package com.kingdee.eas.lifetime.util.kdcontrolutils.threadDialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.eas.EDxbangUtil.kdcontrolutils.threadDialog.inface.EDthreadAdapterInface;
import com.kingdee.eas.util.client.ExceptionHandler;

/**
 * 
 * 
 * <pre>
 * EDthreadDialog dialog = new EDthreadDialog((Frame) SwingUtilities.getWindowAncestor(this), &quot;title&quot;);
 * dialog.setThreadAdapter(new EDthreadAdapterInface() {
 * 	public Object execute() throws Exception {
 * 		for (int i = 0; i &lt; 500000; i++) {
 * 			System.out.println(i);
 * 		}
 * 		return null;
 * 	}
 * 
 * 	public void finish(Object obj) throws Exception {
 * 		System.out.println(&quot;success!&quot;);
 * 	}
 * });
 * dialog.show();
 * </pre>
 * 
 * @author lifeTime
 */
public class EDthreadDialog extends KDDialog {

	private static final long serialVersionUID = 1L;
	private EDthreadAdapterInface threadAdapter;
	private static final Color bottomBgColor = new Color(230, 230, 230);

	public EDthreadDialog(Frame frame, String title) {
		super(frame, title, true);
		threadAdapter = null;
	}

	public EDthreadDialog(Dialog dialog, String title) {
		super(dialog, title, true);
		threadAdapter = null;
	}

	public void setThreadAdapter(EDthreadAdapterInface threadAdapter) {
		this.threadAdapter = threadAdapter;
	}

	protected void dialogInit() {
		super.dialogInit();
		setResizable(false);
		setDefaultCloseOperation(0);
		setLocationRelativeTo(null);
		JPanel contentPane = (JPanel) getContentPane();
		contentPane.setLayout(null);
		Dimension bgPanelDimension = new Dimension(363, 96);
		contentPane.setPreferredSize(new Dimension(bgPanelDimension.width, bgPanelDimension.height + 42));
		contentPane.setBackground(new Color(0xffffff));
		JPanel pnlBottom = new JPanel();
		pnlBottom.setLayout(null);
		pnlBottom.setBounds(0, bgPanelDimension.height, bgPanelDimension.width, 202);
		contentPane.add(pnlBottom);
		pnlBottom.setBackground(bottomBgColor);
		Graphics2D g2d = (Graphics2D) pnlBottom.getGraphics();
		if (g2d != null) {
			GradientPaint gradient = new GradientPaint(0.0F, 0.0F, new Color(0xffffff), 363F, 96F, new Color(0xb4b4b4));
			g2d.setPaint(gradient);
		}
		KDSeparator sp = new KDSeparator();
		sp.setBounds(0, 0, bgPanelDimension.width, 2);
		pnlBottom.add(sp);
		JLabel text = new JLabel();
		text.setBounds(44, 29, 279, 20);
		KDProgressBar progressBar = new KDProgressBar();
		progressBar.setStringPainted(false);
		progressBar.setIndeterminate(true);
		getContentPane().add(text, null);
		getContentPane().add(progressBar, null);
		progressBar.setBounds(new Rectangle(42, 50, 279, 12));
		pack();
		setLocationRelativeTo(null);
	}

	public void show() {
		Thread thread = new Thread() {
			public void run() {
				try {
					Object obj = threadAdapter.execute();
					threadAdapter.finish(obj);
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							dispose();
						}
					});
				} catch (Exception e) {
					dispose();
					ExceptionHandler.handle(e);
				}
			}
		};
		thread.start();
		setCursor(this, Cursor.getPredefinedCursor(3));
		super.show();
		setCursor(this, Cursor.getPredefinedCursor(0));
	}

	private void setCursor(Component cp, Cursor cursor) {
		cp.setCursor(cursor);
		if (cp instanceof Container) {
			Container cc = (Container) cp;
			int i = 0;
			for (int n = cc.getComponentCount(); i < n; i++) {
				Component curComponent = cc.getComponent(i);
				setCursor(curComponent, cursor);
			}
		}
	}

}
