package com.kingdee.eas.lifetime.util.renderImpl;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import com.kingdee.eas.util.client.EASResource;

/**
 * @author lifeTime
 *
 */
public class ListCellRender extends JLabel implements ListCellRenderer {

	private static final long serialVersionUID = 1L;

	private String iconName;

	private Icon icon;

	public ListCellRender() {
	}

	public ListCellRender(String iconName) {
		this.iconName = iconName;
	}

	public ListCellRender(Icon icon) {
		this.icon = icon;
	}

	public Component getListCellRendererComponent(JList jlist, Object value, int i, boolean isSelected, boolean cellHasFocus) {
		String s = value.toString();
		setText(s);
		setIcon(EASResource.getIcon(getIconName()));
		if (isSelected) {
			setBackground(jlist.getSelectionBackground());
			setForeground(jlist.getSelectionForeground());
		} else {
			setBackground(jlist.getBackground());
			setForeground(jlist.getForeground());
		}
		setEnabled(jlist.isEnabled());
		setFont(jlist.getFont());
		setOpaque(true);
		return this;
	}

	public String getIconName() {
		return iconName;
	}

	public void setIconName(String iconName) {
		this.iconName = iconName;
	}

	public Icon getIcon() {
		return icon;
	}

	public void setIcon(Icon icon) {
		this.icon = icon;
	}

}
