=begin
#---------------------------------------------------------------------------------------------------------
#*********************************************************************************************************
# Copyright © 2013 Fredo6 - Designed and written August 2011 by Fredo6
#
# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Description	:  Generic top loader for LibFredo6-compliant scripts.
#
# This file does checking on the environment for correct installation of LibFredo6 and the script itself
#*********************************************************************************************************
#---------------------------------------------------------------------------------------------------------
=end

require 'sketchup.rb'
require 'extensions.rb'

module Fredo6
f6__file__ = __FILE__.gsub(/\\/, '/')
f6__sudir = File.dirname(f6__file__)
f6__base = File.basename(f6__file__, ".rb")

#Check if LibFredo6 is present and correctly installed
if !FileTest.exist?(File.join(f6__sudir, "Fredo6_!LibFredo6.rb")) || (!FileTest.directory?(File.join(f6__sudir, "Fredo6_!LibFredo6")) && Dir[File.join(f6__sudir, "Fredo6_!LibFredo6_??/")].empty?)
	UI.messagebox "You must install LibFredo6 version 5.2 or higher to run #{f6__base}"
	
#Check if the script itself is correctly installed	
elsif !FileTest.directory?(File.join(f6__sudir, f6__base)) && Dir[File.join(File.dirname(f6__file__), "#{f6__base}_??/")].empty?
	UI.messagebox "Installation of #{f6__base} is probably incorrect. Subfolder is missing"
	
#Loading for 'on-the-fly' new installation, via PluginStore or EWH, when Sketchup is already started and LibFredo6 loaded.
#The load will only take place if the script was not already present
elsif defined?(LibFredo6)
	Traductor::Plugin.load_plugin_from_top_rb f6__file__
end	

#Statement for EWH compatibility
begin ; SketchupExtension.new "toto", "toto.rb" ; rescue ; end

end	#module Fredo6
