/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCAnalyzerHeadLess;
import java.util.Properties;
import java.util.StringTokenizer;

public class AELauncher {
    static final String cfgFile = "gca.cfg";
    static final String usage = "Usage : InputFiles -f OutputHTMLFile -t [I|S|X]\n-InputFiles: input file selection set -- a list of filesystem paths identifying the input files selected by the user, with paths delimited by the value of the Java System property  path.separator.\n-OutputHTMLFile: guaranteed not to be an existing file\nI: IBM verbosegc trace(default)\nS: Solaris and HP verbosegc trace\nX:HP Xverosegc trace";

    public static void main(String[] args) {
        String fileType = "-I";
        if (args.length > 4) {
            if (args[3].equalsIgnoreCase("-t")) {
                if (args[4].equalsIgnoreCase("I")) {
                    fileType = "-I";
                } else if (args[4].equalsIgnoreCase("S")) {
                    fileType = "-S";
                } else if (args[4].equalsIgnoreCase("X")) {
                    fileType = "-X";
                }
            }
            if (!args[1].equalsIgnoreCase("-f")) {
                System.out.println(usage);
                return;
            }
        }
        if (args.length < 3) {
            System.out.println(usage);
            return;
        }
        String separator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(args[0], separator);
        int numberOfFiles = st.countTokens();
        String[] inputFiles = new String[numberOfFiles];
        int i = 0;
        while (i < numberOfFiles && st.hasMoreTokens()) {
            inputFiles[i] = st.nextToken();
            ++i;
        }
        Properties p = new Properties();
        p.setProperty("FileType", fileType);
        GCAnalyzerHeadLess hl = new GCAnalyzerHeadLess(args[2]);
        hl.readConfiguration();
        hl.threadAnalysis(inputFiles, p, args[2]);
    }
}

