/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.Configuration;
import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ChartEngine {
    public static final String COPYRIGHT = "IBM Pattern Modeling and Analysis Tool for Java Garbage Collector by Jinwoo Hwang (C) Copyright IBM Corp. 2004-2012 All Rights Reserved";
    public float ratioX;
    public float ratioY;
    public float ratioY2;
    public boolean debugPaint = false;
    int seq = 0;
    public Graphics graphics = null;
    BufferedImage bi;
    boolean headless;
    String prefix;
    JPanel jp;
    Configuration cfg;
    boolean test = true;
    Color fg3D = Color.lightGray;
    FontMetrics fm;
    long yw = 0L;
    long yb = 0L;
    long yb2 = 0L;
    long yw2 = 0L;
    long oldyw = 0L;
    long oldyw2 = 0L;
    long oldyb = 0L;
    long oldyb2 = 0L;
    long maxY;
    long maxY2;
    boolean debug = false;
    GCAnalyzer gca;
    int start;
    int end;
    public boolean zoomIn;
    public boolean zoomOut;
    public boolean zoomCenter;
    public boolean select;
    public boolean zoomInY;
    public boolean zoomOutY;
    public boolean precisionZoom = false;
    public int precisionZoomX1 = -1;
    public int precisionZoomX2 = -1;
    public int precisionZoomY1 = -1;
    public int precisionZoomY2 = -1;
    static final BasicStroke stroke = new BasicStroke(1.0f);
    static final float[] dash1 = new float[]{2.0f};
    static final float[] dash2 = new float[]{4.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 2.0f, dash1, 0.0f);
    static final BasicStroke dashed2 = new BasicStroke(1.0f, 0, 0, 2.0f, dash2, 0.0f);
    int x = 50;
    int y = 50;
    static final int XFACTOR = 60;
    static final int minZoom = 5;
    int leftMargin = 100;
    int rightMargin = 100;
    static final int bottomMargin = 50;
    static final int topMargin = 20;
    GCInfo gi;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("MMM d");
    static SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final Color blue = Color.blue;
    static final Color pink = Color.pink;
    static final Color green = Color.green;
    static final Color cyan = Color.cyan;
    static final Color magenta = Color.magenta;
    static final Color orange = Color.orange;
    static final Color yellow = Color.yellow;
    static final Color gray = Color.gray;
    long zoom;
    float zoomY;
    long oldZoom;
    float oldZoomY;
    int center = -1;
    public volatile long lx;
    volatile long rx;
    long lx_org;
    long rx_org;
    int il;
    int ir;
    boolean noMoreZoomIn = false;
    boolean noMoreZoomOut = false;
    public Dimension dimension;
    boolean free = false;
    boolean freeN = false;
    boolean freeNBefore = false;
    boolean freeBefore = false;
    boolean total = false;
    boolean totalN = false;
    boolean totalNBefore = false;
    boolean totalBefore = false;
    boolean freed = false;
    boolean requested = false;
    boolean since = false;
    boolean compact = false;
    boolean mark = false;
    boolean sweep = false;
    boolean completed = false;
    boolean gccompleted = false;
    boolean used = true;
    boolean overhead = false;
    boolean oome = true;
    boolean restart = true;
    boolean usedBefore = false;
    boolean usedN = false;
    boolean usedNBefore = false;
    boolean[] isShortage;
    boolean usedPBefore = false;
    boolean usedPAfter = false;
    boolean freePBefore = false;
    boolean freePAfter = false;
    boolean totalP = false;
    boolean maxPerm = false;
    boolean maxTen = false;
    boolean freeSOA = false;
    boolean freeLOA = false;
    boolean totalSOA = false;
    boolean totalLOA = false;
    boolean totalBeforeSOA = false;
    boolean totalBeforeLOA = false;
    boolean freeBeforeLOA = false;
    boolean freeBeforeSOA = false;
    public volatile long travelY = 0L;

    public synchronized void addLx(long v) {
        this.lx += v;
    }

    public synchronized void addRx(long v) {
        this.rx += v;
    }

    public synchronized void updateLx(long v) {
        this.lx = v;
    }

    public synchronized void updateRx(long v) {
        this.rx = v;
    }

    public synchronized void updateYw(long v) {
        this.yw = v;
    }

    public synchronized void updateYb(long v) {
        this.yb = v;
    }

    public synchronized void updateYw2(long v) {
        this.yw2 = v;
    }

    public synchronized void updateYb2(long v) {
        this.yb2 = v;
    }

    public ChartEngine() {
    }

    public void resetZoom() {
        block112: {
            int i;
            this.il = this.start;
            this.ir = this.end;
            this.lx = this.gi.timestamp[this.il];
            this.rx = this.gi.timestamp[this.ir];
            this.zoom = this.oldZoom = this.rx - this.lx;
            this.oldZoomY = 1.0f;
            this.zoomY = 1.0f;
            this.yw2 = 0L;
            this.yw = 0L;
            if (this.debug) {
                System.out.println("Auto Y");
            }
            if (this.free) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.free[i] > this.yw) {
                        this.yw = this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.freeBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.freePAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.freePBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.maxPerm) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangePerm[i] > this.yw) {
                        this.yw = this.gi.rangePerm[i];
                    }
                    ++i;
                }
            }
            if (this.maxTen) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangeTenured[i] > this.yw) {
                        this.yw = this.gi.rangeTenured[i];
                    }
                    ++i;
                }
            }
            if (this.used) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] - this.gi.free[i] > this.yw) {
                        this.yw = this.gi.total[i] - this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.usedN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] - this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i] - this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.usedBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.total) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] > this.yw) {
                        this.yw = this.gi.total[i];
                    }
                    ++i;
                }
            }
            if (this.totalBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i];
                    }
                    ++i;
                }
            }
            if (this.totalP) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freed[i] > this.yw) {
                        this.yw = this.gi.freed[i];
                    }
                    ++i;
                }
            }
            if (this.requested) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.af[i] > this.yw) {
                        this.yw = this.gi.af[i];
                    }
                    ++i;
                }
            }
            if (this.freeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeSOA[i] > this.yw) {
                        this.yw = this.gi.freeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeLOA[i] > this.yw) {
                        this.yw = this.gi.freeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalSOA[i] > this.yw) {
                        this.yw = this.gi.totalSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalLOA[i] > this.yw) {
                        this.yw = this.gi.totalLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.since) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.since[i] > this.yw2) {
                        this.yw2 = this.gi.since[i];
                    }
                    ++i;
                }
            }
            if (this.completed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.completed[i] > this.yw2) {
                        this.yw2 = this.gi.completed[i];
                    }
                    ++i;
                }
            }
            if (this.mark) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.mark[i] > this.yw2) {
                        this.yw2 = this.gi.mark[i];
                    }
                    ++i;
                }
            }
            if (this.sweep) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.sweep[i] > this.yw2) {
                        this.yw2 = this.gi.sweep[i];
                    }
                    ++i;
                }
            }
            if (this.compact) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.compact[i] > this.yw2) {
                        this.yw2 = this.gi.compact[i];
                    }
                    ++i;
                }
            }
            if (this.gccompleted) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.gccompleted[i] > this.yw2) {
                        this.yw2 = this.gi.gccompleted[i];
                    }
                    ++i;
                }
            }
            if (!this.overhead) break block112;
            if (this.gi.type == 2) {
                int i2 = this.il;
                while (i2 <= this.ir) {
                    long afOverhead = this.getOverhead(i2);
                    if (afOverhead > this.yw2) {
                        this.yw2 = afOverhead;
                    }
                    ++i2;
                }
            } else {
                int i3 = this.il;
                while (i3 <= this.ir) {
                    long afOverhead;
                    if (!this.isStartPoint(i3) && (afOverhead = (long)this.getOverhead(i3)) > this.yw2) {
                        this.yw2 = afOverhead;
                    }
                    ++i3;
                }
            }
        }
    }

    public ChartEngine(GCInfo gi, Configuration cfg, int start, int end, boolean headless, String prefix, JPanel jp, BufferedImage bi) {
        this.bi = bi;
        this.gi = gi;
        this.cfg = cfg;
        this.headless = headless;
        this.prefix = prefix;
        this.jp = jp;
        this.start = start;
        this.gi = gi;
        this.gca = this.gca;
        this.il = start;
        if (gi.timestamp[start] > gi.timestamp[end]) {
            long prev = gi.timestamp[0];
            int i = 0;
            while (i < gi.timestamp.length) {
                if (prev > gi.timestamp[i]) {
                    if (i > 0) {
                        end = i - 1;
                        break;
                    }
                    end = 0;
                    break;
                }
                prev = gi.timestamp[i];
                ++i;
            }
        }
        this.end = end;
        this.ir = end;
        this.lx = gi.timestamp[this.il];
        this.rx = gi.timestamp[this.ir];
        this.zoom = this.oldZoom = this.rx - this.lx;
        this.oldZoomY = 1.0f;
        this.zoomY = 1.0f;
        if (gi.outOfHeapSpace != null) {
            this.isShortage = new boolean[gi.free.length];
            int i = 0;
            while (i < gi.outOfHeapSpace.length) {
                if (gi.outOfHeapSpace[i] >= 0) {
                    this.isShortage[gi.outOfHeapSpace[i]] = true;
                }
                ++i;
            }
        }
        this.yw = 0L;
        this.yw2 = 0L;
        int i = this.il;
        while (i <= this.ir) {
            if (gi.free != null && gi.free[i] > this.yw) {
                this.yw = gi.free[i];
            }
            if (gi.freeBefore != null && gi.freeBefore[i] > this.yw) {
                this.yw = gi.freeBefore[i];
            }
            if (gi.freeNurseryBefore != null && gi.freeNurseryBefore[i] > this.yw) {
                this.yw = gi.freeNurseryBefore[i];
            }
            if (gi.freeNursery != null && gi.freeNursery[i] > this.yw) {
                this.yw = gi.freeNursery[i];
            }
            if (gi.total != null && gi.free != null && gi.total[i] - gi.free[i] > this.yw) {
                this.yw = gi.total[i] - gi.free[i];
            }
            if (gi.totalNursery != null && gi.freeNursery != null && gi.totalNursery[i] - gi.freeNursery[i] > this.yw) {
                this.yw = gi.totalNursery[i] - gi.freeNursery[i];
            }
            if (gi.totalBefore != null && gi.freeBefore != null && gi.totalBefore[i] - gi.freeBefore[i] > this.yw) {
                this.yw = gi.totalBefore[i] - gi.freeBefore[i];
            }
            if (gi.totalNurseryBefore != null && gi.freeNurseryBefore != null && gi.totalNurseryBefore[i] - gi.freeNurseryBefore[i] > this.yw) {
                this.yw = gi.totalNurseryBefore[i] - gi.freeNurseryBefore[i];
            }
            if (gi.total != null && gi.total[i] > this.yw) {
                this.yw = gi.total[i];
            }
            if (gi.totalBefore != null && gi.totalBefore[i] > this.yw) {
                this.yw = gi.totalBefore[i];
            }
            if (gi.totalNurseryBefore != null && gi.totalNurseryBefore[i] > this.yw) {
                this.yw = gi.totalNurseryBefore[i];
            }
            if (gi.totalNursery != null && gi.totalNursery[i] > this.yw) {
                this.yw = gi.totalNursery[i];
            }
            if (gi.freed != null && gi.freed[i] > this.yw) {
                this.yw = gi.freed[i];
            }
            if (gi.freeSOA != null && gi.freeSOA[i] > this.yw) {
                this.yw = gi.freeSOA[i];
            }
            if (gi.freeLOA != null && gi.freeLOA[i] > this.yw) {
                this.yw = gi.freeLOA[i];
            }
            if (gi.freeBeforeSOA != null && gi.freeBeforeSOA[i] > this.yw) {
                this.yw = gi.freeBeforeSOA[i];
            }
            if (gi.freeBeforeLOA != null && gi.freeBeforeLOA[i] > this.yw) {
                this.yw = gi.freeBeforeLOA[i];
            }
            if (gi.totalSOA != null && gi.totalSOA[i] > this.yw) {
                this.yw = gi.totalSOA[i];
            }
            if (gi.totalLOA != null && gi.totalLOA[i] > this.yw) {
                this.yw = gi.totalLOA[i];
            }
            if (gi.totalBeforeSOA != null && gi.totalBeforeSOA[i] > this.yw) {
                this.yw = gi.totalBeforeSOA[i];
            }
            if (gi.totalBeforeLOA != null && gi.totalBeforeLOA[i] > this.yw) {
                this.yw = gi.totalBeforeLOA[i];
            }
            if (gi.af != null && gi.af[i] > this.yw) {
                this.yw = gi.af[i];
            }
            if (gi.since != null && gi.since[i] > this.yw2) {
                this.yw2 = gi.since[i];
            }
            if (gi.completed != null && gi.completed[i] > this.yw2) {
                this.yw2 = gi.completed[i];
            }
            if (gi.mark != null && gi.mark[i] > this.yw2) {
                this.yw2 = gi.mark[i];
            }
            if (gi.sweep != null && gi.sweep[i] > this.yw2) {
                this.yw2 = gi.sweep[i];
            }
            if (gi.compact != null && gi.compact[i] > this.yw2) {
                this.yw2 = gi.compact[i];
            }
            if (gi.gccompleted != null && gi.gccompleted[i] > this.yw2) {
                this.yw2 = gi.gccompleted[i];
            }
            if (!this.isStartPoint(i)) {
                int afOverhead = gi.type == 2 ? (gi.since[i] + gi.gccompleted[i] == 0L ? 0 : (gi.since[i] == 0L ? 0 : Math.round((float)gi.gccompleted[i] * 100.0f / (float)(gi.since[i] + gi.gccompleted[i])))) : Math.round(100.0f * (float)this.getCompleted(i) / (float)(this.getSince(i) + this.getCompleted(i)));
                if ((long)afOverhead > this.yw2) {
                    this.yw2 = afOverhead;
                }
            }
            ++i;
        }
        this.maxY = this.yw;
        this.maxY2 = this.yw2;
    }

    public String drawChart(Graphics graphics) {
        int y2;
        int y1;
        int x2;
        int t;
        long pixel;
        float r1;
        Graphics2D g;
        this.graphics = graphics;
        this.dimension = this.headless ? new Dimension(this.cfg.width, this.cfg.height) : this.jp.getSize();
        if (!this.headless) {
            this.bi = new BufferedImage(this.dimension.width, this.dimension.height, 2);
            g = this.bi.createGraphics();
        } else {
            g = (Graphics2D)graphics;
        }
        if (this.cfg.font != null) {
            g.setFont(this.cfg.font);
        }
        this.fm = g.getFontMetrics();
        g.setColor(fg);
        if (this.zoom <= 0L) {
            this.zoom = 1L;
        }
        if (this.zoom != this.oldZoom) {
            float ratio = 0.5f;
            long mx = this.lx + (long)((float)(this.rx - this.lx) * ratio);
            this.lx = mx - this.zoom / 2L;
            this.rx = mx + this.zoom / 2L;
            if (this.lx < this.gi.timestamp[this.start]) {
                this.il = 0;
            }
            if (this.rx > this.gi.timestamp[this.end]) {
                this.ir = this.gi.free.length - 1;
            }
            int i = this.start;
            while (i <= this.end) {
                if (this.gi.timestamp[i] >= this.rx) {
                    this.ir = i;
                    break;
                }
                ++i;
            }
            i = this.end;
            while (i >= this.start) {
                if (this.gi.timestamp[i] <= this.lx) {
                    this.il = i;
                    break;
                }
                --i;
            }
            this.oldZoom = this.zoom;
        }
        if (this.travelY != 0L) {
            float total = this.dimension.height - 20 - 50;
            r1 = (float)this.travelY / total;
            int delta = (int)((float)(this.yw - this.yb) * r1);
            int delta2 = (int)((float)(this.yw2 - this.yb2) * r1);
            this.yw += (long)delta;
            this.yb += (long)delta;
            this.yw2 += (long)delta2;
            this.yb2 += (long)delta2;
            this.travelY = 0L;
        }
        if (this.precisionZoom) {
            if (this.precisionZoomX1 >= 0 && this.precisionZoomX2 >= 0) {
                if (this.precisionZoomX1 > this.precisionZoomX2) {
                    this.il = this.precisionZoomX2;
                    this.ir = this.precisionZoomX1;
                } else {
                    this.il = this.precisionZoomX1;
                    this.ir = this.precisionZoomX2;
                }
                this.lx = this.gi.timestamp[this.il];
                this.rx = this.gi.timestamp[this.ir];
                this.zoom = this.oldZoom = this.rx - this.lx;
            }
            if (this.precisionZoomY1 > 0 && this.precisionZoomY2 > 0) {
                float total = this.dimension.height - 20 - 50;
                r1 = (float)(this.precisionZoomY1 - 20) / total;
                float r2 = (float)(this.precisionZoomY2 - 20) / total;
                if (r1 < r2) {
                    this.yw = (long)((float)this.yw - (float)(this.yw - this.yb) * r1);
                    this.yb = (long)((float)this.yb + (float)(this.yw - this.yb) * (1.0f - r2));
                    this.yw2 = (long)((float)this.yw2 - (float)(this.yw2 - this.yb2) * r1);
                    this.yb2 = (long)((float)this.yb2 + (float)(this.yw2 - this.yb2) * (1.0f - r2));
                } else {
                    this.yw = (long)((float)this.yw - (float)(this.yw - this.yb) * r2);
                    this.yb = (long)((float)this.yb + (float)(this.yw - this.yb) * (1.0f - r1));
                    this.yw2 = (long)((float)this.yw2 - (float)(this.yw2 - this.yb2) * r2);
                    this.yb2 = (long)((float)this.yb2 + (float)(this.yw2 - this.yb2) * (1.0f - r1));
                }
            }
            this.precisionZoom = false;
        }
        long xw = this.rx - this.lx;
        if (this.cfg.autoY) {
            int i;
            this.yb2 = 0L;
            this.yb = 0L;
            this.yw2 = 0L;
            this.yw = 0L;
            if (this.debug) {
                System.out.println("Auto Y");
            }
            if (this.free) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.free[i] > this.yw) {
                        this.yw = this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.freeBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.freePAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.freePBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.maxPerm) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangePerm[i] > this.yw) {
                        this.yw = this.gi.rangePerm[i];
                    }
                    ++i;
                }
            }
            if (this.maxTen) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangeTenured[i] > this.yw) {
                        this.yw = this.gi.rangeTenured[i];
                    }
                    ++i;
                }
            }
            if (this.used) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] - this.gi.free[i] > this.yw) {
                        this.yw = this.gi.total[i] - this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.usedN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] - this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i] - this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.usedBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.total) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] > this.yw) {
                        this.yw = this.gi.total[i];
                    }
                    ++i;
                }
            }
            if (this.totalBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i];
                    }
                    ++i;
                }
            }
            if (this.totalP) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freed[i] > this.yw) {
                        this.yw = this.gi.freed[i];
                    }
                    ++i;
                }
            }
            if (this.requested) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.af[i] > this.yw) {
                        this.yw = this.gi.af[i];
                    }
                    ++i;
                }
            }
            if (this.freeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeSOA[i] > this.yw) {
                        this.yw = this.gi.freeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeLOA[i] > this.yw) {
                        this.yw = this.gi.freeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalSOA[i] > this.yw) {
                        this.yw = this.gi.totalSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalLOA[i] > this.yw) {
                        this.yw = this.gi.totalLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.since) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.since[i] > this.yw2) {
                        this.yw2 = this.gi.since[i];
                    }
                    ++i;
                }
            }
            if (this.completed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.completed[i] > this.yw2) {
                        this.yw2 = this.gi.completed[i];
                    }
                    ++i;
                }
            }
            if (this.mark) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.mark[i] > this.yw2) {
                        this.yw2 = this.gi.mark[i];
                    }
                    ++i;
                }
            }
            if (this.sweep) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.sweep[i] > this.yw2) {
                        this.yw2 = this.gi.sweep[i];
                    }
                    ++i;
                }
            }
            if (this.compact) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.compact[i] > this.yw2) {
                        this.yw2 = this.gi.compact[i];
                    }
                    ++i;
                }
            }
            if (this.gccompleted) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.gccompleted[i] > this.yw2) {
                        this.yw2 = this.gi.gccompleted[i];
                    }
                    ++i;
                }
            }
            if (this.overhead) {
                if (this.gi.type == 2) {
                    i = this.il;
                    while (i <= this.ir) {
                        long afOverhead = this.getOverhead(i);
                        if (afOverhead > this.yw2) {
                            this.yw2 = afOverhead;
                        }
                        ++i;
                    }
                } else {
                    i = this.il;
                    while (i <= this.ir) {
                        long afOverhead;
                        if (!this.isStartPoint(i) && (afOverhead = (long)this.getOverhead(i)) > this.yw2) {
                            this.yw2 = afOverhead;
                        }
                        ++i;
                    }
                }
            }
        } else if (this.zoomY != this.oldZoomY) {
            long diff;
            if (this.debug) {
                System.out.println("Changed zoomY=" + this.zoomY + " oldZoomY=" + this.oldZoomY);
            }
            if (this.debug) {
                System.out.println("yw=" + this.yw + " yw2=" + this.yw2);
            }
            this.oldyw = this.yw;
            this.oldyw2 = this.yw2;
            this.oldyb = this.yb;
            this.oldyb2 = this.yb2;
            if (this.zoomY >= this.oldZoomY) {
                diff = (long)((float)((this.yw - this.yb) / 2L) / (this.zoomY / this.oldZoomY));
                if (diff > 0L) {
                    this.yw -= diff;
                    this.yb += diff;
                }
                if ((diff = (long)((float)((this.yw2 - this.yb2) / 2L) / (this.zoomY / this.oldZoomY))) > 0L) {
                    this.yw2 -= diff;
                    this.yb2 += diff;
                }
            } else {
                diff = (long)((float)(this.yw - this.yb) * (this.zoomY / this.oldZoomY));
                if (diff > 0L) {
                    this.yw += diff;
                    this.yb -= diff;
                } else {
                    ++this.yw;
                    --this.yb;
                }
                if (this.yb < 0L) {
                    this.yb = 0L;
                }
                if ((diff = (long)((float)(this.yw2 - this.yb2) * (this.zoomY / this.oldZoomY))) > 0L) {
                    this.yw2 += diff;
                    this.yb2 -= diff;
                } else {
                    ++this.yw2;
                    --this.yb2;
                }
                if (this.yb2 < 0L) {
                    this.yb2 = 0L;
                }
            }
            if (this.yb == 0L) {
                this.yb = this.oldyb;
            }
            if (this.yb2 == 0L) {
                this.yb2 = this.oldyb2;
            }
            if (this.yw == 0L) {
                this.yw = this.oldyw;
            }
            this.yw2 = (long)((float)this.yw2 / (this.zoomY / this.oldZoomY));
            if (this.yw2 == 0L) {
                this.yw2 = this.oldyw2;
            }
            if (this.debug) {
                System.out.println("changed yw=" + this.yw + " yw2=" + this.yw2);
            }
            this.oldZoomY = this.zoomY;
        }
        if (this.debug) {
            System.out.println("yw=" + this.yw + " yw2=" + this.yw2);
        }
        this.leftMargin = this.fm.stringWidth(numberFormatter.format(this.yw)) + 30;
        this.rightMargin = this.fm.stringWidth(numberFormatter.format(this.yw2)) + 40;
        this.ratioX = ((float)this.dimension.width - (float)this.leftMargin - (float)this.rightMargin) / (float)xw;
        this.ratioY = ((float)this.dimension.height - 70.0f) / (float)(this.yw - this.yb);
        this.ratioY2 = ((float)this.dimension.height - 70.0f) / (float)(this.yw2 - this.yb2);
        if (!this.headless) {
            g.setBackground(new Color(204, 204, 204));
            g.clearRect(0, 0, this.dimension.width, this.dimension.height);
            g.setBackground(Color.white);
            g.clearRect(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin, this.dimension.height - 70);
        }
        g.setColor(this.fg3D);
        g.draw3DRect(this.leftMargin - 4, 16, this.dimension.width - this.leftMargin - this.rightMargin + 7, this.dimension.height - 70 + 7, true);
        g.draw3DRect(this.leftMargin - 1, 19, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 70 + 1, false);
        g.setColor(fg);
        g.drawString(dateFormatter.format(new Date(this.lx)), this.leftMargin - 15, this.dimension.height - this.y + 40);
        g.drawString(timeFormatter.format(new Date(this.lx)), this.leftMargin - 23, this.dimension.height - this.y + 20);
        g.drawString(dateFormatter.format(new Date(this.rx)), this.dimension.width - this.rightMargin - 15, this.dimension.height - this.y + 40);
        g.drawString(timeFormatter.format(new Date(this.rx)), this.dimension.width - this.rightMargin - 23, this.dimension.height - this.y + 20);
        int numberOfxt = (this.dimension.width - this.leftMargin - this.rightMargin) / 60;
        if (numberOfxt > 1) {
            long delta = (this.rx - this.lx) / (long)numberOfxt;
            int i = 1;
            while (i < numberOfxt) {
                g.setColor(fg);
                g.drawString(dateFormatter.format(new Date(delta * (long)i + this.lx)), (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin - 15, this.dimension.height - this.y + 40);
                g.drawString(timeFormatter.format(new Date(delta * (long)i + this.lx)), (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin - 23, this.dimension.height - this.y + 20);
                g.setColor(this.fg3D);
                g.setStroke(dashed);
                g.drawLine((int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin, 20, (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin, this.dimension.height - 20);
                ++i;
            }
        }
        long range = this.yw - this.yb;
        float numberOfGrid = 10.0f;
        long roughtNotchRange = (long)Math.ceil((float)range / numberOfGrid);
        long notchRange = 1L;
        long log = (long)Math.log10(roughtNotchRange);
        if (roughtNotchRange > 0L) {
            notchRange = (long)Math.pow(10.0, log);
        }
        long firstNotch = 0L;
        if (this.yb > notchRange) {
            firstNotch = this.yb / notchRange * notchRange;
        }
        long notch = firstNotch;
        int counter = 0;
        while (notch <= this.yw) {
            notch += notchRange;
            ++counter;
        }
        if (counter != 0 && (pixel = (long)((this.dimension.height - 50) / counter)) < 32L) {
            firstNotch = this.yb / (notchRange *= 10L) * notchRange;
        }
        notch = firstNotch;
        g.setColor(fg);
        g.drawString("bytes", 20, 15);
        while (notch <= this.yw) {
            if (notch >= this.yb) {
                t = this.dimension.height - (int)((float)(notch - this.yb) * this.ratioY) - 50;
                g.setColor(this.fg3D);
                g.setStroke(dashed);
                g.drawLine(this.leftMargin, t, this.dimension.width - this.rightMargin, t);
                g.setColor(fg);
                g.drawString(numberFormatter.format(notch), 10, t + 5);
            }
            notch += notchRange;
        }
        range = this.yw2 - this.yb2;
        roughtNotchRange = (long)Math.ceil((float)range / numberOfGrid);
        notchRange = 1L;
        log = (long)Math.log10(roughtNotchRange);
        if (roughtNotchRange > 0L) {
            notchRange = (long)Math.pow(10.0, log);
        }
        firstNotch = 0L;
        if (this.yb2 > notchRange) {
            firstNotch = this.yb2 / notchRange * notchRange;
        }
        notch = firstNotch;
        counter = 0;
        while (notch <= this.yw2) {
            notch += notchRange;
            ++counter;
        }
        if (counter != 0 && (pixel = (long)((this.dimension.height - 50) / counter)) < 32L) {
            firstNotch = this.yb2 / (notchRange *= 10L) * notchRange;
        }
        notch = firstNotch;
        g.setColor(fg);
        if (this.overhead) {
            g.drawString("ms/%", 10 + this.dimension.width - this.rightMargin, 15);
        } else {
            g.drawString("ms", 10 + this.dimension.width - this.rightMargin, 15);
        }
        while (notch <= this.yw2) {
            if (notch >= this.yb2) {
                t = this.dimension.height - (int)((float)(notch - this.yb2) * this.ratioY2) - 50;
                g.setColor(this.fg3D);
                g.setStroke(dashed2);
                g.drawLine(this.leftMargin, t, this.dimension.width - this.rightMargin, t);
                g.setColor(fg);
                g.drawString(numberFormatter.format(notch), 10 + this.dimension.width - this.rightMargin, t + 5);
            }
            notch += notchRange;
        }
        g.setClip(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 20 - 50 + 1);
        if (this.ir > this.il) {
            float diffIndex = this.ir - this.il;
            x2 = (int)((float)(this.gi.timestamp[this.ir - 1] - this.lx) * this.ratioX) + this.leftMargin;
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            float diffPixel = x2 - x1;
            if (diffIndex / diffPixel < 1.0f) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setStroke(stroke);
        if (this.free) {
            g.setStroke(stroke);
            g.setColor(this.cfg.free);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.free[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.free[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeSOA) {
            g.setStroke(stroke);
            g.setColor(this.cfg.freeSOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeSOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeSOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeLOA) {
            g.setStroke(stroke);
            g.setColor(this.cfg.freeLOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeLOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeLOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeBefore) {
            g.setColor(this.cfg.freeBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeBeforeSOA) {
            g.setColor(this.cfg.freeBeforeSOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeBeforeSOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeBeforeSOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeBeforeLOA) {
            g.setColor(this.cfg.freeBeforeLOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeBeforeLOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeBeforeLOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeN) {
            g.setStroke(stroke);
            g.setColor(this.cfg.freeN);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeNursery[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeNursery[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freePAfter) {
            g.setStroke(stroke);
            g.setColor(this.cfg.freePAfter);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freePerm[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freePerm[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freePBefore) {
            g.setColor(this.cfg.freePBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freePermBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freePermBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freeNBefore) {
            g.setColor(this.cfg.freeNBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freeNurseryBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freeNurseryBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.used) {
            g.setStroke(stroke);
            g.setColor(this.cfg.used);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.total[this.il] - this.gi.free[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.total[i] - this.gi.free[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                x1 = x2;
                y1 = y2;
                ++i;
            }
        }
        if (this.usedN) {
            g.setStroke(stroke);
            g.setColor(this.cfg.usedN);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalNursery[this.il] - this.gi.freeNursery[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalNursery[i] - this.gi.freeNursery[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.usedPAfter) {
            g.setStroke(stroke);
            g.setColor(this.cfg.usedPAfter);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[this.il] - this.gi.freePerm[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.usedBefore) {
            g.setStroke(stroke);
            g.setColor(this.cfg.usedBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalBefore[this.il] - this.gi.freeBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalBefore[i] - this.gi.freeBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.usedNBefore) {
            g.setColor(this.cfg.usedNBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.il] - this.gi.freeNurseryBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.usedPBefore) {
            g.setColor(this.cfg.usedPBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[this.il] - this.gi.freePermBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.total) {
            g.setStroke(stroke);
            g.setColor(this.cfg.total);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.total[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.total[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalSOA) {
            g.setStroke(stroke);
            g.setColor(this.cfg.totalSOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalSOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalSOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalLOA) {
            g.setStroke(stroke);
            g.setColor(this.cfg.totalLOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalLOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalLOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.maxTen) {
            g.setStroke(stroke);
            g.setColor(this.cfg.maxTen);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.rangeTenured[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.rangeTenured[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.maxPerm) {
            g.setStroke(stroke);
            g.setColor(this.cfg.maxPerm);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.rangePerm[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.rangePerm[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalBefore) {
            g.setColor(this.cfg.totalBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalBeforeSOA) {
            g.setColor(this.cfg.totalBeforeSOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalBeforeSOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalBeforeSOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalBeforeLOA) {
            g.setColor(this.cfg.totalBeforeLOA);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalBeforeLOA[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalBeforeLOA[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalN) {
            g.setStroke(stroke);
            g.setColor(this.cfg.totalN);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalNursery[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalNursery[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalNBefore) {
            g.setColor(this.cfg.totalNBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.totalP) {
            g.setColor(this.cfg.totalPBefore);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.freed) {
            g.setStroke(stroke);
            g.setColor(this.cfg.freed);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.freed[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.freed[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.requested) {
            g.setStroke(stroke);
            g.setColor(this.cfg.requested);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.af[this.il] - this.yb) * this.ratioY) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.af[i] - this.yb) * this.ratioY) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.compact) {
            g.setStroke(stroke);
            g.setColor(this.cfg.compact);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.compact[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.compact[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.sweep) {
            g.setStroke(stroke);
            g.setColor(this.cfg.sweep);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.sweep[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.sweep[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.mark) {
            g.setStroke(stroke);
            g.setColor(this.cfg.mark);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.mark[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.mark[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.completed) {
            g.setStroke(stroke);
            g.setColor(this.cfg.completed);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.completed[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.completed[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.since) {
            g.setStroke(stroke);
            g.setColor(this.cfg.since);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.since[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.since[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.gccompleted) {
            g.setStroke(stroke);
            g.setColor(this.cfg.gccompleted);
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(this.gi.gccompleted[this.il] - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                y2 = this.dimension.height - (int)((float)(this.gi.gccompleted[i] - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        if (this.overhead) {
            g.setStroke(stroke);
            long afOverhead = this.isStartPoint(this.il) ? 0L : (this.gi.type == 2 ? (long)this.getOverhead(this.il) : (long)Math.round(100.0f * (float)this.getCompleted(this.il) / (float)(this.getSince(this.il) + this.getCompleted(this.il))));
            int x1 = (int)((float)(this.gi.timestamp[this.il] - this.lx) * this.ratioX) + this.leftMargin;
            y1 = this.dimension.height - (int)((float)(afOverhead - this.yb2) * this.ratioY2) - 50;
            int i = this.il + 1;
            while (i <= this.ir) {
                if (i >= this.gi.timestamp.length) break;
                x2 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
                long afOverhead2 = this.isStartPoint(i) ? 0L : (this.gi.type == 2 ? (long)this.getOverhead(i) : (long)Math.round(100.0f * (float)this.getCompleted(i) / (float)(this.getSince(i) + this.getCompleted(i))));
                y2 = this.dimension.height - (int)((float)(afOverhead2 - this.yb2) * this.ratioY2) - 50;
                if (x1 != x2 || y1 != y2) {
                    g.setColor(this.cfg.overhead);
                    g.drawLine(x1, y1, x2, y2);
                    if (this.cfg.terminals) {
                        if (this.isStartPoint(i)) {
                            g.fillRect(x1 - 2, y1 - 2, 4, 4);
                        }
                        if (this.isEndPoint(i + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    if (this.cfg.points && !this.isEndPoint(i + 1)) {
                        g.fillRect(x2 - 2, y2 - 2, 4, 4);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                ++i;
            }
        }
        int i = this.il;
        while (i < this.ir) {
            if (i + 1 == this.ir && this.gi.outOfHeapSpace != null && this.isShortage[i + 1] && this.oome) {
                this.drawOOM((int)((float)(this.gi.timestamp[i + 1] - this.lx) * this.ratioX) + this.leftMargin, g);
                g.setColor(this.cfg.oome);
                g.drawLine((int)((float)(this.gi.timestamp[i + 1] - this.lx) * this.ratioX) + this.leftMargin, 20, (int)((float)(this.gi.timestamp[i + 1] - this.lx) * this.ratioX) + this.leftMargin, this.dimension.height - 50);
            }
            int x1 = (int)((float)(this.gi.timestamp[i] - this.lx) * this.ratioX) + this.leftMargin;
            x2 = (int)((float)(this.gi.timestamp[i + 1] - this.lx) * this.ratioX) + this.leftMargin;
            if (this.gi.ngc[i + 1] < this.gi.ngc[i] && this.restart) {
                this.drawRestart(g, x1);
                g.setColor(this.cfg.restart);
                g.drawLine(x1, 20, x1, this.dimension.height - 50);
            }
            if (this.gi.outOfHeapSpace != null && this.isShortage[i] && this.oome) {
                this.drawOOM(x1, g);
                g.setColor(this.cfg.oome);
                g.drawLine(x1, 20, x1, this.dimension.height - 50);
            }
            ++i;
        }
        g.setClip(null);
        g.setColor(fg);
        if (this.headless) {
            g.drawString(COPYRIGHT, 80, 13);
            String fileName = String.valueOf(this.prefix) + "_" + this.seq + ".png";
            File outputfile = null;
            try {
                outputfile = new File(fileName);
                ++this.seq;
                ImageIO.write((RenderedImage)this.bi, "png", outputfile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return "<img alt=\"" + outputfile.getName() + "\" height=" + this.cfg.height + " src=\"" + outputfile.getName() + "\" width=" + this.cfg.width + ">";
        }
        ((Graphics2D)graphics).drawImage((Image)this.bi, 0, 0, this.jp);
        return null;
    }

    private void drawRestart(Graphics2D g, int x) {
        int size = 6;
        g.setClip(null);
        g.setColor(this.cfg.restart);
        g.setStroke(stroke);
        int[] xPoints = new int[]{x, x - size, x, x + size};
        int[] yPoints = new int[]{20 - size * 2 - 5, 20 - size - 5, 15, 20 - size - 5};
        g.fillPolygon(xPoints, yPoints, xPoints.length);
        g.setClip(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 20 - 50 + 1);
    }

    private void drawOOM(int x, Graphics2D g) {
        int size = 6;
        g.setClip(null);
        g.setColor(this.cfg.oome);
        g.setStroke(stroke);
        int[] xPoints = new int[]{x - size, x, x + size};
        int[] yPoints = new int[]{20 - size * 2 - 5, 15, 20 - size * 2 - 5};
        g.fillPolygon(xPoints, yPoints, xPoints.length);
        g.setClip(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 20 - 50 + 1);
    }

    public int get10(long x) {
        int i = 0;
        while ((x /= 10L) >= 1L) {
            ++i;
        }
        return i;
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    long getCompleted(int idx) {
        if (this.gi.completed[idx] != 0L) {
            return this.gi.completed[idx];
        }
        if (this.gi.gccompleted[idx] == 0L) {
            return 0L;
        }
        int i = idx;
        while (i < this.gi.free.length) {
            if (this.gi.completed[i] != 0L) {
                return this.gi.completed[i];
            }
            ++i;
        }
        return 0L;
    }

    public int getFirstDigit(long x) {
        int i = 0;
        long y = x;
        while ((x /= 10L) >= 1L) {
            y = x;
            ++i;
        }
        return (int)y;
    }

    public Graphics getGraphics() {
        return this.bi.getGraphics();
    }

    public int getOverhead(int idx) {
        if (this.isStartPoint(idx)) {
            return 0;
        }
        if (this.gi.type == 0 && this.gi.naf[idx] == 0) {
            return 0;
        }
        if (this.gi.type == 0) {
            if (this.gi.since[idx] + this.gi.completed[idx] == 0L) {
                return 0;
            }
            return (int)((float)this.gi.completed[idx] * 100.0f / (float)(this.gi.since[idx] + this.gi.completed[idx]));
        }
        if (this.gi.since[idx] + this.gi.gccompleted[idx] == 0L) {
            return 0;
        }
        return (int)((float)this.gi.gccompleted[idx] * 100.0f / (float)(this.gi.since[idx] + this.gi.gccompleted[idx]));
    }

    long getRequested(int idx) {
        if (this.gi.af[idx] != 0L) {
            return this.gi.af[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.gi.af[i] != 0L) {
                return this.gi.af[i];
            }
            --i;
        }
        return 0L;
    }

    public int getSecondDigit(long x) {
        int i = 0;
        long y = x;
        while ((x /= 10L) >= 10L) {
            y = x;
            ++i;
        }
        return (int)y;
    }

    long getSince(int idx) {
        if (this.gi.since[idx] != 0L) {
            return this.gi.since[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.gi.since[i] != 0L && this.gi.af[i] != 0L) {
                return this.gi.since[i];
            }
            --i;
        }
        return 0L;
    }

    boolean isEndPoint(int idx) {
        if (idx >= this.gi.free.length || idx < 0) {
            return false;
        }
        if (idx == this.gi.free.length - 1) {
            return true;
        }
        return this.gi.ngc[idx + 1] <= this.gi.ngc[idx];
    }

    boolean isStartPoint(int idx) {
        if (idx >= this.gi.free.length || idx < 0) {
            return false;
        }
        if (idx == 0) {
            return true;
        }
        return this.gi.ngc[idx - 1] >= this.gi.ngc[idx];
    }

    public void resetBufferedImage() {
        this.bi = new BufferedImage(this.cfg.width, this.cfg.height, 2);
    }

    public String resetDrawChart() {
        this.resetBufferedImage();
        return this.drawChart(this.bi.getGraphics());
    }

    public void setBi(BufferedImage b) {
        this.bi = b;
    }

    public String drawChartOldAlgorithm(Graphics graphics) {
        int t;
        long afOverhead;
        Graphics2D g;
        this.graphics = graphics;
        this.dimension = this.headless ? new Dimension(this.cfg.width, this.cfg.height) : this.jp.getSize();
        if (!this.headless) {
            this.bi = new BufferedImage(this.dimension.width, this.dimension.height, 2);
            g = this.bi.createGraphics();
        } else {
            g = (Graphics2D)graphics;
        }
        if (this.cfg.font != null) {
            g.setFont(this.cfg.font);
        }
        this.fm = g.getFontMetrics();
        g.setColor(fg);
        if (this.zoom != this.oldZoom) {
            float ratio = ((float)this.center - (float)this.leftMargin) / ((float)this.dimension.width - (float)this.leftMargin - (float)this.rightMargin);
            long mx = this.lx + (long)((float)(this.rx - this.lx) * ratio);
            this.lx = mx - this.zoom / 2L;
            this.rx = mx + this.zoom / 2L;
            if (this.lx < this.gi.timestamp[this.start]) {
                this.il = 0;
            }
            if (this.rx > this.gi.timestamp[this.end]) {
                this.ir = this.gi.free.length - 1;
            }
            int i = this.start;
            while (i <= this.end) {
                if (this.gi.timestamp[i] >= this.rx) {
                    this.ir = i;
                    break;
                }
                ++i;
            }
            i = this.end;
            while (i >= this.start) {
                if (this.gi.timestamp[i] <= this.lx) {
                    this.il = i;
                    break;
                }
                --i;
            }
            this.oldZoom = this.zoom;
        }
        if (this.precisionZoom) {
            if (this.precisionZoomX1 > 0 && this.precisionZoomX2 > 0) {
                if (this.precisionZoomX1 > this.precisionZoomX2) {
                    this.il = this.precisionZoomX2;
                    this.ir = this.precisionZoomX1;
                } else {
                    this.il = this.precisionZoomX1;
                    this.ir = this.precisionZoomX2;
                }
                this.lx = this.gi.timestamp[this.il];
                this.rx = this.gi.timestamp[this.ir];
                this.zoom = this.oldZoom = this.rx - this.lx;
            }
            this.precisionZoom = false;
        }
        long xw = this.rx - this.lx;
        if (this.cfg.autoY) {
            int i;
            this.yw2 = 0L;
            this.yw = 0L;
            if (this.debug) {
                System.out.println("Auto Y");
            }
            if (this.free) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.free[i] > this.yw) {
                        this.yw = this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.freeBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freeN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.freePAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.freePBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.maxPerm) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangePerm[i] > this.yw) {
                        this.yw = this.gi.rangePerm[i];
                    }
                    ++i;
                }
            }
            if (this.maxTen) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.rangeTenured[i] > this.yw) {
                        this.yw = this.gi.rangeTenured[i];
                    }
                    ++i;
                }
            }
            if (this.used) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] - this.gi.free[i] > this.yw) {
                        this.yw = this.gi.total[i] - this.gi.free[i];
                    }
                    ++i;
                }
            }
            if (this.usedN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] - this.gi.freeNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i] - this.gi.freeNursery[i];
                    }
                    ++i;
                }
            }
            if (this.usedBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.usedPAfter) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] - this.gi.freePerm[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                    }
                    ++i;
                }
            }
            if (this.total) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.total[i] > this.yw) {
                        this.yw = this.gi.total[i];
                    }
                    ++i;
                }
            }
            if (this.totalBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBefore[i] > this.yw) {
                        this.yw = this.gi.totalBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalNBefore) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNurseryBefore[i] > this.yw) {
                        this.yw = this.gi.totalNurseryBefore[i];
                    }
                    ++i;
                }
            }
            if (this.totalN) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalNursery[i] > this.yw) {
                        this.yw = this.gi.totalNursery[i];
                    }
                    ++i;
                }
            }
            if (this.totalP) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalPermBefore[i] > this.yw) {
                        this.yw = this.gi.totalPermBefore[i];
                    }
                    ++i;
                }
            }
            if (this.freed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freed[i] > this.yw) {
                        this.yw = this.gi.freed[i];
                    }
                    ++i;
                }
            }
            if (this.requested) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.af[i] > this.yw) {
                        this.yw = this.gi.af[i];
                    }
                    ++i;
                }
            }
            if (this.freeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeSOA[i] > this.yw) {
                        this.yw = this.gi.freeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeLOA[i] > this.yw) {
                        this.yw = this.gi.freeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.freeBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.freeBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.freeBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalSOA[i] > this.yw) {
                        this.yw = this.gi.totalSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalLOA[i] > this.yw) {
                        this.yw = this.gi.totalLOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeSOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeSOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeSOA[i];
                    }
                    ++i;
                }
            }
            if (this.totalBeforeLOA) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.totalBeforeLOA[i] > this.yw) {
                        this.yw = this.gi.totalBeforeLOA[i];
                    }
                    ++i;
                }
            }
            if (this.since) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.since[i] > this.yw2) {
                        this.yw2 = this.gi.since[i];
                    }
                    ++i;
                }
            }
            if (this.completed) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.completed[i] > this.yw2) {
                        this.yw2 = this.gi.completed[i];
                    }
                    ++i;
                }
            }
            if (this.mark) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.mark[i] > this.yw2) {
                        this.yw2 = this.gi.mark[i];
                    }
                    ++i;
                }
            }
            if (this.sweep) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.sweep[i] > this.yw2) {
                        this.yw2 = this.gi.sweep[i];
                    }
                    ++i;
                }
            }
            if (this.compact) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.compact[i] > this.yw2) {
                        this.yw2 = this.gi.compact[i];
                    }
                    ++i;
                }
            }
            if (this.gccompleted) {
                i = this.il;
                while (i <= this.ir) {
                    if (this.gi.gccompleted[i] > this.yw2) {
                        this.yw2 = this.gi.gccompleted[i];
                    }
                    ++i;
                }
            }
            if (this.overhead) {
                if (this.gi.type == 2) {
                    i = this.il;
                    while (i <= this.ir) {
                        afOverhead = this.getOverhead(i);
                        if (afOverhead > this.yw2) {
                            this.yw2 = afOverhead;
                        }
                        ++i;
                    }
                } else {
                    i = this.il;
                    while (i <= this.ir) {
                        if (!this.isStartPoint(i) && (afOverhead = (long)this.getOverhead(i)) > this.yw2) {
                            this.yw2 = afOverhead;
                        }
                        ++i;
                    }
                }
            }
        } else if (this.zoomY != this.oldZoomY) {
            if (this.debug) {
                System.out.println("Changed zoomY=" + this.zoomY + " oldZoomY=" + this.oldZoomY);
            }
            if (this.debug) {
                System.out.println("yw=" + this.yw + " yw2=" + this.yw2);
            }
            this.oldyw = this.yw;
            this.oldyw2 = this.yw2;
            this.yw = (long)((float)this.yw / (this.zoomY / this.oldZoomY));
            if (this.yw == 0L) {
                this.yw = this.oldyw;
            }
            this.yw2 = (long)((float)this.yw2 / (this.zoomY / this.oldZoomY));
            if (this.yw2 == 0L) {
                this.yw2 = this.oldyw2;
            }
            if (this.debug) {
                System.out.println("changed yw=" + this.yw + " yw2=" + this.yw2);
            }
            this.oldZoomY = this.zoomY;
        }
        if (this.debug) {
            System.out.println("yw=" + this.yw + " yw2=" + this.yw2);
        }
        int log = this.get10(this.yw);
        this.leftMargin = this.fm.stringWidth(numberFormatter.format(this.yw)) + 30;
        this.rightMargin = this.fm.stringWidth(numberFormatter.format(this.yw2)) + 20;
        this.ratioX = ((float)this.dimension.width - (float)this.leftMargin - (float)this.rightMargin) / (float)xw;
        this.ratioY = ((float)this.dimension.height - 70.0f) / (float)this.yw;
        this.ratioY2 = ((float)this.dimension.height - 70.0f) / (float)this.yw2;
        if (!this.headless) {
            g.setBackground(new Color(204, 204, 204));
            g.clearRect(0, 0, this.dimension.width, this.dimension.height);
            g.setBackground(Color.white);
            g.clearRect(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin, this.dimension.height - 70);
        }
        g.setColor(this.fg3D);
        g.draw3DRect(this.leftMargin - 4, 16, this.dimension.width - this.leftMargin - this.rightMargin + 7, this.dimension.height - 70 + 7, true);
        g.draw3DRect(this.leftMargin - 1, 19, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 70 + 1, false);
        g.setColor(fg);
        g.drawString(dateFormatter.format(new Date(this.lx)), this.leftMargin - 15, this.dimension.height - this.y + 40);
        g.drawString(timeFormatter.format(new Date(this.lx)), this.leftMargin - 23, this.dimension.height - this.y + 20);
        g.drawString(dateFormatter.format(new Date(this.rx)), this.dimension.width - this.rightMargin - 15, this.dimension.height - this.y + 40);
        g.drawString(timeFormatter.format(new Date(this.rx)), this.dimension.width - this.rightMargin - 23, this.dimension.height - this.y + 20);
        int numberOfxt = (this.dimension.width - this.leftMargin - this.rightMargin) / 60;
        if (numberOfxt > 1) {
            long delta = (this.rx - this.lx) / (long)numberOfxt;
            int i = 1;
            while (i < numberOfxt) {
                g.setColor(fg);
                g.drawString(dateFormatter.format(new Date(delta * (long)i + this.lx)), (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin - 15, this.dimension.height - this.y + 40);
                g.drawString(timeFormatter.format(new Date(delta * (long)i + this.lx)), (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin - 23, this.dimension.height - this.y + 20);
                g.setColor(this.fg3D);
                g.setStroke(dashed);
                g.drawLine((int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin, 20, (int)((float)(delta * (long)i) * this.ratioX) + this.leftMargin, this.dimension.height - 20);
                ++i;
            }
        }
        int first = this.getFirstDigit(this.yw);
        long maxLevel = 0L;
        maxLevel = this.yw > 9L ? (long)Math.pow(10.0, log - 1) * (long)this.getSecondDigit(this.yw) : (long)first * (long)Math.pow(10.0, log);
        if (maxLevel == 0L) {
            g.setColor(fg);
            g.drawString("bytes", 20, 15);
        }
        int i = 0;
        while (maxLevel > 0L) {
            t = this.dimension.height - (int)((float)maxLevel * this.ratioY) - 50;
            g.setColor(this.fg3D);
            g.setStroke(dashed);
            g.drawLine(this.leftMargin, t, this.dimension.width - this.rightMargin, t);
            g.setColor(fg);
            if (i == 0) {
                g.drawString("bytes", 20, 15);
            }
            g.drawString(numberFormatter.format(maxLevel), 10, t + 5);
            maxLevel = first == 1 ? (log >= 1 ? (maxLevel -= (long)Math.pow(10.0, log - 1)) : (maxLevel -= 10L)) : (maxLevel -= (long)Math.pow(10.0, log));
            ++i;
        }
        int log2 = this.get10(this.yw2);
        int first2 = this.getFirstDigit(this.yw2);
        long maxLevel2 = 0L;
        maxLevel2 = this.yw2 > 9L ? (long)Math.pow(10.0, log2 - 1) * (long)this.getSecondDigit(this.yw2) : (long)first2 * (long)Math.pow(10.0, log2);
        if (maxLevel2 == 0L) {
            g.setColor(fg);
            if (this.overhead) {
                g.drawString("ms %", 10 + this.dimension.width - this.rightMargin, 15);
            } else {
                g.drawString("ms", 10 + this.dimension.width - this.rightMargin, 15);
            }
        }
        int i2 = 0;
        while (maxLevel2 > 0L) {
            t = this.dimension.height - (int)((float)maxLevel2 * this.ratioY2) - 50;
            g.setColor(this.fg3D);
            g.setStroke(dashed);
            g.drawLine(this.leftMargin, t, this.dimension.width - this.rightMargin, t);
            g.setColor(fg);
            if (i2 == 0) {
                if (this.overhead) {
                    g.drawString("ms,%", 10 + this.dimension.width - this.rightMargin, 15);
                } else {
                    g.drawString("ms", 10 + this.dimension.width - this.rightMargin, 15);
                }
            }
            g.drawString(numberFormatter.format(maxLevel2), 10 + this.dimension.width - this.rightMargin, t + 5);
            maxLevel2 = first2 == 1 ? (log2 >= 1 ? (maxLevel2 -= (long)Math.pow(10.0, log2 - 1)) : (maxLevel2 -= 10L)) : (maxLevel2 -= (long)Math.pow(10.0, log2));
            ++i2;
        }
        g.setClip(this.leftMargin, 20, this.dimension.width - this.leftMargin - this.rightMargin + 1, this.dimension.height - 20 - 50 + 1);
        i2 = this.il;
        while (i2 < this.ir) {
            if (i2 + 1 == this.ir && this.gi.outOfHeapSpace != null && this.isShortage[i2 + 1]) {
                if (this.oome) {
                    this.drawOOM((int)((float)(this.gi.timestamp[i2 + 1] - this.lx) * this.ratioX) + this.leftMargin, g);
                }
                g.setStroke(dashed);
                g.setColor(this.cfg.oome);
                g.drawLine((int)((float)(this.gi.timestamp[i2 + 1] - this.lx) * this.ratioX) + this.leftMargin, 20, (int)((float)(this.gi.timestamp[i2 + 1] - this.lx) * this.ratioX) + this.leftMargin, this.dimension.height - 50);
            }
            int x1 = (int)((float)(this.gi.timestamp[i2] - this.lx) * this.ratioX) + this.leftMargin;
            int x2 = (int)((float)(this.gi.timestamp[i2 + 1] - this.lx) * this.ratioX) + this.leftMargin;
            if (this.gi.ngc[i2 + 1] < this.gi.ngc[i2]) {
                if (this.restart) {
                    this.drawRestart(g, x1);
                }
                g.setStroke(dashed);
                g.setColor(this.cfg.restart);
                g.drawLine(x1, 20, x1, this.dimension.height - 50);
            } else {
                int y2;
                int y1;
                if (this.free) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.free);
                    y1 = this.dimension.height - (int)((float)this.gi.free[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.free[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeSOA) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.freeSOA);
                    y1 = this.dimension.height - (int)((float)this.gi.freeSOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeSOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeLOA) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.freeLOA);
                    y1 = this.dimension.height - (int)((float)this.gi.freeLOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeLOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.freeBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.freeBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeBeforeSOA) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.freeBeforeSOA);
                    y1 = this.dimension.height - (int)((float)this.gi.freeBeforeSOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeBeforeSOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeBeforeLOA) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.freeBeforeLOA);
                    y1 = this.dimension.height - (int)((float)this.gi.freeBeforeLOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeBeforeLOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeN) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.freeN);
                    y1 = this.dimension.height - (int)((float)this.gi.freeNursery[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeNursery[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freePAfter) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.freePAfter);
                    y1 = this.dimension.height - (int)((float)this.gi.freePerm[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freePerm[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freePBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.freePBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.freePermBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freePermBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freeNBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.freeNBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.freeNurseryBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freeNurseryBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.used) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.used);
                    y1 = this.dimension.height - (int)((float)(this.gi.total[i2] - this.gi.free[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.total[i2 + 1] - this.gi.free[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.usedN) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.usedN);
                    y1 = this.dimension.height - (int)((float)(this.gi.totalNursery[i2] - this.gi.freeNursery[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.totalNursery[i2 + 1] - this.gi.freeNursery[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.usedPAfter) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.usedPAfter);
                    y1 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i2] - this.gi.freePerm[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i2 + 1] - this.gi.freePerm[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.usedBefore) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.usedBefore);
                    y1 = this.dimension.height - (int)((float)(this.gi.totalBefore[i2] - this.gi.freeBefore[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.totalBefore[i2 + 1] - this.gi.freeBefore[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                    long l = System.currentTimeMillis();
                }
                if (this.usedNBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.usedNBefore);
                    y1 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[i2] - this.gi.freeNurseryBefore[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.totalNurseryBefore[i2 + 1] - this.gi.freeNurseryBefore[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.usedPBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.usedPBefore);
                    y1 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i2] - this.gi.freePermBefore[i2]) * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)(this.gi.totalPermBefore[i2 + 1] - this.gi.freePermBefore[i2 + 1]) * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.total) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.total);
                    y1 = this.dimension.height - (int)((float)this.gi.total[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.total[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalSOA) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.totalSOA);
                    y1 = this.dimension.height - (int)((float)this.gi.totalSOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalSOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalLOA) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.totalLOA);
                    y1 = this.dimension.height - (int)((float)this.gi.totalLOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalLOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.maxTen) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.maxTen);
                    y1 = this.dimension.height - (int)((float)this.gi.rangeTenured[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.rangeTenured[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.maxPerm) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.maxPerm);
                    y1 = this.dimension.height - (int)((float)this.gi.rangePerm[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.rangePerm[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.totalBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.totalBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalBeforeSOA) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.totalBeforeSOA);
                    y1 = this.dimension.height - (int)((float)this.gi.totalBeforeSOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalBeforeSOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalBeforeLOA) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.totalBeforeLOA);
                    y1 = this.dimension.height - (int)((float)this.gi.totalBeforeLOA[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalBeforeLOA[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalN) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.totalN);
                    y1 = this.dimension.height - (int)((float)this.gi.totalNursery[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalNursery[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalNBefore) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.totalNBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.totalNurseryBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalNurseryBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.totalP) {
                    g.setStroke(dashed);
                    g.setColor(this.cfg.totalPBefore);
                    y1 = this.dimension.height - (int)((float)this.gi.totalPermBefore[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.totalPermBefore[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.freed) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.freed);
                    y1 = this.dimension.height - (int)((float)this.gi.freed[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.freed[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.requested) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.requested);
                    y1 = this.dimension.height - (int)((float)this.gi.af[i2] * this.ratioY) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.af[i2 + 1] * this.ratioY) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.compact) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.compact);
                    y1 = this.dimension.height - (int)((float)this.gi.compact[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.compact[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.sweep) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.sweep);
                    y1 = this.dimension.height - (int)((float)this.gi.sweep[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.sweep[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.mark) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.mark);
                    y1 = this.dimension.height - (int)((float)this.gi.mark[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.mark[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.completed) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.completed);
                    y1 = this.dimension.height - (int)((float)this.gi.completed[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.completed[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.since) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.since);
                    y1 = this.dimension.height - (int)((float)this.gi.since[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.since[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.gccompleted) {
                    g.setStroke(stroke);
                    g.setColor(this.cfg.gccompleted);
                    y1 = this.dimension.height - (int)((float)this.gi.gccompleted[i2] * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)this.gi.gccompleted[i2 + 1] * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
                if (this.overhead) {
                    g.setStroke(stroke);
                    afOverhead = this.isStartPoint(i2) ? 0L : (this.gi.type == 2 ? (long)this.getOverhead(i2) : (long)Math.round(100.0f * (float)this.getCompleted(i2) / (float)(this.getSince(i2) + this.getCompleted(i2))));
                    long afOverhead2 = this.gi.type == 2 ? (long)this.getOverhead(i2 + 1) : (long)Math.round(100.0f * (float)this.getCompleted(i2 + 1) / (float)(this.getSince(i2 + 1) + this.getCompleted(i2 + 1)));
                    y1 = this.dimension.height - (int)((float)afOverhead * this.ratioY2) - 50;
                    y2 = this.dimension.height - (int)((float)afOverhead2 * this.ratioY2) - 50;
                    if (x1 != x2 || y1 != y2) {
                        g.setColor(this.cfg.overhead);
                        g.drawLine(x1, y1, x2, y2);
                        if (this.cfg.terminals) {
                            if (this.isStartPoint(i2)) {
                                g.fillRect(x1 - 2, y1 - 2, 4, 4);
                            }
                            if (this.isEndPoint(i2 + 1)) {
                                g.fillRect(x2 - 2, y2 - 2, 4, 4);
                            }
                        }
                        if (this.cfg.points && !this.isEndPoint(i2 + 1)) {
                            g.fillRect(x2 - 2, y2 - 2, 4, 4);
                        }
                    }
                }
            }
            if (this.gi.outOfHeapSpace != null && this.isShortage[i2]) {
                if (this.oome) {
                    this.drawOOM(x1, g);
                }
                g.setStroke(dashed);
                g.setColor(this.cfg.oome);
                g.drawLine(x1, 20, x1, this.dimension.height - 50);
            }
            ++i2;
        }
        g.setClip(null);
        g.setColor(fg);
        if (this.headless) {
            g.drawString(COPYRIGHT, 80, 13);
            String fileName = String.valueOf(this.prefix) + "_" + this.seq + ".png";
            File outputfile = null;
            try {
                outputfile = new File(fileName);
                ++this.seq;
                ImageIO.write((RenderedImage)this.bi, "png", outputfile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return "<img alt=\"" + outputfile.getName() + "\" height=" + this.cfg.height + " src=\"" + outputfile.getName() + "\" width=" + this.cfg.width + ">";
        }
        ((Graphics2D)graphics).drawImage((Image)this.bi, 0, 0, this.jp);
        return null;
    }
}

