/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.ChartEngine;
import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.GCTableThread;
import com.ibm.jinwoo.gc.HeapFrame;
import com.ibm.jinwoo.gc.JinwooDynamicTextPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class ChartPanel
extends JPanel
implements MouseMotionListener,
MouseWheelListener {
    public boolean dragZoom = true;
    Color lightBlue = new Color(255, 255, 204);
    boolean inDrag = false;
    public HeapFrame heapFrame = null;
    ChartEngine ce;
    GCInfo gi;
    GCAnalyzer gca;
    int oldX = -1;
    int oldXD = -1;
    int pressedIndex = -1;
    int pressedX = -1;
    int pressedY = -1;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private int selectedIdx;
    private int previousDx;
    private int previousDy;

    public void zoom(int x1, int x2) {
        this.ce.precisionZoom = true;
        this.ce.precisionZoomX1 = x1;
        this.ce.precisionZoomX2 = x2;
        this.ce.precisionZoomY1 = this.pressedY;
        this.ce.precisionZoomY2 = this.previousDy;
        this.oldX = -1;
        this.repaint();
    }

    public void released(MouseEvent e) {
        if (this.inDrag) {
            this.zoom(this.pressedIndex, this.oldXD);
            this.inDrag = false;
        }
        this.pressedX = -1;
        this.pressedY = -1;
        this.pressedIndex = -1;
    }

    public ChartPanel() {
        this.initialize();
    }

    public ChartPanel(GCInfo gi, GCAnalyzer gca, int start, int end) {
        this.gi = gi;
        this.gca = gca;
        this.initialize();
        this.ce = new ChartEngine(gi, gca.cfg, start, end, false, null, this, null);
    }

    public ChartPanel(LayoutManager layout) {
        super(layout);
    }

    public ChartPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ChartPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public void chartPanel_MouseClicked(MouseEvent mouseEvent) {
        this.ce.center = mouseEvent.getX();
        if (this.ce.center > this.ce.dimension.width - this.ce.rightMargin || this.ce.center < this.ce.leftMargin) {
            return;
        }
        int Y = mouseEvent.getY();
        if (Y > this.ce.dimension.height - 50 || Y < 20) {
            return;
        }
        if (this.ce.select) {
            this.showTable(this.selectedIdx);
        }
        this.handleZoom();
    }

    public void handleZoom() {
        if (this.ce.zoomInY) {
            this.ce.oldZoomY = this.ce.zoomY;
            this.ce.zoomY *= 2.0f;
            this.oldX = -1;
            this.repaint();
        } else if (this.ce.zoomOutY) {
            this.ce.oldZoomY = this.ce.zoomY;
            this.ce.zoomY /= 2.0f;
            this.oldX = -1;
            this.repaint();
        }
        if (this.ce.zoomIn) {
            long newZoom = (long)((float)this.ce.zoom / 2.0f);
            if (newZoom >= 1L) {
                this.ce.oldZoom = this.ce.zoom;
                this.ce.zoom = newZoom;
                this.oldX = -1;
                this.repaint();
            }
        } else if (this.ce.zoomOut) {
            long newZoom = this.ce.zoom * 2L;
            if (newZoom < Long.MAX_VALUE) {
                this.ce.oldZoom = this.ce.zoom;
                this.ce.zoom = newZoom;
                this.oldX = -1;
                this.repaint();
            }
        } else if (this.ce.zoomCenter) {
            this.ce.oldZoom = -1L;
            this.oldX = -1;
            this.repaint();
        }
    }

    private void connEtoC1(MouseEvent arg1) {
        try {
            this.chartPanel_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ChartPanel");
            this.setLayout(null);
            this.setBackground(new Color(204, 204, 204));
            this.setSize(696, 416);
            this.setMinimumSize(new Dimension(300, 200));
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            ChartPanel aChartPanel = new ChartPanel();
            frame.setContentPane(aChartPanel);
            frame.setSize(aChartPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.ce.drawChart(g);
        this.oldX = -1;
    }

    public void saveChart() {
    }

    public void showTable(int idx) {
        HeapFrame hf = new HeapFrame(String.valueOf(this.gi.file.getName()) + " GC View", this.gi);
        hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
        hf.fileName = this.gi.file.getName();
        JTable jt = new JTable();
        jt.setDragEnabled(true);
        jt.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        hf.setSize(600, 300);
        GCTableThread at = new GCTableThread(jt, this.gi, this.gca, hf, idx);
        at.start();
        JInternalFrame sourceFrame = new JInternalFrame(String.valueOf(this.gi.file.getName()) + " Source View");
        sourceFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
        JinwooDynamicTextPane area = null;
        area = idx + 1 >= this.gi.filePointer.length ? new JinwooDynamicTextPane(this.gi.file, this.gi.filePointer[idx], -1L) : new JinwooDynamicTextPane(this.gi.file, this.gi.filePointer[idx], this.gi.filePointer[idx + 1]);
        sourceFrame.setContentPane(area);
        sourceFrame.setVisible(true);
        sourceFrame.setSize(600, 300);
        sourceFrame.setClosable(true);
        sourceFrame.setResizable(true);
        sourceFrame.setMaximizable(true);
        sourceFrame.setIconifiable(true);
        this.gca.getJDesktopPane1().add(sourceFrame);
        hf.JScrollPaneSetViewportView(jt);
        this.gca.getJDesktopPane1().add(hf);
        this.gca.getJDesktopPane1().getDesktopManager().activateFrame(hf);
        this.gca.getJDesktopPane1().getDesktopManager().activateFrame(sourceFrame);
        try {
            sourceFrame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        if (at.highlight != -1) {
            jt.scrollRectToVisible(jt.getCellRect(at.highlight, 0, true));
        }
    }

    public int getIndexFromX(int x) {
        if (x > this.ce.dimension.width - this.ce.rightMargin) {
            x = this.ce.dimension.width - this.ce.rightMargin;
        }
        if (x < this.ce.leftMargin) {
            x = this.ce.leftMargin;
        }
        float ratio2 = ((float)x - (float)this.ce.leftMargin) / ((float)this.ce.dimension.width - (float)this.ce.leftMargin - (float)this.ce.rightMargin);
        long selectedTS = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * ratio2);
        int selectedIdx = this.ce.il;
        int i = this.ce.il;
        while (i <= this.ce.ir) {
            if (this.ce.gi.timestamp[i] == selectedTS) {
                selectedIdx = i;
                break;
            }
            if (this.ce.gi.timestamp[i] > selectedTS) {
                selectedIdx = i;
                if (selectedIdx == this.ce.il || selectedTS - this.ce.gi.timestamp[selectedIdx - 1] >= this.ce.gi.timestamp[selectedIdx] - selectedTS) break;
                --selectedIdx;
                break;
            }
            ++i;
        }
        return selectedIdx;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        boolean scroll = !this.dragZoom ? !SwingUtilities.isRightMouseButton(mouseEvent) : SwingUtilities.isRightMouseButton(mouseEvent);
        if (scroll) {
            int deltax = this.previousDx - x;
            int deltay = y - this.previousDy;
            int screenWidthPixel = this.ce.dimension.width - this.ce.rightMargin - this.ce.leftMargin;
            float timestampWidth = this.ce.rx - this.ce.lx;
            float timePerPixel = timestampWidth / (float)screenWidthPixel;
            float travel = timePerPixel * (float)deltax;
            float travely = timePerPixel * (float)deltay;
            this.ce.addLx((long)travel);
            this.ce.addRx((long)travel);
            this.ce.oldZoom = 0L;
            if (Math.abs(deltay) > 0) {
                this.ce.travelY = deltay;
            }
            this.repaint();
            this.previousDx = x;
            this.previousDy = y;
            return;
        }
        this.inDrag = true;
        if (this.pressedX < this.ce.leftMargin) {
            this.pressedX = this.ce.leftMargin;
        }
        this.ce.center = x;
        if (this.ce.center > this.ce.dimension.width - this.ce.rightMargin) {
            this.ce.center = this.ce.dimension.width - this.ce.rightMargin;
        }
        if (this.ce.center < this.ce.leftMargin) {
            this.ce.center = this.ce.leftMargin;
        }
        if (y > this.ce.dimension.height - 50) {
            return;
        }
        if (y < 20) {
            return;
        }
        float ratio2 = ((float)this.ce.center - (float)this.ce.leftMargin) / ((float)this.ce.dimension.width - (float)this.ce.leftMargin - (float)this.ce.rightMargin);
        long selectedTS = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * ratio2);
        int selectedIdx = this.ce.il;
        if (selectedTS >= this.ce.rx) {
            selectedIdx = this.ce.ir;
        } else if (selectedTS <= this.ce.lx) {
            selectedIdx = this.ce.il;
        } else {
            int i = this.ce.il;
            while (i <= this.ce.ir) {
                if (this.ce.gi.timestamp[i] == selectedTS) {
                    selectedIdx = i;
                    break;
                }
                if (this.ce.gi.timestamp[i] > selectedTS) {
                    selectedIdx = i;
                    if (selectedIdx == this.ce.il || selectedTS - this.ce.gi.timestamp[selectedIdx - 1] >= this.ce.gi.timestamp[selectedIdx] - selectedTS) break;
                    --selectedIdx;
                    break;
                }
                ++i;
            }
        }
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        g.setColor(this.lightBlue);
        this.oldXD = selectedIdx;
        int width = Math.abs(this.pressedX - this.previousDx);
        int height = Math.abs(this.pressedY - this.previousDy);
        int xx = this.pressedX < this.previousDx ? this.pressedX : this.previousDx;
        int yy = this.pressedY < this.previousDy ? this.pressedY : this.previousDy;
        if (this.ce.cfg.autoY) {
            yy = 20;
            height = this.ce.dimension.height - 50 - 20;
        }
        g.setClip(this.ce.leftMargin, 20, this.ce.dimension.width - this.ce.leftMargin - this.ce.rightMargin + 1, this.ce.dimension.height - 20 - 50 + 1);
        g.fillRect(xx, yy, width, height);
        int dx = x;
        int dy = y;
        if (dx < this.ce.leftMargin) {
            dx = this.ce.leftMargin;
        }
        width = Math.abs(this.pressedX - dx);
        height = Math.abs(this.pressedY - dy);
        xx = this.pressedX < dx ? this.pressedX : dx;
        yy = this.pressedY < dy ? this.pressedY : dy;
        if (this.ce.cfg.autoY) {
            yy = 20;
            height = this.ce.dimension.height - 50 - 20;
        }
        g.fillRect(xx, yy, width, height);
        this.previousDx = dx;
        this.previousDy = dy;
        g.setClip(null);
    }

    public void mouseReleased(MouseEvent e) {
        System.out.println("released at " + e.getX());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int indiX;
        int afOverhead;
        if (this.heapFrame != null && !this.heapFrame.isSelected()) {
            return;
        }
        this.ce.center = mouseEvent.getX();
        if (this.ce.center > this.ce.dimension.width - this.ce.rightMargin) {
            return;
        }
        if (this.ce.center < this.ce.leftMargin) {
            return;
        }
        if (mouseEvent.getY() > this.ce.dimension.height - 50) {
            return;
        }
        if (mouseEvent.getY() < 20) {
            return;
        }
        float ratio2 = ((float)this.ce.center - (float)this.ce.leftMargin) / ((float)this.ce.dimension.width - (float)this.ce.leftMargin - (float)this.ce.rightMargin);
        long selectedTS = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * ratio2);
        this.selectedIdx = this.ce.il;
        int i = this.ce.il;
        while (i <= this.ce.ir) {
            if (this.ce.gi.timestamp[i] == selectedTS) {
                this.selectedIdx = i;
                break;
            }
            if (this.ce.gi.timestamp[i] > selectedTS) {
                this.selectedIdx = i;
                if (this.selectedIdx == this.ce.il || selectedTS - this.ce.gi.timestamp[this.selectedIdx - 1] >= this.ce.gi.timestamp[this.selectedIdx] - selectedTS) break;
                --this.selectedIdx;
                break;
            }
            ++i;
        }
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        Rectangle2D area = null;
        String timeString = null;
        String gcString = null;
        String other = null;
        int indiXadjust = 0;
        if (this.oldX >= 0) {
            if (this.ce.free) {
                g.setColor(this.ce.cfg.free);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.free[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.free[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeButton(), other);
            }
            if (this.ce.freeSOA) {
                g.setColor(this.ce.cfg.freeSOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeSOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeSOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeSOAButton(), other);
            }
            if (this.ce.freeLOA) {
                g.setColor(this.ce.cfg.freeLOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeLOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeLOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeLOAButton(), other);
            }
            if (this.ce.freeBefore) {
                g.setColor(this.ce.cfg.freeBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeBeforeButton(), other);
            }
            if (this.ce.freeBeforeSOA) {
                g.setColor(this.ce.cfg.freeBeforeSOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBeforeSOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeBeforeSOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeBeforeSOAButton(), other);
            }
            if (this.ce.freeBeforeLOA) {
                g.setColor(this.ce.cfg.freeBeforeLOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBeforeLOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeBeforeLOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeBeforeLOAButton(), other);
            }
            if (this.ce.freeN) {
                g.setColor(this.ce.cfg.freeN);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeNursery[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeNursery[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeNButton(), other);
            }
            if (this.ce.freePAfter) {
                g.setColor(this.ce.cfg.freePAfter);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freePerm[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freePerm[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreePermAfterButton(), other);
            }
            if (this.ce.freePBefore) {
                g.setColor(this.ce.cfg.freePBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freePermBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freePermBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreePermBeforeButton(), other);
            }
            if (this.ce.freeNBefore) {
                g.setColor(this.ce.cfg.freeNBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeNurseryBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freeNurseryBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreeNBeforeButton(), other);
            }
            if (this.ce.used) {
                g.setColor(this.ce.cfg.used);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.total[this.oldX] - this.gi.free[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.total[this.selectedIdx] - this.gi.free[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedButton(), other);
            }
            if (this.ce.usedN) {
                g.setColor(this.ce.cfg.usedN);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNursery[this.oldX] - this.gi.freeNursery[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalNursery[this.selectedIdx] - this.gi.freeNursery[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedNButton(), other);
            }
            if (this.ce.usedPAfter) {
                g.setColor(this.ce.cfg.usedPAfter);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.oldX] - this.gi.freePerm[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePerm[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedPermAfterButton(), other);
            }
            if (this.ce.usedBefore) {
                g.setColor(this.ce.cfg.usedBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBefore[this.oldX] - this.gi.freeBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalBefore[this.selectedIdx] - this.gi.freeBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedBeforeButton(), other);
            }
            if (this.ce.usedNBefore) {
                g.setColor(this.ce.cfg.usedBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.oldX] - this.gi.freeNurseryBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalNurseryBefore[this.selectedIdx] - this.gi.freeNurseryBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedNBeforeButton(), other);
            }
            if (this.ce.usedPBefore) {
                g.setColor(this.ce.cfg.usedPBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.oldX] - this.gi.freePermBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePermBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getUsedPermBeforeButton(), other);
            }
            if (this.ce.total) {
                g.setColor(this.ce.cfg.total);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.total[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.total[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalButton(), other);
            }
            if (this.ce.totalSOA) {
                g.setColor(this.ce.cfg.totalSOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalSOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalSOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalSOAButton(), other);
            }
            if (this.ce.totalLOA) {
                g.setColor(this.ce.cfg.totalLOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalLOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalLOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalLOAButton(), other);
            }
            if (this.ce.maxTen) {
                g.setColor(this.ce.cfg.maxTen);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.rangeTenured[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.rangeTenured[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getMaxTenButton(), other);
            }
            if (this.ce.maxPerm) {
                g.setColor(this.ce.cfg.maxPerm);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.rangePerm[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.rangePerm[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getMaxPermButton(), other);
            }
            if (this.ce.totalBefore) {
                g.setColor(this.ce.cfg.totalBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalBeforeButton(), other);
            }
            if (this.ce.totalBeforeSOA) {
                g.setColor(this.ce.cfg.totalBeforeSOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBeforeSOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalBeforeSOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalBeforeSOAButton(), other);
            }
            if (this.ce.totalBeforeLOA) {
                g.setColor(this.ce.cfg.totalBeforeLOA);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBeforeLOA[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalBeforeLOA[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalBeforeLOAButton(), other);
            }
            if (this.ce.totalN) {
                g.setColor(this.ce.cfg.totalN);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNursery[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalNursery[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalNButton(), other);
            }
            if (this.ce.totalNBefore) {
                g.setColor(this.ce.cfg.totalNBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalNurseryBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalNBeforeButton(), other);
            }
            if (this.ce.totalP) {
                g.setColor(this.ce.cfg.totalPBefore);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.totalPermBefore[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getTotalPermButton(), other);
            }
            if (this.ce.freed) {
                g.setColor(this.ce.cfg.freed);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freed[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.freed[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getFreedButton(), other);
            }
            if (this.ce.requested) {
                g.setColor(this.ce.cfg.requested);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.af[this.oldX] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.af[this.selectedIdx]) + " bytes";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getRequestedButton(), other);
            }
            if (this.ce.compact) {
                g.setColor(this.ce.cfg.compact);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.compact[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.compact[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getCompactButton(), other);
            }
            if (this.ce.sweep) {
                g.setColor(this.ce.cfg.sweep);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.sweep[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.sweep[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getSweepButton(), other);
            }
            if (this.ce.mark) {
                g.setColor(this.ce.cfg.mark);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.mark[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.mark[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getMarkButton(), other);
            }
            if (this.ce.completed) {
                g.setColor(this.ce.cfg.completed);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.completed[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.completed[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getCompletedButton(), other);
            }
            if (this.ce.since) {
                g.setColor(this.ce.cfg.since);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.since[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.since[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getSinceButton(), other);
            }
            if (this.ce.gccompleted) {
                g.setColor(this.ce.cfg.gccompleted);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.gccompleted[this.oldX] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                other = " : " + numberFormatter.format(this.gi.gccompleted[this.selectedIdx]) + " ms";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getGCButton(), other);
            }
            if (this.ce.overhead) {
                afOverhead = 0;
                afOverhead = this.ce.isStartPoint(this.oldX) ? 0 : (this.gi.type == 2 ? this.ce.getOverhead(this.oldX) : Math.round(100.0f * (float)this.ce.getCompleted(this.oldX) / (float)(this.ce.getSince(this.oldX) + this.ce.getCompleted(this.oldX))));
                g.setColor(this.ce.cfg.overhead);
                g.drawArc((int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)((long)afOverhead - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
                afOverhead = 0;
                afOverhead = this.ce.isStartPoint(this.selectedIdx) ? 0 : (this.gi.type == 2 ? this.ce.getOverhead(this.selectedIdx) : Math.round(100.0f * (float)this.ce.getCompleted(this.selectedIdx) / (float)(this.ce.getSince(this.selectedIdx) + this.ce.getCompleted(this.selectedIdx))));
                other = " : " + afOverhead + " %";
                this.gca.controlPanel.setValue(this.gca.controlPanel.getOverheadButton(), other);
            }
            g.setColor(Color.gray);
            indiX = (int)((float)(this.gi.timestamp[this.oldX] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin;
            g.drawLine(indiX, 20, indiX, this.ce.dimension.height - 50);
            timeString = "Time=" + ChartEngine.timeFormatter.format(new Date(this.gi.timestamp[this.selectedIdx]));
            gcString = "GC=" + this.gi.ngc[this.selectedIdx];
            area = g.getFontMetrics().getStringBounds(timeString, g);
            indiXadjust = area.getWidth() + (double)indiX > (double)(this.ce.dimension.width - this.ce.rightMargin) ? (int)area.getWidth() : 0;
            area = g.getFontMetrics().getStringBounds(gcString, g);
            indiXadjust = area.getWidth() + (double)indiX > (double)(this.ce.dimension.width - this.ce.rightMargin) ? (int)area.getWidth() : 0;
            if (this.gca.controlPanel != null) {
                this.gca.controlPanel.getGCInfo().setText(gcString);
                this.gca.controlPanel.getTimeInfo().setText(timeString);
            }
        }
        if (this.ce.free) {
            g.setColor(this.ce.cfg.free);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.free[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free(After)=" + this.gi.free[this.selectedIdx];
        }
        if (this.ce.freeSOA) {
            g.setColor(this.ce.cfg.freeSOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeSOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "FreeSOA(After)=" + this.gi.freeSOA[this.selectedIdx];
        }
        if (this.ce.freeLOA) {
            g.setColor(this.ce.cfg.freeLOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeLOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "FreeLOA(After)=" + this.gi.freeLOA[this.selectedIdx];
        }
        if (this.ce.freeBefore) {
            g.setColor(this.ce.cfg.freeBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free(Before)=" + this.gi.freeBefore[this.selectedIdx];
        }
        if (this.ce.freeBeforeSOA) {
            g.setColor(this.ce.cfg.freeBeforeSOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBeforeSOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "FreeSOA(Before)=" + this.gi.freeBeforeSOA[this.selectedIdx];
        }
        if (this.ce.freeBeforeLOA) {
            g.setColor(this.ce.cfg.freeBeforeLOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeBeforeLOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "FreeLOA(Before)=" + this.gi.freeBeforeLOA[this.selectedIdx];
        }
        if (this.ce.freeN) {
            g.setColor(this.ce.cfg.freeN);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeNursery[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free Nursery(After)=" + this.gi.freeNursery[this.selectedIdx];
        }
        if (this.ce.freePAfter) {
            g.setColor(this.ce.cfg.freePAfter);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freePerm[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free Perm(After)=" + this.gi.freePerm[this.selectedIdx];
        }
        if (this.ce.freePBefore) {
            g.setColor(this.ce.cfg.freePBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freePermBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free Perm(Before)=" + this.gi.freePermBefore[this.selectedIdx];
        }
        if (this.ce.freeNBefore) {
            g.setColor(this.ce.cfg.freeNBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freeNurseryBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Free Nursery(Before)=" + this.gi.freeNurseryBefore[this.selectedIdx];
        }
        if (this.ce.used) {
            g.setColor(this.ce.cfg.used);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.total[this.selectedIdx] - this.gi.free[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used(After)=" + (this.gi.total[this.selectedIdx] - this.gi.free[this.selectedIdx]);
        }
        if (this.ce.usedN) {
            g.setColor(this.ce.cfg.usedN);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNursery[this.selectedIdx] - this.gi.freeNursery[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used Nursery(After)=" + (this.gi.totalNursery[this.selectedIdx] - this.gi.freeNursery[this.selectedIdx]);
        }
        if (this.ce.usedPAfter) {
            g.setColor(this.ce.cfg.usedPAfter);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePerm[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used Perm(After)=" + (this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePerm[this.selectedIdx]);
        }
        if (this.ce.usedBefore) {
            g.setColor(this.ce.cfg.usedBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBefore[this.selectedIdx] - this.gi.freeBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used(Before)=" + (this.gi.totalBefore[this.selectedIdx] - this.gi.freeBefore[this.selectedIdx]);
        }
        if (this.ce.usedNBefore) {
            g.setColor(this.ce.cfg.usedBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.selectedIdx] - this.gi.freeNurseryBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used Nursery(Before)=" + (this.gi.totalNurseryBefore[this.selectedIdx] - this.gi.freeNurseryBefore[this.selectedIdx]);
        }
        if (this.ce.usedPBefore) {
            g.setColor(this.ce.cfg.usedPBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePermBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Used Perm(Before)=" + (this.gi.totalPermBefore[this.selectedIdx] - this.gi.freePermBefore[this.selectedIdx]);
        }
        if (this.ce.total) {
            g.setColor(this.ce.cfg.total);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.total[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total(After)=" + this.gi.total[this.selectedIdx];
        }
        if (this.ce.totalSOA) {
            g.setColor(this.ce.cfg.totalSOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalSOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total SOA(After)=" + this.gi.totalSOA[this.selectedIdx];
        }
        if (this.ce.totalLOA) {
            g.setColor(this.ce.cfg.totalLOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalLOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total LOA(After)=" + this.gi.totalLOA[this.selectedIdx];
        }
        if (this.ce.maxTen) {
            g.setColor(this.ce.cfg.maxTen);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.rangeTenured[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Max Tenured=" + this.gi.rangeTenured[this.selectedIdx];
        }
        if (this.ce.maxPerm) {
            g.setColor(this.ce.cfg.maxPerm);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.rangePerm[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Max Perm=" + this.gi.rangePerm[this.selectedIdx];
        }
        if (this.ce.totalBefore) {
            g.setColor(this.ce.cfg.totalBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total(Before)=" + this.gi.totalBefore[this.selectedIdx];
        }
        if (this.ce.totalBeforeSOA) {
            g.setColor(this.ce.cfg.totalBeforeSOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBeforeSOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total SOA(Before)=" + this.gi.totalBeforeSOA[this.selectedIdx];
        }
        if (this.ce.totalBeforeLOA) {
            g.setColor(this.ce.cfg.totalBeforeLOA);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalBeforeLOA[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total LOA(Before)=" + this.gi.totalBeforeLOA[this.selectedIdx];
        }
        if (this.ce.totalN) {
            g.setColor(this.ce.cfg.totalN);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNursery[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total Nursery(After)=" + this.gi.totalNursery[this.selectedIdx];
        }
        if (this.ce.totalNBefore) {
            g.setColor(this.ce.cfg.totalNBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalNurseryBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total Nursery(Before)=" + this.gi.totalNurseryBefore[this.selectedIdx];
        }
        if (this.ce.totalP) {
            g.setColor(this.ce.cfg.totalPBefore);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.totalPermBefore[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Total Perm(Before)" + this.gi.totalPermBefore[this.selectedIdx];
        }
        if (this.ce.freed) {
            g.setColor(this.ce.cfg.freed);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.freed[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Freed=" + this.gi.freed[this.selectedIdx];
        }
        if (this.ce.requested) {
            g.setColor(this.ce.cfg.requested);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.af[this.selectedIdx] - this.ce.yb) * this.ce.ratioY) - 50 - 4, 8, 8, 0, 360);
            other = "Requested=" + this.gi.af[this.selectedIdx];
        }
        if (this.ce.compact) {
            g.setColor(this.ce.cfg.compact);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.compact[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "Compact=" + this.gi.compact[this.selectedIdx];
        }
        if (this.ce.sweep) {
            g.setColor(this.ce.cfg.sweep);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.sweep[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "Sweep=" + this.gi.sweep[this.selectedIdx];
        }
        if (this.ce.mark) {
            g.setColor(this.ce.cfg.mark);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.mark[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "Mark=" + this.gi.mark[this.selectedIdx];
        }
        if (this.ce.completed) {
            g.setColor(this.ce.cfg.completed);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.completed[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "Completed=" + this.gi.completed[this.selectedIdx];
        }
        if (this.ce.since) {
            g.setColor(this.ce.cfg.since);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.since[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "Since=" + this.gi.since[this.selectedIdx];
        }
        if (this.ce.gccompleted) {
            g.setColor(this.ce.cfg.gccompleted);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)(this.gi.gccompleted[this.selectedIdx] - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
            other = "GCCompleted=" + this.gi.gccompleted[this.selectedIdx];
        }
        if (this.ce.overhead) {
            afOverhead = 0;
            afOverhead = this.ce.isStartPoint(this.selectedIdx) ? 0 : (this.gi.type == 2 ? this.ce.getOverhead(this.selectedIdx) : Math.round(100.0f * (float)this.ce.getCompleted(this.selectedIdx) / (float)(this.ce.getSince(this.selectedIdx) + this.ce.getCompleted(this.selectedIdx))));
            other = "Overhead=" + afOverhead;
            g.setColor(this.ce.cfg.overhead);
            g.drawArc((int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin - 4, this.ce.dimension.height - (int)((float)((long)afOverhead - this.ce.yb2) * this.ce.ratioY2) - 50 - 4, 8, 8, 0, 360);
        }
        g.setColor(Color.gray);
        indiX = (int)((float)(this.gi.timestamp[this.selectedIdx] - this.ce.lx) * this.ce.ratioX) + this.ce.leftMargin;
        g.drawLine(indiX, 20, indiX, this.ce.dimension.height - 50);
        timeString = "Time=" + ChartEngine.timeFormatter.format(new Date(this.gi.timestamp[this.selectedIdx]));
        gcString = "GC=" + this.gi.ngc[this.selectedIdx];
        area = g.getFontMetrics().getStringBounds(timeString, g);
        indiXadjust = area.getWidth() + (double)indiX > (double)(this.ce.dimension.width - this.ce.rightMargin) ? (int)area.getWidth() : 0;
        area = g.getFontMetrics().getStringBounds(gcString, g);
        indiXadjust = area.getWidth() + (double)indiX > (double)(this.ce.dimension.width - this.ce.rightMargin) ? (int)area.getWidth() : 0;
        this.oldX = this.selectedIdx;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        long zoomFocusTS;
        float ratio2;
        int notches = e.getWheelRotation();
        int x = e.getX();
        int y = e.getY();
        if (x >= this.ce.leftMargin && x <= this.ce.dimension.width - this.ce.rightMargin) {
            long dif;
            long zoomFocusTSNew;
            long rx;
            long lx;
            long mx;
            long newZoom;
            ratio2 = ((float)x - (float)this.ce.leftMargin) / ((float)this.ce.dimension.width - (float)this.ce.leftMargin - (float)this.ce.rightMargin);
            zoomFocusTS = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * ratio2);
            if (notches < 0) {
                newZoom = (long)((float)this.ce.zoom / 2.0f);
                if (newZoom >= 1L) {
                    mx = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * 0.5f);
                    lx = mx - newZoom / 2L;
                    rx = mx + newZoom / 2L;
                    zoomFocusTSNew = lx + (long)((float)(rx - lx) * ratio2);
                    dif = zoomFocusTSNew - zoomFocusTS;
                    this.ce.updateLx((mx -= dif) - this.ce.zoom);
                    this.ce.updateRx(mx + this.ce.zoom);
                }
            } else {
                newZoom = this.ce.zoom * 2L;
                if (newZoom < Long.MAX_VALUE) {
                    mx = this.ce.lx + (long)((float)(this.ce.rx - this.ce.lx) * 0.5f);
                    lx = mx - newZoom / 2L;
                    rx = mx + newZoom / 2L;
                    zoomFocusTSNew = lx + (long)((float)(rx - lx) * ratio2);
                    dif = zoomFocusTSNew - zoomFocusTS;
                    this.ce.updateLx((mx -= dif) - this.ce.zoom);
                    this.ce.updateRx(mx + this.ce.zoom);
                }
            }
        }
        System.out.println(y);
        if (!this.ce.cfg.autoY && y >= 20 && y <= this.ce.dimension.height - 50) {
            long diff;
            long yb2;
            long yw2;
            long yb;
            long yw;
            ratio2 = ((float)y - 20.0f) / ((float)this.ce.dimension.height - 20.0f - 50.0f);
            zoomFocusTS = this.ce.yw - (long)((float)(this.ce.yw - this.ce.yb) * ratio2);
            if (notches < 0) {
                float zoomY = this.ce.zoomY * 2.0f;
                float oldZoomY = this.ce.zoomY;
                yw = this.ce.yw;
                yb = this.ce.yb;
                yw2 = this.ce.yw2;
                yb2 = this.ce.yb2;
                diff = (long)((float)((yw - yb) / 2L) / (zoomY / oldZoomY));
                if (diff > 0L) {
                    yw -= diff;
                    yb += diff;
                }
                if ((diff = (long)((float)((yw2 - yb2) / 2L) / (zoomY / oldZoomY))) > 0L) {
                    yw2 -= diff;
                    yb2 += diff;
                }
                long zoomFocusTSNew = yw - (long)((float)(yw - yb) * ratio2);
                long zoomFocusTSNew2 = yw2 - (long)((float)(yw2 - yb2) * ratio2);
                long dif = zoomFocusTSNew - zoomFocusTS;
                this.ce.updateYb(this.ce.yb - dif);
                this.ce.updateYw(this.ce.yw - dif);
                long dif2 = zoomFocusTSNew2 - zoomFocusTS;
                this.ce.updateYb2(this.ce.yb2 - dif2);
                this.ce.updateYw2(this.ce.yw2 - dif2);
            } else {
                float zoomY = this.ce.zoomY / 2.0f;
                float oldZoomY = this.ce.zoomY;
                yw = this.ce.yw;
                yb = this.ce.yb;
                yw2 = this.ce.yw2;
                yb2 = this.ce.yb2;
                diff = (long)((float)(yw - yb) * (zoomY / oldZoomY));
                if (diff > 0L) {
                    yw += diff;
                    yb -= diff;
                } else {
                    ++yw;
                    --yb;
                }
                if (yb < 0L) {
                    yb = 0L;
                }
                if ((diff = (long)((float)(yw2 - yb2) * (zoomY / oldZoomY))) > 0L) {
                    yw2 += diff;
                    yb2 -= diff;
                } else {
                    ++yw2;
                    --yb2;
                }
                if (yb2 < 0L) {
                    yb2 = 0L;
                }
                long zoomFocusTSNew = yw - (long)((float)(yw - yb) * ratio2);
                long zoomFocusTSNew2 = yw2 - (long)((float)(yw2 - yb2) * ratio2);
                long dif = zoomFocusTSNew - zoomFocusTS;
                this.ce.updateYb(this.ce.yb - dif);
                this.ce.updateYw(this.ce.yw - dif);
                long dif2 = zoomFocusTSNew2 - zoomFocusTS;
                this.ce.updateYb2(this.ce.yb2 - dif2);
                this.ce.updateYw2(this.ce.yw2 - dif2);
            }
        }
        if (notches < 0) {
            this.gca.controlPanel.zoomInYButton_ActionPerformed(null);
        } else {
            this.gca.controlPanel.zoomOutYButton_ActionPerformed(null);
        }
    }

    class IvjEventHandler
    implements MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == ChartPanel.this) {
                ChartPanel.this.connEtoC1(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == ChartPanel.this) {
                ChartPanel.this.oldXD = -1;
                ChartPanel.this.pressedX = e.getX();
                ChartPanel.this.previousDx = ChartPanel.this.pressedX;
                ChartPanel.this.pressedY = e.getY();
                ChartPanel.this.previousDy = ChartPanel.this.pressedY;
                ChartPanel.this.pressedIndex = ChartPanel.this.getIndexFromX(ChartPanel.this.pressedX);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == ChartPanel.this) {
                ChartPanel.this.released(e);
            }
        }
    }
}

