/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.GCTable;
import com.ibm.jinwoo.gc.SortableHeaderIcon;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class FileTableModel
extends AbstractTableModel {
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    public static final boolean DESCENDING = true;
    public static final boolean ASCENDING = false;
    public boolean direction = true;
    String[] columnNames = new String[]{"Name", "First Garbage Collection", "Last Garbage Collection", "AF/GC", "Cycle"};
    GCTable hi;
    int sortedColumn = 0;
    public JTableHeader tableHeader;
    public long[][] sortedArrary;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public FileTableModel() {
    }

    public FileTableModel(GCTable h) {
        this.hi = h;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Icon getHeaderIcon(int column, int size) {
        if (column != this.sortedColumn) {
            return null;
        }
        return new SortableHeaderIcon(this.direction, size);
    }

    @Override
    public int getRowCount() {
        return this.hi.gcList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        GCInfo gi = (GCInfo)this.hi.gcList.get(row);
        if (col == 0) {
            return gi.file.getName();
        }
        if (col == 1) {
            return dateFormatter.format(new Date(gi.timestamp[0]));
        }
        if (col == 2) {
            return dateFormatter.format(new Date(gi.timestamp[gi.free.length - 1]));
        }
        if (col == 3) {
            return String.valueOf(numberFormatter.format(gi.numberOfAF)) + "/" + numberFormatter.format(gi.free.length);
        }
        if (col == 4) {
            return numberFormatter.format(gi.numberOfSet);
        }
        return "No Info";
    }

    public void sortColumn(int column, boolean direction) {
        if (column == this.sortedColumn) {
            this.direction = !direction;
            this.fireTableDataChanged();
            return;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                FileTableModel.this.sortColumn(column, FileTableModel.this.direction);
                if (FileTableModel.this.tableHeader != null) {
                    FileTableModel.this.tableHeader.repaint();
                }
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(FileTableModel.this.getHeaderIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            FileTableModel.this.fireTableDataChanged();
        }
    }
}

