/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.Attribute;
import com.ibm.jinwoo.gc.BufferedRandomAccessFile;
import com.ibm.jinwoo.gc.ChartEngine;
import com.ibm.jinwoo.gc.Configuration;
import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.JDialogProgress;
import com.ibm.jinwoo.gc.Messages;
import com.ibm.jinwoo.gc.ThreadHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;

public class FileTask {
    public static final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    public static final ParsePosition pp = new ParsePosition(0);
    public NumberFormat decimalformat = new DecimalFormat();
    public static final String SIG_ATTR = "<attribute name=\"";
    public static final String SIG_VMARG = "<vmarg name=\"";
    public static final String SIG_ATTR_VALUE = "\" value=\"";
    public Configuration cfg;
    String outputHTMLFileName;
    int fileSequenceNumber;
    long fileLocation;
    long lineNumber;
    static final String TLH = "Allocation Failure caused by TLH replenishment";
    public static final String[] MESSAGE_PREFIX_SOV = new String[]{"JVMCI", "JVMCL", "JVMDC", "JVMDBG", "JVMDG", "JVMHP", "JVMLK", "JVMST", "JVMXE", "JVMXM", "UTE"};
    public static final String[] MESSAGE_PREFIX_J9 = new String[]{"JVMDUMP", "JVMJ9VM", "JVMSHRC"};
    public int fileType = 0;
    public long timestamp = 0L;
    public boolean inAF = false;
    public boolean inCON = false;
    public boolean inSG = false;
    public boolean inGC = false;
    public boolean afterGC = false;
    boolean debug = false;
    public static final int GC_TYPE = 1;
    public static final int PROGRAM_TIME = 3;
    public static final int EDEN_BEFORE = 7;
    public static final int EDEN_AFTER = 8;
    public static final int EDEN_CAPA = 9;
    public static final int SUR_BEFORE = 10;
    public static final int SUR_AFTER = 11;
    public static final int SUR_CAPA = 12;
    public static final int OLD_BEFORE = 13;
    public static final int OLD_AFTER = 14;
    public static final int OLD_CAPA = 15;
    public static final int PERM_BEFORE = 16;
    public static final int PERM_AFTER = 17;
    public static final int PERM_CAPA = 18;
    public static final int TIME_SPENT = 20;
    public static final String NOPROBLEM = "<TD>Could not find Java heap problem ";
    public static final String GCTimeLimit = "GC time is exceeding GCTimeLimit of ";
    public static final String CMS = "[CMS-concurrent-";
    public static final String CMS2 = "CMS-initial-mark";
    public static final String CMS3 = "CMS-remark";
    public static final String X_VM_SIGNATURE = "<GCH: vm=";
    public static final String X_RELEASE_SIGNATURE = "<GCH: vmrelease=";
    public static final String X_HOST_SIGNATURE = "<GCH: hostname=";
    public static final String X_OS_SIGNATURE = "<GCH: os=";
    public static final String X_NCPU_SIGNATURE = "<GCH: ncpu=";
    public static final String X_START_TIME_SIGNATURE = "<GCH: starttime=";
    public static final String X_OPT_SIGNATURE = "<GCH: opt";
    public static final String X_ARG_SIGNATURE = "<GCH: arg";
    public static final String X_PERM_RESERVED_SIGNATURE = "<GCH: reservperm=";
    public static final String X_OLD_RESERVED_SIGNATURE = "<GCH: reservold=";
    public static final String X_NEW_RESERVED_SIGNATURE = "<GCH: reservnew=";
    public static final String X_EOL_SIGNATURE = " >";
    public static final String X_GC_START_SIGNATURE = "<GC:";
    public static final String S_GC_END_SIGNATURE = "secs]";
    public static final String S_DEFNEW_SIGNATURE = "[DefNew:";
    public static final String S_GC_START_SIGNATURE = "[GC";
    public static final String S_PARNEW_START_SIGNATURE = "[ParNew";
    public static final String S_FULLGC_START_SIGNATURE = "[Full GC";
    public static final String S_PRINTHEAP_BEFORE_START_SIGNATURE = "{Heap before GC invocations=";
    public static final String S_PRINTHEAP_BEFORE_START_SIGNATURE2 = "{Heap before gc invocations=";
    public static final String S_PRINTHEAP_AFTER_START_SIGNATURE = "Heap after GC invocations=";
    public static final String S_PRINTHEAP_AFTER_START_SIGNATURE2 = "Heap after gc invocations=";
    public static final String S_UNLOADING_CLASS_SIGNATURE = "[Unloading class ";
    public static final String S_DUP_FULL_SIGNATURE = "GC[Full GC";
    public static final String S_DUP_MINOR_SIGNATURE = "GC[GC";
    public String nextLine = null;
    public static final String VERBOSEGC_START_SIGNATURE = "<verbosegc";
    public static final String VERBOSEGC_END_SIGNATURE = "</verbosegc";
    public static final String GC_END_SIGNATURE = "</gc>";
    public static final String AF_END_SIGNATURE = "</af>";
    public static final String SG_END_SIGNATURE = "</sys>";
    public static final String CON_END_SIGNATURE = "</con>";
    public static final String GC_END_SIGNATURE2 = "</gc-end>";
    public static final String AF_END_SIGNATURE2 = "<af-end>";
    public static final String SG_END_SIGNATURE2 = "</sys-end>";
    public static final String CON_END_SIGNATURE2 = "</con-end>";
    public static final String XML_SIGNATURE = "<?xml version=\"";
    public static final String AF_SIGNATURE = "<af type=";
    public static final String AF_SIGNATURE2 = "<af-start id=";
    public static final String SG_SIGNATURE2 = "<sys-start id=";
    public static final String GC_SIGNATURE2 = "<gc-start id=\"";
    public static final String CON_SIGNATURE2 = "<con-start event=\"collection\"";
    public static final String CON_SIGNATURE3 = "<concurrent-collection-start id=";
    public static final String CON_SIGNATURE = "<con event=\"collection\"";
    public static final String GC_SIGNATURE = "<gc type=\"";
    public static final String TENURED_SIGNATURE = "<tenured freebytes=\"";
    public static final String SOA_SIGNATURE = "<soa freebytes=\"";
    public static final String LOA_SIGNATURE = "<loa freebytes=\"";
    public static final String NURSERY_SIGNATURE = "<nursery freebytes=\"";
    public static final String TENURED_SIGNATURE2 = "tenure\" free=\"";
    public static final String SOA_SIGNATURE2 = "soa\" free=\"";
    public static final String LOA_SIGNATURE2 = "loa\" free=\"";
    public static final String NURSERY_SIGNATURE2 = "nursery\" free=\"";
    public static final String TOTALBYTES_SIGNATURE2 = "\" total=\"";
    public static final String TOTALBYTES_SIGNATURE = "\" totalbytes=\"";
    public static final String MARK_SIGNATURE = "<timesms mark=\"";
    public static final String SWEEP_SIGNATURE = "\" sweep=\"";
    public static final String COMPACT_SIGNATURE = "\" compact=\"";
    public static final String TOTAL_SIGNATURE = "\" total=\"";
    public static final String GC_OP = "<gc-op id=";
    public static final String GC_END = "<gc-end id=";
    public static final String MARK_SIGNATURE2 = "type=\"mark\" timems=\"";
    public static final String SWEEP_SIGNATURE2 = "type=\"sweep\" timems=\"";
    public static final String COMPACT_SIGNATURE2 = "type=\"compact\" timems=\"";
    public static final String TOTAL_SIGNATURE2 = "\" durationms=\"";
    public static final String TIMEMS_END_SIGNATURE = "\" contextid=";
    public static final String TOTALID_SIGNATURE = "\" totalid=\"";
    public static final String PERCENT_SIGNATURE = "\" percent=\"";
    public static final String MIN_SIGNATURE = "<minimum requested_bytes=\"";
    public static final String MIN_SIGNATURE2 = "\" totalBytesRequested=\"";
    public static final String EOL_SIGNATURE = "\">";
    public static final String EOLS_SIGNATURE = "\" />";
    public static final String ID_SIGNATURE = "\" id=\"";
    public static final String ID_SIGNATURE2 = " id=\"";
    public static final String TIMESTAMP_SIGNATURE = "\" timestamp=\"";
    public static final String INTERVAL_SIGNATURE = "\" intervalms=\"";
    public static final String TOTALMS_SIGNATURE = "<time totalms=\"";
    public static final String SG_SIGNATURE = "<sys id=";
    public static final String OOM_SIGNATURE1 = "JVMDUMP006I Processing Dump Event";
    public static final String OOM_SIGNATURE2 = "\"java/lang/OutOfMemoryError\"";
    public static final String OOM_SIGNATURE3 = "JVMDUMP006I Processing dump event";
    public static final String PANIC_SIGNATURE = "*** panic: ";
    public static final String EXCESSIVE_GC = "excessive gc activity detected";
    public static final String OOMsignature = "]: managing allocation failure, action=6 (";
    public static final String BEFOREsignature = "]: managing allocation failure, action=";
    public static final String USER_ACTION_EXCESSIVEGC_J9 = "Assess required Java heap and increase maximum Java heap size using -Xmx option.<BR>For more information on the JVM's memory management please see Chapter 2 of the JVM Diagnostic Guide available at :  http://www.ibm.com/developerworks/java/jdk/diagnosis/";
    public static final String USER_ACTION_TOO_LARGE_REQUEST = "It's recommended to split  huge Java heap requests into smaller ones for better performance and memory management.<BR>The current thread in the javacore that was generated at the time of OutOfMemoryError might have the stack trace of the large object request<BR><BR>On IBM\u00ae 1.4.2 Sovereign SDK Service Release 4 and later 1.4.2 SDK, it's possible to identify the Java stack of a thread making an allocation request larger than a certain size.<BR>Please refer to the following document for more details:<BR>How to identify the Java stack of a thread making an allocation request larger than a certain size<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21236523<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB<BR>Please refer to the following document for more details:<BR>How to allocate large objects into Large Object Area on IBM SDK 1.4.2 SR1 and later<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21236509";
    public static final String USER_ACTION_EXHAUSTION = "Assess required Java heap and increase maximum Java heap size using -Xmx option.<BR>If it does not help, analyze Java heap dump with IBM HeapAnalyzer (http://www.alphaworks.ibm.com/tech/heapanalyzer)";
    public static final String USER_ACTION_EXHAUSTION_SOA = "If your -Xloratio option is set too high, you may want to reduce the size of the Large Object Area.<BR>Otherwise, assess required Java heap and increase maximum Java heap size using -Xmx option.<BR>If it does not help, analyze Java heap dump with IBM HeapAnalyzer (http://www.alphaworks.ibm.com/tech/heapanalyzer)";
    public static final String USER_ACTION_EXHAUSTION_SOA_J9 = "If your -Xloamaximum option is set too high, you may want to reduce the size of the Large Object Area.<BR>Otherwise, assess required Java heap and increase maximum Java heap size using -Xmx option.<BR>If it does not help, analyze Java heap dump with IBM HeapAnalyzer (http://www.alphaworks.ibm.com/tech/heapanalyzer)";
    public static final String USER_ACTION_EXHAUSTION_LOA = "If your -Xloratio option is set too low, you may want to increase the size of the Large Object Area.<BR>Otherwise, assess required Java heap and increase maximum Java heap size using -Xmx option. If this JVM allows you to increase the maximum size of large object area, you might want to try it as well.<BR>If it does not help, analyze Java heap dump with IBM HeapAnalyzer (http://www.alphaworks.ibm.com/tech/heapanalyzer)";
    public static final String USER_ACTION_EXHAUSTION_LOA_J9 = "If your -Xloamaximum option is set too low, you may want to increase the size of the Large Object Area.<BR>Otherwise, assess required Java heap and increase maximum Java heap size using -Xmx option. If this JVM allows you to increase the maximum size of large object area, you might want to try it as well.<BR>If it does not help, analyze Java heap dump with IBM HeapAnalyzer (http://www.alphaworks.ibm.com/tech/heapanalyzer)";
    public static final String USER_ACTION_NONE = "There's no recommendations. Please contact IBM for further assistance if there's no error messages.";
    public static final String USER_ACTION_FRAGMENTATION_J9 = "There's no known recommendations. Please contact IBM for further assistance.";
    public static final String USER_ACTION_FRAGMENTATION = "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB";
    public static final String USER_ACTION_FRAGMENTATION_SOA = "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB";
    public static final String USER_ACTION_FRAGMENTATION_LOA = "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB";
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    static SimpleDateFormat formatter6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    static SimpleDateFormat formatterUS = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    static SimpleDateFormat formatter2 = new SimpleDateFormat("MMM d HH:mm:ss yyyy");
    static SimpleDateFormat formatter2US = new SimpleDateFormat("MMM d HH:mm:ss yyyy", Locale.US);
    static SimpleDateFormat formatterX = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
    static SimpleDateFormat formatterSun = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public GCAnalyzer ha = null;
    public File[] file = null;
    private JDialogProgress jp = null;
    GCInfo gi = null;

    public FileTask(GCAnalyzer h, File[] f) {
        this.file = f;
        this.ha = h;
        this.lengthOfTask = 1000;
    }

    public FileTask(GCAnalyzer h, File[] f, int fileSequenceNumber, String outputHTMLFileName, Configuration cfg) {
        this.file = f;
        this.ha = h;
        this.cfg = cfg;
        this.outputHTMLFileName = outputHTMLFileName;
        this.lengthOfTask = 1000;
        this.fileSequenceNumber = fileSequenceNumber;
    }

    public FileTask(GCAnalyzer h, File[] f, JDialogProgress j) {
        this.file = f;
        this.ha = h;
        this.jp = j;
        this.lengthOfTask = 100;
    }

    public FileTask(GCAnalyzer h, File[] f, JDialogProgress j, int fileType) {
        this.file = f;
        this.ha = h;
        this.jp = j;
        this.lengthOfTask = 100;
        this.fileType = fileType;
    }

    int findMessageJ9(String str) {
        if (str == null) {
            return -1;
        }
        int i = 0;
        while (i < Messages.message50.length) {
            if (str.startsWith(Messages.message50[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int findMessageSov(String str) {
        if (str == null) {
            return -1;
        }
        if (str.startsWith(PANIC_SIGNATURE)) {
            if (str.length() > PANIC_SIGNATURE.length()) {
                str = str.substring(PANIC_SIGNATURE.length());
            } else {
                return -1;
            }
        }
        int i = 0;
        while (i < Messages.message142.length) {
            if (str.startsWith(Messages.message142[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String generateChart(GCInfo gi, int type) {
        String returnString = "";
        BufferedImage bi = new BufferedImage(this.cfg.width, this.cfg.height, 2);
        ChartEngine ce = new ChartEngine(gi, this.cfg, 0, gi.free.length - 1, true, String.valueOf(this.outputHTMLFileName) + "_" + this.fileSequenceNumber, null, bi);
        Graphics g = bi.getGraphics();
        if (type == 0) {
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            returnString = String.valueOf(returnString) + "<BR>Used Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
            ce.used = false;
            ce.free = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.free = false;
            ce.total = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.total = false;
            ce.usedBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Used Java Heap Size Before Garbage Collection<BR>" + ce.drawChart(g);
            ce.usedBefore = false;
            ce.freeBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.freeBefore = false;
            ce.totalBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.totalBefore = false;
            ce.requested = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.requested = false;
            ce.since = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
            ce.since = false;
            ce.completed = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.resetDrawChart();
            ce.completed = false;
            ce.mark = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.resetDrawChart();
            ce.mark = false;
            ce.sweep = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.resetDrawChart();
            ce.sweep = false;
            ce.compact = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.resetDrawChart();
            ce.compact = false;
            ce.gccompleted = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
            ce.gccompleted = false;
            ce.overhead = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
            ce.overhead = false;
        } else if (type == 1) {
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            returnString = String.valueOf(returnString) + "<BR>Used Tenured Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
            ce.used = false;
            ce.free = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Tenured Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.free = false;
            ce.total = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Tenured Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.total = false;
            ce.usedN = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Used Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.usedN = false;
            ce.freeN = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.freeN = false;
            ce.totalN = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.totalN = false;
            ce.usedBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Used Tenured Java Heap Size Before Garbage Collection<BR>" + ce.drawChart(g);
            ce.usedBefore = false;
            ce.freeBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Tenured Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.freeBefore = false;
            ce.totalBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Tenured Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.totalBefore = false;
            ce.usedNBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Used Nursery Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.usedNBefore = false;
            ce.freeNBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free Nursery Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.freeNBefore = false;
            ce.totalNBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total Nursery Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.totalNBefore = false;
            ce.requested = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.requested = false;
            ce.since = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
            ce.since = false;
            ce.completed = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.resetDrawChart();
            ce.completed = false;
            ce.mark = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.resetDrawChart();
            ce.mark = false;
            ce.sweep = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.resetDrawChart();
            ce.sweep = false;
            ce.compact = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.resetDrawChart();
            ce.compact = false;
            ce.gccompleted = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
            ce.gccompleted = false;
            ce.overhead = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
            ce.overhead = false;
        } else {
            String area = "Tenured";
            if (gi.simpleSolaris) {
                area = "Tenured+New";
            }
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            returnString = String.valueOf(returnString) + "<BR>Used " + area + " Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
            ce.used = false;
            ce.free = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free " + area + " Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.free = false;
            ce.total = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total " + area + " Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
            ce.total = false;
            if (!gi.simpleSolaris) {
                ce.usedN = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Used New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.usedN = false;
                ce.freeN = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Free New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.freeN = false;
                ce.totalN = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Total New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.totalN = false;
                ce.usedPAfter = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Used Permanent Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.usedPAfter = false;
                ce.freePAfter = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Free Permanent Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.freePAfter = false;
                ce.totalP = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Total Permanent Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.totalP = false;
            }
            ce.usedBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Used " + area + " Java Heap Size Before Garbage Collection<BR>" + ce.drawChart(g);
            ce.usedBefore = false;
            ce.freeBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Free " + area + " Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.freeBefore = false;
            ce.totalBefore = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Total " + area + " Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
            ce.totalBefore = false;
            if (!gi.simpleSolaris) {
                ce.usedNBefore = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Used New Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
                ce.usedNBefore = false;
                ce.freeNBefore = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Free New Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
                ce.freeNBefore = false;
                ce.totalNBefore = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Total New Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
                ce.totalNBefore = false;
                ce.usedPBefore = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Used Permanent Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
                ce.usedPBefore = false;
                ce.freePBefore = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Free Permanent Java Heap Size Before Garbage Collection<BR>" + ce.resetDrawChart();
                ce.freePBefore = false;
            }
            if (!gi.noTimestamp) {
                ce.since = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
                ce.since = false;
            }
            if (gi.rangePerm != null) {
                ce.maxPerm = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Maximum Permanent Java Heap Size<BR>" + ce.resetDrawChart();
                ce.maxPerm = false;
                ce.maxTen = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Maximum Tenured Java Heap Size<BR>" + ce.resetDrawChart();
                ce.maxTen = false;
            }
            ce.gccompleted = true;
            returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
            ce.gccompleted = false;
            if (!gi.noTimestamp) {
                ce.overhead = true;
                returnString = String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
                ce.overhead = false;
            }
        }
        return returnString;
    }

    public String generateChart(GCInfo gi, int type, String option) {
        if (option == null) {
            return this.generateChart(gi, type);
        }
        if (this.has("B", option = option.toUpperCase())) {
            return this.generateChart2(gi, type, option);
        }
        String returnString = "";
        BufferedImage bi = new BufferedImage(this.cfg.width, this.cfg.height, 2);
        ChartEngine ce = new ChartEngine(gi, this.cfg, 0, gi.free.length - 1, true, String.valueOf(this.outputHTMLFileName) + "_" + this.fileSequenceNumber, null, bi);
        Graphics g = bi.getGraphics();
        boolean first = true;
        ce.used = false;
        if (type == 0) {
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>Used Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
                ce.used = false;
                first = false;
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Free Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Free Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.free = false;
                first = false;
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Total Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Total Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.total = false;
                first = false;
            }
            if (this.has("R", option)) {
                ce.requested = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.requested = false;
                first = false;
            }
            if (this.has("I", option)) {
                ce.since = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
                ce.since = false;
                first = false;
            }
            if (this.has("A", option)) {
                ce.completed = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.resetDrawChart();
                ce.completed = false;
                first = false;
            }
            if (this.has("M", option)) {
                ce.mark = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.resetDrawChart();
                ce.mark = false;
                first = false;
            }
            if (this.has("S", option)) {
                ce.sweep = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.resetDrawChart();
                ce.sweep = false;
                first = false;
            }
            if (this.has("C", option)) {
                ce.compact = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.resetDrawChart();
                ce.compact = false;
                first = false;
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
                ce.gccompleted = false;
                first = false;
            }
            if (this.has("O", option)) {
                ce.overhead = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
                ce.overhead = false;
                first = false;
            }
        } else if (type == 1) {
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>Used Tenured Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
                ce.used = false;
                first = false;
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Free Tenured Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Free Tenured Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.free = false;
                first = false;
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Total Tenured Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Total Tenured Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.total = false;
                first = false;
            }
            if (this.has("N", option)) {
                ce.usedN = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Used Nursery Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Used Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.usedN = false;
                first = false;
            }
            if (this.has("Q", option)) {
                ce.freeN = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Free Nursery Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Free Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.freeN = false;
                first = false;
            }
            if (this.has("Y", option)) {
                ce.totalN = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Total Nursery Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Total Nursery Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.totalN = false;
                first = false;
            }
            if (this.has("R", option)) {
                ce.requested = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Requested Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.requested = false;
                first = false;
            }
            if (this.has("I", option)) {
                ce.since = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
                ce.since = false;
                first = false;
            }
            if (this.has("A", option)) {
                ce.completed = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Allocation Failure Duration<BR>" + ce.resetDrawChart();
                ce.completed = false;
                first = false;
            }
            if (this.has("M", option)) {
                ce.mark = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Mark Phase Duration<BR>" + ce.resetDrawChart();
                ce.mark = false;
                first = false;
            }
            if (this.has("S", option)) {
                ce.sweep = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Sweep Phase Duration<BR>" + ce.resetDrawChart();
                ce.sweep = false;
                first = false;
            }
            if (this.has("C", option)) {
                ce.compact = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Compact Phase Duration<BR>" + ce.resetDrawChart();
                ce.compact = false;
                first = false;
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
                ce.gccompleted = false;
                first = false;
            }
            if (this.has("O", option)) {
                ce.overhead = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
                ce.overhead = false;
                first = false;
            }
        } else {
            String area = "Tenured";
            if (gi.simpleSolaris) {
                area = "Tenured+New";
            }
            returnString = String.valueOf(returnString) + "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR>";
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>Used " + area + " Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g);
                ce.used = false;
                first = false;
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Free " + area + " Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Free " + area + " Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.free = false;
                first = false;
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Total " + area + " Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart() : String.valueOf(returnString) + "<BR><BR>Total " + area + " Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                ce.total = false;
                first = false;
            }
            if (!gi.simpleSolaris) {
                if (this.has("N", option)) {
                    ce.usedN = true;
                    returnString = first ? String.valueOf(returnString) + "<BR><BR>Used New Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Used New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                    ce.usedN = false;
                    first = false;
                }
                if (this.has("Q", option)) {
                    ce.freeN = true;
                    returnString = first ? String.valueOf(returnString) + "<BR><BR>Free New Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Free New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                    ce.freeN = false;
                    first = false;
                }
                if (this.has("Y", option)) {
                    ce.totalN = true;
                    returnString = first ? String.valueOf(returnString) + "<BR><BR>Total New Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Total New Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                    ce.totalN = false;
                    first = false;
                }
                if (this.has("P", option)) {
                    ce.usedPAfter = true;
                    returnString = first ? String.valueOf(returnString) + "<BR><BR>Used Permanent Java Heap Size After Garbage Collection<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Used Permanent Java Heap Size After Garbage Collection<BR>" + ce.resetDrawChart();
                    ce.usedPAfter = false;
                    first = false;
                }
            }
            if (!gi.noTimestamp && this.has("I", option)) {
                ce.since = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Interval between Garbage Collections<BR>" + ce.resetDrawChart();
                ce.since = false;
                first = false;
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Duration<BR>" + ce.resetDrawChart();
                ce.gccompleted = false;
                first = false;
            }
            if (!gi.noTimestamp && this.has("O", option)) {
                ce.overhead = true;
                returnString = first ? String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.drawChart(g) : String.valueOf(returnString) + "<BR><BR>Garbage Collection Overhead (%)<BR>" + ce.resetDrawChart();
                ce.overhead = false;
                first = false;
            }
        }
        return returnString;
    }

    public String generateChart2(GCInfo gi, int type, String option) {
        if (option == null) {
            return this.generateChart(gi, type);
        }
        option = option.toUpperCase();
        String returnString = "";
        BufferedImage bi = new BufferedImage(this.cfg.width, this.cfg.height, 2);
        ChartEngine ce = new ChartEngine(gi, this.cfg, 0, gi.free.length - 1, true, String.valueOf(this.outputHTMLFileName) + "_" + this.fileSequenceNumber, null, bi);
        Graphics g = bi.getGraphics();
        ce.used = false;
        ce.free = false;
        ce.total = false;
        ce.requested = false;
        ce.since = false;
        ce.completed = false;
        ce.mark = false;
        ce.sweep = false;
        ce.compact = false;
        ce.gccompleted = false;
        ce.overhead = false;
        ce.usedN = false;
        ce.freeN = false;
        ce.totalN = false;
        ce.usedPAfter = false;
        if (type == 0) {
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.used) + "Used Java Heap Size After Garbage Collection";
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.free) + "Free Java Heap Size After Garbage Collection";
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.total) + "Total Java Heap Size After Garbage Collection";
            }
            if (this.has("R", option)) {
                ce.requested = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.requested) + "Requested Java Heap Size After Garbage Collection";
            }
            if (this.has("I", option)) {
                ce.since = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.since) + "Interval between Garbage Collections";
            }
            if (this.has("A", option)) {
                ce.completed = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.completed) + "Allocation Failure Duration";
            }
            if (this.has("M", option)) {
                ce.mark = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.mark) + "Mark Phase Duration";
            }
            if (this.has("S", option)) {
                ce.sweep = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.sweep) + "Sweep Phase Duration";
            }
            if (this.has("C", option)) {
                ce.compact = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.compact) + "Compact Phase Duration";
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.gccompleted) + "Garbage Collection Duration";
            }
            if (this.has("O", option)) {
                ce.overhead = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.overhead) + "Garbage Collection Overhead (%)";
            }
        } else if (type == 1) {
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.used) + "Used Tenured Java Heap Size After Garbage Collection";
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.free) + "Free Tenured Java Heap Size After Garbage Collection";
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.total) + "Total Tenured Java Heap Size After Garbage Collection";
            }
            if (this.has("N", option)) {
                ce.usedN = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.usedN) + "Used Nursery Java Heap Size After Garbage Collection";
            }
            if (this.has("Q", option)) {
                ce.freeN = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.freeN) + "Free Nursery Java Heap Size After Garbage Collection";
            }
            if (this.has("Y", option)) {
                ce.totalN = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.totalN) + "Total Nursery Java Heap Size After Garbage Collection";
            }
            if (this.has("R", option)) {
                ce.requested = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.requested) + "Requested Java Heap Size After Garbage Collection";
            }
            if (this.has("I", option)) {
                ce.since = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.since) + "Interval between Garbage Collections";
            }
            if (this.has("A", option)) {
                ce.completed = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.completed) + "Allocation Failure Duration";
            }
            if (this.has("M", option)) {
                ce.mark = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.mark) + "Mark Phase Duration";
            }
            if (this.has("S", option)) {
                ce.sweep = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.sweep) + "Sweep Phase Duration";
            }
            if (this.has("C", option)) {
                ce.compact = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.compact) + "Compact Phase Duration";
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.gccompleted) + "Garbage Collection Duration";
            }
            if (this.has("O", option)) {
                ce.overhead = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.overhead) + "Garbage Collection Overhead (%)";
            }
        } else {
            String area = "Tenured";
            if (gi.simpleSolaris) {
                area = "Tenured+New";
            }
            if (this.has("U", option)) {
                ce.used = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.used) + "Used " + area + " Java Heap Size After Garbage Collection";
            }
            if (this.has("F", option)) {
                ce.free = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.free) + "Free " + area + " Java Heap Size After Garbage Collection";
            }
            if (this.has("T", option)) {
                ce.total = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.total) + "Total " + area + " Java Heap Size After Garbage Collection";
            }
            if (!gi.simpleSolaris) {
                if (this.has("N", option)) {
                    ce.usedN = true;
                    returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.usedN) + "Used New Java Heap Size After Garbage Collection";
                }
                if (this.has("Q", option)) {
                    ce.freeN = true;
                    returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.freeN) + "Free New Java Heap Size After Garbage Collection";
                }
                if (this.has("Y", option)) {
                    ce.totalN = true;
                    returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.totalN) + "Total New Java Heap Size After Garbage Collection";
                }
                if (this.has("P", option)) {
                    ce.usedPAfter = true;
                    returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.usedPAfter) + "Used Permanent Java Heap Size After Garbage Collection";
                }
            }
            if (!gi.noTimestamp && this.has("I", option)) {
                ce.since = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.since) + "Interval between Garbage Collections";
            }
            if (this.has("D", option)) {
                ce.gccompleted = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.gccompleted) + "Garbage Collection Duration";
            }
            if (!gi.noTimestamp && this.has("O", option)) {
                ce.overhead = true;
                returnString = String.valueOf(returnString) + "<BR>" + this.getHTMLColor(this.cfg.overhead) + "Garbage Collection Overhead (%)";
            }
        }
        return "<BR><B>Java Garbage Collection Activity Analysis Chart Report</B><BR><BR>" + ce.drawChart(g) + "<BR>" + returnString;
    }

    String getColumn(String s, int column) {
        int start = -1;
        int end = -1;
        if (column <= 0) {
            return null;
        }
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ' ') {
                --column;
                if (i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                    ++i;
                }
            }
            if (column == 0) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == -1) {
            return null;
        }
        end = s.substring(start + 1).indexOf(" ");
        if (end < 0) {
            return null;
        }
        return s.substring(start + 1, start + 1 + end);
    }

    long getCompleted(int idx) {
        if (this.gi.completed[idx] != 0L) {
            return this.gi.completed[idx];
        }
        if (this.gi.gccompleted[idx] == 0L) {
            return 0L;
        }
        int i = idx;
        while (i < this.gi.free.length) {
            if (this.gi.completed[i] != 0L) {
                return this.gi.completed[i];
            }
            ++i;
        }
        return 0L;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getHTMLColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        String R = r <= 15 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String G = g <= 15 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String B = b <= 15 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        return "<font color=\"#" + R + G + B + "\"> ----</font>";
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public int getOverhead(int idx) {
        if (this.isStartPoint(idx)) {
            return 0;
        }
        if (this.gi.type == 0 && this.gi.naf[idx] == 0) {
            return 0;
        }
        if (this.gi.type == 0) {
            if (this.gi.since[idx] + this.gi.completed[idx] == 0L) {
                return 0;
            }
            return (int)((float)this.gi.completed[idx] * 100.0f / (float)(this.gi.since[idx] + this.gi.completed[idx]));
        }
        if (this.gi.since[idx] + this.gi.gccompleted[idx] == 0L) {
            return 0;
        }
        return (int)((float)this.gi.gccompleted[idx] * 100.0f / (float)(this.gi.since[idx] + this.gi.gccompleted[idx]));
    }

    public int getOverhead(int x, int y) {
        long gcCompletedAll = 0L;
        int i = x;
        while (i <= y) {
            gcCompletedAll += this.gi.gccompleted[i];
            ++i;
        }
        float nonZero = this.gi.timestamp[y] - this.gi.timestamp[x] + this.gi.gccompleted[y];
        if (nonZero == 0.0f) {
            return 0;
        }
        return Math.round((float)gcCompletedAll * 100.0f / nonZero);
    }

    long getRequested(int idx) {
        if (this.gi.af[idx] == 0L) {
            int i = idx;
            while (i >= 0) {
                if (this.gi.af[i] != 0L) {
                    return this.gi.af[i];
                }
                --i;
            }
        } else {
            return this.gi.af[idx];
        }
        return 0L;
    }

    long getRequestedJ9(int idx) {
        return this.gi.af[idx];
    }

    long getSince(int idx) {
        if (this.gi.since[idx] != 0L) {
            return this.gi.since[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.gi.since[i] != 0L && this.gi.af[i] != 0L) {
                return this.gi.since[i];
            }
            --i;
        }
        return 0L;
    }

    String getStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        String ls = "<BR>";
        StackTraceElement[] st = e.getStackTrace();
        String report = String.valueOf(e.toString()) + ls;
        int i = 0;
        while (i < st.length) {
            report = String.valueOf(report) + "at " + st[i].toString() + ls;
            ++i;
        }
        return report;
    }

    public static long getStringToLong(String ad) throws NumberFormatException {
        int firstDigit;
        if (ad == null) {
            throw new NumberFormatException();
        }
        int max = ad.length();
        if (max == 18 && (firstDigit = Character.digit(ad.charAt(2), 16)) >= 8) {
            int digit = 0;
            double result = 0.0;
            int i = 2;
            byte b = 0;
            while (i < max) {
                digit = Character.digit(ad.charAt(i++), 16);
                b = (byte)digit;
                b = (byte)(b | 0xFFFFFFF0);
                b = ~b;
                result *= 16.0;
                result += (double)b;
            }
            return (long)(-1.0 * (result += 1.0));
        }
        int digit = 0;
        double result = 0.0;
        int i = 2;
        boolean b = false;
        while (i < max) {
            digit = Character.digit(ad.charAt(i++), 16);
            result *= 16.0;
            result += (double)digit;
        }
        return (long)result;
    }

    String getTimeStamp(int x, int y, String del) {
        return String.valueOf(formatter.format(new Date(this.gi.timestamp[x]))) + del + formatter.format(new Date(this.gi.timestamp[y]));
    }

    String getTrend(int x, int y) {
        String ts = "between " + formatter.format(new Date(this.gi.timestamp[x])) + " and " + formatter.format(new Date(this.gi.timestamp[y]));
        float alpha = 0.9f;
        float st_1 = this.gi.total[x] - this.gi.free[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.total[x] - this.gi.free[x];
        float mape = 0.0f;
        int nan = 0;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (this.gi.total[i] == this.gi.free[i]) {
                ++nan;
            } else {
                if (maxUsed < this.gi.total[i] - this.gi.free[i]) {
                    maxUsed = this.gi.total[i] - this.gi.free[i];
                }
                st1 = alpha * (float)(this.gi.total[i] - this.gi.free[i]) + (1.0f - alpha) * st_1;
                st2 = alpha * st1 + (1.0f - alpha) * st2_1;
                st_1 = st1;
                st2_1 = st2;
                mape += Math.abs((float)(this.gi.total[i] - this.gi.free[i]) - st2) / (float)(this.gi.total[i] - this.gi.free[i]);
            }
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x - nan)) > 0.5) {
            return "Trend model not reliable (percentage error is larger than 50%) " + ts;
        }
        float number = doub;
        long max = 0L;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "Trend ratio(%): 0 (Recommended max heap size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + " " + ts;
            }
            if (number > 4.0E9f) {
                return "Trend ratio(%): over 100 with percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + " " + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (this.gi.total[y] == this.gi.free[y]) {
            return "";
        }
        if (max < this.gi.total[y] - this.gi.free[y]) {
            return "Trend ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " (Recommended max heap size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
        }
        return "Trend ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
    }

    String getTrendAnalysis(int x, int y) {
        if (x == y) {
            return "NOTHING";
        }
        String ts = "";
        float alpha = 0.9f;
        float st_1 = this.gi.total[x] - this.gi.free[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.total[x] - this.gi.free[x];
        float mape = 0.0f;
        int nan = 0;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (this.gi.total[i] == this.gi.free[i]) {
                ++nan;
            } else {
                if (maxUsed < this.gi.total[i] - this.gi.free[i]) {
                    maxUsed = this.gi.total[i] - this.gi.free[i];
                }
                st1 = alpha * (float)(this.gi.total[i] - this.gi.free[i]) + (1.0f - alpha) * st_1;
                st2 = alpha * st1 + (1.0f - alpha) * st2_1;
                st_1 = st1;
                st2_1 = st2;
                mape += Math.abs((float)(this.gi.total[i] - this.gi.free[i]) - st2) / (float)(this.gi.total[i] - this.gi.free[i]);
            }
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x - nan)) > 0.5) {
            return "No action required" + ts;
        }
        float number = doub;
        long max = 0L;
        float threshold = 100.0f * (float)maxUsed;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "No action required. Recommended maximum Java heap size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + ")" + ts;
            }
            if (number > threshold) {
                return "There seems to be a rapid increase in Java heap usage (percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + ")" + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (this.gi.total[y] == this.gi.free[y]) {
            return "";
        }
        if (max < this.gi.total[y] - this.gi.free[y]) {
            return "No action required. Recommended maximum Java heap size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
        }
        return "There seems to be a steady increase in Java heap usage. ( ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
    }

    String getTrendAnalysisPerm(int x, int y) {
        String ts = "";
        float alpha = 0.9f;
        float st_1 = this.gi.totalPermBefore[x] - this.gi.freePerm[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.totalPermBefore[x] - this.gi.freePerm[x];
        float mape = 0.0f;
        int nan = 0;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (this.gi.totalPermBefore[i] == this.gi.freePerm[i]) {
                ++nan;
            } else {
                if (maxUsed < this.gi.totalPermBefore[i] - this.gi.freePerm[i]) {
                    maxUsed = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                }
                st1 = alpha * (float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]) + (1.0f - alpha) * st_1;
                st2 = alpha * st1 + (1.0f - alpha) * st2_1;
                st_1 = st1;
                st2_1 = st2;
                mape += Math.abs((float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]) - st2) / (float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]);
            }
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x - nan)) > 0.5) {
            return "No action required for Permanent Generation" + ts;
        }
        float number = doub;
        long max = 0L;
        float threshold = 100.0f * (float)maxUsed;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "No action required. Recommended maximum Permanent Generation size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + ")" + ts;
            }
            if (number > threshold) {
                return "There seems to be a rapid increase in Permanent Generation heap usage (percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + ")" + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (this.gi.totalPermBefore[y] == this.gi.freePerm[y]) {
            return "";
        }
        if (max < this.gi.totalPermBefore[y] - this.gi.freePerm[y]) {
            return "No action required. Recommended maximum Permanent Generation size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
        }
        return "There seems to be a steady increase in Permanent Generation heap usage. ( ratio(%): " + 100.0f * (float)(max - (this.gi.totalPermBefore[y] - this.gi.freePerm[y])) / (float)(this.gi.totalPermBefore[y] - this.gi.freePerm[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
    }

    String getTrendPerm(int x, int y) {
        String ts = "between " + formatter.format(new Date(this.gi.timestamp[x])) + " and " + formatter.format(new Date(this.gi.timestamp[y]));
        float alpha = 0.9f;
        float st_1 = this.gi.totalPermBefore[x] - this.gi.freePerm[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.totalPermBefore[x] - this.gi.freePerm[x];
        float mape = 0.0f;
        int nan = 0;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (this.gi.totalPermBefore[i] == this.gi.freePerm[i]) {
                ++nan;
            } else {
                if (maxUsed < this.gi.totalPermBefore[i] - this.gi.freePerm[i]) {
                    maxUsed = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                }
                st1 = alpha * (float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]) + (1.0f - alpha) * st_1;
                st2 = alpha * st1 + (1.0f - alpha) * st2_1;
                st_1 = st1;
                st2_1 = st2;
                mape += Math.abs((float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]) - st2) / (float)(this.gi.totalPermBefore[i] - this.gi.freePerm[i]);
            }
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x - nan)) > 0.5) {
            return "Trend model not reliable (percentage error is larger than 50%) " + ts;
        }
        float number = doub;
        long max = 0L;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "Trend ratio(%): 0 (Recommended Max Perm size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + " " + ts;
            }
            if (number > 4.0E9f) {
                return "Trend ratio(%): over 100 with percentage error(%): " + 100.0f * mape / (float)(y - x - nan) + " " + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (this.gi.totalPermBefore[y] == this.gi.freePerm[y]) {
            return "";
        }
        if (max < this.gi.totalPermBefore[y] - this.gi.freePerm[y]) {
            return "Trend ratio(%) of Permanent Generation : " + 100.0f * (float)(max - (this.gi.totalPermBefore[y] - this.gi.freePerm[y])) / (float)(this.gi.totalPermBefore[y] - this.gi.freePerm[y]) + " (Recommended max heap size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
        }
        return "Trend ratio(%) of Permanent Generation : " + 100.0f * (float)(max - (this.gi.totalPermBefore[y] - this.gi.freePerm[y])) / (float)(this.gi.totalPermBefore[y] - this.gi.freePerm[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
    }

    public void go() {
        ThreadHandler worker = new ThreadHandler(){

            @Override
            public Object construct() {
                FileTask.this.current = 0;
                FileTask.this.done = false;
                FileTask.this.canceled = false;
                FileTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        worker.start();
    }

    public boolean has(String o, String option) {
        return option.indexOf(o.charAt(0)) >= 0;
    }

    boolean hasMessageJ9(String str) {
        int i = 0;
        while (i < MESSAGE_PREFIX_J9.length) {
            if (str.startsWith(MESSAGE_PREFIX_J9[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean hasMessageSov(String str) {
        if (str.startsWith(PANIC_SIGNATURE)) {
            if (str.length() > PANIC_SIGNATURE.length()) {
                str = str.substring(PANIC_SIGNATURE.length());
            } else {
                return false;
            }
        }
        int i = 0;
        while (i < MESSAGE_PREFIX_SOV.length) {
            if (str.startsWith(MESSAGE_PREFIX_SOV[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean hasOOM(int x, int y) {
        if (this.gi.outOfHeapSpace == null) {
            return false;
        }
        int i = 0;
        while (i < this.gi.outOfHeapSpace.length) {
            if (x <= this.gi.outOfHeapSpace[i] && y >= this.gi.outOfHeapSpace[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int[] indexOfOOM(int x, int y) {
        if (this.gi.outOfHeapSpace == null) {
            return null;
        }
        int counter = 0;
        int i = 0;
        while (i < this.gi.outOfHeapSpace.length) {
            if (x <= this.gi.outOfHeapSpace[i] && y >= this.gi.outOfHeapSpace[i]) {
                ++counter;
            }
            ++i;
        }
        if (counter > 0) {
            int[] oomArray = new int[counter];
            int j = 0;
            int i2 = 0;
            while (i2 < this.gi.outOfHeapSpace.length) {
                if (x <= this.gi.outOfHeapSpace[i2] && y >= this.gi.outOfHeapSpace[i2]) {
                    oomArray[j++] = this.gi.outOfHeapSpace[i2];
                }
                ++i2;
            }
            return oomArray;
        }
        return null;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isExhausted(int oomIndex) {
        if (this.gi == null || this.gi.free == null) {
            return false;
        }
        return this.getRequested(oomIndex) > this.gi.free[oomIndex];
    }

    public boolean isExhausting(int oomIndex) {
        if (this.gi == null || this.gi.total == null) {
            return false;
        }
        return (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)this.cfg.exhaustion;
    }

    public boolean isFragmented(int oomIndex) {
        if (this.getRequested(oomIndex) == 0L) {
            return false;
        }
        return 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)this.cfg.frag;
    }

    public boolean isFullGC(String line) {
        return line.indexOf(S_FULLGC_START_SIGNATURE) >= 0;
    }

    public boolean isGC(String line) {
        if (line.indexOf(S_PARNEW_START_SIGNATURE) >= 0) {
            return true;
        }
        if (line.indexOf(CMS) >= 0 || line.indexOf(CMS2) >= 0 || line.indexOf(CMS3) >= 0) {
            return false;
        }
        return line.indexOf(S_GC_START_SIGNATURE) >= 0 || line.indexOf(S_FULLGC_START_SIGNATURE) >= 0 || line.indexOf(S_PARNEW_START_SIGNATURE) >= 0;
    }

    public boolean isLOAExhausted(int oomIndex) {
        if (this.gi == null || this.gi.totalLOA == null) {
            return false;
        }
        return this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex];
    }

    public boolean isLOAExhausting(int oomIndex) {
        if (this.gi == null || this.gi.totalLOA == null) {
            return false;
        }
        return this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)this.cfg.exhaustion;
    }

    public boolean isLOAFragmented(int oomIndex) {
        if (this.getRequested(oomIndex) == 0L) {
            return false;
        }
        if (this.gi == null || this.gi.totalLOA == null) {
            return false;
        }
        return this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeLOA[oomIndex] <= (float)this.cfg.frag;
    }

    public boolean isNew(String line) {
        return line.indexOf("def new generation") >= 0 || line.indexOf("par new generation") >= 0 || line.indexOf("PSYoungGen ") >= 0;
    }

    boolean isOOM(String str) {
        return str.indexOf(OOM_SIGNATURE2) >= 0 && (str.startsWith(OOM_SIGNATURE1) || str.startsWith(OOM_SIGNATURE3));
    }

    public boolean isPerm(String line) {
        return line.indexOf("compacting perm gen") >= 0 || line.indexOf("concurrent-mark-sweep perm gen") >= 0 || line.indexOf("PSPermGen ") >= 0;
    }

    public boolean isSOAExhausted(int oomIndex) {
        if (this.gi == null || this.gi.totalSOA == null) {
            return false;
        }
        return this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex];
    }

    public boolean isSOAExhausting(int oomIndex) {
        if (this.gi == null || this.gi.totalSOA == null) {
            return false;
        }
        return this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)this.cfg.exhaustion;
    }

    public boolean isSOAFragmented(int oomIndex) {
        if (this.getRequested(oomIndex) == 0L) {
            return false;
        }
        if (this.gi == null || this.gi.totalSOA == null) {
            return false;
        }
        return this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeSOA[oomIndex] <= (float)this.cfg.frag;
    }

    boolean isStartPoint(int idx) {
        if (idx >= this.gi.free.length || idx < 0) {
            return false;
        }
        if (idx == 0) {
            return true;
        }
        return this.gi.ngc[idx - 1] >= this.gi.ngc[idx];
    }

    public boolean isTenured(String line) {
        return line.indexOf("tenured generation") >= 0 || line.indexOf("concurrent mark-sweep generation") >= 0 || line.indexOf("PSOldGen ") >= 0 || line.indexOf("ParOldGen ") >= 0;
    }

    boolean isTooLarge(int idx) {
        if (this.getRequested(idx) < 900000L) {
            return false;
        }
        return (double)((float)this.getRequested(idx) / (float)this.gi.free[idx]) > 0.1;
    }

    String processJ9(File file, Configuration cfg, boolean headless, String option) {
        BufferedRandomAccessFile in;
        long fileSize;
        long filePointer = 0L;
        StringBuffer messageBuffer = new StringBuffer();
        String[] messageLine = null;
        long numberOfExplicitGC = 0L;
        Date dt = new Date();
        ParsePosition pos = new ParsePosition(0);
        int innerGC = 0;
        boolean pinIdx = false;
        long dosed = 0L;
        long pinned = 0L;
        long classes = 0L;
        long maxClass = 0L;
        long maxClassTS = 0L;
        long maxPinned = 0L;
        long maxPinnedTS = 0L;
        long maxDosed = 0L;
        long maxDosedTS = 0L;
        long pCluster = 0L;
        Object found = null;
        long lineNumber = 0L;
        long fileLocation = 0L;
        this.gi = new GCInfo();
        this.gi.file = file;
        this.gi.type = 1;
        Vector rv = new Vector(10, 100);
        boolean index = false;
        boolean totalNames = false;
        long totalNodes = 0L;
        String line = new String();
        Vector cv = new Vector(1);
        boolean result = false;
        boolean progress = false;
        boolean p = false;
        int i = 0;
        int j = 0;
        int k = 0;
        progress = false;
        this.overall = 0;
        this.statMessage = "Loading verbosegc log file";
        boolean gcNumber = false;
        this.gi.numberOfSet = 0;
        int totalGC = 0;
        boolean nextGcNumber = false;
        int outOfHeapSpace = 0;
        int numberOfMessages = 0;
        boolean inVerbosegc = false;
        int attr = -1;
        StringBuffer attributes = new StringBuffer("");
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        boolean flag = false;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            line = in.readLineBuffered();
            if (line != null) {
                line = line.trim();
            }
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    line = in.readLineBuffered();
                    ++lineNumber;
                    continue;
                }
                if (line.length() >= 2 && line.charAt(0) == '0') {
                    line = line.substring(1);
                }
                if (line.indexOf(VERBOSEGC_START_SIGNATURE) >= 0) {
                    inVerbosegc = true;
                } else if (line.indexOf(AF_END_SIGNATURE) >= 0 || line.indexOf(SG_END_SIGNATURE) >= 0 || line.indexOf(CON_END_SIGNATURE) >= 0 || line.indexOf(GC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                } else if (line.indexOf(AF_SIGNATURE) >= 0 || line.indexOf(SG_SIGNATURE) >= 0 || line.indexOf(GC_SIGNATURE) >= 0 || line.indexOf(CON_SIGNATURE) >= 0) {
                    inVerbosegc = true;
                } else if (line.indexOf(VERBOSEGC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                }
                if (inVerbosegc && line.indexOf(GC_SIGNATURE) >= 0) {
                    ++totalGC;
                }
                if (this.isOOM(line)) {
                    ++outOfHeapSpace;
                    ++numberOfMessages;
                } else if (this.hasMessageJ9(line)) {
                    ++numberOfMessages;
                }
                line = in.readLineBuffered();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = (int)(30.0f * (float)fileLocation / (float)fileSize);
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        if (totalGC == 0) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find any verbose garbage collection log", "Information", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot find any verbose garbage collection log";
        }
        if (totalGC > Integer.MAX_VALUE) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries", "Error", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries";
        }
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.timestamp = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.free = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.total = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.mark = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.sweep = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.compact = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.af = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.since = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.sinceJ9 = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.completed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.ngc = new int[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.gccompleted = new long[totalGC];
        this.gi.filePointer = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.naf = new int[totalGC];
        this.gi.freeSOA = new long[totalGC];
        this.gi.freeLOA = new long[totalGC];
        this.gi.totalSOA = new long[totalGC];
        this.gi.totalLOA = new long[totalGC];
        this.gi.totalBeforeSOA = new long[totalGC];
        this.gi.totalBeforeLOA = new long[totalGC];
        this.gi.freeBeforeSOA = new long[totalGC];
        this.gi.freeBeforeLOA = new long[totalGC];
        this.gi.j9collection = new int[totalGC];
        if (outOfHeapSpace != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
            }
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
        } else {
            this.gi.outOfHeapSpace = null;
        }
        if (numberOfMessages != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * numberOfMessages) + " bytes.");
            }
            this.gi.messages = new int[numberOfMessages];
            messageLine = new String[numberOfMessages];
        } else {
            this.gi.messages = null;
        }
        lineNumber = 0L;
        boolean foundFlag = false;
        boolean anyGC = false;
        boolean newStart = false;
        this.statMessage = "Parsing verbosegc log file";
        totalGC = -1;
        nextGcNumber = false;
        gcNumber = false;
        long afSize = 0L;
        int afNumber = 0;
        long afSince = 0L;
        fileLocation = 0L;
        int oomi = 0;
        int messagei = 0;
        inVerbosegc = false;
        Attribute attribute = null;
        String at = null;
        String value = null;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            filePointer = in.getBufferedFilePointer();
            line = in.readLineBuffered();
            if (line != null) {
                line = line.trim();
            }
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if (line.length() >= 2 && line.charAt(0) == '0') {
                    line = line.substring(1);
                }
                if (line.indexOf(VERBOSEGC_START_SIGNATURE) >= 0) {
                    inVerbosegc = true;
                    if (!newStart || anyGC) {
                        ++this.gi.numberOfSet;
                    }
                    afNumber = 0;
                    foundFlag = true;
                    newStart = true;
                    anyGC = false;
                } else if (line.indexOf("<af type=\"") >= 0 || line.indexOf(CON_SIGNATURE) >= 0 || line.indexOf(GC_SIGNATURE) >= 0 || line.indexOf("<sys id=\"") >= 0) {
                    inVerbosegc = true;
                    anyGC = true;
                    if (!foundFlag) {
                        ++this.gi.numberOfSet;
                        afNumber = 0;
                        foundFlag = true;
                    }
                } else if (line.indexOf(VERBOSEGC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                    foundFlag = true;
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = 30 + (int)(40.0f * (float)fileLocation / (float)fileSize);
                if (this.isOOM(line)) {
                    this.gi.outOfHeapSpace[oomi++] = totalGC;
                    messageLine[messagei] = line;
                    this.gi.messages[messagei++] = totalGC;
                } else if (this.hasMessageJ9(line)) {
                    messageLine[messagei] = line;
                    this.gi.messages[messagei++] = totalGC;
                } else {
                    attr = line.indexOf(SIG_ATTR);
                    if (attr >= 0) {
                        int val = line.indexOf(SIG_ATTR_VALUE);
                        if (val > 0) {
                            int st2;
                            at = null;
                            value = null;
                            int st = line.substring(attr + SIG_ATTR.length()).indexOf(34);
                            if (st > 0) {
                                at = line.substring(attr + SIG_ATTR.length(), attr + SIG_ATTR.length() + st);
                            }
                            if ((st2 = line.substring(val + SIG_ATTR_VALUE.length()).indexOf(34)) > 0) {
                                long v;
                                value = line.substring(val + SIG_ATTR_VALUE.length(), val + SIG_ATTR_VALUE.length() + st2);
                                if (value.startsWith("0x")) {
                                    v = -1L;
                                    try {
                                        v = Long.parseLong(value.substring(2), 16);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (v != -1L) {
                                        value = numberFormatter.format(v);
                                        if (at.indexOf("HeapSize") > 0) {
                                            value = String.valueOf(value) + " bytes";
                                        }
                                    }
                                } else if (at.indexOf("physicalMemory") >= 0) {
                                    v = -1L;
                                    try {
                                        v = Long.parseLong(value);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (v != -1L) {
                                        value = String.valueOf(numberFormatter.format(v)) + " bytes";
                                    }
                                }
                            }
                            if (at != null & value != null) {
                                if (attribute == null) {
                                    attribute = new Attribute();
                                }
                                attribute.setAttributes(String.valueOf(attribute.getAttributes()) + at + " : " + value + "<BR>");
                            }
                        }
                    } else {
                        int st;
                        attr = line.indexOf(SIG_VMARG);
                        if (attr >= 0 && (st = line.substring(attr + SIG_VMARG.length()).indexOf(34)) > 0 && (at = line.substring(attr + SIG_VMARG.length(), attr + SIG_VMARG.length() + st)) != null) {
                            if (attribute == null) {
                                attribute = new Attribute();
                            }
                            attribute.setAttributes(String.valueOf(attribute.getAttributes()) + "vm argument : " + at + "<BR>");
                        }
                    }
                }
                if (inVerbosegc) {
                    if (line.indexOf(AF_END_SIGNATURE) >= 0) {
                        this.inAF = false;
                    } else if (line.indexOf(SG_END_SIGNATURE) >= 0) {
                        this.inSG = false;
                    } else if (line.indexOf(AF_SIGNATURE) >= 0 || line.indexOf(SG_SIGNATURE) >= 0 || line.indexOf(CON_SIGNATURE) >= 0) {
                        if (line.indexOf(CON_SIGNATURE) >= 0) {
                            innerGC = 0;
                        }
                        innerGC = 0;
                        if (line.indexOf(AF_SIGNATURE) >= 0) {
                            this.inAF = true;
                        }
                        if (line.indexOf(SG_SIGNATURE) >= 0) {
                            ++numberOfExplicitGC;
                            this.inSG = true;
                        }
                        this.afterGC = false;
                        i = line.indexOf(ID_SIGNATURE);
                        if (line.indexOf(ID_SIGNATURE2) != -1) {
                            ++totalGC;
                        }
                        if (totalGC >= this.gi.naf.length) break;
                        flag = false;
                        if (i == -1) {
                            i = line.indexOf(ID_SIGNATURE2);
                            flag = true;
                        }
                        if (i != -1 && (j = line.indexOf(TIMESTAMP_SIGNATURE)) != -1) {
                            afNumber = flag ? Integer.parseInt(line.substring(i + ID_SIGNATURE2.length(), j)) : Integer.parseInt(line.substring(i + ID_SIGNATURE.length(), j));
                            this.gi.naf[totalGC] = afNumber;
                            this.gi.filePointer[totalGC] = filePointer;
                            k = line.indexOf(INTERVAL_SIGNATURE);
                            if (k != -1) {
                                try {
                                    dt = formatter.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                }
                                catch (ParseException pe) {
                                    try {
                                        dt = formatter2.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                    }
                                    catch (ParseException pe2) {
                                        try {
                                            dt = formatterUS.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                        }
                                        catch (ParseException pe3) {
                                            try {
                                                dt = formatter2US.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                            }
                                            catch (ParseException pe4) {
                                                try {
                                                    String s = line.substring(j + TIMESTAMP_SIGNATURE.length(), k);
                                                    int si = s.indexOf(" ");
                                                    if (si <= 0) {
                                                        throw new ParseException("", 0);
                                                    }
                                                    dt = formatter2.parse(s.substring(si + 1));
                                                }
                                                catch (ParseException pe5) {
                                                    String errString = "Date ParseException while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
                                                    System.out.println(errString);
                                                    if (!headless) {
                                                        this.ha.handleException(pe4);
                                                        this.jp.dispose();
                                                    }
                                                    this.done = true;
                                                    return String.valueOf(errString) + "<BR>" + this.getStackTrace(pe4);
                                                }
                                            }
                                        }
                                    }
                                }
                                this.timestamp = dt.getTime();
                                if (attribute != null) {
                                    attribute.setTimestamp(this.timestamp);
                                    attrList.add(attribute);
                                    attribute = null;
                                }
                                if ((i = line.indexOf(EOL_SIGNATURE)) != -1) {
                                    this.gi.sinceJ9[totalGC] = Math.round(Float.parseFloat(line.substring(k + INTERVAL_SIGNATURE.length(), i)));
                                }
                            }
                        }
                    } else {
                        if (line != null) {
                            line = line.trim();
                        }
                        if (line.length() >= 2 && line.charAt(0) == '0') {
                            line = line.substring(1);
                        }
                        if (line.indexOf(GC_END_SIGNATURE) >= 0) {
                            this.inGC = false;
                        } else if (line.indexOf(MIN_SIGNATURE) >= 0) {
                            i = line.indexOf(EOLS_SIGNATURE);
                            if (totalGC >= 0 && i != -1) {
                                this.gi.af[totalGC] = Long.parseLong(line.substring(MIN_SIGNATURE.length(), i));
                            }
                        } else if (line.indexOf(GC_SIGNATURE) >= 0) {
                            if (totalGC >= 0) {
                                this.gi.j9collection[totalGC] = line.indexOf("scavenger") >= 0 ? 2 : 1;
                                if (++innerGC > 1) {
                                    ++totalGC;
                                }
                                this.inGC = true;
                                this.afterGC = true;
                                if (this.inAF) {
                                    this.gi.naf[totalGC] = afNumber;
                                }
                                this.gi.timestamp[totalGC] = this.timestamp;
                                i = line.indexOf(TOTALID_SIGNATURE);
                                if (i != -1 && (j = line.indexOf(INTERVAL_SIGNATURE)) != -1) {
                                    this.gi.ngc[totalGC] = Integer.parseInt(line.substring(i + TOTALID_SIGNATURE.length(), j));
                                    k = line.indexOf(EOL_SIGNATURE);
                                    if (k != -1) {
                                        this.gi.since[totalGC] = Math.round(Float.parseFloat(line.substring(j + INTERVAL_SIGNATURE.length(), k)));
                                    }
                                }
                            }
                        } else if (line.indexOf(TENURED_SIGNATURE) >= 0) {
                            if (totalGC >= 0 && (i = line.indexOf(TOTALBYTES_SIGNATURE)) != -1) {
                                if (!this.afterGC) {
                                    this.gi.freeBefore[totalGC] = Long.parseLong(line.substring(line.indexOf(TENURED_SIGNATURE) + TENURED_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalBefore[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                } else {
                                    this.gi.free[totalGC] = Long.parseLong(line.substring(line.indexOf(TENURED_SIGNATURE) + TENURED_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.total[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                }
                            }
                        } else if (line.indexOf(SOA_SIGNATURE) >= 0) {
                            if (totalGC >= 0 && (i = line.indexOf(TOTALBYTES_SIGNATURE)) != -1) {
                                if (!this.afterGC) {
                                    this.gi.freeBeforeSOA[totalGC] = Long.parseLong(line.substring(line.indexOf(SOA_SIGNATURE) + SOA_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalBeforeSOA[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                } else {
                                    this.gi.freeSOA[totalGC] = Long.parseLong(line.substring(line.indexOf(SOA_SIGNATURE) + SOA_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (this.debug && this.gi.freeSOA[totalGC] == 0L) {
                                        System.out.println(String.valueOf(totalGC) + ":" + this.gi.freeSOA[totalGC]);
                                    }
                                    if (j != -1) {
                                        this.gi.totalSOA[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                }
                            }
                        } else if (line.indexOf(LOA_SIGNATURE) >= 0) {
                            if (totalGC >= 0 && (i = line.indexOf(TOTALBYTES_SIGNATURE)) != -1) {
                                if (!this.afterGC) {
                                    this.gi.freeBeforeLOA[totalGC] = Long.parseLong(line.substring(line.indexOf(LOA_SIGNATURE) + LOA_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalBeforeLOA[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                } else {
                                    this.gi.freeLOA[totalGC] = Long.parseLong(line.substring(line.indexOf(LOA_SIGNATURE) + LOA_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalLOA[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                }
                            }
                        } else if (line.indexOf(NURSERY_SIGNATURE) >= 0) {
                            if (totalGC >= 0 && (i = line.indexOf(TOTALBYTES_SIGNATURE)) != -1) {
                                if (!this.afterGC) {
                                    this.gi.freeNurseryBefore[totalGC] = Long.parseLong(line.substring(line.indexOf(NURSERY_SIGNATURE) + NURSERY_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalNurseryBefore[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                } else {
                                    this.gi.freeNursery[totalGC] = Long.parseLong(line.substring(line.indexOf(NURSERY_SIGNATURE) + NURSERY_SIGNATURE.length(), i));
                                    j = line.indexOf(PERCENT_SIGNATURE);
                                    if (j != -1) {
                                        this.gi.totalNursery[totalGC] = Long.parseLong(line.substring(i + TOTALBYTES_SIGNATURE.length(), j));
                                    }
                                }
                            }
                        } else if (line.indexOf(TOTALMS_SIGNATURE) >= 0) {
                            if (totalGC >= 0 && (i = line.indexOf(EOLS_SIGNATURE)) != -1) {
                                if (this.inGC) {
                                    this.gi.gccompleted[totalGC] = (long)Float.parseFloat(line.substring(line.indexOf(TOTALMS_SIGNATURE) + TOTALMS_SIGNATURE.length(), i));
                                } else {
                                    this.gi.completed[totalGC] = (long)Float.parseFloat(line.substring(line.indexOf(TOTALMS_SIGNATURE) + TOTALMS_SIGNATURE.length(), i));
                                }
                            }
                        } else if (line.indexOf(MARK_SIGNATURE) >= 0 && totalGC >= 0 && (i = line.indexOf(SWEEP_SIGNATURE)) != -1) {
                            this.gi.mark[totalGC] = (long)Float.parseFloat(line.substring(line.indexOf(MARK_SIGNATURE) + MARK_SIGNATURE.length(), i));
                            j = line.indexOf(COMPACT_SIGNATURE);
                            if (j != -1) {
                                this.gi.sweep[totalGC] = (long)Float.parseFloat(line.substring(i + SWEEP_SIGNATURE.length(), j));
                                k = line.indexOf("\" total=\"");
                                if (k != -1) {
                                    this.gi.compact[totalGC] = (long)Float.parseFloat(line.substring(j + COMPACT_SIGNATURE.length(), k));
                                    i = line.indexOf(EOLS_SIGNATURE);
                                    if (i != -1) {
                                        this.gi.gccompleted[totalGC] = (long)Float.parseFloat(line.substring(k + "\" total=\"".length(), i));
                                    }
                                }
                            }
                        }
                    }
                }
                filePointer = in.getBufferedFilePointer();
                line = in.readLineBuffered();
                if (line != null) {
                    line = line.trim();
                }
                ++lineNumber;
                if (line == null) continue;
                fileLocation += (long)line.length();
            }
            in.close();
            if (newStart && !anyGC) {
                --this.gi.numberOfSet;
            }
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        Attribute[] attrArray = null;
        if (attrList.size() > 0) {
            attrArray = new Attribute[attrList.size()];
            attrArray = attrList.toArray(attrArray);
        }
        attrList = null;
        this.current = 0;
        this.overall = 70;
        if (totalGC == 0) {
            this.gi.numberOfSet = 0;
        }
        this.gi.numberOfAF = 0L;
        i = 0;
        while (i < this.gi.free.length) {
            if (this.gi.af[i] != 0L) {
                ++this.gi.numberOfAF;
            }
            ++i;
        }
        String trend = "";
        String summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
        int maxOverhead = 0;
        int tempOverhead = 0;
        int maxOverheadIndex = 0;
        long maxLO = 0L;
        int numberOfLO = 0;
        int maxLOIndex = 0;
        int numberOf100 = 0;
        int nGC = 999999999;
        int start = 0;
        long sinceAll = 0L;
        long completedAll = 0L;
        long gcCompletedAll = 0L;
        long usageAll = 0L;
        long maxUsage = 0L;
        int maxUsageIndex = 0;
        long cycle = 0L;
        i = 0;
        while (i < this.gi.free.length) {
            int l;
            int oomIndex;
            int oh;
            sinceAll += this.gi.sinceJ9[i];
            completedAll += this.gi.completed[i];
            gcCompletedAll += this.gi.gccompleted[i];
            if (this.gi.naf[i] == 0) {
                ++numberOfExplicitGC;
            }
            usageAll += this.gi.total[i] - this.gi.free[i];
            if (this.gi.total[i] - this.gi.free[i] > maxUsage) {
                maxUsage = this.gi.total[i] - this.gi.free[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > maxUsage) {
                maxUsage = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                maxUsageIndex = i;
            }
            this.current = 100 * i / this.gi.free.length;
            if (this.gi.ngc[i] < nGC) {
                if (i != 0) {
                    int[] aoomIndex;
                    if (!this.hasOOM(start, i - 1)) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i - 1) + "</li>";
                    }
                    if ((aoomIndex = this.indexOfOOM(start, i - 1)) == null) {
                        oh = this.getOverhead(start, i - 1);
                        summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i - 1) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i - 1);
                    } else {
                        oomIndex = 0;
                        l = 0;
                        while (l < aoomIndex.length) {
                            oomIndex = aoomIndex[l];
                            summary = l == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + aoomIndex.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) : String.valueOf(summary) + "<TR>";
                            summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(summary) + "<TD>" + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXCESSIVEGC_J9 : (this.isSOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.isLOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE)))))))))));
                            ++l;
                        }
                    }
                    start = i;
                }
            } else if (i + 1 == this.gi.free.length) {
                int[] oomIndexa;
                if (!this.hasOOM(start, i)) {
                    trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i) + "</li>";
                }
                if ((oomIndexa = this.indexOfOOM(start, i)) == null) {
                    oh = this.getOverhead(start, i);
                    summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i);
                } else {
                    oomIndex = 0;
                    l = 0;
                    while (l < oomIndexa.length) {
                        oomIndex = oomIndexa[l];
                        summary = l == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) : String.valueOf(summary) + "<TR>";
                        summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(summary) + "<TD>" + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXCESSIVEGC_J9 : (this.isSOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.isLOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) > 0L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : String.valueOf(summary) + "<TD>Could not find any Java heap problem " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE)))))))))));
                        ++l;
                    }
                }
            }
            nGC = this.gi.ngc[i];
            if (!this.isStartPoint(i)) {
                tempOverhead = this.getOverhead(i);
                if (tempOverhead == 100) {
                    ++numberOf100;
                }
                if (tempOverhead > maxOverhead) {
                    maxOverheadIndex = i;
                    maxOverhead = tempOverhead;
                }
            }
            if (this.gi.af[i] > (long)(cfg.large * 1024 * 1024)) {
                ++numberOfLO;
            }
            if (this.gi.af[i] > maxLO) {
                maxLO = this.gi.af[i];
                maxLOIndex = i;
            }
            ++i;
        }
        this.overall = 90;
        this.current = 0;
        String report = "";
        StringBuffer error = new StringBuffer();
        long lastValidTimestamp = this.gi.timestamp[this.gi.timestamp.length - 1];
        if (lastValidTimestamp == 0L && this.gi.timestamp.length >= 2) {
            int n = this.gi.timestamp.length - 2;
            while (n >= 0) {
                lastValidTimestamp = this.gi.timestamp[n];
                if (lastValidTimestamp != 0L) break;
                --n;
            }
        }
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Overall Garbage Collection overhead</B></span> : " + decimalFormat.format((float)completedAll * 100.0f / (float)(lastValidTimestamp - this.gi.timestamp[0])) + "%</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Garbage Collection overhead</B></span> : " + maxOverhead + "% (" + formatter.format(new Date(this.gi.timestamp[maxOverheadIndex])) + ")</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of 100% AF overhead</B></span> : " + numberFormatter.format(numberOf100) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total Garbage Collection pause</B></span> : " + numberFormatter.format(completedAll / 1000L) + " seconds </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured Area usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + ")</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured Area usage</B></span> : " + numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Explicit Garbage Collection</B></span> : " + numberFormatter.format(numberOfExplicitGC) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Allocation Request</B></span> : " + numberFormatter.format(maxLO) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxLOIndex])) + ")</li>";
        report = numberOfLO > 0 ? String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Object Requests larger than " + cfg.large + " M bytes</B></span> : " + numberFormatter.format(numberOfLO) + "</li>" : String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>There is no object request larger than " + cfg.large + " M bytes.</B></span></li>";
        if (maxClass > 0L) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + numberFormatter.format(maxClass) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + numberFormatter.format(maxDosed) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + numberFormatter.format(maxPinned) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
        }
        if (outOfHeapSpace != 0) {
            report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Java Heap Activity Analysis and Recommendations report</B> section for details)</LI>";
            i = 0;
            while (i < this.gi.outOfHeapSpace.length) {
                this.current = 100 * i / this.gi.outOfHeapSpace.length;
                int oomIndex = this.gi.outOfHeapSpace[i];
                if (oomIndex >= 0) {
                    report = this.isExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(report) + "Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAExhausting(oomIndex) ? String.valueOf(report) + "Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAExhausting(oomIndex) ? String.valueOf(report) + "Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(report) + "Excessive Garbage Collection detected. " + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.getRequested(oomIndex) > 0L ? String.valueOf(report) + "Large object request:could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : String.valueOf(report) + "Could not find Java heap problem " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of requested space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>"))))))))));
                }
                ++i;
            }
        }
        if (numberOfMessages != 0) {
            int messageNumber = 0;
            error.append("<LI><span style=\"font-weight: bold;\"><B>List of Java messages and codes</B></span></LI>");
            i = 0;
            while (i < this.gi.messages.length) {
                if ((long)i >= cfg.limit) {
                    error.append("<BR><BR>");
                    error.append("There are ");
                    error.append(numberFormatter.format((long)this.gi.messages.length - cfg.limit));
                    error.append(" more messages. Please adjust JVM message limit in View->Option menu to see more messages");
                    error.append("<BR><BR>");
                    break;
                }
                this.current = 100 * i / this.gi.messages.length;
                int mIndex = this.gi.messages[i];
                messageNumber = this.findMessageJ9(messageLine[i]);
                if (messageNumber >= 0) {
                    error.append("<B>");
                    if (mIndex >= 0) {
                        error.append("[");
                        error.append(formatter.format(new Date(this.gi.timestamp[mIndex])));
                        error.append("] ");
                    }
                    error.append(messageLine[i]);
                    error.append("</B>");
                    if (Messages.message50[messageNumber][1].length() != 0) {
                        error.append("<BR><B>Explanation: </B>");
                        error.append(Messages.message50[messageNumber][1]);
                    }
                    if (Messages.message50[messageNumber][2].length() != 0) {
                        error.append("<BR><B>System action: </B>");
                        error.append(Messages.message50[messageNumber][2]);
                    }
                    if (Messages.message50[messageNumber][3].length() != 0) {
                        error.append("<BR><B>User response: </B>");
                        error.append(Messages.message50[messageNumber][3]);
                    }
                    error.append("<BR><BR>");
                } else if (mIndex >= 0) {
                    error.append("<B>[");
                    error.append(formatter.format(new Date(this.gi.timestamp[mIndex])));
                    error.append("] ");
                    error.append(messageLine[i]);
                    error.append("</B><BR><BR>");
                }
                ++i;
            }
        }
        this.gi.summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.gi.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + this.gi.numberOfSet + "</li><li><span style=\"font-weight: bold;\"><B>Number of Garbage Collections</B></span> : " + this.gi.free.length + "</li><li><span style=\"font-weight: bold;\"><B>Number of Allocation failures</B></span> : " + this.gi.numberOfAF + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[0])) + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[this.gi.free.length - 1])) + "</li><li><span style=\"font-weight: bold;\"><B>Number of&nbsp; Java heap exhaustion</B></span> : " + outOfHeapSpace + "</li>" + report + "<BR><li><span style=\"font-weight: bold;\"><B>Java Heap Activity Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE><BR>" + error + "</ul></html>";
        String chartString = "";
        if (!headless) {
            this.ha.ti.gcList.add(this.gi);
        } else {
            chartString = this.generateChart(this.gi, 1, option);
        }
        return String.valueOf(this.gi.summary) + chartString;
    }

    /*
     * Unable to fully structure code
     */
    String processSolaris(File file, Configuration cfg, boolean headless, String option) {
        solaris50 = false;
        filePointer = 0L;
        id = null;
        isNewDone = false;
        maxPerm = 0L;
        maxTenured = 0L;
        maxNew = 0L;
        baseNew = 0L;
        basePerm = 0L;
        baseTenured = 0L;
        tempLong = 0L;
        isPrintHeap = false;
        nGC = 1;
        lastTimestamp = 9.223372036854776E18;
        currentStartupTimestamp = 0.0;
        lastPermTotal = 0L;
        lastPermFree = 0L;
        newtenTotal = 0L;
        newtenBefore = 0L;
        newtenAfter = 0L;
        numberOfExplicitGC = 0L;
        dt = new Date();
        pos = new ParsePosition(0);
        innerGC = false;
        pinIdx = false;
        dosed = 0L;
        pinned = 0L;
        classes = 0L;
        maxClass = 0L;
        maxClassTS = 0L;
        maxPinned = 0L;
        maxPinnedTS = 0L;
        maxDosed = 0L;
        maxDosedTS = 0L;
        pCluster = 0L;
        found = null;
        this.lineNumber = 0L;
        this.fileLocation = 0L;
        this.gi = new GCInfo();
        this.gi.file = file;
        this.gi.type = 2;
        rv = new Vector<E>(10, 100);
        index = false;
        totalNames = false;
        totalNodes = 0L;
        line = new String();
        oldLine = new String();
        cv = new Vector<E>(1);
        result = false;
        progress = false;
        p = false;
        temp = false;
        i = 0;
        j = 0;
        k = 0;
        l = 0;
        m = 0;
        this.gi.simpleSolaris = true;
        progress = false;
        this.overall = 0;
        this.statMessage = "Loading verbosegc log file";
        gcNumber = false;
        this.gi.numberOfSet = 0;
        this.gi.numberOfAF = 0L;
        totalGC = 0;
        nextGcNumber = false;
        outOfHeapSpace = 0;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            line = this.readLine(in);
            while (line != null) {
                if ((line = line.trim()).endsWith("secs]") && line.indexOf("[CMS-concurrent-") < 0 && line.indexOf("CMS-initial-mark") < 0 && line.indexOf("CMS-remark") < 0 && line.indexOf("Heap dump file created") < 0) {
                    ++totalGC;
                }
                line = this.readLine(in);
                this.current = (int)(100.0f * (float)this.fileLocation / (float)fileSize);
                this.overall = (int)(30.0f * (float)this.fileLocation / (float)fileSize);
            }
            in.close();
        }
        catch (Exception e) {
            errString = "Exception while parsing line " + FileTask.numberFormatter.format(this.lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        if (totalGC == 0) {
            if (this.debug) {
                System.out.println("totalGC= " + totalGC);
            }
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find any verbose garbage collection log", "Information", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot find any verbose garbage collection log";
        }
        if (totalGC > 0x7FFFFFFF) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot process more than " + FileTask.numberFormatter.format(0x7FFFFFFFL) + " entries", "Error", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot process more than " + FileTask.numberFormatter.format(0x7FFFFFFFL) + " entries";
        }
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.timestamp = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freePerm = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(1 * totalGC) + " bytes.");
        }
        this.gi.isFullGC = new boolean[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalPermBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freePermBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.free = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.total = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.mark = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.sweep = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.compact = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.af = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.since = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.completed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.ngc = new int[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.gccompleted = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.naf = new int[totalGC];
        this.gi.filePointer = new long[totalGC];
        if (outOfHeapSpace != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + FileTask.numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
            }
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
        } else {
            this.gi.outOfHeapSpace = null;
        }
        isOOM = new boolean[totalGC];
        this.statMessage = "Parsing verbosegc log file";
        totalGC = -1;
        nextGcNumber = false;
        gcNumber = false;
        afSize = 0L;
        afNumber = false;
        afSince = 0L;
        this.fileLocation = 0L;
        this.lineNumber = 0L;
        oomi = false;
        brokenGcLine = false;
        carryOn = false;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            filePointer = in.getBufferedFilePointer();
            line = this.readLine(in);
            while (line != null) {
                block279: {
                    block280: {
                        block281: {
                            block278: {
                                this.current = (int)(100.0f * (float)this.fileLocation / (float)fileSize);
                                this.overall = 30 + (int)(40.0f * (float)this.fileLocation / (float)fileSize);
                                if (line.indexOf("{Heap before GC invocations=") < 0 && line.indexOf("{Heap before gc invocations=") < 0) break block280;
                                this.gi.simpleSolaris = false;
                                isPrintHeap = true;
                                if (this.gi.rangePerm == null) {
                                    this.gi.rangePerm = new long[this.gi.ngc.length];
                                }
                                if (this.gi.rangeTenured == null) {
                                    this.gi.rangeTenured = new long[this.gi.ngc.length];
                                }
                                if (!brokenGcLine) {
                                    ++totalGC;
                                }
                                if (totalGC >= this.gi.timestamp.length) break;
                                if (this.isFullGC(line)) {
                                    this.gi.isFullGC[totalGC] = true;
                                }
                                if (!brokenGcLine) {
                                    this.gi.ngc[totalGC] = nGC++;
                                }
                                this.gi.filePointer[totalGC] = filePointer;
                                if (brokenGcLine) {
                                    brokenGcLine = false;
                                }
                                while (line.indexOf("Heap after GC invocations=") < 0 && line.indexOf("Heap after gc invocations=") < 0) {
                                    if (line.indexOf("Desired") < 0 && line.indexOf("- age") < 0) {
                                        if (line.indexOf("(concurrent mode") < 0) {
                                            oldLine = line;
                                            carryOn = false;
                                        } else {
                                            carryOn = false;
                                        }
                                    } else {
                                        carryOn = true;
                                    }
                                    filePointer = in.getBufferedFilePointer();
                                    if (line.indexOf("(concurrent mode interrupted)") >= 0 && (cms = line.indexOf("CMS")) >= 0) {
                                        oldLine = oldLine.substring(0, cms);
                                        oldLine = String.valueOf(oldLine) + " " + line;
                                    }
                                    line = this.readLine(in);
                                    if (carryOn) {
                                        line = String.valueOf(oldLine) + " " + line;
                                    }
                                    if (line == null) break;
                                    if (this.isFullGC(line)) {
                                        this.gi.isFullGC[totalGC] = true;
                                    }
                                    if (this.isTenured(line)) {
                                        if (baseTenured == 0L) {
                                            baseTenured = this.readBase(line);
                                        }
                                        tempLong = this.readMax(line);
                                        this.gi.rangeTenured[totalGC] = Math.abs(tempLong - this.readBase(line));
                                        if (tempLong > maxTenured || maxTenured == 0L) {
                                            maxTenured = tempLong;
                                        }
                                        this.gi.totalBefore[totalGC] = this.readTotal(line);
                                        this.gi.freeBefore[totalGC] = this.gi.totalBefore[totalGC] - this.readUsed(line);
                                    }
                                    if (this.isNew(line)) {
                                        if (baseNew == 0L) {
                                            baseNew = this.readBase(line);
                                        }
                                        if ((tempLong = this.readMax(line)) > maxNew || maxNew == 0L) {
                                            maxNew = tempLong;
                                        }
                                        this.gi.totalNurseryBefore[totalGC] = this.readTotal(line);
                                        this.gi.freeNurseryBefore[totalGC] = this.gi.totalNurseryBefore[totalGC] - this.readUsed(line);
                                    }
                                    if (this.isPerm(line)) {
                                        if (basePerm == 0L) {
                                            basePerm = this.readBase(line);
                                        }
                                        tempLong = this.readMax(line);
                                        this.gi.rangePerm[totalGC] = Math.abs(tempLong - this.readBase(line));
                                        if (tempLong > maxPerm || maxPerm == 0L) {
                                            maxPerm = tempLong;
                                        }
                                        this.gi.totalPermBefore[totalGC] = this.readTotal(line);
                                        this.gi.freePermBefore[totalGC] = this.gi.totalPermBefore[totalGC] - this.readUsed(line);
                                    }
                                    if (!line.startsWith(", ") || !line.endsWith(" secs]")) continue;
                                    line = String.valueOf(oldLine) + line;
                                }
                                if (carryOn) {
                                    line = String.valueOf(oldLine) + line;
                                }
                                i = -1;
                                if (line == null) break;
                                if (line.indexOf("K) Heap after GC invocations=") >= 0 || line.indexOf("K) Heap after gc invocations=") >= 0) {
                                    i = line.lastIndexOf("K) ");
                                } else if (line.indexOf("K)] Heap after GC invocations=") >= 0 || line.indexOf("K)] Heap after gc invocations=") >= 0) {
                                    i = line.lastIndexOf("K), ");
                                } else {
                                    if (line.startsWith("Heap after")) {
                                        line = oldLine;
                                        solaris50 = true;
                                    }
                                    if ((i = line.indexOf(" secs]")) > 0 && (i = line.substring(0, i).lastIndexOf(", ")) >= 0) {
                                        FileTask.pp.setIndex(0);
                                        this.gi.gccompleted[totalGC] = timespent = (long)(this.decimalformat.parse(line.substring(i + 2, line.indexOf(" secs]")), FileTask.pp).doubleValue() * 1000.0);
                                    }
                                    if ((i = line.lastIndexOf("K), ")) < 0) {
                                        i = line.lastIndexOf("K)], ");
                                    }
                                    if (i < 0) {
                                        i = line.lastIndexOf("K)]\t");
                                    }
                                    if (i < 0) {
                                        i = line.lastIndexOf("K)\t");
                                    }
                                }
                                if (i < 0) break block281;
                                if (line.charAt(0) >= '0' && line.charAt(0) <= '9') {
                                    i = line.indexOf(": ");
                                    if (i >= 0) {
                                        n = 0;
                                        d = null;
                                        this.gi.noTimestamp = false;
                                        try {
                                            d = FileTask.formatterSun.parse(line.substring(0, i));
                                            if (line.substring(i + 2).indexOf(": ") > 0) {
                                                n = i + 2;
                                                i = line.substring(i + 2).indexOf(": ") + n;
                                            }
                                        }
                                        catch (ParseException pe) {
                                            d = null;
                                        }
                                        if (d == null) {
                                            FileTask.pp.setIndex(0);
                                            if (this.decimalformat.parse(line.substring(n, i), FileTask.pp).doubleValue() < lastTimestamp) {
                                                baseTenured = 0L;
                                                baseNew = 0L;
                                                basePerm = 0L;
                                                maxNew = 0L;
                                                maxTenured = 0L;
                                                maxPerm = 0L;
                                                nGC = 1;
                                                this.gi.ngc[totalGC] = nGC++;
                                                ++this.gi.numberOfSet;
                                                lastPermTotal = 0L;
                                                if (lastTimestamp == 9.223372036854776E18) {
                                                    lastTimestamp = 0.0;
                                                }
                                                currentStartupTimestamp += lastTimestamp;
                                            }
                                            FileTask.pp.setIndex(0);
                                            lastTimestamp = this.decimalformat.parse(line.substring(n, i), FileTask.pp).doubleValue();
                                            this.timestamp = (long)((lastTimestamp + currentStartupTimestamp) * 1000.0) + cfg.defaultStartTime;
                                        }
                                        this.gi.timestamp[totalGC] = d == null ? this.timestamp : d.getTime();
                                        if (totalGC > 0) {
                                            this.gi.since[totalGC] = this.gi.timestamp[totalGC] - this.gi.timestamp[totalGC - 1] - this.gi.gccompleted[totalGC - 1];
                                        }
                                        if (this.gi.since[totalGC] < 0L) {
                                            System.out.println("negative:" + this.gi.since[totalGC]);
                                        }
                                    }
                                } else {
                                    if (!this.gi.noTimestamp) {
                                        if ((line = line.trim()).indexOf("(concurrent mode") >= 0) {
                                            if (oldLine.charAt(0) >= '0' && oldLine.charAt(0) <= '9' && (i = oldLine.indexOf(": ")) >= 0) {
                                                this.gi.noTimestamp = false;
                                                n = 0;
                                                d = null;
                                                try {
                                                    d = FileTask.formatterSun.parse(oldLine.substring(0, i));
                                                    if (oldLine.substring(i + 2).indexOf(": ") > 0) {
                                                        n = i + 2;
                                                        i = oldLine.substring(i + 2).indexOf(": ") + n;
                                                    }
                                                }
                                                catch (ParseException pe) {
                                                    d = null;
                                                }
                                                if (d == null) {
                                                    FileTask.pp.setIndex(0);
                                                    try {
                                                        this.decimalformat.parse(oldLine.substring(0, i), FileTask.pp);
                                                    }
                                                    catch (NumberFormatException pe) {
                                                        // empty catch block
                                                    }
                                                    FileTask.pp.setIndex(0);
                                                    if (this.decimalformat.parse(oldLine.substring(n, i), FileTask.pp).doubleValue() < lastTimestamp) {
                                                        baseTenured = 0L;
                                                        baseNew = 0L;
                                                        basePerm = 0L;
                                                        maxNew = 0L;
                                                        maxTenured = 0L;
                                                        maxPerm = 0L;
                                                        nGC = 1;
                                                        this.gi.ngc[totalGC] = nGC++;
                                                        ++this.gi.numberOfSet;
                                                        lastPermTotal = 0L;
                                                        if (lastTimestamp == 9.223372036854776E18) {
                                                            lastTimestamp = 0.0;
                                                        }
                                                        currentStartupTimestamp += lastTimestamp;
                                                    }
                                                    FileTask.pp.setIndex(0);
                                                    lastTimestamp = this.decimalformat.parse(oldLine.substring(0, i), FileTask.pp).doubleValue();
                                                    this.timestamp = (long)((lastTimestamp + currentStartupTimestamp) * 1000.0) + cfg.defaultStartTime;
                                                }
                                                this.gi.timestamp[totalGC] = d == null ? this.timestamp : d.getTime();
                                                if (totalGC > 0) {
                                                    this.gi.since[totalGC] = this.gi.timestamp[totalGC] - this.gi.timestamp[totalGC - 1] - this.gi.gccompleted[totalGC - 1];
                                                }
                                                if (this.gi.since[totalGC] < 0L) {
                                                    System.out.println(this.gi.since[totalGC]);
                                                }
                                            }
                                        } else {
                                            nGC = 1;
                                            this.gi.ngc[totalGC] = nGC++;
                                            ++this.gi.numberOfSet;
                                            baseTenured = 0L;
                                            baseNew = 0L;
                                            basePerm = 0L;
                                            maxNew = 0L;
                                            maxTenured = 0L;
                                            maxPerm = 0L;
                                            lastPermTotal = 0L;
                                            currentStartupTimestamp = lastTimestamp == 9.223372036854776E18 ? 0.0 : (currentStartupTimestamp += lastTimestamp);
                                            lastTimestamp = 0.0;
                                            this.gi.noTimestamp = true;
                                        }
                                    } else {
                                        if (line.indexOf("Heap after GC invocations=1:") >= 0 || line.indexOf("Heap after gc invocations=1:") >= 0) {
                                            nGC = 1;
                                            this.gi.ngc[totalGC] = nGC++;
                                            ++this.gi.numberOfSet;
                                            baseTenured = 0L;
                                            baseNew = 0L;
                                            basePerm = 0L;
                                            maxNew = 0L;
                                            maxTenured = 0L;
                                            maxPerm = 0L;
                                            lastPermTotal = 0L;
                                            if (lastTimestamp == 9.223372036854776E18) {
                                                lastTimestamp = 0.0;
                                            }
                                            currentStartupTimestamp += lastTimestamp;
                                            lastTimestamp = 0.0;
                                        }
                                        this.gi.noTimestamp = true;
                                        lastTimestamp += 1000.0;
                                    }
                                    this.gi.timestamp[totalGC] = (long)(lastTimestamp + currentStartupTimestamp) * 1000L + cfg.defaultStartTime;
                                }
                                if (!solaris50) ** GOTO lbl444
                                while (line.compareTo("}") != 0) {
                                    oldLine = line;
                                    filePointer = in.getBufferedFilePointer();
                                    line = this.readLine(in);
                                    if (line != null) {
                                        if (this.isNew(line)) {
                                            this.gi.totalNursery[totalGC] = this.readTotal(line);
                                            this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - this.readUsed(line);
                                            continue;
                                        }
                                        if (this.isTenured(line)) {
                                            this.gi.total[totalGC] = this.readTotal(line);
                                            this.gi.free[totalGC] = this.gi.total[totalGC] - this.readUsed(line);
                                            if (this.gi.free[totalGC] != 0L || this.gi.total[totalGC] != maxTenured - baseTenured) continue;
                                            isOOM[totalGC] = true;
                                            continue;
                                        }
                                        if (!this.isPerm(line)) continue;
                                        this.gi.freePerm[totalGC] = this.gi.totalPermBefore[totalGC] - this.readUsed(line);
                                        if (this.gi.freePerm[totalGC] != 0L || this.gi.totalPermBefore[totalGC] != maxPerm - basePerm) continue;
                                        isOOM[totalGC] = true;
                                        continue;
                                    }
                                    break block278;
                                }
                                break block278;
lbl-1000:
                                // 1 sources

                                {
                                    oldLine = line;
                                    filePointer = in.getBufferedFilePointer();
                                    line = this.readLine(in);
                                    if (line == null) break;
                                    if (this.isNew(line)) {
                                        this.gi.totalNursery[totalGC] = this.readTotal(line);
                                        this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - this.readUsed(line);
                                        continue;
                                    }
                                    if (this.isTenured(line)) {
                                        this.gi.total[totalGC] = this.readTotal(line);
                                        this.gi.free[totalGC] = this.gi.total[totalGC] - this.readUsed(line);
                                        if (this.gi.free[totalGC] != 0L || this.gi.total[totalGC] != maxTenured - baseTenured) continue;
                                        isOOM[totalGC] = true;
                                        continue;
                                    }
                                    if (!this.isPerm(line)) continue;
                                    this.gi.freePerm[totalGC] = this.gi.totalPermBefore[totalGC] - this.readUsed(line);
                                    if (this.gi.freePerm[totalGC] != 0L || this.gi.totalPermBefore[totalGC] != maxPerm - basePerm) continue;
                                    isOOM[totalGC] = true;
lbl444:
                                    // 7 sources

                                    ** while (!line.endsWith((String)" secs]"))
                                }
                            }
                            if (!solaris50 && (i = line.lastIndexOf(", ")) >= 0) {
                                if (this.debug) {
                                    System.out.println("|" + line.substring(i + 2, line.lastIndexOf(" secs]")) + "|");
                                }
                                FileTask.pp.setIndex(0);
                                timespent = (long)(this.decimalformat.parse(line.substring(i + 2, line.lastIndexOf(" secs]")), FileTask.pp).doubleValue() * 1000.0);
                                if (this.debug) {
                                    System.out.println("timespent=" + timespent);
                                }
                                this.gi.gccompleted[totalGC] = timespent;
                            }
                            break block279;
                        }
                        i = oldLine.lastIndexOf(", ");
                        if (oldLine.lastIndexOf(" secs]") >= 0 && i >= 0) {
                            timespent = 0L;
                            midLocation = oldLine.lastIndexOf(" secs] [Times");
                            if (midLocation >= 0) {
                                sub = oldLine.substring(0, midLocation);
                                length = sub.length();
                                n = length - 1;
                                while (n >= 0) {
                                    c = sub.charAt(n);
                                    if (c == ' ' || c == '/') break;
                                    --n;
                                }
                                timespent = (long)(Float.parseFloat(oldLine.substring(n + 1, midLocation)) * 1000.0f);
                            } else {
                                timespent = (long)(Float.parseFloat(oldLine.substring(i + 2, oldLine.lastIndexOf(" secs]"))) * 1000.0f);
                            }
                            this.gi.gccompleted[totalGC] = timespent;
                        }
                        if (line.startsWith(" Heap after GC invocations=") || line.startsWith(" Heap after gc invocations=")) {
                            if (oldLine != null && oldLine.length() > 0 && oldLine.charAt(0) >= '0' && oldLine.charAt(0) <= '9') {
                                i = oldLine.indexOf(": ");
                                if (i >= 0) {
                                    this.gi.noTimestamp = false;
                                    n = 0;
                                    d = null;
                                    try {
                                        d = FileTask.formatterSun.parse(oldLine.substring(0, i));
                                        if (oldLine.substring(i + 2).indexOf(": ") > 0) {
                                            n = i + 2;
                                            i = oldLine.substring(i + 2).indexOf(": ") + n;
                                        }
                                    }
                                    catch (ParseException pe) {
                                        d = null;
                                    }
                                    if (d == null) {
                                        FileTask.pp.setIndex(0);
                                        if (this.decimalformat.parse(oldLine.substring(n, i), FileTask.pp).doubleValue() < lastTimestamp) {
                                            nGC = 1;
                                            this.gi.ngc[totalGC] = nGC++;
                                            ++this.gi.numberOfSet;
                                            baseTenured = 0L;
                                            baseNew = 0L;
                                            basePerm = 0L;
                                            maxNew = 0L;
                                            maxTenured = 0L;
                                            maxPerm = 0L;
                                            lastPermTotal = 0L;
                                            if (lastTimestamp == 9.223372036854776E18) {
                                                lastTimestamp = 0.0;
                                            }
                                            currentStartupTimestamp += lastTimestamp;
                                        }
                                        FileTask.pp.setIndex(0);
                                        lastTimestamp = this.decimalformat.parse(oldLine.substring(0, i), FileTask.pp).doubleValue();
                                        this.timestamp = (long)((lastTimestamp + currentStartupTimestamp) * 1000.0) + cfg.defaultStartTime;
                                    }
                                    this.gi.timestamp[totalGC] = d == null ? this.timestamp : d.getTime();
                                    if (totalGC > 0) {
                                        this.gi.since[totalGC] = this.gi.timestamp[totalGC] - this.gi.timestamp[totalGC - 1] - this.gi.gccompleted[totalGC - 1];
                                    }
                                    if (this.gi.since[totalGC] < 0L) {
                                        System.out.println(this.gi.since[totalGC]);
                                    }
                                }
                            } else {
                                if (line.indexOf("Heap after GC invocations=1:") >= 0 || line.indexOf("Heap after gc invocations=1:") >= 0) {
                                    nGC = 1;
                                    this.gi.ngc[totalGC] = nGC++;
                                    ++this.gi.numberOfSet;
                                    lastTimestamp = 0.0;
                                    baseTenured = 0L;
                                    baseNew = 0L;
                                    basePerm = 0L;
                                    maxNew = 0L;
                                    maxTenured = 0L;
                                    maxPerm = 0L;
                                    lastPermTotal = 0L;
                                    if (lastTimestamp == 9.223372036854776E18) {
                                        lastTimestamp = 0.0;
                                    }
                                    currentStartupTimestamp += lastTimestamp;
                                    lastTimestamp = 0.0;
                                } else if (oldLine.indexOf("secs]") < 0) {
                                    while (!line.startsWith("}")) {
                                        oldLine = line;
                                        filePointer = in.getBufferedFilePointer();
                                        line = this.readLine(in);
                                        if (line == null) break;
                                    }
                                    --totalGC;
                                    continue;
                                }
                                this.gi.noTimestamp = true;
                                this.gi.timestamp[totalGC] = (long)(lastTimestamp + currentStartupTimestamp) * 1000L + cfg.defaultStartTime;
                            }
                            while (!line.startsWith("}")) {
                                oldLine = line;
                                filePointer = in.getBufferedFilePointer();
                                line = this.readLine(in);
                                if (line != null) {
                                    if (this.isNew(line)) {
                                        this.gi.totalNursery[totalGC] = this.readTotal(line);
                                        this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - this.readUsed(line);
                                        continue;
                                    }
                                    if (this.isTenured(line)) {
                                        this.gi.total[totalGC] = this.readTotal(line);
                                        this.gi.free[totalGC] = this.gi.total[totalGC] - this.readUsed(line);
                                        if (this.gi.free[totalGC] != 0L || this.gi.total[totalGC] != maxTenured - baseTenured) continue;
                                        isOOM[totalGC] = true;
                                        continue;
                                    }
                                    if (!this.isPerm(line)) continue;
                                    this.gi.freePerm[totalGC] = this.gi.totalPermBefore[totalGC] - this.readUsed(line);
                                    if (this.gi.freePerm[totalGC] != 0L || this.gi.totalPermBefore[totalGC] != maxPerm - basePerm) continue;
                                    isOOM[totalGC] = true;
                                    continue;
                                }
                                break block279;
                            }
                        }
                        break block279;
                    }
                    if (this.isGC(line)) {
                        if (++totalGC >= this.gi.timestamp.length) break;
                        if (this.isFullGC(line)) {
                            this.gi.isFullGC[totalGC] = true;
                        }
                        this.gi.ngc[totalGC] = nGC++;
                        this.gi.filePointer[totalGC] = filePointer;
                        number = null;
                        if (line.charAt(0) >= '0' && line.charAt(0) <= '9') {
                            i = line.indexOf(": ");
                            if (i >= 0) {
                                this.gi.noTimestamp = false;
                                n = 0;
                                d = null;
                                try {
                                    d = FileTask.formatterSun.parse(line.substring(0, i));
                                    if (line.substring(i + 2).indexOf(": ") > 0) {
                                        n = i + 2;
                                        i = line.substring(i + 2).indexOf(": ") + n;
                                    }
                                }
                                catch (ParseException pe) {
                                    d = null;
                                }
                                if (d == null) {
                                    FileTask.pp.setIndex(0);
                                    number = this.decimalformat.parse(line.substring(n, i), FileTask.pp);
                                    if (number != null && number.doubleValue() < lastTimestamp) {
                                        nGC = 1;
                                        this.gi.ngc[totalGC] = nGC++;
                                        ++this.gi.numberOfSet;
                                        baseTenured = 0L;
                                        baseNew = 0L;
                                        basePerm = 0L;
                                        maxNew = 0L;
                                        maxTenured = 0L;
                                        maxPerm = 0L;
                                        lastPermTotal = 0L;
                                        if (lastTimestamp == 9.223372036854776E18) {
                                            lastTimestamp = 0.0;
                                        }
                                        currentStartupTimestamp += lastTimestamp;
                                    }
                                    if (this.debug) {
                                        System.out.println("ts=" + line.substring(0, i));
                                    }
                                    lastTimestamp = number.doubleValue();
                                    this.timestamp = (long)((lastTimestamp + currentStartupTimestamp) * 1000.0) + cfg.defaultStartTime;
                                }
                                this.gi.timestamp[totalGC] = d == null ? this.timestamp : d.getTime();
                                if (totalGC > 0) {
                                    this.gi.since[totalGC] = this.gi.timestamp[totalGC] - this.gi.timestamp[totalGC - 1] - this.gi.gccompleted[totalGC - 1];
                                }
                                if (this.gi.since[totalGC] < 0L) {
                                    System.out.println(this.gi.since[totalGC]);
                                }
                            }
                        } else {
                            if (!this.gi.noTimestamp) {
                                nGC = 1;
                                this.gi.ngc[totalGC] = nGC++;
                                ++this.gi.numberOfSet;
                                lastTimestamp = 0.0;
                                baseTenured = 0L;
                                baseNew = 0L;
                                basePerm = 0L;
                                maxNew = 0L;
                                maxTenured = 0L;
                                maxPerm = 0L;
                                lastPermTotal = 0L;
                                if (lastTimestamp == 9.223372036854776E18) {
                                    lastTimestamp = 0.0;
                                }
                                currentStartupTimestamp += lastTimestamp;
                                this.gi.noTimestamp = true;
                            } else {
                                lastTimestamp += 1000.0;
                            }
                            this.gi.timestamp[totalGC] = (long)(lastTimestamp + currentStartupTimestamp) * 1000L + cfg.defaultStartTime;
                        }
                        i = line.lastIndexOf(", ");
                        if (line.indexOf("[Times:") > 0) {
                            line = line.substring(0, line.indexOf("[Times:"));
                            i = line.lastIndexOf(", ");
                        }
                        if (i < 0) {
                            brokenGcLine = false;
                            while ((i = line.lastIndexOf(", ")) < 0 || line.indexOf("Desired") >= 0 || line.indexOf("- age") >= 0) {
                                filePointer = in.getBufferedFilePointer();
                                line = this.readLine(in);
                                if (line == null) break;
                                if (line.indexOf("Heap before GC") < 0 && line.indexOf("Heap before gc") < 0) continue;
                                brokenGcLine = true;
                                break;
                            }
                        }
                        if (i >= 0) {
                            if (this.debug) {
                                System.out.println("DEBUG" + line);
                                System.out.println("|" + line.substring(i + 2, line.lastIndexOf(" secs]")) + "|");
                            }
                            FileTask.pp.setIndex(0);
                            number = this.decimalformat.parse(line.substring(i + 2, line.lastIndexOf(" secs]")), FileTask.pp);
                            if (number != null) {
                                this.gi.gccompleted[totalGC] = (long)(number.doubleValue() * 1000.0);
                            }
                        }
                        if (line == null) break;
                        i = line.lastIndexOf("K), ");
                        if (i < 0) {
                            i = line.lastIndexOf("K) [");
                        }
                        if (i >= 0) {
                            j = line.substring(0, i).lastIndexOf(40);
                            if (j >= 0) {
                                if (this.debug) {
                                    System.out.println("newten total=" + line.substring(j + 1, i));
                                }
                                this.gi.totalBefore[totalGC] = newtenTotal = (long)Integer.parseInt(line.substring(j + 1, i)) * 1024L;
                                this.gi.total[totalGC] = newtenTotal;
                            }
                            if ((k = line.substring(0, j).lastIndexOf("K->")) >= 0) {
                                if (this.debug) {
                                    System.out.println("newten after=" + line.substring(k + "K->".length(), j - 1));
                                }
                                if (this.gi.totalBefore[totalGC] >= (newtenAfter = Long.parseLong(line.substring(k + "K->".length(), j - 1)) * 1024L)) {
                                    this.gi.free[totalGC] = this.gi.totalBefore[totalGC] - newtenAfter;
                                }
                                if ((i = line.substring(0, k).lastIndexOf(32)) >= 0) {
                                    if (this.debug) {
                                        System.out.println("newten before=" + line.substring(i + 1, k));
                                    }
                                    if (this.gi.totalBefore[totalGC] >= (newtenBefore = Long.parseLong(line.substring(i + 1, k)) * 1024L)) {
                                        this.gi.freeBefore[totalGC] = this.gi.totalBefore[totalGC] - newtenBefore;
                                    }
                                }
                            } else {
                                k = line.lastIndexOf("K(");
                                if (k >= 0 && (i = line.substring(0, k).lastIndexOf(32)) >= 0 && this.gi.totalBefore[totalGC] >= (newtenAfter = Long.parseLong(line.substring(i + 1, k)) * 1024L)) {
                                    this.gi.free[totalGC] = this.gi.totalBefore[totalGC] - newtenAfter;
                                    this.gi.freeBefore[totalGC] = this.gi.totalBefore[totalGC] - newtenAfter;
                                }
                            }
                            isNewDone = false;
                            j = line.indexOf("[DefNew:");
                            if (j >= 0) {
                                id = "DefNew:";
                            } else {
                                j = line.indexOf("[ParNew:");
                                if (j >= 0) {
                                    id = "ParNew:";
                                }
                            }
                            if (id != null && j >= 0) {
                                isNewDone = true;
                                this.gi.simpleSolaris = false;
                                k = line.indexOf("K->");
                                if (k >= 0) {
                                    usedNurseryBefore = Long.parseLong(line.substring(2 + j + id.length(), k)) * 1024L;
                                    if (this.debug) {
                                        System.out.println("used before=" + Long.parseLong(line.substring(2 + j + id.length(), k)));
                                    }
                                    if ((l = line.indexOf("K(")) >= 0) {
                                        if (this.debug) {
                                            System.out.println("used after=" + line.substring(k + "K->".length(), l));
                                        }
                                        usedNurseryAfter = Long.parseLong(line.substring(k + "K->".length(), l)) * 1024L;
                                        m = line.indexOf("K),");
                                        if (m >= 0) {
                                            if (this.debug) {
                                                System.out.println("totalBefore=" + line.substring(l + "K(".length(), m));
                                            }
                                            this.gi.totalNurseryBefore[totalGC] = this.gi.totalNursery[totalGC] = (totalNurseryBefore = Long.parseLong(line.substring(l + "K(".length(), m)) * 1024L);
                                            if (this.gi.totalNurseryBefore[totalGC] >= usedNurseryBefore) {
                                                this.gi.freeNurseryBefore[totalGC] = this.gi.totalNurseryBefore[totalGC] - usedNurseryBefore;
                                            }
                                            if (this.gi.totalNursery[totalGC] >= usedNurseryAfter) {
                                                this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - usedNurseryAfter;
                                            }
                                            if (this.gi.totalBefore[totalGC] >= this.gi.totalNurseryBefore[totalGC]) {
                                                this.gi.totalBefore[totalGC] = this.gi.totalBefore[totalGC] - this.gi.totalNurseryBefore[totalGC];
                                                this.gi.total[totalGC] = this.gi.totalBefore[totalGC];
                                            }
                                            if (this.gi.free[totalGC] >= this.gi.freeNursery[totalGC]) {
                                                this.gi.free[totalGC] = this.gi.free[totalGC] - this.gi.freeNursery[totalGC];
                                            }
                                            if (this.gi.freeBefore[totalGC] >= this.gi.freeNurseryBefore[totalGC]) {
                                                this.gi.freeBefore[totalGC] = this.gi.freeBefore[totalGC] - this.gi.freeNurseryBefore[totalGC];
                                            }
                                            this.gi.freePerm[totalGC] = lastPermFree;
                                            this.gi.freePermBefore[totalGC] = lastPermFree;
                                            this.gi.totalPermBefore[totalGC] = lastPermTotal;
                                        }
                                    }
                                }
                            }
                            if (!isNewDone) {
                                j = line.indexOf("[Tenured:");
                                if (j >= 0) {
                                    id = "[Tenured:";
                                } else {
                                    j = line.indexOf("[Train MSC:");
                                    if (j >= 0) {
                                        id = "[Train MSC:";
                                    }
                                }
                                if (id != null && j >= 0) {
                                    this.gi.simpleSolaris = false;
                                    k = line.substring(j).indexOf("K->");
                                    if (k >= 0) {
                                        usedTenBefore = Long.parseLong(line.substring(1 + j + id.length(), k += j)) * 1024L;
                                        if (this.debug) {
                                            System.out.println("Ten used before=" + Long.parseLong(line.substring(1 + j + id.length(), k)));
                                        }
                                        if ((l = line.substring(k).indexOf("K(")) >= 0) {
                                            l += k;
                                            if (this.debug) {
                                                System.out.println("Ten used after=" + line.substring(k + "K->".length(), l));
                                            }
                                            usedTenAfter = Long.parseLong(line.substring(k + "K->".length(), l)) * 1024L;
                                            m = line.substring(l).indexOf("K),");
                                            if (m >= 0) {
                                                m += l;
                                                if (this.debug) {
                                                    System.out.println("Ten totalBefore=" + line.substring(l + "K(".length(), m));
                                                }
                                                if (this.gi.totalBefore[totalGC] >= (totalTenBefore = Long.parseLong(line.substring(l + "K(".length(), m)) * 1024L)) {
                                                    this.gi.totalNurseryBefore[totalGC] = this.gi.totalBefore[totalGC] - totalTenBefore;
                                                    this.gi.totalNursery[totalGC] = this.gi.totalNurseryBefore[totalGC];
                                                }
                                                if (this.gi.totalNursery[totalGC] >= newtenAfter - usedTenAfter) {
                                                    this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - (newtenAfter - usedTenAfter);
                                                }
                                                if (this.gi.totalNurseryBefore[totalGC] >= newtenBefore - usedTenBefore) {
                                                    this.gi.freeNurseryBefore[totalGC] = this.gi.totalNurseryBefore[totalGC] - (newtenBefore - usedTenBefore);
                                                }
                                                this.gi.total[totalGC] = this.gi.totalBefore[totalGC] = totalTenBefore;
                                                if (this.gi.total[totalGC] >= usedTenAfter) {
                                                    this.gi.free[totalGC] = this.gi.total[totalGC] - usedTenAfter;
                                                }
                                                if (this.gi.totalBefore[totalGC] >= usedTenBefore) {
                                                    this.gi.freeBefore[totalGC] = this.gi.totalBefore[totalGC] - usedTenBefore;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ((j = line.indexOf("[Perm :")) >= 0 && (k = line.substring(j).indexOf("K->")) >= 0) {
                                usedPermBefore = Long.parseLong(line.substring(1 + j + "[Perm :".length(), k += j)) * 1024L;
                                if (this.debug) {
                                    System.out.println("Perm used before=" + Long.parseLong(line.substring(1 + j + "[Perm :".length(), k)));
                                }
                                if ((l = line.substring(j).indexOf("K(")) >= 0) {
                                    l += j;
                                    if (this.debug) {
                                        System.out.println("Perm used after=" + line.substring(k + "K->".length(), l));
                                    }
                                    usedPermAfter = Long.parseLong(line.substring(k + "K->".length(), l)) * 1024L;
                                    m = line.substring(j).indexOf("K)]");
                                    if (m >= 0) {
                                        m += j;
                                        if (this.debug) {
                                            System.out.println("Perm totalBefore=" + line.substring(l + "K(".length(), m));
                                        }
                                        this.gi.totalPermBefore[totalGC] = totalPermBefore = Long.parseLong(line.substring(l + "K(".length(), m)) * 1024L;
                                        lastPermTotal = totalPermBefore;
                                        if (totalPermBefore >= usedPermBefore) {
                                            this.gi.freePermBefore[totalGC] = totalPermBefore - usedPermBefore;
                                        }
                                        if (totalPermBefore >= usedPermAfter) {
                                            this.gi.freePerm[totalGC] = totalPermBefore - usedPermAfter;
                                            lastPermFree = this.gi.freePerm[totalGC];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (line == null) break;
                if (!((line = line.trim()).startsWith("}  {Heap before GC invocations=") || line.startsWith("}  {Heap before gc invocations=") || line.startsWith("{Heap before GC invocations=") || line.startsWith("{Heap before gc invocations="))) {
                    oldLine = line;
                    filePointer = in.getBufferedFilePointer();
                    line = this.readLine(in);
                    if (line == null) break;
                }
                if (totalGC <= 0 || this.gi.timestamp[totalGC] != 0L || this.gi.gccompleted[totalGC] != 0L) continue;
                --totalGC;
                --nGC;
            }
            in.close();
        }
        catch (Exception e) {
            errString = "Exception while parsing line " + FileTask.numberFormatter.format(this.lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        this.current = 0;
        this.overall = 70;
        if (this.debug) {
            System.out.println("Completed parsing");
        }
        if (totalGC == 0) {
            this.gi.numberOfSet = 0;
        }
        this.gi.numberOfAF = 0L;
        i = 0;
        while (i < this.gi.isFullGC.length) {
            if (this.gi.isFullGC[i]) {
                ++this.gi.numberOfAF;
            }
            ++i;
        }
        outOfHeapSpace = 0;
        i = 0;
        while (i < isOOM.length) {
            if (isOOM[i]) {
                ++outOfHeapSpace;
            }
            ++i;
        }
        if (outOfHeapSpace != 0) {
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
            i = 0;
            j = 0;
            while (i < isOOM.length) {
                if (isOOM[i]) {
                    this.gi.outOfHeapSpace[j++] = i;
                }
                ++i;
            }
        }
        trend = "";
        summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
        maxOverhead = 0;
        tempOverhead = 0;
        maxOverheadIndex = 0;
        maxLO = 0L;
        numberOfLO = 0;
        maxLOIndex = 0;
        numberOf100 = 0;
        nGC = 999999999;
        start = 0;
        sinceAll = 0L;
        completedAll = 0L;
        gcCompletedAll = 0L;
        usageAll = 0L;
        usagePermAll = 0L;
        maxUsage = 0L;
        maxPermUsage = 0L;
        maxNewUsage = 0L;
        usageNewAll = 0L;
        maxUsageIndex = 0;
        maxPermUsageIndex = 0;
        maxNewUsageIndex = 0;
        cycle = 0L;
        if (this.gi.totalPermBefore[0] == 0L) {
            indexOfNone0 = -1;
            i = 0;
            while (i < this.gi.free.length) {
                if (this.gi.totalPermBefore[i] != 0L) {
                    indexOfNone0 = i;
                    break;
                }
                ++i;
            }
            if (indexOfNone0 > 0) {
                i = 0;
                while (i < indexOfNone0) {
                    this.gi.totalPermBefore[i] = this.gi.totalPermBefore[indexOfNone0];
                    ++i;
                }
            }
        }
        i = 0;
        while (i < this.gi.free.length) {
            sinceAll += this.gi.since[i];
            completedAll += this.gi.completed[i];
            if (!this.gi.simpleSolaris) {
                if (this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] > maxNewUsage) {
                    maxNewUsage = this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                    maxNewUsageIndex = i;
                }
                if (this.gi.totalNursery[i] - this.gi.freeNursery[i] > maxNewUsage) {
                    maxNewUsage = this.gi.totalNursery[i] - this.gi.freeNursery[i];
                    maxNewUsageIndex = i;
                }
                usageNewAll += this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                usagePermAll += this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                if (this.debug) {
                    System.out.println("perm usage" + (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i]));
                }
            }
            gcCompletedAll += this.gi.gccompleted[i];
            if (this.gi.naf[i] == 0) {
                ++numberOfExplicitGC;
            }
            usageAll += this.gi.total[i] - this.gi.free[i];
            if (this.gi.total[i] - this.gi.free[i] > maxUsage) {
                maxUsage = this.gi.total[i] - this.gi.free[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > maxUsage) {
                maxUsage = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] > maxPermUsage) {
                maxPermUsage = this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                maxPermUsageIndex = i;
            }
            if (this.gi.totalPermBefore[i] - this.gi.freePerm[i] > maxPermUsage) {
                maxPermUsage = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                maxPermUsageIndex = i;
            }
            if (this.gi.ngc[i] < nGC) {
                this.gi.since[i] = 0L;
            } else if (i > 0) {
                this.gi.since[i] = this.gi.timestamp[i] - this.gi.timestamp[i - 1] - this.gi.gccompleted[i - 1];
            }
            this.current = 100 * i / this.gi.free.length;
            if (this.gi.ngc[i] < nGC) {
                if (i != 0) {
                    if (!this.hasOOM(start, i - 1)) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i - 1) + "</li>";
                        if (!this.gi.simpleSolaris) {
                            trend = String.valueOf(trend) + "<li>" + this.getTrendPerm(start, i - 1) + "</li>";
                        }
                    }
                    if ((oomIndexa = this.indexOfOOM(start, i - 1)) == null) {
                        oh = this.getOverhead(start, i - 1);
                        ohString = null;
                        ohString = this.gi.noTimestamp == false && oh >= cfg.overheadRatio ? "There's " + oh + "% of overhead" : "";
                        summary = isPrintHeap ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>No Java heap exhaustion found." + ohString + "<TD>" + this.getTrendAnalysis(start, i - 1) + "<BR>" + this.getTrendAnalysisPerm(start, i - 1) : (!this.gi.simpleSolaris ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Cannot determine Java heap exhaustion." + ohString + "<TD>" + "Please make sure you have the following parameters on 1.4.1 and higher JVM to collect more information.<BR>-XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintHeapAtGC <BR><BR>" + this.getTrendAnalysis(start, i - 1) + "<BR>" + this.getTrendAnalysisPerm(start, i - 1) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Cannot determine Java heap exhaustion." + ohString + "<TD>" + "Please make sure you have the following parameters on 1.4.1 and higher JVM to collect more information.<BR>-XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintHeapAtGC <BR><BR>" + this.getTrendAnalysis(start, i - 1));
                    } else {
                        oomIndex = 0;
                        n = 0;
                        while (n < oomIndexa.length) {
                            summary = n == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") : String.valueOf(summary) + "<TR>";
                            oomIndex = oomIndexa[n];
                            if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                                summary = (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Permanent Generation is exhausted " + 100.0f * (float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] + " % free " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Permanent Generation size using -XX:MaxPermSize option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + FileTask.numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + FileTask.numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + "<TD>Could not find Java heap problem " + FileTask.numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + FileTask.numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "There's no recommendations. Please contact IBM for further assistance if there's no error messages."));
                            }
                            ++n;
                        }
                    }
                    start = i;
                }
            } else if (i + 1 == this.gi.free.length) {
                if (!this.hasOOM(start, i)) {
                    trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i) + "</li>";
                    if (!this.gi.simpleSolaris) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrendPerm(start, i) + "</li>";
                    }
                }
                if ((oomIndexa = this.indexOfOOM(start, i)) == null) {
                    oh = this.getOverhead(start, i);
                    ohString = null;
                    ohString = this.gi.noTimestamp == false && oh >= cfg.overheadRatio ? "There's " + oh + "% of overhead" : "";
                    summary = isPrintHeap ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + "<TD>No Java heap exhaustion found." + ohString + "<TD>" + this.getTrendAnalysis(start, i) + "<BR>" + this.getTrendAnalysisPerm(start, i) : (!this.gi.simpleSolaris ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Cannot determine Java heap exhaustion." + ohString + "<TD>" + "Please make sure you have the following parameters on 1.4.1 and higher JVM to collect more information.<BR>-XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintHeapAtGC <BR><BR>" + this.getTrendAnalysis(start, i - 1) + "<BR>" + this.getTrendAnalysisPerm(start, i - 1) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Cannot determine Java heap exhaustion." + ohString + "<TD>" + "Please make sure you have the following parameters on 1.4.1 and higher JVM to collect more information.<BR>-XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintHeapAtGC <BR><BR>" + this.getTrendAnalysis(start, i - 1));
                } else {
                    oomIndex = 0;
                    n = 0;
                    while (n < oomIndexa.length) {
                        summary = l == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") : String.valueOf(summary) + "<TR>";
                        oomIndex = oomIndexa[n];
                        if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                            summary = (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Permanent Generation is exhausted " + 100.0f * (float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] + " % free " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Permanent Generation size using -XX:MaxPermSize option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + FileTask.numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + FileTask.numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + "<TD>Could not find Java heap problem " + FileTask.numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + FileTask.numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "There's no recommendations. Please contact IBM for further assistance if there's no error messages."));
                        }
                        ++n;
                    }
                }
            }
            nGC = this.gi.ngc[i];
            if (!this.isStartPoint(i)) {
                tempOverhead = this.getOverhead(i);
                if (tempOverhead == 100) {
                    ++numberOf100;
                }
                if (tempOverhead > maxOverhead) {
                    maxOverheadIndex = i;
                    maxOverhead = tempOverhead;
                }
            }
            if (this.gi.af[i] > (long)(cfg.large * 1024 * 1024)) {
                ++numberOfLO;
            }
            if (this.gi.af[i] > maxLO) {
                maxLO = this.gi.af[i];
                maxLOIndex = i;
            }
            ++i;
        }
        this.overall = 90;
        this.current = 0;
        report = "";
        lastValidTimestamp = this.gi.timestamp[this.gi.timestamp.length - 1];
        if (lastValidTimestamp == 0L && this.gi.timestamp.length >= 2) {
            n = this.gi.timestamp.length - 2;
            while (n >= 0) {
                lastValidTimestamp = this.gi.timestamp[n];
                if (lastValidTimestamp != 0L) break;
                --n;
            }
        }
        if (this.gi.noTimestamp) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\">WARNING!! The interval of 1 second is used where timestamp is not available</span></li><li><span style=\"font-weight: bold;\">Enable -XX:+PrintGCTimeStamps to collect timestamp information on J2SE 1.4.1 and higher</span></li>";
        } else {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Overall Garbage Collection overhead</B></span> : " + FileTask.decimalFormat.format((float)gcCompletedAll * 100.0f / (float)(lastValidTimestamp - this.gi.timestamp[0])) + "%</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total time spent in non Garbage Collection</B></span> : " + FileTask.numberFormatter.format((lastValidTimestamp - this.gi.timestamp[0] - gcCompletedAll) / 1000L) + " seconds </li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Garbage Collection overhead</B></span> : " + maxOverhead + "% (" + FileTask.formatter.format(new Date(this.gi.timestamp[maxOverheadIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of 100% overhead</B></span> : " + FileTask.numberFormatter.format(numberOf100) + "</li>";
        }
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total Garbage Collection pause</B></span> : " + FileTask.numberFormatter.format(gcCompletedAll / 1000L) + " seconds </li>";
        if (maxPermUsage > 0L) {
            pct = "";
            if (isPrintHeap && maxPerm - basePerm != 0L) {
                pct = String.valueOf(100L * maxPermUsage / (maxPerm - basePerm)) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Permanent Generation usage</B></span> : " + FileTask.numberFormatter.format(maxPermUsage) + " bytes ( " + pct + FileTask.formatter.format(new Date(this.gi.timestamp[maxPermUsageIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Permanent Generation usage</B></span> : " + FileTask.numberFormatter.format(usagePermAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        }
        if (this.gi.simpleSolaris) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\">Enable -XX:+PrintGCDetails to collect GC detail information on J2SE 1.4.1 and higher</span></li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured+New Generation usage</B></span> : " + FileTask.numberFormatter.format(maxUsage) + " bytes (" + FileTask.formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured+New Generation usage</B></span> : " + FileTask.numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        } else {
            pct = "";
            if (isPrintHeap && maxTenured - baseTenured != 0L) {
                pct = String.valueOf(100L * maxUsage / (maxTenured - baseTenured)) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured Generation usage</B></span> : " + FileTask.numberFormatter.format(maxUsage) + " bytes ( " + pct + FileTask.formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + " )</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured Generation usage</B></span> : " + FileTask.numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
            pct = "";
            if (isPrintHeap && maxNew - baseNew != 0L) {
                pct = String.valueOf(100L * maxNewUsage / (maxNew - baseNew)) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum New Generation usage</B></span> : " + FileTask.numberFormatter.format(maxNewUsage) + " bytes ( " + pct + FileTask.formatter.format(new Date(this.gi.timestamp[maxNewUsageIndex])) + " )</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average New Generation usage</B></span> : " + FileTask.numberFormatter.format(usageNewAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        }
        if (maxClass > 0L) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + FileTask.numberFormatter.format(maxClass) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + FileTask.numberFormatter.format(maxDosed) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + FileTask.numberFormatter.format(maxPinned) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + FileTask.numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
        }
        if (outOfHeapSpace != 0) {
            report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Java Heap Activity Analysis and Recommendations report</B> section for details)</LI>";
            i = 0;
            while (i < this.gi.outOfHeapSpace.length) {
                this.current = 100 * i / this.gi.outOfHeapSpace.length;
                oomIndex = this.gi.outOfHeapSpace[i];
                if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                    if ((float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion) {
                        report = String.valueOf(report) + "Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>";
                    } else if ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion) {
                        report = String.valueOf(report) + "Java heap Permanent Generation is exhausted " + FileTask.numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available " + FileTask.formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>";
                    }
                }
                ++i;
            }
        }
        maxInfo = "";
        if (isPrintHeap) {
            maxInfo = "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of New generation</B></span> : " + FileTask.numberFormatter.format(Math.abs(maxNew - baseNew)) + " bytes" + "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of Tenured generation</B></span> : " + FileTask.numberFormatter.format(Math.abs(maxTenured - baseTenured)) + " bytes" + "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of Permanent generation</B></span> : " + FileTask.numberFormatter.format(Math.abs(maxPerm - basePerm)) + " bytes";
        }
        this.gi.summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.gi.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + FileTask.numberFormatter.format(this.gi.numberOfSet) + "</li><li><span style=\"font-weight: bold;\"><B>Number of all Garbage Collections</B></span> : " + FileTask.numberFormatter.format(this.gi.free.length) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Full Garbage Collections</B></span> : " + FileTask.numberFormatter.format(this.gi.numberOfAF) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Minor Garbage Collections</B></span> : " + FileTask.numberFormatter.format((long)this.gi.free.length - this.gi.numberOfAF) + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + FileTask.formatter.format(new Date(this.gi.timestamp[0])) + (headless != false ? " (There's no startup timestamp information." + new Date(cfg.defaultStartTime) + " is used.)" : " (There's no startup timestamp information. The timestamp at View->Option->Start time is used.)") + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + FileTask.formatter.format(new Date(lastValidTimestamp)) + (headless != false ? " (There's no startup timestamp information. " + new Date(cfg.defaultStartTime) + " is used to calculate last garbage collection time.)" : " (There's no startup timestamp information. The timestamp at View->Option->Start time is used to calculate last garbage collection time.)") + maxInfo + report + "<li><span style=\"font-weight: bold;\"><B>Java Heap Activity Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE>" + "</ul></html>";
        chartString = "";
        if (!headless) {
            this.ha.ti.gcList.add(this.gi);
        } else {
            chartString = this.generateChart(this.gi, 2, option);
        }
        return String.valueOf(this.gi.summary) + chartString;
    }

    String processSov(File file, Configuration cfg, boolean headless, String option) {
        BufferedRandomAccessFile in;
        long fileSize;
        long filePointer = 0L;
        Date dt = new Date();
        int messagei = 0;
        int pinIdx = 0;
        String[] messageLine = null;
        long dosed = 0L;
        long pinned = 0L;
        long classes = 0L;
        long maxClass = 0L;
        long maxClassTS = 0L;
        long maxPinned = 0L;
        long maxPinnedTS = 0L;
        long maxDosed = 0L;
        long maxDosedTS = 0L;
        long pCluster = 0L;
        Object found = null;
        long lineNumber = 0L;
        long fileLocation = 0L;
        this.gi = new GCInfo();
        this.gi.file = file;
        Vector rv = new Vector(10, 100);
        boolean index = false;
        boolean totalNames = false;
        long totalNodes = 0L;
        String line = new String();
        Vector cv = new Vector(1);
        boolean result = false;
        boolean progress = false;
        boolean p = false;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        progress = false;
        this.overall = 0;
        if (this.debug) {
            System.out.println("Loading verbosegc log file");
        }
        this.statMessage = "Loading verbosegc log file";
        int gcNumber = 0;
        int numberOfSet = 1;
        int totalGC = 0;
        int nextGcNumber = 0;
        int outOfHeapSpace = 0;
        int numberOfMessages = 0;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            line = in.readLineBuffered();
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if ((line = line.trim()).startsWith("<GC(")) {
                    if (line.indexOf("GC cycle started") != -1) {
                        ++totalGC;
                    }
                } else if (line.indexOf("<AF[") >= 0) {
                    if (line.indexOf(OOMsignature) != -1) {
                        ++outOfHeapSpace;
                    }
                } else if (this.hasMessageSov(line)) {
                    ++numberOfMessages;
                }
                line = in.readLineBuffered();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = (int)(30.0f * (float)fileLocation / (float)fileSize);
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        if (totalGC == 0) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find any verbose garbage collection log", "Information", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot find any verbose garbage collection log";
        }
        if (totalGC > Integer.MAX_VALUE) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries", "Error", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries";
        }
        this.gi.type = 0;
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeLOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalLOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeSOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalSOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBeforeLOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBeforeLOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBeforeSOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBeforeSOA = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.timestamp = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.free = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.total = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.mark = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.sweep = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.compact = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.af = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.since = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.completed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.ngc = new int[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.gccompleted = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.naf = new int[totalGC];
        this.gi.filePointer = new long[totalGC];
        if (outOfHeapSpace != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
            }
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
        } else {
            this.gi.outOfHeapSpace = null;
        }
        if (numberOfMessages != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * numberOfMessages) + " bytes.");
            }
            this.gi.messages = new int[numberOfMessages];
            messageLine = new String[numberOfMessages];
        } else {
            this.gi.messages = null;
        }
        lineNumber = 0L;
        this.statMessage = "Parsing verbosegc log file";
        totalGC = -1;
        nextGcNumber = 0;
        gcNumber = 0;
        long afSize = 0L;
        int afNumber = 0;
        long afSince = 0L;
        fileLocation = 0L;
        int oomi = 0;
        long recordStart = -1L;
        int tlhReplenishment = 0;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            filePointer = in.getBufferedFilePointer();
            line = in.readLineBuffered();
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                block165: {
                    String str;
                    this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                    this.overall = 30 + (int)(40.0f * (float)fileLocation / (float)fileSize);
                    if ((line = line.trim()).startsWith("<CON[")) {
                        i = line.indexOf(93);
                        if (i != -1) {
                            afNumber = Integer.parseInt(line.substring(5, i));
                        }
                        if ((i = line.indexOf("Concurrent collection,")) != -1) {
                            this.inCON = true;
                            recordStart = filePointer;
                            k = line.indexOf("ms");
                            if (k != -1) {
                                afSince = Long.parseLong(line.substring(line.lastIndexOf(",") + 2, k - 1));
                            }
                            if (totalGC + 1 < this.gi.freeBefore.length && (j = line.indexOf("(")) != -1 && (k = line.indexOf("/")) != -1 && (l = line.indexOf(")")) != -1) {
                                this.gi.freeBefore[totalGC + 1] = Long.parseLong(line.substring(j + 1, k));
                                this.gi.totalBefore[totalGC + 1] = Long.parseLong(line.substring(k + 1, l));
                                str = line.substring(l + 1);
                                if (str != null && str.length() != 0 && (j = str.indexOf("(")) != -1 && (k = str.indexOf("/")) != -1 && (l = str.indexOf(")")) != -1) {
                                    this.gi.freeLOA[totalGC + 1] = Long.parseLong(str.substring(j + 1, k));
                                    this.gi.totalLOA[totalGC + 1] = Long.parseLong(str.substring(k + 1, l));
                                    int n = totalGC + 1;
                                    this.gi.totalBefore[n] = this.gi.totalBefore[n] + this.gi.totalLOA[totalGC + 1];
                                }
                            }
                        } else {
                            i = line.indexOf("completed in");
                            if (i != -1) {
                                if (totalGC >= 0 && recordStart != -1L) {
                                    this.gi.filePointer[totalGC] = recordStart;
                                    recordStart = -1L;
                                }
                                this.inCON = false;
                                j = line.indexOf("ms");
                                if (j != -1) {
                                    this.gi.completed[totalGC] = Long.parseLong(line.substring(1 + i + "completed in".length(), j - 1));
                                }
                            }
                        }
                    } else if (line.indexOf("<AF[") >= 0) {
                        i = line.indexOf(93);
                        if (i != -1) {
                            try {
                                afNumber = Integer.parseInt(line.substring(4, i));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((i = line.indexOf("Allocation Failure. need")) != -1) {
                            this.inAF = true;
                            recordStart = filePointer;
                            j = line.indexOf("bytes");
                            if (j != -1) {
                                afSize = Long.parseLong(line.substring(line.indexOf("need") + "need".length() + 1, j - 1));
                                k = line.indexOf("ms");
                                if (k != -1) {
                                    afSince = Long.parseLong(line.substring(2 + j + "bytes".length(), k - 1));
                                }
                            }
                        } else {
                            i = line.indexOf("Allocation Failure caused by");
                            if (i != -1) {
                                if (line.contains(TLH)) {
                                    ++tlhReplenishment;
                                }
                                this.inAF = true;
                                afSize = -1L;
                                j = line.indexOf(",");
                                if (j != -1 && (k = line.indexOf("ms")) != -1) {
                                    afSince = Long.parseLong(line.substring(2 + j, k - 1));
                                }
                            } else {
                                i = line.indexOf("completed in");
                                if (i != -1) {
                                    this.inAF = false;
                                    j = line.indexOf("ms");
                                    if (totalGC >= 0 && recordStart != -1L) {
                                        this.gi.filePointer[totalGC] = recordStart;
                                        recordStart = -1L;
                                    }
                                    if (totalGC >= 0 && j != -1) {
                                        this.gi.completed[totalGC] = Long.parseLong(line.substring(1 + i + "completed in".length(), j - 1));
                                    }
                                } else if (line.indexOf(OOMsignature) != -1) {
                                    this.gi.outOfHeapSpace[oomi++] = totalGC;
                                } else if (totalGC + 1 < this.gi.freeBefore.length && (i = line.indexOf(BEFOREsignature)) != -1 && (j = line.indexOf("(")) != -1 && (k = line.indexOf("/")) != -1 && (l = line.indexOf(")")) != -1) {
                                    this.gi.freeBefore[totalGC + 1] = Long.parseLong(line.substring(j + 1, k));
                                    this.gi.totalBefore[totalGC + 1] = Long.parseLong(line.substring(k + 1, l));
                                    str = line.substring(l + 1);
                                    if (str != null && str.length() != 0 && (j = str.indexOf("(")) != -1 && (k = str.indexOf("/")) != -1 && (l = str.indexOf(")")) != -1) {
                                        this.gi.freeBeforeSOA[totalGC + 1] = this.gi.freeBefore[totalGC + 1];
                                        this.gi.totalBeforeSOA[totalGC + 1] = this.gi.totalBefore[totalGC + 1];
                                        this.gi.freeBeforeLOA[totalGC + 1] = Long.parseLong(str.substring(j + 1, k));
                                        this.gi.totalBeforeLOA[totalGC + 1] = Long.parseLong(str.substring(k + 1, l));
                                        this.gi.freeBefore[totalGC + 1] = this.gi.freeBeforeSOA[totalGC + 1] + this.gi.freeBeforeLOA[totalGC + 1];
                                        this.gi.totalBefore[totalGC + 1] = this.gi.totalBeforeSOA[totalGC + 1] + this.gi.totalBeforeLOA[totalGC + 1];
                                    }
                                }
                            }
                        }
                    } else {
                        if (line.startsWith("<GC(")) {
                            try {
                                i = line.indexOf("GC cycle started");
                                if (i != -1) {
                                    int index_of_number;
                                    try {
                                        dt = formatter.parse(line.substring(1 + i + "GC cycle started".length()));
                                    }
                                    catch (ParseException pe) {
                                        try {
                                            dt = formatterUS.parse(line.substring(1 + i + "GC cycle started".length()));
                                        }
                                        catch (ParseException pe2) {
                                            String errString = "Date ParseException while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
                                            System.out.println(errString);
                                            if (!headless) {
                                                this.ha.handleException(pe2);
                                                this.jp.dispose();
                                            }
                                            this.done = true;
                                            return String.valueOf(errString) + "<BR>" + this.getStackTrace(pe2);
                                        }
                                    }
                                    ++totalGC;
                                    if (recordStart != -1L) {
                                        this.gi.filePointer[totalGC] = recordStart;
                                    }
                                    if ((i = line.lastIndexOf(41)) != -1 && (index_of_number = line.lastIndexOf("<GC(")) >= 0) {
                                        this.gi.ngc[totalGC] = nextGcNumber = Integer.parseInt(line.substring(index_of_number + 4, i));
                                        if (nextGcNumber < gcNumber) {
                                            ++numberOfSet;
                                        }
                                        gcNumber = nextGcNumber;
                                    }
                                    if (recordStart == -1L) {
                                        this.gi.filePointer[totalGC] = filePointer;
                                    }
                                    this.gi.timestamp[totalGC] = dt.getTime();
                                    if (afSize != 0L) {
                                        if (afSize > 0L) {
                                            this.gi.af[totalGC] = afSize;
                                        }
                                        this.gi.since[totalGC] = afSince;
                                        this.gi.naf[totalGC] = afNumber;
                                        afSize = 0L;
                                    } else if (this.inAF) {
                                        this.gi.naf[totalGC] = afNumber;
                                    } else if (this.inCON) {
                                        this.gi.naf[totalGC] = afNumber;
                                        this.gi.since[totalGC] = afSince;
                                    }
                                    break block165;
                                }
                                if (totalGC >= 0) {
                                    i = line.indexOf("): freed");
                                    if (i != -1) {
                                        j = line.indexOf("bytes");
                                        if (j != -1) {
                                            this.gi.freed[totalGC] = Long.parseLong(line.substring(1 + i + "): freed".length(), j - 1));
                                        }
                                        if ((i = line.indexOf("free (")) != -1) {
                                            j = line.indexOf("/");
                                            if (j != -1) {
                                                this.gi.free[totalGC] = Long.parseLong(line.substring(i + "free (".length(), j));
                                                k = line.lastIndexOf(")");
                                                if (k != -1) {
                                                    this.gi.total[totalGC] = Long.parseLong(line.substring(j + 1, k));
                                                }
                                            }
                                            if ((i = line.indexOf("in ")) != -1 && (j = line.indexOf(" ms")) != -1) {
                                                this.gi.gccompleted[totalGC] = Long.parseLong(line.substring(i + "in ".length(), j));
                                            }
                                        }
                                    } else {
                                        i = line.indexOf(": mark:");
                                        if (i != -1) {
                                            j = line.indexOf("ms");
                                            if (j != -1) {
                                                this.gi.mark[totalGC] = Long.parseLong(line.substring(1 + i + ": mark:".length(), j - 1));
                                            }
                                            if ((i = line.indexOf("sweep:")) != -1) {
                                                j = line.indexOf("ms", i);
                                                if (j != -1) {
                                                    this.gi.sweep[totalGC] = Long.parseLong(line.substring(1 + i + "sweep:".length(), j - 1));
                                                }
                                                if ((i = line.indexOf("compact:")) != -1 && (j = line.indexOf("ms", i)) != -1) {
                                                    this.gi.compact[totalGC] = Long.parseLong(line.substring(1 + i + "compact:".length(), j - 1));
                                                }
                                            }
                                        } else {
                                            pinIdx = line.indexOf("pinned=");
                                            if (pinIdx != -1) {
                                                i = line.indexOf("(classes");
                                                if (i != -1 && (pinned = Long.parseLong(line.substring(pinIdx + "pinned=".length(), i))) > maxPinned) {
                                                    maxPinned = pinned;
                                                }
                                                if ((pinIdx = line.indexOf("classes=")) != -1 && (j = line.indexOf("/freeclasses")) != -1 && (classes = Long.parseLong(line.substring(pinIdx + "classes=".length(), j))) > maxClass) {
                                                    maxClass = classes;
                                                    pCluster = pinned - classes;
                                                }
                                                if ((pinIdx = line.indexOf("dosed=")) != -1) {
                                                    j = line.indexOf("movable");
                                                    if (j != -1) {
                                                        dosed = Long.parseLong(line.substring(pinIdx + "dosed=".length(), j - 1));
                                                    }
                                                    if (dosed > maxDosed) {
                                                        maxDosed = dosed;
                                                    }
                                                }
                                            } else {
                                                i = line.indexOf(": heap layout:  ");
                                                if (i > 0 && (j = line.substring(i + 16).indexOf("(")) != -1 && (k = line.indexOf("/")) != -1 && (l = line.substring(i + 16).indexOf(")")) != -1) {
                                                    this.gi.freeSOA[totalGC] = Long.parseLong(line.substring(i + 16 + j + 1, k));
                                                    if (this.debug && this.gi.freeSOA[totalGC] == 0L) {
                                                        System.out.println(String.valueOf(totalGC) + ":" + this.gi.freeSOA[totalGC] + ":" + line);
                                                    }
                                                    this.gi.totalSOA[totalGC] = Long.parseLong(line.substring(k + 1, l + i + 16));
                                                    str = line.substring(l + i + 16 + 1);
                                                    if (str != null && str.length() != 0 && (j = str.indexOf("(")) != -1 && (k = str.indexOf("/")) != -1 && (l = str.indexOf(")")) != -1) {
                                                        this.gi.freeLOA[totalGC] = Long.parseLong(str.substring(j + 1, k));
                                                        this.gi.totalLOA[totalGC] = Long.parseLong(str.substring(k + 1, l));
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                break block165;
                            }
                            catch (Exception e) {
                                System.out.println("Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line);
                                if (!headless) {
                                    this.ha.handleException(e);
                                }
                                filePointer = in.getBufferedFilePointer();
                                line = in.readLineBuffered();
                                ++lineNumber;
                                continue;
                            }
                        }
                        pinIdx = line.indexOf("pinned=");
                        if (pinIdx != -1) {
                            i = line.indexOf("(classes");
                            if (i != -1 && (pinned = Long.parseLong(line.substring(pinIdx + "pinned=".length(), i))) > maxPinned) {
                                maxPinned = pinned;
                            }
                            if ((pinIdx = line.indexOf("classes=")) != -1 && (i = line.indexOf("/freeclasses")) != -1 && (classes = Long.parseLong(line.substring(pinIdx + "classes=".length(), i))) > maxClass) {
                                maxClass = classes;
                                pCluster = pinned - classes;
                            }
                            if ((pinIdx = line.indexOf("dosed=")) != -1 && (i = line.indexOf("movable")) != -1 && (dosed = Long.parseLong(line.substring(pinIdx + "dosed=".length(), i - 1))) > maxDosed) {
                                maxDosed = dosed;
                            }
                        } else if (this.hasMessageSov(line)) {
                            messageLine[messagei] = line;
                            this.gi.messages[messagei++] = totalGC == -1 ? 0 : totalGC;
                        }
                    }
                }
                filePointer = in.getBufferedFilePointer();
                line = in.readLineBuffered();
                ++lineNumber;
                if (line == null) continue;
                fileLocation += (long)line.length();
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        this.current = 0;
        this.overall = 70;
        if (totalGC == 0) {
            numberOfSet = 0;
        }
        this.gi.numberOfSet = numberOfSet;
        i = 0;
        while (i < this.gi.free.length) {
            if (this.gi.af[i] != 0L) {
                ++this.gi.numberOfAF;
            }
            ++i;
        }
        String trend = "";
        String summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
        int maxOverhead = 0;
        int tempOverhead = 0;
        int maxOverheadIndex = 0;
        long maxLO = 0L;
        int numberOfLO = 0;
        int maxLOIndex = 0;
        int numberOf100 = 0;
        int nGC = 999999999;
        long completedAll = 0L;
        long sinceAll = 0L;
        long gcCompletedAll = 0L;
        long gcTime = 0L;
        long startGCTime = 0L;
        int start = 0;
        long maxUsage = 0L;
        int maxUsageIndex = 0;
        long usageAll = 0L;
        int numberOfExplicitGC = 0;
        long cycle = 0L;
        i = 0;
        while (i < this.gi.free.length) {
            int m;
            int oomIndex;
            int oh;
            int[] oomIndexa;
            completedAll += this.gi.completed[i];
            sinceAll += this.gi.since[i];
            gcCompletedAll += this.gi.gccompleted[i];
            if (this.gi.naf[i] == 0) {
                ++numberOfExplicitGC;
            }
            usageAll += this.gi.total[i] - this.gi.free[i];
            if (this.gi.total[i] - this.gi.free[i] > maxUsage) {
                maxUsage = this.gi.total[i] - this.gi.free[i];
                maxUsageIndex = i;
            }
            this.current = 100 * i / this.gi.free.length;
            if (this.gi.ngc[i] < nGC) {
                if (i != 0) {
                    if (!this.hasOOM(start, i - 1)) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i - 1) + "</li>";
                    }
                    if ((oomIndexa = this.indexOfOOM(start, i - 1)) == null) {
                        oh = this.getOverhead(start, i - 1);
                        summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i - 1) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i - 1);
                    } else {
                        oomIndex = 0;
                        m = 0;
                        while (m < oomIndexa.length) {
                            oomIndex = oomIndexa[m];
                            summary = m == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") : String.valueOf(summary) + "<TR>";
                            summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeSOA[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeLOA[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE))))))))));
                            ++m;
                        }
                    }
                    start = i;
                }
            } else if (i + 1 == this.gi.free.length) {
                if (!this.hasOOM(start, i)) {
                    trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i) + "</li>";
                }
                if ((oomIndexa = this.indexOfOOM(start, i)) == null) {
                    oh = this.getOverhead(start, i);
                    summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i);
                } else {
                    oomIndex = 0;
                    m = 0;
                    while (m < oomIndexa.length) {
                        oomIndex = oomIndexa[m];
                        summary = m == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") : String.valueOf(summary) + "<TR>";
                        summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeSOA[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeLOA[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE))))))))));
                        ++m;
                    }
                }
            }
            nGC = this.gi.ngc[i];
            if (!this.isStartPoint(i)) {
                tempOverhead = this.getOverhead(i);
                if (tempOverhead == 100) {
                    ++numberOf100;
                }
                if (tempOverhead > maxOverhead) {
                    maxOverheadIndex = i;
                    maxOverhead = tempOverhead;
                }
            }
            if (this.gi.af[i] > (long)(cfg.large * 1024 * 1024)) {
                ++numberOfLO;
            }
            if (this.gi.af[i] > maxLO) {
                maxLO = this.gi.af[i];
                maxLOIndex = i;
            }
            ++i;
        }
        this.overall = 90;
        this.current = 0;
        String report = "";
        String error = "";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Overall GC overhead</B></span> : " + decimalFormat.format((float)gcCompletedAll * 100.0f / (float)(this.gi.timestamp[this.gi.timestamp.length - 1] - this.gi.timestamp[0] + this.gi.gccompleted[this.gi.timestamp.length - 1])) + "%</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total GC pause</B></span> : " + numberFormatter.format(gcCompletedAll / 1000L) + " seconds </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Java heap usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + ")</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Java heap usage</B></span> : " + numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Explicit Garbage Collections</B></span> : " + numberFormatter.format(numberOfExplicitGC) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Allocation Failures caused by Thread Local Heap Replenishment</B></span> : " + numberFormatter.format(tlhReplenishment) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Allocation Request</B></span> : " + numberFormatter.format(maxLO) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxLOIndex])) + ")</li>";
        report = numberOfLO > 0 ? String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Object Requests larger than " + cfg.large + " M bytes</B></span> : " + numberFormatter.format(numberOfLO) + "</li>" : String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>There is no object request larger than " + cfg.large + " M bytes.</B></span></li>";
        if (maxClass > 0L) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + numberFormatter.format(maxClass) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + numberFormatter.format(maxDosed) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + numberFormatter.format(maxPinned) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
        }
        if (outOfHeapSpace != 0) {
            report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Java Heap Activity Analysis and Recommendations report</B> section for details)</LI><BR>";
            i = 0;
            while (i < this.gi.outOfHeapSpace.length) {
                this.current = 100 * i / this.gi.outOfHeapSpace.length;
                int oomIndex = this.gi.outOfHeapSpace[i];
                report = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(report) + "Complete Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(report) + "Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(report) + "Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(report) + "Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(report) + "Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(report) + "Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeSOA[oomIndex] <= (float)cfg.frag ? String.valueOf(report) + "Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.freeLOA[oomIndex] <= (float)cfg.frag ? String.valueOf(report) + "Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(report) + "Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(report) + "Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : (this.getRequested(oomIndex) > 0L ? String.valueOf(report) + "Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>" : String.valueOf(report) + "Could not find any Java heap problem " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<BR>"))))))))));
                ++i;
            }
        }
        if (numberOfMessages != 0) {
            int messageNumber = 0;
            error = String.valueOf(error) + "<LI><span style=\"font-weight: bold;\"><B>List of Java messages and codes</B></span></LI>";
            i = 0;
            while (i < this.gi.messages.length) {
                this.current = 100 * i / this.gi.messages.length;
                int mIndex = this.gi.messages[i];
                if (mIndex < 0) {
                    System.out.println("i=-1 at " + i);
                }
                error = (messageNumber = this.findMessageSov(messageLine[i])) >= 0 ? String.valueOf(error) + "<B>[" + formatter.format(new Date(this.gi.timestamp[mIndex])) + "] " + messageLine[i] + "<BR>Explanation: </B>" + Messages.message142[messageNumber][1] + "<BR><B>System action: </B>" + Messages.message142[messageNumber][2] + "<BR><B>User response: </B>" + Messages.message142[messageNumber][3] + "<BR><BR>" : String.valueOf(error) + "<B>[" + formatter.format(new Date(this.gi.timestamp[mIndex])) + "] " + messageLine[i] + "</B><BR><BR>";
                ++i;
            }
        }
        this.done = true;
        this.overall = 100;
        this.gi.summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.gi.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + numberOfSet + "</li><li><span style=\"font-weight: bold;\"><B>Number of Garbage Collections</B></span> : " + this.gi.free.length + "</li><li><span style=\"font-weight: bold;\"><B>Number of Allocation failures</B></span> : " + this.gi.numberOfAF + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[0])) + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[this.gi.free.length - 1])) + "</li><li><span style=\"font-weight: bold;\"><B>Number of&nbsp; Java heap exhaustion</B></span> : " + outOfHeapSpace + "</li>" + report + "<BR><li><span style=\"font-weight: bold;\"><B>Java Heap Activity Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE><BR>" + error + "</ul></html>";
        String chartString = "";
        if (!headless) {
            this.ha.ti.gcList.add(this.gi);
        } else {
            chartString = this.generateChart(this.gi, 0, option);
        }
        return String.valueOf(this.gi.summary) + chartString;
    }

    String processXverbosegc(File file, Configuration cfg, boolean headless, String option) {
        BufferedRandomAccessFile in;
        long fileSize;
        long filePointer = 0L;
        String release = null;
        String vm = null;
        String host = null;
        String os = null;
        String ncpu = null;
        String args = "";
        String temp = null;
        Object id = null;
        long startTime = 0L;
        boolean isNewDone = false;
        long maxPerm = 0L;
        long maxTenured = 0L;
        long maxNew = 0L;
        long baseNew = 0L;
        long basePerm = 0L;
        long baseTenured = 0L;
        long tempLong = 0L;
        boolean isPrintHeap = false;
        int nGC = 1;
        long newUsed = 0L;
        long newCapa = 0L;
        float lastTimestamp = 9.223372E18f;
        float currentTimestamp = 0.0f;
        long lastPermTotal = 0L;
        long lastPermFree = 0L;
        long newtenTotal = 0L;
        long newtenBefore = 0L;
        long newtenAfter = 0L;
        long numberOfExplicitGC = 0L;
        Date dt = new Date();
        ParsePosition pos = new ParsePosition(0);
        boolean innerGC = false;
        boolean pinIdx = false;
        long dosed = 0L;
        long pinned = 0L;
        long classes = 0L;
        long maxClass = 0L;
        long maxClassTS = 0L;
        long maxPinned = 0L;
        long maxPinnedTS = 0L;
        long maxDosed = 0L;
        long maxDosedTS = 0L;
        long pCluster = 0L;
        Object found = null;
        long lineNumber = 0L;
        long fileLocation = 0L;
        this.gi = new GCInfo();
        this.gi.file = file;
        this.gi.type = 2;
        Vector rv = new Vector(10, 100);
        boolean index = false;
        boolean totalNames = false;
        long totalNodes = 0L;
        String line = new String();
        String oldLine = new String();
        Vector cv = new Vector(1);
        boolean result = false;
        boolean progress = false;
        boolean p = false;
        int i = 0;
        int j = 0;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        this.gi.simpleSolaris = false;
        progress = false;
        this.overall = 0;
        this.statMessage = "Loading verbosegc log file";
        boolean gcNumber = false;
        this.gi.numberOfSet = 0;
        this.gi.numberOfAF = 0L;
        int totalGC = 0;
        boolean nextGcNumber = false;
        int outOfHeapSpace = 0;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            line = in.readLineBuffered();
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if ((line = line.trim()).startsWith(X_GC_START_SIGNATURE)) {
                    ++totalGC;
                }
                line = in.readLineBuffered();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = (int)(30.0f * (float)fileLocation / (float)fileSize);
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        if (totalGC == 0) {
            if (this.debug) {
                System.out.println("totalGC= " + totalGC);
            }
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find any Xverbose garbage collection log", "Information", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot find any Xverbose garbage collection log";
        }
        if (totalGC > Integer.MAX_VALUE) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries", "Error", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries";
        }
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.timestamp = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freePerm = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(1 * totalGC) + " bytes.");
        }
        this.gi.isFullGC = new boolean[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalPermBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freePermBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.free = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.total = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.mark = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.sweep = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.compact = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.af = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.since = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.completed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.ngc = new int[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.gccompleted = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.naf = new int[totalGC];
        this.gi.rangePerm = new long[totalGC];
        this.gi.rangeTenured = new long[totalGC];
        this.gi.filePointer = new long[totalGC];
        if (outOfHeapSpace != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
            }
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
        } else {
            this.gi.outOfHeapSpace = null;
        }
        boolean[] isOOM = new boolean[totalGC];
        this.statMessage = "Parsing Xverbosegc log file";
        totalGC = -1;
        nextGcNumber = false;
        gcNumber = false;
        long afSize = 0L;
        boolean afNumber = false;
        long afSince = 0L;
        fileLocation = 0L;
        lineNumber = 0L;
        boolean oomi = false;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            filePointer = in.getBufferedFilePointer();
            line = in.readLineBuffered();
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = 30 + (int)(40.0f * (float)fileLocation / (float)fileSize);
                if (line.startsWith(X_NCPU_SIGNATURE)) {
                    ncpu = line.substring(X_NCPU_SIGNATURE.length(), line.lastIndexOf(">"));
                } else if (line.startsWith(X_HOST_SIGNATURE)) {
                    host = line.substring(X_HOST_SIGNATURE.length(), line.lastIndexOf(">"));
                } else if (line.startsWith(X_OS_SIGNATURE)) {
                    os = line.substring(X_OS_SIGNATURE.length(), line.lastIndexOf(">"));
                } else if (line.startsWith(X_RELEASE_SIGNATURE)) {
                    release = line.substring(X_RELEASE_SIGNATURE.length() + 1, line.lastIndexOf("\""));
                } else if (line.startsWith(X_VM_SIGNATURE)) {
                    vm = line.substring(X_VM_SIGNATURE.length() + 1, line.lastIndexOf("\""));
                } else if (line.startsWith(X_ARG_SIGNATURE) || line.startsWith(X_OPT_SIGNATURE)) {
                    args = String.valueOf(args) + "<BR>" + line.substring(X_ARG_SIGNATURE.length(), line.lastIndexOf(">"));
                } else if (line.startsWith(X_NEW_RESERVED_SIGNATURE)) {
                    maxNew = 1024L * Long.parseLong(line.substring(X_NEW_RESERVED_SIGNATURE.length(), line.indexOf(X_EOL_SIGNATURE)));
                } else if (line.startsWith(X_OLD_RESERVED_SIGNATURE)) {
                    maxTenured = 1024L * Long.parseLong(line.substring(X_OLD_RESERVED_SIGNATURE.length(), line.indexOf(X_EOL_SIGNATURE)));
                } else if (line.startsWith(X_PERM_RESERVED_SIGNATURE)) {
                    maxPerm = 1024L * Long.parseLong(line.substring(X_PERM_RESERVED_SIGNATURE.length(), line.indexOf(X_EOL_SIGNATURE)));
                } else if (line.startsWith(X_START_TIME_SIGNATURE)) {
                    try {
                        dt = formatterX.parse(line.substring(X_START_TIME_SIGNATURE.length() + 1, line.lastIndexOf("\"")));
                        startTime = dt.getTime();
                    }
                    catch (ParseException pe) {
                        startTime = cfg.defaultStartTime;
                    }
                    ++this.gi.numberOfSet;
                    nGC = 1;
                } else if (line.startsWith(X_GC_START_SIGNATURE)) {
                    this.gi.ngc[++totalGC] = nGC++;
                    this.gi.filePointer[totalGC] = filePointer;
                    this.gi.rangePerm[totalGC] = maxPerm;
                    this.gi.rangeTenured[totalGC] = maxTenured;
                    temp = this.getColumn(line, 1);
                    if (temp != null && Integer.parseInt(temp) == 2) {
                        this.gi.isFullGC[totalGC] = true;
                    }
                    if ((temp = this.getColumn(line, 3)) != null) {
                        this.gi.timestamp[totalGC] = (long)(Float.parseFloat(temp) * 1000.0f) + startTime;
                    }
                    if ((temp = this.getColumn(line, 20)) != null) {
                        this.gi.gccompleted[totalGC] = (long)(Float.parseFloat(temp) * 1000.0f);
                    }
                    if ((temp = this.getColumn(line, 18)) != null) {
                        this.gi.totalPermBefore[totalGC] = Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 16)) != null) {
                        this.gi.freePermBefore[totalGC] = this.gi.totalPermBefore[totalGC] - Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 17)) != null) {
                        this.gi.freePerm[totalGC] = this.gi.totalPermBefore[totalGC] - Long.parseLong(temp);
                        if (this.gi.freePerm[totalGC] == 0L && this.gi.totalPermBefore[totalGC] == maxPerm) {
                            isOOM[totalGC] = true;
                        }
                    }
                    if ((temp = this.getColumn(line, 15)) != null) {
                        this.gi.totalBefore[totalGC] = this.gi.total[totalGC] = Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 13)) != null) {
                        this.gi.freeBefore[totalGC] = this.gi.totalBefore[totalGC] - Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 14)) != null) {
                        this.gi.free[totalGC] = this.gi.total[totalGC] - Long.parseLong(temp);
                        if (this.gi.free[totalGC] == 0L && this.gi.total[totalGC] == maxTenured) {
                            isOOM[totalGC] = true;
                        }
                    }
                    if ((temp = this.getColumn(line, 9)) != null) {
                        newCapa = Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 12)) != null) {
                        this.gi.totalNursery[totalGC] = this.gi.totalNurseryBefore[totalGC] = (newCapa += Long.parseLong(temp));
                    }
                    if ((temp = this.getColumn(line, 7)) != null) {
                        newUsed = Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 10)) != null) {
                        this.gi.freeNurseryBefore[totalGC] = this.gi.totalNurseryBefore[totalGC] - (newUsed += Long.parseLong(temp));
                    }
                    if ((temp = this.getColumn(line, 8)) != null) {
                        newUsed = Long.parseLong(temp);
                    }
                    if ((temp = this.getColumn(line, 11)) != null) {
                        this.gi.freeNursery[totalGC] = this.gi.totalNursery[totalGC] - (newUsed += Long.parseLong(temp));
                    }
                }
                oldLine = line;
                filePointer = in.getBufferedFilePointer();
                line = in.readLineBuffered();
                ++lineNumber;
                if (line == null) continue;
                fileLocation += (long)line.length();
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        this.current = 0;
        this.overall = 70;
        if (this.debug) {
            System.out.println("Completed parsing");
        }
        if (totalGC == 0) {
            this.gi.numberOfSet = 0;
        }
        this.gi.numberOfAF = 0L;
        i = 0;
        while (i < this.gi.isFullGC.length) {
            if (this.gi.isFullGC[i]) {
                ++this.gi.numberOfAF;
            }
            ++i;
        }
        outOfHeapSpace = 0;
        i = 0;
        while (i < isOOM.length) {
            if (isOOM[i]) {
                ++outOfHeapSpace;
            }
            ++i;
        }
        if (outOfHeapSpace != 0) {
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
            i = 0;
            j = 0;
            while (i < isOOM.length) {
                if (isOOM[i]) {
                    this.gi.outOfHeapSpace[j++] = i;
                }
                ++i;
            }
        }
        String trend = "";
        String summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
        int maxOverhead = 0;
        int tempOverhead = 0;
        int maxOverheadIndex = 0;
        long maxLO = 0L;
        int numberOfLO = 0;
        int maxLOIndex = 0;
        int numberOf100 = 0;
        nGC = 999999999;
        int start = 0;
        long sinceAll = 0L;
        long completedAll = 0L;
        long gcCompletedAll = 0L;
        long usageAll = 0L;
        long usagePermAll = 0L;
        long maxUsage = 0L;
        long maxPermUsage = 0L;
        long maxNewUsage = 0L;
        long usageNewAll = 0L;
        int maxUsageIndex = 0;
        int maxPermUsageIndex = 0;
        int maxNewUsageIndex = 0;
        long cycle = 0L;
        if (this.gi.totalPermBefore[0] == 0L) {
            int indexOfNone0 = -1;
            i = 0;
            while (i < this.gi.free.length) {
                if (this.gi.totalPermBefore[i] != 0L) {
                    indexOfNone0 = i;
                    break;
                }
                ++i;
            }
            if (indexOfNone0 > 0) {
                i = 0;
                while (i < indexOfNone0) {
                    this.gi.totalPermBefore[i] = this.gi.totalPermBefore[indexOfNone0];
                    ++i;
                }
            }
        }
        i = 0;
        while (i < this.gi.free.length) {
            int oomIndex;
            int oh;
            completedAll += this.gi.completed[i];
            if (!this.gi.simpleSolaris) {
                if (this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i] > maxNewUsage) {
                    maxNewUsage = this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                    maxNewUsageIndex = i;
                }
                if (this.gi.totalNursery[i] - this.gi.freeNursery[i] > maxNewUsage) {
                    maxNewUsage = this.gi.totalNursery[i] - this.gi.freeNursery[i];
                    maxNewUsageIndex = i;
                }
                usageNewAll += this.gi.totalNurseryBefore[i] - this.gi.freeNurseryBefore[i];
                usagePermAll += this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                if (this.debug) {
                    System.out.println("perm usage" + (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i]));
                }
            }
            gcCompletedAll += this.gi.gccompleted[i];
            if (this.gi.naf[i] == 0) {
                ++numberOfExplicitGC;
            }
            usageAll += this.gi.total[i] - this.gi.free[i];
            if (this.gi.total[i] - this.gi.free[i] > maxUsage) {
                maxUsage = this.gi.total[i] - this.gi.free[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > maxUsage) {
                maxUsage = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalPermBefore[i] - this.gi.freePermBefore[i] > maxPermUsage) {
                maxPermUsage = this.gi.totalPermBefore[i] - this.gi.freePermBefore[i];
                maxPermUsageIndex = i;
            }
            if (this.gi.totalPermBefore[i] - this.gi.freePerm[i] > maxPermUsage) {
                maxPermUsage = this.gi.totalPermBefore[i] - this.gi.freePerm[i];
                maxPermUsageIndex = i;
            }
            if (this.gi.ngc[i] < nGC) {
                this.gi.since[i] = 0L;
            } else if (i > 0) {
                this.gi.since[i] = this.gi.timestamp[i] - this.gi.timestamp[i - 1] - this.gi.gccompleted[i - 1];
            }
            sinceAll += this.gi.since[i];
            this.current = 100 * i / this.gi.free.length;
            if (this.gi.ngc[i] < nGC) {
                if (i != 0) {
                    int[] oomIndexa;
                    if (!this.hasOOM(start, i - 1)) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i - 1) + "</li>";
                        if (!this.gi.simpleSolaris) {
                            trend = String.valueOf(trend) + "<li>" + this.getTrendPerm(start, i - 1) + "</li>";
                        }
                    }
                    if ((oomIndexa = this.indexOfOOM(start, i - 1)) == null) {
                        oh = this.getOverhead(start, i - 1);
                        String ohString = null;
                        ohString = oh >= cfg.overheadRatio ? "There's " + oh + "% of overhead" : "";
                        summary = String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + "<TD>No Java heap exhaustion found." + ohString + "<TD>" + this.getTrendAnalysis(start, i - 1) + "<BR>" + this.getTrendAnalysisPerm(start, i - 1);
                    } else {
                        oomIndex = 0;
                        int n = 0;
                        while (n < oomIndexa.length) {
                            oomIndex = oomIndexa[n];
                            summary = !l ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") : String.valueOf(summary) + "<TR>";
                            if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                                summary = (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Permanent Generation is exhausted " + 100.0f * (float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Permanent Generation size using -XX:MaxPermSize option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + USER_ACTION_NONE));
                            }
                            ++n;
                        }
                    }
                    start = i;
                }
            } else if (i + 1 == this.gi.free.length) {
                int[] oomIndexa;
                if (!this.hasOOM(start, i)) {
                    trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i) + "</li>";
                    if (!this.gi.simpleSolaris) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrendPerm(start, i) + "</li>";
                    }
                }
                if ((oomIndexa = this.indexOfOOM(start, i)) == null) {
                    oh = this.getOverhead(start, i);
                    String ohString = null;
                    ohString = oh >= cfg.overheadRatio ? "There's " + oh + "% of overhead" : "";
                    summary = String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + "<TD>No Java heap exhaustion found." + ohString + "<TD>" + this.getTrendAnalysis(start, i) + "<BR>" + this.getTrendAnalysisPerm(start, i);
                } else {
                    oomIndex = 0;
                    int n = 0;
                    while (n < oomIndexa.length) {
                        summary = n == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") : String.valueOf(summary) + "<TR>";
                        oomIndex = oomIndexa[n];
                        if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                            summary = (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap Permanent Generation is exhausted " + 100.0f * (float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Permanent Generation size using -XX:MaxPermSize option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + "Java heap fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of options is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072<BR><BR>If you haven't set these configurations, please try the following options as a starting point and keep adjusting until optimal options are found:<BR>-Xk20000  -Xp32768K,4096K<BR><BR>Another option is to try the option, -Xcompactgc which compacts the Java heap every garbage collection cycle.<BR>It has given good results in solving a problem like this but it does have a performance hit.  This may be very acceptable in your situation.  The smaller you can keep your Java heap the less CPU overhead you will have on each GC.  Most people who have low CPU usage and heaps under 1 Gig do not notice the overhead.  You can determine the overhead of this parameter from the verbosegc trace.<BR><BR>Another solution is the option, -Xloratio (Large Object Area Ratio). IBM\u00ae Sovereign 1.4.2 SDK SR1 and later (build date of 20050209 and later) supports the configuration of Large Object Area to reserve the Java\u2122 heap for allocating large objects (>=64 KB).<BR>Generally, thorough analysis of the verbosegc trace is needed to decide whether to configure the -Xloratio. Use the following information as a general guideline:<BR>If you see fragmentation of the Java heap because of large objects (>= 64 KB) and there is a significant number of allocation failures due to these objects, then you can enable Xloratio with 0.2 or 0.3.<BR>From the verbosegc if you see that 0.2 or 0.3 is being used up and the Java heap is still fragmented because of large objects, then consider increasing Xloratio to 0.4 or 0.5.<BR>The one draw back of this is that when allocating a large object it will first try to put this in the regular heap instead of the Large Object Area.  Thus you may not have enough Java heap for the rest of your objects but have much available Java heap in the Large Object Area.<BR>Example:<BR>-Xloratio0.2<BR>This command reserves 20% of the active Java heap (not 20% of -Xmx but 20% of the current size of the Java heap) to the allocation of large objects (>= 64 KB) only. When an allocation request for an object less than 64 KB arrives, the process first tries to allocate from the remaining 80% of the heap. If it is unable to allocate, it then tries to allocate in the exclusively reserved area for large objects.<BR>-Xmx should be changed to make sure that you don't reduce the size of the small object area, by using the following formula:<BR>[New Xmx] = [Current Xmx] / (1 - [loratio])<BR>For example, we need at least 1462 MB for -Xmx to use -Xloratio0.3 with current -Xmx1024 MB<BR>1024 MB / (1 - 0.3) = 1462 MB" : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available in Tenured Generation " + numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available in Permanent Generation  " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<TD>" + USER_ACTION_NONE));
                        }
                        ++n;
                    }
                }
            }
            nGC = this.gi.ngc[i];
            if (!this.isStartPoint(i)) {
                tempOverhead = this.getOverhead(i);
                if (tempOverhead == 100) {
                    ++numberOf100;
                }
                if (tempOverhead > maxOverhead) {
                    maxOverheadIndex = i;
                    maxOverhead = tempOverhead;
                }
            }
            if (this.gi.af[i] > (long)(cfg.large * 1024 * 1024)) {
                ++numberOfLO;
            }
            if (this.gi.af[i] > maxLO) {
                maxLO = this.gi.af[i];
                maxLOIndex = i;
            }
            ++i;
        }
        this.overall = 90;
        this.current = 0;
        String report = "";
        if (this.gi.noTimestamp) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\">Enable -XX:+PrintGCTimeStamps to collect timestamp information on J2SE 1.4.1 and higher</span></li>";
        } else {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Overall Garbage Collection overhead</B></span> : " + decimalFormat.format((float)gcCompletedAll * 100.0f / (float)(this.gi.timestamp[this.gi.timestamp.length - 1] - this.gi.timestamp[0])) + "%</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total time spent in non Garbage Collection</B></span> : " + numberFormatter.format((this.gi.timestamp[this.gi.timestamp.length - 1] - this.gi.timestamp[0] - gcCompletedAll) / 1000L) + " seconds </li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Garbage Collection overhead</B></span> : " + maxOverhead + "% (" + formatter.format(new Date(this.gi.timestamp[maxOverheadIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of 100% overhead</B></span> : " + numberFormatter.format(numberOf100) + "</li>";
        }
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total Garbage Collection pause</B></span> : " + numberFormatter.format(gcCompletedAll / 1000L) + " seconds </li>";
        if (maxPermUsage > 0L) {
            String pct = "";
            if (maxPerm != 0L) {
                pct = String.valueOf(100L * maxPermUsage / maxPerm) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Permanent Generation usage</B></span> : " + numberFormatter.format(maxPermUsage) + " bytes ( " + pct + formatter.format(new Date(this.gi.timestamp[maxPermUsageIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Permanent Generation usage</B></span> : " + numberFormatter.format(usagePermAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        }
        if (this.gi.simpleSolaris) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\">Enable -XX:+PrintGCDetails to collect GC detail information on J2SE 1.4.1 and higher</span></li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured+New Generation usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured+New Generation usage</B></span> : " + numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        } else {
            String pct = "";
            if (maxTenured != 0L) {
                pct = String.valueOf(100L * maxUsage / maxTenured) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured Generation usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes ( " + pct + formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + " )</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured Generation usage</B></span> : " + numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
            pct = "";
            if (maxNew != 0L) {
                pct = String.valueOf(100L * maxNewUsage / maxNew) + "% ";
            }
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum New Generation usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes ( " + pct + formatter.format(new Date(this.gi.timestamp[maxNewUsageIndex])) + " )</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average New Generation usage</B></span> : " + numberFormatter.format(usageNewAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        }
        if (maxClass > 0L) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + numberFormatter.format(maxClass) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + numberFormatter.format(maxDosed) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + numberFormatter.format(maxPinned) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
        }
        if (outOfHeapSpace != 0) {
            report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Java Heap Activity Analysis and Recommendations report</B> section for details)</LI>";
            i = 0;
            while (i < this.gi.outOfHeapSpace.length) {
                this.current = 100 * i / this.gi.outOfHeapSpace.length;
                int oomIndex = this.gi.outOfHeapSpace[i];
                if (this.gi.rangeTenured != null && this.gi.rangePerm != null) {
                    if ((float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] * 100.0f <= (float)cfg.exhaustion) {
                        report = String.valueOf(report) + "Java heap Tenured Generation is exhausted " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.rangeTenured[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>";
                    } else if ((float)this.gi.freePerm[oomIndex] / (float)this.gi.rangePerm[oomIndex] * 100.0f <= (float)cfg.exhaustion) {
                        report = String.valueOf(report) + "Java heap Permanent Generation is exhausted " + numberFormatter.format(this.gi.freePerm[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>";
                    }
                }
                ++i;
            }
        }
        String maxInfo = "";
        maxInfo = "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of New generation</B></span> : " + numberFormatter.format(Math.abs(maxNew)) + " bytes" + "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of Tenured generation</B></span> : " + numberFormatter.format(Math.abs(maxTenured)) + " bytes" + "</li><li><span style=\"font-weight: bold;\"><B>Maximum size of Permanent generation</B></span> : " + numberFormatter.format(Math.abs(maxPerm)) + " bytes";
        this.gi.summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.gi.file.getAbsolutePath() + (vm == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Java Virtual Machine</B></span> : " + vm) + (release == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Java release</B></span> : " + release) + (host == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Host Name</B></span> : " + host) + (os == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Operating System</B></span> : " + os) + (ncpu == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Number of CPU</B></span> : " + ncpu) + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + numberFormatter.format(this.gi.numberOfSet) + "</li><li><span style=\"font-weight: bold;\"><B>Number of all Garbage Collections</B></span> : " + numberFormatter.format(this.gi.free.length) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Full Garbage Collections</B></span> : " + numberFormatter.format(this.gi.numberOfAF) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Minor Garbage Collections</B></span> : " + numberFormatter.format((long)this.gi.free.length - this.gi.numberOfAF) + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[0])) + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[this.gi.free.length - 1])) + maxInfo + (args == null ? "" : "</li><li><span style=\"font-weight: bold;\"><B>Java options (size in 1024 bytes)</B></span> : " + args) + report + "<li><span style=\"font-weight: bold;\"><B>Java Heap Activity Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE>" + "</ul></html>";
        String chartString = "";
        if (!headless) {
            this.ha.ti.gcList.add(this.gi);
        } else {
            chartString = this.generateChart(this.gi, 3, option);
        }
        return String.valueOf(this.gi.summary) + chartString;
    }

    public long readBase(String line) {
        int j;
        int i = line.lastIndexOf("K [");
        if (i >= 0 && (j = line.substring(i).indexOf(",")) >= 0) {
            String t = line.substring(i + "K [".length(), j + i);
            if (t == null) {
                return 0L;
            }
            if (!t.startsWith("0x")) {
                t = "0x" + t;
            }
            return FileTask.getStringToLong(t);
        }
        return 0L;
    }

    public String readLine(BufferedRandomAccessFile in) throws IOException {
        if (this.nextLine != null) {
            String b = this.nextLine;
            this.nextLine = null;
            return b;
        }
        String buffer = in.readLineBuffered();
        ++this.lineNumber;
        if (buffer != null) {
            this.fileLocation += (long)buffer.length();
        }
        if (buffer != null && buffer.indexOf(S_UNLOADING_CLASS_SIGNATURE) > 0) {
            String temp = in.readLineBuffered();
            ++this.lineNumber;
            if (temp != null) {
                this.fileLocation += (long)temp.length();
            }
            while (temp != null && temp.indexOf(S_UNLOADING_CLASS_SIGNATURE) >= 0) {
                temp = in.readLineBuffered();
                ++this.lineNumber;
                if (temp == null) continue;
                this.fileLocation += (long)temp.length();
            }
            return String.valueOf(buffer.substring(0, buffer.indexOf(S_UNLOADING_CLASS_SIGNATURE))) + temp;
        }
        if (buffer != null && buffer.indexOf(S_DUP_FULL_SIGNATURE) > 0) {
            int idx = buffer.lastIndexOf(S_FULLGC_START_SIGNATURE);
            if (idx >= 0) {
                String temp = in.readLineBuffered();
                if (temp != null) {
                    this.nextLine = temp.startsWith(S_FULLGC_START_SIGNATURE) || temp.startsWith(S_GC_START_SIGNATURE) ? temp : String.valueOf(buffer.substring(0, idx)) + temp;
                }
                return buffer.substring(idx);
            }
        } else if (buffer != null && buffer.indexOf(S_DUP_MINOR_SIGNATURE) > 0) {
            int idx = buffer.lastIndexOf(S_GC_START_SIGNATURE);
            if (idx >= 0) {
                String temp = in.readLineBuffered();
                if (temp != null) {
                    this.nextLine = temp.startsWith(S_FULLGC_START_SIGNATURE) || temp.startsWith(S_GC_START_SIGNATURE) ? temp : String.valueOf(buffer.substring(0, idx)) + temp;
                }
                return buffer.substring(idx);
            }
        } else {
            return buffer;
        }
        return buffer;
    }

    public String readLine(BufferedReader in) throws IOException {
        if (this.nextLine != null) {
            String b = this.nextLine;
            this.nextLine = null;
            return b;
        }
        String buffer = in.readLine();
        ++this.lineNumber;
        if (buffer != null) {
            this.fileLocation += (long)buffer.length();
        }
        if (buffer != null && buffer.indexOf(S_UNLOADING_CLASS_SIGNATURE) > 0) {
            String temp = in.readLine();
            ++this.lineNumber;
            if (temp != null) {
                this.fileLocation += (long)temp.length();
            }
            while (temp != null && temp.indexOf(S_UNLOADING_CLASS_SIGNATURE) >= 0) {
                temp = in.readLine();
                ++this.lineNumber;
                if (temp == null) continue;
                this.fileLocation += (long)temp.length();
            }
            return String.valueOf(buffer.substring(0, buffer.indexOf(S_UNLOADING_CLASS_SIGNATURE))) + temp;
        }
        if (buffer != null && buffer.indexOf(S_DUP_FULL_SIGNATURE) > 0) {
            int idx = buffer.lastIndexOf(S_FULLGC_START_SIGNATURE);
            if (idx >= 0) {
                String temp = in.readLine();
                if (temp != null) {
                    this.nextLine = temp.startsWith(S_FULLGC_START_SIGNATURE) || temp.startsWith(S_GC_START_SIGNATURE) ? temp : String.valueOf(buffer.substring(0, idx)) + temp;
                }
                return buffer.substring(idx);
            }
        } else if (buffer != null && buffer.indexOf(S_DUP_MINOR_SIGNATURE) > 0) {
            int idx = buffer.lastIndexOf(S_GC_START_SIGNATURE);
            if (idx >= 0) {
                String temp = in.readLine();
                if (temp != null) {
                    this.nextLine = temp.startsWith(S_FULLGC_START_SIGNATURE) || temp.startsWith(S_GC_START_SIGNATURE) ? temp : String.valueOf(buffer.substring(0, idx)) + temp;
                }
                return buffer.substring(idx);
            }
        } else {
            return buffer;
        }
        return buffer;
    }

    public long readMax(String line) {
        int i = line.lastIndexOf(", ");
        int j = line.lastIndexOf(")");
        if (i >= 0 && j >= 0) {
            String t = line.substring(i + ", ".length(), j);
            if (t == null) {
                return 0L;
            }
            if (!t.startsWith("0x")) {
                t = "0x" + t;
            }
            return FileTask.getStringToLong(t);
        }
        return 0L;
    }

    public long readTotal(String line) {
        int j;
        String id = "total ";
        int i = line.lastIndexOf(id);
        if (i >= 0 && (j = line.substring(i).indexOf("K")) >= 0) {
            String t = line.substring(i + id.length(), j + i);
            if (t == null) {
                return 0L;
            }
            return Long.decode(t) * 1024L;
        }
        return 0L;
    }

    public long readUsed(String line) {
        int j;
        String id = "used ";
        int i = line.lastIndexOf(id);
        if (i >= 0 && (j = line.substring(i).indexOf("K")) >= 0) {
            String t = line.substring(i + id.length(), j + i);
            if (t == null) {
                return 0L;
            }
            return Long.decode(t) * 1024L;
        }
        return 0L;
    }

    String returnPolicy(Attribute[] list, long timestamp) {
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].getTimestamp() == timestamp) {
                    return "<BR><BR><B>Configuration</B><BR>" + list[i].getAttributes();
                }
                ++i;
            }
        }
        return "";
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    String processJ92(File file, Configuration cfg, boolean headless, String option) {
        BufferedRandomAccessFile in;
        long fileSize;
        long filePointer = 0L;
        StringBuffer messageBuffer = new StringBuffer();
        String[] messageLine = null;
        long numberOfExplicitGC = 0L;
        Date dt = new Date();
        ParsePosition pos = new ParsePosition(0);
        int innerGC = 0;
        boolean pinIdx = false;
        long dosed = 0L;
        long pinned = 0L;
        long classes = 0L;
        long maxClass = 0L;
        long maxClassTS = 0L;
        long maxPinned = 0L;
        long maxPinnedTS = 0L;
        long maxDosed = 0L;
        long maxDosedTS = 0L;
        long pCluster = 0L;
        Object found = null;
        long lineNumber = 0L;
        long fileLocation = 0L;
        this.gi = new GCInfo();
        this.gi.file = file;
        this.gi.type = 1;
        Vector rv = new Vector(10, 100);
        boolean index = false;
        boolean totalNames = false;
        long totalNodes = 0L;
        String line = new String();
        Vector cv = new Vector(1);
        boolean result = false;
        boolean progress = false;
        boolean p = false;
        int i = 0;
        int j = 0;
        int k = 0;
        progress = false;
        this.overall = 0;
        this.statMessage = "Loading verbosegc log file";
        boolean gcNumber = false;
        this.gi.numberOfSet = 0;
        int totalGC = 0;
        boolean nextGcNumber = false;
        int outOfHeapSpace = 0;
        int numberOfMessages = 0;
        boolean inVerbosegc = false;
        int attr = -1;
        StringBuffer attributes = new StringBuffer("");
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        boolean flag = false;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            line = in.readLineBuffered();
            if (line != null) {
                line = line.trim();
            }
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    line = in.readLineBuffered();
                    ++lineNumber;
                    continue;
                }
                if (line.length() >= 2 && line.charAt(0) == '0') {
                    line = line.substring(1);
                }
                if (line.indexOf(VERBOSEGC_START_SIGNATURE) >= 0) {
                    inVerbosegc = true;
                } else if (line.indexOf(AF_END_SIGNATURE) >= 0 || line.indexOf(SG_END_SIGNATURE) >= 0 || line.indexOf(CON_END_SIGNATURE) >= 0 || line.indexOf(GC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                } else if (line.indexOf(AF_SIGNATURE2) >= 0 || line.indexOf(SG_SIGNATURE2) >= 0 || line.indexOf(GC_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE3) >= 0) {
                    inVerbosegc = true;
                } else if (line.indexOf(VERBOSEGC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                }
                if (inVerbosegc && line.indexOf(GC_SIGNATURE2) >= 0) {
                    ++totalGC;
                }
                if (this.isOOM(line)) {
                    ++outOfHeapSpace;
                    ++numberOfMessages;
                } else if (this.hasMessageJ9(line)) {
                    ++numberOfMessages;
                }
                line = in.readLineBuffered();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = (int)(30.0f * (float)fileLocation / (float)fileSize);
            }
            in.close();
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        if (totalGC == 0) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find any verbose garbage collection log", "Information", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot find any verbose garbage collection log";
        }
        if (totalGC > Integer.MAX_VALUE) {
            if (!headless) {
                JOptionPane.showMessageDialog(this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries", "Error", 2);
                this.jp.dispose();
            }
            this.done = true;
            return "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries";
        }
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.timestamp = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNursery = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalNurseryBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.freeBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.totalBefore = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.free = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.total = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.mark = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.sweep = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.compact = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.af = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.since = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
        }
        this.gi.sinceJ9 = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.completed = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.ngc = new int[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.gccompleted = new long[totalGC];
        this.gi.filePointer = new long[totalGC];
        if (cfg.verbose) {
            System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
        }
        this.gi.naf = new int[totalGC];
        this.gi.freeSOA = new long[totalGC];
        this.gi.freeLOA = new long[totalGC];
        this.gi.totalSOA = new long[totalGC];
        this.gi.totalLOA = new long[totalGC];
        this.gi.totalBeforeSOA = new long[totalGC];
        this.gi.totalBeforeLOA = new long[totalGC];
        this.gi.freeBeforeSOA = new long[totalGC];
        this.gi.freeBeforeLOA = new long[totalGC];
        this.gi.j9collection = new int[totalGC];
        if (outOfHeapSpace != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
            }
            this.gi.outOfHeapSpace = new int[outOfHeapSpace];
        } else {
            this.gi.outOfHeapSpace = null;
        }
        if (numberOfMessages != 0) {
            if (cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * numberOfMessages) + " bytes.");
            }
            this.gi.messages = new int[numberOfMessages];
            messageLine = new String[numberOfMessages];
        } else {
            this.gi.messages = null;
        }
        lineNumber = 0L;
        boolean foundFlag = false;
        boolean anyGC = false;
        boolean newStart = false;
        this.statMessage = "Parsing verbosegc log file";
        totalGC = -1;
        nextGcNumber = false;
        gcNumber = false;
        long afSize = 0L;
        int afNumber = 0;
        long afSince = 0L;
        fileLocation = 0L;
        int oomi = 0;
        int messagei = 0;
        inVerbosegc = false;
        Attribute attribute = null;
        String at = null;
        String value = null;
        try {
            fileSize = file.length();
            in = new BufferedRandomAccessFile(file, "r");
            filePointer = in.getBufferedFilePointer();
            line = in.readLineBuffered();
            if (line != null) {
                line = line.trim();
            }
            ++lineNumber;
            if (line != null) {
                fileLocation += (long)line.length();
            }
            while (line != null) {
                if (line.length() >= 2 && line.charAt(0) == '0') {
                    line = line.substring(1);
                }
                if (line.indexOf(VERBOSEGC_START_SIGNATURE) >= 0) {
                    inVerbosegc = true;
                    if (!newStart || anyGC) {
                        ++this.gi.numberOfSet;
                    }
                    afNumber = 0;
                    foundFlag = true;
                    newStart = true;
                    anyGC = false;
                } else if (line.indexOf(AF_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE3) >= 0 || line.indexOf(GC_SIGNATURE2) >= 0 || line.indexOf(SG_SIGNATURE2) >= 0) {
                    inVerbosegc = true;
                    anyGC = true;
                    if (!foundFlag) {
                        ++this.gi.numberOfSet;
                        afNumber = 0;
                        foundFlag = true;
                    }
                } else if (line.indexOf(VERBOSEGC_END_SIGNATURE) >= 0) {
                    inVerbosegc = false;
                    foundFlag = true;
                }
                this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                this.overall = 30 + (int)(40.0f * (float)fileLocation / (float)fileSize);
                if (this.isOOM(line)) {
                    this.gi.outOfHeapSpace[oomi++] = totalGC;
                    messageLine[messagei] = line;
                    this.gi.messages[messagei++] = totalGC;
                } else if (this.hasMessageJ9(line)) {
                    messageLine[messagei] = line;
                    this.gi.messages[messagei++] = totalGC;
                } else {
                    attr = line.indexOf(SIG_ATTR);
                    if (attr >= 0) {
                        int val = line.indexOf(SIG_ATTR_VALUE);
                        if (val > 0) {
                            int st2;
                            at = null;
                            value = null;
                            int st = line.substring(attr + SIG_ATTR.length()).indexOf(34);
                            if (st > 0) {
                                at = line.substring(attr + SIG_ATTR.length(), attr + SIG_ATTR.length() + st);
                            }
                            if ((st2 = line.substring(val + SIG_ATTR_VALUE.length()).indexOf(34)) > 0) {
                                long v;
                                value = line.substring(val + SIG_ATTR_VALUE.length(), val + SIG_ATTR_VALUE.length() + st2);
                                if (value.startsWith("0x")) {
                                    v = -1L;
                                    try {
                                        v = Long.parseLong(value.substring(2), 16);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (v != -1L) {
                                        value = numberFormatter.format(v);
                                        if (at.indexOf("HeapSize") > 0) {
                                            value = String.valueOf(value) + " bytes";
                                        }
                                    }
                                } else if (at.indexOf("physicalMemory") >= 0) {
                                    v = -1L;
                                    try {
                                        v = Long.parseLong(value);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    if (v != -1L) {
                                        value = String.valueOf(numberFormatter.format(v)) + " bytes";
                                    }
                                }
                            }
                            if (at != null & value != null) {
                                if (attribute == null) {
                                    attribute = new Attribute();
                                }
                                attribute.setAttributes(String.valueOf(attribute.getAttributes()) + at + " : " + value + "<BR>");
                            }
                        }
                    } else {
                        int st;
                        attr = line.indexOf(SIG_VMARG);
                        if (attr >= 0 && (st = line.substring(attr + SIG_VMARG.length()).indexOf(34)) > 0 && (at = line.substring(attr + SIG_VMARG.length(), attr + SIG_VMARG.length() + st)) != null) {
                            if (attribute == null) {
                                attribute = new Attribute();
                            }
                            attribute.setAttributes(String.valueOf(attribute.getAttributes()) + "vm argument : " + at + "<BR>");
                        }
                    }
                }
                if (inVerbosegc) {
                    if (line.indexOf(AF_END_SIGNATURE2) >= 0) {
                        this.inAF = false;
                    } else if (line.indexOf(SG_END_SIGNATURE2) >= 0) {
                        this.inSG = false;
                    } else if (line.indexOf(AF_SIGNATURE2) >= 0 || line.indexOf(SG_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE2) >= 0 || line.indexOf(CON_SIGNATURE3) >= 0) {
                        if (line.indexOf(CON_SIGNATURE2) >= 0) {
                            innerGC = 0;
                        }
                        innerGC = 0;
                        this.inAF = line.indexOf(AF_SIGNATURE2) >= 0;
                        if (line.indexOf(SG_SIGNATURE2) >= 0) {
                            ++numberOfExplicitGC;
                            this.inSG = true;
                        }
                        this.afterGC = false;
                        i = line.indexOf(ID_SIGNATURE2);
                        if (i > 0) {
                            ++totalGC;
                        }
                        if (totalGC >= this.gi.naf.length) break;
                        flag = false;
                        if (i != -1) {
                            j = line.indexOf(MIN_SIGNATURE2);
                            if (j >= 0) {
                                k = line.indexOf(TIMESTAMP_SIGNATURE);
                                if (k >= 0) {
                                    if (totalGC >= 0 && i != -1) {
                                        this.gi.af[totalGC] = Long.parseLong(line.substring(j + MIN_SIGNATURE2.length(), k));
                                    }
                                    afNumber = Integer.parseInt(line.substring(i + ID_SIGNATURE2.length(), j));
                                }
                            } else {
                                k = line.indexOf(TIMESTAMP_SIGNATURE);
                                if (k >= 0) {
                                    afNumber = Integer.parseInt(line.substring(i + ID_SIGNATURE2.length(), k));
                                }
                            }
                            this.gi.naf[totalGC] = afNumber;
                            j = line.indexOf(TIMESTAMP_SIGNATURE);
                            if (j != -1) {
                                this.gi.filePointer[totalGC] = filePointer;
                                k = line.indexOf(INTERVAL_SIGNATURE);
                                if (k != -1) {
                                    try {
                                        dt = formatter6.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                    }
                                    catch (ParseException pe) {
                                        try {
                                            dt = formatter2.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                        }
                                        catch (ParseException pe2) {
                                            try {
                                                dt = formatterUS.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                            }
                                            catch (ParseException pe3) {
                                                try {
                                                    dt = formatter2US.parse(line.substring(j + TIMESTAMP_SIGNATURE.length(), k));
                                                }
                                                catch (ParseException pe4) {
                                                    try {
                                                        String s = line.substring(j + TIMESTAMP_SIGNATURE.length(), k);
                                                        int si = s.indexOf(" ");
                                                        if (si <= 0) {
                                                            throw new ParseException("", 0);
                                                        }
                                                        dt = formatter2.parse(s.substring(si + 1));
                                                    }
                                                    catch (ParseException pe5) {
                                                        String errString = "Date ParseException while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
                                                        System.out.println(errString);
                                                        if (!headless) {
                                                            this.ha.handleException(pe4);
                                                            this.jp.dispose();
                                                        }
                                                        this.done = true;
                                                        return String.valueOf(errString) + "<BR>" + this.getStackTrace(pe4);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    this.timestamp = dt.getTime();
                                    if (attribute != null) {
                                        attribute.setTimestamp(this.timestamp);
                                        attrList.add(attribute);
                                        attribute = null;
                                    }
                                    if ((i = line.indexOf(EOLS_SIGNATURE)) != -1) {
                                        this.gi.since[totalGC] = this.gi.sinceJ9[totalGC] = (long)Math.round(Float.parseFloat(line.substring(k + INTERVAL_SIGNATURE.length(), i)));
                                    }
                                }
                            }
                        }
                    } else {
                        if (line != null) {
                            line = line.trim();
                        }
                        if (line.length() >= 2 && line.charAt(0) == '0') {
                            line = line.substring(1);
                        }
                        if (line.indexOf(GC_END_SIGNATURE2) >= 0) {
                            this.inGC = false;
                        } else {
                            i = line.indexOf(GC_SIGNATURE2);
                            if (i >= 0) {
                                if (totalGC >= 0) {
                                    this.gi.j9collection[totalGC] = line.indexOf("scavenge") >= 0 ? 2 : 1;
                                    if (++innerGC > 1) {
                                        ++totalGC;
                                    }
                                    this.inGC = true;
                                    if (this.inAF) {
                                        this.gi.naf[totalGC] = afNumber;
                                    }
                                    this.gi.timestamp[totalGC] = this.timestamp;
                                    j = line.indexOf("\" type=");
                                    if (j > 0) {
                                        this.gi.ngc[totalGC] = Integer.parseInt(line.substring(i + GC_SIGNATURE2.length(), j));
                                    }
                                }
                            } else if (line.indexOf(TENURED_SIGNATURE2) >= 0) {
                                if (totalGC >= 0 && (i = line.indexOf("\" total=\"")) != -1) {
                                    if (!this.afterGC) {
                                        this.gi.freeBefore[totalGC] = Long.parseLong(line.substring(line.indexOf(TENURED_SIGNATURE2) + TENURED_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalBefore[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    } else {
                                        this.gi.free[totalGC] = Long.parseLong(line.substring(line.indexOf(TENURED_SIGNATURE2) + TENURED_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.total[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    }
                                }
                            } else if (line.indexOf(SOA_SIGNATURE2) >= 0) {
                                if (totalGC >= 0 && (i = line.indexOf("\" total=\"")) != -1) {
                                    if (!this.afterGC) {
                                        this.gi.freeBeforeSOA[totalGC] = Long.parseLong(line.substring(line.indexOf(SOA_SIGNATURE2) + SOA_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalBeforeSOA[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    } else {
                                        this.gi.freeSOA[totalGC] = Long.parseLong(line.substring(line.indexOf(SOA_SIGNATURE2) + SOA_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (this.debug && this.gi.freeSOA[totalGC] == 0L) {
                                            System.out.println(String.valueOf(totalGC) + ":" + this.gi.freeSOA[totalGC]);
                                        }
                                        if (j != -1) {
                                            this.gi.totalSOA[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    }
                                }
                            } else if (line.indexOf(LOA_SIGNATURE2) >= 0) {
                                if (totalGC >= 0 && (i = line.indexOf("\" total=\"")) != -1) {
                                    if (!this.afterGC) {
                                        this.gi.freeBeforeLOA[totalGC] = Long.parseLong(line.substring(line.indexOf(LOA_SIGNATURE2) + LOA_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalBeforeLOA[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    } else {
                                        this.gi.freeLOA[totalGC] = Long.parseLong(line.substring(line.indexOf(LOA_SIGNATURE2) + LOA_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalLOA[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    }
                                }
                            } else if (line.indexOf(NURSERY_SIGNATURE2) >= 0) {
                                if (totalGC >= 0 && (i = line.indexOf("\" total=\"")) != -1) {
                                    if (!this.afterGC) {
                                        this.gi.freeNurseryBefore[totalGC] = Long.parseLong(line.substring(line.indexOf(NURSERY_SIGNATURE2) + NURSERY_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalNurseryBefore[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    } else {
                                        this.gi.freeNursery[totalGC] = Long.parseLong(line.substring(line.indexOf(NURSERY_SIGNATURE2) + NURSERY_SIGNATURE2.length(), i));
                                        j = line.indexOf(PERCENT_SIGNATURE);
                                        if (j != -1) {
                                            this.gi.totalNursery[totalGC] = Long.parseLong(line.substring(i + "\" total=\"".length(), j));
                                        }
                                    }
                                }
                            } else if (line.indexOf(TOTALMS_SIGNATURE) >= 0) {
                                if (totalGC >= 0 && (i = line.indexOf(EOLS_SIGNATURE)) != -1 && this.inGC) {
                                    this.gi.gccompleted[totalGC] = (long)Float.parseFloat(line.substring(line.indexOf(TOTALMS_SIGNATURE) + TOTALMS_SIGNATURE.length(), i));
                                    this.gi.completed[totalGC] = this.gi.gccompleted[totalGC];
                                }
                            } else if (totalGC >= 0) {
                                if (line.indexOf(GC_OP) >= 0) {
                                    i = line.indexOf(MARK_SIGNATURE2);
                                    j = line.indexOf(TIMEMS_END_SIGNATURE);
                                    if (i >= 0 && j >= 0) {
                                        this.gi.mark[totalGC] = (long)Float.parseFloat(line.substring(i + MARK_SIGNATURE2.length(), j));
                                    }
                                    if ((i = line.indexOf(SWEEP_SIGNATURE2)) >= 0 && j >= 0) {
                                        this.gi.sweep[totalGC] = (long)Float.parseFloat(line.substring(i + SWEEP_SIGNATURE2.length(), j));
                                    }
                                    if ((i = line.indexOf(COMPACT_SIGNATURE2)) >= 0 && j >= 0) {
                                        this.gi.compact[totalGC] = (long)Float.parseFloat(line.substring(i + COMPACT_SIGNATURE2.length(), j));
                                    }
                                } else if (line.indexOf(GC_END) >= 0) {
                                    this.afterGC = true;
                                    i = line.indexOf(TOTAL_SIGNATURE2);
                                    j = line.indexOf(TIMESTAMP_SIGNATURE);
                                    if (i >= 0 && j >= 0) {
                                        this.gi.gccompleted[totalGC] = (long)Float.parseFloat(line.substring(i + TOTAL_SIGNATURE2.length(), j));
                                        if (this.inAF) {
                                            this.gi.completed[totalGC] = this.gi.gccompleted[totalGC];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                filePointer = in.getBufferedFilePointer();
                line = in.readLineBuffered();
                if (line != null) {
                    line = line.trim();
                }
                ++lineNumber;
                if (line == null) continue;
                fileLocation += (long)line.length();
            }
            in.close();
            if (newStart && !anyGC) {
                --this.gi.numberOfSet;
            }
        }
        catch (Exception e) {
            String errString = "Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line;
            System.out.println(errString);
            if (!headless) {
                this.ha.handleException(e);
                this.jp.dispose();
            }
            this.done = true;
            return String.valueOf(errString) + "<BR>" + this.getStackTrace(e);
        }
        Attribute[] attrArray = null;
        if (attrList.size() > 0) {
            attrArray = new Attribute[attrList.size()];
            attrArray = attrList.toArray(attrArray);
        }
        attrList = null;
        this.current = 0;
        this.overall = 70;
        if (totalGC == 0) {
            this.gi.numberOfSet = 0;
        }
        this.gi.numberOfAF = 0L;
        i = 0;
        while (i < this.gi.free.length) {
            if (this.gi.af[i] != 0L) {
                ++this.gi.numberOfAF;
            }
            ++i;
        }
        String trend = "";
        String summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
        int maxOverhead = 0;
        int tempOverhead = 0;
        int maxOverheadIndex = 0;
        long maxLO = 0L;
        int numberOfLO = 0;
        int maxLOIndex = 0;
        int numberOf100 = 0;
        int nGC = 999999999;
        int start = 0;
        long sinceAll = 0L;
        long completedAll = 0L;
        long gcCompletedAll = 0L;
        long usageAll = 0L;
        long maxUsage = 0L;
        int maxUsageIndex = 0;
        long cycle = 0L;
        i = 0;
        while (i < this.gi.free.length) {
            int l;
            int oomIndex;
            int oh;
            sinceAll += this.gi.sinceJ9[i];
            completedAll += this.gi.completed[i];
            gcCompletedAll += this.gi.gccompleted[i];
            if (this.gi.naf[i] == 0) {
                ++numberOfExplicitGC;
            }
            usageAll += this.gi.total[i] - this.gi.free[i];
            if (this.gi.total[i] - this.gi.free[i] > maxUsage) {
                maxUsage = this.gi.total[i] - this.gi.free[i];
                maxUsageIndex = i;
            }
            if (this.gi.totalBefore[i] - this.gi.freeBefore[i] > maxUsage) {
                maxUsage = this.gi.totalBefore[i] - this.gi.freeBefore[i];
                maxUsageIndex = i;
            }
            this.current = 100 * i / this.gi.free.length;
            if (this.gi.ngc[i] < nGC) {
                if (i != 0) {
                    int[] aoomIndex;
                    if (!this.hasOOM(start, i - 1)) {
                        trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i - 1) + "</li>";
                    }
                    if ((aoomIndex = this.indexOfOOM(start, i - 1)) == null) {
                        oh = this.getOverhead(start, i - 1);
                        summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i - 1) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i - 1);
                    } else {
                        oomIndex = 0;
                        l = 0;
                        while (l < aoomIndex.length) {
                            oomIndex = aoomIndex[l];
                            summary = l == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + aoomIndex.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i - 1, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) : String.valueOf(summary) + "<TR>";
                            summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(summary) + "<TD>" + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXCESSIVEGC_J9 : (this.isSOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.isLOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : String.valueOf(summary) + NOPROBLEM + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE)))))))))));
                            ++l;
                        }
                    }
                    start = i;
                }
            } else if (i + 1 == this.gi.free.length) {
                int[] oomIndexa;
                if (!this.hasOOM(start, i)) {
                    trend = String.valueOf(trend) + "<li>" + this.getTrend(start, i) + "</li>";
                }
                if ((oomIndexa = this.indexOfOOM(start, i)) == null) {
                    oh = this.getOverhead(start, i);
                    summary = oh < cfg.overheadRatio ? String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found<TD>" + this.getTrendAnalysis(start, i) : String.valueOf(summary) + "<TR><TD>#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) + "<TD>No Java heap exhaustion found. There's " + oh + "% of overhead<TD>" + this.getTrendAnalysis(start, i);
                } else {
                    oomIndex = 0;
                    l = 0;
                    while (l < oomIndexa.length) {
                        oomIndex = oomIndexa[l];
                        summary = l == 0 ? String.valueOf(summary) + "<TR><TD rowspan=\"" + oomIndexa.length + "\">#" + ++cycle + " " + this.getTimeStamp(start, i, "<BR>") + this.returnPolicy(attrArray, this.gi.timestamp[start]) : String.valueOf(summary) + "<TR>";
                        summary = this.getRequested(oomIndex) > this.gi.free[oomIndex] ? String.valueOf(summary) + "<TD>Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && this.getRequested(oomIndex) > this.gi.freeSOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && this.getRequested(oomIndex) > this.gi.freeLOA[oomIndex] ? String.valueOf(summary) + "<TD>Complete Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested with " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + "Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (this.gi.totalSOA[oomIndex] > 0L && this.getRequested(oomIndex) < 65536L && (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.totalSOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_SOA_J9 : (this.gi.totalLOA[oomIndex] > 0L && this.getRequested(oomIndex) >= 65536L && (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(summary) + "<TD>Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.totalLOA[oomIndex] + " % free [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXHAUSTION_LOA_J9 : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(summary) + "<TD>" + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_EXCESSIVEGC_J9 : (this.isSOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.isLOAFragmented(oomIndex) ? String.valueOf(summary) + "<TD>Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) > 0L && 100.0f * (float)this.getRequested(oomIndex) / (float)this.gi.free[oomIndex] <= (float)cfg.frag ? String.valueOf(summary) + "<TD>Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : (this.getRequested(oomIndex) >= (long)(cfg.large * 1024 * 1024) ? String.valueOf(summary) + "<TD>Too large object request. Could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_TOO_LARGE_REQUEST : (this.getRequested(oomIndex) > 0L ? String.valueOf(summary) + "<TD>Possible Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_FRAGMENTATION_J9 : String.valueOf(summary) + "<TD>Could not find any Java heap problem " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available [" + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "]<TD>" + USER_ACTION_NONE)))))))))));
                        ++l;
                    }
                }
            }
            nGC = this.gi.ngc[i];
            if (!this.isStartPoint(i)) {
                tempOverhead = this.getOverhead(i);
                if (tempOverhead == 100) {
                    ++numberOf100;
                }
                if (tempOverhead > maxOverhead) {
                    maxOverheadIndex = i;
                    maxOverhead = tempOverhead;
                }
            }
            if (this.gi.af[i] > (long)(cfg.large * 1024 * 1024)) {
                ++numberOfLO;
            }
            if (this.gi.af[i] > maxLO) {
                maxLO = this.gi.af[i];
                maxLOIndex = i;
            }
            ++i;
        }
        this.overall = 90;
        this.current = 0;
        String report = "";
        StringBuffer error = new StringBuffer();
        long lastValidTimestamp = this.gi.timestamp[this.gi.timestamp.length - 1];
        if (lastValidTimestamp == 0L && this.gi.timestamp.length >= 2) {
            int n = this.gi.timestamp.length - 2;
            while (n >= 0) {
                lastValidTimestamp = this.gi.timestamp[n];
                if (lastValidTimestamp != 0L) break;
                --n;
            }
        }
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Overall Garbage Collection overhead</B></span> : " + decimalFormat.format((float)completedAll * 100.0f / (float)(lastValidTimestamp - this.gi.timestamp[0])) + "%</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Garbage Collection overhead</B></span> : " + maxOverhead + "% (" + formatter.format(new Date(this.gi.timestamp[maxOverheadIndex])) + ")</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of 100% AF overhead</B></span> : " + numberFormatter.format(numberOf100) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Total Garbage Collection pause</B></span> : " + numberFormatter.format(completedAll / 1000L) + " seconds </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Tenured Area usage</B></span> : " + numberFormatter.format(maxUsage) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxUsageIndex])) + ")</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Average Tenured Area usage</B></span> : " + numberFormatter.format(usageAll / (long)(this.gi.total.length + 1)) + " bytes </li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Explicit Garbage Collection</B></span> : " + numberFormatter.format(numberOfExplicitGC) + "</li>";
        report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum Allocation Request</B></span> : " + numberFormatter.format(maxLO) + " bytes (" + formatter.format(new Date(this.gi.timestamp[maxLOIndex])) + ")</li>";
        report = numberOfLO > 0 ? String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Object Requests larger than " + cfg.large + " M bytes</B></span> : " + numberFormatter.format(numberOfLO) + "</li>" : String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>There is no object request larger than " + cfg.large + " M bytes.</B></span></li>";
        if (maxClass > 0L) {
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + numberFormatter.format(maxClass) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + numberFormatter.format(maxDosed) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + numberFormatter.format(maxPinned) + "</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
        }
        if (outOfHeapSpace != 0) {
            report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Java Heap Activity Analysis and Recommendations report</B> section for details)</LI>";
            i = 0;
            while (i < this.gi.outOfHeapSpace.length) {
                this.current = 100 * i / this.gi.outOfHeapSpace.length;
                int oomIndex = this.gi.outOfHeapSpace[i];
                if (oomIndex >= 0) {
                    report = this.isExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion in large object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAExhausted(oomIndex) ? String.valueOf(report) + "Java heap exhaustion in small object area. " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : ((float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] * 100.0f <= (float)cfg.exhaustion ? String.valueOf(report) + "Java heap critical shortage " + 100.0f * (float)this.gi.free[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAExhausting(oomIndex) ? String.valueOf(report) + "Java heap critical shortage in small object area " + 100.0f * (float)this.gi.freeSOA[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAExhausting(oomIndex) ? String.valueOf(report) + "Java heap critical shortage in large object area " + 100.0f * (float)this.gi.freeLOA[oomIndex] / (float)this.gi.total[oomIndex] + " % free " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.getOverhead(oomIndex) >= 95 ? String.valueOf(report) + "Excessive Garbage Collection detected. " + this.getOverhead(oomIndex) + "% of time is spent within Java Garbage Collector " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isSOAFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation in small object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeSOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isLOAFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation in large object area " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.freeLOA[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.isFragmented(oomIndex) ? String.valueOf(report) + "Java heap fragmentation " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : (this.getRequested(oomIndex) > 0L ? String.valueOf(report) + "Large object request:could not locate " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>" : String.valueOf(report) + "Could not find Java heap problem " + numberFormatter.format(this.getRequested(oomIndex)) + " bytes of requested space / " + numberFormatter.format(this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(this.gi.timestamp[oomIndex])) + "<BR>"))))))))));
                }
                ++i;
            }
        }
        if (numberOfMessages != 0) {
            int messageNumber = 0;
            error.append("<LI><span style=\"font-weight: bold;\"><B>List of Java messages and codes</B></span></LI>");
            i = 0;
            while (i < this.gi.messages.length) {
                if ((long)i >= cfg.limit) {
                    error.append("<BR><BR>");
                    error.append("There are ");
                    error.append(numberFormatter.format((long)this.gi.messages.length - cfg.limit));
                    error.append(" more messages. Please adjust JVM message limit in View->Option menu to see more messages");
                    error.append("<BR><BR>");
                    break;
                }
                this.current = 100 * i / this.gi.messages.length;
                int mIndex = this.gi.messages[i];
                messageNumber = this.findMessageJ9(messageLine[i]);
                if (messageNumber >= 0) {
                    error.append("<B>");
                    if (mIndex >= 0) {
                        error.append("[");
                        error.append(formatter.format(new Date(this.gi.timestamp[mIndex])));
                        error.append("] ");
                    }
                    error.append(messageLine[i]);
                    error.append("</B>");
                    if (Messages.message50[messageNumber][1].length() != 0) {
                        error.append("<BR><B>Explanation: </B>");
                        error.append(Messages.message50[messageNumber][1]);
                    }
                    if (Messages.message50[messageNumber][2].length() != 0) {
                        error.append("<BR><B>System action: </B>");
                        error.append(Messages.message50[messageNumber][2]);
                    }
                    if (Messages.message50[messageNumber][3].length() != 0) {
                        error.append("<BR><B>User response: </B>");
                        error.append(Messages.message50[messageNumber][3]);
                    }
                    error.append("<BR><BR>");
                } else if (mIndex >= 0) {
                    error.append("<B>[");
                    error.append(formatter.format(new Date(this.gi.timestamp[mIndex])));
                    error.append("] ");
                    error.append(messageLine[i]);
                    error.append("</B><BR><BR>");
                }
                ++i;
            }
        }
        this.gi.summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.gi.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + this.gi.numberOfSet + "</li><li><span style=\"font-weight: bold;\"><B>Number of Garbage Collections</B></span> : " + this.gi.free.length + "</li><li><span style=\"font-weight: bold;\"><B>Number of Allocation failures</B></span> : " + this.gi.numberOfAF + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[0])) + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + formatter.format(new Date(this.gi.timestamp[this.gi.free.length - 1])) + "</li><li><span style=\"font-weight: bold;\"><B>Number of&nbsp; Java heap exhaustion</B></span> : " + outOfHeapSpace + "</li>" + report + "<BR><li><span style=\"font-weight: bold;\"><B>Java Heap Activity Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE><BR>" + error + "</ul></html>";
        String chartString = "";
        if (!headless) {
            this.ha.ti.gcList.add(this.gi);
        } else {
            chartString = this.generateChart(this.gi, 1, option);
        }
        return String.valueOf(this.gi.summary) + chartString;
    }

    class ActualTask {
        ActualTask() {
            Date dt = new Date();
            FileTask.this.cfg = FileTask.this.ha.cfg;
            int z = 0;
            while (z < FileTask.this.file.length) {
                if (FileTask.this.fileType == 2) {
                    FileTask.this.processXverbosegc(FileTask.this.file[z], FileTask.this.ha.cfg, false, null);
                } else if (FileTask.this.fileType == 1) {
                    FileTask.this.processSolaris(FileTask.this.file[z], FileTask.this.ha.cfg, false, null);
                } else {
                    int type = FileTask.this.ha.getFileType(FileTask.this.file[z]);
                    if (type == 1) {
                        FileTask.this.processJ9(FileTask.this.file[z], FileTask.this.ha.cfg, false, null);
                    } else if (type == 2) {
                        FileTask.this.processJ92(FileTask.this.file[z], FileTask.this.ha.cfg, false, null);
                    } else {
                        FileTask.this.processSov(FileTask.this.file[z], FileTask.this.ha.cfg, false, null);
                    }
                }
                int s = FileTask.this.ha.ti.gcList.size();
                if (s != 0) {
                    FileTask.this.ha.fileTable.changeSelection(s - 1, 0, false, false);
                }
                try {
                    if (FileTask.this.ha.cfg.fileList && !FileTask.this.ha.getFileFrame().isMaximum()) {
                        FileTask.this.ha.getFileFrame().setMaximum(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FileTask.this.ha.fileTable.updateUI();
                ++z;
            }
            FileTask.this.jp.dispose();
            FileTask.this.done = true;
        }
    }
}

