/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.HeapFrame;
import com.ibm.jinwoo.gc.JDialogProgress;
import com.ibm.jinwoo.gc.ThreadHandler;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;

public class FileTaskJ9 {
    public long timestamp = 0L;
    public boolean inAF = false;
    public boolean inSG = false;
    public boolean inGC = false;
    public boolean afterGC = false;
    public static final String GC_END_SIGNATURE = "</gc>";
    public static final String AF_END_SIGNATURE = "</af>";
    public static final String SG_END_SIGNATURE = "</sys>";
    public static final String XML_SIGNATURE = "<?xml version=\"";
    public static final String AF_SIGNATURE = "<af type=";
    public static final String CON_SIGNATURE = "<con event=\"";
    public static final String GC_SIGNATURE = "<gc type=\"";
    public static final String TENURED_SIGNATURE = "<tenured freebytes=\"";
    public static final String NURSERY_SIGNATURE = "<nursery freebytes=\"";
    public static final String TOTALBYTES_SIGNATURE = "\" totalbytes=\"";
    public static final String MARK_SIGNATURE = "<timesms mark=\"";
    public static final String SWEEP_SIGNATURE = "\" sweep=\"";
    public static final String COMPACT_SIGNATURE = "\" compact=\"";
    public static final String TOTAL_SIGNATURE = "\" total=\"";
    public static final String TOTALID_SIGNATURE = "\" totalid=\"";
    public static final String PERCENT_SIGNATURE = "\" percent=\"";
    public static final String MIN_SIGNATURE = "<minimum requested_bytes=\"";
    public static final String EOL_SIGNATURE = "\">";
    public static final String EOLS_SIGNATURE = "\" />";
    public static final String ID_SIGNATURE = "\" id=\"";
    public static final String TIMESTAMP_SIGNATURE = "\" timestamp=\"";
    public static final String INTERVAL_SIGNATURE = "\" intervalms=\"";
    public static final String TOTALMS_SIGNATURE = "<time totalms=\"";
    public static final String SG_SIGNATURE = "<sys id=";
    public static final String OOM_SIGNATURE = "JVMDUMP006I Processing Dump Event \"uncaught\", detail \"java/lang/OutOfMemoryError\"";
    public static final int SIZE_OF_LARGE_OBJECT = 900000;
    public static final float RATIO_OF_HEAP_SHORTAGE = 0.1f;
    public static final String OOMsignature = "]: managing allocation failure, action=6 (";
    public static final String USER_ACTION_TOO_LARGE_REQUEST = "Deploy swprofiler to identify the source of large object request.<BR>Swprofiler can print stack traces of the threads causing problems<BR>It's available at http://www-1.ibm.com/support/docview.wss?uid=swg21162314<BR>(MustGather: Determining the application code responsible for causing allocation failures)";
    public static final String USER_ACTION_FRAGMENTATION = "Fragmentation is caused by the objects on the Java heap that can not be moved and the fact that objects need to be allocated into a contiguous space on the Java heap.<BR>One of solutions is to group unmovable objects together into pools so they do not fragment the Java heap.<BR>To size these pools the garbage collection trace, st_verify (for IBM SDK 1.4.2) or -Xtgc2 (for IBM SDK 1.3.1) needs to be enabled as well as -verbosegc trace.<BR><BR>Please refer to the following document for more information:<BR><BR>How to avoid Java heap fragmentation with 1.3.1 Service Refresh 7 and above<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21179701<BR><BR>Avoiding Java heap fragmentation with V1.4.2.<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21176363<BR><BR>Heap Fragmentation with IBM JVMs<BR>http://www-1.ibm.com/support/docview.wss?uid=swg21196072";
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    static SimpleDateFormat formatter2 = new SimpleDateFormat("MMM d HH:mm:ss yyyy");
    public GCAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    GCInfo gi = null;

    public FileTaskJ9(GCAnalyzer h, File f) {
        this.file = f;
        this.ha = h;
        this.lengthOfTask = 1000;
    }

    public FileTaskJ9(GCAnalyzer h, File f, JDialogProgress j) {
        this.file = f;
        this.ha = h;
        this.jp = j;
        this.lengthOfTask = 100;
    }

    long getCompleted(int idx) {
        if (this.gi.completed[idx] != 0L) {
            return this.gi.completed[idx];
        }
        if (this.gi.gccompleted[idx] == 0L) {
            return 0L;
        }
        int i = idx;
        while (i < this.gi.free.length) {
            if (this.gi.completed[i] != 0L) {
                return this.gi.completed[i];
            }
            ++i;
        }
        return 0L;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    long getRequested(int idx) {
        if (this.gi.af[idx] == 0L) {
            int i = idx;
            while (i >= 0) {
                if (this.gi.af[i] != 0L) {
                    return this.gi.af[i];
                }
                --i;
            }
        } else {
            return this.gi.af[idx];
        }
        return 0L;
    }

    long getSince(int idx) {
        if (this.gi.since[idx] != 0L) {
            return this.gi.since[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.gi.since[i] != 0L && this.gi.af[i] != 0L) {
                return this.gi.since[i];
            }
            --i;
        }
        return 0L;
    }

    String getTimeStamp(int x, int y, String del) {
        return String.valueOf(formatter.format(new Date(this.gi.timestamp[x]))) + del + formatter.format(new Date(this.gi.timestamp[y]));
    }

    String getTrend(int x, int y) {
        String ts = "between " + formatter.format(new Date(this.gi.timestamp[x])) + " and " + formatter.format(new Date(this.gi.timestamp[y]));
        float alpha = 0.9f;
        float st_1 = this.gi.total[x] - this.gi.free[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.total[x] - this.gi.free[x];
        float mape = 0.0f;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (maxUsed < this.gi.total[i] - this.gi.free[i]) {
                maxUsed = this.gi.total[i] - this.gi.free[i];
            }
            st1 = alpha * (float)(this.gi.total[i] - this.gi.free[i]) + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            st_1 = st1;
            st2_1 = st2;
            mape += Math.abs((float)(this.gi.total[i] - this.gi.free[i]) - st2) / (float)(this.gi.total[i] - this.gi.free[i]);
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x)) > 0.5) {
            return "Trend model not reliable (percentage error is larger than 50%) " + ts;
        }
        float number = doub;
        long max = 0L;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "Trend ratio(%): 0 (Recommended max heap size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
            }
            if (number > 4.0E9f) {
                return "Trend ratio(%): over 100 with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (max < this.gi.total[y] - this.gi.free[y]) {
            return "Trend ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " (Recommended max heap size of " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater) with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
        }
        return "Trend ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + " " + ts;
    }

    String getTrendAnalysis(int x, int y) {
        String ts = "";
        float alpha = 0.9f;
        float st_1 = this.gi.total[x] - this.gi.free[x];
        float st1 = 0.0f;
        float st2 = 0.0f;
        float st2_1 = this.gi.total[x] - this.gi.free[x];
        float mape = 0.0f;
        long maxUsed = 0L;
        int i = x + 1;
        while (i <= y) {
            if (maxUsed < this.gi.total[i] - this.gi.free[i]) {
                maxUsed = this.gi.total[i] - this.gi.free[i];
            }
            st1 = alpha * (float)(this.gi.total[i] - this.gi.free[i]) + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            st_1 = st1;
            st2_1 = st2;
            mape += Math.abs((float)(this.gi.total[i] - this.gi.free[i]) - st2) / (float)(this.gi.total[i] - this.gi.free[i]);
            ++i;
        }
        float doub = 2.0f * st_1 - st2_1 + alpha / (1.0f - alpha) * (st_1 - st2_1);
        if ((double)(mape / (float)(y - x)) > 0.5) {
            return "No action required" + ts;
        }
        float number = doub;
        long max = 0L;
        float threshold = 100.0f * (float)maxUsed;
        int i2 = 0;
        while (i2 < y - x + 1) {
            st1 = alpha * number + (1.0f - alpha) * st_1;
            st2 = alpha * st1 + (1.0f - alpha) * st2_1;
            if ((number = 2.0f * (st_1 = st1) - (st2_1 = st2) + alpha / (1.0f - alpha) * (st_1 - st2_1)) < 1.0f) {
                return "No action required. Recommended maximum Java heap size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
            }
            if (number > threshold) {
                return "There seems to be a rapid increase in Java heap usage (percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
            }
            if (number > (float)max) {
                max = (long)number;
            }
            ++i2;
        }
        if (max < this.gi.total[y] - this.gi.free[y]) {
            return "No action required. Recommended maximum Java heap size is " + numberFormatter.format(1.3f * (float)maxUsed) + " or greater (percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
        }
        return "There seems to be a steady increase in Java heap usage. ( ratio(%): " + 100.0f * (float)(max - (this.gi.total[y] - this.gi.free[y])) / (float)(this.gi.total[y] - this.gi.free[y]) + " with percentage error(%): " + 100.0f * mape / (float)(y - x) + ")" + ts;
    }

    public void go() {
        ThreadHandler worker = new ThreadHandler(){

            @Override
            public Object construct() {
                FileTaskJ9.this.current = 0;
                FileTaskJ9.this.done = false;
                FileTaskJ9.this.canceled = false;
                FileTaskJ9.this.statMessage = null;
                return new ActualTask();
            }
        };
        worker.start();
    }

    boolean hasOOM(int x, int y) {
        if (this.gi.outOfHeapSpace == null) {
            return false;
        }
        int i = 0;
        while (i < this.gi.outOfHeapSpace.length) {
            if (x <= this.gi.outOfHeapSpace[i] && y >= this.gi.outOfHeapSpace[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int indexOfOOM(int x, int y) {
        if (this.gi.outOfHeapSpace == null) {
            return -1;
        }
        int i = 0;
        while (i < this.gi.outOfHeapSpace.length) {
            if (x <= this.gi.outOfHeapSpace[i] && y >= this.gi.outOfHeapSpace[i]) {
                return this.gi.outOfHeapSpace[i];
            }
            ++i;
        }
        return -1;
    }

    public boolean isDone() {
        return this.done;
    }

    boolean isFragmented(int idx) {
        if (this.gi.free[idx] < 1000000L) {
            return false;
        }
        if ((double)((float)this.gi.free[idx] / (float)this.gi.total[idx]) > 0.1) {
            return true;
        }
        return (double)((float)this.getRequested(idx) / (float)this.gi.free[idx]) < 0.05;
    }

    boolean isStartPoint(int idx) {
        if (idx >= this.gi.free.length || idx < 0) {
            return false;
        }
        if (idx == 0) {
            return true;
        }
        return this.gi.ngc[idx - 1] >= this.gi.ngc[idx];
    }

    boolean isTooLarge(int idx) {
        if (this.getRequested(idx) < 900000L) {
            return false;
        }
        return (double)((float)this.getRequested(idx) / (float)this.gi.free[idx]) > 0.1;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    class ActualTask {
        ActualTask() {
            BufferedReader in;
            long fileSize;
            Date dt = new Date();
            ParsePosition pos = new ParsePosition(0);
            boolean pinIdx = false;
            long dosed = 0L;
            long pinned = 0L;
            long classes = 0L;
            long maxClass = 0L;
            long maxClassTS = 0L;
            long maxPinned = 0L;
            long maxPinnedTS = 0L;
            long maxDosed = 0L;
            long maxDosedTS = 0L;
            long pCluster = 0L;
            Object found = null;
            long lineNumber = 0L;
            long fileLocation = 0L;
            FileTaskJ9.this.gi = new GCInfo();
            Vector rv = new Vector(10, 100);
            boolean index = false;
            boolean totalNames = false;
            long totalNodes = 0L;
            String line = new String();
            Vector cv = new Vector(1);
            boolean result = false;
            boolean progress = false;
            boolean p = false;
            int i = 0;
            int j = 0;
            int k = 0;
            progress = false;
            FileTaskJ9.this.overall = 0;
            FileTaskJ9.this.statMessage = "Loading verbosegc log file";
            boolean gcNumber = false;
            int numberOfSet = 0;
            int totalGC = 0;
            boolean nextGcNumber = false;
            int outOfHeapSpace = 0;
            try {
                fileSize = FileTaskJ9.this.file.length();
                in = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(FileTaskJ9.this.file)));
                line = in.readLine();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                while (line != null) {
                    if ((line = line.trim()).startsWith(FileTaskJ9.GC_SIGNATURE)) {
                        ++totalGC;
                    } else if (line.startsWith(FileTaskJ9.OOM_SIGNATURE)) {
                        ++outOfHeapSpace;
                    }
                    line = in.readLine();
                    ++lineNumber;
                    if (line != null) {
                        fileLocation += (long)line.length();
                    }
                    FileTaskJ9.this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                    FileTaskJ9.this.overall = (int)(30.0f * (float)fileLocation / (float)fileSize);
                }
                in.close();
            }
            catch (Exception e) {
                System.out.println("Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line);
                FileTaskJ9.this.ha.handleException(e);
                FileTaskJ9.this.jp.dispose();
                FileTaskJ9.this.done = true;
                return;
            }
            if (totalGC == 0) {
                JOptionPane.showMessageDialog(FileTaskJ9.this.ha, "Cannot find any verbose garbage collection log", "Information", 2);
                FileTaskJ9.this.jp.dispose();
                FileTaskJ9.this.done = true;
                return;
            }
            if (totalGC > Integer.MAX_VALUE) {
                JOptionPane.showMessageDialog(FileTaskJ9.this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " entries", "Error", 2);
                FileTaskJ9.this.jp.dispose();
                FileTaskJ9.this.done = true;
                return;
            }
            System.out.println("# of GC: " + totalGC);
            FileTaskJ9.this.gi.type = 1;
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.timestamp = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.freeNursery = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.totalNursery = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.freeNurseryBefore = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.totalNurseryBefore = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.freeBefore = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.totalBefore = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.free = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.total = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.mark = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.sweep = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.compact = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.af = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(8 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.since = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.completed = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.ngc = new int[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.gccompleted = new long[totalGC];
            if (FileTaskJ9.this.ha.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * totalGC) + " bytes.");
            }
            FileTaskJ9.this.gi.naf = new int[totalGC];
            if (outOfHeapSpace != 0) {
                if (FileTaskJ9.this.ha.cfg.verbose) {
                    System.out.println(new Date() + " Requesting " + numberFormatter.format(4 * outOfHeapSpace) + " bytes.");
                }
                FileTaskJ9.this.gi.outOfHeapSpace = new int[outOfHeapSpace];
            } else {
                FileTaskJ9.this.gi.outOfHeapSpace = null;
            }
            FileTaskJ9.this.statMessage = "Parsing verbosegc log file";
            totalGC = -1;
            nextGcNumber = false;
            gcNumber = false;
            long afSize = 0L;
            int afNumber = 0;
            long afSince = 0L;
            fileLocation = 0L;
            int oomi = 0;
            try {
                fileSize = FileTaskJ9.this.file.length();
                in = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(FileTaskJ9.this.file)));
                line = in.readLine();
                ++lineNumber;
                if (line != null) {
                    fileLocation += (long)line.length();
                }
                while (line != null) {
                    FileTaskJ9.this.current = (int)(100.0f * (float)fileLocation / (float)fileSize);
                    FileTaskJ9.this.overall = 30 + (int)(40.0f * (float)fileLocation / (float)fileSize);
                    if (line.startsWith(FileTaskJ9.AF_END_SIGNATURE)) {
                        FileTaskJ9.this.inAF = false;
                    } else if (line.startsWith(FileTaskJ9.SG_END_SIGNATURE)) {
                        FileTaskJ9.this.inSG = false;
                    } else if (line.startsWith(FileTaskJ9.AF_SIGNATURE) || line.startsWith(FileTaskJ9.SG_SIGNATURE) || line.startsWith(FileTaskJ9.CON_SIGNATURE)) {
                        if (line.startsWith(FileTaskJ9.AF_SIGNATURE)) {
                            FileTaskJ9.this.inAF = true;
                        }
                        if (line.startsWith(FileTaskJ9.SG_SIGNATURE)) {
                            FileTaskJ9.this.inSG = true;
                        }
                        FileTaskJ9.this.afterGC = false;
                        i = line.indexOf(FileTaskJ9.ID_SIGNATURE);
                        if (i != -1 && (j = line.indexOf(FileTaskJ9.TIMESTAMP_SIGNATURE)) != -1) {
                            afNumber = Integer.parseInt(line.substring(i + FileTaskJ9.ID_SIGNATURE.length(), j));
                            if (totalGC + 1 < FileTaskJ9.this.gi.naf.length) {
                                FileTaskJ9.this.gi.naf[totalGC + 1] = afNumber;
                            }
                            if ((k = line.indexOf(FileTaskJ9.INTERVAL_SIGNATURE)) != -1) {
                                try {
                                    dt = formatter.parse(line.substring(j + FileTaskJ9.TIMESTAMP_SIGNATURE.length(), k));
                                }
                                catch (Exception e) {
                                    System.out.println("gotcha");
                                    dt = formatter2.parse(line.substring(j + FileTaskJ9.TIMESTAMP_SIGNATURE.length(), k));
                                }
                                FileTaskJ9.this.timestamp = dt.getTime();
                                i = line.indexOf(FileTaskJ9.EOL_SIGNATURE);
                                if (i != -1 && totalGC + 1 < FileTaskJ9.this.gi.naf.length) {
                                    FileTaskJ9.this.gi.since[totalGC + 1] = (long)Float.parseFloat(line.substring(k + FileTaskJ9.INTERVAL_SIGNATURE.length(), i));
                                }
                            }
                        }
                    } else if (line.startsWith(FileTaskJ9.XML_SIGNATURE)) {
                        ++numberOfSet;
                        afNumber = 0;
                    } else if (line.startsWith(FileTaskJ9.OOM_SIGNATURE)) {
                        FileTaskJ9.this.gi.outOfHeapSpace[oomi++] = totalGC;
                    } else if ((line = line.trim()).startsWith(FileTaskJ9.GC_END_SIGNATURE)) {
                        FileTaskJ9.this.inGC = false;
                    } else if (line.startsWith(FileTaskJ9.MIN_SIGNATURE)) {
                        i = line.indexOf(FileTaskJ9.EOLS_SIGNATURE);
                        if (i != -1 && totalGC + 1 < FileTaskJ9.this.gi.naf.length) {
                            FileTaskJ9.this.gi.af[totalGC + 1] = Long.parseLong(line.substring(FileTaskJ9.MIN_SIGNATURE.length(), i));
                        }
                    } else if (line.startsWith(FileTaskJ9.GC_SIGNATURE)) {
                        ++totalGC;
                        FileTaskJ9.this.inGC = true;
                        FileTaskJ9.this.afterGC = true;
                        if (FileTaskJ9.this.inAF) {
                            FileTaskJ9.this.gi.naf[totalGC] = afNumber;
                        }
                        FileTaskJ9.this.gi.timestamp[totalGC] = FileTaskJ9.this.timestamp;
                        i = line.indexOf(FileTaskJ9.TOTALID_SIGNATURE);
                        if (i != -1 && (j = line.indexOf(FileTaskJ9.INTERVAL_SIGNATURE)) != -1) {
                            FileTaskJ9.this.gi.ngc[totalGC] = Integer.parseInt(line.substring(i + FileTaskJ9.TOTALID_SIGNATURE.length(), j));
                        }
                    } else if (line.startsWith(FileTaskJ9.TENURED_SIGNATURE)) {
                        i = line.indexOf(FileTaskJ9.TOTALBYTES_SIGNATURE);
                        if (i != -1) {
                            if (!FileTaskJ9.this.afterGC && (FileTaskJ9.this.inAF || FileTaskJ9.this.inSG) && totalGC + 1 < FileTaskJ9.this.gi.naf.length) {
                                FileTaskJ9.this.gi.freeBefore[totalGC + 1] = Long.parseLong(line.substring(FileTaskJ9.TENURED_SIGNATURE.length(), i));
                                j = line.indexOf(FileTaskJ9.PERCENT_SIGNATURE);
                                if (j != -1) {
                                    FileTaskJ9.this.gi.totalBefore[totalGC + 1] = Long.parseLong(line.substring(i + FileTaskJ9.TOTALBYTES_SIGNATURE.length(), j));
                                }
                            } else {
                                FileTaskJ9.this.gi.free[totalGC] = Long.parseLong(line.substring(FileTaskJ9.TENURED_SIGNATURE.length(), i));
                                j = line.indexOf(FileTaskJ9.PERCENT_SIGNATURE);
                                if (j != -1) {
                                    FileTaskJ9.this.gi.total[totalGC] = Long.parseLong(line.substring(i + FileTaskJ9.TOTALBYTES_SIGNATURE.length(), j));
                                }
                            }
                        }
                    } else if (line.startsWith(FileTaskJ9.NURSERY_SIGNATURE)) {
                        i = line.indexOf(FileTaskJ9.TOTALBYTES_SIGNATURE);
                        if (i != -1) {
                            if (!FileTaskJ9.this.afterGC && (FileTaskJ9.this.inAF || FileTaskJ9.this.inSG) && totalGC + 1 < FileTaskJ9.this.gi.naf.length) {
                                FileTaskJ9.this.gi.freeNurseryBefore[totalGC + 1] = Long.parseLong(line.substring(FileTaskJ9.NURSERY_SIGNATURE.length(), i));
                                j = line.indexOf(FileTaskJ9.PERCENT_SIGNATURE);
                                if (j != -1) {
                                    FileTaskJ9.this.gi.totalNurseryBefore[totalGC + 1] = Long.parseLong(line.substring(i + FileTaskJ9.TOTALBYTES_SIGNATURE.length(), j));
                                }
                            } else {
                                FileTaskJ9.this.gi.freeNursery[totalGC] = Long.parseLong(line.substring(FileTaskJ9.NURSERY_SIGNATURE.length(), i));
                                j = line.indexOf(FileTaskJ9.PERCENT_SIGNATURE);
                                if (j != -1) {
                                    FileTaskJ9.this.gi.totalNursery[totalGC] = Long.parseLong(line.substring(i + FileTaskJ9.TOTALBYTES_SIGNATURE.length(), j));
                                }
                            }
                        }
                    } else if (line.startsWith(FileTaskJ9.TOTALMS_SIGNATURE)) {
                        i = line.indexOf(FileTaskJ9.EOLS_SIGNATURE);
                        if (i != -1) {
                            FileTaskJ9.this.gi.completed[totalGC] = (long)Float.parseFloat(line.substring(FileTaskJ9.TOTALMS_SIGNATURE.length(), i));
                        }
                    } else if (line.startsWith(FileTaskJ9.MARK_SIGNATURE) && (i = line.indexOf(FileTaskJ9.SWEEP_SIGNATURE)) != -1) {
                        FileTaskJ9.this.gi.mark[totalGC] = (long)Float.parseFloat(line.substring(FileTaskJ9.MARK_SIGNATURE.length(), i));
                        j = line.indexOf(FileTaskJ9.COMPACT_SIGNATURE);
                        if (j != -1) {
                            FileTaskJ9.this.gi.sweep[totalGC] = (long)Float.parseFloat(line.substring(i + FileTaskJ9.SWEEP_SIGNATURE.length(), j));
                            k = line.indexOf(FileTaskJ9.TOTAL_SIGNATURE);
                            if (k != -1) {
                                FileTaskJ9.this.gi.compact[totalGC] = (long)Float.parseFloat(line.substring(j + FileTaskJ9.COMPACT_SIGNATURE.length(), k));
                                i = line.indexOf(FileTaskJ9.EOLS_SIGNATURE);
                                if (i != -1) {
                                    FileTaskJ9.this.gi.gccompleted[totalGC] = (long)Float.parseFloat(line.substring(k + FileTaskJ9.TOTAL_SIGNATURE.length(), i));
                                }
                            }
                        }
                    }
                    line = in.readLine();
                    ++lineNumber;
                    if (line == null) continue;
                    fileLocation += (long)line.length();
                }
                in.close();
            }
            catch (Exception e) {
                System.out.println("Exception while parsing line " + numberFormatter.format(lineNumber) + " : " + line);
                FileTaskJ9.this.ha.handleException(e);
                FileTaskJ9.this.jp.dispose();
                FileTaskJ9.this.done = true;
                return;
            }
            FileTaskJ9.this.current = 0;
            FileTaskJ9.this.overall = 70;
            if (totalGC == 0) {
                numberOfSet = 0;
            }
            FileTaskJ9.this.gi.numberOfSet = numberOfSet;
            int numberOfAF = 0;
            i = 0;
            while (i < FileTaskJ9.this.gi.free.length) {
                if (FileTaskJ9.this.gi.af[i] != 0L) {
                    ++numberOfAF;
                }
                ++i;
            }
            String trend = "";
            String summary = "<TR><TH>Garbage collection start / finish<TH>Analysis<TH>Recommendations";
            int maxOverhead = 0;
            int tempOverhead = 0;
            int maxOverheadIndex = 0;
            long maxLO = 0L;
            int numberOfLO = 0;
            int maxLOIndex = 0;
            int numberOf100 = 0;
            int nGC = 999999999;
            int start = 0;
            i = 0;
            while (i < FileTaskJ9.this.gi.free.length) {
                int oomIndex;
                FileTaskJ9.this.current = 100 * i / FileTaskJ9.this.gi.free.length;
                if (FileTaskJ9.this.gi.ngc[i] < nGC) {
                    if (i != 0) {
                        if (!FileTaskJ9.this.hasOOM(start, i - 1)) {
                            trend = String.valueOf(trend) + "<li>" + FileTaskJ9.this.getTrend(start, i - 1) + "</li>";
                        }
                        summary = (oomIndex = FileTaskJ9.this.indexOfOOM(start, i - 1)) == -1 ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i - 1, "<BR>") + "<TD>No Java heap exhaustion found<TD>" + FileTaskJ9.this.getTrendAnalysis(start, i - 1) : ((float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] <= 0.1f ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Java heap exhaustion " + 100.0f * (float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] + " % free " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (FileTaskJ9.this.getRequested(oomIndex) > FileTaskJ9.this.gi.free[oomIndex] ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Java heap exhaustion. " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (FileTaskJ9.this.getRequested(oomIndex) < 900000L ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Possible Java heap fragmetation " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>" + FileTaskJ9.USER_ACTION_FRAGMENTATION : String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i - 1, "<BR>") + "<TD>Too large object request. Could not locate " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>" + FileTaskJ9.USER_ACTION_TOO_LARGE_REQUEST)));
                        start = i;
                    }
                } else if (i + 1 == FileTaskJ9.this.gi.free.length) {
                    if (!FileTaskJ9.this.hasOOM(start, i)) {
                        trend = String.valueOf(trend) + "<li>" + FileTaskJ9.this.getTrend(start, i) + "</li>";
                    }
                    summary = (oomIndex = FileTaskJ9.this.indexOfOOM(start, i)) == -1 ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i, "<BR>") + "<TD>No Java heap exhaustion found<TD>" + FileTaskJ9.this.getTrendAnalysis(start, i) : ((float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] <= 0.1f ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i, "<BR>") + "<TD>Java heap exhaustion " + 100.0f * (float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] + " % free " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (FileTaskJ9.this.getRequested(oomIndex) > FileTaskJ9.this.gi.free[oomIndex] ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i, "<BR>") + "<TD>Java heap exhaustion. " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>Increase maximum Java heap size using -Xmx option. If it does not work, review Java heap dump with IBM HeapAnalyzer(http://www.alphaworks.ibm.com/tech/heapanalyzer)" : (FileTaskJ9.this.getRequested(oomIndex) < 900000L ? String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i, "<BR>") + "<TD>Possible Java heap fragmetation " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>" + FileTaskJ9.USER_ACTION_FRAGMENTATION : String.valueOf(summary) + "<TR><TD>" + FileTaskJ9.this.getTimeStamp(start, i, "<BR>") + "<TD>Too large object request. Could not locate " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<TD>" + FileTaskJ9.USER_ACTION_TOO_LARGE_REQUEST)));
                }
                nGC = FileTaskJ9.this.gi.ngc[i];
                if (!FileTaskJ9.this.isStartPoint(i)) {
                    tempOverhead = Math.round((float)FileTaskJ9.this.getCompleted(i) * 100.0f / (float)(FileTaskJ9.this.getSince(i) + FileTaskJ9.this.getCompleted(i)));
                    if (tempOverhead == 100) {
                        ++numberOf100;
                    }
                    if (tempOverhead > maxOverhead) {
                        maxOverheadIndex = i;
                        maxOverhead = tempOverhead;
                    }
                }
                if (FileTaskJ9.this.gi.af[i] > 900000L) {
                    ++numberOfLO;
                }
                if (FileTaskJ9.this.gi.af[i] > maxLO) {
                    maxLO = FileTaskJ9.this.gi.af[i];
                    maxLOIndex = i;
                }
                ++i;
            }
            FileTaskJ9.this.overall = 90;
            FileTaskJ9.this.current = 0;
            String report = "";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum AF overhead</B></span> : " + maxOverhead + "% (" + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[maxOverheadIndex])) + ")</li>";
            report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of 100% overhead</B></span> : " + numberFormatter.format(numberOf100) + "</li>";
            if (numberOfLO > 0) {
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum size of Large Object Request</B></span> : " + numberFormatter.format(maxLO) + " bytes (" + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[maxLOIndex])) + ")</li>";
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Number of Large Object Requests</B></span> : " + numberFormatter.format(numberOfLO) + "</li>";
            } else {
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>There is no large object request.</B></span></li>";
            }
            if (maxClass > 0L) {
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of classes</B></span> : " + numberFormatter.format(maxClass) + "</li>";
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of dosed objects</B></span> : " + numberFormatter.format(maxDosed) + "</li>";
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Maximum number of pinned objects</B></span> : " + numberFormatter.format(maxPinned) + "</li>";
                report = String.valueOf(report) + "<li><span style=\"font-weight: bold;\"><B>Recommended size of kCluster</B></span> : " + numberFormatter.format((long)((float)maxClass * 1.1f)) + " or greater</li>";
            }
            if (outOfHeapSpace != 0) {
                report = String.valueOf(report) + "<LI><span style=\"font-weight: bold;\"><B>List of Java heap failures</B></span>(Refer to <B>Analysis and Recommendations report</B> section for details)</LI>";
                i = 0;
                while (i < FileTaskJ9.this.gi.outOfHeapSpace.length) {
                    FileTaskJ9.this.current = 100 * i / FileTaskJ9.this.gi.outOfHeapSpace.length;
                    int oomIndex = FileTaskJ9.this.gi.outOfHeapSpace[i];
                    report = (float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] <= 0.1f ? String.valueOf(report) + "Java heap exhaustion " + 100.0f * (float)FileTaskJ9.this.gi.free[oomIndex] / (float)FileTaskJ9.this.gi.total[oomIndex] + " % free " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<BR>" : (FileTaskJ9.this.getRequested(oomIndex) > FileTaskJ9.this.gi.free[oomIndex] ? String.valueOf(report) + "Java heap exhaustion. " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested while " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<BR>" : (FileTaskJ9.this.getRequested(oomIndex) < 900000L ? String.valueOf(report) + "Possible Java heap fragmetation " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes requested / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<BR>" : String.valueOf(report) + "Large object request:could not locate " + numberFormatter.format(FileTaskJ9.this.getRequested(oomIndex)) + " bytes of contiguous space / " + numberFormatter.format(FileTaskJ9.this.gi.free[oomIndex]) + " bytes available " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[oomIndex])) + "<BR>"));
                    ++i;
                }
            }
            FileTaskJ9.this.done = true;
            FileTaskJ9.this.overall = 100;
            FileTaskJ9.this.jp.dispose();
            HeapFrame hf = new HeapFrame(FileTaskJ9.this.file.getName(), FileTaskJ9.this.gi);
            hf.fileName = FileTaskJ9.this.file.getName();
            FileTaskJ9.this.gi.file = FileTaskJ9.this.file;
            JEditorPane jt = new JEditorPane("text/html", "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + FileTaskJ9.this.gi.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of verboseGC cycles</B></span> : " + numberOfSet + "</li><li><span style=\"font-weight: bold;\"><B>Number of Garbage Collections</B></span> : " + FileTaskJ9.this.gi.free.length + "</li><li><span style=\"font-weight: bold;\"><B>Number of Allocation failures</B></span> : " + numberOfAF + "</li><li><span style=\"font-weight: bold;\"><B>First Garbage Collection</B></span> : " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[0])) + "</li><li><span style=\"font-weight: bold;\"><B>Last Garbage Collection</B></span> : " + formatter.format(new Date(FileTaskJ9.this.gi.timestamp[FileTaskJ9.this.gi.free.length - 1])) + "</li><li><span style=\"font-weight: bold;\"><B>Number of&nbsp; Java heap exhaustion</B></span> : " + outOfHeapSpace + "</li>" + report + "<li><span style=\"font-weight: bold;\"><B>Analysis and Recommendations report</B></span></li>" + "<TABLE border=\"1\">" + summary + "</TABLE>" + "</ul></html>");
            jt.setDragEnabled(true);
            jt.setEditable(false);
            hf.JScrollPaneSetViewportView(jt);
            FileTaskJ9.this.ha.getJDesktopPane1().add(hf);
            FileTaskJ9.this.ha.getJDesktopPane1().getDesktopManager().activateFrame(hf);
            try {
                hf.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
    }
}

