/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.ChartPanel;
import com.ibm.jinwoo.gc.ColorComboBoxRenderer;
import com.ibm.jinwoo.gc.Configuration;
import com.ibm.jinwoo.gc.ConsolePrintStream;
import com.ibm.jinwoo.gc.ControlPanel;
import com.ibm.jinwoo.gc.FileTableModel;
import com.ibm.jinwoo.gc.FileTask;
import com.ibm.jinwoo.gc.FileTaskJ9;
import com.ibm.jinwoo.gc.GCAnalyzerAboutBox;
import com.ibm.jinwoo.gc.GCAnalyzerHeadLess;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.GCTable;
import com.ibm.jinwoo.gc.GCTableModel;
import com.ibm.jinwoo.gc.GCTableThread;
import com.ibm.jinwoo.gc.HeapFrame;
import com.ibm.jinwoo.gc.JDialogProgress;
import com.ibm.jinwoo.gc.PopupListener;
import com.ibm.jinwoo.gc.Utility;
import com.ibm.jinwoo.gc.Version;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;

public class GCAnalyzer
extends JFrame {
    public static final String LICENSE_TITLE = "Licensed Materials - Property of IBM Corp. (C) Copyright IBM Corp. 2004-2013. All Rights Reserved.";
    public static final String QUOTE = "\"";
    public static final String STANDALONE_VERSION_TEXT = "To use this feature, install a standalone version available from Help->About->Home";
    public static final String home = "https://www.ibm.com/developerworks/mydeveloperworks/groups/service/html/communityview?communityUuid=22d56091-3a7b-4497-b36e-634b51838e11";
    public static final String version = "4.0.2";
    GraphicsEnvironment ge = null;
    ColorComboBoxRenderer colorComboBoxRenderer = null;
    ButtonGroup lookAndFeelGroup = new ButtonGroup();
    boolean isChartViewEnabled;
    GCInfo giPart;
    int[] startPart;
    int[] endPart;
    DefaultListModel partModel;
    boolean debug = false;
    public GCTable ti = new GCTable();
    public FileTableModel fileModel = null;
    public JTable fileTable = null;
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    static SimpleDateFormat dateInputFormatter = new SimpleDateFormat("HH:mm:ss MM/dd/yyyy");
    public Configuration cfg;
    public ControlPanel controlPanel;
    public static final String J9_SIGNATURE = "<verbosegc";
    public static final String J9_SIGNATURE2 = "<gc type=";
    public static final String J9_SIGNATURE623 = "<cycle-start id=";
    public static final String SOV_SIGNATURE1 = "<GC(";
    public static final String SOV_SIGNATURE2 = "<AF(";
    public static final String SOL_SIGNATURE = " secs]";
    public static final String X_SIGNATURE = "GC:";
    ConsolePrintStream console;
    JDialogProgress jp;
    static final int SOLARIS = 1;
    static final int XVERBOSE = 2;
    private static final String PREFERENCE_FILE = "ga.xml";
    public static Preferences prefs = Preferences.userRoot().node("com.ibm.jinwoo.gcanalyzer");
    private FileTask task;
    private FileTaskJ9 taskJ9;
    private Timer timer;
    private Timer timerJ9;
    private JMenuItem ivjAbout_BoxMenuItem = null;
    private JMenuItem ivjUpdateMenuItem = null;
    private JMenu ivjAnalysisMenu = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JMenuItem ivjExitMenuItem = null;
    private JMenu ivjFileMenu = null;
    private JMenuItem ivjGC_ListMenuItem = null;
    private JMenuBar ivjGCAnalyzerJMenuBar = null;
    private JMenuItem ivjGraph_ViewMenuItem = null;
    private JMenuItem ivjHelp_TopicsMenuItem = null;
    private JMenu ivjHelpMenu = null;
    private JPanel ivjJFrameContentPane = null;
    private JMenuItem ivjOpenMenuItem = null;
    private JMenuItem ivjAutoOpenMenuItem = null;
    private JPanel ivjStatusBarPane = null;
    private JLabel ivjStatusMsg1 = null;
    private JLabel ivjStatusMsg2 = null;
    private JMenu ivjViewMenu = null;
    private JPanel ivjJInternalFrameContentPane = null;
    private JInternalFrame ivjConsoleFrame = null;
    private JTextArea ivjConsoleTextArea = null;
    private JScrollPane ivjConsoleScrollPane = null;
    private JCheckBoxMenuItem ivjConsoleCheckBoxMenuItem = null;
    private JCheckBoxMenuItem ivjStatusbarCheckBoxMenuItem = null;
    private JDesktopPane ivjJDesktopPane1 = null;
    private JPanel ivjJDialogContentPane = null;
    private JDialog ivjOptionDialog = null;
    private JMenuItem ivjOptionMenuItem = null;
    private JMenuItem ivjUsageMenuItem = null;
    private JMenuItem ivjDurationMenuItem = null;
    private JLabel ivjJLabel1 = null;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private JMenuItem ivjAFMenuItem = null;
    private JSeparator ivjJSeparator1 = null;
    private JButton ivjBrowseButton = null;
    private JButton updateButton = null;
    private JCheckBox ivjVerboseCheckBox = null;
    private JCheckBox ivjTerminalCheckBox = null;
    private JCheckBox ivjPointsCheckBox = null;
    private JMenuItem ivjClearMenuItem = null;
    private JSeparator ivjJSeparator2 = null;
    private JLabel ivjJLabel2 = null;
    private JCheckBox ivjSaveCheckBox = null;
    private JComboBox ivjColorComboBox = null;
    private JTextField ivjDefaultPath = null;
    private JPanel ivjJInternalFrameContentPane1 = null;
    private JScrollPane ivjDetailScrollPane = null;
    private JEditorPane ivjDetailTextPane = null;
    private JScrollPane ivjFileListScrollPane = null;
    private JInternalFrame ivjFileFrame = null;
    private JSplitPane ivjFileSplitPane = null;
    private JMenuItem ivjAFMenuItem1 = null;
    private JMenuItem ivjDurationMenuItem1 = null;
    private JPopupMenu ivjFileTableMenu = null;
    private JMenuItem ivjGC_ListMenuItem1 = null;
    private JMenuItem ivjGraph_ViewMenuItem1 = null;
    private JMenuItem ivjRefreshMenuItem = null;
    private JMenuItem ivjRefreshMenuItem1 = null;
    private JSeparator ivjJSeparator3 = null;
    private JMenuItem ivjUsageMenuItem1 = null;
    private JMenuItem ivjCloseAllMenuItem = null;
    private JMenuItem ivjCloseMenuItem = null;
    private JSeparator ivjJSeparator4 = null;
    private JSeparator ivjJSeparator5 = null;
    private JMenuItem ivjCloseAllMenuItem1 = null;
    private JMenuItem ivjCloseMenuItem1 = null;
    private JSeparator ivjJSeparator6 = null;
    private JMenuItem ivjGCViewPartMenuItem = null;
    private JPanel ivjJDialogContentPane1 = null;
    private JDialog ivjPartDialog = null;
    private JList ivjPartList = null;
    private JButton ivjPartCancelButton = null;
    private JButton ivjPartOpenButton = null;
    private JScrollPane ivjPartListScrollPane = null;
    private JMenuItem ivjGCViewPartMenuItem1 = null;
    private JMenuItem ivjGraph_ViewMenuItem11 = null;
    private JMenuItem ivjGraph_ViewMenuItem2 = null;
    private JSlider ivjJSliderFrag = null;
    private JLabel ivjJLabelFrag = null;
    private JTextField ivjJTextFieldFrag = null;
    private JPanel ivjBasic = null;
    private JPanel ivjJPanelAdvanced = null;
    private JTabbedPane ivjJTabbedPaneOption = null;
    private JPanel ivjJPanelOptionButtons = null;
    private JLabel ivjJLabelLarge = null;
    private JSlider ivjJSliderLarge = null;
    private JTextField ivjJTextFieldLarge = null;
    private JButton ivjSaveButton = null;
    private JButton ivjCloseButton = null;
    private JLabel ivjJLabelOverhead = null;
    private JSlider ivjJSliderOverhead = null;
    private JTextField ivjJTextFieldOverhead = null;
    private JPanel ivjJPanelFrag = null;
    private JLabel ivjJLabelExhaustion = null;
    private JPanel ivjJPanelLarge = null;
    private JPanel ivjJPanelLarge1 = null;
    private JPanel ivjJPanelLarge2 = null;
    private JSlider ivjJSliderExhaustion = null;
    private JTextField ivjJTextFieldExhaustion = null;
    private JCheckBox ivjAutoYCheckBox = null;
    private JCheckBox ivjJCheckBoxMax = null;
    private JButton ivjDefaultButton = null;
    private JCheckBox ivjJCheckBoxFileList = null;
    private JPanel ivjLookAndFeelPanel = null;
    private JRadioButton ivjMotifRadioButton = null;
    private JRadioButton ivjSystemRadioButton = null;
    private JRadioButton ivjMetalRadioButton = null;
    private JPanel ivjWarningPanel = null;
    private JLabel ivjWarningLabel = null;
    private JLabel ivjWarningLabel1 = null;
    private JMenuItem ivjOpenMenuItemSolaris = null;
    private JPanel ivjJDialogContentPane2 = null;
    private JLabel ivjJLabel3 = null;
    private JTextField ivjDefaultTime = null;
    private JTextField ivjEndTime = null;
    private JLabel ivjJLabel31 = null;
    private JLabel ivjJLabel32 = null;
    private JTextField ivjStartTime = null;
    private JButton ivjStatisticsButton = null;
    private JDialog ivjStatisticsDialog = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JPanel ivjStatisticsPanel = null;
    private JSplitPane ivjStatisticsSplitPane = null;
    private JEditorPane ivjStatisticsTextArea = null;
    private JButton ivjStatisticsCloseButton = null;
    private JMenuItem ivjStatisticsMenuItem = null;
    private JMenuItem ivjStatisticsMenuItem1 = null;
    private JMenuItem ivjOpenMenuItemXverbosegc = null;
    private JMenuItem ivjExportMenu = null;
    private JCheckBox ivjJCheckBoxBold = null;
    private JCheckBox ivjJCheckBoxItalic = null;
    private JLabel ivjJLabelFont = null;
    private JLabel ivjJLabelFontSize = null;
    private JLabel ivjJLabelFontStyle = null;
    private JComboBox ivjJComboBoxFont = null;
    private JTextField ivjJTextFieldFontSize = null;
    private JLabel ivjJLabelChartHeight = null;
    private JLabel ivjJLabelChartWidth = null;
    private JTextField ivjJTextFieldHeight = null;
    private JTextField ivjJTextFieldWidth = null;
    private JButton ivjDefaultToolBarButton = null;
    private JToolBar ivjJToolBar1 = null;
    private JButton ivjJToolBarButton1 = null;
    private JButton ivjJToolBarButtonExport = null;
    private JButton ivjJToolBarButton0 = null;
    private JButton ivjJToolBarButtonRefresh = null;
    private JButton ivjJToolBarButton2 = null;
    private JButton ivjJToolBarButton3 = null;
    private JButton ivjJToolBarButton4 = null;
    private JButton ivjJToolBarButton31 = null;
    private JButton ivjJToolBarButton32 = null;
    private JButton ivjJToolBarButton321 = null;
    private JButton ivjJToolBarButton3211 = null;
    private JButton ivjJToolBarButton322 = null;
    private JButton ivjJToolBarButton3221 = null;
    private JButton ivjJToolBarButton32211 = null;
    private JButton ivjJToolBarButton32212 = null;
    private JButton ivjJToolBarButton32213 = null;
    private JButton ivjJToolBarButton32214 = null;
    private JButton ivjJToolBarButton32215 = null;
    private JButton ivjJToolBarButton322151 = null;
    private JButton ivjJToolBarButton3221511 = null;
    private JToggleButton ivjJToggleButton1 = null;
    private JToggleButton ivjJToggleButton11 = null;
    private JLabel ivjJLabel4 = null;
    private JTextField ivjJTextFieldMessageLimit = null;
    private boolean isISA;
    static final String FTP_URL = "ftp://public.dhe.ibm.com/software/websphere/appserv/support/tools/pmat/";

    public GCAnalyzer() {
        this.initialize();
    }

    public void update() {
        SwingWorker<String[], Void> worker = this.createCheckUpdateWorker(true, this, false);
        worker.execute();
    }

    public void export() {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select a file to export", "Information", 1);
            return;
        }
        GCInfo gi = (GCInfo)this.ti.gcList.get(selectedRows[0]);
        String previousCsvDir = prefs.get("csvDir", Configuration.WORKINGDIR);
        JFileChooser fc = new JFileChooser(previousCsvDir);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String cvsDir = fc.getCurrentDirectory().getAbsolutePath();
            prefs.put("csvDir", cvsDir);
            if (file.exists() && JOptionPane.showConfirmDialog(this, "The file, " + file.getName() + " already exists. Do you want to overwrite it?", "Export", 0) == 1) {
                return;
            }
            GCTableModel om = new GCTableModel(gi, 0, gi.free.length - 1);
            int columnCount = om.getColumnCount();
            int rowCount = om.getRowCount();
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write("IBM Pattern Modeling and Analysis Tool for Java Garbage Collector by Jinwoo Hwang (C) Copyright IBM Corp. 2004-2012 All Rights Reserved");
                    bufferedWriter.newLine();
                    bufferedWriter.write("CSV File generated from " + gi.file.getAbsolutePath());
                    bufferedWriter.newLine();
                    int j = 0;
                    while (j < columnCount) {
                        bufferedWriter.write(QUOTE + om.getColumnName(j) + QUOTE);
                        if (j < columnCount - 1) {
                            bufferedWriter.write(",");
                        }
                        ++j;
                    }
                    bufferedWriter.newLine();
                    int i = 0;
                    while (i < rowCount) {
                        int j2 = 0;
                        while (j2 < columnCount) {
                            bufferedWriter.write(QUOTE + om.getValueAt(i, j2).toString() + QUOTE);
                            if (j2 < columnCount - 1) {
                                bufferedWriter.write(",");
                            }
                            ++j2;
                        }
                        bufferedWriter.newLine();
                        ++i;
                    }
                }
                catch (IOException e) {
                    this.handleException(e);
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.flush();
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException ex) {
                        this.handleException(ex);
                        return;
                    }
                    return;
                }
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex) {
                    this.handleException(ex);
                    return;
                }
            }
            JOptionPane.showMessageDialog(this, "Successfully exported to " + file.getAbsolutePath(), "CSV Export", 1);
        }
    }

    public GCAnalyzer(String title) {
        super(title);
    }

    public void aFMenuItem_ActionPerformed(ActionEvent actionEvent) {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] gi = new GCInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            gi[i] = (GCInfo)this.ti.gcList.get(selectedRows[i]);
            ++i;
        }
        String selectedFiles = "";
        int i2 = 0;
        while (i2 < selectedRows.length) {
            selectedFiles = String.valueOf(selectedFiles) + this.fileTable.getValueAt(selectedRows[i2], 0) + " ";
            ++i2;
        }
        int z = 0;
        while (z < gi.length) {
            if (gi[z].type == 2 || gi[z].numberOfAF == 0L) {
                JOptionPane.showMessageDialog(this, "There's no allocation failures in " + gi[z].file.getName(), "Information", 1);
            } else {
                HeapFrame hf = new HeapFrame(String.valueOf(gi[z].file.getName()) + " Allocation Failure Summary", gi[z]);
                hf.fileName = gi[z].file.getName();
                hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/failed_ovr.gif")));
                long[] min = new long[3];
                long[] max = new long[3];
                long[] avg = new long[3];
                long[] timestamp = new long[3];
                long[] sum = new long[3];
                min[0] = max[0] = gi[z].af[0];
                int minAF = 0;
                int i3 = 0;
                while (i3 < gi[z].free.length) {
                    if (gi[z].af[i3] != 0L) {
                        min[1] = max[1] = gi[z].since[i3];
                        minAF = gi[z].naf[i3];
                        break;
                    }
                    ++i3;
                }
                min[2] = max[2] = gi[z].completed[0];
                timestamp[1] = timestamp[2] = gi[z].timestamp[0];
                timestamp[0] = timestamp[2];
                int numberOfAF = 0;
                int nAF = 999999999;
                int numberOfSet = 0;
                int i4 = 0;
                while (i4 < gi[z].free.length) {
                    if (gi[z].af[i4] != 0L) {
                        if (gi[z].naf[i4] < nAF) {
                            ++numberOfSet;
                        }
                        nAF = gi[z].naf[i4];
                        if (gi[z].af[i4] > max[0]) {
                            max[0] = gi[z].af[i4];
                            timestamp[0] = gi[z].timestamp[i4];
                        }
                        if (gi[z].af[i4] < min[0]) {
                            min[0] = gi[z].af[i4];
                        }
                        sum[0] = sum[0] + gi[z].af[i4];
                        if (gi[z].since[i4] > max[1]) {
                            max[1] = gi[z].since[i4];
                        }
                        if ((minAF == 1 || gi[z].since[i4] < min[1]) && gi[z].naf[i4] != 1) {
                            min[1] = gi[z].since[i4];
                            timestamp[1] = gi[z].timestamp[i4];
                            minAF = gi[z].naf[i4];
                        }
                        sum[1] = sum[1] + gi[z].since[i4];
                        if (gi[z].completed[i4] > max[2]) {
                            max[2] = gi[z].completed[i4];
                            timestamp[2] = gi[z].timestamp[i4];
                        }
                        if (gi[z].completed[i4] < min[2]) {
                            min[2] = gi[z].completed[i4];
                        }
                        sum[2] = sum[2] + gi[z].completed[i4];
                        ++numberOfAF;
                    }
                    ++i4;
                }
                Object[] header = new Object[]{"", "Requested avg", "min", "max", "timestamp of max", "Since avg", "min", "max", "timestamp of min", "Completed avg", "min", "max", "timestamp of max"};
                Object[][] data = new Object[numberOfSet + 1][13];
                data[0][0] = "Overall";
                int i5 = 0;
                while (i5 < 3) {
                    data[0][i5 * 4 + 1] = numberFormatter.format(sum[i5] / (long)(numberOfAF - numberOfSet));
                    data[0][i5 * 4 + 2] = numberFormatter.format(min[i5]);
                    data[0][i5 * 4 + 3] = numberFormatter.format(max[i5]);
                    data[0][i5 * 4 + 4] = dateFormatter.format(new Date(timestamp[i5]));
                    ++i5;
                }
                long[] minRequested = new long[numberOfAF];
                long[] maxRequested = new long[numberOfAF];
                long[] sumRequested = new long[numberOfAF];
                long[] timeRequested = new long[numberOfAF];
                long[] countRequested = new long[numberOfAF];
                long[] minSince = new long[numberOfAF];
                long[] maxSince = new long[numberOfAF];
                long[] sumSince = new long[numberOfAF];
                long[] timeSince = new long[numberOfAF];
                long[] countSince = new long[numberOfAF];
                long[] minCompleted = new long[numberOfAF];
                long[] maxCompleted = new long[numberOfAF];
                long[] sumCompleted = new long[numberOfAF];
                long[] timeCompleted = new long[numberOfAF];
                long[] countCompleted = new long[numberOfAF];
                nAF = 999999999;
                int index = -1;
                int i6 = 0;
                while (i6 < gi[z].free.length) {
                    if (gi[z].af[i6] != 0L) {
                        if (gi[z].naf[i6] < nAF) {
                            minRequested[++index] = maxRequested[index] = gi[z].af[i6];
                            minSince[index] = maxSince[index] = gi[z].since[i6];
                            minAF = gi[z].naf[i6];
                            minCompleted[index] = maxCompleted[index] = gi[z].completed[i6];
                            timeRequested[index] = timeSince[index] = gi[z].timestamp[i6];
                            timeCompleted[index] = timeSince[index];
                        }
                        nAF = gi[z].naf[i6];
                        if (gi[z].af[i6] > maxRequested[index]) {
                            maxRequested[index] = gi[z].af[i6];
                            timeRequested[index] = gi[z].timestamp[i6];
                        }
                        if (gi[z].af[i6] < minRequested[index]) {
                            minRequested[index] = gi[z].af[i6];
                        }
                        int n = index;
                        sumRequested[n] = sumRequested[n] + gi[z].af[i6];
                        int n2 = index;
                        countRequested[n2] = countRequested[n2] + 1L;
                        if (gi[z].since[i6] > maxSince[index]) {
                            maxSince[index] = gi[z].since[i6];
                        }
                        if ((minAF == 1 || gi[z].since[i6] < minSince[index]) && gi[z].naf[i6] != 1) {
                            minSince[index] = gi[z].since[i6];
                            timeSince[index] = gi[z].timestamp[i6];
                            minAF = gi[z].naf[i6];
                        }
                        int n3 = index;
                        sumSince[n3] = sumSince[n3] + gi[z].since[i6];
                        int n4 = index;
                        countSince[n4] = countSince[n4] + 1L;
                        if (gi[z].completed[i6] > maxCompleted[index]) {
                            maxCompleted[index] = gi[z].completed[i6];
                            timeCompleted[index] = gi[z].timestamp[i6];
                        }
                        if (gi[z].completed[i6] < minCompleted[index]) {
                            minCompleted[index] = gi[z].completed[i6];
                        }
                        int n5 = index;
                        sumCompleted[n5] = sumCompleted[n5] + gi[z].completed[i6];
                        int n6 = index;
                        countCompleted[n6] = countCompleted[n6] + 1L;
                    }
                    ++i6;
                }
                i6 = 1;
                while (i6 < numberOfSet + 1) {
                    data[i6][0] = "# " + i6;
                    data[i6][1] = numberFormatter.format(sumRequested[i6 - 1] / countRequested[i6 - 1]);
                    data[i6][2] = numberFormatter.format(minRequested[i6 - 1]);
                    data[i6][3] = numberFormatter.format(maxRequested[i6 - 1]);
                    data[i6][4] = dateFormatter.format(new Date(timeRequested[i6 - 1]));
                    data[i6][5] = countSince[i6 - 1] < 2L ? new Float(0.0f) : numberFormatter.format(sumSince[i6 - 1] / (countSince[i6 - 1] - 1L));
                    data[i6][6] = numberFormatter.format(minSince[i6 - 1]);
                    data[i6][7] = numberFormatter.format(maxSince[i6 - 1]);
                    data[i6][8] = dateFormatter.format(new Date(timeSince[i6 - 1]));
                    data[i6][9] = numberFormatter.format(sumCompleted[i6 - 1] / countCompleted[i6 - 1]);
                    data[i6][10] = numberFormatter.format(minCompleted[i6 - 1]);
                    data[i6][11] = numberFormatter.format(maxCompleted[i6 - 1]);
                    data[i6][12] = dateFormatter.format(new Date(timeCompleted[i6 - 1]));
                    ++i6;
                }
                JTable jt = new JTable(data, header){

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                        Component c = super.prepareRenderer(renderer, row, column);
                        return c;
                    }
                };
                jt.setDragEnabled(true);
                hf.JScrollPaneSetViewportView(jt);
                this.getJDesktopPane1().add(hf);
                this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
                try {
                    hf.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
            ++z;
        }
    }

    private void setDefaultUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this.getJFrame());
            this.cfg.lookAndFeel = 2;
            prefs.putInt("lookAndFeel", 2);
            SwingUtilities.updateComponentTreeUI(this.getJDialog());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void browseButton_ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jf;
        block10: {
            String mname;
            String cname;
            jf = null;
            if (this.cfg.workingDir == null) {
                String curDir = System.getProperty("user.dir");
                try {
                    jf = new JFileChooser(curDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    StackTraceElement[] stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block10;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(curDir);
                        break block10;
                    }
                    this.handleException(e);
                }
            } else {
                try {
                    jf = new JFileChooser(this.cfg.workingDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    StackTraceElement[] stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block10;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(this.cfg.workingDir);
                    }
                    this.handleException(e);
                }
            }
        }
        jf.setFileSelectionMode(1);
        JDialog jd = new JDialog(this);
        jf.showDialog(jd, "Default directory");
        File f = jf.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "Directory not found:" + f.getAbsoluteFile(), "Directory Open Error", 2);
            return;
        }
        File file = jf.getSelectedFile();
        this.cfg.workingDir = file.getAbsolutePath();
        prefs.put("workingDir", this.cfg.workingDir);
        this.getDefaultPath().setText(this.cfg.workingDir);
    }

    public void colorComboBox_ActionPerformed(ActionEvent actionEvent) {
        Color selectedColor = this.cfg.free;
        int selected = this.getColorComboBox().getSelectedIndex();
        switch (selected) {
            case 0: {
                selectedColor = this.cfg.free;
                break;
            }
            case 1: {
                selectedColor = this.cfg.used;
                break;
            }
            case 2: {
                selectedColor = this.cfg.total;
                break;
            }
            case 3: {
                selectedColor = this.cfg.requested;
                break;
            }
            case 4: {
                selectedColor = this.cfg.freed;
                break;
            }
            case 5: {
                selectedColor = this.cfg.since;
                break;
            }
            case 6: {
                selectedColor = this.cfg.completed;
                break;
            }
            case 7: {
                selectedColor = this.cfg.mark;
                break;
            }
            case 8: {
                selectedColor = this.cfg.sweep;
                break;
            }
            case 9: {
                selectedColor = this.cfg.compact;
                break;
            }
            case 10: {
                selectedColor = this.cfg.gccompleted;
                break;
            }
            case 11: {
                selectedColor = this.cfg.overhead;
                break;
            }
            case 12: {
                selectedColor = this.cfg.freeBefore;
                break;
            }
            case 13: {
                selectedColor = this.cfg.totalBefore;
                break;
            }
            case 14: {
                selectedColor = this.cfg.freeN;
                break;
            }
            case 15: {
                selectedColor = this.cfg.totalN;
                break;
            }
            case 16: {
                selectedColor = this.cfg.freeNBefore;
                break;
            }
            case 17: {
                selectedColor = this.cfg.totalNBefore;
                break;
            }
            case 18: {
                selectedColor = this.cfg.usedBefore;
                break;
            }
            case 19: {
                selectedColor = this.cfg.usedN;
                break;
            }
            case 20: {
                selectedColor = this.cfg.usedNBefore;
                break;
            }
            case 21: {
                selectedColor = this.cfg.freePAfter;
                break;
            }
            case 22: {
                selectedColor = this.cfg.freePBefore;
                break;
            }
            case 23: {
                selectedColor = this.cfg.usedPAfter;
                break;
            }
            case 24: {
                selectedColor = this.cfg.usedPBefore;
                break;
            }
            case 25: {
                selectedColor = this.cfg.totalPBefore;
                break;
            }
            case 26: {
                selectedColor = this.cfg.maxPerm;
                break;
            }
            case 27: {
                selectedColor = this.cfg.maxTen;
                break;
            }
            case 28: {
                selectedColor = this.cfg.freeBeforeSOA;
                break;
            }
            case 29: {
                selectedColor = this.cfg.freeSOA;
                break;
            }
            case 30: {
                selectedColor = this.cfg.freeBeforeLOA;
                break;
            }
            case 31: {
                selectedColor = this.cfg.freeLOA;
                break;
            }
            case 32: {
                selectedColor = this.cfg.totalBeforeSOA;
                break;
            }
            case 33: {
                selectedColor = this.cfg.totalSOA;
                break;
            }
            case 34: {
                selectedColor = this.cfg.totalBeforeLOA;
                break;
            }
            case 35: {
                selectedColor = this.cfg.totalLOA;
                break;
            }
            case 36: {
                selectedColor = this.cfg.oome;
                break;
            }
            case 37: {
                selectedColor = this.cfg.restart;
            }
        }
        selectedColor = JColorChooser.showDialog(this, "Choose Color", selectedColor);
        if (selectedColor == null) {
            return;
        }
        switch (selected) {
            case 0: {
                this.cfg.free = selectedColor;
                break;
            }
            case 1: {
                this.cfg.used = selectedColor;
                break;
            }
            case 2: {
                this.cfg.total = selectedColor;
                break;
            }
            case 3: {
                this.cfg.requested = selectedColor;
                break;
            }
            case 4: {
                this.cfg.freed = selectedColor;
                break;
            }
            case 5: {
                this.cfg.since = selectedColor;
                break;
            }
            case 6: {
                this.cfg.completed = selectedColor;
                break;
            }
            case 7: {
                this.cfg.mark = selectedColor;
                break;
            }
            case 8: {
                this.cfg.sweep = selectedColor;
                break;
            }
            case 9: {
                this.cfg.compact = selectedColor;
                break;
            }
            case 10: {
                this.cfg.gccompleted = selectedColor;
                break;
            }
            case 11: {
                this.cfg.overhead = selectedColor;
                break;
            }
            case 12: {
                this.cfg.freeBefore = selectedColor;
                break;
            }
            case 13: {
                this.cfg.totalBefore = selectedColor;
                break;
            }
            case 14: {
                this.cfg.freeN = selectedColor;
                break;
            }
            case 15: {
                this.cfg.totalN = selectedColor;
                break;
            }
            case 16: {
                this.cfg.freeNBefore = selectedColor;
                break;
            }
            case 17: {
                this.cfg.totalNBefore = selectedColor;
                break;
            }
            case 18: {
                this.cfg.usedBefore = selectedColor;
                break;
            }
            case 19: {
                this.cfg.usedN = selectedColor;
                break;
            }
            case 20: {
                this.cfg.usedNBefore = selectedColor;
                break;
            }
            case 21: {
                this.cfg.freePAfter = selectedColor;
                break;
            }
            case 22: {
                this.cfg.freePBefore = selectedColor;
                break;
            }
            case 23: {
                this.cfg.usedPAfter = selectedColor;
                break;
            }
            case 24: {
                this.cfg.usedPBefore = selectedColor;
                break;
            }
            case 25: {
                this.cfg.totalPBefore = selectedColor;
                break;
            }
            case 26: {
                this.cfg.maxPerm = selectedColor;
                break;
            }
            case 27: {
                this.cfg.maxTen = selectedColor;
                break;
            }
            case 28: {
                this.cfg.freeBeforeSOA = selectedColor;
                break;
            }
            case 29: {
                this.cfg.freeSOA = selectedColor;
                break;
            }
            case 30: {
                this.cfg.freeBeforeLOA = selectedColor;
                break;
            }
            case 31: {
                this.cfg.freeLOA = selectedColor;
                break;
            }
            case 32: {
                this.cfg.totalBeforeSOA = selectedColor;
                break;
            }
            case 33: {
                this.cfg.totalSOA = selectedColor;
                break;
            }
            case 34: {
                this.cfg.totalBeforeLOA = selectedColor;
                break;
            }
            case 35: {
                this.cfg.totalLOA = selectedColor;
                break;
            }
            case 36: {
                this.cfg.oome = selectedColor;
                break;
            }
            case 37: {
                this.cfg.restart = selectedColor;
            }
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.help_TopicsMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(ActionEvent arg1) {
        try {
            this.aFMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11(ActionEvent arg1) {
        try {
            this.colorComboBox_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC12(ActionEvent arg1) {
        try {
            this.statisticsButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC13(ActionEvent arg1) {
        try {
            this.browseButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC14(WindowEvent arg1) {
        try {
            this.gCAnalyzer_WindowClosing(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC15(ActionEvent arg1) {
        try {
            this.gCAnalyzer_WindowClosing(null);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC16(ActionEvent arg1) {
        try {
            this.gC_ListMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC17(ActionEvent arg1) {
        try {
            this.graph_ViewMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC18(ActionEvent arg1) {
        try {
            this.usageMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC19(ActionEvent arg1) {
        try {
            this.durationMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.viewStatusBar();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC20(ActionEvent arg1) {
        try {
            this.aFMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC21(ActionEvent arg1) {
        try {
            this.deleteMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC22(ActionEvent arg1) {
        try {
            this.deleteAllMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC23(ActionEvent arg1) {
        try {
            this.deleteMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC24(ActionEvent arg1) {
        try {
            this.deleteAllMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC25(ActionEvent arg1) {
        try {
            this.partOpenButton_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC26(ActionEvent arg1) {
        try {
            this.openMenuItemSolaris_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC27(ActionEvent arg1) {
        try {
            this.openMenuItemXverbosegc_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC28(ActionEvent arg1) {
        try {
            this.openMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC29(ActionEvent arg1) {
        try {
            this.openMenuItemSolaris_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.showAboutBox();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC30(ActionEvent arg1) {
        try {
            this.openMenuItemXverbosegc_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC31(ActionEvent arg1) {
        try {
            this.deleteMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC32(ActionEvent arg1) {
        try {
            this.deleteAllMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC33(ActionEvent arg1) {
        try {
            this.gCAnalyzer_WindowClosing(null);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC34(ActionEvent arg1) {
        try {
            this.gC_ListMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC35(ActionEvent arg1) {
        try {
            this.graph_ViewMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC36(ActionEvent arg1) {
        try {
            this.durationMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC37(ActionEvent arg1) {
        try {
            this.usageMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC38(ActionEvent arg1) {
        try {
            this.aFMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC39(ActionEvent arg1) {
        try {
            this.viewStatusBar();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.openMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC40(ActionEvent arg1) {
        try {
            this.viewConsole();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC41(ActionEvent arg1) {
        try {
            this.help_TopicsMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC42(ActionEvent arg1) {
        try {
            this.showAboutBox();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.viewConsole();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.gC_ListMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.graph_ViewMenuItem_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ActionEvent arg1) {
        try {
            this.usageMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.durationMenuItem_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Open");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM10(MouseEvent arg1) {
        try {
            this.getStatusMsg2().setText("Exit");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM11(MouseEvent arg1) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM12(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("GC View");
            this.getStatusMsg2().setText("GC Table View");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM13(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM14(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Graph View");
            this.getStatusMsg2().setText("GC Graph View of usage and duration");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM15(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM16(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Usage");
            this.getStatusMsg2().setText("Usage Summary View");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM17(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM18(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Duration");
            this.getStatusMsg2().setText("GC duration summary view");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM19(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            Dimension dialogSize = this.getOptionDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getOptionDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getOptionDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM20(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Allocation Failure");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM21(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM22(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Option");
            this.getStatusMsg2().setText("Change options");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM23(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM24(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Clear Console");
            this.getStatusMsg2().setText("Clear content of console");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM25(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM26(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Status bar");
            this.getStatusMsg2().setText("Hide/Show Status bar");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM27(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM28(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Console");
            this.getStatusMsg2().setText("Hide/Show Console");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM29(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(ActionEvent arg1) {
        try {
            String hs;
            String ws;
            String limit;
            if (this.getMetalRadioButton().isSelected()) {
                this.cfg.lookAndFeel = 0;
                if (this.cfg.lookAndFeel != prefs.getInt("lookAndFeel", 0)) {
                    prefs.putInt("lookAndFeel", this.cfg.lookAndFeel);
                }
            }
            if (this.getMotifRadioButton().isSelected()) {
                this.cfg.lookAndFeel = 1;
                prefs.putInt("lookAndFeel", this.cfg.lookAndFeel);
            }
            if (this.getSystemRadioButton().isSelected()) {
                this.cfg.lookAndFeel = 2;
                prefs.putInt("lookAndFeel", this.cfg.lookAndFeel);
            }
            this.cfg.verbose = this.getVerboseCheckBox().isSelected();
            if (this.cfg.verbose != prefs.getBoolean("verbose", true)) {
                prefs.putBoolean("verbose", this.cfg.verbose);
            }
            this.cfg.autoY = this.getAutoYCheckBox().isSelected();
            if (this.cfg.autoY != prefs.getBoolean("autoY", true)) {
                prefs.putBoolean("autoY", this.cfg.autoY);
            }
            this.cfg.save = this.getSaveCheckBox().isSelected();
            if (this.cfg.save != prefs.getBoolean("save", true)) {
                prefs.putBoolean("save", this.cfg.save);
            }
            this.cfg.terminals = this.getTerminalCheckBox().isSelected();
            if (this.cfg.terminals != prefs.getBoolean("terminals", true)) {
                prefs.putBoolean("terminals", this.cfg.terminals);
            }
            this.cfg.points = this.getPointsCheckBox().isSelected();
            if (this.cfg.points != prefs.getBoolean("points", false)) {
                prefs.putBoolean("points", this.cfg.points);
            }
            this.cfg.frag = this.getJSliderFrag().getValue();
            if (this.cfg.frag != prefs.getInt("frag", 30)) {
                prefs.putInt("frag", this.cfg.frag);
            }
            this.cfg.large = this.getJSliderLarge().getValue();
            if (this.cfg.large != prefs.getInt("large", 10)) {
                prefs.putInt("large", this.cfg.large);
            }
            this.cfg.exhaustion = this.getJSliderExhaustion().getValue();
            if (this.cfg.exhaustion != prefs.getInt("exhaustion", 10)) {
                prefs.putInt("exhaustion", this.cfg.exhaustion);
            }
            this.cfg.overheadRatio = this.getJSliderOverhead().getValue();
            if (this.cfg.overheadRatio != prefs.getInt("overheadRatio", 10)) {
                prefs.putInt("overheadRatio", this.cfg.overheadRatio);
            }
            this.cfg.max = this.getJCheckBoxMax().isSelected();
            if (this.cfg.max != prefs.getBoolean("max", true)) {
                prefs.putBoolean("max", this.cfg.max);
            }
            this.cfg.fileList = this.getJCheckBoxFileList().isSelected();
            if (this.cfg.fileList != prefs.getBoolean("fileList", true)) {
                prefs.putBoolean("fileList", this.cfg.fileList);
            }
            if ((limit = this.getJTextFieldMessageLimit().getText()) != null) {
                long l = Long.parseLong(limit);
                if (l > 0L) {
                    this.cfg.limit = l;
                    if (this.cfg.limit != prefs.getLong("limit", 1000L)) {
                        prefs.putLong("limit", this.cfg.limit);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot use message limit  : " + limit + "\nPlease use limit larger than 0", "Message Limit Error", 2);
                    return;
                }
            }
            if ((ws = this.getJTextFieldWidth().getText()) != null) {
                int wi = Integer.parseInt(ws);
                if (wi > 0) {
                    this.cfg.width = wi;
                    if (this.cfg.width != prefs.getInt("width", 1024)) {
                        prefs.putInt("width", this.cfg.width);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot use Chart Width  : " + ws + "\nPlease use size larger than 0", "Chart Width Error", 2);
                    return;
                }
            }
            if ((hs = this.getJTextFieldHeight().getText()) != null) {
                int hi = Integer.parseInt(hs);
                if (hi > 0) {
                    this.cfg.height = hi;
                    if (this.cfg.height != prefs.getInt("height", 768)) {
                        prefs.putInt("height", this.cfg.height);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot use Chart Height  : " + ws + "\nPlease use size larger than 0", "Chart Height Error", 2);
                    return;
                }
            }
            String sz = this.getJTextFieldFontSize().getText();
            int size = Integer.parseInt(sz);
            this.cfg.font = new Font((String)this.getJComboBoxFont().getSelectedItem(), (this.getJCheckBoxBold().isSelected() ? 1 : 0) + (this.getJCheckBoxItalic().isSelected() ? 2 : 0), size);
            prefs.putInt("fontSize", size);
            int style = 0;
            if (this.getJCheckBoxBold().isSelected()) {
                ++style;
            }
            if (this.getJCheckBoxItalic().isSelected()) {
                style += 2;
            }
            prefs.putInt("fontStyle", style);
            prefs.put("fontFamily", (String)this.getJComboBoxFont().getSelectedItem());
            if (this.getDefaultTime().getText() == null) {
                this.cfg.defaultStartTime = 0L;
            } else {
                Date dt = new Date();
                try {
                    dt = dateInputFormatter.parse(this.getDefaultTime().getText());
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(this, "Cannot understand : " + this.getDefaultTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
                    return;
                }
                if (dt == null) {
                    JOptionPane.showMessageDialog(this, "Cannot understand : " + this.getDefaultTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
                    return;
                }
                this.cfg.defaultStartTime = dt.getTime();
                prefs.putLong("defaultStartTime", this.cfg.defaultStartTime);
            }
            this.cfg.workingDir = prefs.get("workingDir", Configuration.WORKINGDIR);
            if (this.cfg.free.getRGB() != prefs.getInt("free", Configuration.FREE.getRGB())) {
                prefs.putInt("free", this.cfg.free.getRGB());
            }
            if (this.cfg.freeSOA.getRGB() != prefs.getInt("freeSOA", Configuration.FREESOA.getRGB())) {
                prefs.putInt("freeSOA", this.cfg.freeSOA.getRGB());
            }
            if (this.cfg.freeBeforeSOA.getRGB() != prefs.getInt("freeBeforeSOA", Configuration.FREEBEFORESOA.getRGB())) {
                prefs.putInt("freeBeforeSOA", this.cfg.freeBeforeSOA.getRGB());
            }
            if (this.cfg.freeLOA.getRGB() != prefs.getInt("freeLOA", Configuration.FREELOA.getRGB())) {
                prefs.putInt("freeLOA", this.cfg.freeLOA.getRGB());
            }
            if (this.cfg.freeBeforeLOA.getRGB() != prefs.getInt("freeBeforeLOA", Configuration.FREEBEFORELOA.getRGB())) {
                prefs.putInt("freeBeforeLOA", this.cfg.freeBeforeLOA.getRGB());
            }
            if (this.cfg.freeN.getRGB() != prefs.getInt("freeBeforeLOA", Configuration.FREEN.getRGB())) {
                prefs.putInt("freeN", this.cfg.freeN.getRGB());
            }
            if (this.cfg.freeNBefore.getRGB() != prefs.getInt("freeNBefore", Configuration.FREENBEFORE.getRGB())) {
                prefs.putInt("freeNBefore", this.cfg.freeNBefore.getRGB());
            }
            if (this.cfg.freeBefore.getRGB() != prefs.getInt("freeBefore", Configuration.FREEBEFORE.getRGB())) {
                prefs.putInt("freeBefore", this.cfg.freeBefore.getRGB());
            }
            if (this.cfg.freed.getRGB() != prefs.getInt("freed", Configuration.FREED.getRGB())) {
                prefs.putInt("freed", this.cfg.freed.getRGB());
            }
            if (this.cfg.overhead.getRGB() != prefs.getInt("overhead", Configuration.OVERHEAD.getRGB())) {
                prefs.putInt("overhead", this.cfg.overhead.getRGB());
            }
            if (this.cfg.used.getRGB() != prefs.getInt("used", Configuration.USED.getRGB())) {
                prefs.putInt("used", this.cfg.used.getRGB());
            }
            if (this.cfg.usedN.getRGB() != prefs.getInt("usedN", Configuration.USEDN.getRGB())) {
                prefs.putInt("usedN", this.cfg.usedN.getRGB());
            }
            if (this.cfg.usedNBefore.getRGB() != prefs.getInt("usedNBefore", Configuration.USEDNBEFORE.getRGB())) {
                prefs.putInt("usedNBefore", this.cfg.usedNBefore.getRGB());
            }
            if (this.cfg.usedBefore.getRGB() != prefs.getInt("usedBefore", Configuration.USEDBEFORE.getRGB())) {
                prefs.putInt("usedBefore", this.cfg.usedBefore.getRGB());
            }
            if (this.cfg.total.getRGB() != prefs.getInt("total", Configuration.TOTAL.getRGB())) {
                prefs.putInt("total", this.cfg.total.getRGB());
            }
            if (this.cfg.totalLOA.getRGB() != prefs.getInt("totalLOA", Configuration.TOTALLOA.getRGB())) {
                prefs.putInt("totalLOA", this.cfg.totalLOA.getRGB());
            }
            if (this.cfg.totalSOA.getRGB() != prefs.getInt("totalSOA", Configuration.TOTALSOA.getRGB())) {
                prefs.putInt("totalSOA", this.cfg.totalSOA.getRGB());
            }
            if (this.cfg.totalN.getRGB() != prefs.getInt("totalN", Configuration.TOTALN.getRGB())) {
                prefs.putInt("totalN", this.cfg.totalN.getRGB());
            }
            if (this.cfg.totalBefore.getRGB() != prefs.getInt("totalBefore", Configuration.TOTALBEFORE.getRGB())) {
                prefs.putInt("totalBefore", this.cfg.totalBefore.getRGB());
            }
            if (this.cfg.totalBeforeSOA.getRGB() != prefs.getInt("totalBeforeSOA", Configuration.TOTALBEFORESOA.getRGB())) {
                prefs.putInt("totalBeforeSOA", this.cfg.totalBeforeSOA.getRGB());
            }
            if (this.cfg.totalBeforeLOA.getRGB() != prefs.getInt("totalBeforeLOA", Configuration.TOTALBEFORELOA.getRGB())) {
                prefs.putInt("totalBeforeLOA", this.cfg.totalBeforeLOA.getRGB());
            }
            if (this.cfg.totalNBefore.getRGB() != prefs.getInt("totalNBefore", Configuration.TOTALNBEFORE.getRGB())) {
                prefs.putInt("totalNBefore", this.cfg.totalNBefore.getRGB());
            }
            if (this.cfg.requested.getRGB() != prefs.getInt("requested", Configuration.REQUESTED.getRGB())) {
                prefs.putInt("requested", this.cfg.requested.getRGB());
            }
            if (this.cfg.since.getRGB() != prefs.getInt("since", Configuration.SINCE.getRGB())) {
                prefs.putInt("since", this.cfg.since.getRGB());
            }
            if (this.cfg.completed.getRGB() != prefs.getInt("completed", Configuration.COMPLETED.getRGB())) {
                prefs.putInt("completed", this.cfg.completed.getRGB());
            }
            if (this.cfg.gccompleted.getRGB() != prefs.getInt("gccompleted", Configuration.GCCOMPLETED.getRGB())) {
                prefs.putInt("gccompleted", this.cfg.gccompleted.getRGB());
            }
            if (this.cfg.mark.getRGB() != prefs.getInt("mark", Configuration.MARK.getRGB())) {
                prefs.putInt("mark", this.cfg.mark.getRGB());
            }
            if (this.cfg.sweep.getRGB() != prefs.getInt("sweep", Configuration.SWEEP.getRGB())) {
                prefs.putInt("sweep", this.cfg.sweep.getRGB());
            }
            if (this.cfg.compact.getRGB() != prefs.getInt("compact", Configuration.COMPACT.getRGB())) {
                prefs.putInt("compact", this.cfg.compact.getRGB());
            }
            if (this.cfg.totalPBefore.getRGB() != prefs.getInt("totalPBefore", Configuration.TOTALPBEFORE.getRGB())) {
                prefs.putInt("totalPBefore", this.cfg.totalPBefore.getRGB());
            }
            if (this.cfg.usedPBefore.getRGB() != prefs.getInt("usedPBefore", Configuration.USEDPBEFORE.getRGB())) {
                prefs.putInt("usedPBefore", this.cfg.usedPBefore.getRGB());
            }
            if (this.cfg.usedPAfter.getRGB() != prefs.getInt("usedPAfter", Configuration.USEDPAFTER.getRGB())) {
                prefs.putInt("usedPAfter", this.cfg.usedPAfter.getRGB());
            }
            if (this.cfg.freePAfter.getRGB() != prefs.getInt("freePAfter", Configuration.FREEPAFTER.getRGB())) {
                prefs.putInt("freePAfter", this.cfg.freePAfter.getRGB());
            }
            if (this.cfg.freePBefore.getRGB() != prefs.getInt("freePBefore", Configuration.FREEPBEFORE.getRGB())) {
                prefs.putInt("freePBefore", this.cfg.freePBefore.getRGB());
            }
            if (this.cfg.maxTen.getRGB() != prefs.getInt("maxTen", Configuration.MAXTEN.getRGB())) {
                prefs.putInt("maxTen", this.cfg.maxTen.getRGB());
            }
            if (this.cfg.maxPerm.getRGB() != prefs.getInt("maxPerm", Configuration.MAXPERM.getRGB())) {
                prefs.putInt("maxPerm", this.cfg.maxPerm.getRGB());
            }
            if (this.cfg.oome.getRGB() != prefs.getInt("oome", Configuration.OOME.getRGB())) {
                prefs.putInt("oome", this.cfg.oome.getRGB());
            }
            if (this.cfg.restart.getRGB() != prefs.getInt("restart", Configuration.RESTART.getRGB())) {
                prefs.putInt("restart", this.cfg.restart.getRGB());
            }
            this.getOptionDialog().dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM30(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Help");
            this.getStatusMsg2().setText("Read tutorial");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM31(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM32(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("About IBM Pattern Modeling and Analysis Tool for Java Garbage Collector");
            this.getStatusMsg2().setText("About PMAT");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM33(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM34(ActionEvent arg1) {
        try {
            this.getPartDialog().dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM35(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = false;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] < nGC) {
                    this.startPart[++index] = i;
                } else {
                    this.endPart[index] = i;
                }
                nGC = this.giPart.ngc[i];
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM36(ActionEvent arg1) {
        try {
            this.getPartDialog().dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM37(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = false;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] < nGC) {
                    this.startPart[++index] = i;
                } else {
                    this.endPart[index] = i;
                }
                nGC = this.giPart.ngc[i];
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM38(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = true;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] < nGC) {
                    this.startPart[++index] = i;
                } else {
                    this.endPart[index] = i;
                }
                nGC = this.giPart.ngc[i];
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM39(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = true;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] < nGC) {
                    this.startPart[++index] = i;
                } else {
                    this.endPart[index] = i;
                }
                nGC = this.giPart.ngc[i];
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM40(ActionEvent arg1) {
        try {
            this.getOptionDialog().dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM41(ChangeEvent arg1) {
        try {
            this.getJTextFieldFrag().setText(String.valueOf(this.getJSliderFrag().getValue()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM42() {
        try {
            this.getJSliderFrag().setValue(Integer.parseInt(this.getJTextFieldFrag().getText()));
        }
        catch (Throwable ivjExc) {
            if (this.getJTextFieldFrag().getText().length() == 0) {
                return;
            }
            if (ivjExc instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid Number : " + this.getJTextFieldFrag().getText(), "Invalid ratio", 2);
                this.getJTextFieldFrag().setText("");
                return;
            }
            this.handleException(ivjExc);
        }
    }

    private void connEtoM43(ChangeEvent arg1) {
        try {
            this.getJTextFieldLarge().setText(String.valueOf(this.getJSliderLarge().getValue()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM44() {
        try {
            this.getJSliderLarge().setValue(Integer.parseInt(this.getJTextFieldLarge().getText()));
        }
        catch (Throwable ivjExc) {
            if (this.getJTextFieldLarge().getText().length() == 0) {
                return;
            }
            if (ivjExc instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid Number : " + this.getJTextFieldLarge().getText(), "Invalid Threshold", 2);
                this.getJTextFieldLarge().setText("");
                return;
            }
            this.handleException(ivjExc);
        }
    }

    private void connEtoM45(ChangeEvent arg1) {
        try {
            this.getJTextFieldExhaustion().setText(String.valueOf(this.getJSliderExhaustion().getValue()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM46() {
        try {
            this.getJSliderExhaustion().setValue(Integer.parseInt(this.getJTextFieldExhaustion().getText()));
        }
        catch (Throwable ivjExc) {
            if (this.getJTextFieldExhaustion().getText().length() == 0) {
                return;
            }
            if (ivjExc instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(this, "Invalid Number : " + this.getJTextFieldExhaustion().getText(), "Invalid Ratio", 2);
                this.getJTextFieldExhaustion().setText("");
                return;
            }
            this.handleException(ivjExc);
        }
    }

    private void connEtoM47(ActionEvent arg1) {
        try {
            this.getJSliderFrag().setValue(30);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM48(ActionEvent arg1) {
        try {
            this.getJSliderLarge().setValue(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM49(ActionEvent arg1) {
        try {
            this.getJSliderOverhead().setValue(30);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5(ActionEvent arg1) {
        try {
            this.getConsoleTextArea().setText("");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM50(ActionEvent arg1) {
        try {
            this.getJSliderExhaustion().setValue(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM51(ChangeEvent arg1) {
        try {
            this.getJTextFieldOverhead().setText(String.valueOf(this.getJSliderOverhead().getValue()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM52(ComponentEvent arg1) {
        try {
            this.getDefaultButton().setVisible(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM53() {
        try {
            this.getJSliderOverhead().setValue(Integer.parseInt(this.getJTextFieldOverhead().getText()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM54(ComponentEvent arg1) {
        try {
            this.getDefaultButton().setVisible(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM55(ActionEvent arg1) {
        try {
            int[] selectedRows = this.fileTable.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
                return;
            }
            Dimension dialogSize = this.getStatisticsDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getStatisticsDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRows[0]);
            this.getStartTime().setText(dateInputFormatter.format(new Date(this.giPart.timestamp[0])));
            long lastValidTimestamp = this.giPart.timestamp[this.giPart.timestamp.length - 1];
            if (lastValidTimestamp == 0L && this.giPart.timestamp.length >= 2) {
                int n = this.giPart.timestamp.length - 2;
                while (n >= 0) {
                    lastValidTimestamp = this.giPart.timestamp[n];
                    if (lastValidTimestamp != 0L) break;
                    --n;
                }
            }
            this.getEndTime().setText(dateInputFormatter.format(new Date(lastValidTimestamp)));
            this.getStatisticsTextArea().setText("");
            this.getStatisticsDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM56(ActionEvent arg1) {
        try {
            this.getStatisticsDialog().dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM57(ActionEvent arg1) {
        try {
            int[] selectedRows = this.fileTable.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
                return;
            }
            Dimension dialogSize = this.getStatisticsDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getStatisticsDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRows[0]);
            this.getStartTime().setText(dateInputFormatter.format(new Date(this.giPart.timestamp[0])));
            this.getEndTime().setText(dateInputFormatter.format(new Date(this.giPart.timestamp[this.giPart.timestamp.length - 1])));
            this.getStatisticsTextArea().setText("");
            this.getStatisticsDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM58(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = false;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] != 0) {
                    if (this.giPart.ngc[i] < nGC) {
                        this.startPart[++index] = i;
                    } else {
                        this.endPart[index] = i;
                    }
                    nGC = this.giPart.ngc[i];
                }
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM59(ActionEvent arg1) {
        try {
            this.isChartViewEnabled = true;
            int selectedRow = this.fileTable.getSelectedRow();
            if (selectedRow == -1) {
                JOptionPane.showMessageDialog(this, "Please select  a file", "Information", 1);
                return;
            }
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRow);
            this.startPart = new int[this.giPart.numberOfSet];
            this.endPart = new int[this.giPart.numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i = 0;
            while (i < this.giPart.free.length) {
                if (this.giPart.ngc[i] != 0) {
                    if (this.giPart.ngc[i] < nGC) {
                        if (++index < this.startPart.length) {
                            this.startPart[index] = i;
                        }
                    } else if (index < this.endPart.length) {
                        this.endPart[index] = i;
                    }
                    nGC = this.giPart.ngc[i];
                }
                ++i;
            }
            this.partModel = new DefaultListModel();
            i = 0;
            while (i < this.giPart.numberOfSet) {
                this.partModel.addElement("#" + (i + 1) + " " + dateFormatter.format(new Date(this.giPart.timestamp[this.startPart[i]])) + "-" + dateFormatter.format(new Date(this.giPart.timestamp[this.endPart[i]])));
                ++i;
            }
            this.getPartList().setModel(this.partModel);
            Dimension dialogSize = this.getPartDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getPartDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getPartDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM6(MouseEvent arg1) {
        try {
            this.getStatusMsg2().setText("Open verbose garbage collection logs");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM60(ActionEvent arg1) {
        try {
            Dimension dialogSize = this.getOptionDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getOptionDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.getOptionDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM61(ActionEvent arg1) {
        try {
            this.getConsoleTextArea().setText("");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM62(ActionEvent arg1) {
        try {
            int[] selectedRows = this.fileTable.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
                return;
            }
            Dimension dialogSize = this.getStatisticsDialog().getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.getStatisticsDialog().setLocation((frameSize.width - dialogSize.width) / 4 + loc.x, (frameSize.height - dialogSize.height) / 6 + loc.y);
            this.giPart = (GCInfo)this.ti.gcList.get(selectedRows[0]);
            this.getStartTime().setText(dateInputFormatter.format(new Date(this.giPart.timestamp[0])));
            this.getEndTime().setText(dateInputFormatter.format(new Date(this.giPart.timestamp[this.giPart.timestamp.length - 1])));
            this.getStatisticsTextArea().setText("");
            this.getStatisticsDialog().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM7(MouseEvent arg1) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM8(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText("Exit");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM9(MouseEvent arg1) {
        try {
            this.getStatusMsg1().setText(" ");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void deleteAllMenuItem_ActionPerformed(ActionEvent actionEvent) {
        this.ti.gcList.clear();
        this.fileModel.fireTableDataChanged();
        this.fileTable.updateUI();
        this.getDetailTextPane().setText("<html></html>");
    }

    public void deleteMenuItem_ActionPerformed(ActionEvent actionEvent) {
        int[] selectedRow = this.fileTable.getSelectedRows();
        if (selectedRow.length != 0) {
            GCInfo[] dump = new GCInfo[selectedRow.length];
            int i = 0;
            while (i < selectedRow.length) {
                dump[i] = (GCInfo)this.ti.gcList.get(selectedRow[i]);
                ++i;
            }
            i = 0;
            while (i < dump.length) {
                this.ti.gcList.remove(dump[i]);
                ++i;
            }
            this.fileModel.fireTableDataChanged();
            this.fileTable.updateUI();
            this.getDetailTextPane().setText("<html></html>");
        }
    }

    public void displaySummary() {
        int selectedRow = this.fileTable.getSelectedRow();
        GCInfo gi = (GCInfo)this.ti.gcList.get(selectedRow);
        this.getDetailTextPane().setText(gi.summary);
        this.getDetailTextPane().setCaretPosition(0);
    }

    public void displaySummary(int selectedRow) {
        GCInfo gi = (GCInfo)this.ti.gcList.get(selectedRow);
        this.getDetailTextPane().setText(gi.summary);
        this.getDetailTextPane().setCaretPosition(0);
    }

    public void durationMenuItem_ActionPerformed(ActionEvent actionEvent) {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] gi = new GCInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            gi[i] = (GCInfo)this.ti.gcList.get(selectedRows[i]);
            ++i;
        }
        String selectedFiles = "";
        int i2 = 0;
        while (i2 < selectedRows.length) {
            selectedFiles = String.valueOf(selectedFiles) + this.fileTable.getValueAt(selectedRows[i2], 0) + " ";
            ++i2;
        }
        int z = 0;
        while (z < gi.length) {
            HeapFrame hf = new HeapFrame(String.valueOf(gi[z].file.getName()) + " GC Usage Summary", gi[z]);
            hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/displayjoblog.gif")));
            hf.fileName = gi[z].file.getName();
            long[] min = new long[3];
            long[] max = new long[3];
            long[] avg = new long[3];
            long[] timestamp = new long[3];
            long[] sum = new long[3];
            min[0] = max[0] = gi[z].free[0];
            min[1] = max[1] = gi[z].total[0];
            min[2] = max[2] = gi[z].total[0] - gi[z].free[0];
            timestamp[1] = timestamp[2] = gi[z].timestamp[0];
            timestamp[0] = timestamp[2];
            int i3 = 0;
            while (i3 < gi[z].free.length) {
                if (gi[z].free[i3] > max[0]) {
                    max[0] = gi[z].free[i3];
                    timestamp[0] = gi[z].timestamp[i3];
                }
                if (gi[z].free[i3] < min[0]) {
                    min[0] = gi[z].free[i3];
                }
                sum[0] = sum[0] + gi[z].free[i3];
                if (gi[z].total[i3] > max[1]) {
                    max[1] = gi[z].total[i3];
                    timestamp[1] = gi[z].timestamp[i3];
                }
                if (gi[z].total[i3] < min[1]) {
                    min[1] = gi[z].total[i3];
                }
                sum[1] = sum[1] + gi[z].total[i3];
                if (gi[z].total[z] - gi[z].free[i3] > max[2]) {
                    max[2] = gi[z].total[i3] - gi[z].free[i3];
                    timestamp[2] = gi[z].timestamp[i3];
                }
                if (gi[z].total[i3] - gi[z].free[i3] < min[2]) {
                    min[2] = gi[z].total[i3] - gi[z].free[i3];
                }
                sum[2] = sum[2] + (gi[z].total[i3] - gi[z].free[i3]);
                ++i3;
            }
            Object[] header = new Object[]{"", "Free avg", "min", "max", "timestamp of max", "Total avg", "min", "max", "timestamp of max", "Used avg", "min", "max", "timestamp of max"};
            Object[][] data = new Object[gi[z].numberOfSet + 1][13];
            data[0][0] = "Overall";
            int i4 = 0;
            while (i4 < 3) {
                data[0][i4 * 4 + 1] = numberFormatter.format(sum[i4] / (long)gi[z].free.length);
                data[0][i4 * 4 + 2] = numberFormatter.format(min[i4]);
                data[0][i4 * 4 + 3] = numberFormatter.format(max[i4]);
                data[0][i4 * 4 + 4] = dateFormatter.format(new Date(timestamp[i4]));
                ++i4;
            }
            long[] minFree = new long[gi[z].numberOfSet];
            long[] maxFree = new long[gi[z].numberOfSet];
            long[] sumFree = new long[gi[z].numberOfSet];
            long[] timeFree = new long[gi[z].numberOfSet];
            int[] countFree = new int[gi[z].numberOfSet];
            long[] minTotal = new long[gi[z].numberOfSet];
            long[] maxTotal = new long[gi[z].numberOfSet];
            long[] sumTotal = new long[gi[z].numberOfSet];
            long[] timeTotal = new long[gi[z].numberOfSet];
            int[] countTotal = new int[gi[z].numberOfSet];
            long[] minFreed = new long[gi[z].numberOfSet];
            long[] maxFreed = new long[gi[z].numberOfSet];
            long[] sumFreed = new long[gi[z].numberOfSet];
            long[] timeFreed = new long[gi[z].numberOfSet];
            int[] countFreed = new int[gi[z].numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i5 = 0;
            while (i5 < gi[z].free.length) {
                if (gi[z].ngc[i5] < nGC) {
                    minFree[++index] = maxFree[index] = gi[z].free[i5];
                    minTotal[index] = maxTotal[index] = gi[z].total[i5];
                    minFreed[index] = maxFreed[index] = gi[z].total[i5] - gi[z].free[i5];
                    timeFreed[index] = timeTotal[index] = gi[z].timestamp[i5];
                    timeFree[index] = timeTotal[index];
                }
                nGC = gi[z].ngc[i5];
                if (gi[z].free[i5] > maxFree[index]) {
                    maxFree[index] = gi[z].free[i5];
                    timeFree[index] = gi[z].timestamp[i5];
                }
                if (gi[z].free[i5] < minFree[index]) {
                    minFree[index] = gi[z].free[i5];
                }
                int n = index;
                sumFree[n] = sumFree[n] + gi[z].free[i5];
                int n2 = index;
                countFree[n2] = countFree[n2] + 1;
                if (gi[z].total[i5] > maxTotal[index]) {
                    maxTotal[index] = gi[z].total[i5];
                    timeTotal[index] = gi[z].timestamp[i5];
                }
                if (gi[z].total[i5] < minTotal[index]) {
                    minTotal[index] = gi[z].total[i5];
                }
                int n3 = index;
                sumTotal[n3] = sumTotal[n3] + gi[z].total[i5];
                int n4 = index;
                countTotal[n4] = countTotal[n4] + 1;
                if (gi[z].total[i5] - gi[z].free[i5] > maxFreed[index]) {
                    maxFreed[index] = gi[z].total[i5] - gi[z].free[i5];
                    timeFreed[index] = gi[z].timestamp[i5];
                }
                if (gi[z].total[i5] - gi[z].free[i5] < minFreed[index]) {
                    minFreed[index] = gi[z].total[i5] - gi[z].free[i5];
                }
                int n5 = index;
                sumFreed[n5] = sumFreed[n5] + (gi[z].total[i5] - gi[z].free[i5]);
                int n6 = index;
                countFreed[n6] = countFreed[n6] + 1;
                ++i5;
            }
            i5 = 1;
            while (i5 < gi[z].numberOfSet + 1) {
                data[i5][0] = "# " + i5;
                data[i5][1] = numberFormatter.format(sumFree[i5 - 1] / (long)countFree[i5 - 1]);
                data[i5][2] = numberFormatter.format(minFree[i5 - 1]);
                data[i5][3] = numberFormatter.format(maxFree[i5 - 1]);
                data[i5][4] = dateFormatter.format(new Date(timeFree[i5 - 1]));
                data[i5][5] = numberFormatter.format(sumTotal[i5 - 1] / (long)countTotal[i5 - 1]);
                data[i5][6] = numberFormatter.format(minTotal[i5 - 1]);
                data[i5][7] = numberFormatter.format(maxTotal[i5 - 1]);
                data[i5][8] = dateFormatter.format(new Date(timeTotal[i5 - 1]));
                data[i5][9] = numberFormatter.format(sumFreed[i5 - 1] / (long)countFreed[i5 - 1]);
                data[i5][10] = numberFormatter.format(minFreed[i5 - 1]);
                data[i5][11] = numberFormatter.format(maxFreed[i5 - 1]);
                data[i5][12] = dateFormatter.format(new Date(timeFreed[i5 - 1]));
                ++i5;
            }
            JTable jt = new JTable(data, header){

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component c = super.prepareRenderer(renderer, row, column);
                    return c;
                }
            };
            jt.setDragEnabled(true);
            hf.JScrollPaneSetViewportView(jt);
            this.getJDesktopPane1().add(hf);
            this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
            try {
                hf.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            ++z;
        }
    }

    public void gC_ListMenuItem_ActionPerformed() {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] gi = new GCInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            gi[i] = (GCInfo)this.ti.gcList.get(selectedRows[i]);
            ++i;
        }
        i = 0;
        while (i < gi.length) {
            HeapFrame hf = new HeapFrame(String.valueOf(gi[i].file.getName()) + " Table View", gi[i]);
            hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
            hf.fileName = gi[i].file.getName();
            JTable jt = new JTable(){

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component c = super.prepareRenderer(renderer, row, column);
                    return c;
                }
            };
            jt.setDragEnabled(true);
            jt.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
            hf.JScrollPaneSetViewportView(jt);
            this.getJDesktopPane1().add(hf);
            this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
            try {
                hf.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            GCTableThread at = new GCTableThread(jt, gi[i], this, hf);
            at.start();
            ++i;
        }
    }

    public void gCAnalyzer_WindowClosing(WindowEvent windowEvent) {
        if (JOptionPane.showConfirmDialog(this, "Do you want to exit IBM Pattern Modeling and Analysis Tool?", "Exit", 0) == 1) {
            return;
        }
        if (this.cfg.save) {
            this.writePreferenceFile();
        }
        System.exit(0);
    }

    public void gCViewPartMenuItem_ActionPerformed(ActionEvent actionEvent) {
        JDialog ivjPartDialog = new JDialog();
        ivjPartDialog.setName("PartDialog");
        ivjPartDialog.setDefaultCloseOperation(2);
        ivjPartDialog.setBounds(970, 438, 366, 130);
        JPanel ivjJDialogContentPane1 = new JPanel();
        ivjJDialogContentPane1.setName("JDialogContentPane1");
        ivjJDialogContentPane1.setLayout(new BorderLayout());
        JList ivjPartList = new JList();
        ivjPartList.setName("PartList");
        DefaultListModel<String> partModel = new DefaultListModel<String>();
        partModel.addElement("1");
        partModel.addElement("2");
        ivjPartList.setModel(partModel);
        ivjPartList.setBounds(89, 28, 201, 76);
        ivjJDialogContentPane1.add(ivjPartList, "Center");
        ivjPartDialog.setContentPane(ivjJDialogContentPane1);
        ivjPartList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("CLICK");
            }
        });
        ivjPartDialog.show();
    }

    private JMenuItem getAbout_BoxMenuItem() {
        if (this.ivjAbout_BoxMenuItem == null) {
            try {
                this.ivjAbout_BoxMenuItem = new JMenuItem();
                this.ivjAbout_BoxMenuItem.setName("About_BoxMenuItem");
                this.ivjAbout_BoxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/about.gif")));
                this.ivjAbout_BoxMenuItem.setMnemonic('A');
                this.ivjAbout_BoxMenuItem.setText("About IBM Pattern Modeling and Analysis Tool for Java Garbage Collector");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAbout_BoxMenuItem;
    }

    private JMenuItem getAFMenuItem() {
        if (this.ivjAFMenuItem == null) {
            try {
                this.ivjAFMenuItem = new JMenuItem();
                this.ivjAFMenuItem.setName("AFMenuItem");
                this.ivjAFMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/failed_ovr.gif")));
                this.ivjAFMenuItem.setMnemonic('A');
                this.ivjAFMenuItem.setText("AF Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAFMenuItem;
    }

    private JMenuItem getAFMenuItem1() {
        if (this.ivjAFMenuItem1 == null) {
            try {
                this.ivjAFMenuItem1 = new JMenuItem();
                this.ivjAFMenuItem1.setName("AFMenuItem1");
                this.ivjAFMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/failed_ovr.gif")));
                this.ivjAFMenuItem1.setMnemonic('A');
                this.ivjAFMenuItem1.setText("AF Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAFMenuItem1;
    }

    private JMenu getAnalysisMenu() {
        if (this.ivjAnalysisMenu == null) {
            try {
                this.ivjAnalysisMenu = new JMenu();
                this.ivjAnalysisMenu.setName("AnalysisMenu");
                this.ivjAnalysisMenu.setMnemonic('A');
                this.ivjAnalysisMenu.setText("Analysis");
                this.ivjAnalysisMenu.add(this.getGC_ListMenuItem());
                this.ivjAnalysisMenu.add(this.getGCViewPartMenuItem1());
                this.ivjAnalysisMenu.add(this.getGraph_ViewMenuItem());
                this.ivjAnalysisMenu.add(this.getGraph_ViewMenuItem2());
                this.ivjAnalysisMenu.add(this.getStatisticsMenuItem());
                this.ivjAnalysisMenu.add(this.getJSeparator1());
                this.ivjAnalysisMenu.add(this.getDurationMenuItem());
                this.ivjAnalysisMenu.add(this.getUsageMenuItem());
                this.ivjAnalysisMenu.add(this.getAFMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAnalysisMenu;
    }

    private JCheckBox getAutoYCheckBox() {
        if (this.ivjAutoYCheckBox == null) {
            try {
                this.ivjAutoYCheckBox = new JCheckBox();
                this.ivjAutoYCheckBox.setName("AutoYCheckBox");
                this.ivjAutoYCheckBox.setSelected(true);
                this.ivjAutoYCheckBox.setMnemonic('A');
                this.ivjAutoYCheckBox.setText("Auto Adjust Y-axis");
                this.ivjAutoYCheckBox.setBounds(14, 276, 144, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAutoYCheckBox;
    }

    private JPanel getBasic() {
        if (this.ivjBasic == null) {
            try {
                this.ivjBasic = new JPanel();
                this.ivjBasic.setName("Basic");
                this.ivjBasic.setLayout(null);
                this.getBasic().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getBasic().add((Component)this.getJLabel2(), this.getJLabel2().getName());
                this.getBasic().add((Component)this.getVerboseCheckBox(), this.getVerboseCheckBox().getName());
                this.getBasic().add((Component)this.getTerminalCheckBox(), this.getTerminalCheckBox().getName());
                this.getBasic().add((Component)this.getPointsCheckBox(), this.getPointsCheckBox().getName());
                this.getBasic().add((Component)this.getSaveCheckBox(), this.getSaveCheckBox().getName());
                this.getBasic().add((Component)this.getColorComboBox(), this.getColorComboBox().getName());
                this.getBasic().add((Component)this.getDefaultPath(), this.getDefaultPath().getName());
                this.getBasic().add((Component)this.getBrowseButton(), this.getBrowseButton().getName());
                this.getBasic().add((Component)this.getAutoYCheckBox(), this.getAutoYCheckBox().getName());
                this.getBasic().add((Component)this.getJCheckBoxMax(), this.getJCheckBoxMax().getName());
                this.getBasic().add((Component)this.getJCheckBoxFileList(), this.getJCheckBoxFileList().getName());
                this.getBasic().add((Component)this.getLookAndFeelPanel(), this.getLookAndFeelPanel().getName());
                this.getBasic().add((Component)this.getJLabel3(), this.getJLabel3().getName());
                this.getBasic().add((Component)this.getDefaultTime(), this.getDefaultTime().getName());
                this.getBasic().add((Component)this.getJLabelFont(), this.getJLabelFont().getName());
                this.getBasic().add((Component)this.getJComboBoxFont(), this.getJComboBoxFont().getName());
                this.getBasic().add((Component)this.getJLabelFontSize(), this.getJLabelFontSize().getName());
                this.getBasic().add((Component)this.getJCheckBoxBold(), this.getJCheckBoxBold().getName());
                this.getBasic().add((Component)this.getJCheckBoxItalic(), this.getJCheckBoxItalic().getName());
                this.getBasic().add((Component)this.getJLabelFontStyle(), this.getJLabelFontStyle().getName());
                this.getBasic().add((Component)this.getJTextFieldFontSize(), this.getJTextFieldFontSize().getName());
                this.getBasic().add((Component)this.getJLabelChartWidth(), this.getJLabelChartWidth().getName());
                this.getBasic().add((Component)this.getJLabelChartHeight(), this.getJLabelChartHeight().getName());
                this.getBasic().add((Component)this.getJTextFieldWidth(), this.getJTextFieldWidth().getName());
                this.getBasic().add((Component)this.getJTextFieldHeight(), this.getJTextFieldHeight().getName());
                this.getBasic().add((Component)this.getJLabel4(), this.getJLabel4().getName());
                this.getBasic().add((Component)this.getJTextFieldMessageLimit(), this.getJTextFieldMessageLimit().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasic;
    }

    private JButton getBrowseButton() {
        if (this.ivjBrowseButton == null) {
            try {
                this.ivjBrowseButton = new JButton();
                this.ivjBrowseButton.setName("BrowseButton");
                this.ivjBrowseButton.setMnemonic('B');
                this.ivjBrowseButton.setText("Browse");
                this.ivjBrowseButton.setBounds(282, 13, 85, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBrowseButton;
    }

    private JMenuItem getClearMenuItem() {
        if (this.ivjClearMenuItem == null) {
            try {
                this.ivjClearMenuItem = new JMenuItem();
                this.ivjClearMenuItem.setName("ClearMenuItem");
                this.ivjClearMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/clear.gif")));
                this.ivjClearMenuItem.setMnemonic('C');
                this.ivjClearMenuItem.setText("Clear Console");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearMenuItem;
    }

    private JMenuItem getCloseAllMenuItem() {
        if (this.ivjCloseAllMenuItem == null) {
            try {
                this.ivjCloseAllMenuItem = new JMenuItem();
                this.ivjCloseAllMenuItem.setName("CloseAllMenuItem");
                this.ivjCloseAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/remove_all.gif")));
                this.ivjCloseAllMenuItem.setPreferredSize(new Dimension(133, 27));
                this.ivjCloseAllMenuItem.setMnemonic('A');
                this.ivjCloseAllMenuItem.setText("Close All Files");
                this.ivjCloseAllMenuItem.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseAllMenuItem;
    }

    private JMenuItem getCloseAllMenuItem1() {
        if (this.ivjCloseAllMenuItem1 == null) {
            try {
                this.ivjCloseAllMenuItem1 = new JMenuItem();
                this.ivjCloseAllMenuItem1.setName("CloseAllMenuItem1");
                this.ivjCloseAllMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/remove_all.gif")));
                this.ivjCloseAllMenuItem1.setMnemonic('l');
                this.ivjCloseAllMenuItem1.setText("Close All Files");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseAllMenuItem1;
    }

    private JButton getCloseButton() {
        if (this.ivjCloseButton == null) {
            try {
                this.ivjCloseButton = new JButton();
                this.ivjCloseButton.setName("CloseButton");
                this.ivjCloseButton.setMnemonic('C');
                this.ivjCloseButton.setText("Close");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseButton;
    }

    private JMenuItem getCloseMenuItem() {
        if (this.ivjCloseMenuItem == null) {
            try {
                this.ivjCloseMenuItem = new JMenuItem();
                this.ivjCloseMenuItem.setName("CloseMenuItem");
                this.ivjCloseMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/remove.gif")));
                this.ivjCloseMenuItem.setMnemonic('C');
                this.ivjCloseMenuItem.setText("Close Files");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseMenuItem;
    }

    private JMenuItem getCloseMenuItem1() {
        if (this.ivjCloseMenuItem1 == null) {
            try {
                this.ivjCloseMenuItem1 = new JMenuItem();
                this.ivjCloseMenuItem1.setName("CloseMenuItem1");
                this.ivjCloseMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/remove.gif")));
                this.ivjCloseMenuItem1.setMnemonic('C');
                this.ivjCloseMenuItem1.setText("Close Files");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseMenuItem1;
    }

    public long getCollected(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.type == 0) {
                counter += this.giPart.totalBefore[i] - this.giPart.freeBefore[i] - (this.giPart.total[i] - this.giPart.free[i]);
            } else if (this.giPart.simpleSolaris) {
                counter += this.giPart.totalBefore[i] - this.giPart.freeBefore[i] - (this.giPart.total[i] - this.giPart.free[i]);
            } else {
                counter += this.giPart.totalBefore[i] - this.giPart.freeBefore[i] - (this.giPart.total[i] - this.giPart.free[i]);
                if (this.giPart.freeNursery != null) {
                    counter += this.giPart.totalNurseryBefore[i] - this.giPart.freeNurseryBefore[i] - (this.giPart.totalNursery[i] - this.giPart.freeNursery[i]);
                }
                if (this.giPart.freePerm != null) {
                    counter += this.giPart.totalPermBefore[i] - this.giPart.freePermBefore[i] - (this.giPart.totalPermBefore[i] - this.giPart.freePerm[i]);
                }
            }
            ++i;
        }
        return counter;
    }

    public long getCollectedFull(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.isFullGC[i]) {
                if (this.giPart.type == 0) {
                    counter += this.giPart.free[i] - this.giPart.freeBefore[i];
                } else if (this.giPart.simpleSolaris) {
                    counter += this.giPart.free[i] - this.giPart.freeBefore[i];
                } else {
                    counter += this.giPart.free[i] - this.giPart.freeBefore[i];
                    if (this.giPart.freeNursery != null) {
                        counter += this.giPart.freeNursery[i] - this.giPart.freeNurseryBefore[i];
                    }
                    if (this.giPart.freePerm != null) {
                        counter += this.giPart.freePerm[i] - this.giPart.freePermBefore[i];
                    }
                }
            }
            ++i;
        }
        return counter;
    }

    public long getCollectedGlobal(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 1) {
                counter += this.giPart.free[i] - this.giPart.freeBefore[i];
                if (this.giPart.freeNursery != null) {
                    counter += this.giPart.freeNursery[i] - this.giPart.freeNurseryBefore[i];
                }
                if (this.giPart.freePerm != null) {
                    counter += this.giPart.freePerm[i] - this.giPart.freePermBefore[i];
                }
            }
            ++i;
        }
        return counter;
    }

    public long getCollectedScavenger(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 2) {
                counter += this.giPart.free[i] - this.giPart.freeBefore[i];
                if (this.giPart.freeNursery != null) {
                    counter += this.giPart.freeNursery[i] - this.giPart.freeNurseryBefore[i];
                }
                if (this.giPart.freePerm != null) {
                    counter += this.giPart.freePerm[i] - this.giPart.freePermBefore[i];
                }
            }
            ++i;
        }
        return counter;
    }

    private JComboBox getColorComboBox() {
        if (this.ivjColorComboBox == null) {
            try {
                this.ivjColorComboBox = new JComboBox();
                this.ivjColorComboBox.setName("ColorComboBox");
                this.ivjColorComboBox.setMaximumRowCount(10);
                this.ivjColorComboBox.setBounds(124, 52, 241, 25);
                this.ivjColorComboBox.setSelectedIndex(-1);
                this.colorComboBoxRenderer = new ColorComboBoxRenderer(this.cfg, this.getColorComboBox());
                this.ivjColorComboBox.setRenderer(this.colorComboBoxRenderer);
                int i = 0;
                while (i < ColorComboBoxRenderer.stateString.length) {
                    this.ivjColorComboBox.addItem(ColorComboBoxRenderer.stateString[i]);
                    ++i;
                }
                this.ivjColorComboBox.setSelectedIndex(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjColorComboBox;
    }

    private JCheckBoxMenuItem getConsoleCheckBoxMenuItem() {
        if (this.ivjConsoleCheckBoxMenuItem == null) {
            try {
                this.ivjConsoleCheckBoxMenuItem = new JCheckBoxMenuItem();
                this.ivjConsoleCheckBoxMenuItem.setName("ConsoleCheckBoxMenuItem");
                this.ivjConsoleCheckBoxMenuItem.setSelected(true);
                this.ivjConsoleCheckBoxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/console_view.gif")));
                this.ivjConsoleCheckBoxMenuItem.setMnemonic('n');
                this.ivjConsoleCheckBoxMenuItem.setText("Console");
                this.ivjConsoleCheckBoxMenuItem.setActionCommand("Console");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsoleCheckBoxMenuItem;
    }

    private JInternalFrame getConsoleFrame() {
        if (this.ivjConsoleFrame == null) {
            try {
                this.ivjConsoleFrame = new JInternalFrame();
                this.ivjConsoleFrame.setName("ConsoleFrame");
                this.ivjConsoleFrame.setTitle("Console");
                this.ivjConsoleFrame.setIconifiable(true);
                this.ivjConsoleFrame.setVisible(true);
                this.ivjConsoleFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/console_view.gif")));
                this.ivjConsoleFrame.setBounds(5, 281, 570, 138);
                this.ivjConsoleFrame.setMaximizable(true);
                this.ivjConsoleFrame.setResizable(true);
                this.getConsoleFrame().setContentPane(this.getJInternalFrameContentPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsoleFrame;
    }

    private JScrollPane getConsoleScrollPane() {
        if (this.ivjConsoleScrollPane == null) {
            try {
                this.ivjConsoleScrollPane = new JScrollPane();
                this.ivjConsoleScrollPane.setName("ConsoleScrollPane");
                this.getConsoleScrollPane().setViewportView(this.getConsoleTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsoleScrollPane;
    }

    private JTextArea getConsoleTextArea() {
        if (this.ivjConsoleTextArea == null) {
            try {
                this.ivjConsoleTextArea = new JTextArea();
                this.ivjConsoleTextArea.setName("ConsoleTextArea");
                this.ivjConsoleTextArea.setBounds(0, 0, 245, 107);
                this.ivjConsoleTextArea.setEditable(false);
                this.ivjConsoleTextArea.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConsoleTextArea;
    }

    private JButton getDefaultButton() {
        if (this.ivjDefaultButton == null) {
            try {
                this.ivjDefaultButton = new JButton();
                this.ivjDefaultButton.setName("DefaultButton");
                this.ivjDefaultButton.setMnemonic('D');
                this.ivjDefaultButton.setText("Default");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultButton;
    }

    private JTextField getDefaultPath() {
        if (this.ivjDefaultPath == null) {
            try {
                this.ivjDefaultPath = new JTextField();
                this.ivjDefaultPath.setName("DefaultPath");
                this.ivjDefaultPath.setBounds(124, 13, 148, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultPath;
    }

    private JTextField getDefaultTime() {
        if (this.ivjDefaultTime == null) {
            try {
                this.ivjDefaultTime = new JTextField();
                this.ivjDefaultTime.setName("DefaultTime");
                this.ivjDefaultTime.setBounds(218, 421, 149, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultTime;
    }

    private JButton getDefaultToolBarButton() {
        if (this.ivjDefaultToolBarButton == null) {
            try {
                this.ivjDefaultToolBarButton = new JButton();
                this.ivjDefaultToolBarButton.setName("DefaultToolBarButton");
                this.ivjDefaultToolBarButton.setToolTipText("Open IBM verbosegc trace");
                this.ivjDefaultToolBarButton.setText("");
                this.ivjDefaultToolBarButton.setHorizontalTextPosition(0);
                this.ivjDefaultToolBarButton.setVerticalTextPosition(3);
                this.ivjDefaultToolBarButton.setIcon(new ImageIcon(this.getClass().getResource("/openI.gif")));
                this.ivjDefaultToolBarButton.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultToolBarButton;
    }

    private JScrollPane getDetailScrollPane() {
        if (this.ivjDetailScrollPane == null) {
            try {
                this.ivjDetailScrollPane = new JScrollPane();
                this.ivjDetailScrollPane.setName("DetailScrollPane");
                this.getDetailScrollPane().setViewportView(this.getDetailTextPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetailScrollPane;
    }

    private JEditorPane getDetailTextPane() {
        if (this.ivjDetailTextPane == null) {
            try {
                this.ivjDetailTextPane = new JEditorPane();
                this.ivjDetailTextPane.setName("DetailTextPane");
                this.ivjDetailTextPane.setDocument(new HTMLDocument());
                this.ivjDetailTextPane.setBounds(0, 0, 26, 23);
                this.ivjDetailTextPane.setEditable(false);
                this.ivjDetailTextPane.setContentType("text/html");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDetailTextPane;
    }

    public String getDetailTextPaneText() {
        return this.getDetailTextPane().getText();
    }

    private JMenuItem getDurationMenuItem() {
        if (this.ivjDurationMenuItem == null) {
            try {
                this.ivjDurationMenuItem = new JMenuItem();
                this.ivjDurationMenuItem.setName("DurationMenuItem");
                this.ivjDurationMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/displayjoblog.gif")));
                this.ivjDurationMenuItem.setMnemonic('U');
                this.ivjDurationMenuItem.setText("Usage Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDurationMenuItem;
    }

    private JMenuItem getDurationMenuItem1() {
        if (this.ivjDurationMenuItem1 == null) {
            try {
                this.ivjDurationMenuItem1 = new JMenuItem();
                this.ivjDurationMenuItem1.setName("DurationMenuItem1");
                this.ivjDurationMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/displayjoblog.gif")));
                this.ivjDurationMenuItem1.setMnemonic('U');
                this.ivjDurationMenuItem1.setText("Usage Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDurationMenuItem1;
    }

    private JTextField getEndTime() {
        if (this.ivjEndTime == null) {
            try {
                this.ivjEndTime = new JTextField();
                this.ivjEndTime.setName("EndTime");
                this.ivjEndTime.setBounds(233, 52, 165, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEndTime;
    }

    private JMenuItem getExitMenuItem() {
        if (this.ivjExitMenuItem == null) {
            try {
                this.ivjExitMenuItem = new JMenuItem();
                this.ivjExitMenuItem.setName("ExitMenuItem");
                this.ivjExitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/close.gif")));
                this.ivjExitMenuItem.setMnemonic('x');
                this.ivjExitMenuItem.setText("Exit");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExitMenuItem;
    }

    public JInternalFrame getFileFrame() {
        if (this.ivjFileFrame == null) {
            try {
                this.ivjFileFrame = new JInternalFrame();
                this.ivjFileFrame.setName("FileFrame");
                this.ivjFileFrame.setResizable(true);
                this.ivjFileFrame.setIconifiable(true);
                this.ivjFileFrame.setVisible(true);
                this.ivjFileFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
                this.ivjFileFrame.setBounds(4, 8, 570, 242);
                this.ivjFileFrame.setMaximizable(true);
                this.ivjFileFrame.setEnabled(true);
                this.ivjFileFrame.setTitle("File List");
                this.getFileFrame().setContentPane(this.getJInternalFrameContentPane1());
                this.fileTable = new JTable(){

                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                        Component c = super.prepareRenderer(renderer, row, column);
                        return c;
                    }
                };
                PopupListener popupListener = new PopupListener(this.getFileTableMenu(), this.fileTable, this);
                this.fileTable.addMouseListener(popupListener);
                this.fileTable.setDragEnabled(true);
                this.fileModel = new FileTableModel(this.ti);
                this.fileTable.setModel(this.fileModel);
                this.getFileListScrollPane().setViewportView(this.fileTable);
                ListSelectionModel rowSM = this.fileTable.getSelectionModel();
                rowSM.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (e.getValueIsAdjusting()) {
                            return;
                        }
                        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                        if (lsm.isSelectionEmpty()) {
                            return;
                        }
                        GCAnalyzer.this.displaySummary();
                    }
                });
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileFrame;
    }

    private JScrollPane getFileListScrollPane() {
        if (this.ivjFileListScrollPane == null) {
            try {
                this.ivjFileListScrollPane = new JScrollPane();
                this.ivjFileListScrollPane.setName("FileListScrollPane");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileListScrollPane;
    }

    private JMenu getFileMenu() {
        if (this.ivjFileMenu == null) {
            try {
                this.ivjFileMenu = new JMenu();
                this.ivjFileMenu.setName("FileMenu");
                this.ivjFileMenu.setMnemonic('F');
                this.ivjFileMenu.setText("File");
                this.ivjFileMenu.add(this.getAutoOpenMenuItem());
                this.ivjFileMenu.add(this.getOpenMenuItem());
                this.ivjFileMenu.add(this.getOpenMenuItemSolaris());
                this.ivjFileMenu.add(this.getOpenMenuItemXverbosegc());
                this.ivjFileMenu.add(this.getRefreshMenuItem1());
                this.ivjFileMenu.add(this.getJSeparator4());
                this.ivjFileMenu.add(this.getExportMenu());
                this.ivjFileMenu.add(this.getJSeparator4());
                this.ivjFileMenu.add(this.getCloseMenuItem());
                this.ivjFileMenu.add(this.getCloseAllMenuItem());
                this.ivjFileMenu.add(this.getJSeparator5());
                this.ivjFileMenu.add(this.getExitMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileMenu;
    }

    private JSplitPane getFileSplitPane() {
        if (this.ivjFileSplitPane == null) {
            try {
                this.ivjFileSplitPane = new JSplitPane(0);
                this.ivjFileSplitPane.setName("FileSplitPane");
                this.ivjFileSplitPane.setDividerLocation(100);
                this.ivjFileSplitPane.setOneTouchExpandable(true);
                this.getFileSplitPane().add((Component)this.getFileListScrollPane(), "top");
                this.getFileSplitPane().add((Component)this.getDetailScrollPane(), "bottom");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileSplitPane;
    }

    private JPopupMenu getFileTableMenu() {
        if (this.ivjFileTableMenu == null) {
            try {
                this.ivjFileTableMenu = new JPopupMenu();
                this.ivjFileTableMenu.setName("FileTableMenu");
                this.ivjFileTableMenu.add(this.getRefreshMenuItem());
                this.ivjFileTableMenu.add(this.getGC_ListMenuItem1());
                this.ivjFileTableMenu.add(this.getGCViewPartMenuItem());
                this.ivjFileTableMenu.add(this.getGraph_ViewMenuItem1());
                this.ivjFileTableMenu.add(this.getGraph_ViewMenuItem11());
                this.ivjFileTableMenu.add(this.getStatisticsMenuItem1());
                this.ivjFileTableMenu.add(this.getJSeparator3());
                this.ivjFileTableMenu.add(this.getDurationMenuItem1());
                this.ivjFileTableMenu.add(this.getUsageMenuItem1());
                this.ivjFileTableMenu.add(this.getAFMenuItem1());
                this.ivjFileTableMenu.add(this.getJSeparator6());
                this.ivjFileTableMenu.add(this.getCloseMenuItem1());
                this.ivjFileTableMenu.add(this.getCloseAllMenuItem1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileTableMenu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFileType(File file) {
        try {
            char[] cbuffer = new char[11];
            BufferedReader br = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(file)));
            String txtSignature = br.readLine();
            txtSignature = this.filterZOS(txtSignature);
            if (txtSignature != null) {
                txtSignature = txtSignature.trim();
            }
            while (true) {
                if (txtSignature == null) {
                    return 0;
                }
                if (txtSignature.startsWith(J9_SIGNATURE2)) {
                    br.close();
                    return 1;
                }
                if (txtSignature.startsWith(J9_SIGNATURE623)) {
                    br.close();
                    return 2;
                }
                txtSignature = br.readLine();
                if (txtSignature == null) continue;
                txtSignature = this.filterZOS(txtSignature);
                txtSignature = txtSignature.trim();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    private String filterZOS(String line) {
        if (line == null) {
            return null;
        }
        int i = line.indexOf(65533);
        if (i >= 0 && line.length() > i + 1) {
            line = line.substring(i + 1);
        }
        return line;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getGCLogType(File file) {
        int threshold = 10;
        int i1 = 0;
        int i2 = 0;
        int i0 = 0;
        int s = 0;
        int x = 0;
        try {
            BufferedReader br;
            block24: {
                char[] cbuffer = new char[11];
                br = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(file)));
                String txtSignature = br.readLine();
                if (txtSignature != null) {
                    txtSignature = txtSignature.trim();
                }
                do {
                    if (txtSignature == null) {
                        threshold = 0;
                        if (i2 > threshold) {
                            br.close();
                            return 2;
                        }
                        break block24;
                    }
                    if (txtSignature.startsWith(J9_SIGNATURE2)) {
                        ++i1;
                    } else if (txtSignature.startsWith(J9_SIGNATURE623)) {
                        ++i2;
                    } else if (txtSignature.startsWith(SOV_SIGNATURE1) || txtSignature.startsWith(SOV_SIGNATURE1)) {
                        ++i0;
                    } else if (txtSignature.endsWith(SOL_SIGNATURE)) {
                        ++s;
                    } else if (txtSignature.startsWith(X_SIGNATURE)) {
                        ++x;
                    } else {
                        txtSignature = br.readLine();
                        if (txtSignature != null) {
                            txtSignature = txtSignature.trim();
                        }
                    }
                    if (i2 > threshold) {
                        br.close();
                        return 2;
                    }
                    if (i1 > threshold) {
                        br.close();
                        return 1;
                    }
                    if (i0 > threshold) {
                        br.close();
                        return 0;
                    }
                    if (s <= threshold) continue;
                    br.close();
                    return 3;
                } while (x <= threshold);
                br.close();
                return 4;
            }
            if (i1 > threshold) {
                br.close();
                return 1;
            }
            if (i0 > threshold) {
                br.close();
                return 0;
            }
            if (s > threshold) {
                br.close();
                return 3;
            }
            if (x <= threshold) return 0;
            br.close();
            return 4;
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    public int getFullGC(int s, int e) {
        int counter = 0;
        int i = s;
        while (i <= e) {
            if (this.giPart.isFullGC[i]) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    private JMenuItem getGC_ListMenuItem() {
        if (this.ivjGC_ListMenuItem == null) {
            try {
                this.ivjGC_ListMenuItem = new JMenuItem();
                this.ivjGC_ListMenuItem.setName("GC_ListMenuItem");
                this.ivjGC_ListMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
                this.ivjGC_ListMenuItem.setMnemonic('G');
                this.ivjGC_ListMenuItem.setText("GC View All");
                this.ivjGC_ListMenuItem.setActionCommand("GC View All");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGC_ListMenuItem;
    }

    private JMenuItem getGC_ListMenuItem1() {
        if (this.ivjGC_ListMenuItem1 == null) {
            try {
                this.ivjGC_ListMenuItem1 = new JMenuItem();
                this.ivjGC_ListMenuItem1.setName("GC_ListMenuItem1");
                this.ivjGC_ListMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
                this.ivjGC_ListMenuItem1.setMnemonic('G');
                this.ivjGC_ListMenuItem1.setText("GC View All");
                this.ivjGC_ListMenuItem1.setActionCommand("GC View All");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGC_ListMenuItem1;
    }

    private JMenuBar getGCAnalyzerJMenuBar() {
        if (this.ivjGCAnalyzerJMenuBar == null) {
            try {
                this.ivjGCAnalyzerJMenuBar = new JMenuBar();
                this.ivjGCAnalyzerJMenuBar.setName("GCAnalyzerJMenuBar");
                this.ivjGCAnalyzerJMenuBar.add(this.getFileMenu());
                this.ivjGCAnalyzerJMenuBar.add(this.getAnalysisMenu());
                this.ivjGCAnalyzerJMenuBar.add(this.getViewMenu());
                this.ivjGCAnalyzerJMenuBar.add(this.getHelpMenu());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGCAnalyzerJMenuBar;
    }

    public long getGCCompleted(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            counter += this.giPart.gccompleted[i];
            ++i;
        }
        return counter;
    }

    public long getGCCompletedFull(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.isFullGC[i]) {
                counter += this.giPart.gccompleted[i];
            }
            ++i;
        }
        return counter;
    }

    public long getGCCompletedGlobal(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 1) {
                counter += this.giPart.gccompleted[i];
            }
            ++i;
        }
        return counter;
    }

    public long getGCCompletedScavenger(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 2) {
                counter += this.giPart.gccompleted[i];
            }
            ++i;
        }
        return counter;
    }

    public long getGCSince(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            counter += this.giPart.since[i];
            ++i;
        }
        return counter;
    }

    public long getGCSinceFull(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.isFullGC[i]) {
                counter += this.giPart.since[i];
            }
            ++i;
        }
        return counter;
    }

    public long getGCSinceGlobal(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 1) {
                counter += this.giPart.since[i];
            }
            ++i;
        }
        return counter;
    }

    public long getGCSinceScavenger(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0L;
        }
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 2) {
                counter += this.giPart.since[i];
            }
            ++i;
        }
        return counter;
    }

    private JMenuItem getGCViewPartMenuItem() {
        if (this.ivjGCViewPartMenuItem == null) {
            try {
                this.ivjGCViewPartMenuItem = new JMenuItem();
                this.ivjGCViewPartMenuItem.setName("GCViewPartMenuItem");
                this.ivjGCViewPartMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/RecordSfl.gif")));
                this.ivjGCViewPartMenuItem.setMnemonic('P');
                this.ivjGCViewPartMenuItem.setText("GC View Part");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGCViewPartMenuItem;
    }

    private JMenuItem getGCViewPartMenuItem1() {
        if (this.ivjGCViewPartMenuItem1 == null) {
            try {
                this.ivjGCViewPartMenuItem1 = new JMenuItem();
                this.ivjGCViewPartMenuItem1.setName("GCViewPartMenuItem1");
                this.ivjGCViewPartMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/RecordSfl.gif")));
                this.ivjGCViewPartMenuItem1.setMnemonic('P');
                this.ivjGCViewPartMenuItem1.setText("GC View Part");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGCViewPartMenuItem1;
    }

    public int getGlobalCollection(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0;
        }
        int counter = 0;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 1) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    private JMenuItem getGraph_ViewMenuItem() {
        if (this.ivjGraph_ViewMenuItem == null) {
            try {
                this.ivjGraph_ViewMenuItem = new JMenuItem();
                this.ivjGraph_ViewMenuItem.setName("Graph_ViewMenuItem");
                this.ivjGraph_ViewMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
                this.ivjGraph_ViewMenuItem.setMnemonic('A');
                this.ivjGraph_ViewMenuItem.setText("Graph View All");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraph_ViewMenuItem;
    }

    private JMenuItem getGraph_ViewMenuItem1() {
        if (this.ivjGraph_ViewMenuItem1 == null) {
            try {
                this.ivjGraph_ViewMenuItem1 = new JMenuItem();
                this.ivjGraph_ViewMenuItem1.setName("Graph_ViewMenuItem1");
                this.ivjGraph_ViewMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
                this.ivjGraph_ViewMenuItem1.setMnemonic('A');
                this.ivjGraph_ViewMenuItem1.setText("Graph View All");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraph_ViewMenuItem1;
    }

    private JMenuItem getRefreshMenuItem() {
        if (this.ivjRefreshMenuItem == null) {
            try {
                this.ivjRefreshMenuItem = new JMenuItem();
                this.ivjRefreshMenuItem.setName("RefreshFile");
                this.ivjRefreshMenuItem.setMnemonic('R');
                this.ivjRefreshMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/refresh.gif")));
                this.ivjRefreshMenuItem.setText("Refresh File");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRefreshMenuItem;
    }

    private JMenuItem getRefreshMenuItem1() {
        if (this.ivjRefreshMenuItem1 == null) {
            try {
                this.ivjRefreshMenuItem1 = new JMenuItem();
                this.ivjRefreshMenuItem1.setName("RefreshFile");
                this.ivjRefreshMenuItem1.setMnemonic('R');
                this.ivjRefreshMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/refresh.gif")));
                this.ivjRefreshMenuItem1.setText("Refresh File");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRefreshMenuItem1;
    }

    private JMenuItem getGraph_ViewMenuItem11() {
        if (this.ivjGraph_ViewMenuItem11 == null) {
            try {
                this.ivjGraph_ViewMenuItem11 = new JMenuItem();
                this.ivjGraph_ViewMenuItem11.setName("Graph_ViewMenuItem11");
                this.ivjGraph_ViewMenuItem11.setIcon(new ImageIcon(this.getClass().getResource("/chartPart.gif")));
                this.ivjGraph_ViewMenuItem11.setMnemonic('r');
                this.ivjGraph_ViewMenuItem11.setText("Graph View Part");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraph_ViewMenuItem11;
    }

    private JMenuItem getGraph_ViewMenuItem2() {
        if (this.ivjGraph_ViewMenuItem2 == null) {
            try {
                this.ivjGraph_ViewMenuItem2 = new JMenuItem();
                this.ivjGraph_ViewMenuItem2.setName("Graph_ViewMenuItem2");
                this.ivjGraph_ViewMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/chartPart.gif")));
                this.ivjGraph_ViewMenuItem2.setMnemonic('r');
                this.ivjGraph_ViewMenuItem2.setText("Graph View Part");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraph_ViewMenuItem2;
    }

    private JMenuItem getHelp_TopicsMenuItem() {
        if (this.ivjHelp_TopicsMenuItem == null) {
            try {
                this.ivjHelp_TopicsMenuItem = new JMenuItem();
                this.ivjHelp_TopicsMenuItem.setName("Help_TopicsMenuItem");
                this.ivjHelp_TopicsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/help.gif")));
                this.ivjHelp_TopicsMenuItem.setMnemonic('H');
                this.ivjHelp_TopicsMenuItem.setText("Help Topics");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHelp_TopicsMenuItem;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
        }
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
        this.updateButton.setToolTipText("Check for updates");
        if (this.isISA) {
            this.updateButton.setEnabled(false);
            this.updateButton.setToolTipText(STANDALONE_VERSION_TEXT);
        }
        return this.updateButton;
    }

    private JMenu getHelpMenu() {
        if (this.ivjHelpMenu == null) {
            try {
                this.ivjHelpMenu = new JMenu();
                this.ivjHelpMenu.setName("HelpMenu");
                this.ivjHelpMenu.setMnemonic('H');
                this.ivjHelpMenu.setText("Help");
                this.ivjHelpMenu.add(this.getHelp_TopicsMenuItem());
                this.ivjHelpMenu.add(this.getUpdateMenuItem());
                this.ivjHelpMenu.add(this.getAbout_BoxMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHelpMenu;
    }

    public static InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException e) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }

    private JCheckBox getJCheckBoxBold() {
        if (this.ivjJCheckBoxBold == null) {
            try {
                this.ivjJCheckBoxBold = new JCheckBox();
                this.ivjJCheckBoxBold.setName("JCheckBoxBold");
                this.ivjJCheckBoxBold.setText("Bold");
                this.ivjJCheckBoxBold.setBounds(124, 129, 56, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxBold;
    }

    private JCheckBox getJCheckBoxFileList() {
        if (this.ivjJCheckBoxFileList == null) {
            try {
                this.ivjJCheckBoxFileList = new JCheckBox();
                this.ivjJCheckBoxFileList.setName("JCheckBoxFileList");
                this.ivjJCheckBoxFileList.setSelected(true);
                this.ivjJCheckBoxFileList.setMnemonic('L');
                this.ivjJCheckBoxFileList.setText("Maximize File List");
                this.ivjJCheckBoxFileList.setBounds(182, 307, 165, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxFileList;
    }

    private JCheckBox getJCheckBoxItalic() {
        if (this.ivjJCheckBoxItalic == null) {
            try {
                this.ivjJCheckBoxItalic = new JCheckBox();
                this.ivjJCheckBoxItalic.setName("JCheckBoxItalic");
                this.ivjJCheckBoxItalic.setFont(new Font("Arial", 2, 12));
                this.ivjJCheckBoxItalic.setText("Italic");
                this.ivjJCheckBoxItalic.setBounds(193, 129, 52, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxItalic;
    }

    private JCheckBox getJCheckBoxMax() {
        if (this.ivjJCheckBoxMax == null) {
            try {
                this.ivjJCheckBoxMax = new JCheckBox();
                this.ivjJCheckBoxMax.setName("JCheckBoxMax");
                this.ivjJCheckBoxMax.setSelected(true);
                this.ivjJCheckBoxMax.setMnemonic('x');
                this.ivjJCheckBoxMax.setText("Maximize at startup");
                this.ivjJCheckBoxMax.setBounds(182, 276, 165, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxMax;
    }

    private JComboBox getJComboBoxFont() {
        if (this.ivjJComboBoxFont == null) {
            try {
                this.ivjJComboBoxFont = new JComboBox();
                this.ivjJComboBoxFont.setName("JComboBoxFont");
                this.ivjJComboBoxFont.setBounds(124, 92, 130, 23);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJComboBoxFont;
    }

    public JDesktopPane getJDesktopPane1() {
        if (this.ivjJDesktopPane1 == null) {
            try {
                this.ivjJDesktopPane1 = new JDesktopPane();
                this.ivjJDesktopPane1.setName("JDesktopPane1");
                this.getJDesktopPane1().add((Component)this.getConsoleFrame(), this.getConsoleFrame().getName());
                this.getJDesktopPane1().add((Component)this.getFileFrame(), this.getFileFrame().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDesktopPane1;
    }

    public Container getJDialog() {
        return this.getOptionDialog();
    }

    public void writePreferenceFile() {
        try {
            prefs.exportNode(new FileOutputStream(PREFERENCE_FILE));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void loadPreferenceFile() {
        try {
            prefs.clear();
        }
        catch (BackingStoreException e2) {
            e2.printStackTrace();
        }
        BufferedInputStream is = null;
        FileInputStream fio = null;
        try {
            fio = new FileInputStream(PREFERENCE_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fio != null) {
            try {
                is = new BufferedInputStream(fio);
            }
            catch (Exception e) {
                this.handleException(e);
                return;
            }
            if (is != null) {
                try {
                    Preferences.importPreferences(is);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
                catch (InvalidPreferencesFormatException e) {
                    this.handleException(e);
                }
                this.cfg.lookAndFeel = prefs.getInt("lookAndFeel", 0);
                this.cfg.verbose = prefs.getBoolean("verbose", true);
                this.cfg.autoY = prefs.getBoolean("autoY", true);
                this.cfg.save = prefs.getBoolean("save", true);
                this.cfg.terminals = prefs.getBoolean("terminals", true);
                this.cfg.points = prefs.getBoolean("points", false);
                this.cfg.frag = prefs.getInt("frag", 30);
                this.cfg.large = prefs.getInt("large", 10);
                this.cfg.exhaustion = prefs.getInt("exhaustion", 10);
                this.cfg.overheadRatio = prefs.getInt("overheadRatio", 10);
                this.cfg.max = prefs.getBoolean("max", true);
                this.cfg.fileList = prefs.getBoolean("fileList", true);
                this.cfg.limit = prefs.getLong("limit", 1000L);
                this.cfg.width = prefs.getInt("width", 1024);
                this.cfg.height = prefs.getInt("height", 768);
                String name = prefs.get("fontFamily", null);
                if (name == null) {
                    this.cfg.font = null;
                } else {
                    int size = prefs.getInt("fontSize", 10);
                    int style = prefs.getInt("fontStyle", 0);
                    this.cfg.font = new Font(name, style, size);
                }
                this.cfg.defaultStartTime = prefs.getLong("defaultStartTime", 0L);
                this.cfg.workingDir = prefs.get("workingDir", Configuration.WORKINGDIR);
                this.cfg.free = new Color(prefs.getInt("free", Configuration.FREE.getRGB()));
                this.cfg.freeSOA = new Color(prefs.getInt("freeSOA", Configuration.FREESOA.getRGB()));
                this.cfg.freeBeforeSOA = new Color(prefs.getInt("freeBeforeSOA", Configuration.FREEBEFORESOA.getRGB()));
                this.cfg.freeLOA = new Color(prefs.getInt("freeLOA", Configuration.FREELOA.getRGB()));
                this.cfg.freeBeforeLOA = new Color(prefs.getInt("freeBeforeLOA", Configuration.FREEBEFORELOA.getRGB()));
                this.cfg.freeN = new Color(prefs.getInt("freeN", Configuration.FREEN.getRGB()));
                this.cfg.freeNBefore = new Color(prefs.getInt("freeNBefore", Configuration.FREENBEFORE.getRGB()));
                this.cfg.freeBefore = new Color(prefs.getInt("freeBefore", Configuration.FREEBEFORE.getRGB()));
                this.cfg.freed = new Color(prefs.getInt("freed", Configuration.FREED.getRGB()));
                this.cfg.overhead = new Color(prefs.getInt("overhead", Configuration.OVERHEAD.getRGB()));
                this.cfg.used = new Color(prefs.getInt("used", Configuration.USED.getRGB()));
                this.cfg.usedN = new Color(prefs.getInt("usedN", Configuration.USEDN.getRGB()));
                this.cfg.usedNBefore = new Color(prefs.getInt("usedNBefore", Configuration.USEDNBEFORE.getRGB()));
                this.cfg.usedBefore = new Color(prefs.getInt("usedBefore", Configuration.USEDBEFORE.getRGB()));
                this.cfg.total = new Color(prefs.getInt("total", Configuration.TOTAL.getRGB()));
                this.cfg.totalLOA = new Color(prefs.getInt("totalLOA", Configuration.TOTALLOA.getRGB()));
                this.cfg.totalSOA = new Color(prefs.getInt("totalSOA", Configuration.TOTALSOA.getRGB()));
                this.cfg.totalN = new Color(prefs.getInt("totalN", Configuration.TOTALN.getRGB()));
                this.cfg.totalBefore = new Color(prefs.getInt("totalBefore", Configuration.TOTALBEFORE.getRGB()));
                this.cfg.totalBeforeSOA = new Color(prefs.getInt("totalBeforeSOA", Configuration.TOTALBEFORESOA.getRGB()));
                this.cfg.totalBeforeLOA = new Color(prefs.getInt("totalBeforeLOA", Configuration.TOTALBEFORELOA.getRGB()));
                this.cfg.totalNBefore = new Color(prefs.getInt("totalNBefore", Configuration.TOTALNBEFORE.getRGB()));
                this.cfg.requested = new Color(prefs.getInt("requested", Configuration.REQUESTED.getRGB()));
                this.cfg.since = new Color(prefs.getInt("since", Configuration.SINCE.getRGB()));
                this.cfg.completed = new Color(prefs.getInt("completed", Configuration.COMPLETED.getRGB()));
                this.cfg.gccompleted = new Color(prefs.getInt("gccompleted", Configuration.GCCOMPLETED.getRGB()));
                this.cfg.mark = new Color(prefs.getInt("mark", Configuration.MARK.getRGB()));
                this.cfg.sweep = new Color(prefs.getInt("sweep", Configuration.SWEEP.getRGB()));
                this.cfg.compact = new Color(prefs.getInt("compact", Configuration.COMPACT.getRGB()));
                this.cfg.totalPBefore = new Color(prefs.getInt("totalPBefore", Configuration.TOTALPBEFORE.getRGB()));
                this.cfg.usedPBefore = new Color(prefs.getInt("usedPBefore", Configuration.USEDPBEFORE.getRGB()));
                this.cfg.usedPAfter = new Color(prefs.getInt("usedPAfter", Configuration.USEDPAFTER.getRGB()));
                this.cfg.freePAfter = new Color(prefs.getInt("freePAfter", Configuration.FREEPAFTER.getRGB()));
                this.cfg.freePBefore = new Color(prefs.getInt("freePBefore", Configuration.FREEPBEFORE.getRGB()));
                this.cfg.maxTen = new Color(prefs.getInt("maxTen", Configuration.MAXTEN.getRGB()));
                this.cfg.maxPerm = new Color(prefs.getInt("maxPerm", Configuration.MAXPERM.getRGB()));
                this.cfg.oome = new Color(prefs.getInt("oome", Configuration.OOME.getRGB()));
                this.cfg.restart = new Color(prefs.getInt("restart", Configuration.RESTART.getRGB()));
            }
        }
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanelOptionButtons(), "South");
                this.getJDialogContentPane().add((Component)this.getJTabbedPaneOption(), "Center");
                if (this.ge == null) {
                    this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                }
                String[] fontList = this.ge.getAvailableFontFamilyNames();
                int i = 0;
                while (i < fontList.length) {
                    this.getJComboBoxFont().addItem(fontList[i]);
                    ++i;
                }
                if (this.cfg.font != null) {
                    this.getJComboBoxFont().setSelectedItem(this.cfg.font.getFamily());
                    if (this.cfg.font.isBold()) {
                        this.getJCheckBoxBold().setSelected(true);
                    } else {
                        this.getJCheckBoxBold().setSelected(false);
                    }
                    if (this.cfg.font.isItalic()) {
                        this.getJCheckBoxItalic().setSelected(true);
                    } else {
                        this.getJCheckBoxItalic().setSelected(false);
                    }
                    this.getJTextFieldFontSize().setText("" + this.cfg.font.getSize());
                } else {
                    Font font = UIManager.getFont("Button.font");
                    this.getJComboBoxFont().setSelectedItem(font.getFamily());
                    this.getJTextFieldFontSize().setText("" + font.getSize());
                }
                this.getJTextFieldHeight().setText("" + this.cfg.height);
                this.getJTextFieldWidth().setText("" + this.cfg.width);
                this.getJTextFieldMessageLimit().setText("" + this.cfg.limit);
                switch (this.cfg.lookAndFeel) {
                    case 0: {
                        this.getMetalRadioButton().setSelected(true);
                        break;
                    }
                    case 1: {
                        this.getMotifRadioButton().setSelected(true);
                        break;
                    }
                    case 2: {
                        this.getSystemRadioButton().setSelected(true);
                    }
                }
                this.getJCheckBoxMax().setSelected(this.cfg.max);
                this.getJCheckBoxFileList().setSelected(this.cfg.fileList);
                this.getDefaultPath().setText(this.cfg.workingDir);
                this.getVerboseCheckBox().setSelected(this.cfg.verbose);
                this.getAutoYCheckBox().setSelected(this.cfg.autoY);
                this.getSaveCheckBox().setSelected(this.cfg.save);
                this.getTerminalCheckBox().setSelected(this.cfg.terminals);
                this.getPointsCheckBox().setSelected(this.cfg.points);
                this.getJSliderFrag().setValue(this.cfg.frag);
                this.getJSliderLarge().setValue(this.cfg.large);
                this.getJSliderExhaustion().setValue(this.cfg.exhaustion);
                this.getJSliderOverhead().setValue(this.cfg.overheadRatio);
                this.getJTextFieldFrag().setText(String.valueOf(this.cfg.frag));
                this.getJTextFieldLarge().setText(String.valueOf(this.cfg.large));
                this.getJTextFieldOverhead().setText(String.valueOf(this.cfg.overheadRatio));
                this.getJTextFieldExhaustion().setText(String.valueOf(this.cfg.exhaustion));
                this.getDefaultTime().setText(dateInputFormatter.format(new Date(this.cfg.defaultStartTime)));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJDialogContentPane1() {
        if (this.ivjJDialogContentPane1 == null) {
            try {
                this.ivjJDialogContentPane1 = new JPanel();
                this.ivjJDialogContentPane1.setName("JDialogContentPane1");
                this.ivjJDialogContentPane1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsPartOpenButton = new GridBagConstraints();
                constraintsPartOpenButton.gridx = 2;
                constraintsPartOpenButton.gridy = 1;
                constraintsPartOpenButton.ipadx = 20;
                constraintsPartOpenButton.insets = new Insets(11, 6, 3, 14);
                this.getJDialogContentPane1().add((Component)this.getPartOpenButton(), constraintsPartOpenButton);
                GridBagConstraints constraintsPartCancelButton = new GridBagConstraints();
                constraintsPartCancelButton.gridx = 2;
                constraintsPartCancelButton.gridy = 2;
                constraintsPartCancelButton.ipadx = 12;
                constraintsPartCancelButton.insets = new Insets(4, 6, 62, 14);
                this.getJDialogContentPane1().add((Component)this.getPartCancelButton(), constraintsPartCancelButton);
                GridBagConstraints constraintsPartListScrollPane = new GridBagConstraints();
                constraintsPartListScrollPane.gridx = 1;
                constraintsPartListScrollPane.gridy = 1;
                constraintsPartListScrollPane.gridheight = 2;
                constraintsPartListScrollPane.fill = 1;
                constraintsPartListScrollPane.weightx = 1.0;
                constraintsPartListScrollPane.weighty = 1.0;
                constraintsPartListScrollPane.ipadx = 260;
                constraintsPartListScrollPane.ipady = 101;
                constraintsPartListScrollPane.insets = new Insets(3, 3, 4, 5);
                this.getJDialogContentPane1().add((Component)this.getPartListScrollPane(), constraintsPartListScrollPane);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane1;
    }

    private JPanel getJDialogContentPane2() {
        if (this.ivjJDialogContentPane2 == null) {
            try {
                this.ivjJDialogContentPane2 = new JPanel();
                this.ivjJDialogContentPane2.setName("JDialogContentPane2");
                this.ivjJDialogContentPane2.setLayout(new BorderLayout());
                this.getJDialogContentPane2().add((Component)this.getStatisticsSplitPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane2;
    }

    public Container getJFrame() {
        return this;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getStatusBarPane(), "South");
                this.getJFrameContentPane().add((Component)this.getJDesktopPane1(), "Center");
                this.getJFrameContentPane().add((Component)this.getJToolBar1(), "North");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JPanel getJInternalFrameContentPane() {
        if (this.ivjJInternalFrameContentPane == null) {
            try {
                this.ivjJInternalFrameContentPane = new JPanel();
                this.ivjJInternalFrameContentPane.setName("JInternalFrameContentPane");
                this.ivjJInternalFrameContentPane.setLayout(new BorderLayout());
                this.getJInternalFrameContentPane().add((Component)this.getConsoleScrollPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJInternalFrameContentPane;
    }

    private JPanel getJInternalFrameContentPane1() {
        if (this.ivjJInternalFrameContentPane1 == null) {
            try {
                this.ivjJInternalFrameContentPane1 = new JPanel();
                this.ivjJInternalFrameContentPane1.setName("JInternalFrameContentPane1");
                this.ivjJInternalFrameContentPane1.setLayout(new BorderLayout());
                this.getJInternalFrameContentPane1().add((Component)this.getFileSplitPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJInternalFrameContentPane1;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Default directory");
                this.ivjJLabel1.setBounds(10, 13, 104, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("Chart Color");
                this.ivjJLabel2.setBounds(10, 57, 88, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Start time (HH:mm:ss MM/dd/yyyy)");
                this.ivjJLabel3.setBounds(17, 424, 200, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel31() {
        if (this.ivjJLabel31 == null) {
            try {
                this.ivjJLabel31 = new JLabel();
                this.ivjJLabel31.setName("JLabel31");
                this.ivjJLabel31.setText("Start time (HH:mm:ss MM/dd/yyyy)");
                this.ivjJLabel31.setBounds(18, 26, 200, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel31;
    }

    private JLabel getJLabel32() {
        if (this.ivjJLabel32 == null) {
            try {
                this.ivjJLabel32 = new JLabel();
                this.ivjJLabel32.setName("JLabel32");
                this.ivjJLabel32.setText("End time (HH:mm:ss MM/dd/yyyy)");
                this.ivjJLabel32.setBounds(19, 55, 200, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel32;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText("JVM message limit");
                this.ivjJLabel4.setBounds(10, 358, 141, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabelChartHeight() {
        if (this.ivjJLabelChartHeight == null) {
            try {
                this.ivjJLabelChartHeight = new JLabel();
                this.ivjJLabelChartHeight.setName("JLabelChartHeight");
                this.ivjJLabelChartHeight.setText("Height");
                this.ivjJLabelChartHeight.setBounds(216, 172, 51, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelChartHeight;
    }

    private JLabel getJLabelChartWidth() {
        if (this.ivjJLabelChartWidth == null) {
            try {
                this.ivjJLabelChartWidth = new JLabel();
                this.ivjJLabelChartWidth.setName("JLabelChartWidth");
                this.ivjJLabelChartWidth.setText("Chart Width");
                this.ivjJLabelChartWidth.setBounds(10, 172, 77, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelChartWidth;
    }

    private JLabel getJLabelExhaustion() {
        if (this.ivjJLabelExhaustion == null) {
            try {
                this.ivjJLabelExhaustion = new JLabel();
                this.ivjJLabelExhaustion.setName("JLabelExhaustion");
                this.ivjJLabelExhaustion.setText("Exhaustion Ratio(%)");
                this.ivjJLabelExhaustion.setBounds(14, 11, 148, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelExhaustion;
    }

    private JLabel getJLabelFont() {
        if (this.ivjJLabelFont == null) {
            try {
                this.ivjJLabelFont = new JLabel();
                this.ivjJLabelFont.setName("JLabelFont");
                this.ivjJLabelFont.setText("Chart Font");
                this.ivjJLabelFont.setBounds(10, 96, 87, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelFont;
    }

    private JLabel getJLabelFontSize() {
        if (this.ivjJLabelFontSize == null) {
            try {
                this.ivjJLabelFontSize = new JLabel();
                this.ivjJLabelFontSize.setName("JLabelFontSize");
                this.ivjJLabelFontSize.setText("Size");
                this.ivjJLabelFontSize.setBounds(282, 96, 29, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelFontSize;
    }

    private JLabel getJLabelFontStyle() {
        if (this.ivjJLabelFontStyle == null) {
            try {
                this.ivjJLabelFontStyle = new JLabel();
                this.ivjJLabelFontStyle.setName("JLabelFontStyle");
                this.ivjJLabelFontStyle.setText("Chart Font Style");
                this.ivjJLabelFontStyle.setBounds(10, 133, 93, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelFontStyle;
    }

    private JLabel getJLabelFrag() {
        if (this.ivjJLabelFrag == null) {
            try {
                this.ivjJLabelFrag = new JLabel();
                this.ivjJLabelFrag.setName("JLabelFrag");
                this.ivjJLabelFrag.setText("Fragmentation Ratio(%)");
                this.ivjJLabelFrag.setBounds(16, 9, 148, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelFrag;
    }

    private JLabel getJLabelLarge() {
        if (this.ivjJLabelLarge == null) {
            try {
                this.ivjJLabelLarge = new JLabel();
                this.ivjJLabelLarge.setName("JLabelLarge");
                this.ivjJLabelLarge.setText("Large Object Threshold (MB)");
                this.ivjJLabelLarge.setBounds(10, 12, 174, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelLarge;
    }

    private JLabel getJLabelOverhead() {
        if (this.ivjJLabelOverhead == null) {
            try {
                this.ivjJLabelOverhead = new JLabel();
                this.ivjJLabelOverhead.setName("JLabelOverhead");
                this.ivjJLabelOverhead.setText("Overhead Ratio(%)");
                this.ivjJLabelOverhead.setBounds(17, 9, 148, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelOverhead;
    }

    private JPanel getJPanelAdvanced() {
        if (this.ivjJPanelAdvanced == null) {
            try {
                this.ivjJPanelAdvanced = new JPanel();
                this.ivjJPanelAdvanced.setName("JPanelAdvanced");
                this.ivjJPanelAdvanced.setLayout(null);
                this.getJPanelAdvanced().add((Component)this.getJPanelFrag(), this.getJPanelFrag().getName());
                this.getJPanelAdvanced().add((Component)this.getJPanelLarge(), this.getJPanelLarge().getName());
                this.getJPanelAdvanced().add((Component)this.getJPanelLarge1(), this.getJPanelLarge1().getName());
                this.getJPanelAdvanced().add((Component)this.getJPanelLarge2(), this.getJPanelLarge2().getName());
                this.getJPanelAdvanced().add((Component)this.getWarningPanel(), this.getWarningPanel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelAdvanced;
    }

    private JPanel getJPanelFrag() {
        if (this.ivjJPanelFrag == null) {
            try {
                this.ivjJPanelFrag = new JPanel();
                this.ivjJPanelFrag.setName("JPanelFrag");
                this.ivjJPanelFrag.setBorder(new EtchedBorder());
                this.ivjJPanelFrag.setLayout(null);
                this.ivjJPanelFrag.setBounds(5, 8, 368, 86);
                this.getJPanelFrag().add((Component)this.getJLabelFrag(), this.getJLabelFrag().getName());
                this.getJPanelFrag().add((Component)this.getJTextFieldFrag(), this.getJTextFieldFrag().getName());
                this.getJPanelFrag().add((Component)this.getJSliderFrag(), this.getJSliderFrag().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelFrag;
    }

    private JPanel getJPanelLarge() {
        if (this.ivjJPanelLarge == null) {
            try {
                this.ivjJPanelLarge = new JPanel();
                this.ivjJPanelLarge.setName("JPanelLarge");
                this.ivjJPanelLarge.setBorder(new EtchedBorder());
                this.ivjJPanelLarge.setLayout(null);
                this.ivjJPanelLarge.setBounds(5, 102, 368, 86);
                this.getJPanelLarge().add((Component)this.getJLabelLarge(), this.getJLabelLarge().getName());
                this.getJPanelLarge().add((Component)this.getJSliderLarge(), this.getJSliderLarge().getName());
                this.getJPanelLarge().add((Component)this.getJTextFieldLarge(), this.getJTextFieldLarge().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelLarge;
    }

    private JPanel getJPanelLarge1() {
        if (this.ivjJPanelLarge1 == null) {
            try {
                this.ivjJPanelLarge1 = new JPanel();
                this.ivjJPanelLarge1.setName("JPanelLarge1");
                this.ivjJPanelLarge1.setBorder(new EtchedBorder());
                this.ivjJPanelLarge1.setLayout(null);
                this.ivjJPanelLarge1.setBounds(5, 196, 368, 86);
                this.getJPanelLarge1().add((Component)this.getJLabelOverhead(), this.getJLabelOverhead().getName());
                this.getJPanelLarge1().add((Component)this.getJTextFieldOverhead(), this.getJTextFieldOverhead().getName());
                this.getJPanelLarge1().add((Component)this.getJSliderOverhead(), this.getJSliderOverhead().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelLarge1;
    }

    private JPanel getJPanelLarge2() {
        if (this.ivjJPanelLarge2 == null) {
            try {
                this.ivjJPanelLarge2 = new JPanel();
                this.ivjJPanelLarge2.setName("JPanelLarge2");
                this.ivjJPanelLarge2.setBorder(new EtchedBorder());
                this.ivjJPanelLarge2.setLayout(null);
                this.ivjJPanelLarge2.setBounds(5, 290, 368, 86);
                this.getJPanelLarge2().add((Component)this.getJLabelExhaustion(), this.getJLabelExhaustion().getName());
                this.getJPanelLarge2().add((Component)this.getJSliderExhaustion(), this.getJSliderExhaustion().getName());
                this.getJPanelLarge2().add((Component)this.getJTextFieldExhaustion(), this.getJTextFieldExhaustion().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelLarge2;
    }

    private JPanel getJPanelOptionButtons() {
        if (this.ivjJPanelOptionButtons == null) {
            try {
                this.ivjJPanelOptionButtons = new JPanel();
                this.ivjJPanelOptionButtons.setName("JPanelOptionButtons");
                this.ivjJPanelOptionButtons.setLayout(new FlowLayout());
                this.getJPanelOptionButtons().add((Component)this.getSaveButton(), this.getSaveButton().getName());
                this.ivjJPanelOptionButtons.add(this.getCloseButton());
                this.getJPanelOptionButtons().add((Component)this.getDefaultButton(), this.getDefaultButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanelOptionButtons;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getStatisticsTextArea());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator1;
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSeparator getJSeparator3() {
        if (this.ivjJSeparator3 == null) {
            try {
                this.ivjJSeparator3 = new JSeparator();
                this.ivjJSeparator3.setName("JSeparator3");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator3;
    }

    private JSeparator getJSeparator4() {
        if (this.ivjJSeparator4 == null) {
            try {
                this.ivjJSeparator4 = new JSeparator();
                this.ivjJSeparator4.setName("JSeparator4");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator4;
    }

    private JSeparator getJSeparator5() {
        if (this.ivjJSeparator5 == null) {
            try {
                this.ivjJSeparator5 = new JSeparator();
                this.ivjJSeparator5.setName("JSeparator5");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator5;
    }

    private JSeparator getJSeparator6() {
        if (this.ivjJSeparator6 == null) {
            try {
                this.ivjJSeparator6 = new JSeparator();
                this.ivjJSeparator6.setName("JSeparator6");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator6;
    }

    private JSlider getJSliderExhaustion() {
        if (this.ivjJSliderExhaustion == null) {
            try {
                this.ivjJSliderExhaustion = new JSlider();
                this.ivjJSliderExhaustion.setName("JSliderExhaustion");
                this.ivjJSliderExhaustion.setPaintLabels(true);
                this.ivjJSliderExhaustion.setToolTipText("Exhaustion Ratio");
                this.ivjJSliderExhaustion.setInverted(false);
                this.ivjJSliderExhaustion.setPaintTicks(true);
                this.ivjJSliderExhaustion.setValue(10);
                this.ivjJSliderExhaustion.setMinimum(0);
                this.ivjJSliderExhaustion.setBounds(3, 27, 357, 54);
                this.ivjJSliderExhaustion.setCursor(new Cursor(0));
                this.ivjJSliderExhaustion.setPaintTrack(true);
                this.ivjJSliderExhaustion.setMajorTickSpacing(10);
                this.ivjJSliderExhaustion.setMaximum(30);
                this.ivjJSliderExhaustion.setMinorTickSpacing(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSliderExhaustion;
    }

    private JSlider getJSliderFrag() {
        if (this.ivjJSliderFrag == null) {
            try {
                this.ivjJSliderFrag = new JSlider();
                this.ivjJSliderFrag.setName("JSliderFrag");
                this.ivjJSliderFrag.setPaintLabels(true);
                this.ivjJSliderFrag.setToolTipText("Fragmentation Ratio");
                this.ivjJSliderFrag.setInverted(false);
                this.ivjJSliderFrag.setPaintTicks(true);
                this.ivjJSliderFrag.setValue(30);
                this.ivjJSliderFrag.setPaintTrack(true);
                this.ivjJSliderFrag.setMajorTickSpacing(10);
                this.ivjJSliderFrag.setBounds(1, 27, 360, 54);
                this.ivjJSliderFrag.setMinorTickSpacing(5);
                this.ivjJSliderFrag.setCursor(new Cursor(0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSliderFrag;
    }

    private JSlider getJSliderLarge() {
        if (this.ivjJSliderLarge == null) {
            try {
                this.ivjJSliderLarge = new JSlider();
                this.ivjJSliderLarge.setName("JSliderLarge");
                this.ivjJSliderLarge.setPaintLabels(true);
                this.ivjJSliderLarge.setToolTipText("Large Object Threshold");
                this.ivjJSliderLarge.setInverted(false);
                this.ivjJSliderLarge.setPaintTicks(true);
                this.ivjJSliderLarge.setValue(10);
                this.ivjJSliderLarge.setBounds(3, 30, 363, 54);
                this.ivjJSliderLarge.setCursor(new Cursor(0));
                this.ivjJSliderLarge.setPaintTrack(true);
                this.ivjJSliderLarge.setMajorTickSpacing(50);
                this.ivjJSliderLarge.setFont(new Font("dialog", 0, 3));
                this.ivjJSliderLarge.setMaximum(500);
                this.ivjJSliderLarge.setMinorTickSpacing(10);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSliderLarge;
    }

    private JSlider getJSliderOverhead() {
        if (this.ivjJSliderOverhead == null) {
            try {
                this.ivjJSliderOverhead = new JSlider();
                this.ivjJSliderOverhead.setName("JSliderOverhead");
                this.ivjJSliderOverhead.setPaintLabels(true);
                this.ivjJSliderOverhead.setToolTipText("Overhead Ratio");
                this.ivjJSliderOverhead.setInverted(false);
                this.ivjJSliderOverhead.setPaintTicks(true);
                this.ivjJSliderOverhead.setValue(30);
                this.ivjJSliderOverhead.setPaintTrack(true);
                this.ivjJSliderOverhead.setMajorTickSpacing(10);
                this.ivjJSliderOverhead.setBounds(4, 25, 359, 54);
                this.ivjJSliderOverhead.setMinorTickSpacing(5);
                this.ivjJSliderOverhead.setCursor(new Cursor(0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSliderOverhead;
    }

    private JTabbedPane getJTabbedPaneOption() {
        if (this.ivjJTabbedPaneOption == null) {
            try {
                this.ivjJTabbedPaneOption = new JTabbedPane();
                this.ivjJTabbedPaneOption.setName("JTabbedPaneOption");
                this.ivjJTabbedPaneOption.insertTab("Basic", null, this.getBasic(), null, 0);
                this.ivjJTabbedPaneOption.insertTab("Advanced", null, this.getJPanelAdvanced(), null, 1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTabbedPaneOption;
    }

    private JTextField getJTextFieldExhaustion() {
        if (this.ivjJTextFieldExhaustion == null) {
            try {
                this.ivjJTextFieldExhaustion = new JTextField();
                this.ivjJTextFieldExhaustion.setName("JTextFieldExhaustion");
                this.ivjJTextFieldExhaustion.setText("10");
                this.ivjJTextFieldExhaustion.setBounds(168, 8, 41, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldExhaustion;
    }

    private JTextField getJTextFieldFontSize() {
        if (this.ivjJTextFieldFontSize == null) {
            try {
                this.ivjJTextFieldFontSize = new JTextField();
                this.ivjJTextFieldFontSize.setName("JTextFieldFontSize");
                this.ivjJTextFieldFontSize.setText("10");
                this.ivjJTextFieldFontSize.setBounds(328, 93, 39, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldFontSize;
    }

    private JTextField getJTextFieldFrag() {
        if (this.ivjJTextFieldFrag == null) {
            try {
                this.ivjJTextFieldFrag = new JTextField();
                this.ivjJTextFieldFrag.setName("JTextFieldFrag");
                this.ivjJTextFieldFrag.setText("30");
                this.ivjJTextFieldFrag.setBounds(170, 6, 41, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldFrag;
    }

    private JTextField getJTextFieldHeight() {
        if (this.ivjJTextFieldHeight == null) {
            try {
                this.ivjJTextFieldHeight = new JTextField();
                this.ivjJTextFieldHeight.setName("JTextFieldHeight");
                this.ivjJTextFieldHeight.setBounds(280, 169, 87, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldHeight;
    }

    private JTextField getJTextFieldLarge() {
        if (this.ivjJTextFieldLarge == null) {
            try {
                this.ivjJTextFieldLarge = new JTextField();
                this.ivjJTextFieldLarge.setName("JTextFieldLarge");
                this.ivjJTextFieldLarge.setText("10");
                this.ivjJTextFieldLarge.setBounds(173, 9, 35, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldLarge;
    }

    private JTextField getJTextFieldMessageLimit() {
        if (this.ivjJTextFieldMessageLimit == null) {
            try {
                this.ivjJTextFieldMessageLimit = new JTextField();
                this.ivjJTextFieldMessageLimit.setName("JTextFieldMessageLimit");
                this.ivjJTextFieldMessageLimit.setText("");
                this.ivjJTextFieldMessageLimit.setBounds(175, 356, 127, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldMessageLimit;
    }

    private JTextField getJTextFieldOverhead() {
        if (this.ivjJTextFieldOverhead == null) {
            try {
                this.ivjJTextFieldOverhead = new JTextField();
                this.ivjJTextFieldOverhead.setName("JTextFieldOverhead");
                this.ivjJTextFieldOverhead.setText("30");
                this.ivjJTextFieldOverhead.setBounds(171, 6, 41, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldOverhead;
    }

    private JTextField getJTextFieldWidth() {
        if (this.ivjJTextFieldWidth == null) {
            try {
                this.ivjJTextFieldWidth = new JTextField();
                this.ivjJTextFieldWidth.setName("JTextFieldWidth");
                this.ivjJTextFieldWidth.setBounds(96, 169, 87, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldWidth;
    }

    private JToggleButton getJToggleButton1() {
        if (this.ivjJToggleButton1 == null) {
            try {
                this.ivjJToggleButton1 = new JToggleButton();
                this.ivjJToggleButton1.setName("JToggleButton1");
                this.ivjJToggleButton1.setToolTipText("Status Bar");
                this.ivjJToggleButton1.setText("");
                this.ivjJToggleButton1.setMaximumSize(new Dimension(27, 27));
                this.ivjJToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/statusbar.gif")));
                this.ivjJToggleButton1.setPreferredSize(new Dimension(27, 27));
                this.ivjJToggleButton1.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToggleButton1;
    }

    private JToggleButton getJToggleButton11() {
        if (this.ivjJToggleButton11 == null) {
            try {
                this.ivjJToggleButton11 = new JToggleButton();
                this.ivjJToggleButton11.setName("JToggleButton11");
                this.ivjJToggleButton11.setToolTipText("Console");
                this.ivjJToggleButton11.setText("");
                this.ivjJToggleButton11.setMaximumSize(new Dimension(27, 27));
                this.ivjJToggleButton11.setIcon(new ImageIcon(this.getClass().getResource("/console_view.gif")));
                this.ivjJToggleButton11.setPreferredSize(new Dimension(27, 27));
                this.ivjJToggleButton11.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToggleButton11;
    }

    private JToolBar getJToolBar1() {
        if (this.ivjJToolBar1 == null) {
            try {
                this.ivjJToolBar1 = new JToolBar();
                this.ivjJToolBar1.setName("JToolBar1");
                this.getJToolBar1().add((Component)this.getJToolBarButton0(), this.getJToolBarButton0().getName());
                this.ivjJToolBar1.add(this.getDefaultToolBarButton());
                this.getJToolBar1().add((Component)this.getJToolBarButton1(), this.getJToolBarButton1().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton2(), this.getJToolBarButton2().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButtonRefresh(), this.getJToolBarButtonRefresh().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButtonExport(), this.getJToolBarButton3().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButton3(), this.getJToolBarButton3().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton4(), this.getJToolBarButton4().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton31(), this.getJToolBarButton31().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButton321(), this.getJToolBarButton321().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton3211(), this.getJToolBarButton3211().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton32(), this.getJToolBarButton32().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton322(), this.getJToolBarButton322().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton3221(), this.getJToolBarButton3221().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButton32211(), this.getJToolBarButton32211().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton32212(), this.getJToolBarButton32212().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton32213(), this.getJToolBarButton32213().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButton32214(), this.getJToolBarButton32214().getName());
                this.getJToolBar1().add((Component)this.getJToolBarButton32215(), this.getJToolBarButton32215().getName());
                this.getJToolBar1().add((Component)this.getJToggleButton1(), this.getJToggleButton1().getName());
                this.getJToolBar1().add((Component)this.getJToggleButton11(), this.getJToggleButton11().getName());
                this.ivjJToolBar1.addSeparator();
                this.getJToolBar1().add((Component)this.getJToolBarButton322151(), this.getJToolBarButton322151().getName());
                this.getJToolBar1().add(this.getUpdateButton());
                this.getJToolBar1().add((Component)this.getJToolBarButton3221511(), this.getJToolBarButton3221511().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBar1;
    }

    private JButton getJToolBarButton1() {
        if (this.ivjJToolBarButton1 == null) {
            try {
                this.ivjJToolBarButton1 = new JButton();
                this.ivjJToolBarButton1.setName("JToolBarButton1");
                this.ivjJToolBarButton1.setToolTipText("Open Solaris/HP-UX verbosegc trace");
                this.ivjJToolBarButton1.setText("");
                this.ivjJToolBarButton1.setHorizontalTextPosition(0);
                this.ivjJToolBarButton1.setVerticalTextPosition(3);
                this.ivjJToolBarButton1.setIcon(new ImageIcon(this.getClass().getResource("/openN.gif")));
                this.ivjJToolBarButton1.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton1;
    }

    private JButton getJToolBarButtonRefresh() {
        if (this.ivjJToolBarButtonRefresh == null) {
            try {
                this.ivjJToolBarButtonRefresh = new JButton();
                this.ivjJToolBarButtonRefresh.setName("JToolBarButtonRefresh");
                this.ivjJToolBarButtonRefresh.setToolTipText("Refresh");
                this.ivjJToolBarButtonRefresh.setText("");
                this.ivjJToolBarButtonRefresh.setHorizontalTextPosition(0);
                this.ivjJToolBarButtonRefresh.setVerticalTextPosition(3);
                this.ivjJToolBarButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/refresh.gif")));
                this.ivjJToolBarButtonRefresh.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButtonRefresh;
    }

    private JButton getJToolBarButton0() {
        if (this.ivjJToolBarButton0 == null) {
            try {
                this.ivjJToolBarButton0 = new JButton();
                this.ivjJToolBarButton0.setName("JToolBarButton0");
                this.ivjJToolBarButton0.setToolTipText("Open Verbosegc trace(AutoDetection)");
                this.ivjJToolBarButton0.setText("");
                this.ivjJToolBarButton0.setHorizontalTextPosition(0);
                this.ivjJToolBarButton0.setVerticalTextPosition(3);
                this.ivjJToolBarButton0.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
                this.ivjJToolBarButton0.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton0;
    }

    private JButton getJToolBarButtonExport() {
        if (this.ivjJToolBarButtonExport == null) {
            try {
                this.ivjJToolBarButtonExport = new JButton();
                this.ivjJToolBarButtonExport.setName("JToolBarButton0");
                this.ivjJToolBarButtonExport.setToolTipText("Export to CSV(Comma Separated Values) file");
                this.ivjJToolBarButtonExport.setText("");
                this.ivjJToolBarButtonExport.setHorizontalTextPosition(0);
                this.ivjJToolBarButtonExport.setVerticalTextPosition(3);
                this.ivjJToolBarButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/csv.gif")));
                this.ivjJToolBarButtonExport.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButtonExport;
    }

    private JButton getJToolBarButton2() {
        if (this.ivjJToolBarButton2 == null) {
            try {
                this.ivjJToolBarButton2 = new JButton();
                this.ivjJToolBarButton2.setName("JToolBarButton2");
                this.ivjJToolBarButton2.setToolTipText("Open HP-UX Xverbosegc trace");
                this.ivjJToolBarButton2.setText("");
                this.ivjJToolBarButton2.setHorizontalTextPosition(0);
                this.ivjJToolBarButton2.setVerticalTextPosition(3);
                this.ivjJToolBarButton2.setIcon(new ImageIcon(this.getClass().getResource("/openX.gif")));
                this.ivjJToolBarButton2.setMargin(new Insets(0, 0, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton2;
    }

    private JButton getJToolBarButton3() {
        if (this.ivjJToolBarButton3 == null) {
            try {
                this.ivjJToolBarButton3 = new JButton();
                this.ivjJToolBarButton3.setName("JToolBarButton3");
                this.ivjJToolBarButton3.setToolTipText("Close Files");
                this.ivjJToolBarButton3.setText("");
                this.ivjJToolBarButton3.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton3.setHorizontalTextPosition(0);
                this.ivjJToolBarButton3.setVerticalTextPosition(3);
                this.ivjJToolBarButton3.setIcon(new ImageIcon(this.getClass().getResource("/remove.gif")));
                this.ivjJToolBarButton3.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton3.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton3.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton3;
    }

    private JButton getJToolBarButton31() {
        if (this.ivjJToolBarButton31 == null) {
            try {
                this.ivjJToolBarButton31 = new JButton();
                this.ivjJToolBarButton31.setName("JToolBarButton31");
                this.ivjJToolBarButton31.setToolTipText("Exit");
                this.ivjJToolBarButton31.setText("");
                this.ivjJToolBarButton31.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton31.setHorizontalTextPosition(0);
                this.ivjJToolBarButton31.setVerticalTextPosition(3);
                this.ivjJToolBarButton31.setIcon(new ImageIcon(this.getClass().getResource("/close.gif")));
                this.ivjJToolBarButton31.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton31.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton31.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton31;
    }

    private JButton getJToolBarButton32() {
        if (this.ivjJToolBarButton32 == null) {
            try {
                this.ivjJToolBarButton32 = new JButton();
                this.ivjJToolBarButton32.setName("JToolBarButton32");
                this.ivjJToolBarButton32.setToolTipText("Graph View All");
                this.ivjJToolBarButton32.setText("");
                this.ivjJToolBarButton32.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32.setVerticalTextPosition(3);
                this.ivjJToolBarButton32.setIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
                this.ivjJToolBarButton32.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32;
    }

    private JButton getJToolBarButton321() {
        if (this.ivjJToolBarButton321 == null) {
            try {
                this.ivjJToolBarButton321 = new JButton();
                this.ivjJToolBarButton321.setName("JToolBarButton321");
                this.ivjJToolBarButton321.setToolTipText("GC View All");
                this.ivjJToolBarButton321.setText("");
                this.ivjJToolBarButton321.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton321.setHorizontalTextPosition(0);
                this.ivjJToolBarButton321.setVerticalTextPosition(3);
                this.ivjJToolBarButton321.setIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
                this.ivjJToolBarButton321.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton321.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton321.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton321;
    }

    private JButton getJToolBarButton3211() {
        if (this.ivjJToolBarButton3211 == null) {
            try {
                this.ivjJToolBarButton3211 = new JButton();
                this.ivjJToolBarButton3211.setName("JToolBarButton3211");
                this.ivjJToolBarButton3211.setToolTipText("GC View Part");
                this.ivjJToolBarButton3211.setText("");
                this.ivjJToolBarButton3211.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton3211.setHorizontalTextPosition(0);
                this.ivjJToolBarButton3211.setVerticalTextPosition(3);
                this.ivjJToolBarButton3211.setIcon(new ImageIcon(this.getClass().getResource("/RecordSfl.gif")));
                this.ivjJToolBarButton3211.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton3211.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton3211.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton3211;
    }

    private JButton getJToolBarButton322() {
        if (this.ivjJToolBarButton322 == null) {
            try {
                this.ivjJToolBarButton322 = new JButton();
                this.ivjJToolBarButton322.setName("JToolBarButton322");
                this.ivjJToolBarButton322.setToolTipText("Graph View Part");
                this.ivjJToolBarButton322.setText("");
                this.ivjJToolBarButton322.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton322.setHorizontalTextPosition(0);
                this.ivjJToolBarButton322.setVerticalTextPosition(3);
                this.ivjJToolBarButton322.setIcon(new ImageIcon(this.getClass().getResource("/chartPart.gif")));
                this.ivjJToolBarButton322.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton322.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton322.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton322;
    }

    private JButton getJToolBarButton3221() {
        if (this.ivjJToolBarButton3221 == null) {
            try {
                this.ivjJToolBarButton3221 = new JButton();
                this.ivjJToolBarButton3221.setName("JToolBarButton3221");
                this.ivjJToolBarButton3221.setToolTipText("Statistics");
                this.ivjJToolBarButton3221.setText("");
                this.ivjJToolBarButton3221.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton3221.setHorizontalTextPosition(0);
                this.ivjJToolBarButton3221.setVerticalTextPosition(3);
                this.ivjJToolBarButton3221.setIcon(new ImageIcon(this.getClass().getResource("/statistic.gif")));
                this.ivjJToolBarButton3221.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton3221.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton3221.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton3221;
    }

    private JButton getJToolBarButton32211() {
        if (this.ivjJToolBarButton32211 == null) {
            try {
                this.ivjJToolBarButton32211 = new JButton();
                this.ivjJToolBarButton32211.setName("JToolBarButton32211");
                this.ivjJToolBarButton32211.setToolTipText("Usage Summary");
                this.ivjJToolBarButton32211.setText("");
                this.ivjJToolBarButton32211.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32211.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32211.setVerticalTextPosition(3);
                this.ivjJToolBarButton32211.setIcon(new ImageIcon(this.getClass().getResource("/displayjoblog.gif")));
                this.ivjJToolBarButton32211.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32211.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32211.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32211;
    }

    private JButton getJToolBarButton32212() {
        if (this.ivjJToolBarButton32212 == null) {
            try {
                this.ivjJToolBarButton32212 = new JButton();
                this.ivjJToolBarButton32212.setName("JToolBarButton32212");
                this.ivjJToolBarButton32212.setToolTipText("Duration Summary");
                this.ivjJToolBarButton32212.setText("");
                this.ivjJToolBarButton32212.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32212.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32212.setVerticalTextPosition(3);
                this.ivjJToolBarButton32212.setIcon(new ImageIcon(this.getClass().getResource("/working_duration_template.gif")));
                this.ivjJToolBarButton32212.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32212.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32212.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32212;
    }

    private JButton getJToolBarButton32213() {
        if (this.ivjJToolBarButton32213 == null) {
            try {
                this.ivjJToolBarButton32213 = new JButton();
                this.ivjJToolBarButton32213.setName("JToolBarButton32213");
                this.ivjJToolBarButton32213.setToolTipText("AF Summary");
                this.ivjJToolBarButton32213.setText("");
                this.ivjJToolBarButton32213.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32213.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32213.setVerticalTextPosition(3);
                this.ivjJToolBarButton32213.setIcon(new ImageIcon(this.getClass().getResource("/failed_ovr.gif")));
                this.ivjJToolBarButton32213.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32213.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32213.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32213;
    }

    private JButton getJToolBarButton32214() {
        if (this.ivjJToolBarButton32214 == null) {
            try {
                this.ivjJToolBarButton32214 = new JButton();
                this.ivjJToolBarButton32214.setName("JToolBarButton32214");
                this.ivjJToolBarButton32214.setToolTipText("Option");
                this.ivjJToolBarButton32214.setText("");
                this.ivjJToolBarButton32214.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32214.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32214.setVerticalTextPosition(3);
                this.ivjJToolBarButton32214.setIcon(new ImageIcon(this.getClass().getResource("/options.gif")));
                this.ivjJToolBarButton32214.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32214.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32214.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32214;
    }

    private JButton getJToolBarButton32215() {
        if (this.ivjJToolBarButton32215 == null) {
            try {
                this.ivjJToolBarButton32215 = new JButton();
                this.ivjJToolBarButton32215.setName("JToolBarButton32215");
                this.ivjJToolBarButton32215.setToolTipText("Clear Console");
                this.ivjJToolBarButton32215.setText("");
                this.ivjJToolBarButton32215.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton32215.setHorizontalTextPosition(0);
                this.ivjJToolBarButton32215.setVerticalTextPosition(3);
                this.ivjJToolBarButton32215.setIcon(new ImageIcon(this.getClass().getResource("/clear.gif")));
                this.ivjJToolBarButton32215.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton32215.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton32215.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton32215;
    }

    private JButton getJToolBarButton322151() {
        if (this.ivjJToolBarButton322151 == null) {
            try {
                this.ivjJToolBarButton322151 = new JButton();
                this.ivjJToolBarButton322151.setName("JToolBarButton322151");
                this.ivjJToolBarButton322151.setToolTipText("Help");
                this.ivjJToolBarButton322151.setText("");
                this.ivjJToolBarButton322151.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton322151.setHorizontalTextPosition(0);
                this.ivjJToolBarButton322151.setVerticalTextPosition(3);
                this.ivjJToolBarButton322151.setIcon(new ImageIcon(this.getClass().getResource("/help.gif")));
                this.ivjJToolBarButton322151.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton322151.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton322151.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton322151;
    }

    private JButton getJToolBarButton3221511() {
        if (this.ivjJToolBarButton3221511 == null) {
            try {
                this.ivjJToolBarButton3221511 = new JButton();
                this.ivjJToolBarButton3221511.setName("JToolBarButton3221511");
                this.ivjJToolBarButton3221511.setToolTipText("About");
                this.ivjJToolBarButton3221511.setText("");
                this.ivjJToolBarButton3221511.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton3221511.setHorizontalTextPosition(0);
                this.ivjJToolBarButton3221511.setVerticalTextPosition(3);
                this.ivjJToolBarButton3221511.setIcon(new ImageIcon(this.getClass().getResource("/about.gif")));
                this.ivjJToolBarButton3221511.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton3221511.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton3221511.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton3221511;
    }

    private JButton getJToolBarButton4() {
        if (this.ivjJToolBarButton4 == null) {
            try {
                this.ivjJToolBarButton4 = new JButton();
                this.ivjJToolBarButton4.setName("JToolBarButton4");
                this.ivjJToolBarButton4.setToolTipText("Close All Files");
                this.ivjJToolBarButton4.setText("");
                this.ivjJToolBarButton4.setMaximumSize(new Dimension(27, 27));
                this.ivjJToolBarButton4.setHorizontalTextPosition(0);
                this.ivjJToolBarButton4.setVerticalTextPosition(3);
                this.ivjJToolBarButton4.setIcon(new ImageIcon(this.getClass().getResource("/remove_all.gif")));
                this.ivjJToolBarButton4.setPreferredSize(new Dimension(27, 27));
                this.ivjJToolBarButton4.setMargin(new Insets(0, 0, 0, 0));
                this.ivjJToolBarButton4.setMinimumSize(new Dimension(27, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJToolBarButton4;
    }

    private JPanel getLookAndFeelPanel() {
        if (this.ivjLookAndFeelPanel == null) {
            try {
                this.ivjLookAndFeelPanel = new JPanel();
                this.ivjLookAndFeelPanel.setName("LookAndFeelPanel");
                this.ivjLookAndFeelPanel.setLayout(null);
                this.ivjLookAndFeelPanel.setBounds(27, 459, 321, 65);
                this.getLookAndFeelPanel().add((Component)this.getMetalRadioButton(), this.getMetalRadioButton().getName());
                this.getLookAndFeelPanel().add((Component)this.getMotifRadioButton(), this.getMotifRadioButton().getName());
                this.getLookAndFeelPanel().add((Component)this.getSystemRadioButton(), this.getSystemRadioButton().getName());
                Border raisedetched = BorderFactory.createEtchedBorder(0);
                this.ivjLookAndFeelPanel.setBorder(BorderFactory.createTitledBorder(raisedetched, " Look and Feel "));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLookAndFeelPanel;
    }

    private JRadioButton getMetalRadioButton() {
        if (this.ivjMetalRadioButton == null) {
            try {
                this.ivjMetalRadioButton = new JRadioButton();
                this.ivjMetalRadioButton.setName("MetalRadioButton");
                this.ivjMetalRadioButton.setMnemonic('i');
                this.ivjMetalRadioButton.setText("Nimbus");
                this.ivjMetalRadioButton.setBounds(35, 30, 70, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMetalRadioButton;
    }

    private JRadioButton getMotifRadioButton() {
        if (this.ivjMotifRadioButton == null) {
            try {
                this.ivjMotifRadioButton = new JRadioButton();
                this.ivjMotifRadioButton.setName("MotifRadioButton");
                this.ivjMotifRadioButton.setMnemonic('e');
                this.ivjMotifRadioButton.setText("Metal");
                this.ivjMotifRadioButton.setBounds(127, 30, 70, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMotifRadioButton;
    }

    public int getNGC(int s, int e) {
        return e - s + 1;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.ivjOpenMenuItem == null) {
            try {
                this.ivjOpenMenuItem = new JMenuItem();
                this.ivjOpenMenuItem.setName("OpenMenuItem");
                this.ivjOpenMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/openI.gif")));
                this.ivjOpenMenuItem.setMnemonic('I');
                this.ivjOpenMenuItem.setText("Open verbosegc Files(IBM SDK)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOpenMenuItem;
    }

    private JMenuItem getAutoOpenMenuItem() {
        if (this.ivjAutoOpenMenuItem == null) {
            try {
                this.ivjAutoOpenMenuItem = new JMenuItem();
                this.ivjAutoOpenMenuItem.setName("AutoOpenMenuItem");
                this.ivjAutoOpenMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
                this.ivjAutoOpenMenuItem.setMnemonic('O');
                this.ivjAutoOpenMenuItem.setText("Open verbosegc Files(AutoDetection)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAutoOpenMenuItem;
    }

    private JMenuItem getOpenMenuItemSolaris() {
        if (this.ivjOpenMenuItemSolaris == null) {
            try {
                this.ivjOpenMenuItemSolaris = new JMenuItem();
                this.ivjOpenMenuItemSolaris.setName("OpenMenuItemSolaris");
                this.ivjOpenMenuItemSolaris.setIcon(new ImageIcon(this.getClass().getResource("/openN.gif")));
                this.ivjOpenMenuItemSolaris.setMnemonic('S');
                this.ivjOpenMenuItemSolaris.setText("Open verbosegc Files(Solaris/HP-UX)");
                this.ivjOpenMenuItemSolaris.setActionCommand("Open Files(Solaris/HP-UX SDK 1.4.2/5.0)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOpenMenuItemSolaris;
    }

    private JMenuItem getOpenMenuItemXverbosegc() {
        if (this.ivjOpenMenuItemXverbosegc == null) {
            try {
                this.ivjOpenMenuItemXverbosegc = new JMenuItem();
                this.ivjOpenMenuItemXverbosegc.setName("OpenMenuItemXverbosegc");
                this.ivjOpenMenuItemXverbosegc.setIcon(new ImageIcon(this.getClass().getResource("/openX.gif")));
                this.ivjOpenMenuItemXverbosegc.setMnemonic('H');
                this.ivjOpenMenuItemXverbosegc.setText("Open Xverbosegc Files(HP-UX)");
                this.ivjOpenMenuItemXverbosegc.setActionCommand("Open Xverbosegc Files(HP-UX SDK 1.4.2/5.0)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOpenMenuItemXverbosegc;
    }

    private JMenuItem getExportMenu() {
        if (this.ivjExportMenu == null) {
            try {
                this.ivjExportMenu = new JMenuItem();
                this.ivjExportMenu.setName("ExportMenuItem");
                this.ivjExportMenu.setIcon(new ImageIcon(this.getClass().getResource("/csv.gif")));
                this.ivjExportMenu.setMnemonic('C');
                this.ivjExportMenu.setText("Export to CSV(Comma Separated Values) file");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExportMenu;
    }

    private JDialog getOptionDialog() {
        if (this.ivjOptionDialog == null) {
            try {
                this.ivjOptionDialog = new JDialog();
                this.ivjOptionDialog.setName("OptionDialog");
                this.ivjOptionDialog.setDefaultCloseOperation(2);
                this.ivjOptionDialog.setResizable(false);
                this.ivjOptionDialog.setBounds(1491, 12, 383, 650);
                this.ivjOptionDialog.setModal(true);
                this.ivjOptionDialog.setTitle("Option");
                this.getOptionDialog().setContentPane(this.getJDialogContentPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOptionDialog;
    }

    private JMenuItem getOptionMenuItem() {
        if (this.ivjOptionMenuItem == null) {
            try {
                this.ivjOptionMenuItem = new JMenuItem();
                this.ivjOptionMenuItem.setName("OptionMenuItem");
                this.ivjOptionMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/options.gif")));
                this.ivjOptionMenuItem.setMnemonic('O');
                this.ivjOptionMenuItem.setText("Option");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOptionMenuItem;
    }

    private JButton getPartCancelButton() {
        if (this.ivjPartCancelButton == null) {
            try {
                this.ivjPartCancelButton = new JButton();
                this.ivjPartCancelButton.setName("PartCancelButton");
                this.ivjPartCancelButton.setMnemonic('C');
                this.ivjPartCancelButton.setText("Cancel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPartCancelButton;
    }

    private JDialog getPartDialog() {
        if (this.ivjPartDialog == null) {
            try {
                this.ivjPartDialog = new JDialog();
                this.ivjPartDialog.setName("PartDialog");
                this.ivjPartDialog.setDefaultCloseOperation(2);
                this.ivjPartDialog.setBounds(383, 563, 395, 130);
                this.ivjPartDialog.setModal(true);
                this.ivjPartDialog.setTitle("Retrieve Partial Trace");
                this.getPartDialog().setContentPane(this.getJDialogContentPane1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPartDialog;
    }

    private JList getPartList() {
        if (this.ivjPartList == null) {
            try {
                this.ivjPartList = new JList();
                this.ivjPartList.setName("PartList");
                this.ivjPartList.setBounds(0, 0, 280, 129);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPartList;
    }

    private JScrollPane getPartListScrollPane() {
        if (this.ivjPartListScrollPane == null) {
            try {
                this.ivjPartListScrollPane = new JScrollPane();
                this.ivjPartListScrollPane.setName("PartListScrollPane");
                this.getPartListScrollPane().setViewportView(this.getPartList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPartListScrollPane;
    }

    private JButton getPartOpenButton() {
        if (this.ivjPartOpenButton == null) {
            try {
                this.ivjPartOpenButton = new JButton();
                this.ivjPartOpenButton.setName("PartOpenButton");
                this.ivjPartOpenButton.setMnemonic('O');
                this.ivjPartOpenButton.setText("Open");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPartOpenButton;
    }

    private JCheckBox getPointsCheckBox() {
        if (this.ivjPointsCheckBox == null) {
            try {
                this.ivjPointsCheckBox = new JCheckBox();
                this.ivjPointsCheckBox.setName("PointsCheckBox");
                this.ivjPointsCheckBox.setMnemonic('N');
                this.ivjPointsCheckBox.setText("Mark Non-terminals");
                this.ivjPointsCheckBox.setBounds(182, 241, 170, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPointsCheckBox;
    }

    private JButton getSaveButton() {
        if (this.ivjSaveButton == null) {
            try {
                this.ivjSaveButton = new JButton();
                this.ivjSaveButton.setName("SaveButton");
                this.ivjSaveButton.setMnemonic('S');
                this.ivjSaveButton.setText("Save");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSaveButton;
    }

    private JCheckBox getSaveCheckBox() {
        if (this.ivjSaveCheckBox == null) {
            try {
                this.ivjSaveCheckBox = new JCheckBox();
                this.ivjSaveCheckBox.setName("SaveCheckBox");
                this.ivjSaveCheckBox.setSelected(true);
                this.ivjSaveCheckBox.setMnemonic('v');
                this.ivjSaveCheckBox.setText("Save option");
                this.ivjSaveCheckBox.setBounds(182, 206, 150, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSaveCheckBox;
    }

    public int getScavengerCollection(int s, int e) {
        if (this.giPart.j9collection == null) {
            return 0;
        }
        int counter = 0;
        int i = s;
        while (i <= e) {
            if (this.giPart.j9collection[i] == 2) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public long getSince(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            counter += this.giPart.since[i];
            ++i;
        }
        return counter;
    }

    public long getSinceFull(int s, int e) {
        long counter = 0L;
        int i = s;
        while (i <= e) {
            if (this.giPart.isFullGC[i]) {
                counter += this.giPart.since[i];
            }
            ++i;
        }
        return counter;
    }

    private JTextField getStartTime() {
        if (this.ivjStartTime == null) {
            try {
                this.ivjStartTime = new JTextField();
                this.ivjStartTime.setName("StartTime");
                this.ivjStartTime.setBounds(232, 23, 165, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStartTime;
    }

    private JButton getStatisticsButton() {
        if (this.ivjStatisticsButton == null) {
            try {
                this.ivjStatisticsButton = new JButton();
                this.ivjStatisticsButton.setName("StatisticsButton");
                this.ivjStatisticsButton.setMnemonic('O');
                this.ivjStatisticsButton.setText("Open");
                this.ivjStatisticsButton.setBounds(418, 21, 65, 25);
                this.ivjStatisticsButton.setActionCommand("Statistics");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsButton;
    }

    private JButton getStatisticsCloseButton() {
        if (this.ivjStatisticsCloseButton == null) {
            try {
                this.ivjStatisticsCloseButton = new JButton();
                this.ivjStatisticsCloseButton.setName("StatisticsCloseButton");
                this.ivjStatisticsCloseButton.setMnemonic('C');
                this.ivjStatisticsCloseButton.setText("Close");
                this.ivjStatisticsCloseButton.setBounds(504, 21, 73, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsCloseButton;
    }

    private JDialog getStatisticsDialog() {
        if (this.ivjStatisticsDialog == null) {
            try {
                this.ivjStatisticsDialog = new JDialog();
                this.ivjStatisticsDialog.setName("StatisticsDialog");
                this.ivjStatisticsDialog.setDefaultCloseOperation(2);
                this.ivjStatisticsDialog.setBounds(809, 207, 623, 673);
                this.ivjStatisticsDialog.setTitle("Statistics");
                this.getStatisticsDialog().setContentPane(this.getJDialogContentPane2());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsDialog;
    }

    private JMenuItem getStatisticsMenuItem() {
        if (this.ivjStatisticsMenuItem == null) {
            try {
                this.ivjStatisticsMenuItem = new JMenuItem();
                this.ivjStatisticsMenuItem.setName("StatisticsMenuItem");
                this.ivjStatisticsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/statistic.gif")));
                this.ivjStatisticsMenuItem.setMnemonic('S');
                this.ivjStatisticsMenuItem.setText("Statistics");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsMenuItem;
    }

    private JMenuItem getStatisticsMenuItem1() {
        if (this.ivjStatisticsMenuItem1 == null) {
            try {
                this.ivjStatisticsMenuItem1 = new JMenuItem();
                this.ivjStatisticsMenuItem1.setName("StatisticsMenuItem1");
                this.ivjStatisticsMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/statistic.gif")));
                this.ivjStatisticsMenuItem1.setMnemonic('S');
                this.ivjStatisticsMenuItem1.setText("Statistics");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsMenuItem1;
    }

    private JPanel getStatisticsPanel() {
        if (this.ivjStatisticsPanel == null) {
            try {
                this.ivjStatisticsPanel = new JPanel();
                this.ivjStatisticsPanel.setName("StatisticsPanel");
                this.ivjStatisticsPanel.setLayout(null);
                this.getStatisticsPanel().add((Component)this.getJLabel31(), this.getJLabel31().getName());
                this.getStatisticsPanel().add((Component)this.getStartTime(), this.getStartTime().getName());
                this.getStatisticsPanel().add((Component)this.getJLabel32(), this.getJLabel32().getName());
                this.getStatisticsPanel().add((Component)this.getEndTime(), this.getEndTime().getName());
                this.getStatisticsPanel().add((Component)this.getStatisticsButton(), this.getStatisticsButton().getName());
                this.getStatisticsPanel().add((Component)this.getStatisticsCloseButton(), this.getStatisticsCloseButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsPanel;
    }

    private JSplitPane getStatisticsSplitPane() {
        if (this.ivjStatisticsSplitPane == null) {
            try {
                this.ivjStatisticsSplitPane = new JSplitPane(0);
                this.ivjStatisticsSplitPane.setName("StatisticsSplitPane");
                this.ivjStatisticsSplitPane.setDividerLocation(100);
                this.getStatisticsSplitPane().add((Component)this.getStatisticsPanel(), "top");
                this.getStatisticsSplitPane().add((Component)this.getJScrollPane1(), "bottom");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsSplitPane;
    }

    private JEditorPane getStatisticsTextArea() {
        if (this.ivjStatisticsTextArea == null) {
            try {
                this.ivjStatisticsTextArea = new JEditorPane();
                this.ivjStatisticsTextArea.setName("StatisticsTextArea");
                this.ivjStatisticsTextArea.setDocument(new HTMLDocument());
                this.ivjStatisticsTextArea.setBounds(0, 0, 334, 162);
                this.ivjStatisticsTextArea.setEditable(false);
                this.ivjStatisticsTextArea.setContentType("text/html");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatisticsTextArea;
    }

    private JCheckBoxMenuItem getStatusbarCheckBoxMenuItem() {
        if (this.ivjStatusbarCheckBoxMenuItem == null) {
            try {
                this.ivjStatusbarCheckBoxMenuItem = new JCheckBoxMenuItem();
                this.ivjStatusbarCheckBoxMenuItem.setName("StatusbarCheckBoxMenuItem");
                this.ivjStatusbarCheckBoxMenuItem.setSelected(true);
                this.ivjStatusbarCheckBoxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/statusbar.gif")));
                this.ivjStatusbarCheckBoxMenuItem.setMnemonic('S');
                this.ivjStatusbarCheckBoxMenuItem.setText("Statusbar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusbarCheckBoxMenuItem;
    }

    private JPanel getStatusBarPane() {
        if (this.ivjStatusBarPane == null) {
            try {
                this.ivjStatusBarPane = new JPanel();
                this.ivjStatusBarPane.setName("StatusBarPane");
                this.ivjStatusBarPane.setLayout(new BorderLayout());
                this.getStatusBarPane().add((Component)this.getStatusMsg1(), "West");
                this.getStatusBarPane().add((Component)this.getStatusMsg2(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusBarPane;
    }

    private JLabel getStatusMsg1() {
        if (this.ivjStatusMsg1 == null) {
            try {
                this.ivjStatusMsg1 = new JLabel();
                this.ivjStatusMsg1.setName("StatusMsg1");
                this.ivjStatusMsg1.setBorder(new EtchedBorder());
                this.ivjStatusMsg1.setText("PMAT");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusMsg1;
    }

    private JLabel getStatusMsg2() {
        if (this.ivjStatusMsg2 == null) {
            try {
                this.ivjStatusMsg2 = new JLabel();
                this.ivjStatusMsg2.setName("StatusMsg2");
                this.ivjStatusMsg2.setBorder(new EtchedBorder());
                this.ivjStatusMsg2.setText("Status");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusMsg2;
    }

    private JRadioButton getSystemRadioButton() {
        if (this.ivjSystemRadioButton == null) {
            try {
                this.ivjSystemRadioButton = new JRadioButton();
                this.ivjSystemRadioButton.setName("SystemRadioButton");
                this.ivjSystemRadioButton.setMnemonic('y');
                this.ivjSystemRadioButton.setText("System");
                this.ivjSystemRadioButton.setBounds(217, 30, 69, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSystemRadioButton;
    }

    private JCheckBox getTerminalCheckBox() {
        if (this.ivjTerminalCheckBox == null) {
            try {
                this.ivjTerminalCheckBox = new JCheckBox();
                this.ivjTerminalCheckBox.setName("TerminalCheckBox");
                this.ivjTerminalCheckBox.setSelected(true);
                this.ivjTerminalCheckBox.setMnemonic('M');
                this.ivjTerminalCheckBox.setText("Mark Terminals");
                this.ivjTerminalCheckBox.setBounds(14, 241, 115, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTerminalCheckBox;
    }

    private JMenuItem getUsageMenuItem() {
        if (this.ivjUsageMenuItem == null) {
            try {
                this.ivjUsageMenuItem = new JMenuItem();
                this.ivjUsageMenuItem.setName("UsageMenuItem");
                this.ivjUsageMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/working_duration_template.gif")));
                this.ivjUsageMenuItem.setMnemonic('D');
                this.ivjUsageMenuItem.setText("Duration Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUsageMenuItem;
    }

    private JMenuItem getUsageMenuItem1() {
        if (this.ivjUsageMenuItem1 == null) {
            try {
                this.ivjUsageMenuItem1 = new JMenuItem();
                this.ivjUsageMenuItem1.setName("UsageMenuItem1");
                this.ivjUsageMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/working_duration_template.gif")));
                this.ivjUsageMenuItem1.setMnemonic('D');
                this.ivjUsageMenuItem1.setText("Duration Summary");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUsageMenuItem1;
    }

    private JCheckBox getVerboseCheckBox() {
        if (this.ivjVerboseCheckBox == null) {
            try {
                this.ivjVerboseCheckBox = new JCheckBox();
                this.ivjVerboseCheckBox.setName("VerboseCheckBox");
                this.ivjVerboseCheckBox.setSelected(true);
                this.ivjVerboseCheckBox.setMnemonic('V');
                this.ivjVerboseCheckBox.setText("Verbose Mode");
                this.ivjVerboseCheckBox.setBounds(14, 206, 116, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjVerboseCheckBox;
    }

    private JMenu getViewMenu() {
        if (this.ivjViewMenu == null) {
            try {
                this.ivjViewMenu = new JMenu();
                this.ivjViewMenu.setName("ViewMenu");
                this.ivjViewMenu.setMnemonic('V');
                this.ivjViewMenu.setText("View");
                this.ivjViewMenu.add(this.getOptionMenuItem());
                this.ivjViewMenu.add(this.getClearMenuItem());
                this.ivjViewMenu.add(this.getJSeparator2());
                this.ivjViewMenu.add(this.getStatusbarCheckBoxMenuItem());
                this.ivjViewMenu.add(this.getConsoleCheckBoxMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewMenu;
    }

    private JLabel getWarningLabel() {
        if (this.ivjWarningLabel == null) {
            try {
                this.ivjWarningLabel = new JLabel();
                this.ivjWarningLabel.setName("WarningLabel");
                this.ivjWarningLabel.setAutoscrolls(false);
                this.ivjWarningLabel.setText("WARNING!! Please do not modify these options");
                this.ivjWarningLabel.setBounds(13, 9, 346, 20);
                this.ivjWarningLabel.setForeground(Color.red);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWarningLabel;
    }

    private JLabel getWarningLabel1() {
        if (this.ivjWarningLabel1 == null) {
            try {
                this.ivjWarningLabel1 = new JLabel();
                this.ivjWarningLabel1.setName("WarningLabel1");
                this.ivjWarningLabel1.setAutoscrolls(false);
                this.ivjWarningLabel1.setText("unless you are familiar with them.");
                this.ivjWarningLabel1.setBounds(13, 38, 346, 18);
                this.ivjWarningLabel1.setForeground(Color.red);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWarningLabel1;
    }

    private JPanel getWarningPanel() {
        if (this.ivjWarningPanel == null) {
            try {
                this.ivjWarningPanel = new JPanel();
                this.ivjWarningPanel.setName("WarningPanel");
                this.ivjWarningPanel.setBorder(new EtchedBorder());
                this.ivjWarningPanel.setLayout(null);
                this.ivjWarningPanel.setBounds(5, 384, 368, 65);
                this.getWarningPanel().add((Component)this.getWarningLabel(), this.getWarningLabel().getName());
                this.getWarningPanel().add((Component)this.getWarningLabel1(), this.getWarningLabel1().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWarningPanel;
    }

    public void refresh() {
        int[] selectedRow = this.fileTable.getSelectedRows();
        if (selectedRow.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] dump = new GCInfo[selectedRow.length];
        File[] f = new File[selectedRow.length];
        int i = 0;
        while (i < selectedRow.length) {
            dump[i] = (GCInfo)this.ti.gcList.get(selectedRow[i]);
            f[i] = dump[i].file;
            ++i;
        }
        i = 0;
        while (i < dump.length) {
            this.ti.gcList.remove(dump[i]);
            ++i;
        }
        this.fileModel.fireTableDataChanged();
        this.fileTable.updateUI();
        this.getDetailTextPane().setText("<html></html>");
        Dimension dialogSize = this.jp.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        this.jp.show();
        int fileType = this.getGCLogType(f[0]);
        if (fileType <= 2) {
            this.task = new FileTask(this, f, this.jp);
            this.task.go();
            this.timer.start();
            return;
        }
        this.task = new FileTask(this, f, this.jp, fileType - 2);
        this.task.go();
        this.timer.start();
    }

    public void graph_ViewMenuItem_ActionPerformed() {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] gi = new GCInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            gi[i] = (GCInfo)this.ti.gcList.get(selectedRows[i]);
            ++i;
        }
        String selectedFiles = "";
        int i2 = 0;
        while (i2 < selectedRows.length) {
            selectedFiles = String.valueOf(selectedFiles) + this.fileTable.getValueAt(selectedRows[i2], 0) + " ";
            ++i2;
        }
        i2 = 0;
        while (i2 < gi.length) {
            HeapFrame hf = new HeapFrame(String.valueOf(gi[i2].file.getName()) + " Chart View", gi[i2]);
            hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
            hf.fileName = gi[i2].file.getName();
            ChartPanel cp = new ChartPanel(gi[i2], this, 0, gi[i2].free.length - 1);
            cp.heapFrame = hf;
            this.controlPanel = new ControlPanel(cp, gi[i2]);
            JSplitPane splitPane = new JSplitPane(1, cp, this.controlPanel);
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(1.0);
            hf.getContentPane().add(splitPane);
            hf.setMinimumSize(new Dimension(350, 550));
            hf.setSize(new Dimension(900, 650));
            this.getJDesktopPane1().add(hf);
            this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
            try {
                hf.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            splitPane.setVisible(true);
            splitPane.setDividerLocation(0.8);
            ++i2;
        }
    }

    public void handleException(Throwable exception) {
        exception.printStackTrace(System.out);
    }

    public void help_TopicsMenuItem_ActionPerformed(ActionEvent actionEvent) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        URL helpURL = this.getClass().getResource("/readme.html");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Couldn't read file: readme.html", "Information", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Couldn't find file: readme.html", "Information", 1);
            return;
        }
        HeapFrame hf = new HeapFrame("Help");
        hf.JScrollPaneSetViewportView(editorPane);
        this.getJDesktopPane1().add(hf);
        this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
        try {
            hf.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void initConnections() throws Exception {
        this.getUpdateMenuItem().addMouseListener(this.ivjEventHandler);
        this.getUpdateMenuItem().addActionListener(this.ivjEventHandler);
        this.getStatusbarCheckBoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getAbout_BoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getOpenMenuItem().addActionListener(this.ivjEventHandler);
        this.getAutoOpenMenuItem().addActionListener(this.ivjEventHandler);
        this.getConsoleCheckBoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getGC_ListMenuItem().addActionListener(this.ivjEventHandler);
        this.getGraph_ViewMenuItem().addActionListener(this.ivjEventHandler);
        this.getOptionMenuItem().addActionListener(this.ivjEventHandler);
        this.getSaveButton().addActionListener(this.ivjEventHandler);
        this.getUsageMenuItem().addActionListener(this.ivjEventHandler);
        this.getDurationMenuItem().addActionListener(this.ivjEventHandler);
        this.getAFMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearMenuItem().addActionListener(this.ivjEventHandler);
        this.getColorComboBox().addActionListener(this.ivjEventHandler);
        this.getBrowseButton().addActionListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getExitMenuItem().addActionListener(this.ivjEventHandler);
        this.getOpenMenuItem().addMouseListener(this.ivjEventHandler);
        this.getAutoOpenMenuItem().addMouseListener(this.ivjEventHandler);
        this.getExitMenuItem().addMouseListener(this.ivjEventHandler);
        this.getGC_ListMenuItem().addMouseListener(this.ivjEventHandler);
        this.getGraph_ViewMenuItem().addMouseListener(this.ivjEventHandler);
        this.getDurationMenuItem().addMouseListener(this.ivjEventHandler);
        this.getUsageMenuItem().addMouseListener(this.ivjEventHandler);
        this.getAFMenuItem().addMouseListener(this.ivjEventHandler);
        this.getRefreshMenuItem().addMouseListener(this.ivjEventHandler);
        this.getRefreshMenuItem().addActionListener(this.ivjEventHandler);
        this.getRefreshMenuItem1().addMouseListener(this.ivjEventHandler);
        this.getRefreshMenuItem1().addActionListener(this.ivjEventHandler);
        this.getOptionMenuItem().addMouseListener(this.ivjEventHandler);
        this.getClearMenuItem().addMouseListener(this.ivjEventHandler);
        this.getStatusbarCheckBoxMenuItem().addMouseListener(this.ivjEventHandler);
        this.getConsoleCheckBoxMenuItem().addMouseListener(this.ivjEventHandler);
        this.getHelp_TopicsMenuItem().addMouseListener(this.ivjEventHandler);
        this.getAbout_BoxMenuItem().addMouseListener(this.ivjEventHandler);
        this.getHelp_TopicsMenuItem().addActionListener(this.ivjEventHandler);
        this.getGC_ListMenuItem1().addActionListener(this.ivjEventHandler);
        this.getGraph_ViewMenuItem1().addActionListener(this.ivjEventHandler);
        this.getUsageMenuItem1().addActionListener(this.ivjEventHandler);
        this.getDurationMenuItem1().addActionListener(this.ivjEventHandler);
        this.getAFMenuItem1().addActionListener(this.ivjEventHandler);
        this.getCloseMenuItem().addActionListener(this.ivjEventHandler);
        this.getCloseAllMenuItem().addActionListener(this.ivjEventHandler);
        this.getCloseMenuItem1().addActionListener(this.ivjEventHandler);
        this.getCloseAllMenuItem1().addActionListener(this.ivjEventHandler);
        this.getGCViewPartMenuItem().addActionListener(this.ivjEventHandler);
        this.getPartCancelButton().addActionListener(this.ivjEventHandler);
        this.getPartOpenButton().addActionListener(this.ivjEventHandler);
        this.getGCViewPartMenuItem1().addActionListener(this.ivjEventHandler);
        this.getGraph_ViewMenuItem11().addActionListener(this.ivjEventHandler);
        this.getGraph_ViewMenuItem2().addActionListener(this.ivjEventHandler);
        this.getCloseButton().addActionListener(this.ivjEventHandler);
        this.getJSliderFrag().addChangeListener(this.ivjEventHandler);
        this.getJTextFieldFrag().addKeyListener(this.ivjEventHandler);
        this.getJSliderLarge().addChangeListener(this.ivjEventHandler);
        this.getJTextFieldLarge().addKeyListener(this.ivjEventHandler);
        this.getJSliderExhaustion().addChangeListener(this.ivjEventHandler);
        this.getJTextFieldExhaustion().addKeyListener(this.ivjEventHandler);
        this.getDefaultButton().addActionListener(this.ivjEventHandler);
        this.getJPanelAdvanced().addComponentListener(this.ivjEventHandler);
        this.getJSliderOverhead().addChangeListener(this.ivjEventHandler);
        this.getJTextFieldOverhead().addKeyListener(this.ivjEventHandler);
        this.getBasic().addComponentListener(this.ivjEventHandler);
        this.getOpenMenuItemSolaris().addActionListener(this.ivjEventHandler);
        this.getStatisticsMenuItem().addActionListener(this.ivjEventHandler);
        this.getStatisticsCloseButton().addActionListener(this.ivjEventHandler);
        this.getStatisticsButton().addActionListener(this.ivjEventHandler);
        this.getStatisticsMenuItem1().addActionListener(this.ivjEventHandler);
        this.getOpenMenuItemXverbosegc().addActionListener(this.ivjEventHandler);
        this.getExportMenu().addActionListener(this.ivjEventHandler);
        this.getDefaultToolBarButton().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton0().addActionListener(this.ivjEventHandler);
        this.getJToolBarButtonRefresh().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton1().addActionListener(this.ivjEventHandler);
        this.getJToolBarButtonExport().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton2().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton3().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton4().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton31().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton321().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton3211().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton322().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32211().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32212().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32213().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32214().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton32215().addActionListener(this.ivjEventHandler);
        this.getJToggleButton1().addActionListener(this.ivjEventHandler);
        this.getJToggleButton11().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton322151().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton3221511().addActionListener(this.ivjEventHandler);
        this.getJToolBarButton3221().addActionListener(this.ivjEventHandler);
    }

    private JMenuItem getUpdateMenuItem() {
        if (this.ivjUpdateMenuItem == null) {
            try {
                this.ivjUpdateMenuItem = new JMenuItem();
                this.ivjUpdateMenuItem.setName("UpdateMenuItem");
                this.ivjUpdateMenuItem.setIcon(null);
                this.ivjUpdateMenuItem.setMnemonic('U');
                this.ivjUpdateMenuItem.setText("Check for updates");
                this.ivjUpdateMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
                if (this.isISA) {
                    this.ivjUpdateMenuItem.setEnabled(false);
                    this.ivjUpdateMenuItem.setToolTipText(STANDALONE_VERSION_TEXT);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUpdateMenuItem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] checkVersionInternet(boolean showProgressCheckVersion, Component parent, boolean quiet) {
        ProgressMonitor progressMonitorCheck = null;
        if (showProgressCheckVersion) {
            progressMonitorCheck = new ProgressMonitor(parent, "Checking for updates of IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", "", 0, 1450);
            progressMonitorCheck.setMillisToPopup(0);
            progressMonitorCheck.setMillisToDecideToPopup(0);
            progressMonitorCheck.setProgress(1);
        }
        try {
            String inputLine;
            URL traHomePage = new URL(home);
            URLConnection yc = traHomePage.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            String prefix = "VERSION";
            int i = 1;
            do {
                if ((inputLine = in.readLine()) == null) {
                    in.close();
                    return null;
                }
                ++i;
                if (progressMonitorCheck == null) continue;
                progressMonitorCheck.setProgress(i);
            } while (!inputLine.contains("VERSION"));
            int s = inputLine.indexOf("VERSION");
            String version = inputLine.substring(s + "VERSION".length() + 1);
            String description = inputLine.substring(s);
            s = version.indexOf(32);
            version = version.substring(0, s);
            int latestVersion = Utility.getVersionNumberFromString(version);
            int myVersion = Utility.getMyVersion();
            if (progressMonitorCheck != null) {
                progressMonitorCheck.setProgress(progressMonitorCheck.getMaximum());
            }
            if (latestVersion > myVersion) {
                s = description.indexOf("<");
                if (s >= 0) {
                    description = description.substring(0, s);
                }
                String[] returnInfo = new String[]{version, description};
                return returnInfo;
            }
            if (progressMonitorCheck != null && !quiet) {
                JOptionPane.showMessageDialog(parent, "Your IBM Pattern Modeling and Analysis Tool for Java Garbage Collector is up to date", "Checking for updates of IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", 1);
            }
            System.out.println("IBM Pattern Modeling and Analysis Tool for Java Garbage Collector is up to date as of " + new Date(System.currentTimeMillis()));
            return null;
        }
        catch (Exception e) {
            if (progressMonitorCheck != null) {
                progressMonitorCheck.close();
            }
            this.handleException(e);
        }
        return null;
    }

    public void download(String[] str, Component parent, boolean force) {
        int webVersion = Utility.getVersionNumberFromString(str[0]);
        int localVersion = -1;
        File localFile = Utility.getLatestVersion();
        if (localFile != null) {
            localVersion = Utility.getVersionFromFileName(localFile.getName());
        }
        if (webVersion > localVersion) {
            String url = "ftp://public.dhe.ibm.com/software/websphere/appserv/support/tools/pmat/ga" + webVersion + ".jar";
            long fileSize = Utility.getFileSize(url, this);
            if (fileSize >= 0L) {
                if (force) {
                    Utility.upgrade(this, url, fileSize, force);
                } else {
                    int n = JOptionPane.showConfirmDialog(parent, String.valueOf(str[1]) + "\nWould you like to upgrade?", "Version " + str[0] + " is available", 0);
                    if (n == 0) {
                        Utility.upgrade(this, url, fileSize, force);
                    }
                }
            }
        } else if (localVersion != -1) {
            Utility.checkVersion();
        }
    }

    public SwingWorker<String[], Void> createCheckUpdateWorker(final boolean showProgressCheckVersion, final Component parent, final boolean force) {
        return new SwingWorker<String[], Void>(){

            @Override
            public String[] doInBackground() {
                String[] str = GCAnalyzer.this.checkVersionInternet(showProgressCheckVersion, parent, force);
                if (str != null) {
                    GCAnalyzer.this.download(str, parent, force);
                }
                return str;
            }

            @Override
            public void done() {
                String[] str = null;
                try {
                    str = (String[])this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    String why = null;
                    Throwable cause = e.getCause();
                    why = cause != null ? cause.getMessage() : e.getMessage();
                    System.err.println("Error retrieving version information: " + why);
                }
                if (str == null) {
                    Utility.checkVersion();
                }
            }
        };
    }

    private void initialize() {
        if (Utility.getMyVersionFromFileName() < 0) {
            this.isISA = true;
        } else {
            SwingWorker<String[], Void> worker = this.createCheckUpdateWorker(false, this, false);
            worker.execute();
        }
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/chart.gif"));
            this.setIconImage(icon.getImage());
            this.setName("GCAnalyzer");
            this.setDefaultCloseOperation(0);
            this.setJMenuBar(this.getGCAnalyzerJMenuBar());
            this.setSize(620, 496);
            this.setTitle("IBM Pattern Modeling and Analysis Tool for Java Garbage Collector");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.lookAndFeelGroup.add(this.getMetalRadioButton());
        this.lookAndFeelGroup.add(this.getMotifRadioButton());
        this.lookAndFeelGroup.add(this.getSystemRadioButton());
        LookAndFeelListener lListener = new LookAndFeelListener();
        this.getMetalRadioButton().addItemListener(lListener);
        this.getMotifRadioButton().addItemListener(lListener);
        this.getSystemRadioButton().addItemListener(lListener);
        this.console = new ConsolePrintStream(this.getConsoleTextArea());
        System.setOut(this.console);
        System.setErr(this.console);
        this.cfg = new Configuration();
        this.loadPreferenceFile();
        try {
            block2 : switch (this.cfg.lookAndFeel) {
                case 1: {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    break;
                }
                case 0: {
                    UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                    int n = lookAndFeelInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                        if ("Nimbus".equals(info.getName())) {
                            UIManager.setLookAndFeel(info.getClassName());
                            break block2;
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            SwingUtilities.updateComponentTreeUI(this.getJFrame());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.colorComboBoxRenderer.cfg = this.cfg;
        if (this.cfg.max) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
        this.jp = new JDialogProgress(this);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAnalyzer.this.jp.getJProgressBar1().setValue(GCAnalyzer.this.task.getCurrent());
                GCAnalyzer.this.jp.getOverallProgressBar().setValue(GCAnalyzer.this.task.getOverall());
                String s = GCAnalyzer.this.task.getMessage();
                if (s != null) {
                    GCAnalyzer.this.jp.getJLabel1().setText(s);
                }
                if (GCAnalyzer.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    GCAnalyzer.this.timer.stop();
                    GCAnalyzer.this.jp.getJProgressBar1().setValue(GCAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    GCAnalyzer.this.jp.getOverallProgressBar().setValue(GCAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
        this.timerJ9 = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GCAnalyzer.this.jp.getJProgressBar1().setValue(GCAnalyzer.this.taskJ9.getCurrent());
                GCAnalyzer.this.jp.getOverallProgressBar().setValue(GCAnalyzer.this.taskJ9.getOverall());
                String s = GCAnalyzer.this.taskJ9.getMessage();
                if (s != null) {
                    GCAnalyzer.this.jp.getJLabel1().setText(s);
                }
                if (GCAnalyzer.this.taskJ9.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    GCAnalyzer.this.timerJ9.stop();
                    GCAnalyzer.this.jp.getJProgressBar1().setValue(GCAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    GCAnalyzer.this.jp.getOverallProgressBar().setValue(GCAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
    }

    public static boolean isHeadLess(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length <= 1) {
            return false;
        }
        if (args[0] == null) {
            return false;
        }
        return args[0].equalsIgnoreCase("-I") || args[0].equalsIgnoreCase("-S") || args[0].equalsIgnoreCase("-X") ? args.length >= 3 : args.length >= 2;
    }

    public static void main(String[] args) {
        Graphics2D g;
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (GCAnalyzer.isHeadLess(args)) {
            if (splash != null) {
                splash.close();
            }
            GCAnalyzer.runHeadLess(args);
            return;
        }
        if (splash != null && (g = splash.createGraphics()) != null) {
            Font font = new Font(g.getFont().getName(), 1, 12);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(font);
            g.setComposite(AlphaComposite.Clear);
            g.setPaintMode();
            g.setColor(new Color(42, 42, 42));
            g.drawString("Version " + Version.getVersionInfo(), 20, 287);
            g.setColor(Color.gray);
            font = new Font(g.getFont().getName(), 0, 11);
            g.setFont(font);
            g.drawString(LICENSE_TITLE, 20, 320);
            splash.update();
        }
        try {
            GCAnalyzer aGCAnalyzer = new GCAnalyzer();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = aGCAnalyzer.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            aGCAnalyzer.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            aGCAnalyzer.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    System.exit(0);
                }
            });
            aGCAnalyzer.setVisible(true);
            if (args != null && args.length != 0) {
                aGCAnalyzer.openBatch(args);
            }
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of GCAnalyzer");
            exception.printStackTrace(System.out);
        }
    }

    public void openBatch(String[] args) {
        int type = 0;
        int start = 1;
        if (args != null && args[0] != null) {
            if (args[0].equalsIgnoreCase("-I")) {
                type = 0;
            } else if (args[0].equalsIgnoreCase("-S")) {
                type = 1;
            } else if (args[0].equalsIgnoreCase("-X")) {
                type = 2;
            } else {
                start = 0;
            }
            String separator = System.getProperty("path.separator");
            StringTokenizer st = new StringTokenizer(args[start], separator);
            int numberOfFiles = st.countTokens();
            String[] inputFiles = new String[numberOfFiles];
            File[] f = new File[numberOfFiles];
            int i = 0;
            while (i < numberOfFiles && st.hasMoreTokens()) {
                inputFiles[i] = st.nextToken();
                f[i] = new File(inputFiles[i]);
                ++i;
            }
            if (f.length == 0) {
                return;
            }
            Dimension dialogSize = this.jp.getPreferredSize();
            Dimension frameSize = this.getSize();
            Point loc = this.getLocation();
            this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
            this.jp.show();
            switch (type) {
                case 0: {
                    this.task = new FileTask(this, f, this.jp);
                    break;
                }
                case 1: {
                    this.task = new FileTask(this, f, this.jp, 1);
                    break;
                }
                case 2: {
                    this.task = new FileTask(this, f, this.jp, 2);
                }
            }
            this.task.go();
            this.timer.start();
        }
    }

    public void autoOpen() {
        JFileChooser jf;
        block10: {
            StackTraceElement[] stackTrace;
            String mname;
            String cname;
            jf = null;
            if (this.cfg.workingDir == null) {
                String curDir = System.getProperty("user.dir");
                try {
                    jf = new JFileChooser(curDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block10;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(curDir);
                        break block10;
                    }
                    this.handleException(e);
                }
            } else {
                try {
                    jf = new JFileChooser(this.cfg.workingDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block10;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(this.cfg.workingDir);
                    }
                    this.handleException(e);
                }
            }
        }
        jf.setMultiSelectionEnabled(true);
        JDialog jd = new JDialog(this);
        jf.showDialog(jd, "Open");
        File[] f = jf.getSelectedFiles();
        if (f.length == 0) {
            return;
        }
        this.cfg.workingDir = jf.getCurrentDirectory().getAbsolutePath();
        prefs.put("workingDir", this.cfg.workingDir);
        Dimension dialogSize = this.jp.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        this.jp.show();
        int fileType = this.getGCLogType(f[0]);
        if (fileType <= 2) {
            this.task = new FileTask(this, f, this.jp);
            this.task.go();
            this.timer.start();
            return;
        }
        this.task = new FileTask(this, f, this.jp, fileType - 2);
        this.task.go();
        this.timer.start();
    }

    public void openMenuItem_ActionPerformed() {
        JFileChooser jf;
        block9: {
            StackTraceElement[] stackTrace;
            String mname;
            String cname;
            jf = null;
            if (this.cfg.workingDir == null) {
                String curDir = System.getProperty("user.dir");
                try {
                    jf = new JFileChooser(curDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(curDir);
                        break block9;
                    }
                    this.handleException(e);
                }
            } else {
                try {
                    jf = new JFileChooser(this.cfg.workingDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(this.cfg.workingDir);
                    }
                    this.handleException(e);
                }
            }
        }
        jf.setMultiSelectionEnabled(true);
        JDialog jd = new JDialog(this);
        jf.showDialog(jd, "Open");
        File[] f = jf.getSelectedFiles();
        if (f.length == 0) {
            return;
        }
        this.cfg.workingDir = jf.getCurrentDirectory().getAbsolutePath();
        prefs.put("workingDir", this.cfg.workingDir);
        Dimension dialogSize = this.jp.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        this.jp.show();
        this.task = new FileTask(this, f, this.jp);
        this.task.go();
        this.timer.start();
    }

    public void openMenuItemSolaris_ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jf;
        block9: {
            StackTraceElement[] stackTrace;
            String mname;
            String cname;
            jf = null;
            if (this.cfg.workingDir == null) {
                String curDir = System.getProperty("user.dir");
                try {
                    jf = new JFileChooser(curDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(curDir);
                        break block9;
                    }
                    this.handleException(e);
                }
            } else {
                try {
                    jf = new JFileChooser(this.cfg.workingDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(this.cfg.workingDir);
                    }
                    this.handleException(e);
                }
            }
        }
        jf.setMultiSelectionEnabled(true);
        JDialog jd = new JDialog(this);
        jf.showDialog(jd, "Open Files of Solaris/HP-UX 5.0/1.4.2 SDK");
        File[] f = jf.getSelectedFiles();
        if (f.length == 0) {
            return;
        }
        this.cfg.workingDir = jf.getCurrentDirectory().getAbsolutePath();
        prefs.put("workingDir", this.cfg.workingDir);
        Dimension dialogSize = this.jp.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        this.jp.show();
        this.task = new FileTask(this, f, this.jp, 1);
        this.task.go();
        this.timer.start();
    }

    public void openMenuItemXverbosegc_ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jf;
        block9: {
            StackTraceElement[] stackTrace;
            String mname;
            String cname;
            jf = null;
            if (this.cfg.workingDir == null) {
                String curDir = System.getProperty("user.dir");
                try {
                    jf = new JFileChooser(curDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(curDir);
                        break block9;
                    }
                    this.handleException(e);
                }
            } else {
                try {
                    jf = new JFileChooser(this.cfg.workingDir);
                }
                catch (Exception e) {
                    cname = "sun.swing.plaf.synth.SynthFileChooserUIImpl";
                    mname = "installStrings";
                    stackTrace = e.getStackTrace();
                    if (stackTrace.length <= 0 || stackTrace[0] == null) break block9;
                    if (stackTrace[0].getClassName().equals(cname) && stackTrace[0].getMethodName().equals(mname)) {
                        JOptionPane.showMessageDialog(this, "Your Java runtime environment cannot handle SynthFileChooserUI correctly. Changing UI to system default", "Changing Look and Feel", 1);
                        this.setDefaultUI();
                        jf = new JFileChooser(this.cfg.workingDir);
                    }
                    this.handleException(e);
                }
            }
        }
        jf.setMultiSelectionEnabled(true);
        JDialog jd = new JDialog(this);
        jf.showDialog(jd, "Open Xverbosegc Files of HP-UX 5.0/1.4.2 SDK");
        File[] f = jf.getSelectedFiles();
        if (f.length == 0) {
            return;
        }
        this.cfg.workingDir = jf.getCurrentDirectory().getAbsolutePath();
        prefs.put("workingDir", this.cfg.workingDir);
        Dimension dialogSize = this.jp.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        this.jp.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        this.jp.show();
        this.task = new FileTask(this, f, this.jp, 2);
        this.task.go();
        this.timer.start();
    }

    public void partList_ValueChanged(ListSelectionEvent listSelectionEvent) {
        System.out.println("Click");
    }

    public void partOpenButton_ActionPerformed(ActionEvent actionEvent) {
        block9: {
            int[] selectedRows = this.getPartList().getSelectedIndices();
            if (selectedRows.length == 0) break block9;
            if (!this.isChartViewEnabled) {
                int i = 0;
                while (i < selectedRows.length) {
                    HeapFrame hf = new HeapFrame(String.valueOf(this.giPart.file.getName()) + " GC View", this.giPart);
                    hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
                    hf.fileName = this.giPart.file.getName();
                    JTable jt = new JTable(){

                        @Override
                        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                            Component c = super.prepareRenderer(renderer, row, column);
                            return c;
                        }
                    };
                    jt.setDragEnabled(true);
                    jt.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
                    hf.JScrollPaneSetViewportView(jt);
                    this.getJDesktopPane1().add(hf);
                    this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
                    try {
                        hf.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                    if (this.debug) {
                        System.out.println("start " + this.startPart[selectedRows[i]] + " end " + this.endPart[selectedRows[i]]);
                    }
                    GCTableThread at = new GCTableThread(jt, this.giPart, this, this.startPart[selectedRows[i]], this.endPart[selectedRows[i]]);
                    at.start();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < selectedRows.length) {
                    HeapFrame hf = new HeapFrame(String.valueOf(this.giPart.file.getName()) + " Chart View", this.giPart);
                    hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
                    hf.fileName = this.giPart.file.getName();
                    ChartPanel cp = new ChartPanel(this.giPart, this, this.startPart[selectedRows[i]], this.endPart[selectedRows[i]]);
                    cp.heapFrame = hf;
                    this.controlPanel = new ControlPanel(cp, this.giPart);
                    JSplitPane splitPane = new JSplitPane(1, cp, this.controlPanel);
                    splitPane.setOneTouchExpandable(true);
                    splitPane.setResizeWeight(1.0);
                    hf.getContentPane().add(splitPane);
                    hf.setMinimumSize(new Dimension(350, 550));
                    hf.setSize(new Dimension(900, 650));
                    this.getJDesktopPane1().add(hf);
                    this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
                    try {
                        hf.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                    splitPane.setVisible(true);
                    splitPane.setDividerLocation(0.8);
                    ++i;
                }
            }
        }
    }

    public void readConfiguration(String cfile, boolean headless) {
        File file = new File(cfile);
        if (!file.exists()) {
            this.cfg = new Configuration();
            this.cfg.frag = 30;
            this.cfg.large = 10;
            this.cfg.exhaustion = 10;
            this.cfg.overheadRatio = 10;
        } else {
            try {
                GZIPInputStream gs = new GZIPInputStream(new FileInputStream(file));
                ObjectInputStream ois = new ObjectInputStream(gs);
                this.cfg = (Configuration)ois.readObject();
                ois.close();
                gs.close();
            }
            catch (Exception e) {
                this.handleException(e);
                this.cfg = new Configuration();
                if (headless) {
                    System.out.println("Cannot understand configuration file :" + file.getAbsoluteFile());
                }
                JOptionPane.showMessageDialog(this, "Cannot understand configuration file :" + file.getAbsoluteFile(), "File Format Error", 2);
            }
        }
    }

    public static void runHeadLess(String[] args) {
        int start = 1;
        String fileType = "-I";
        if (args[0].equalsIgnoreCase("-I")) {
            fileType = "-I";
        } else if (args[0].equalsIgnoreCase("-S")) {
            fileType = "-S";
        } else if (args[0].equalsIgnoreCase("-X")) {
            fileType = "-X";
        } else {
            start = 0;
        }
        String separator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(args[start], separator);
        int numberOfFiles = st.countTokens();
        String[] inputFiles = new String[numberOfFiles];
        int i = 0;
        while (i < numberOfFiles && st.hasMoreTokens()) {
            inputFiles[i] = st.nextToken();
            ++i;
        }
        Properties p = new Properties();
        p.setProperty("FileType", fileType);
        File outputHTMLFile = new File(args[start + 1]);
        if (outputHTMLFile.exists()) {
            System.out.println("Output file:" + args[start + 1] + " already exists. Please try a different output file.");
            return;
        }
        GCAnalyzerHeadLess hl = new GCAnalyzerHeadLess(args[start + 1]);
        if (args.length > start + 2) {
            hl.setOption(args[start + 2]);
        } else {
            hl.setOption(null);
        }
        hl.readConfiguration();
        hl.threadAnalysis(inputFiles, p, args[start + 1]);
    }

    public void setDetailTextPaneText(String arg1) {
        this.getDetailTextPane().setText(arg1);
    }

    public void showAboutBox() {
        GCAnalyzerAboutBox aGCAnalyzerAboutBox = new GCAnalyzerAboutBox(this);
        Dimension dialogSize = aGCAnalyzerAboutBox.getPreferredSize();
        Dimension frameSize = this.getSize();
        Point loc = this.getLocation();
        aGCAnalyzerAboutBox.setLocation((frameSize.width - dialogSize.width) / 2 + loc.x, (frameSize.height - dialogSize.height) / 2 + loc.y);
        aGCAnalyzerAboutBox.setModal(true);
        aGCAnalyzerAboutBox.show();
    }

    public void statisticsButton_ActionPerformed(ActionEvent actionEvent) {
        long end;
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        Date dt = new Date();
        Date dt2 = new Date();
        try {
            dt = dateInputFormatter.parse(this.getStartTime().getText());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this, "Cannot understand start time : " + this.getStartTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
            this.getStatisticsDialog().show();
            return;
        }
        try {
            dt2 = dateInputFormatter.parse(this.getEndTime().getText());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this, "Cannot understand end  time : " + this.getEndTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
            this.getStatisticsDialog().show();
            return;
        }
        if (dt == null) {
            JOptionPane.showMessageDialog(this, "Cannot understand start time: " + this.getStartTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
            return;
        }
        if (dt2 == null) {
            JOptionPane.showMessageDialog(this, "Cannot understand start time: " + this.getEndTime().getText() + "\nPlease use the format HH:mm:ss MM/dd/yyyy ", "Timestamp format Error", 2);
            return;
        }
        long start = dt.getTime();
        if (start >= (end = dt2.getTime())) {
            JOptionPane.showMessageDialog(this, "End time should be later than start time", "Timestamp Error", 2);
            return;
        }
        this.giPart = (GCInfo)this.ti.gcList.get(selectedRows[0]);
        if (start > this.giPart.timestamp[this.giPart.timestamp.length - 1] || end < this.giPart.timestamp[0]) {
            JOptionPane.showMessageDialog(this, "Cannot find any record between the specified start and end time", "Timestamp Error", 2);
            return;
        }
        int startIndex = -1;
        int endIndex = -1;
        int i = 0;
        while (i < this.giPart.free.length) {
            if (this.giPart.timestamp[i] >= start) {
                startIndex = i;
                break;
            }
            ++i;
        }
        i = this.giPart.free.length - 1;
        while (i >= 0) {
            if (this.giPart.timestamp[i] <= end) {
                endIndex = i;
                break;
            }
            --i;
        }
        if (startIndex < 0 || endIndex < 0) {
            JOptionPane.showMessageDialog(this, "Cannot find any record between the specified start and end time", "Timestamp Error", 2);
            return;
        }
        int nGC = this.getNGC(startIndex, endIndex);
        String summary = "<html><ul><li><span style=\"font-weight: bold;\"><B>File name</B></span> :&nbsp; " + this.giPart.file.getAbsolutePath() + "</li><li><span style=\"font-weight: bold;\"><B>Number of all Garbage Collections</B></span> : " + numberFormatter.format(nGC) + "</li>";
        int nFGC = 0;
        int globalgc = 0;
        int scavengergc = 0;
        if (this.giPart.type == 2) {
            nFGC = this.getFullGC(startIndex, endIndex);
            summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Number of Full Garbage Collections</B></span> : " + numberFormatter.format(nFGC) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Minor Garbage Collections</B></span> : " + numberFormatter.format(nGC - nFGC) + "</li>";
        } else if (this.giPart.type == 1) {
            globalgc = this.getGlobalCollection(startIndex, endIndex);
            scavengergc = this.getScavengerCollection(startIndex, endIndex);
            summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Number of Global Garbage Collections</B></span> : " + numberFormatter.format(globalgc) + "</li><li><span style=\"font-weight: bold;\"><B>Number of Scavenger Garbage Collections</B></span> : " + numberFormatter.format(scavengergc) + "</li>";
        }
        if (!this.giPart.noTimestamp) {
            summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Elapsed time between start and end time</B></span> : " + numberFormatter.format((end - start) / 1000L) + " seconds </li>";
        }
        long gcCompletedAll = this.getGCCompleted(startIndex, endIndex);
        summary = String.valueOf(summary) + "<BR><li><span style=\"font-weight: bold;\"><B>Total Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedAll / 1000L) + " seconds " + (this.giPart.noTimestamp ? "" : "(" + 100.0 * (double)gcCompletedAll / (double)(end - start) + "% of elapsed time between start and end time)</li>");
        summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedAll / (long)nGC) + " milliseconds </li>";
        long gcCompletedFull = 0L;
        if (this.giPart.type == 2) {
            if (nFGC != 0) {
                gcCompletedFull = this.getGCCompletedFull(startIndex, endIndex);
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Full Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / 1000L) + " seconds </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Full Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / (long)nFGC) + " milliseconds </li>";
            }
            if (nGC - nFGC != 0) {
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Minor Garbage Collection duration</B></span> : " + numberFormatter.format((gcCompletedAll - gcCompletedFull) / 1000L) + " seconds </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Minor Garbage Collection duration</B></span> : " + numberFormatter.format((gcCompletedAll - gcCompletedFull) / (long)(nGC - nFGC)) + " milliseconds </li>";
            }
        } else if (this.giPart.type == 1) {
            if (globalgc != 0) {
                gcCompletedFull = this.getGCCompletedGlobal(startIndex, endIndex);
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Global Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / 1000L) + " seconds </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Global Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / (long)globalgc) + " milliseconds </li>";
            }
            if (scavengergc != 0) {
                gcCompletedFull = this.getGCCompletedScavenger(startIndex, endIndex);
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Scavenger Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / 1000L) + " seconds </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Scavenger Garbage Collection duration</B></span> : " + numberFormatter.format(gcCompletedFull / (long)scavengergc) + " milliseconds </li>";
            }
        }
        if (!this.giPart.noTimestamp) {
            long since = this.getSince(startIndex, endIndex);
            summary = String.valueOf(summary) + "<BR><li><span style=\"font-weight: bold;\"><B>Total Garbage Collection interval</B></span> : " + numberFormatter.format(since / 1000L) + " seconds </li>";
            summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Garbage Collection interval</B></span> : " + numberFormatter.format(since / (long)nGC) + " milliseconds </li>";
            long sinceFull = 0L;
            if (this.giPart.type == 2) {
                if (nFGC != 0) {
                    sinceFull = this.getGCSinceFull(startIndex, endIndex);
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Full Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / 1000L) + " seconds </li>";
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Full Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / (long)nFGC) + " milliseconds </li>";
                }
                if (nGC - nFGC != 0) {
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Minor Garbage Collection interval</B></span> : " + numberFormatter.format((since - sinceFull) / 1000L) + " seconds </li>";
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Minor Garbage Collection interval</B></span> : " + numberFormatter.format((since - sinceFull) / (long)(nGC - nFGC)) + " milliseconds </li>";
                }
            } else if (this.giPart.type == 1) {
                if (globalgc != 0) {
                    sinceFull = this.getGCSinceGlobal(startIndex, endIndex);
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Global Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / 1000L) + " seconds </li>";
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Global Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / (long)globalgc) + " milliseconds </li>";
                }
                if (scavengergc != 0) {
                    sinceFull = this.getGCSinceScavenger(startIndex, endIndex);
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total Scavenger Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / 1000L) + " seconds </li>";
                    summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average Scavenger Garbage Collection interval</B></span> : " + numberFormatter.format(sinceFull / (long)scavengergc) + " milliseconds </li>";
                }
            }
        }
        long collected = this.getCollected(startIndex, endIndex);
        summary = String.valueOf(summary) + "<BR><li><span style=\"font-weight: bold;\"><B>Total collected bytes by Garbage Collection</B></span> : " + numberFormatter.format(collected) + " bytes </li>";
        summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average collected bytes by Garbage Collection</B></span> : " + numberFormatter.format(collected / (long)nGC) + " bytes </li>";
        long collectedFull = 0L;
        if (this.giPart.type == 2) {
            collectedFull = this.getCollectedFull(startIndex, endIndex);
            if (nFGC != 0) {
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total collected bytes by Full Garbage Collection</B></span> : " + numberFormatter.format(collectedFull) + " bytes </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average collected bytes by Full Garbage Collection</B></span> : " + numberFormatter.format(collectedFull / (long)nFGC) + " bytes </li>";
            }
            if (nGC - nFGC != 0) {
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total collected bytes by Minor Garbage Collection</B></span> : " + numberFormatter.format(collected - collectedFull) + " bytes </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average collected bytes by Minor Garbage Collection</B></span> : " + numberFormatter.format((collected - collectedFull) / (long)(nGC - nFGC)) + " bytes </li>";
            }
        } else if (this.giPart.type == 1) {
            collectedFull = this.getCollectedGlobal(startIndex, endIndex);
            if (globalgc != 0) {
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total collected bytes by Global Garbage Collection</B></span> : " + numberFormatter.format(collectedFull) + " bytes </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average collected bytes by Global Garbage Collection</B></span> : " + numberFormatter.format(collectedFull / (long)globalgc) + " bytes </li>";
            }
            if (scavengergc != 0) {
                collectedFull = this.getCollectedScavenger(startIndex, endIndex);
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Total collected bytes by Scavenger Garbage Collection</B></span> : " + numberFormatter.format(collectedFull) + " bytes </li>";
                summary = String.valueOf(summary) + "<li><span style=\"font-weight: bold;\"><B>Average collected bytes by Scavenger Garbage Collection</B></span> : " + numberFormatter.format(collectedFull / (long)scavengergc) + " bytes </li>";
            }
        }
        this.getStatisticsTextArea().setText(summary);
        this.getStatisticsTextArea().setCaretPosition(0);
    }

    public void usageMenuItem_ActionPerformed(ActionEvent actionEvent) {
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select  files", "Information", 1);
            return;
        }
        GCInfo[] gi = new GCInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            gi[i] = (GCInfo)this.ti.gcList.get(selectedRows[i]);
            ++i;
        }
        String selectedFiles = "";
        int i2 = 0;
        while (i2 < selectedRows.length) {
            selectedFiles = String.valueOf(selectedFiles) + this.fileTable.getValueAt(selectedRows[i2], 0) + " ";
            ++i2;
        }
        int z = 0;
        while (z < gi.length) {
            HeapFrame hf = new HeapFrame(String.valueOf(gi[z].file.getName()) + " GC Duration Summary", gi[z]);
            hf.setFrameIcon(new ImageIcon(this.getClass().getResource("/working_duration_template.gif")));
            hf.fileName = gi[z].file.getName();
            long[] min = new long[4];
            long[] max = new long[4];
            long[] avg = new long[4];
            long[] timestamp = new long[4];
            long[] sum = new long[4];
            min[0] = max[0] = gi[z].mark[0];
            min[1] = max[1] = gi[z].sweep[0];
            min[2] = max[2] = gi[z].compact[0];
            min[3] = max[3] = gi[z].gccompleted[0];
            timestamp[2] = timestamp[3] = gi[z].timestamp[0];
            timestamp[1] = timestamp[3];
            timestamp[0] = timestamp[3];
            int i3 = 0;
            while (i3 < gi[z].free.length) {
                if (gi[z].mark[i3] > max[0]) {
                    max[0] = gi[z].mark[i3];
                    timestamp[0] = gi[z].timestamp[i3];
                }
                if (gi[z].mark[i3] < min[0]) {
                    min[0] = gi[z].mark[i3];
                }
                sum[0] = sum[0] + gi[z].mark[i3];
                if (gi[z].sweep[i3] > max[1]) {
                    max[1] = gi[z].sweep[i3];
                    timestamp[1] = gi[z].timestamp[i3];
                }
                if (gi[z].sweep[i3] < min[1]) {
                    min[1] = gi[z].sweep[i3];
                }
                sum[1] = sum[1] + gi[z].sweep[i3];
                if (gi[z].compact[i3] > max[2]) {
                    max[2] = gi[z].compact[i3];
                    timestamp[2] = gi[z].timestamp[i3];
                }
                if (gi[z].compact[i3] < min[2]) {
                    min[2] = gi[z].compact[i3];
                }
                sum[2] = sum[2] + gi[z].compact[i3];
                if (gi[z].gccompleted[i3] > max[3]) {
                    max[3] = gi[z].gccompleted[i3];
                    timestamp[3] = gi[z].timestamp[i3];
                }
                if (gi[z].gccompleted[i3] < min[3]) {
                    min[3] = gi[z].gccompleted[i3];
                }
                sum[3] = sum[3] + gi[z].gccompleted[i3];
                ++i3;
            }
            Object[] header = new Object[]{"", "Mark avg", "min", "max", "timestamp of max", "Sweep avg", "min", "max", "timestamp of max", "Compact avg", "min", "max", "timestamp of max", "Overall avg", "min", "max", "timestamp of max"};
            Object[][] data = new Object[gi[z].numberOfSet + 1][17];
            data[0][0] = "Overall";
            int i4 = 0;
            while (i4 < min.length) {
                data[0][i4 * 4 + 1] = numberFormatter.format(sum[i4] / (long)gi[z].free.length);
                data[0][i4 * 4 + 2] = numberFormatter.format(min[i4]);
                data[0][i4 * 4 + 3] = numberFormatter.format(max[i4]);
                data[0][i4 * 4 + 4] = dateFormatter.format(new Date(timestamp[i4]));
                ++i4;
            }
            long[] minMark = new long[gi[z].numberOfSet];
            long[] maxMark = new long[gi[z].numberOfSet];
            long[] sumMark = new long[gi[z].numberOfSet];
            long[] timeMark = new long[gi[z].numberOfSet];
            int[] countMark = new int[gi[z].numberOfSet];
            long[] minSweep = new long[gi[z].numberOfSet];
            long[] maxSweep = new long[gi[z].numberOfSet];
            long[] sumSweep = new long[gi[z].numberOfSet];
            long[] timeSweep = new long[gi[z].numberOfSet];
            int[] countSweep = new int[gi[z].numberOfSet];
            long[] minCompact = new long[gi[z].numberOfSet];
            long[] maxCompact = new long[gi[z].numberOfSet];
            long[] sumCompact = new long[gi[z].numberOfSet];
            long[] timeCompact = new long[gi[z].numberOfSet];
            int[] countCompact = new int[gi[z].numberOfSet];
            long[] minComplete = new long[gi[z].numberOfSet];
            long[] maxComplete = new long[gi[z].numberOfSet];
            long[] sumComplete = new long[gi[z].numberOfSet];
            long[] timeComplete = new long[gi[z].numberOfSet];
            int[] countComplete = new int[gi[z].numberOfSet];
            int nGC = 999999999;
            int index = -1;
            int i5 = 0;
            while (i5 < gi[z].free.length) {
                if (gi[z].ngc[i5] < nGC) {
                    minMark[++index] = maxMark[index] = gi[z].mark[i5];
                    minSweep[index] = maxSweep[index] = gi[z].sweep[i5];
                    minCompact[index] = maxCompact[index] = gi[z].compact[i5];
                    minComplete[index] = maxComplete[index] = gi[z].gccompleted[i5];
                    timeMark[index] = timeSweep[index] = gi[z].timestamp[i5];
                    timeComplete[index] = timeSweep[index];
                    timeCompact[index] = timeSweep[index];
                }
                nGC = gi[z].ngc[i5];
                if (gi[z].mark[i5] > maxMark[index]) {
                    maxMark[index] = gi[z].mark[i5];
                    timeMark[index] = gi[z].timestamp[i5];
                }
                if (gi[z].mark[i5] < minMark[index]) {
                    minMark[index] = gi[z].mark[i5];
                }
                int n = index;
                sumMark[n] = sumMark[n] + gi[z].mark[i5];
                int n2 = index;
                countMark[n2] = countMark[n2] + 1;
                if (gi[z].sweep[i5] > maxSweep[index]) {
                    maxSweep[index] = gi[z].sweep[i5];
                    timeSweep[index] = gi[z].timestamp[i5];
                }
                if (gi[z].sweep[i5] < minSweep[index]) {
                    minSweep[index] = gi[z].sweep[i5];
                }
                int n3 = index;
                sumSweep[n3] = sumSweep[n3] + gi[z].sweep[i5];
                int n4 = index;
                countSweep[n4] = countSweep[n4] + 1;
                if (gi[z].compact[i5] > maxCompact[index]) {
                    maxCompact[index] = gi[z].compact[i5];
                    timeCompact[index] = gi[z].timestamp[i5];
                }
                if (gi[z].compact[i5] < minCompact[index]) {
                    minCompact[index] = gi[z].compact[i5];
                }
                int n5 = index;
                sumCompact[n5] = sumCompact[n5] + gi[z].compact[i5];
                int n6 = index;
                countCompact[n6] = countCompact[n6] + 1;
                if (gi[z].gccompleted[i5] > maxComplete[index]) {
                    maxComplete[index] = gi[z].gccompleted[i5];
                    timeComplete[index] = gi[z].timestamp[i5];
                }
                if (gi[z].gccompleted[i5] < minComplete[index]) {
                    minComplete[index] = gi[z].gccompleted[i5];
                }
                int n7 = index;
                sumComplete[n7] = sumComplete[n7] + gi[z].gccompleted[i5];
                int n8 = index;
                countComplete[n8] = countComplete[n8] + 1;
                ++i5;
            }
            i5 = 1;
            while (i5 < gi[z].numberOfSet + 1) {
                data[i5][0] = "# " + i5;
                data[i5][1] = numberFormatter.format(sumMark[i5 - 1] / (long)countMark[i5 - 1]);
                data[i5][2] = numberFormatter.format(minMark[i5 - 1]);
                data[i5][3] = numberFormatter.format(maxMark[i5 - 1]);
                data[i5][4] = dateFormatter.format(new Date(timeMark[i5 - 1]));
                data[i5][5] = numberFormatter.format(sumSweep[i5 - 1] / (long)countSweep[i5 - 1]);
                data[i5][6] = numberFormatter.format(minSweep[i5 - 1]);
                data[i5][7] = numberFormatter.format(maxSweep[i5 - 1]);
                data[i5][8] = dateFormatter.format(new Date(timeSweep[i5 - 1]));
                data[i5][9] = numberFormatter.format(sumCompact[i5 - 1] / (long)countCompact[i5 - 1]);
                data[i5][10] = numberFormatter.format(minCompact[i5 - 1]);
                data[i5][11] = numberFormatter.format(maxCompact[i5 - 1]);
                data[i5][12] = dateFormatter.format(new Date(timeCompact[i5 - 1]));
                data[i5][13] = numberFormatter.format(sumComplete[i5 - 1] / (long)countComplete[i5 - 1]);
                data[i5][14] = numberFormatter.format(minComplete[i5 - 1]);
                data[i5][15] = numberFormatter.format(maxComplete[i5 - 1]);
                data[i5][16] = dateFormatter.format(new Date(timeComplete[i5 - 1]));
                ++i5;
            }
            JTable jt = new JTable(data, header){

                @Override
                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                    Component c = super.prepareRenderer(renderer, row, column);
                    return c;
                }
            };
            jt.setDragEnabled(true);
            hf.JScrollPaneSetViewportView(jt);
            this.getJDesktopPane1().add(hf);
            this.getJDesktopPane1().getDesktopManager().activateFrame(hf);
            try {
                hf.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            ++z;
        }
    }

    public void viewConsole() {
        try {
            this.getConsoleFrame().setIcon(!this.getConsoleFrame().isIcon());
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void viewStatusBar() {
        this.getStatusBarPane().setVisible(!this.getStatusBarPane().isVisible());
    }

    class IvjEventHandler
    implements ActionListener,
    ComponentListener,
    KeyListener,
    MouseListener,
    WindowListener,
    ChangeListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GCAnalyzer.this.getUpdateMenuItem() || e.getSource() == GCAnalyzer.this.getUpdateButton()) {
                GCAnalyzer.this.update();
            }
            if (e.getSource() == GCAnalyzer.this.getStatusbarCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoC2(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAbout_BoxMenuItem()) {
                GCAnalyzer.this.connEtoC3(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAutoOpenMenuItem()) {
                GCAnalyzer.this.autoOpen();
            }
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItem()) {
                GCAnalyzer.this.connEtoC4(e);
            }
            if (e.getSource() == GCAnalyzer.this.getConsoleCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoC5(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGC_ListMenuItem()) {
                GCAnalyzer.this.connEtoC6(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem()) {
                GCAnalyzer.this.connEtoC7(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOptionMenuItem()) {
                GCAnalyzer.this.connEtoM2(e);
            }
            if (e.getSource() == GCAnalyzer.this.getSaveButton()) {
                GCAnalyzer.this.connEtoM3(e);
            }
            if (e.getSource() == GCAnalyzer.this.getUsageMenuItem()) {
                GCAnalyzer.this.connEtoC8(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDurationMenuItem()) {
                GCAnalyzer.this.connEtoC9(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAFMenuItem()) {
                GCAnalyzer.this.connEtoC10(e);
            }
            if (e.getSource() == GCAnalyzer.this.getClearMenuItem()) {
                GCAnalyzer.this.connEtoM5(e);
            }
            if (e.getSource() == GCAnalyzer.this.getColorComboBox()) {
                GCAnalyzer.this.connEtoC11(e);
            }
            if (e.getSource() == GCAnalyzer.this.getBrowseButton()) {
                GCAnalyzer.this.connEtoC13(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExitMenuItem()) {
                GCAnalyzer.this.connEtoC15(e);
            }
            if (e.getSource() == GCAnalyzer.this.getHelp_TopicsMenuItem()) {
                GCAnalyzer.this.connEtoC1(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGC_ListMenuItem1()) {
                GCAnalyzer.this.connEtoC16(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem1()) {
                GCAnalyzer.this.connEtoC17(e);
            }
            if (e.getSource() == GCAnalyzer.this.getRefreshMenuItem() || e.getSource() == GCAnalyzer.this.getRefreshMenuItem1() || e.getSource() == GCAnalyzer.this.getJToolBarButtonRefresh()) {
                GCAnalyzer.this.refresh();
            }
            if (e.getSource() == GCAnalyzer.this.getUsageMenuItem1()) {
                GCAnalyzer.this.connEtoC18(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDurationMenuItem1()) {
                GCAnalyzer.this.connEtoC19(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAFMenuItem1()) {
                GCAnalyzer.this.connEtoC20(e);
            }
            if (e.getSource() == GCAnalyzer.this.getCloseMenuItem()) {
                GCAnalyzer.this.connEtoC21(e);
            }
            if (e.getSource() == GCAnalyzer.this.getCloseAllMenuItem()) {
                GCAnalyzer.this.connEtoC22(e);
            }
            if (e.getSource() == GCAnalyzer.this.getCloseMenuItem1()) {
                GCAnalyzer.this.connEtoC23(e);
            }
            if (e.getSource() == GCAnalyzer.this.getCloseAllMenuItem1()) {
                GCAnalyzer.this.connEtoC24(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGCViewPartMenuItem()) {
                GCAnalyzer.this.connEtoM35(e);
            }
            if (e.getSource() == GCAnalyzer.this.getPartCancelButton()) {
                GCAnalyzer.this.connEtoM34(e);
            }
            if (e.getSource() == GCAnalyzer.this.getPartOpenButton()) {
                GCAnalyzer.this.connEtoC25(e);
            }
            if (e.getSource() == GCAnalyzer.this.getPartOpenButton()) {
                GCAnalyzer.this.connEtoM36(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGCViewPartMenuItem1()) {
                GCAnalyzer.this.connEtoM37(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem11()) {
                GCAnalyzer.this.connEtoM38(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem2()) {
                GCAnalyzer.this.connEtoM39(e);
            }
            if (e.getSource() == GCAnalyzer.this.getCloseButton()) {
                GCAnalyzer.this.connEtoM40(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDefaultButton()) {
                GCAnalyzer.this.connEtoM48(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDefaultButton()) {
                GCAnalyzer.this.connEtoM49(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDefaultButton()) {
                GCAnalyzer.this.connEtoM50(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDefaultButton()) {
                GCAnalyzer.this.connEtoM47(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItemSolaris()) {
                GCAnalyzer.this.connEtoC26(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatisticsMenuItem()) {
                GCAnalyzer.this.connEtoM55(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatisticsCloseButton()) {
                GCAnalyzer.this.connEtoM56(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatisticsButton()) {
                GCAnalyzer.this.connEtoC12(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatisticsMenuItem1()) {
                GCAnalyzer.this.connEtoM57(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItemXverbosegc()) {
                GCAnalyzer.this.connEtoC27(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExportMenu() || e.getSource() == GCAnalyzer.this.getJToolBarButtonExport()) {
                GCAnalyzer.this.export();
            }
            if (e.getSource() == GCAnalyzer.this.getDefaultToolBarButton()) {
                GCAnalyzer.this.connEtoC28(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton1()) {
                GCAnalyzer.this.connEtoC29(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton0()) {
                GCAnalyzer.this.autoOpen();
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton2()) {
                GCAnalyzer.this.connEtoC30(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton3()) {
                GCAnalyzer.this.connEtoC31(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton4()) {
                GCAnalyzer.this.connEtoC32(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton31()) {
                GCAnalyzer.this.connEtoC33(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton321()) {
                GCAnalyzer.this.connEtoC34(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton3211()) {
                GCAnalyzer.this.connEtoM58(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32()) {
                GCAnalyzer.this.connEtoC35(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton322()) {
                GCAnalyzer.this.connEtoM59(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32211()) {
                GCAnalyzer.this.connEtoC36(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32212()) {
                GCAnalyzer.this.connEtoC37(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32213()) {
                GCAnalyzer.this.connEtoC38(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32214()) {
                GCAnalyzer.this.connEtoM60(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton32215()) {
                GCAnalyzer.this.connEtoM61(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToggleButton1()) {
                GCAnalyzer.this.connEtoC39(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToggleButton11()) {
                GCAnalyzer.this.connEtoC40(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton322151()) {
                GCAnalyzer.this.connEtoC41(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton3221511()) {
                GCAnalyzer.this.connEtoC42(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJToolBarButton3221()) {
                GCAnalyzer.this.connEtoM62(e);
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (e.getSource() == GCAnalyzer.this.getJPanelAdvanced()) {
                GCAnalyzer.this.connEtoM52(e);
            }
            if (e.getSource() == GCAnalyzer.this.getBasic()) {
                GCAnalyzer.this.connEtoM54(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() == GCAnalyzer.this.getJTextFieldFrag()) {
                GCAnalyzer.this.connEtoM42();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldLarge()) {
                GCAnalyzer.this.connEtoM44();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldExhaustion()) {
                GCAnalyzer.this.connEtoM46();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldOverhead()) {
                GCAnalyzer.this.connEtoM53();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == GCAnalyzer.this.getJTextFieldFrag()) {
                GCAnalyzer.this.connEtoM42();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldLarge()) {
                GCAnalyzer.this.connEtoM44();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldExhaustion()) {
                GCAnalyzer.this.connEtoM46();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldOverhead()) {
                GCAnalyzer.this.connEtoM53();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getSource() == GCAnalyzer.this.getJTextFieldFrag()) {
                GCAnalyzer.this.connEtoM42();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldLarge()) {
                GCAnalyzer.this.connEtoM44();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldExhaustion()) {
                GCAnalyzer.this.connEtoM46();
            }
            if (e.getSource() == GCAnalyzer.this.getJTextFieldOverhead()) {
                GCAnalyzer.this.connEtoM53();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItem()) {
                GCAnalyzer.this.connEtoM1(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItem()) {
                GCAnalyzer.this.connEtoM6(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExitMenuItem()) {
                GCAnalyzer.this.connEtoM8(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExitMenuItem()) {
                GCAnalyzer.this.connEtoM10(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGC_ListMenuItem()) {
                GCAnalyzer.this.connEtoM12(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem()) {
                GCAnalyzer.this.connEtoM14(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDurationMenuItem()) {
                GCAnalyzer.this.connEtoM16(e);
            }
            if (e.getSource() == GCAnalyzer.this.getUsageMenuItem()) {
                GCAnalyzer.this.connEtoM18(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAFMenuItem()) {
                GCAnalyzer.this.connEtoM20(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOptionMenuItem()) {
                GCAnalyzer.this.connEtoM22(e);
            }
            if (e.getSource() == GCAnalyzer.this.getClearMenuItem()) {
                GCAnalyzer.this.connEtoM24(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatusbarCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoM26(e);
            }
            if (e.getSource() == GCAnalyzer.this.getConsoleCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoM28(e);
            }
            if (e.getSource() == GCAnalyzer.this.getHelp_TopicsMenuItem()) {
                GCAnalyzer.this.connEtoM30(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAbout_BoxMenuItem()) {
                GCAnalyzer.this.connEtoM32(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItem()) {
                GCAnalyzer.this.connEtoM4(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOpenMenuItem()) {
                GCAnalyzer.this.connEtoM7(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExitMenuItem()) {
                GCAnalyzer.this.connEtoM9(e);
            }
            if (e.getSource() == GCAnalyzer.this.getExitMenuItem()) {
                GCAnalyzer.this.connEtoM11(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGC_ListMenuItem()) {
                GCAnalyzer.this.connEtoM13(e);
            }
            if (e.getSource() == GCAnalyzer.this.getGraph_ViewMenuItem()) {
                GCAnalyzer.this.connEtoM15(e);
            }
            if (e.getSource() == GCAnalyzer.this.getDurationMenuItem()) {
                GCAnalyzer.this.connEtoM17(e);
            }
            if (e.getSource() == GCAnalyzer.this.getUsageMenuItem()) {
                GCAnalyzer.this.connEtoM19(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAFMenuItem()) {
                GCAnalyzer.this.connEtoM21(e);
            }
            if (e.getSource() == GCAnalyzer.this.getOptionMenuItem()) {
                GCAnalyzer.this.connEtoM23(e);
            }
            if (e.getSource() == GCAnalyzer.this.getClearMenuItem()) {
                GCAnalyzer.this.connEtoM25(e);
            }
            if (e.getSource() == GCAnalyzer.this.getStatusbarCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoM27(e);
            }
            if (e.getSource() == GCAnalyzer.this.getConsoleCheckBoxMenuItem()) {
                GCAnalyzer.this.connEtoM29(e);
            }
            if (e.getSource() == GCAnalyzer.this.getHelp_TopicsMenuItem()) {
                GCAnalyzer.this.connEtoM31(e);
            }
            if (e.getSource() == GCAnalyzer.this.getAbout_BoxMenuItem()) {
                GCAnalyzer.this.connEtoM33(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == GCAnalyzer.this.getJSliderFrag()) {
                GCAnalyzer.this.connEtoM41(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJSliderLarge()) {
                GCAnalyzer.this.connEtoM43(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJSliderExhaustion()) {
                GCAnalyzer.this.connEtoM45(e);
            }
            if (e.getSource() == GCAnalyzer.this.getJSliderOverhead()) {
                GCAnalyzer.this.connEtoM51(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == GCAnalyzer.this) {
                GCAnalyzer.this.connEtoC14(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    class LookAndFeelListener
    implements ItemListener {
        LookAndFeelListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rb = (JRadioButton)e.getSource();
            try {
                if (rb.isSelected() && rb.getText().equals("System")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJDialog());
                } else if (rb.isSelected() && rb.getText().equals("Nimbus")) {
                    UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                    int n = lookAndFeelInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                        if ("Nimbus".equals(info.getName())) {
                            UIManager.setLookAndFeel(info.getClassName());
                            break;
                        }
                        ++n2;
                    }
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJDialog());
                } else if (rb.isSelected() && rb.getText().equals("Metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJDialog());
                }
            }
            catch (UnsupportedLookAndFeelException ex) {
                rb.setEnabled(false);
                System.out.println(String.valueOf(rb.getText()) + " Look and Feel is not supported on this platform. Trying Cross Platform Look and Feel.");
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(GCAnalyzer.this.getJDialog());
                    System.out.println("Cross Platform Look and Feel is applied.");
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    System.out.println("Cross Platform Look and Feel failed.");
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

