/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.Configuration;
import com.ibm.jinwoo.gc.FileTask;
import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.Version;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class GCAnalyzerHeadLess {
    String option;
    String outputHTMLFileName;
    public Configuration cfg;
    private static final String PREFERENCE_FILE = "ga.xml";
    public static Preferences prefs = Preferences.userRoot().node("com.ibm.jinwoo.gcanalyzer");
    public static final String HEADER = "<B>IBM Pattern Modeling and Analysis Tool for Java Garbage Collector</B> Version " + Version.getVersionInfo() + "<BR>Created & Developed by Jinwoo Hwang (jinwoo@us.ibm.com)<BR>" + "Licensed Materials - Property of IBM Corp. (C) Copyright IBM Corp. 2004-2013. All Rights Reserved." + "<BR>";
    long lineNumber;
    long fileLocation;
    String statMessage;
    int overall;
    int current;
    boolean done = false;
    boolean debug = false;
    GCInfo gi = null;
    public int fileType = 0;
    public long timestamp = 0L;
    public boolean inAF = false;
    public boolean inCON = false;
    public boolean inSG = false;
    public boolean inGC = false;
    public boolean afterGC = false;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    static SimpleDateFormat formatterX = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
    public static final String J9_SIGNATURE = "<?xml version=\"";

    public GCAnalyzerHeadLess(String outputHTMLFileName) {
        this.outputHTMLFileName = outputHTMLFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFileType(File file) {
        try {
            char[] cbuffer = new char[11];
            BufferedReader br = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(file)));
            String txtSignature = br.readLine();
            while (true) {
                if (txtSignature == null) {
                    return 0;
                }
                if (txtSignature.startsWith("<verbosegc") || txtSignature.startsWith("<gc type=")) {
                    br.close();
                    return 1;
                }
                txtSignature = br.readLine();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getFileType(String filename) {
        File file = new File(filename);
        try {
            char[] cbuffer = new char[11];
            BufferedReader br = new BufferedReader(new InputStreamReader(GCAnalyzer.getInputStream(file)));
            String txtSignature = br.readLine();
            if (txtSignature != null) {
                txtSignature = txtSignature.trim();
            }
            while (true) {
                if (txtSignature == null) {
                    return 0;
                }
                if (txtSignature.startsWith("<gc type=")) {
                    br.close();
                    return 1;
                }
                if (txtSignature.startsWith("<cycle-start id=")) {
                    br.close();
                    return 2;
                }
                txtSignature = br.readLine();
                if (txtSignature == null) continue;
                txtSignature = txtSignature.trim();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            return -1;
        }
    }

    public String getOption() {
        return this.option;
    }

    public void handleException(Throwable exception) {
        exception.printStackTrace(System.out);
    }

    String processJ9(String inputFileNames, Properties prop, int fileSequenceNumber) {
        File file = new File(inputFileNames);
        FileTask ft = new FileTask(null, null, fileSequenceNumber, this.outputHTMLFileName, this.cfg);
        return ft.processJ9(file, this.cfg, true, this.getOption());
    }

    String processSolaris(String inputFileNames, Properties prop, int fileSequenceNumber) {
        File file = new File(inputFileNames);
        FileTask ft = new FileTask(null, null, fileSequenceNumber, this.outputHTMLFileName, this.cfg);
        return ft.processSolaris(file, this.cfg, true, this.getOption());
    }

    String processSov(String inputFileNames, Properties prop, int fileSequenceNumber) {
        File file = new File(inputFileNames);
        FileTask ft = new FileTask(null, null, fileSequenceNumber, this.outputHTMLFileName, this.cfg);
        return ft.processSov(file, this.cfg, true, this.getOption());
    }

    String processXverbosegc(String inputFileNames, Properties prop, int fileSequenceNumber) {
        File file = new File(inputFileNames);
        FileTask ft = new FileTask(null, null, fileSequenceNumber, this.outputHTMLFileName, this.cfg);
        return ft.processXverbosegc(file, this.cfg, true, this.getOption());
    }

    public void readConfiguration() {
        this.cfg = new Configuration();
        this.loadPreferenceFile();
    }

    void loadPreferenceFile() {
        try {
            prefs.clear();
        }
        catch (BackingStoreException e2) {
            e2.printStackTrace();
        }
        BufferedInputStream is = null;
        FileInputStream fio = null;
        try {
            fio = new FileInputStream(PREFERENCE_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fio != null) {
            try {
                is = new BufferedInputStream(fio);
            }
            catch (Exception e) {
                this.handleException(e);
                return;
            }
            if (is != null) {
                try {
                    Preferences.importPreferences(is);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
                catch (InvalidPreferencesFormatException e) {
                    this.handleException(e);
                }
                this.cfg.lookAndFeel = prefs.getInt("lookAndFeel", 0);
                this.cfg.verbose = prefs.getBoolean("verbose", true);
                this.cfg.autoY = prefs.getBoolean("autoY", true);
                this.cfg.save = prefs.getBoolean("save", true);
                this.cfg.terminals = prefs.getBoolean("terminals", true);
                this.cfg.points = prefs.getBoolean("points", false);
                this.cfg.frag = prefs.getInt("frag", 30);
                this.cfg.large = prefs.getInt("large", 10);
                this.cfg.exhaustion = prefs.getInt("exhaustion", 10);
                this.cfg.overheadRatio = prefs.getInt("overheadRatio", 10);
                this.cfg.max = prefs.getBoolean("max", true);
                this.cfg.fileList = prefs.getBoolean("fileList", true);
                this.cfg.limit = prefs.getLong("limit", 1000L);
                this.cfg.width = prefs.getInt("width", 1024);
                this.cfg.height = prefs.getInt("height", 768);
                String name = prefs.get("fontFamily", null);
                if (name == null) {
                    this.cfg.font = null;
                } else {
                    int size = prefs.getInt("fontSize", 10);
                    int style = prefs.getInt("fontStyle", 0);
                    this.cfg.font = new Font(name, style, size);
                }
                this.cfg.defaultStartTime = prefs.getLong("defaultStartTime", 0L);
                this.cfg.workingDir = prefs.get("workingDir", Configuration.WORKINGDIR);
                this.cfg.free = new Color(prefs.getInt("free", Configuration.FREE.getRGB()));
                this.cfg.freeSOA = new Color(prefs.getInt("freeSOA", Configuration.FREESOA.getRGB()));
                this.cfg.freeBeforeSOA = new Color(prefs.getInt("freeBeforeSOA", Configuration.FREEBEFORESOA.getRGB()));
                this.cfg.freeLOA = new Color(prefs.getInt("freeLOA", Configuration.FREELOA.getRGB()));
                this.cfg.freeBeforeLOA = new Color(prefs.getInt("freeBeforeLOA", Configuration.FREEBEFORELOA.getRGB()));
                this.cfg.freeN = new Color(prefs.getInt("freeN", Configuration.FREEN.getRGB()));
                this.cfg.freeNBefore = new Color(prefs.getInt("freeNBefore", Configuration.FREENBEFORE.getRGB()));
                this.cfg.freeBefore = new Color(prefs.getInt("freeBefore", Configuration.FREEBEFORE.getRGB()));
                this.cfg.freed = new Color(prefs.getInt("freed", Configuration.FREED.getRGB()));
                this.cfg.overhead = new Color(prefs.getInt("overhead", Configuration.OVERHEAD.getRGB()));
                this.cfg.used = new Color(prefs.getInt("used", Configuration.USED.getRGB()));
                this.cfg.usedN = new Color(prefs.getInt("usedN", Configuration.USEDN.getRGB()));
                this.cfg.usedNBefore = new Color(prefs.getInt("usedNBefore", Configuration.USEDNBEFORE.getRGB()));
                this.cfg.usedBefore = new Color(prefs.getInt("usedBefore", Configuration.USEDBEFORE.getRGB()));
                this.cfg.total = new Color(prefs.getInt("total", Configuration.TOTAL.getRGB()));
                this.cfg.totalLOA = new Color(prefs.getInt("totalLOA", Configuration.TOTALLOA.getRGB()));
                this.cfg.totalSOA = new Color(prefs.getInt("totalSOA", Configuration.TOTALSOA.getRGB()));
                this.cfg.totalN = new Color(prefs.getInt("totalN", Configuration.TOTALN.getRGB()));
                this.cfg.totalBefore = new Color(prefs.getInt("totalBefore", Configuration.TOTALBEFORE.getRGB()));
                this.cfg.totalBeforeSOA = new Color(prefs.getInt("totalBeforeSOA", Configuration.TOTALBEFORESOA.getRGB()));
                this.cfg.totalBeforeLOA = new Color(prefs.getInt("totalBeforeLOA", Configuration.TOTALBEFORELOA.getRGB()));
                this.cfg.totalNBefore = new Color(prefs.getInt("totalNBefore", Configuration.TOTALNBEFORE.getRGB()));
                this.cfg.requested = new Color(prefs.getInt("requested", Configuration.REQUESTED.getRGB()));
                this.cfg.since = new Color(prefs.getInt("since", Configuration.SINCE.getRGB()));
                this.cfg.completed = new Color(prefs.getInt("completed", Configuration.COMPLETED.getRGB()));
                this.cfg.gccompleted = new Color(prefs.getInt("gccompleted", Configuration.GCCOMPLETED.getRGB()));
                this.cfg.mark = new Color(prefs.getInt("mark", Configuration.MARK.getRGB()));
                this.cfg.sweep = new Color(prefs.getInt("sweep", Configuration.SWEEP.getRGB()));
                this.cfg.compact = new Color(prefs.getInt("compact", Configuration.COMPACT.getRGB()));
                this.cfg.totalPBefore = new Color(prefs.getInt("totalPBefore", Configuration.TOTALPBEFORE.getRGB()));
                this.cfg.usedPBefore = new Color(prefs.getInt("usedPBefore", Configuration.USEDPBEFORE.getRGB()));
                this.cfg.usedPAfter = new Color(prefs.getInt("usedPAfter", Configuration.USEDPAFTER.getRGB()));
                this.cfg.freePAfter = new Color(prefs.getInt("freePAfter", Configuration.FREEPAFTER.getRGB()));
                this.cfg.freePBefore = new Color(prefs.getInt("freePBefore", Configuration.FREEPBEFORE.getRGB()));
                this.cfg.maxTen = new Color(prefs.getInt("maxTen", Configuration.MAXTEN.getRGB()));
                this.cfg.maxPerm = new Color(prefs.getInt("maxPerm", Configuration.MAXPERM.getRGB()));
                this.cfg.oome = new Color(prefs.getInt("oome", Configuration.OOME.getRGB()));
                this.cfg.restart = new Color(prefs.getInt("restart", Configuration.RESTART.getRGB()));
            }
        }
    }

    public void setOption(String o) {
        this.option = o;
    }

    public void threadAnalysis(String[] inputFileNames, Properties prop, String outputHTMLFileName) {
        block14: {
            if (this.cfg == null) {
                this.cfg = new Configuration();
            }
            String outputString = "";
            int i = 0;
            while (i < inputFileNames.length) {
                outputString = String.valueOf(outputString) + this.threadAnalysis(inputFileNames[i], prop, i) + "<BR><BR>";
                ++i;
            }
            outputString = "<HTML><HEAD><TITLE>Java Heap Garbage Collector Trace Analysis</TITLE><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" ></HEAD><BODY><H3>Java Heap Garbage Collector Trace Analysis</H3>" + HEADER + "<BR>" + "<TABLE WIDTH=\"100%\">" + "<TR><TD WIDTH=\"0%\"></TD>" + "<TD WIDTH=\"100%\">Report date and time: " + new Date() + "</TD>" + "</TR>" + "<TR><TD WIDTH=\"0%\"></TD>" + "<TD WIDTH=\"100%\">Problem Type for Analysis: Java Heap Garbage Collection Problem" + "</TD>" + "</TR>" + "<TR><TD WIDTH=\"0%\"></TD>" + "<TD WIDTH=\"100%\">Please run standalone version (http://www.alphaworks.ibm.com/tech/pmat) if you need interactive interfaces or more information" + "</TD>" + "</TR>" + "</TABLE>" + "<BR>" + outputString + "</html>";
            File outputFile = new File(outputHTMLFileName);
            Writer output = null;
            try {
                try {
                    output = new BufferedWriter(new FileWriter(outputFile));
                    output.write(outputString);
                }
                catch (Exception e) {
                    this.handleException(e);
                    if (output == null) break block14;
                    try {
                        output.close();
                    }
                    catch (Exception e2) {
                        this.handleException(e2);
                    }
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
        }
    }

    public String threadAnalysis(String inputFileNames, Properties prop, int fileSequenceNumber) {
        String outputString = null;
        if (prop == null) {
            return null;
        }
        String fileType = prop.getProperty("FileType");
        if (fileType == null) {
            return null;
        }
        if (fileType.compareToIgnoreCase("-I") == 0) {
            int type = this.getFileType(inputFileNames);
            outputString = type == 1 ? this.processJ9(inputFileNames, prop, fileSequenceNumber) : (type == 2 ? this.processJ92(inputFileNames, prop, fileSequenceNumber) : this.processSov(inputFileNames, prop, fileSequenceNumber));
        } else if (fileType.compareToIgnoreCase("-S") == 0) {
            outputString = this.processSolaris(inputFileNames, prop, fileSequenceNumber);
        } else if (fileType.compareToIgnoreCase("-X") == 0) {
            outputString = this.processXverbosegc(inputFileNames, prop, fileSequenceNumber);
        }
        return outputString;
    }

    String processJ92(String inputFileNames, Properties prop, int fileSequenceNumber) {
        File file = new File(inputFileNames);
        FileTask ft = new FileTask(null, null, fileSequenceNumber, this.outputHTMLFileName, this.cfg);
        return ft.processJ92(file, this.cfg, true, this.getOption());
    }
}

