/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.SortThreadGC;
import com.ibm.jinwoo.gc.SortableHeaderIcon;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class GCTableModel
extends AbstractTableModel {
    int start;
    int end;
    Date date = new Date(0L);
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    public static final boolean DESCENDING = true;
    public static final boolean ASCENDING = false;
    public boolean direction = true;
    String[] columnNames = new String[]{"Used", "Free", "Total", "Needed", "Freed", "Free(Before)", "Total(Before)", "AF Completed", "Since", "Mark", "Sweep", "Compact", "GC Completed", "Overhead", "Exhausted", "AF#", "GC#", "Timestamp"};
    String[] columnNamesForJ9 = new String[]{"Used Tenured(After)", "Free Tenured(After)", "Total Tenured(After)", "Needed", "Free Tenured(Before)", "Total Tenured(Before)", "Free Nursery(After)", "Total Nursery(After)", "Free Nursery(Before)", "Total Nursery(Before)", "AF Completed", "Since", "Mark", "Sweep", "Compact", "GC Completed", "Overhead", "Exhausted", "AF#", "GC#", "Timestamp"};
    String[] columnNamesForSolaris = new String[]{"Used Tenured(After)", "Free Tenured(After)", "Total Tenured(After)", "Free Tenured(Before)", "Total Tenured(Before)", "Free New(After)", "Total New(After)", "Free New(Before)", "Total New(Before)", "Free Perm(After)", "Free Perm(Before)", "Total Perm", "Since", "GC Completed", "Overhead", "GC#", "Timestamp"};
    String[] columnNamesForSolarisSimple = new String[]{"Used Tenured+New(After)", "Free Tenured+New(After)", "Total Tenured+New(After)", "Free Tenured+New(Before)", "Total Tenured+New(Before)", "Since", "GC Completed", "Overhead", "GC#", "Timestamp"};
    GCInfo hi;
    int sortedColumn = 0;
    public JTableHeader tableHeader;
    public long[][] sortedArrary;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public GCTableModel() {
    }

    public GCTableModel(GCInfo h) {
        this(h, 0, h.free.length - 1);
    }

    public GCTableModel(GCInfo h, int col) {
        this.hi = h;
        this.sortedColumn = col;
        if (this.hi.type == 1) {
            this.columnNames = new String[this.columnNamesForJ9.length];
            int i = 0;
            while (i < this.columnNamesForJ9.length) {
                this.columnNames[i] = this.columnNamesForJ9[i];
                ++i;
            }
        }
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public GCTableModel(GCInfo h, int start, int end) {
        this.start = start;
        this.end = end;
        this.hi = h;
        if (this.hi.type == 1) {
            this.columnNames = new String[this.columnNamesForJ9.length];
            int i = 0;
            while (i < this.columnNamesForJ9.length) {
                this.columnNames[i] = this.columnNamesForJ9[i];
                ++i;
            }
        } else if (this.hi.type == 2) {
            if (this.hi.simpleSolaris) {
                this.columnNames = new String[this.columnNamesForSolarisSimple.length];
                int i = 0;
                while (i < this.columnNamesForSolarisSimple.length) {
                    this.columnNames[i] = this.columnNamesForSolarisSimple[i];
                    ++i;
                }
            } else {
                this.columnNames = new String[this.columnNamesForSolaris.length];
                int i = 0;
                while (i < this.columnNamesForSolaris.length) {
                    this.columnNames[i] = this.columnNamesForSolaris[i];
                    ++i;
                }
            }
        }
        this.sortedColumn = this.columnNames.length - 1;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    long getCompleted(int idx) {
        if (this.hi.completed[idx] != 0L) {
            return this.hi.completed[idx];
        }
        if (this.hi.gccompleted[idx] == 0L) {
            return 0L;
        }
        int i = idx;
        while (i < this.hi.free.length) {
            if (this.hi.completed[i] != 0L) {
                return this.hi.completed[i];
            }
            ++i;
        }
        return 0L;
    }

    public Icon getHeaderIcon(int column, int size) {
        if (column != this.sortedColumn) {
            return null;
        }
        return new SortableHeaderIcon(this.direction, size);
    }

    public int getOverhead(int idx) {
        if (this.isStartPoint(idx)) {
            return 0;
        }
        if (this.hi.type == 0 && this.hi.naf[idx] == 0) {
            return 0;
        }
        if (this.hi.type == 0) {
            if (this.hi.since[idx] + this.hi.completed[idx] == 0L) {
                return 0;
            }
            return (int)((float)this.hi.completed[idx] * 100.0f / (float)(this.hi.since[idx] + this.hi.completed[idx]));
        }
        if (this.hi.since[idx] + this.hi.gccompleted[idx] == 0L) {
            return 0;
        }
        return (int)((float)this.hi.gccompleted[idx] * 100.0f / (float)(this.hi.since[idx] + this.hi.gccompleted[idx]));
    }

    @Override
    public int getRowCount() {
        return this.end - this.start + 1;
    }

    long getSince(int idx) {
        if (this.hi.since[idx] != 0L) {
            return this.hi.since[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.hi.since[i] != 0L && this.hi.af[i] != 0L) {
                return this.hi.since[i];
            }
            --i;
        }
        return 0L;
    }

    long getSinceJ9(int idx) {
        if (this.hi.sinceJ9[idx] != 0L) {
            return this.hi.sinceJ9[idx];
        }
        int i = idx;
        while (i >= 0) {
            if (this.hi.sinceJ9[i] != 0L && this.hi.af[i] != 0L) {
                return this.hi.sinceJ9[i];
            }
            --i;
        }
        return 0L;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.hi.type == 0) {
            int idx = row;
            if (this.sortedColumn == this.columnNames.length - 1) {
                idx = !this.direction ? this.end - row : row + this.start;
            } else if (this.direction) {
                idx = this.getRowCount() - row - 1;
            }
            if (this.sortedColumn != this.columnNames.length - 1) {
                idx = (int)this.sortedArrary[1][idx];
            }
            switch (col) {
                case 0: {
                    return numberFormatter.format(this.hi.total[idx] - this.hi.free[idx]);
                }
                case 1: {
                    return numberFormatter.format(this.hi.free[idx]);
                }
                case 2: {
                    return numberFormatter.format(this.hi.total[idx]);
                }
                case 3: {
                    return numberFormatter.format(this.hi.af[idx]);
                }
                case 4: {
                    return numberFormatter.format(this.hi.freed[idx]);
                }
                case 5: {
                    return numberFormatter.format(this.hi.freeBefore[idx]);
                }
                case 6: {
                    return numberFormatter.format(this.hi.totalBefore[idx]);
                }
                case 7: {
                    return numberFormatter.format(this.hi.completed[idx]);
                }
                case 8: {
                    return numberFormatter.format(this.hi.since[idx]);
                }
                case 9: {
                    return numberFormatter.format(this.hi.mark[idx]);
                }
                case 10: {
                    return numberFormatter.format(this.hi.sweep[idx]);
                }
                case 11: {
                    return numberFormatter.format(this.hi.compact[idx]);
                }
                case 12: {
                    return numberFormatter.format(this.hi.gccompleted[idx]);
                }
                case 13: {
                    return numberFormatter.format(this.getOverhead(idx));
                }
                case 14: {
                    if (this.hi.outOfHeapSpace == null) {
                        return "No";
                    }
                    int i = 0;
                    while (i < this.hi.outOfHeapSpace.length) {
                        if (this.hi.outOfHeapSpace[i] == idx) {
                            return "Yes";
                        }
                        ++i;
                    }
                    return "No";
                }
                case 15: {
                    return numberFormatter.format(this.hi.naf[idx]);
                }
                case 16: {
                    return numberFormatter.format(this.hi.ngc[idx]);
                }
            }
            this.date.setTime(this.hi.timestamp[idx]);
            return dateFormatter.format(this.date);
        }
        if (this.hi.type == 1) {
            int idx = row;
            if (this.sortedColumn == this.columnNamesForJ9.length - 1) {
                idx = !this.direction ? this.end - row : row + this.start;
            } else if (this.direction) {
                idx = this.getRowCount() - row - 1;
            }
            if (this.sortedColumn != this.columnNamesForJ9.length - 1) {
                idx = (int)this.sortedArrary[1][idx];
            }
            switch (col) {
                case 0: {
                    return numberFormatter.format(this.hi.total[idx] - this.hi.free[idx]);
                }
                case 1: {
                    return numberFormatter.format(this.hi.free[idx]);
                }
                case 2: {
                    return numberFormatter.format(this.hi.total[idx]);
                }
                case 3: {
                    return numberFormatter.format(this.hi.af[idx]);
                }
                case 4: {
                    return numberFormatter.format(this.hi.freeBefore[idx]);
                }
                case 5: {
                    return numberFormatter.format(this.hi.totalBefore[idx]);
                }
                case 6: {
                    return numberFormatter.format(this.hi.freeNursery[idx]);
                }
                case 7: {
                    return numberFormatter.format(this.hi.totalNursery[idx]);
                }
                case 8: {
                    return numberFormatter.format(this.hi.freeNurseryBefore[idx]);
                }
                case 9: {
                    return numberFormatter.format(this.hi.totalNurseryBefore[idx]);
                }
                case 10: {
                    return numberFormatter.format(this.hi.completed[idx]);
                }
                case 11: {
                    return numberFormatter.format(this.hi.since[idx]);
                }
                case 12: {
                    return numberFormatter.format(this.hi.mark[idx]);
                }
                case 13: {
                    return numberFormatter.format(this.hi.sweep[idx]);
                }
                case 14: {
                    return numberFormatter.format(this.hi.compact[idx]);
                }
                case 15: {
                    return numberFormatter.format(this.hi.gccompleted[idx]);
                }
                case 16: {
                    return numberFormatter.format(this.getOverhead(idx));
                }
                case 17: {
                    if (this.hi.outOfHeapSpace == null) {
                        return "No";
                    }
                    int i = 0;
                    while (i < this.hi.outOfHeapSpace.length) {
                        if (this.hi.outOfHeapSpace[i] == idx) {
                            return "Yes";
                        }
                        ++i;
                    }
                    return "No";
                }
                case 18: {
                    return numberFormatter.format(this.hi.naf[idx]);
                }
                case 19: {
                    return numberFormatter.format(this.hi.ngc[idx]);
                }
            }
            this.date.setTime(this.hi.timestamp[idx]);
            return dateFormatter.format(this.date);
        }
        if (this.hi.type == 2 && !this.hi.simpleSolaris) {
            int idx = row;
            if (this.sortedColumn == this.columnNamesForSolaris.length - 1) {
                idx = !this.direction ? this.end - row : row + this.start;
            } else if (this.direction) {
                idx = this.getRowCount() - row - 1;
            }
            if (this.sortedColumn != this.columnNamesForSolaris.length - 1) {
                idx = (int)this.sortedArrary[1][idx];
            }
            switch (col) {
                case 0: {
                    return numberFormatter.format(this.hi.total[idx] - this.hi.free[idx]);
                }
                case 1: {
                    return numberFormatter.format(this.hi.free[idx]);
                }
                case 2: {
                    return numberFormatter.format(this.hi.total[idx]);
                }
                case 3: {
                    return numberFormatter.format(this.hi.freeBefore[idx]);
                }
                case 4: {
                    return numberFormatter.format(this.hi.totalBefore[idx]);
                }
                case 5: {
                    return numberFormatter.format(this.hi.freeNursery[idx]);
                }
                case 6: {
                    return numberFormatter.format(this.hi.totalNursery[idx]);
                }
                case 7: {
                    return numberFormatter.format(this.hi.freeNurseryBefore[idx]);
                }
                case 8: {
                    return numberFormatter.format(this.hi.totalNurseryBefore[idx]);
                }
                case 9: {
                    return numberFormatter.format(this.hi.freePerm[idx]);
                }
                case 10: {
                    return numberFormatter.format(this.hi.freePermBefore[idx]);
                }
                case 11: {
                    return numberFormatter.format(this.hi.totalPermBefore[idx]);
                }
                case 12: {
                    if (this.hi.noTimestamp) {
                        return "Not Available";
                    }
                    return numberFormatter.format(this.hi.since[idx]);
                }
                case 13: {
                    return numberFormatter.format(this.hi.gccompleted[idx]);
                }
                case 14: {
                    if (this.hi.noTimestamp) {
                        return "Not Available";
                    }
                    return numberFormatter.format(this.getOverhead(idx));
                }
                case 15: {
                    return numberFormatter.format(this.hi.ngc[idx]);
                }
            }
            this.date.setTime(this.hi.timestamp[idx]);
            return dateFormatter.format(this.date);
        }
        if (this.hi.type == 2 && this.hi.simpleSolaris) {
            int idx = row;
            if (this.sortedColumn == this.columnNamesForSolarisSimple.length - 1) {
                idx = !this.direction ? this.end - row : row + this.start;
            } else if (this.direction) {
                idx = this.getRowCount() - row - 1;
            }
            if (this.sortedColumn != this.columnNamesForSolarisSimple.length - 1) {
                idx = (int)this.sortedArrary[1][idx];
            }
            switch (col) {
                case 0: {
                    return numberFormatter.format(this.hi.total[idx] - this.hi.free[idx]);
                }
                case 1: {
                    return numberFormatter.format(this.hi.free[idx]);
                }
                case 2: {
                    return numberFormatter.format(this.hi.total[idx]);
                }
                case 3: {
                    return numberFormatter.format(this.hi.freeBefore[idx]);
                }
                case 4: {
                    return numberFormatter.format(this.hi.totalBefore[idx]);
                }
                case 5: {
                    if (this.hi.noTimestamp) {
                        return "Not Available";
                    }
                    return numberFormatter.format(this.hi.since[idx]);
                }
                case 6: {
                    return numberFormatter.format(this.hi.gccompleted[idx]);
                }
                case 7: {
                    if (this.hi.noTimestamp) {
                        return "Not Available";
                    }
                    return numberFormatter.format(this.getOverhead(idx));
                }
                case 8: {
                    return numberFormatter.format(this.hi.ngc[idx]);
                }
            }
            this.date.setTime(this.hi.timestamp[idx]);
            return dateFormatter.format(this.date);
        }
        return null;
    }

    boolean isStartPoint(int idx) {
        if (idx >= this.hi.free.length || idx < 0) {
            return false;
        }
        if (idx == 0) {
            return true;
        }
        return this.hi.ngc[idx - 1] >= this.hi.ngc[idx];
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void sortColumn(int column, boolean direction) {
        if (column == this.sortedColumn) {
            this.direction = !direction;
            this.fireTableDataChanged();
            return;
        }
        SortThreadGC st = new SortThreadGC(this, column);
        st.start();
    }

    public boolean isSortedbyTimeStamp() {
        return this.sortedColumn == this.columnNames.length - 1;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                GCTableModel.this.sortColumn(column, GCTableModel.this.direction);
                if (GCTableModel.this.tableHeader != null) {
                    GCTableModel.this.tableHeader.repaint();
                }
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(GCTableModel.this.getHeaderIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            GCTableModel.this.fireTableDataChanged();
        }
    }
}

