/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.GCInfo;
import com.ibm.jinwoo.gc.GCTableModel;
import com.ibm.jinwoo.gc.HeapFrame;
import com.ibm.jinwoo.gc.JinwooDynamicTextPane;
import com.ibm.jinwoo.gc.PopupListener2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class GCTableThread
extends Thread
implements ActionListener,
ItemListener {
    GCInfo hi;
    JTable jt;
    int start;
    int end;
    GCAnalyzer gca;
    HeapFrame hf;
    int highlight = -1;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    JPopupMenu popup;

    public GCTableThread() {
    }

    public GCTableThread(GCInfo h) {
        this.hi = h;
    }

    public GCTableThread(Runnable target) {
        super(target);
    }

    public GCTableThread(Runnable target, String name) {
        super(target, name);
    }

    public GCTableThread(String name) {
        super(name);
    }

    public GCTableThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    public GCTableThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    public GCTableThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public GCTableThread(JTable j, GCInfo h) {
        this.hi = h;
        this.jt = j;
    }

    public GCTableThread(JTable j, GCInfo h, GCAnalyzer gca) {
        this.hi = h;
        this.jt = j;
        this.start = 0;
        this.end = this.hi.free.length - 1;
        this.gca = gca;
    }

    public GCTableThread(JTable j, GCInfo h, GCAnalyzer gca, int start, int end) {
        this.hi = h;
        this.jt = j;
        this.gca = gca;
        this.start = start;
        this.end = end;
    }

    public GCTableThread(JTable j, GCInfo h, GCAnalyzer gca, HeapFrame hf) {
        this.hi = h;
        this.jt = j;
        this.start = 0;
        if (h.timestamp[0] > h.timestamp[h.timestamp.length - 1]) {
            long prev = h.timestamp[0];
            int i = 0;
            while (i < h.timestamp.length) {
                if (prev > h.timestamp[i]) {
                    this.end = i > 0 ? i - 1 : 0;
                    break;
                }
                prev = h.timestamp[i];
                ++i;
            }
        } else {
            this.end = this.hi.free.length - 1;
        }
        this.gca = gca;
        this.hf = hf;
    }

    public GCTableThread(JTable j, GCInfo h, GCAnalyzer gca, HeapFrame hf, int highlight) {
        this.hi = h;
        this.jt = j;
        this.start = 0;
        if (h.timestamp[0] > h.timestamp[h.timestamp.length - 1]) {
            long prev = h.timestamp[0];
            int i = 0;
            while (i < h.timestamp.length) {
                if (prev > h.timestamp[i]) {
                    this.end = i > 0 ? i - 1 : 0;
                    break;
                }
                prev = h.timestamp[i];
                ++i;
            }
        } else {
            this.end = this.hi.free.length - 1;
        }
        this.gca = gca;
        this.hf = hf;
        this.highlight = highlight;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.jt.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this.gca, "Please select a row for source view", "Information", 1);
            return;
        }
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().startsWith("Source View")) {
            GCTableModel om = (GCTableModel)this.jt.getModel();
            int idx = this.jt.getSelectedRow();
            if (om.isSortedbyTimeStamp()) {
                if (!om.direction) {
                    idx = om.getRowCount() - idx - 1;
                }
            } else {
                if (om.direction) {
                    idx = om.getRowCount() - idx - 1;
                }
                idx = (int)om.sortedArrary[1][idx];
            }
            JInternalFrame sourceFrame = new JInternalFrame(String.valueOf(this.hi.file.getName()) + " Source View");
            sourceFrame.setFrameIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
            JinwooDynamicTextPane area = null;
            area = idx + 1 >= this.hi.filePointer.length ? new JinwooDynamicTextPane(this.hi.file, this.hi.filePointer[idx], -1L) : new JinwooDynamicTextPane(this.hi.file, this.hi.filePointer[idx], this.hi.filePointer[idx + 1]);
            sourceFrame.setContentPane(area);
            sourceFrame.setVisible(true);
            sourceFrame.setSize(600, 300);
            sourceFrame.setClosable(true);
            sourceFrame.setResizable(true);
            sourceFrame.setMaximizable(true);
            sourceFrame.setIconifiable(true);
            this.gca.getJDesktopPane1().add(sourceFrame);
            this.gca.getJDesktopPane1().getDesktopManager().activateFrame(sourceFrame);
            try {
                sourceFrame.setSelected(true);
            }
            catch (PropertyVetoException e2) {
                e2.printStackTrace();
            }
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
        if (source.isSelected()) {
            String txt = source.getText();
            int i = 0;
            while (i < this.jt.getColumnModel().getColumnCount()) {
                if (this.jt.getColumnName(i).compareTo(txt) == 0) {
                    this.jt.getColumnModel().getColumn(i).setMinWidth(15);
                    this.jt.getColumnModel().getColumn(i).setMaxWidth(2000);
                    this.jt.getColumnModel().getColumn(i).setWidth(100);
                    this.jt.getColumnModel().getColumn(i).setPreferredWidth(100);
                    break;
                }
                ++i;
            }
        } else {
            String txt = source.getText();
            int i = 0;
            while (i < this.jt.getColumnModel().getColumnCount()) {
                if (this.jt.getColumnName(i).compareTo(txt) == 0) {
                    this.jt.getColumnModel().getColumn(i).setMinWidth(0);
                    this.jt.getColumnModel().getColumn(i).setMaxWidth(0);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void run() {
        GCTableModel om = new GCTableModel(this.hi, this.start, this.end);
        om.setTableHeader(this.jt.getTableHeader());
        if (om.sortedArrary == null) {
            if (this.gca.cfg.verbose) {
                System.out.println(new Date() + " Requesting " + numberFormatter.format(this.hi.total.length * 16) + " bytes of Java heap.");
            }
            om.sortedArrary = new long[2][this.end - this.start + 1];
        }
        this.jt.setModel(om);
        this.jt.setToolTipText("Click right button of mouse to hide/show columns or display source");
        this.popup = new JPopupMenu();
        JMenuItem cbMenu = new JMenuItem("Source View");
        cbMenu.addActionListener(this);
        this.popup.add(cbMenu);
        this.popup.add(new JSeparator());
        int i = 0;
        while (i < om.getColumnCount()) {
            JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(om.getColumnName(i));
            cbMenuItem.setSelected(true);
            cbMenuItem.addItemListener(this);
            this.popup.add(cbMenuItem);
            ++i;
        }
        PopupListener2 popupListener = new PopupListener2(this.popup, this.jt, this.gca);
        this.jt.addMouseListener(popupListener);
        if (this.highlight != -1) {
            ListSelectionModel selectionModel = this.jt.getSelectionModel();
            selectionModel.setSelectionInterval(this.highlight, this.highlight);
            this.jt.scrollRectToVisible(this.jt.getCellRect(this.highlight, 0, true));
        }
    }
}

