/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.BufferedRandomAccessFile;
import com.ibm.jinwoo.gc.JinwooHighlightPainter;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

public class JinwooTextArea
extends JTextArea
implements KeyListener,
MouseWheelListener {
    private boolean isKeyEvent = false;
    private boolean isScrollEvent = false;
    int barLocation = -1;
    static final String newLine = "\n";
    BufferedRandomAccessFile br;
    File file;
    long startFilePointer;
    long endFilePointer;
    JScrollPane scrollPane;
    private JScrollBar verticalScrollBar;

    public synchronized boolean isScrollEvent() {
        return this.isScrollEvent;
    }

    public synchronized void setScrollEvent(boolean isScrollEvent) {
        this.isScrollEvent = isScrollEvent;
    }

    public synchronized boolean isKeyEvent() {
        return this.isKeyEvent;
    }

    public synchronized void setKeyEvent(boolean isKeyEvent) {
        this.isKeyEvent = isKeyEvent;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public void setVerticalScrollBar(JScrollBar verticalScrollBar) {
        this.verticalScrollBar = verticalScrollBar;
    }

    public JinwooTextArea() {
        this.addKeyListener(this);
    }

    public JinwooTextArea(int rows, int columns) {
        super(rows, columns);
    }

    public JinwooTextArea(File file, long filePointer, JScrollBar verticalScrollBar, JScrollPane pane, long endFilePointer) {
        this.setEditable(true);
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
        this.file = file;
        this.startFilePointer = filePointer;
        this.scrollPane = pane;
        this.setScrollPane(pane);
        this.setVerticalScrollBar(verticalScrollBar);
        String nextLine = null;
        try {
            this.br = new BufferedRandomAccessFile(file, "r");
            this.br.seek(this.startFilePointer);
            nextLine = this.br.readLineBuffered();
            if (nextLine != null) {
                this.setText(nextLine);
                this.append(newLine);
                int i = 0;
                while (i < 200) {
                    nextLine = this.br.readLineBuffered();
                    if (nextLine == null) break;
                    this.append(nextLine);
                    this.append(newLine);
                    ++i;
                }
                String moreLines = null;
                int start = 0;
                try {
                    moreLines = this.br.readPreviousLinesBuffered(2L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (moreLines != null) {
                    this.insert(moreLines, 0);
                    start = moreLines.length();
                }
                JinwooHighlightPainter highlightPainter = new JinwooHighlightPainter(Color.yellow);
                Highlighter lighlighter = this.getHighlighter();
                try {
                    if (endFilePointer == -1L) {
                        lighlighter.addHighlight(start, this.getText().length() - 1, highlightPainter);
                    } else {
                        lighlighter.addHighlight(start, start + this.br.getSize(filePointer, endFilePointer), highlightPainter);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            this.setCaretPosition(0);
            endFilePointer = this.br.getBufferedFilePointer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JinwooTextArea(String text) {
        super(text);
    }

    public JinwooTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public JinwooTextArea(Document doc) {
        super(doc);
    }

    public JinwooTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (e.getKeyCode() == 40 || e.getKeyCode() == 34) {
            int lineNumber = -1;
            try {
                lineNumber = this.getLineOfOffset(this.getCaretPosition());
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
            if (lineNumber == this.getLineCount() - 1) {
                String moreLines = null;
                StringBuffer allLines = null;
                int count = 1;
                if (e.getKeyCode() == 34) {
                    count = 20;
                    e.consume();
                }
                int i = 0;
                while (i < count) {
                    moreLines = null;
                    try {
                        moreLines = this.br.readLineBuffered();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (moreLines == null) break;
                    if (allLines == null) {
                        allLines = new StringBuffer(String.valueOf(moreLines) + newLine);
                    } else {
                        allLines.append(String.valueOf(moreLines) + newLine);
                    }
                    ++i;
                }
                if (allLines != null) {
                    this.append(allLines.toString());
                }
            } else {
                this.setKeyEvent(true);
            }
        } else if (e.getKeyCode() == 38 || e.getKeyCode() == 33) {
            int lineNumber = -1;
            try {
                lineNumber = this.getLineOfOffset(this.getCaretPosition());
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
            if (lineNumber == 0) {
                String moreLines = null;
                int count = 1;
                if (e.getKeyCode() == 33) {
                    count = 20;
                }
                moreLines = null;
                try {
                    moreLines = this.br.readPreviousLinesBuffered(count);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (moreLines != null) {
                    this.insert(moreLines, 0);
                }
            } else {
                this.setKeyEvent(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            int gap = e.getUnitsToScroll();
            if (gap > 0) {
                int nextPage = this.viewToModel(new Point(this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height + this.getFont().getSize() * gap));
                if (nextPage < 0) {
                    nextPage = 0;
                }
                if (nextPage >= this.getText().length()) {
                    String moreLines = null;
                    StringBuffer allLines = null;
                    int count = gap;
                    int i = 0;
                    while (i < count) {
                        moreLines = null;
                        try {
                            moreLines = this.br.readLineBuffered();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (moreLines == null) break;
                        if (allLines == null) {
                            allLines = new StringBuffer(String.valueOf(moreLines) + newLine);
                        } else {
                            allLines.append(String.valueOf(moreLines) + newLine);
                        }
                        ++i;
                    }
                    if (allLines != null) {
                        this.append(allLines.toString());
                    }
                }
                this.setCaretPosition(nextPage);
                this.setScrollEvent(true);
            } else {
                int prePage = 0;
                if (this.getVisibleRect().y == 0) {
                    String moreLines = null;
                    int count = -gap;
                    moreLines = null;
                    try {
                        moreLines = this.br.readPreviousLinesBuffered(count);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (moreLines != null) {
                        this.insert(moreLines, 0);
                    }
                } else {
                    prePage = this.viewToModel(new Point(this.getVisibleRect().x, this.getVisibleRect().y - this.getFont().getSize() * -gap));
                    if (prePage < 0) {
                        prePage = 0;
                    }
                }
                this.setCaretPosition(prePage);
                this.setScrollEvent(true);
            }
        }
    }

    public void scrollBarEvent(AdjustmentEvent e) {
        if (this.isKeyEvent()) {
            this.setKeyEvent(false);
            return;
        }
        if (this.br == null) {
            return;
        }
        if (this.barLocation != e.getValue()) {
            int gap = this.barLocation - e.getValue();
            if (gap < 0) {
                int nextPage = this.viewToModel(new Point(this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height + this.getFont().getSize() * (gap / -80 - 1)));
                if (nextPage < 0) {
                    nextPage = 0;
                }
                if (nextPage >= this.getText().length()) {
                    String moreLines = null;
                    StringBuffer allLines = null;
                    int count = gap / -80;
                    int i = 0;
                    while (i < count) {
                        moreLines = null;
                        try {
                            moreLines = this.br.readLineBuffered();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (moreLines == null) break;
                        if (allLines == null) {
                            allLines = new StringBuffer(String.valueOf(moreLines) + newLine);
                        } else {
                            allLines.append(String.valueOf(moreLines) + newLine);
                        }
                        ++i;
                    }
                    if (allLines != null) {
                        this.append(allLines.toString());
                    }
                }
                this.setCaretPosition(nextPage);
                this.setScrollEvent(true);
            } else {
                int prePage = 0;
                if (this.getVisibleRect().y == 0) {
                    String moreLines = null;
                    int count = gap / 80;
                    moreLines = null;
                    try {
                        moreLines = this.br.readPreviousLinesBuffered(count);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (moreLines != null) {
                        this.insert(moreLines, 0);
                    }
                } else {
                    prePage = this.viewToModel(new Point(this.getVisibleRect().x, this.getVisibleRect().y - this.getFont().getSize() * (gap / 80)));
                    if (prePage < 0) {
                        prePage = 0;
                    }
                }
                this.setCaretPosition(prePage);
                this.setScrollEvent(true);
            }
        }
        this.barLocation = e.getValue();
    }

    public void intervalScrollEvent(AdjustmentEvent e) {
        if (this.isScrollEvent()) {
            this.setScrollEvent(false);
            return;
        }
        int newLocation = this.getCaretPosition() + (int)this.br.getVirtualPointer();
        if ((long)newLocation <= this.file.length()) {
            this.getVerticalScrollBar().setValue(newLocation);
        }
    }
}

