/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.gc;

import com.ibm.jinwoo.gc.GCAnalyzer;
import com.ibm.jinwoo.gc.Version;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class Utility {
    static final String fileSeparator = System.getProperty("file.separator");
    static final String FTP_URL_START = "<a href=\"";
    static final String FTP_URL_END = "\">VERSION";
    static ProgressMonitor progressMonitorDownload = null;
    static ProgressMonitor progressMonitorCheck = null;

    public static void restart(JFrame ha) {
        String javaHome = System.getProperty("java.home");
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        if (javaHome == null || fileSeparator == null || classPath == null) {
            JOptionPane.showMessageDialog(ha, "Cannot find Java executable. Please manually restart the IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", "Information", 1);
            return;
        }
        String javaExecutable = String.valueOf(javaHome) + fileSeparator + "bin" + fileSeparator + "java";
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer inputArgumentStringBuffer = new StringBuffer();
        for (String arg : inputArguments) {
            if (!arg.startsWith("-")) continue;
            inputArgumentStringBuffer.append("\"");
            inputArgumentStringBuffer.append(arg);
            inputArgumentStringBuffer.append("\" ");
        }
        final StringBuilder restartCommand = new StringBuilder();
        restartCommand.append(javaExecutable);
        restartCommand.append(" ");
        restartCommand.append(inputArgumentStringBuffer);
        restartCommand.append("-jar ");
        restartCommand.append(classPath);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(restartCommand.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        System.exit(0);
    }

    public static File getClassDirectory(String classPath) {
        File dir = new File(classPath);
        File parent = dir.getParentFile();
        File currentDir = null;
        if (parent == null) {
            String curDir = System.getProperty("user.dir");
            currentDir = new File(curDir);
        } else {
            currentDir = parent;
        }
        return currentDir;
    }

    public static int getMyVersionFromFileName() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        File currentDir = Utility.getClassDirectory(classPath);
        if (currentDir == null) {
            return -2;
        }
        return Utility.getVersionFromFileName(classPath);
    }

    public static int getMyVersion() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        File currentDir = Utility.getClassDirectory(classPath);
        if (currentDir == null) {
            return Utility.getVersionNumberFromString(Version.getVersionInfo());
        }
        int version = Utility.getVersionFromFileName(classPath);
        if (version == -1) {
            return Utility.getVersionNumberFromString(Version.getVersionInfo());
        }
        return version;
    }

    public static String getMyVersionString() {
        int version = Utility.getMyVersion();
        if (version <= 0) {
            return null;
        }
        String release = String.valueOf(version % 10);
        String minor = String.valueOf(version / 10 % 10);
        String major = String.valueOf(version / 100);
        return String.valueOf(major) + "." + minor + "." + release;
    }

    public static File getLatestVersion() {
        int currentVersion;
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        File currentDir = Utility.getClassDirectory(classPath);
        if (currentDir == null) {
            return null;
        }
        int maxVersion = currentVersion = Utility.getVersionFromFileName(classPath);
        File[] files = currentDir.listFiles();
        if (files != null) {
            Pattern p = Pattern.compile("ga\\d+\\.jar");
            int latestIndex = -1;
            int i = 0;
            while (i < files.length) {
                int fileVersion;
                String fileName;
                Matcher m;
                boolean b;
                if (files[i].isFile() && (b = (m = p.matcher(fileName = files[i].getName())).matches()) && (fileVersion = Utility.getVersionFromFileName(fileName)) > maxVersion) {
                    maxVersion = fileVersion;
                    latestIndex = i;
                }
                ++i;
            }
            if (latestIndex >= 0) {
                return files[latestIndex];
            }
        }
        return null;
    }

    public static void checkVersion() {
        int n;
        File file = Utility.getLatestVersion();
        if (file != null && (n = JOptionPane.showConfirmDialog(null, "You have a later version than you started. Do you want to run " + file.getName() + " ?", "Later version detected", 0)) == 0) {
            Utility.start(null, file.getAbsolutePath());
        }
    }

    public static int getVersionFromFileName(String classPath) {
        if (classPath != null) {
            int start = classPath.lastIndexOf(fileSeparator);
            int end = classPath.lastIndexOf(".");
            if (end < 0) {
                String fileName = start >= 0 ? classPath.substring(start + 1) : classPath.substring(0);
                int version = -1;
                try {
                    version = Integer.valueOf(fileName.substring(2));
                }
                catch (NumberFormatException e) {
                    version = -1;
                }
                return version;
            }
            String fileName = start >= 0 ? classPath.substring(start + 1, end) : classPath.substring(0, end);
            int version = -1;
            try {
                version = Integer.valueOf(fileName.substring(2));
            }
            catch (NumberFormatException e) {
                version = -1;
            }
            return version;
        }
        return -1;
    }

    public static void start(Component ha, String classPath) {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || fileSeparator == null || classPath == null) {
            JOptionPane.showMessageDialog(ha, "Cannot find Java executable. Please manually restart the IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", "Information", 1);
            return;
        }
        String javaExecutable = String.valueOf(javaHome) + fileSeparator + "bin" + fileSeparator + "java";
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer inputArgumentStringBuffer = new StringBuffer();
        for (String arg : inputArguments) {
            if (!arg.startsWith("-")) continue;
            inputArgumentStringBuffer.append("\"");
            inputArgumentStringBuffer.append(arg);
            inputArgumentStringBuffer.append("\" ");
        }
        final StringBuilder restartCommand = new StringBuilder();
        restartCommand.append(javaExecutable);
        restartCommand.append(" ");
        restartCommand.append(inputArgumentStringBuffer);
        restartCommand.append("-jar ");
        restartCommand.append(classPath);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(restartCommand.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        System.exit(0);
    }

    public static void upgrade(GCAnalyzer ha, String url, long fileSize, boolean force) {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        File directory = Utility.getClassDirectory(classPath);
        int fileNameStart = url.lastIndexOf("/");
        if (fileNameStart >= 0) {
            String fileName = url.substring(fileNameStart + 1);
            File outputFile = new File(String.valueOf(directory.getAbsolutePath()) + fileSeparator + fileName);
            if (outputFile.exists()) {
                if (outputFile.canWrite()) {
                    if (force) {
                        Utility.download(ha, url, outputFile, fileSize, force);
                    } else {
                        int n = JOptionPane.showConfirmDialog(null, String.valueOf(outputFile.getName()) + " exists. Do you want to overwrite it?", "Download the latest version", 0);
                        if (n == 0) {
                            Utility.download(ha, url, outputFile, fileSize, force);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, String.valueOf(outputFile.getAbsolutePath()) + " exists and the application is not allowed to overwrite it.");
                }
            } else {
                Utility.download(ha, url, outputFile, fileSize, force);
            }
        }
    }

    public static long getFileSize(String address, GCAnalyzer ha) {
        String s;
        int fileNameIndex = address.lastIndexOf("/");
        String directoryName = address.substring(0, fileNameIndex);
        String fileName = address.substring(fileNameIndex + 1);
        if (fileName == null) {
            return -1L;
        }
        fileName = fileName.toLowerCase();
        BufferedInputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            try {
                URL url = new URL(directoryName);
                URLConnection urlConnection = url.openConnection();
                is = new BufferedInputStream(urlConnection.getInputStream());
                byte[] buf = new byte[4096];
                int bytesRead = is.read(buf);
                while (bytesRead > -1) {
                    s = new String(buf, 0, bytesRead, "UTF-8");
                    if (s != null) {
                        sb.append(s);
                    }
                    bytesRead = is.read(buf);
                }
            }
            catch (Exception e) {
                ha.handleException(e);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return -1L;
                    }
                }
                return -1L;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1L;
                }
            }
        }
        if (sb.length() > 0) {
            StringTokenizer st = new StringTokenizer(sb.toString(), "\n\r\f");
            while (st.hasMoreTokens()) {
                String name;
                String line = st.nextToken();
                String[] split = line.split("\\s+", 20);
                if (split == null || split.length <= 5 || (name = split[split.length - 1]) == null || !name.toLowerCase().equals(fileName)) continue;
                s = split[split.length - 5];
                long size = -1L;
                try {
                    size = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                return size;
            }
            return -1L;
        }
        return -1L;
    }

    public static void download(final GCAnalyzer ha, final String address, final File file, final long fileSize, final boolean force) {
        SwingWorker<Void, Void> downloadTask = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                block22: {
                    progressMonitorDownload = new ProgressMonitor(ha, "Downloading IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", "", 0, 100);
                    progressMonitorDownload.setMillisToPopup(0);
                    progressMonitorDownload.setMillisToDecideToPopup(0);
                    progressMonitorDownload.setProgress(1);
                    BufferedInputStream is = null;
                    FilterOutputStream os = null;
                    try {
                        try {
                            int i;
                            URL url = new URL(address);
                            URLConnection urlConnection = url.openConnection();
                            is = new BufferedInputStream(urlConnection.getInputStream());
                            os = new BufferedOutputStream(new FileOutputStream(file.getName()));
                            int bytes = 0;
                            while ((i = is.read()) != -1) {
                                ((BufferedOutputStream)os).write(i);
                                int progress = (int)(100.0f * (float)bytes / (float)fileSize);
                                if (progress > 1) {
                                    progressMonitorDownload.setProgress(progress);
                                }
                                ++bytes;
                            }
                        }
                        catch (Exception e) {
                            ha.handleException(e);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e2) {
                                    ha.handleException(e2);
                                }
                            }
                            if (os == null) break block22;
                            try {
                                os.close();
                            }
                            catch (IOException e3) {
                                ha.handleException(e3);
                            }
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                ha.handleException(e);
                            }
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException e) {
                                ha.handleException(e);
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            public void done() {
                progressMonitorDownload.setProgress(progressMonitorDownload.getMaximum());
                if (force) {
                    Utility.start(ha, file.getAbsolutePath());
                } else {
                    int o = JOptionPane.showConfirmDialog(ha, "Downloaded " + file.getName() + ". Do you want to restart?", "Restart IBM Pattern Modeling and Analysis Tool for Java Garbage Collector", 0);
                    if (o == 0) {
                        Utility.start(ha, file.getAbsolutePath());
                    }
                }
            }
        };
        downloadTask.execute();
    }

    public static int getVersionNumberFromString(String versionString) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < versionString.length()) {
            if (Character.isDigit(versionString.charAt(i))) {
                sb.append(versionString.charAt(i));
            }
            ++i;
        }
        if (sb.length() == 0) {
            return -1;
        }
        return Integer.parseInt(sb.toString());
    }
}

