/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class BigTask {
    private int lengthOfTask;
    private static int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private HeapInfo hi;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    HeapInfo heapinfo;
    Node node;
    int threshold;
    int adjustedThreshold = -1;
    TreePath tpath;
    private HeapTree ht;
    private Node newNode;
    private TreePath nextPath;
    private Node nextNode;

    public BigTask(HeapTree heapTree, HeapAnalyzer heapAnalyzer, HeapInfo heapInfo, Node node, TreePath treePath) {
        this.ht = heapTree;
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        this.node = node;
        this.tpath = treePath;
        this.lengthOfTask = 1000;
    }

    public int getCurrent() {
        return current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                current = 0;
                BigTask.this.done = false;
                BigTask.this.canceled = false;
                BigTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isEnd(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l == -1L || node.getIndex() == -1 || this.hi.getTotal(l) == (long)this.hi.getSize((int)l);
    }

    public boolean isRealDrop(Node node) {
        float f = 0.5f;
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        if (l != -1L && node.getIndex() != -1) {
            System.out.println(this.hi.getTotal(l) + "/" + this.hi.getTotal(node.getIndex()) + ":" + (float)this.hi.getTotal(l) / (float)this.hi.getTotal(node.getIndex()));
            if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(node.getIndex()) <= f) {
                System.out.println("TRUE");
                return true;
            }
        }
        System.out.println("FALSE");
        return false;
    }

    public boolean isRealDrop(Node node, TreePath treePath) {
        float f = 0.5f;
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l != -1L && node.getIndex() != -1 && (float)this.hi.getTotal(l) / ((float)this.hi.getTotal(node.getIndex()) - (float)this.hi.getTotal(l)) <= f;
    }

    public TreePath returnBigDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) <= (long)n) {
            int n2 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
            this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
        } else {
            this.adjustedThreshold = -1;
        }
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public TreePath returnOneDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) == (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                this.nextNode = new Node((int)l);
                vector.addElement(this.nextNode);
                Object[] objectArray3 = vector.toArray();
                Object[] objectArray4 = new Node[objectArray3.length];
                for (int i = 0; i < objectArray3.length; ++i) {
                    objectArray4[i] = (Node)objectArray3[i];
                }
                this.nextPath = new TreePath(objectArray4);
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public long returnTreeDepth(long l) {
        long l2 = 0L;
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return -1L;
        }
        if (this.hi.isHav()) {
            long l3 = 0L;
            while ((l3 = this.hi.getHav().getParent(l)) >= 0L) {
                ++l2;
                l = l3;
            }
        } else {
            while (this.hi.getParent()[(int)l] >= 0) {
                ++l2;
                l = this.hi.getParent()[(int)l];
            }
        }
        return l2;
    }

    public TreePath returnTreePath(long l) {
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        if (this.hi.isHav()) {
            vector.add(0, new Node(true, l));
            long l2 = 0L;
            while ((l2 = this.hi.getHav().getParent(l)) >= 0L) {
                vector.add(0, new Node(true, l2));
                l = l2;
            }
        } else {
            vector.add(0, new Node((int)l));
            while (this.hi.getParent()[(int)l] >= 0) {
                vector.add(0, new Node(this.hi.getParent()[(int)l]));
                l = this.hi.getParent()[(int)l];
            }
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public long returnBiggestDrop(Node node) {
        long l = 0L;
        long l2 = 0L;
        if (this.hi.isHav()) {
            long l3;
            while ((l3 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && (l2 = this.hi.getHav().getTotal(node.getLocation()) - this.hi.getHav().getTotal(l3)) > l) {
                    l = l2;
                    this.newNode = node;
                }
                node = new Node(true, l3);
                if (l3 != -1L) continue;
                node.setIndex(-1);
            }
        } else {
            long l4;
            while ((l4 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l4) > l) {
                    l = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l4);
                    this.newNode = node;
                }
                node = new Node((int)l4);
            }
        }
        return l;
    }

    public TreePath returnBiggestDrop(Node node, long l, TreePath treePath) {
        long l2;
        long l3 = 0L;
        Node node2 = node;
        Vector vector = new Vector(1);
        while ((l2 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l2) > l3) {
                l3 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l2);
            }
            node = new Node((int)l2);
        }
        return null;
    }

    public long returnBiggestDrop(Node node, TreePath treePath) {
        long l;
        long l2 = 0L;
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
                this.newNode = node;
            }
            node = new Node((int)l);
        }
        return l2;
    }

    public long returnOneDrop(Node node, long l) {
        Vector vector = new Vector(1);
        if (this.hi.isHav()) {
            long l2;
            while ((l2 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && this.hi.getHav().getTotal(node.getLocation()) - this.hi.getHav().getTotal(l2) == l) {
                    return l2;
                }
                if (this.hi.getHav().getTotal(l2) < l) {
                    return -2L;
                }
                node = new Node(true, l2);
                if (l2 == -1L) {
                    node.setIndex(-1);
                }
                ++current;
            }
        } else {
            long l3;
            while ((l3 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l3) == l) {
                    return l3;
                }
                if (this.hi.getTotal(l3) < l) {
                    return -2L;
                }
                node = new Node((int)l3);
                ++current;
            }
        }
        return -2L;
    }

    class ActualTask {
        ActualTask() {
            current = 0;
            BigTask.this.ha.dp.setProgressText("   Traversing trees...");
            BigTask.this.ha.dp.setTitle("Searching for the largest drop in subtrees");
            long l = BigTask.this.returnOneDrop(BigTask.this.node, BigTask.this.returnBiggestDrop(BigTask.this.node));
            if (l == -2L) {
                BigTask.this.ha.dp.hide();
                JOptionPane.showMessageDialog(BigTask.this.ha, "Cannot locate any drop", "Locate the largest drop", 1);
                return;
            }
            BigTask.this.ha.dp.setTitle("Found the largest total size drop");
            BigTask.this.done = true;
            if (BigTask.this.returnTreeDepth(l) > HeapAnalyzer.MAX_VIEW_SIZE) {
                ((BigTask)BigTask.this).ht.moreParentsMenuItem.setEnabled(true);
                ((BigTask)BigTask.this).ht.showFromRootsMenuItem.setEnabled(true);
                Vector<Node> vector = new Vector<Node>();
                int n = 0;
                Node node = null;
                if (BigTask.this.hi.isHav()) {
                    vector.add(0, new Node(true, l));
                    long l2 = 0L;
                    while ((l2 = BigTask.this.hi.getHav().getParent(l)) >= 0L && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(true, l2));
                        l = l2;
                        ++n;
                    }
                    node = new Node(true, l2, (int)HeapAnalyzer.MAX_SUBTREE);
                    vector.add(0, node);
                } else {
                    vector.add(0, new Node((int)l));
                    while (BigTask.this.hi.getParent()[(int)l] >= 0 && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(BigTask.this.hi.getParent()[(int)l]));
                        l = BigTask.this.hi.getParent()[(int)l];
                        ++n;
                    }
                    node = new Node(BigTask.this.hi.getParent()[(int)l], (int)HeapAnalyzer.MAX_SUBTREE);
                    vector.add(0, node);
                }
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray2);
                if (treePath == null) {
                    return;
                }
                Node node2 = ((HeapModel)((BigTask)BigTask.this).ht.getModel()).rootPerson;
                ((HeapModel)((BigTask)BigTask.this).ht.getModel()).rootPerson = node;
                ((HeapModel)BigTask.this.ht.getModel()).fireTreeStructureChanged(node2);
                BigTask.this.ht.scrollPathToVisible(treePath);
                BigTask.this.ht.setSelectionPath(treePath);
                BigTask.this.ha.dp.hide();
            } else {
                Object object;
                ((BigTask)BigTask.this).ht.moreParentsMenuItem.setEnabled(false);
                ((BigTask)BigTask.this).ht.showFromRootsMenuItem.setEnabled(false);
                if (((HeapModel)((BigTask)BigTask.this).ht.getModel()).rootPerson.getIndex() != -1) {
                    object = new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
                    Node node = ((HeapModel)((BigTask)BigTask.this).ht.getModel()).rootPerson;
                    ((HeapModel)((BigTask)BigTask.this).ht.getModel()).rootPerson = object;
                    ((HeapModel)BigTask.this.ht.getModel()).fireTreeStructureChanged(node);
                }
                if ((object = BigTask.this.returnTreePath(l)) == null) {
                    return;
                }
                BigTask.this.ht.scrollPathToVisible((TreePath)object);
                BigTask.this.ht.setSelectionPath((TreePath)object);
                BigTask.this.ha.dp.hide();
            }
        }
    }
}

