/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JPanel;

public class ChartPanel
extends JPanel {
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final Color blue = Color.blue;
    private long[] table;
    private String[] label = new String[]{"0", "10", "100", "1K", "10K", "100K", "1M", "10M", "100M", "1G"};

    public ChartPanel() {
    }

    public ChartPanel(long[] lArray) {
        this.table = lArray;
    }

    public ChartPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public ChartPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public ChartPanel(boolean bl) {
        super(bl);
    }

    public int get10(long l) {
        int n = 0;
        while ((l /= 10L) >= 1L) {
            ++n;
        }
        return n;
    }

    public int getFirstDigit(long l) {
        int n = 0;
        long l2 = l;
        while ((l /= 10L) >= 1L) {
            l2 = l;
            ++n;
        }
        return (int)l2;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        long l = this.table[0];
        for (n2 = 1; n2 < this.table.length; ++n2) {
            if (this.table[n2] <= l) continue;
            l = this.table[n2];
        }
        n2 = this.get10(l);
        int n3 = this.getFirstDigit(l);
        long l2 = (long)Math.pow(10.0, n2) * (long)n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Color color = Color.lightGray;
        graphics2D.setPaint(color);
        graphics2D.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        graphics2D.draw3DRect(3, 3, dimension.width - 7, dimension.height - 7, false);
        graphics2D.setPaint(fg);
        int n4 = 50;
        int n5 = 50;
        int n6 = (dimension.width - n4 - 10) / 10;
        int n7 = dimension.height - 14 - n5;
        int n8 = n6;
        graphics2D.draw3DRect(n4, n5, dimension.width - n4 - 14, n7 - n5, true);
        graphics2D.drawString("Gap size (byte)", (dimension.width - n4) / 2 - 14, dimension.height - n5 + 20);
        graphics2D.drawString("Number of gaps by size", dimension.width / 2 - n4 - 30, 30);
        int n9 = n3;
        if (n3 == 1) {
            n9 = 10;
        }
        for (n = 0; n < n9; ++n) {
            float f = (float)((double)n7 - (double)(n7 - n5) * ((double)l2 / (double)l));
            graphics2D.draw(new Line2D.Double(50.0, f, dimension.width - 14, f));
            graphics2D.drawString(numberFormatter.format(l2), 10.0f, f);
            if (n3 == 1) {
                l2 -= (long)Math.pow(10.0, n2 - 1);
                continue;
            }
            l2 -= (long)Math.pow(10.0, n2);
        }
        n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            double d = (double)(n7 - n5) * ((double)this.table[i] / (double)l);
            GradientPaint gradientPaint = new GradientPaint((float)n4 + 1.0f, (float)((double)n7 - d), blue, (float)n4 + 1.0f, n7, white);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(new Rectangle2D.Double(n4 + 1, (double)n7 - d, n8, (double)(n7 - n5) * ((double)this.table[i] / (double)l)));
            graphics2D.setPaint(blue);
            graphics2D.drawString(numberFormatter.format(this.table[i]), (float)n4 + 1.0f, (float)((double)n7 - d) - 5.0f);
            graphics2D.setPaint(fg);
            graphics2D.drawString(this.label[n++], (float)n4 - 10.0f, (float)(dimension.height - n5));
            n4 += n6;
        }
        graphics2D.setPaint(fg);
    }
}

