/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class ConsolePrintStream
extends PrintStream {
    JTextArea text;

    public ConsolePrintStream(OutputStream outputStream) {
        super(outputStream);
    }

    public ConsolePrintStream(OutputStream outputStream, JTextArea jTextArea) {
        super(outputStream);
        this.text = jTextArea;
    }

    public ConsolePrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public ConsolePrintStream(JTextArea jTextArea) {
        super(new PipedOutputStream());
        this.text = jTextArea;
    }

    public void print(char[] cArray) {
        if (cArray != null) {
            this.text.append(new String(cArray, 0, cArray.length));
        }
        this.scroll();
    }

    public void print(char c) {
        this.text.append(c + "");
        this.scroll();
    }

    public void print(double d) {
        this.text.append(d + "");
        this.scroll();
    }

    public void print(float f) {
        this.text.append(f + "");
        this.scroll();
    }

    public void print(int n) {
        this.text.append(n + "");
        this.scroll();
    }

    public void print(Object object) {
        if (object != null) {
            this.text.append(object.toString());
        } else {
            this.text.append("null");
        }
        this.scroll();
    }

    public void print(String string) {
        if (string != null) {
            this.text.append(string);
        } else {
            this.text.append("null");
        }
        this.scroll();
    }

    public void print(boolean bl) {
        this.text.append(bl + "");
        this.scroll();
    }

    public void println(char[] cArray) {
        if (cArray != null) {
            this.text.append(new String(cArray, 0, cArray.length) + "\n");
        }
        this.scroll();
    }

    public void println(char c) {
        this.text.append(c + "\n");
        this.scroll();
    }

    public void println(double d) {
        this.text.append(d + "\n");
        this.scroll();
    }

    public void println(float f) {
        this.text.append(f + "\n");
        this.scroll();
    }

    public void println(int n) {
        this.text.append(n + "\n");
        this.scroll();
    }

    public void println(Object object) {
        if (object != null) {
            this.text.append(object.toString() + "\n");
        } else {
            this.text.append("null\n");
        }
        this.scroll();
    }

    public void println(String string) {
        if (string != null) {
            this.text.append(string + "\n");
        } else {
            this.text.append("null\n");
        }
        this.scroll();
    }

    public void println(boolean bl) {
        this.text.append(bl + "\n");
        this.scroll();
    }

    private void scroll() {
        this.text.setCaretPosition(this.text.getDocument().getLength());
    }
}

