/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DirectBuffer {
    static final int BUFFER_SIZE = 100000000;
    private MappedByteBuffer[] buffer;
    private long position = 0L;
    private long fileChannelPosition = 0L;
    private FileChannel fileChannel = null;
    private int numberOfBuffers = 0;

    int allocateDirect(long l) {
        if (l <= 0L) {
            return -1;
        }
        int n = (int)(l / 100000000L);
        if (l % 100000000L != 0L) {
            ++n;
        }
        this.setNumberOfBuffers(n);
        this.setBuffer(new MappedByteBuffer[this.getNumberOfBuffers()]);
        int n2 = 0;
        for (n2 = 0; n2 < this.getNumberOfBuffers() - 1; ++n2) {
            this.setBuffer((MappedByteBuffer)ByteBuffer.allocateDirect(100000000), n2);
        }
        if (l % 100000000L != 0L) {
            this.setBuffer((MappedByteBuffer)ByteBuffer.allocateDirect((int)(l % 100000000L)), n2);
        } else {
            this.setBuffer((MappedByteBuffer)ByteBuffer.allocateDirect(100000000), n2);
        }
        return this.getNumberOfBuffers();
    }

    synchronized DirectBuffer putLong(long l) {
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n < 8) {
            byte[] byArray = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                mappedByteBuffer.put(byArray[n2]);
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n2 < 8) {
                    mappedByteBuffer.put(byArray[n2]);
                    ++n2;
                }
            }
        } else {
            mappedByteBuffer.putLong(l);
        }
        this.setPosition(this.getPosition() + 8L);
        return this;
    }

    synchronized long getLong() {
        long l = 0L;
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n < 8) {
            byte[] byArray = new byte[8];
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = mappedByteBuffer.get();
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n2 < 8) {
                    byArray[n2] = mappedByteBuffer.get();
                    ++n2;
                }
            }
            l = (0xFF & byArray[0]) << 56 | (0xFF & byArray[1]) << 48 | (0xFF & byArray[2]) << 40 | (0xFF & byArray[3]) << 32 | (0xFF & byArray[4]) << 24 | (0xFF & byArray[5]) << 16 | (0xFF & byArray[6]) << 8 | 0xFF & byArray[7];
        } else {
            l = mappedByteBuffer.getLong();
        }
        this.setPosition(this.getPosition() + 8L);
        return l;
    }

    synchronized DirectBuffer putInt(int n) {
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n2 = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n2 < 4) {
            byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            int n3 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                mappedByteBuffer.put(byArray[n3]);
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n3 < 4) {
                    mappedByteBuffer.put(byArray[n3]);
                    ++n3;
                }
            }
        } else {
            mappedByteBuffer.putInt(n);
        }
        this.setPosition(this.getPosition() + 4L);
        return this;
    }

    synchronized int getInt() {
        int n = 0;
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n2 = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n2 < 4) {
            byte[] byArray = new byte[4];
            int n3 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                byArray[n3] = mappedByteBuffer.get();
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n3 < 4) {
                    byArray[n3] = mappedByteBuffer.get();
                    ++n3;
                }
            }
            n = (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        } else {
            n = mappedByteBuffer.getInt();
        }
        this.setPosition(this.getPosition() + 4L);
        return n;
    }

    synchronized DirectBuffer putShort(short s) {
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n < 2) {
            byte[] byArray = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                mappedByteBuffer.put(byArray[n2]);
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n2 < 2) {
                    mappedByteBuffer.put(byArray[n2]);
                    ++n2;
                }
            }
        } else {
            mappedByteBuffer.putShort(s);
        }
        this.setPosition(this.getPosition() + 2L);
        return this;
    }

    synchronized short getShort() {
        short s = 0;
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        int n = mappedByteBuffer.limit() - mappedByteBuffer.position();
        if (n < 2) {
            byte[] byArray = new byte[2];
            int n2 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = mappedByteBuffer.get();
            }
            mappedByteBuffer = this.getNextBuffer();
            if (mappedByteBuffer != null) {
                while (n2 < 2) {
                    byArray[n2] = mappedByteBuffer.get();
                    ++n2;
                }
            }
            s = (short)((0xFF & byArray[0]) << 8 | 0xFF & byArray[1]);
        } else {
            s = mappedByteBuffer.getShort();
        }
        this.setPosition(this.getPosition() + 2L);
        return s;
    }

    synchronized DirectBuffer put(byte by) {
        int n;
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        if (mappedByteBuffer == null) {
            System.out.println("Null buffer");
        }
        if ((n = mappedByteBuffer.limit() - mappedByteBuffer.position()) < 1) {
            mappedByteBuffer = this.getNextBuffer();
        }
        if (mappedByteBuffer != null) {
            mappedByteBuffer.put(by);
            this.setPosition(this.getPosition() + 1L);
        }
        return this;
    }

    synchronized byte get() {
        int n;
        byte by = 0;
        MappedByteBuffer mappedByteBuffer = this.getCurrentBuffer();
        if (mappedByteBuffer == null) {
            System.out.println("Null buffer");
        }
        if ((n = mappedByteBuffer.limit() - mappedByteBuffer.position()) < 1) {
            mappedByteBuffer = this.getNextBuffer();
        }
        if (mappedByteBuffer != null) {
            by = mappedByteBuffer.get();
            this.setPosition(this.getPosition() + 1L);
        }
        return by;
    }

    synchronized String readUTF() {
        short s = this.getShort();
        int n = s & 0xFFFF;
        return this.readUTF(n);
    }

    synchronized String readUTF(int n) {
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.get();
        }
        return new String(byArray);
    }

    synchronized MappedByteBuffer getCurrentBuffer() {
        int n = (int)(this.getPosition() / 100000000L);
        if (n >= this.getNumberOfBuffers()) {
            return null;
        }
        MappedByteBuffer mappedByteBuffer = this.getBuffer(n);
        int n2 = (int)(this.position % 100000000L);
        if (mappedByteBuffer.position() != n2) {
            try {
                mappedByteBuffer.position(n2);
            }
            catch (Exception exception) {
                System.out.println("setPosition error newPosition=" + n2 + " limit=" + mappedByteBuffer.limit() + " capacity=" + mappedByteBuffer.capacity());
                exception.printStackTrace();
            }
        }
        return mappedByteBuffer;
    }

    synchronized MappedByteBuffer getNextBuffer() {
        int n = 1 + (int)(this.getPosition() / 100000000L);
        if (n >= this.getNumberOfBuffers()) {
            return null;
        }
        MappedByteBuffer mappedByteBuffer = this.getBuffer(n);
        mappedByteBuffer.rewind();
        return mappedByteBuffer;
    }

    synchronized void setPosition(long l) {
        this.position = l;
    }

    synchronized long getPosition() {
        return this.position;
    }

    synchronized long position() {
        return this.getPosition();
    }

    synchronized void position(long l) {
        this.setPosition(l);
    }

    void setBuffer(MappedByteBuffer mappedByteBuffer, int n) {
        this.buffer[n] = mappedByteBuffer;
    }

    void setBuffer(MappedByteBuffer[] mappedByteBufferArray) {
        this.buffer = mappedByteBufferArray;
    }

    MappedByteBuffer getBuffer(int n) {
        return this.buffer[n];
    }

    synchronized DirectBuffer flip() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.getBuffer(i).flip();
        }
        this.setPosition(0L);
        return this;
    }

    synchronized DirectBuffer rewind() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.getBuffer(i).rewind();
        }
        this.setPosition(0L);
        return this;
    }

    public void setNumberOfBuffers(int n) {
        this.numberOfBuffers = n;
    }

    public int getNumberOfBuffers() {
        return this.numberOfBuffers;
    }

    public int map(FileChannel fileChannel, FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        long l3 = l;
        if (l2 <= 0L) {
            return -1;
        }
        int n = (int)(l2 / 100000000L);
        if (l2 % 100000000L != 0L) {
            ++n;
        }
        this.setNumberOfBuffers(n);
        this.setBuffer(new MappedByteBuffer[this.getNumberOfBuffers()]);
        this.setFileChannel(fileChannel);
        this.setFileChannelPosition(l);
        int n2 = 0;
        for (n2 = 0; n2 < this.getNumberOfBuffers() - 1; ++n2) {
            this.setBuffer(fileChannel.map(mapMode, l3, 100000000L), n2);
            l3 += 100000000L;
        }
        if (l2 % 100000000L != 0L) {
            this.setBuffer(fileChannel.map(mapMode, l3, l2 % 100000000L), n2);
        } else {
            this.setBuffer(fileChannel.map(mapMode, l3, 100000000L), n2);
        }
        return this.getNumberOfBuffers();
    }

    void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    FileChannel getFileChannel() {
        return this.fileChannel;
    }

    void setFileChannelPosition(long l) {
        this.fileChannelPosition = l;
    }

    long getFileChannelPosition() {
        return this.fileChannelPosition;
    }

    int readInt() {
        return this.getInt();
    }

    int readUnsignedByte() {
        byte by = this.get();
        int n = by & 0xFF;
        return n;
    }

    int readUnsignedShort() {
        short s = this.getShort();
        int n = s & 0xFFFF;
        return n;
    }

    long readLong() {
        return this.getLong();
    }

    byte readByte() {
        return this.get();
    }

    void close() {
        this.buffer = null;
    }

    short readShort() {
        return this.getShort();
    }

    public DirectBuffer write(long l) {
        if (l == -1L) {
            this.put((byte)127);
            return this;
        }
        if (l < 127L) {
            this.put((byte)l);
        } else if (l <= 16383L) {
            this.putShort((short)(l | 0x8000L));
        } else if (l <= 0x1FFFFFL) {
            this.put((byte)(l >> 16 | 0xC0L));
            this.putShort((short)(l & 0xFFFFL));
        } else if (l <= 0xFFFFFFFL) {
            this.putInt((int)(l | 0xFFFFFFFFE0000000L));
        } else if (l <= 0x7FFFFFFFFL) {
            this.put((byte)(l >> 32 | 0xF0L));
            this.putInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        } else if (l <= 0x3FFFFFFFFFFL) {
            this.putShort((short)(l >> 32 | 0xF800L));
            this.putInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.putLong(l | 0xFC00000000000000L);
        }
        return this;
    }

    public static byte getSize(long l) {
        if (l < 127L) {
            return 1;
        }
        if (l <= 16383L) {
            return 2;
        }
        if (l <= 0x1FFFFFL) {
            return 3;
        }
        if (l <= 0xFFFFFFFL) {
            return 4;
        }
        if (l <= 0x7FFFFFFFFL) {
            return 5;
        }
        if (l <= 0x3FFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    public static byte getSizeForName(long l) {
        if (l < 31L) {
            return 1;
        }
        if (l <= 4095L) {
            return 2;
        }
        if (l <= 524287L) {
            return 3;
        }
        if (l <= 0x3FFFFFFL) {
            return 4;
        }
        if (l <= 0x1FFFFFFFFL) {
            return 5;
        }
        if (l <= 0xFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    public static byte getSize3bit(long l) {
        if (l <= 63L) {
            return 1;
        }
        if (l <= 8191L) {
            return 2;
        }
        if (l <= 0x1FFFFFL) {
            return 3;
        }
        if (l <= 0x1FFFFFFFL) {
            return 4;
        }
        if (l <= 0x1FFFFFFFFFL) {
            return 5;
        }
        if (l <= 0x1FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    public long read() {
        long l = 0L;
        byte by = this.get();
        if ((by & 0x80) != 128) {
            if (by == 127) {
                return -1L;
            }
            return by;
        }
        if ((by & 0xC0) == 128) {
            byte by2 = this.get();
            return by2 & 0xFF | (by & 0x7F) << 8;
        }
        if ((by & 0xE0) == 192) {
            short s = this.getShort();
            return s & 0xFFFF | (by & 0x1F) << 16;
        }
        if ((by & 0xF0) == 224) {
            byte by3 = this.get();
            short s = this.getShort();
            return s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 0xF) << 24;
        }
        if ((by & 0xF8) == 240) {
            int n = this.getInt();
            return (long)n & 0xFFFFFFFFL | (long)((by & 7) << 32);
        }
        if ((by & 0xFC) == 248) {
            byte by4 = this.get();
            int n = this.getInt();
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)((by & 3) << 40);
        }
        short s = this.getShort();
        int n = this.getInt();
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)((by & 3) << 48);
    }

    public DirectBuffer writeName(boolean bl, boolean bl2, long l) {
        if (l == -1L) {
            this.put((byte)31);
            return this;
        }
        int n = 0;
        if (bl) {
            n = (byte)(n | 0x80);
        }
        if (bl2) {
            n = (byte)(n | 0x40);
        }
        if (l < 31L) {
            this.put((byte)((byte)(n & 0xFF) | (byte)l));
        } else if (l <= 4095L) {
            this.putShort((short)((short)((n & 0xFF) << 8) | (short)(l | 0x2000L)));
        } else if (l <= 524287L) {
            this.put((byte)((byte)(n & 0xFF) | (byte)(l >> 16 | 0x30L)));
            this.putShort((short)(l & 0xFFFFL));
        } else if (l <= 0x3FFFFFFL) {
            this.putInt((byte)(n & 0xFF) << 24 | (int)(l | 0x38000000L));
        } else if (l <= 0x1FFFFFFFFL) {
            this.put((byte)((byte)(n & 0xFF) | (byte)(l >> 32 | 0x3CL)));
            this.putInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        } else if (l <= 0xFFFFFFFFFFL) {
            this.putShort((short)((short)((n & 0xFF) << 8) | (short)(l >> 32 | 0x3E00L)));
            this.putInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.putLong((long)((byte)(n & 0xFF) << 56) | l | 0x3F00000000000000L);
        }
        return this;
    }

    public long readName() {
        long l = 0L;
        byte by = this.get();
        if ((by & 0x20) != 32) {
            if ((by & 0x1F) == 31) {
                return -1L;
            }
            return (long)(by & 0x3F) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x30) == 32) {
            byte by2 = this.get();
            long l2 = by2 & 0xFF | (by & 0x1F) << 8 | (by & 0xC0) << 56;
            return (long)(by2 & 0xFF | (by & 0x1F) << 8) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x38) == 48) {
            short s = this.getShort();
            long l3 = s & 0xFFFF | (by & 0xF) << 16 | (by & 0xC0) << 56;
            return (long)(s & 0xFFFF | (by & 0xF) << 16) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3C) == 56) {
            byte by3 = this.get();
            short s = this.getShort();
            long l4 = (long)(s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 3) << 24) | (long)(by & 0xC0) << 56;
            return (long)(s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 3) << 24) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3E) == 60) {
            int n = this.getInt();
            long l5 = (long)n & 0xFFFFFFFFL | (long)((by & 1) << 32) | (long)((by & 0xC0) << 56);
            return (long)n & 0xFFFFFFFFL | (long)((by & 1) << 32) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3F) == 62) {
            byte by4 = this.get();
            int n = this.getInt();
            long l6 = (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)((by & 0xC0) << 56);
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)(by & 0xC0) << 56;
        }
        byte by5 = this.get();
        short s = this.getShort();
        int n = this.getInt();
        long l7 = (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)(by5 << 48) | (long)((by & 0xC0) << 56);
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)(by5 << 48) | (long)(by & 0xC0) << 56;
    }
}

