/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class DropTask {
    private int lengthOfTask;
    private static int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private HeapInfo hi;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    HeapInfo heapinfo;
    Node node;
    int threshold;
    int adjustedThreshold = -1;
    TreePath tpath;
    private HeapTree ht;

    public DropTask(HeapTree heapTree, HeapAnalyzer heapAnalyzer, HeapInfo heapInfo, Node node, int n, TreePath treePath) {
        this.ht = heapTree;
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        this.node = node;
        this.threshold = n;
        this.tpath = treePath;
        this.lengthOfTask = 1000;
    }

    public int getCurrent() {
        return current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                current = 0;
                DropTask.this.done = false;
                DropTask.this.canceled = false;
                DropTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public long returnBigDrop(Node node, int n) {
        Vector vector = new Vector(1);
        if (this.hi.isHav()) {
            long l;
            if (node.getIndex() != -1 && this.hi.getHav().getTotal(node.getLocation()) <= (long)n) {
                int n2 = (int)(Math.log(this.hi.getHav().getTotal(node.getLocation())) / Math.log(10.0));
                this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
            } else {
                this.adjustedThreshold = -1;
            }
            while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && this.hi.getHav().getTotal(node.getLocation()) - this.hi.getHav().getTotal(l) >= (long)n) {
                    return l;
                }
                if (this.hi.getHav().getTotal(l) < (long)n) {
                    return -2L;
                }
                node = new Node(true, l);
                ++current;
            }
        } else {
            long l;
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) <= (long)n) {
                int n3 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
                this.adjustedThreshold = n = (int)Math.pow(10.0, n3);
            } else {
                this.adjustedThreshold = -1;
            }
            while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
                if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                    return l;
                }
                if (this.hi.getTotal(l) < (long)n) {
                    return -2L;
                }
                node = new Node((int)l);
                ++current;
            }
        }
        return -2L;
    }

    public TreePath returnBigDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) <= (long)n) {
            int n2 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
            this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
        } else {
            this.adjustedThreshold = -1;
        }
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public long returnTreeDepth(long l) {
        long l2 = 0L;
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return -1L;
        }
        if (this.hi.isHav()) {
            while (this.hi.getHav().getParent(l) >= 0L) {
                ++l2;
                l = this.hi.getHav().getParent(l);
            }
        } else {
            while (this.hi.getParent()[(int)l] >= 0) {
                ++l2;
                l = this.hi.getParent()[(int)l];
            }
        }
        return l2;
    }

    public TreePath returnTreePath(long l) {
        Object[] objectArray = null;
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        if (this.hi.isHav()) {
            long l2 = 0L;
            vector.add(0, new Node(true, l));
            while ((l2 = this.hi.getHav().getParent(l)) >= 0L) {
                vector.add(0, new Node(true, l2));
                l = l2;
            }
            objectArray = this.ht.getPathForRow(0).getPath();
            vector.add(0, (Node)objectArray[0]);
        } else {
            vector.add(0, new Node((int)l));
            while (this.hi.getParent()[(int)l] >= 0) {
                vector.add(0, new Node(this.hi.getParent()[(int)l]));
                l = this.hi.getParent()[(int)l];
            }
            objectArray = this.ht.getPathForRow(0).getPath();
            vector.add(0, (Node)objectArray[0]);
        }
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    class ActualTask {
        ActualTask() {
            current = 0;
            DropTask.this.ha.dp.setProgressText("   Traversing trees...");
            DropTask.this.ha.dp.setTitle("Searching for total size drop");
            long l = DropTask.this.returnBigDrop(DropTask.this.node, DropTask.this.threshold);
            if (l == -2L) {
                DropTask.this.ha.dp.hide();
                if (DropTask.this.adjustedThreshold == -1) {
                    JOptionPane.showMessageDialog(DropTask.this.ha, "Cannot find any size drop with the threshold : " + numberFormatter.format(HeapAnalyzer.MIN_DROP) + " byte(s). Reduce the threshold.", "Search for total size drop", 1);
                } else {
                    JOptionPane.showMessageDialog(DropTask.this.ha, "Cannot find any size drop with the self-adjusted threshold : " + numberFormatter.format(DropTask.this.adjustedThreshold) + " byte(s). Reduce default threshold.", "Search for total size drop", 1);
                }
                return;
            }
            DropTask.this.ha.dp.setTitle("Found a total size drop");
            DropTask.this.done = true;
            if (DropTask.this.returnTreeDepth(l) > HeapAnalyzer.MAX_VIEW_SIZE) {
                ((DropTask)DropTask.this).ht.moreParentsMenuItem.setEnabled(true);
                ((DropTask)DropTask.this).ht.showFromRootsMenuItem.setEnabled(true);
                Vector<Node> vector = new Vector<Node>();
                if (DropTask.this.hi.isHav()) {
                    vector.add(0, new Node(true, l));
                } else {
                    vector.add(0, new Node((int)l));
                }
                int n = 0;
                Node node = null;
                if (DropTask.this.hi.isHav()) {
                    long l2 = 0L;
                    while ((l2 = DropTask.this.hi.getHav().getParent(l)) >= 0L && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(true, l2));
                        l = l2;
                        ++n;
                    }
                    node = new Node(true, DropTask.this.hi.getHav().getParent(l), (int)HeapAnalyzer.MAX_SUBTREE);
                    vector.add(0, node);
                } else {
                    while (DropTask.this.hi.getParent()[(int)l] >= 0 && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(DropTask.this.hi.getParent()[(int)l]));
                        l = DropTask.this.hi.getParent()[(int)l];
                        ++n;
                    }
                    node = new Node(DropTask.this.hi.getParent()[(int)l], (int)HeapAnalyzer.MAX_SUBTREE);
                    vector.add(0, node);
                }
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray2);
                if (treePath == null) {
                    return;
                }
                Node node2 = ((HeapModel)((DropTask)DropTask.this).ht.getModel()).rootPerson;
                ((HeapModel)((DropTask)DropTask.this).ht.getModel()).rootPerson = node;
                ((HeapModel)DropTask.this.ht.getModel()).fireTreeStructureChanged(node2);
                DropTask.this.ht.scrollPathToVisible(treePath);
                DropTask.this.ht.setSelectionPath(treePath);
                DropTask.this.ha.dp.hide();
            } else {
                Object object;
                ((DropTask)DropTask.this).ht.moreParentsMenuItem.setEnabled(false);
                ((DropTask)DropTask.this).ht.showFromRootsMenuItem.setEnabled(false);
                if (((HeapModel)((DropTask)DropTask.this).ht.getModel()).rootPerson.getIndex() != -1) {
                    object = new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
                    Node node = ((HeapModel)((DropTask)DropTask.this).ht.getModel()).rootPerson;
                    ((HeapModel)((DropTask)DropTask.this).ht.getModel()).rootPerson = object;
                    ((HeapModel)DropTask.this.ht.getModel()).fireTreeStructureChanged(node);
                }
                if ((object = DropTask.this.returnTreePath(l)) == null) {
                    return;
                }
                DropTask.this.ht.scrollPathToVisible((TreePath)object);
                DropTask.this.ht.setSelectionPath((TreePath)object);
                DropTask.this.ha.dp.hide();
            }
        }
    }
}

