/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.tree.TreePath;

public class ExpandTask {
    private int lengthOfTask;
    private static int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private HeapInfo hi;
    Hashtable listOfSuspects = new Hashtable();
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    HeapInfo heapinfo;
    Node node;
    int adjustedThreshold = -1;
    TreePath tpath;
    private HeapTree ht;
    private Node newNode;
    private TreePath nextPath;
    private Node nextNode;
    private boolean expand = false;

    public ExpandTask(HeapTree heapTree, HeapAnalyzer heapAnalyzer, TreePath treePath, boolean bl) {
        this.ht = heapTree;
        this.ha = heapAnalyzer;
        this.tpath = treePath;
        this.expand = bl;
        this.lengthOfTask = 1000;
    }

    public void compileLeakSuspects(int n) {
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        boolean bl = false;
        boolean[] blArray = new boolean[this.hi.getAddressLength()];
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(n));
        while (!stack.empty()) {
            int n2 = (Integer)stack.peek();
            bl = false;
            if (this.hi.getChild()[n2] != null) {
                int n3;
                int n4 = heapModel.getChildCount(n2);
                for (int i = 0; i < n4 && this.hi.getTotal(n3 = this.hi.getChild()[n2][i]) >= HeapAnalyzer.MIN_TOTAL_LIMIT && n3 >= 0 && (float)this.hi.getTotal(n3) / (float)this.hi.getTotal(n2) > HeapAnalyzer.MRATIO; ++i) {
                    int n5 = n3;
                    if (blArray[n5]) continue;
                    blArray[n5] = true;
                    stack.push(new Integer(n5));
                    ++current;
                    bl = true;
                }
            }
            if (bl || this.hi.getTotal(n2 = ((Integer)stack.pop()).intValue()) < HeapAnalyzer.MIN_TOTAL_LIMIT || this.hi.getChild()[n2] == null || !((float)this.hi.getTotal(this.hi.getChild()[n2][0]) / (float)this.hi.getTotal(n2) <= HeapAnalyzer.RATIO)) continue;
            this.listOfSuspects.put(new Long(this.hi.getAddress(n2)), new Long(this.hi.getTotal(n2)));
        }
    }

    public int getCurrent() {
        return current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                current = 0;
                ExpandTask.this.done = false;
                ExpandTask.this.canceled = false;
                ExpandTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isEnd(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l == -1L || node.getIndex() == -1 || this.hi.getTotal(l) == (long)this.hi.getSize((int)l);
    }

    public boolean isRealDrop(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        if (l != -1L && node.getIndex() != -1) {
            if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(node.getIndex()) <= HeapAnalyzer.RATIO) {
                return true;
            }
        }
        return false;
    }

    public boolean isRealDrop(Node node, TreePath treePath) {
        float f = 0.5f;
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l != -1L && node.getIndex() != -1 && (float)this.hi.getTotal(l) / ((float)this.hi.getTotal(node.getIndex()) - (float)this.hi.getTotal(l)) <= f;
    }

    public boolean isThereLeakSuspect(int n) {
        int n2;
        current = 0;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        while ((n2 = heapModel.getBiggestRealChild(n)) != -1) {
            if (n != -1) {
                if ((float)this.hi.getTotal(n2) / (float)this.hi.getTotal(n) <= HeapAnalyzer.RATIO) {
                    return true;
                }
            }
            ++current;
            n = n2;
        }
        return false;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    class ActualTask {
        ActualTask() {
            current = 0;
            ExpandTask.this.ha.dp.setProgressText("   Expanding " + numberFormatter.format(ExpandTask.this.tpath.getPath().length) + " trees...");
            ExpandTask.this.ha.dp.setTitle("Please wait while trees are being expanded");
            if (ExpandTask.this.expand) {
                ExpandTask.this.ht.expandPath(ExpandTask.this.tpath);
            }
            ExpandTask.this.ht.scrollPathToVisible(ExpandTask.this.tpath);
            ExpandTask.this.ht.setSelectionPath(ExpandTask.this.tpath);
            ExpandTask.this.done = true;
            ExpandTask.this.ha.dp.hide();
        }
    }
}

