/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FindAddressView;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.SuspectTask;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class FileTask {
    private boolean isHeadless;
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    long startTime = 0L;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    private HeapInfo hi = null;

    public FileTask(HeapAnalyzer heapAnalyzer, File file) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.lengthOfTask = 1000;
    }

    public FileTask(File file) {
        this.file = file;
        this.lengthOfTask = 1000;
        this.setHeadless();
    }

    public FileTask(HeapAnalyzer heapAnalyzer, File file, JDialogProgress jDialogProgress) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = jDialogProgress;
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                FileTask.this.current = 0;
                FileTask.this.done = false;
                FileTask.this.canceled = false;
                FileTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public void done() {
        this.done = true;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public HeapInfo getHeapInfo() {
        return this.hi;
    }

    public InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }

    class ActualTask {
        void processHeapDump() {
            int n;
            int n2;
            int n3;
            int n4;
            String string;
            Cloneable cloneable;
            BufferedReader bufferedReader;
            FileTask.this.startTime = System.currentTimeMillis();
            boolean bl = false;
            long l = 0L;
            long l2 = 0L;
            Boolean bl2 = null;
            long l3 = 0L;
            long l4 = 0L;
            FileTask.this.setHeapInfo(new HeapInfo());
            int n5 = 0;
            boolean bl3 = false;
            FileTask.this.getHeapInfo().setDumpInfo("Heap dump comments :\n");
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Property");
            defaultTableModel.addColumn("Value");
            HeapInfo.addRow2TableModel("Heap dump file name", "" + FileTask.this.file.getAbsoluteFile(), defaultTableModel);
            long l5 = 0L;
            String string2 = new String();
            Vector<Integer> vector = new Vector<Integer>(1);
            int n6 = 0;
            int n7 = 0;
            Object var27_15 = null;
            boolean bl4 = false;
            int n8 = 0;
            int n9 = 0;
            boolean bl5 = false;
            n7 = 0;
            FileTask.this.overall = 0;
            FileTask.this.current = 0;
            FileTask.this.statMessage = "Loading heap dump file";
            try {
                long l6 = FileTask.this.file.length();
                bufferedReader = new BufferedReader(new InputStreamReader(FileTask.this.getInputStream(FileTask.this.file)));
                string2 = bufferedReader.readLine();
                ++l3;
                if (string2 != null) {
                    l4 += (long)string2.length();
                }
                while (string2 != null) {
                    if (string2.startsWith("//")) {
                        bl = true;
                    } else if (!string2.startsWith("\t") && string2.startsWith("0x")) {
                        block128: {
                            try {
                                n8 = string2.indexOf(32);
                                if (n8 == -1) {
                                    throw new Exception();
                                }
                                long l7 = string2.startsWith("0x0x") ? FindAddressView.getStringToLong(string2.substring(2, n8)) : FindAddressView.getStringToLong(string2.substring(0, n8));
                                if (l5 == 0L) {
                                    l2 = l7;
                                    l = l7;
                                    break block128;
                                }
                                if (l7 < l2) {
                                    l2 = l7;
                                }
                                if (l7 <= l) break block128;
                                l = l7;
                            }
                            catch (Exception exception) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                if (gregorianCalendar != null) {
                                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                                }
                                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                                exception.printStackTrace();
                                string2 = bufferedReader.readLine();
                                ++l3;
                                continue;
                            }
                        }
                        ++l5;
                        FileTask.this.current = (int)(100.0f * (float)l4 / (float)l6);
                        FileTask.this.overall = (int)(10.0f * (float)l4 / (float)l6);
                    }
                    string2 = bufferedReader.readLine();
                    ++l3;
                    if (string2 != null) {
                        l4 += (long)string2.length();
                    }
                    while (string2 != null && string2.startsWith("\t")) {
                        string2 = bufferedReader.readLine();
                        ++l3;
                        if (string2 == null) continue;
                        l4 += (long)string2.length();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                if (!FileTask.this.isHeadless) {
                    FileTask.this.ha.handleException(exception);
                    FileTask.this.jp.dispose();
                    FileTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            if (l5 > Integer.MAX_VALUE) {
                if (!FileTask.this.isHeadless) {
                    JOptionPane.showMessageDialog(FileTask.this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes", "Error", 2);
                    FileTask.this.jp.dispose();
                    FileTask.this.done = true;
                } else {
                    System.out.println("Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes");
                }
                return;
            }
            FileTask.this.statMessage = "Loading address of heap node";
            FileTask.this.overall = 10;
            if (!FileTask.this.isHeadless) {
                FileTask.this.jp.getJProgressBar1().setMaximum((int)l5);
                FileTask.this.jp.getJProgressBar1().setStringPainted(true);
            }
            FileTask.this.current = 0;
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                cloneable = new GregorianCalendar();
                if (cloneable != null) {
                    System.out.print("[" + ((Calendar)cloneable).getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(l5 * 8L) + " bytes of Java heap.");
            }
            if (l - l2 > Integer.MAX_VALUE) {
                FileTask.this.getHeapInfo().setAddress64(true);
            }
            FileTask.this.getHeapInfo().allocateAddress((int)l5);
            FileTask.this.getHeapInfo().setBaseAddress(l2);
            cloneable = new Hashtable();
            FileTask.this.getHeapInfo().setFile(FileTask.this.file);
            l5 = 0L;
            int n10 = 0;
            n7 = 0;
            l3 = 0L;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(FileTask.this.getInputStream(FileTask.this.file)));
                string2 = bufferedReader.readLine();
                ++l3;
                while (string2 != null) {
                    if (string2.startsWith("//")) {
                        FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + string2 + "\n");
                        HeapInfo.addRow2TableModel("Comment", string2, defaultTableModel);
                    } else if (!string2.startsWith("\t") && string2.startsWith("0x")) {
                        block129: {
                            try {
                                n8 = string2.indexOf(32);
                                if (n8 == -1) {
                                    throw new Exception();
                                }
                                if (string2.startsWith("0x0x")) {
                                    FileTask.this.getHeapInfo().setAddress(n10++, FindAddressView.getStringToLong(string2.substring(2, n8)));
                                } else {
                                    FileTask.this.getHeapInfo().setAddress(n10++, FindAddressView.getStringToLong(string2.substring(0, n8)));
                                }
                                string = string2.substring(string2.indexOf(93, n8) + 2);
                                int n11 = string.indexOf("class ");
                                if (n11 == 0) {
                                    string = string.substring("class ".length());
                                } else {
                                    int n12 = string.indexOf("array of ");
                                    if (n12 == 0) {
                                        string = string.substring("array of ".length());
                                    } else {
                                        int n13 = string.indexOf("CLS ");
                                        if (n13 == 0) {
                                            string = string.substring("CLS ".length());
                                        } else {
                                            n4 = string.indexOf("OBJ ");
                                            if (n4 == 0) {
                                                string = string.substring("OBJ ".length());
                                            }
                                        }
                                    }
                                }
                                bl2 = (Boolean)((Hashtable)cloneable).get(string);
                                if (bl2 != null) break block129;
                                ((Hashtable)cloneable).put(string, new Boolean(true));
                            }
                            catch (Exception exception) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                if (gregorianCalendar != null) {
                                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                                }
                                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                                exception.printStackTrace();
                                string2 = bufferedReader.readLine();
                                ++l3;
                                continue;
                            }
                        }
                        ++l5;
                        ++n7;
                        FileTask.this.current++;
                        FileTask.this.overall = 10 + (int)(18.0f * ((float)FileTask.this.current / (float)FileTask.this.getHeapInfo().getAddressLength()));
                    }
                    string2 = bufferedReader.readLine();
                    ++l3;
                    while (string2 != null && string2.startsWith("\t")) {
                        string2 = bufferedReader.readLine();
                        ++l3;
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                if (!FileTask.this.isHeadless) {
                    FileTask.this.ha.handleException(exception);
                    FileTask.this.jp.dispose();
                    FileTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            FileTask.this.statMessage = "Sorting nodes by address";
            FileTask.this.overall = 28;
            if (FileTask.this.getHeapInfo().isAddress64()) {
                Arrays.sort(FileTask.this.getHeapInfo().getAddressLong());
            } else {
                Arrays.sort(FileTask.this.getHeapInfo().getAddress());
            }
            FileTask.this.getHeapInfo().setNameTable(new String[((Hashtable)cloneable).size()]);
            int n14 = 0;
            Object object = ((Hashtable)cloneable).keys();
            while (object.hasMoreElements()) {
                FileTask.this.getHeapInfo().setNameTable(n14++, (String)object.nextElement());
            }
            ((Hashtable)cloneable).clear();
            cloneable = null;
            FileTask.this.overall = 29;
            Arrays.sort(FileTask.this.getHeapInfo().getNameTable());
            FileTask.this.getHeapInfo().markReferences();
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                object = new GregorianCalendar();
                if (object != null) {
                    System.out.print("[" + ((Calendar)object).getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(FileTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setNameKey(new int[FileTask.this.getHeapInfo().getAddressLength()]);
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                object = new GregorianCalendar();
                if (object != null) {
                    System.out.print("[" + ((Calendar)object).getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(FileTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setSize(new int[FileTask.this.getHeapInfo().getAddressLength()]);
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                object = new GregorianCalendar();
                if (object != null) {
                    System.out.print("[" + ((Calendar)object).getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(FileTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setChild(new int[FileTask.this.getHeapInfo().getAddressLength()][]);
            FileTask.this.statMessage = "Processing heap node";
            FileTask.this.overall = 30;
            FileTask.this.current = 0;
            l3 = 0L;
            bl4 = false;
            n5 = 0;
            n7 = 0;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(FileTask.this.getInputStream(FileTask.this.file)));
                string2 = bufferedReader.readLine();
                ++l3;
                while (string2 != null) {
                    if (!string2.startsWith("//")) {
                        if (string2.startsWith("\t")) {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            if (gregorianCalendar != null) {
                                System.out.print("[" + gregorianCalendar.getTime() + "] ");
                            }
                            System.out.println("Format error while parsing line " + numberFormatter.format(l3) + " : " + string2);
                        } else if (string2.startsWith("0x")) {
                            try {
                                n8 = string2.indexOf(32);
                                if (n8 == -1) {
                                    throw new Exception();
                                }
                                n5 = string2.startsWith("0x0x") ? (FileTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(FileTask.this.getHeapInfo().getAddressLong(), FindAddressView.getStringToLong(string2.substring(2, n8)) - FileTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(FileTask.this.getHeapInfo().getAddress(), (int)(FindAddressView.getStringToLong(string2.substring(2, n8)) - FileTask.this.getHeapInfo().getBaseAddress()))) : (FileTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(FileTask.this.getHeapInfo().getAddressLong(), FindAddressView.getStringToLong(string2.substring(0, n8)) - FileTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(FileTask.this.getHeapInfo().getAddress(), (int)(FindAddressView.getStringToLong(string2.substring(0, n8)) - FileTask.this.getHeapInfo().getBaseAddress())));
                                n9 = string2.indexOf(91, n8) + 1;
                                n8 = string2.indexOf(93, n9);
                                if (n9 >= n8) {
                                    throw new Exception();
                                }
                                FileTask.this.getHeapInfo().setSize(n5, Integer.parseInt(string2.substring(n9, n8)));
                                string = string2.substring(n8 + 2);
                                int n15 = string.indexOf("class ");
                                int n16 = -1;
                                if (n15 == 0) {
                                    string = string.substring("class ".length());
                                } else {
                                    n4 = string.indexOf("array of ");
                                    if (n4 == 0) {
                                        string = string.substring("array of ".length());
                                        FileTask.this.getHeapInfo().setSize(n5, FileTask.this.getHeapInfo().getSize(n5) | Integer.MIN_VALUE);
                                    } else {
                                        n16 = string.indexOf("CLS ");
                                        if (n16 == 0) {
                                            string = string.substring("CLS ".length());
                                        } else {
                                            n3 = string.indexOf("OBJ ");
                                            if (n3 == 0) {
                                                string = string.substring("OBJ ".length());
                                            }
                                        }
                                    }
                                }
                                n6 = Arrays.binarySearch(FileTask.this.getHeapInfo().getNameTable(), string);
                                if (n6 >= 0) {
                                    if (n15 == 0 || n16 == 0) {
                                        n6 |= Integer.MIN_VALUE;
                                    }
                                } else {
                                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                    if (gregorianCalendar != null) {
                                        System.out.print("[" + gregorianCalendar.getTime() + "] ");
                                    }
                                    System.out.println("Could not find an object in an array");
                                    throw new Exception();
                                }
                                FileTask.this.getHeapInfo().setNameKey(n5, n6);
                            }
                            catch (Exception exception) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                if (gregorianCalendar != null) {
                                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                                }
                                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                                exception.printStackTrace();
                                string2 = bufferedReader.readLine();
                                ++l3;
                                continue;
                            }
                            ++n7;
                            FileTask.this.current++;
                            FileTask.this.overall = 30 + (int)(40.0f * (float)FileTask.this.current / (float)FileTask.this.getHeapInfo().getAddressLength());
                        }
                    }
                    string2 = bufferedReader.readLine();
                    ++l3;
                    vector.clear();
                    bl5 = false;
                    while (string2 != null && string2.length() != 0 && string2.charAt(0) == '\t') {
                        block130: {
                            try {
                                if (string2.length() == 1) break block130;
                                n8 = 0;
                                n9 = 1;
                                long l8 = 0L;
                                while ((n8 = string2.indexOf(32, n9)) != -1) {
                                    int n17;
                                    l8 = string2.substring(n9, n8).startsWith("0x0x") ? FindAddressView.getStringToLong(string2.substring(n9 + 2, n8)) : FindAddressView.getStringToLong(string2.substring(n9, n8));
                                    if (FileTask.this.getHeapInfo().isAddress64()) {
                                        n17 = Arrays.binarySearch(FileTask.this.getHeapInfo().getAddressLong(), l8 - FileTask.this.getHeapInfo().getBaseAddress());
                                        if (n17 >= 0) {
                                            vector.addElement(new Integer(n17));
                                        }
                                    } else {
                                        n17 = Arrays.binarySearch(FileTask.this.getHeapInfo().getAddress(), (int)(l8 - FileTask.this.getHeapInfo().getBaseAddress()));
                                        if (n17 >= 0) {
                                            vector.addElement(new Integer(n17));
                                        }
                                    }
                                    n9 = n8 + 1;
                                }
                            }
                            catch (Exception exception) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                if (gregorianCalendar != null) {
                                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                                }
                                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                                exception.printStackTrace();
                                string2 = bufferedReader.readLine();
                                ++l3;
                                continue;
                            }
                        }
                        string2 = bufferedReader.readLine();
                        ++l3;
                    }
                    if (vector.isEmpty()) continue;
                    FileTask.this.getHeapInfo().getChild()[n5] = new int[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        FileTask.this.getHeapInfo().getChild()[n5][i] = (Integer)vector.elementAt(i);
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("Exception while parsing line " + numberFormatter.format(l3) + " : " + string2);
                if (!FileTask.this.isHeadless) {
                    FileTask.this.ha.handleException(exception);
                    FileTask.this.jp.dispose();
                    FileTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            vector.clear();
            vector = null;
            FileTask.this.getHeapInfo().setBits(new byte[FileTask.this.getHeapInfo().getAddressLength()]);
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(FileTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setParent(new int[FileTask.this.getHeapInfo().getAddressLength()]);
            for (n8 = 0; n8 < FileTask.this.getHeapInfo().getParent().length; ++n8) {
                FileTask.this.getHeapInfo().getParent()[n8] = -1;
            }
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(FileTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setTotal(new long[FileTask.this.getHeapInfo().getAddressLength()]);
            l5 = 0L;
            n7 = 0;
            FileTask.this.overall = 73;
            FileTask.this.statMessage = "Analyzing pure roots";
            FileTask.this.current = 0;
            if (!FileTask.this.isHeadless()) {
                FileTask.this.jp.getJProgressBar1().setMaximum(FileTask.this.getHeapInfo().getAddressLength());
            }
            FileTask.this.getHeapInfo().reorg();
            int n18 = 0;
            for (int i = 0; i < FileTask.this.getHeapInfo().getAddressLength(); ++i) {
                if (FileTask.this.getHeapInfo().getHasParent(i)) continue;
                ++n18;
            }
            int[] nArray = new int[n18];
            n18 = 0;
            for (n4 = 0; n4 < FileTask.this.getHeapInfo().getAddressLength(); ++n4) {
                if (!FileTask.this.getHeapInfo().getHasParent(n4)) {
                    FileTask.this.getHeapInfo().calculateTotal(n4);
                    nArray[n18++] = n4;
                }
                FileTask.this.current++;
            }
            FileTask.this.overall = 75;
            FileTask.this.statMessage = "Analyzing pseudo roots";
            FileTask.this.current = 0;
            n7 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n3 = 0; n3 < FileTask.this.getHeapInfo().getAddressLength(); ++n3) {
                if (!FileTask.this.getHeapInfo().getVisited(n3) && FileTask.this.getHeapInfo().getChild()[n3] != null) {
                    FileTask.this.getHeapInfo().calculateTotal(n3);
                    arrayList.add(new Integer(n3));
                }
                FileTask.this.current++;
            }
            FileTask.this.getHeapInfo().clearBits();
            if (!FileTask.this.isHeadless && FileTask.this.ha.cfg.verbose) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                if (gregorianCalendar != null) {
                    System.out.print("[" + gregorianCalendar.getTime() + "] ");
                }
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format((nArray.length + arrayList.size()) * 4) + " bytes of Java heap.");
            }
            FileTask.this.getHeapInfo().setRootChildren(new int[nArray.length + arrayList.size()]);
            FileTask.this.overall = 78;
            FileTask.this.statMessage = "Analyzing root children";
            FileTask.this.current = 0;
            n8 = 0;
            if (!FileTask.this.isHeadless()) {
                FileTask.this.jp.getJProgressBar1().setMaximum(nArray.length + arrayList.size());
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                FileTask.this.getHeapInfo().setRootChildren(n8++, nArray[n2]);
                FileTask.this.current++;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                FileTask.this.getHeapInfo().setRootChildren(n8++, (Integer)arrayList.get(n2));
                FileTask.this.current++;
            }
            arrayList = null;
            n2 = FileTask.this.getHeapInfo().getDumpInfo().indexOf("Classes: ");
            if (FileTask.this.getHeapInfo().getDumpInfo().indexOf("J9") >= 0) {
                FileTask.this.getHeapInfo().setJ9(true);
            }
            if (n2 != -1 && (n = FileTask.this.getHeapInfo().getDumpInfo().indexOf(",", n2 + "Classes: ".length())) != -1) {
                long l9 = 0L;
                try {
                    l9 = Long.parseLong(FileTask.this.getHeapInfo().getDumpInfo().substring(n2 + "Classes: ".length(), n));
                }
                catch (NumberFormatException numberFormatException) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    if (gregorianCalendar != null) {
                        System.out.print("[" + gregorianCalendar.getTime() + "] ");
                    }
                    System.out.println("Cannot parse \"" + FileTask.this.getHeapInfo().getDumpInfo().substring(n2 + "Classes: ".length(), n) + "\"");
                }
                if (!FileTask.this.getHeapInfo().isJ9()) {
                    FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Recommended size of kCluster : " + numberFormatter.format((long)((float)l9 * 1.1f)) + " or greater\n");
                    HeapInfo.addRow2TableModel("Recommended size of kCluster", numberFormatter.format((long)((float)l9 * 1.1f)) + " or greater", defaultTableModel);
                }
            }
            FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Number of roots : " + numberFormatter.format(FileTask.this.getHeapInfo().getRootChildrenLength()) + "\n");
            HeapInfo.addRow2TableModel("Number of roots", numberFormatter.format(FileTask.this.getHeapInfo().getRootChildrenLength()), defaultTableModel);
            FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Number of types : " + numberFormatter.format(FileTask.this.getHeapInfo().getNameTable().length) + "\n");
            HeapInfo.addRow2TableModel("Number of types", numberFormatter.format(FileTask.this.getHeapInfo().getNameTable().length), defaultTableModel);
            FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Heap range : 0x" + Long.toHexString(FileTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(FileTask.this.getHeapInfo().getAddress(FileTask.this.getHeapInfo().getAddressLength() - 1)) + "\n");
            HeapInfo.addRow2TableModel("Heap range", "0x" + Long.toHexString(FileTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(FileTask.this.getHeapInfo().getAddress(FileTask.this.getHeapInfo().getAddressLength() - 1)), defaultTableModel);
            FileTask.this.overall = 90;
            FileTask.this.getHeapInfo().sortRootChildren();
            FileTask.this.statMessage = "Calculating total heap size";
            FileTask.this.current = 0;
            if (!FileTask.this.isHeadless) {
                FileTask.this.jp.getJProgressBar1().setMaximum(FileTask.this.getHeapInfo().getAddressLength());
            }
            long l10 = 0L;
            int n19 = 0;
            for (n8 = 0; n8 < FileTask.this.getHeapInfo().getSize().length; ++n8) {
                l10 += (long)FileTask.this.getHeapInfo().getSize(n8);
                if (FileTask.this.getHeapInfo().isFinalizer(n8)) {
                    ++n19;
                }
                FileTask.this.current++;
            }
            if (n19 > 0) {
                FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Number of objects with finalize() method : " + numberFormatter.format(n19) + "\n");
                HeapInfo.addRow2TableModel("Number of objects with finalize() method", numberFormatter.format(n19), defaultTableModel);
            }
            if (FileTask.this.getHeapInfo().getNumberOfFinalizableObject() > 0) {
                FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Number of garbage objects implementing finalize() method : " + numberFormatter.format(FileTask.this.getHeapInfo().getNumberOfFinalizableObject()) + "\n");
                HeapInfo.addRow2TableModel("Number of garbage objects implementing finalize() method", numberFormatter.format(FileTask.this.getHeapInfo().getNumberOfFinalizableObject()), defaultTableModel);
            }
            FileTask.this.getHeapInfo().setNumberOfFinalizerObject(n19);
            FileTask.this.getHeapInfo().setHeapSize(l10);
            FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "Java heap usage : " + numberFormatter.format(l10) + " bytes\n");
            FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + FileTask.this.getHeapInfo().darkMatterAnalysis() + "\n");
            HeapInfo.addRow2TableModel("Java heap usage", numberFormatter.format(l10) + " bytes", defaultTableModel);
            HeapInfo.addRow2TableModel("Dark matter", FileTask.this.getHeapInfo().darkMatterAnalysis(), defaultTableModel);
            FileTask.this.statMessage = "Chasing Java heap leak suspects";
            SuspectTask suspectTask = new SuspectTask(null, FileTask.this.ha, FileTask.this.getHeapInfo(), null, null);
            int n20 = suspectTask.headLessTask();
            FileTask.this.done = true;
            FileTask.this.overall = 100;
            System.out.println("[" + new Date() + "] Heap Analysis of " + FileTask.this.file.getAbsoluteFile() + " completed in " + FileTask.this.getElapsed());
            if (FileTask.this.getHeapInfo().getDumpInfo().indexOf("// EOF: ") == -1 && FileTask.this.getHeapInfo().getDumpInfo().indexOf("// Finished heapdump") == -1 && bl) {
                FileTask.this.getHeapInfo().setDumpInfo(FileTask.this.getHeapInfo().getDumpInfo() + "\n*** WARNING!! THE HEAP DUMP IS TRUNCATED. No further analysis is recommended.***\n\n");
                HeapInfo.addRow2TableModel("WARNING", "THE HEAP DUMP IS TRUNCATED. No further analysis is recommended", defaultTableModel);
            }
            if (!FileTask.this.isHeadless()) {
                FileTask.this.jp.dispose();
                HeapFrame heapFrame = new HeapFrame("Analysis of " + FileTask.this.file.getName(), FileTask.this.getHeapInfo());
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ha.gif"));
                heapFrame.setFrameIcon(imageIcon);
                heapFrame.fileName = FileTask.this.file.getName();
                JTable jTable = new JTable();
                jTable.setDragEnabled(true);
                jTable.setCellSelectionEnabled(true);
                jTable.setModel(defaultTableModel);
                HeapTree heapTree = FileTask.this.ha.addLeakSuspectView(FileTask.this.hi, heapFrame, jTable, true);
                if (heapTree == null) {
                    heapFrame.JScrollPaneSetViewportView(jTable);
                } else {
                    heapFrame.setSize(900, 800);
                    HeapInfo.addRow2TableModel("Number of leak suspects", numberFormatter.format(((FileTask)FileTask.this).hi.suspectList.length), defaultTableModel);
                }
                FileTask.this.ha.getJDesktopPane1().add(heapFrame);
                FileTask.this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
                try {
                    heapFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            } else {
                System.out.println("Heap dump file name : " + FileTask.this.file.getAbsoluteFile() + "\n");
                System.out.println(FileTask.this.getHeapInfo().getDumpInfo() + "\n");
            }
        }

        ActualTask() {
            this.processHeapDump();
        }
    }
}

