/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTable;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.PopupListener;
import com.ibm.jinwoo.heap.SearchTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class FindAddressView
extends JDialog {
    static DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JPanel ivjJDialogContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JButton ivjCancel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjFind = null;
    private HeapInfo hi = null;
    private HeapTree ht = null;
    private JComboBox ivjAddressField = null;
    public HeapAnalyzer ha = null;

    public FindAddressView() {
        this.initialize();
    }

    public FindAddressView(Dialog dialog) {
        super(dialog);
    }

    public FindAddressView(Dialog dialog, String string) {
        super(dialog, string);
    }

    public FindAddressView(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public FindAddressView(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public FindAddressView(Frame frame) {
        super(frame);
        this.initialize();
    }

    public FindAddressView(Frame frame, HeapInfo heapInfo) {
        super(frame);
        this.ha = (HeapAnalyzer)frame;
        this.hi = heapInfo;
        this.initialize();
    }

    public FindAddressView(Frame frame, HeapInfo heapInfo, HeapTree heapTree) {
        super(frame);
        this.ha = (HeapAnalyzer)frame;
        this.hi = heapInfo;
        this.ht = heapTree;
        this.initialize();
    }

    public FindAddressView(Frame frame, String string) {
        super(frame, string);
    }

    public FindAddressView(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public FindAddressView(Frame frame, boolean bl) {
        super(frame, bl);
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.find_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionEvent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void find_ActionPerformed() {
        Object object;
        Object object2;
        String string = ((String)this.getAddressField().getSelectedItem()).trim();
        if (string == null) {
            return;
        }
        model.addElement(string);
        long l = 0L;
        try {
            l = FindAddressView.getStringToLong(string);
        }
        catch (RuntimeException runtimeException) {
            JOptionPane.showMessageDialog(this, "Invalid address : " + string, "Invalid address", 0);
            return;
        }
        int n = 0;
        l -= this.hi.getBaseAddress();
        long l2 = -1L;
        long l3 = 0L;
        long l4 = 0L;
        if (this.hi.isHav()) {
            object = object2 = this.hi.getHav().raf;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getHeapBaseLocation());
                    for (int i = 0; i < this.hi.getHav().getNumberOfEntries(); ++i) {
                        l4 = this.hi.getHav().raf.getFilePointer() - this.hi.getHav().getHeapBaseLocation();
                        if (this.hi.getHav().read((RandomAccessFile)object2) == l) {
                            l2 = this.hi.getHav().read((RandomAccessFile)object2);
                            l3 = this.hi.getHav().read((RandomAccessFile)object2) + l2;
                            break;
                        }
                        this.hi.getHav().read((RandomAccessFile)object2);
                        this.hi.getHav().read((RandomAccessFile)object2);
                        this.hi.getHav().readName((RandomAccessFile)object2);
                        this.hi.getHav().raf.readInt();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (l2 == -1L) {
                JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                return;
            }
        } else {
            n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)l);
            if (n < 0) {
                JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                return;
            }
        }
        object2 = new HeapFrame(this.hi.getFile().getName() + " Search Address", this.hi);
        object = new ImageIcon(this.getClass().getResource("/address.gif"));
        ((JInternalFrame)object2).setFrameIcon((Icon)object);
        ((HeapFrame)object2).fileName = this.hi.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        ((HeapFrame)object2).JScrollPaneSetViewportView(heapTable);
        this.ha.getJDesktopPane1().add((Component)object2);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame((JInternalFrame)object2);
        try {
            ((JInternalFrame)object2).setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        SearchTableModel searchTableModel = new SearchTableModel(this.hi, 0);
        searchTableModel.setTableHeader(heapTable.getTableHeader());
        if (searchTableModel.sortedArrary == null) {
            searchTableModel.sortedArrary = new long[2][1];
            if (this.hi.isHav()) {
                searchTableModel.sortedArrary[0][0] = l3;
                searchTableModel.sortedArrary[1][0] = l4;
            } else {
                searchTableModel.sortedArrary[0][0] = this.hi.getTotal(n);
                searchTableModel.sortedArrary[1][0] = n;
            }
            heapTable.setModel(searchTableModel);
        }
        this.dispose();
    }

    private JComboBox getAddressField() {
        if (this.ivjAddressField == null) {
            try {
                this.ivjAddressField = new JComboBox();
                this.ivjAddressField.setName("AddressField");
                this.ivjAddressField.setEditable(true);
                this.ivjAddressField.setModel(model);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAddressField;
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setMnemonic('C');
                this.ivjCancel.setText("Cancel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCancel;
    }

    private JButton getFind() {
        if (this.ivjFind == null) {
            try {
                this.ivjFind = new JButton();
                this.ivjFind.setName("Find");
                this.ivjFind.setMnemonic('F');
                this.ivjFind.setText("Find");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFind;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Please enter an address (i.e.  0x00FC)");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new FlowLayout());
                this.getJPanel1().add((Component)this.getFind(), this.getFind().getName());
                this.ivjJPanel1.add(this.getCancel());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(27, 35, 5, 35);
                this.getJPanel2().add((Component)this.getJLabel1(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.gridy = 2;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.ipadx = 136;
                gridBagConstraints2.ipady = -3;
                gridBagConstraints2.insets = new Insets(6, 15, 37, 15);
                this.getJPanel2().add((Component)this.getAddressField(), gridBagConstraints2);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel2;
    }

    public static long getStringToLong(String string) throws NumberFormatException {
        int n;
        if (string == null) {
            throw new NumberFormatException();
        }
        int n2 = string.length();
        if (n2 == 18 && (n = Character.digit(string.charAt(2), 16)) >= 8) {
            int n3 = 0;
            long l = 0L;
            int n4 = 2;
            byte by = 0;
            while (n4 < n2) {
                n3 = Character.digit(string.charAt(n4++), 16);
                by = (byte)n3;
                by = (byte)(by | 0xFFFFFFF0);
                by = ~by;
                l <<= 4;
                l += (long)by;
            }
            return -1L * ++l;
        }
        n = 0;
        long l = 0L;
        int n5 = 2;
        boolean bl = false;
        while (n5 < n2) {
            n = Character.digit(string.charAt(n5++), 16);
            l <<= 4;
            l += (long)n;
        }
        return l;
    }

    private void handleException(Throwable throwable) {
        throwable.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getCancel().addActionListener(this.ivjEventHandler);
        this.getFind().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("FindAddress");
            this.setDefaultCloseOperation(2);
            this.setSize(284, 144);
            this.setVisible(true);
            this.setTitle("Find an address");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            FindAddressView findAddressView = new FindAddressView();
            findAddressView.setModal(true);
            findAddressView.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            findAddressView.show();
            Insets insets = findAddressView.getInsets();
            findAddressView.setSize(findAddressView.getWidth() + insets.left + insets.right, findAddressView.getHeight() + insets.top + insets.bottom);
            findAddressView.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            throwable.printStackTrace(System.out);
        }
    }

    public long returnTreeDepth(int n) {
        long l = 0L;
        if (n < 0) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + n, "Address not found", 0);
            return -1L;
        }
        while (this.hi.getParent()[n] >= 0) {
            ++l;
            n = this.hi.getParent()[n];
        }
        return l;
    }

    public TreePath returnTreePath(int n) {
        if (n < 0) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + n, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        vector.add(0, new Node(n));
        while (this.hi.getParent()[n] >= 0) {
            vector.add(0, new Node(this.hi.getParent()[n]));
            n = this.hi.getParent()[n];
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FindAddressView.this.getCancel()) {
                FindAddressView.this.connEtoM1(actionEvent);
            }
            if (actionEvent.getSource() == FindAddressView.this.getFind()) {
                FindAddressView.this.connEtoC1(actionEvent);
            }
        }
    }
}

