/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FindAddress;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTable;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.PopupListener;
import com.ibm.jinwoo.heap.TableThreadSearch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FindTypes
extends JDialog {
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JPanel ivjJDialogContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JButton ivjCancel = null;
    private JButton ivjFind = null;
    private HeapInfo hi = null;
    private HeapTree ht = null;
    private HeapAnalyzer ha = null;
    private JComboBox ivjTypeField = null;
    private boolean bySize = false;
    private JCheckBox ivjJCheckBoxRegularExpression = null;
    private JCheckBox ivjJCheckBoxArray = null;
    private JCheckBox ivjJCheckBoxClass = null;

    public FindTypes() {
        this.initialize();
    }

    public FindTypes(Dialog dialog) {
        super(dialog);
    }

    public FindTypes(Dialog dialog, String string) {
        super(dialog, string);
    }

    public FindTypes(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public FindTypes(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public FindTypes(Frame frame) {
        super(frame);
        this.initialize();
    }

    public FindTypes(Frame frame, HeapInfo heapInfo) {
        super(frame);
        this.hi = heapInfo;
        this.initialize();
    }

    public FindTypes(Frame frame, HeapInfo heapInfo, HeapAnalyzer heapAnalyzer) {
        super(frame);
        this.hi = heapInfo;
        this.ha = heapAnalyzer;
        this.initialize();
    }

    public FindTypes(Frame frame, HeapInfo heapInfo, HeapAnalyzer heapAnalyzer, boolean bl) {
        super(frame);
        this.hi = heapInfo;
        this.ha = heapAnalyzer;
        this.bySize = bl;
        this.initialize();
    }

    public FindTypes(Frame frame, String string) {
        super(frame, string);
    }

    public FindTypes(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public FindTypes(Frame frame, boolean bl) {
        super(frame, bl);
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.find_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.find_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionEvent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void find_ActionPerformed() {
        int n = -1;
        Object var2_2 = null;
        boolean bl = false;
        String string = (String)this.getTypeField().getSelectedItem();
        Object var5_5 = null;
        if (string == null) {
            return;
        }
        model.addElement(string);
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Search", this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/search.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView(heapTable);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        TableThreadSearch tableThreadSearch = new TableThreadSearch(heapTable, this.hi, n, string, this.ha, this.getJCheckBoxClass().isSelected(), this.getJCheckBoxArray().isSelected(), this.getJCheckBoxRegularExpression().isSelected());
        tableThreadSearch.start();
        this.dispose();
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setMnemonic('C');
                this.ivjCancel.setText("Cancel");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCancel;
    }

    private JButton getFind() {
        if (this.ivjFind == null) {
            try {
                this.ivjFind = new JButton();
                this.ivjFind.setName("Find");
                this.ivjFind.setMnemonic('F');
                this.ivjFind.setText("Find");
                this.ivjFind.setSelected(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFind;
    }

    private JCheckBox getJCheckBoxArray() {
        if (this.ivjJCheckBoxArray == null) {
            try {
                this.ivjJCheckBoxArray = new JCheckBox();
                this.ivjJCheckBoxArray.setName("JCheckBoxArray");
                this.ivjJCheckBoxArray.setText("Array only");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxArray;
    }

    private JCheckBox getJCheckBoxClass() {
        if (this.ivjJCheckBoxClass == null) {
            try {
                this.ivjJCheckBoxClass = new JCheckBox();
                this.ivjJCheckBoxClass.setName("JCheckBoxClass");
                this.ivjJCheckBoxClass.setText("Class only");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxClass;
    }

    private JCheckBox getJCheckBoxRegularExpression() {
        if (this.ivjJCheckBoxRegularExpression == null) {
            try {
                this.ivjJCheckBoxRegularExpression = new JCheckBox();
                this.ivjJCheckBoxRegularExpression.setName("JCheckBoxRegularExpression");
                this.ivjJCheckBoxRegularExpression.setText("Regular expressions");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxRegularExpression;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Search");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new FlowLayout());
                this.getJPanel1().add((Component)this.getFind(), this.getFind().getName());
                this.ivjJPanel1.add(this.getCancel());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(32, 25, 13, 5);
                this.getJPanel2().add((Component)this.getJLabel1(), gridBagConstraints);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 2;
                gridBagConstraints2.gridy = 1;
                gridBagConstraints2.fill = 2;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.ipadx = 141;
                gridBagConstraints2.ipady = -3;
                gridBagConstraints2.insets = new Insets(30, 5, 9, 25);
                this.getJPanel2().add((Component)this.getTypeField(), gridBagConstraints2);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 1;
                gridBagConstraints3.gridy = 4;
                gridBagConstraints3.gridwidth = 2;
                gridBagConstraints3.ipadx = 166;
                gridBagConstraints3.insets = new Insets(4, 25, 39, 26);
                this.getJPanel2().add((Component)this.getJCheckBoxRegularExpression(), gridBagConstraints3);
                GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
                gridBagConstraints4.gridx = 1;
                gridBagConstraints4.gridy = 2;
                gridBagConstraints4.gridwidth = 2;
                gridBagConstraints4.ipadx = 226;
                gridBagConstraints4.insets = new Insets(10, 25, 4, 26);
                this.getJPanel2().add((Component)this.getJCheckBoxClass(), gridBagConstraints4);
                GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
                gridBagConstraints5.gridx = 1;
                gridBagConstraints5.gridy = 3;
                gridBagConstraints5.gridwidth = 2;
                gridBagConstraints5.ipadx = 227;
                gridBagConstraints5.insets = new Insets(5, 25, 3, 26);
                this.getJPanel2().add((Component)this.getJCheckBoxArray(), gridBagConstraints5);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJPanel2;
    }

    private JComboBox getTypeField() {
        if (this.ivjTypeField == null) {
            try {
                this.ivjTypeField = new JComboBox();
                this.ivjTypeField.setName("TypeField");
                this.ivjTypeField.setEditable(true);
                this.ivjTypeField.setModel(model);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTypeField;
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() throws Exception {
        this.getCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindTypes.this.connEtoM1(actionEvent);
            }
        });
        this.getFind().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindTypes.this.connEtoC1(actionEvent);
            }
        });
    }

    private void initialize() {
        try {
            this.setName("FindAddress");
            this.setDefaultCloseOperation(2);
            this.setSize(360, 225);
            this.setVisible(false);
            this.setTitle("Search");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public static void main(String[] stringArray) {
        try {
            FindAddress findAddress = new FindAddress();
            findAddress.setModal(true);
            findAddress.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            findAddress.show();
            Insets insets = findAddress.getInsets();
            findAddress.setSize(findAddress.getWidth() + insets.left + insets.right, findAddress.getHeight() + insets.top + insets.bottom);
            findAddress.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            throwable.printStackTrace(System.out);
        }
    }
}

