/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.DirectBuffer;
import com.ibm.jinwoo.heap.HeapCache;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.OpenHavTask;
import com.ibm.jinwoo.heap.SaveViewerTask;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class Hav {
    private boolean isLongAddress;
    Hashtable nameCache = new Hashtable();
    Hashtable heapCache = new Hashtable();
    private long heapBaseLocation = 0L;
    private long stringBaseLocation = 0L;
    RandomAccessFile raf = null;
    public Vector notifyList = new Vector();
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private int rootChildrenLength = 0;
    private int numberOfEntries;
    private int nameTableLength;
    HeapInfo hi;
    static final String HAV_SIGNATURE = "IBM HeapAnalyzer 1.0.0";
    static final int HEADER_SIZE = 61;
    static final int DEFAULT_POINTER_SIZE = 4;
    private int pointerSize = 4;
    private int addressSize = 4;
    private int nameSize = 4;
    private int totalSize = 8;
    private int sizeSize = 4;
    private int childSize = 4;
    long[] stringLocation = null;
    long[] entryLocation = null;
    long nonRoot = 0L;
    long spos = 0L;
    long pos = 0L;
    DirectBuffer heapBuffer = null;
    MappedByteBuffer stringBuffer = null;

    void setRootChildrenLength(int n) {
        this.rootChildrenLength = n;
    }

    int getRootChildrenLength() {
        return this.rootChildrenLength;
    }

    public Hav(HeapInfo heapInfo) {
        this.hi = heapInfo;
        if (this.hi.isAddress64()) {
            this.setAddressSize(8);
        }
    }

    void findNameSize(long l) {
        if (l > Integer.MAX_VALUE) {
            this.setNameSize(8);
        } else if (l > 32767L) {
            this.setNameSize(4);
        } else if (l > 127L) {
            this.setNameSize(2);
        } else {
            this.setNameSize(1);
        }
    }

    void findChildSize(int n) {
        if (n > Integer.MAX_VALUE) {
            this.setChildSize(8);
        } else if (n > Short.MAX_VALUE) {
            this.setChildSize(4);
        } else if (n > 127) {
            this.setChildSize(2);
        } else {
            this.setChildSize(1);
        }
    }

    void findSizeSize(long l) {
        if (l > Integer.MAX_VALUE) {
            this.setSizeSize(8);
        } else if (l > 32767L) {
            this.setSizeSize(4);
        } else if (l > 127L) {
            this.setSizeSize(2);
        } else {
            this.setSizeSize(1);
        }
    }

    void findTotalSize(long l) {
        if (l > Integer.MAX_VALUE) {
            this.setTotalSize(8);
        } else if (l > 32767L) {
            this.setTotalSize(4);
        } else if (l > 127L) {
            this.setTotalSize(2);
        } else {
            this.setTotalSize(1);
        }
    }

    long getUnitSize(int n) {
        int n2 = 0;
        if (this.hi.getChild()[n] != null) {
            n2 = this.hi.getChild()[n].length;
        }
        return (n2 + 1) * this.getPointerSize() + this.getAddressSize() + this.getSizeSize() + this.getTotalSize() + this.getChildSize() + this.getNameSize();
    }

    long getCompressedUnitSize(int n, int[] nArray) {
        return 4 + DirectBuffer.getSize(this.hi.getOffsetAddress(n)) + DirectBuffer.getSize(this.hi.getSize(n)) + DirectBuffer.getSize(this.hi.getTotal(n) - (long)this.hi.getSize(n)) + DirectBuffer.getSizeForName(nArray[this.hi.getNameKey(n)]);
    }

    long getDefaultUnitSize(int n) {
        int n2 = 0;
        if (this.hi.getChild()[n] != null) {
            n2 = this.hi.getChild()[n].length;
        }
        return (n2 + 1) * 4 + this.getAddressSize() + this.getSizeSize() + this.getTotalSize() + this.getChildSize() + this.getNameSize();
    }

    int calculatePointerSize() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < this.hi.getAddressLength(); ++i) {
            if (i == 0) {
                l2 = this.hi.getSize(i);
                l3 = this.hi.getTotal(i);
            }
            if (l2 < (long)this.hi.getSize(i)) {
                l2 = this.hi.getSize(i);
            }
            if (l3 < this.hi.getTotal(i)) {
                l3 = this.hi.getTotal(i);
            }
            if (l > Integer.MAX_VALUE) continue;
            l += this.getDefaultUnitSize(i);
        }
        this.findTotalSize(l3);
        this.findSizeSize(l2);
        if (l > Integer.MAX_VALUE) {
            return 8;
        }
        return 4;
    }

    void setNameSize(int n) {
        this.nameSize = n;
    }

    int getNameSize() {
        return this.nameSize;
    }

    void setPointerSize(int n) {
        this.pointerSize = n;
    }

    int getPointerSize() {
        return this.pointerSize;
    }

    void setAddressSize(int n) {
        this.addressSize = n;
    }

    int getAddressSize() {
        return this.addressSize;
    }

    void setTotalSize(int n) {
        this.totalSize = n;
    }

    int getTotalSize() {
        return this.totalSize;
    }

    void setSizeSize(int n) {
        this.sizeSize = n;
    }

    int getSizeSize() {
        return this.sizeSize;
    }

    void setChildSize(int n) {
        this.childSize = n;
    }

    int getChildSize() {
        return this.childSize;
    }

    public void printObject(MappedByteBuffer mappedByteBuffer, MappedByteBuffer mappedByteBuffer2, int n, int n2, int n3, int n4, int n5, int n6) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        mappedByteBuffer.position(n);
        l = n2 == 8 ? mappedByteBuffer.getLong() : (long)mappedByteBuffer.getInt();
        l4 = n4 == 8 ? mappedByteBuffer.getLong() : (n4 == 4 ? (long)mappedByteBuffer.getInt() : (n4 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        l2 = n5 == 8 ? mappedByteBuffer.getLong() : (n5 == 4 ? (long)mappedByteBuffer.getInt() : (n5 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        if (n3 == 8) {
            long l6 = mappedByteBuffer.getLong();
        } else {
            long l7 = mappedByteBuffer.getInt();
        }
        l3 = n2 == 8 ? mappedByteBuffer.getLong() : (long)mappedByteBuffer.getInt();
        l5 = n6 == 8 ? mappedByteBuffer.getLong() : (n6 == 4 ? (long)mappedByteBuffer.getInt() : (n6 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        System.out.println(" 0x" + Long.toHexString(l) + " [" + l4 + "/" + l2 + "] ");
    }

    public StringBuffer getObjectName(MappedByteBuffer mappedByteBuffer, int n) {
        byte by = 0;
        StringBuffer stringBuffer = new StringBuffer();
        mappedByteBuffer.rewind();
        mappedByteBuffer.position(n);
        do {
            if ((by = mappedByteBuffer.get()) == 0) continue;
            stringBuffer.append((char)by);
        } while (by != 0);
        return stringBuffer;
    }

    void save(File file) {
        int n;
        ByteBuffer[] byteBufferArray = null;
        DirectBuffer directBuffer = new DirectBuffer();
        long l = 0L;
        this.stringLocation = new long[this.hi.getNameTable().length];
        this.entryLocation = new long[this.hi.getAddressLength()];
        for (n = 0; n < this.entryLocation.length; ++n) {
            this.entryLocation[n] = -1L;
        }
        try {
            int n2;
            int n3;
            int n4;
            byteBufferArray = new ByteBuffer[this.hi.getNameTable().length];
            this.spos = 0L;
            for (n = 0; n < this.hi.getNameTable().length; ++n) {
                this.stringLocation[n] = this.spos;
                byteBufferArray[n] = ByteBuffer.allocateDirect(this.hi.getNameTable(n).length() + 1);
                byteBufferArray[n].put(this.hi.getNameTable(n).getBytes());
                byteBufferArray[n].put((byte)0);
                byteBufferArray[n].flip();
                this.spos += (long)byteBufferArray[n].capacity();
            }
            if (this.spos > Integer.MAX_VALUE) {
                this.pointerSize = 8;
                this.nameSize = 8;
            } else {
                this.pointerSize = this.calculatePointerSize();
            }
            n = 0;
            for (n4 = 0; n4 < this.hi.getChild().length; ++n4) {
                if (this.hi.getChild()[n4] == null) continue;
                if (this.hi.getChild().length > n) {
                    n = this.hi.getChild().length;
                }
                l += (long)this.hi.getChild()[n4].length;
            }
            this.findChildSize(n);
            l = l * (long)this.pointerSize + (long)(this.hi.getAddressLength() * (this.pointerSize + this.addressSize + this.sizeSize + this.totalSize + this.nameSize + this.childSize));
            this.pos = 0L;
            for (n4 = 0; n4 < this.hi.getRootChildrenLength(); ++n4) {
                this.entryLocation[this.hi.getRootChildren((int)n4)] = this.pos;
                this.pos += this.getUnitSize(this.hi.getRootChildren(n4));
            }
            this.nonRoot = this.pos;
            for (n4 = 0; n4 < this.hi.getAddressLength(); ++n4) {
                if (this.entryLocation[n4] != -1L) continue;
                this.entryLocation[n4] = this.pos;
                this.pos += this.getUnitSize(n4);
            }
            System.out.println("File size=" + l);
            directBuffer.allocateDirect(l);
            for (n4 = 0; n4 < this.hi.getRootChildrenLength(); ++n4) {
                if (this.addressSize == 8) {
                    directBuffer.putLong(this.hi.getAddress(this.hi.getRootChildren(n4)));
                } else {
                    directBuffer.putInt((int)this.hi.getAddress(this.hi.getRootChildren(n4)));
                }
                if (this.hi.isArray(this.hi.getRootChildren(n4))) {
                    if (this.sizeSize == 1) {
                        directBuffer.put((byte)((byte)this.hi.getSize(this.hi.getRootChildren(n4)) | 0xFFFFFF80));
                    } else if (this.sizeSize == 2) {
                        directBuffer.putShort((short)((short)this.hi.getSize(this.hi.getRootChildren(n4)) | Short.MIN_VALUE));
                    } else {
                        directBuffer.putInt(this.hi.getSize(this.hi.getRootChildren(n4)) | Integer.MIN_VALUE);
                    }
                } else if (this.sizeSize == 1) {
                    directBuffer.put((byte)this.hi.getSize(this.hi.getRootChildren(n4)));
                } else if (this.sizeSize == 2) {
                    directBuffer.putShort((short)this.hi.getSize(this.hi.getRootChildren(n4)));
                } else {
                    directBuffer.putInt(this.hi.getSize(this.hi.getRootChildren(n4)));
                }
                if (n4 < 10) {
                    System.out.println("i=" + n4 + " total=" + this.hi.getTotal(this.hi.getRootChildren(n4)));
                }
                if (this.totalSize == 1) {
                    directBuffer.put((byte)this.hi.getTotal(this.hi.getRootChildren(n4)));
                } else if (this.totalSize == 2) {
                    directBuffer.putShort((short)this.hi.getTotal(this.hi.getRootChildren(n4)));
                } else if (this.totalSize == 4) {
                    directBuffer.putInt((int)this.hi.getTotal(this.hi.getRootChildren(n4)));
                } else {
                    directBuffer.putLong(this.hi.getTotal(this.hi.getRootChildren(n4)));
                }
                if (this.hi.isClass(this.hi.getRootChildren(n4))) {
                    if (this.nameSize == 8) {
                        directBuffer.putLong(Long.MIN_VALUE | this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                    } else if (this.nameSize == 4) {
                        directBuffer.putInt(Integer.MIN_VALUE | (int)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                    } else if (this.nameSize == 2) {
                        directBuffer.putShort((short)(Short.MIN_VALUE | (short)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]));
                    } else {
                        directBuffer.put((byte)(0xFFFFFF80 | (byte)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]));
                    }
                } else if (this.nameSize == 8) {
                    directBuffer.putLong(this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                } else if (this.nameSize == 4) {
                    directBuffer.putInt((int)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                } else if (this.nameSize == 2) {
                    directBuffer.putShort((short)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                } else {
                    directBuffer.put((byte)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n4))]);
                }
                if (this.pointerSize == 8) {
                    directBuffer.putLong(-1L);
                } else {
                    directBuffer.putInt(-1);
                }
                if (this.hi.getChild()[this.hi.getRootChildren(n4)] == null) {
                    if (this.childSize == 8) {
                        directBuffer.putLong(0L);
                    } else if (this.childSize == 4) {
                        directBuffer.putInt(0);
                    } else if (this.childSize == 2) {
                        directBuffer.putShort((short)0);
                    } else {
                        directBuffer.put((byte)0);
                    }
                } else if (this.childSize == 1) {
                    directBuffer.put((byte)this.hi.getChild()[this.hi.getRootChildren(n4)].length);
                } else if (this.childSize == 2) {
                    directBuffer.putShort((short)this.hi.getChild()[this.hi.getRootChildren(n4)].length);
                } else if (this.childSize == 4) {
                    directBuffer.putInt(this.hi.getChild()[this.hi.getRootChildren(n4)].length);
                } else {
                    directBuffer.putLong(this.hi.getChild()[this.hi.getRootChildren(n4)].length);
                }
                if (this.hi.getChild()[this.hi.getRootChildren(n4)] == null) continue;
                for (n3 = 0; n3 < this.hi.getChild()[this.hi.getRootChildren(n4)].length; ++n3) {
                    if (this.pointerSize == 8) {
                        directBuffer.putLong(this.entryLocation[this.hi.getChild()[this.hi.getRootChildren(n4)][n3]]);
                        continue;
                    }
                    directBuffer.putInt((int)this.entryLocation[this.hi.getChild()[this.hi.getRootChildren(n4)][n3]]);
                }
            }
            for (n4 = 0; n4 < this.hi.getAddressLength(); ++n4) {
                if (this.hi.getParent()[n4] < 0) continue;
                if (this.addressSize == 8) {
                    directBuffer.putLong(this.hi.getAddress(n4));
                } else {
                    directBuffer.putInt((int)this.hi.getAddress(n4));
                }
                if (this.hi.isArray(n4)) {
                    if (this.sizeSize == 4) {
                        directBuffer.putInt(this.hi.getSize(n4) | Integer.MIN_VALUE);
                    } else if (this.sizeSize == 2) {
                        directBuffer.putShort((short)((short)this.hi.getSize(n4) | Short.MIN_VALUE));
                    } else {
                        directBuffer.put((byte)((byte)this.hi.getSize(n4) | 0xFFFFFF80));
                    }
                } else if (this.sizeSize == 4) {
                    directBuffer.putInt(this.hi.getSize(n4));
                } else if (this.sizeSize == 2) {
                    directBuffer.putShort((short)this.hi.getSize(n4));
                } else {
                    directBuffer.put((byte)this.hi.getSize(n4));
                }
                if (this.totalSize == 8) {
                    directBuffer.putLong(this.hi.getTotal(n4));
                } else if (this.totalSize == 4) {
                    directBuffer.putInt((int)this.hi.getTotal(n4));
                } else if (this.totalSize == 2) {
                    directBuffer.putShort((short)this.hi.getTotal(n4));
                } else {
                    directBuffer.put((byte)this.hi.getTotal(n4));
                }
                if (this.hi.isClass(n4)) {
                    if (this.nameSize == 8) {
                        directBuffer.putLong(Long.MIN_VALUE | this.stringLocation[this.hi.getNameKey(n4)]);
                    } else if (this.nameSize == 4) {
                        directBuffer.putInt(Integer.MIN_VALUE | (int)this.stringLocation[this.hi.getNameKey(n4)]);
                    } else if (this.nameSize == 2) {
                        directBuffer.putShort((short)(Short.MIN_VALUE | (short)this.stringLocation[this.hi.getNameKey(n4)]));
                    } else {
                        directBuffer.put((byte)(0xFFFFFF80 | (byte)this.stringLocation[this.hi.getNameKey(n4)]));
                    }
                } else if (this.nameSize == 8) {
                    directBuffer.putLong(this.stringLocation[this.hi.getNameKey(n4)]);
                } else if (this.nameSize == 4) {
                    directBuffer.putInt((int)this.stringLocation[this.hi.getNameKey(n4)]);
                } else if (this.nameSize == 2) {
                    directBuffer.putShort((short)this.stringLocation[this.hi.getNameKey(n4)]);
                } else {
                    directBuffer.put((byte)this.stringLocation[this.hi.getNameKey(n4)]);
                }
                if (this.pointerSize == 8) {
                    directBuffer.putLong(this.entryLocation[this.hi.getParent()[n4]]);
                } else {
                    directBuffer.putInt((int)this.entryLocation[this.hi.getParent()[n4]]);
                }
                if (this.hi.getChild()[n4] == null) {
                    if (this.childSize == 8) {
                        directBuffer.putLong(0L);
                    } else if (this.childSize == 4) {
                        directBuffer.putInt(0);
                    } else if (this.childSize == 2) {
                        directBuffer.putShort((short)0);
                    } else {
                        directBuffer.put((byte)0);
                    }
                } else if (this.childSize == 8) {
                    directBuffer.putLong(this.hi.getChild()[n4].length);
                } else if (this.childSize == 4) {
                    directBuffer.putInt(this.hi.getChild()[n4].length);
                } else if (this.childSize == 2) {
                    directBuffer.putShort((short)this.hi.getChild()[n4].length);
                } else {
                    directBuffer.put((byte)this.hi.getChild()[n4].length);
                }
                if (this.hi.getChild()[n4] == null) continue;
                for (n3 = 0; n3 < this.hi.getChild()[n4].length; ++n3) {
                    if (this.pointerSize == 8) {
                        directBuffer.putLong(this.entryLocation[this.hi.getChild()[n4][n3]]);
                        continue;
                    }
                    directBuffer.putInt((int)this.entryLocation[this.hi.getChild()[n4][n3]]);
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            char[] cArray = HAV_SIGNATURE.toCharArray();
            int n5 = 61 + cArray.length;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
            for (n2 = 0; n2 < cArray.length; ++n2) {
                byteBuffer.put((byte)cArray[n2]);
            }
            byteBuffer.put((byte)this.pointerSize).put((byte)this.addressSize).put((byte)this.nameSize).put((byte)this.sizeSize).put((byte)this.totalSize).put((byte)this.childSize).putLong(this.spos).putLong(this.pos).putLong(this.nonRoot).putLong(this.hi.getBaseAddress()).putInt(this.hi.getRootChildrenLength()).putInt(this.hi.getAddressLength()).putInt(this.hi.getNameTableLength());
            byteBuffer.flip();
            directBuffer.flip();
            fileChannel.write(byteBuffer);
            fileChannel.write(byteBufferArray);
            for (n2 = 0; n2 < directBuffer.getNumberOfBuffers(); ++n2) {
                fileChannel.write(directBuffer.getBuffer(n2));
            }
            fileChannel.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        directBuffer = null;
        byteBufferArray = null;
    }

    void saveCompressed(File file, SaveViewerTask saveViewerTask) {
        long l = System.currentTimeMillis();
        ByteBuffer[] byteBufferArray = null;
        DirectBuffer directBuffer = new DirectBuffer();
        DirectBuffer directBuffer2 = new DirectBuffer();
        long l2 = 0L;
        int[] nArray = new int[this.hi.getNameTable().length];
        int[] nArray2 = new int[this.hi.getAddressLength()];
        int[] nArray3 = new int[this.hi.getAddressLength()];
        try {
            byte by;
            int n;
            int n2;
            int n3;
            byteBufferArray = new ByteBuffer[this.hi.getNameTable().length];
            this.spos = 0L;
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(0);
                saveViewerTask.setStatMessage("Calculating name address");
            }
            for (int i = 0; i < this.hi.getNameTable().length; ++i) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(10 * i / this.hi.getNameTable().length);
                }
                nArray[i] = (int)this.spos;
                byteBufferArray[i] = ByteBuffer.allocateDirect(this.hi.getNameTable(i).length() + 1);
                byteBufferArray[i].put(this.hi.getNameTable(i).getBytes());
                byteBufferArray[i].put((byte)0);
                byteBufferArray[i].flip();
                this.spos += (long)byteBufferArray[i].capacity();
            }
            System.out.println("String calc Completed in " + (System.currentTimeMillis() / 1000L - l / 1000L) + " seconds");
            System.out.println("spos(string table size)=" + this.spos);
            l2 = 0L;
            long l3 = System.currentTimeMillis();
            this.pos = 0L;
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(10);
                saveViewerTask.setStatMessage("Calculating entry address");
            }
            boolean[] blArray = new boolean[this.hi.getAddressLength()];
            for (n3 = 0; n3 < this.hi.getRootChildrenLength(); ++n3) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(10 + 5 * n3 / this.hi.getRootChildrenLength());
                }
                nArray2[this.hi.getRootChildren((int)n3)] = (int)this.pos;
                blArray[this.hi.getRootChildren((int)n3)] = true;
                this.pos += this.getCompressedUnitSize(this.hi.getRootChildren(n3), nArray);
            }
            this.nonRoot = this.pos;
            System.out.println("ientry root calc Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            l3 = System.currentTimeMillis();
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(15);
                saveViewerTask.setStatMessage("Calculating entry address");
            }
            for (n3 = 0; n3 < this.hi.getAddressLength(); ++n3) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(15 + 5 * n3 / this.hi.getAddressLength());
                }
                if (blArray[n3]) continue;
                nArray2[n3] = (int)this.pos;
                this.pos += this.getCompressedUnitSize(n3, nArray);
            }
            System.out.println("ientry calc non-root Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            System.out.println("pos(Size)=" + this.pos);
            l3 = System.currentTimeMillis();
            n3 = (int)this.pos;
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(15);
                saveViewerTask.setStatMessage("Calculating child address");
            }
            for (int i = 0; i < this.hi.getChild().length; ++i) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(15 + 5 * i / this.hi.getChild().length);
                }
                nArray3[i] = n3++;
                if (this.hi.getParent(i) >= 0) {
                    n3 += DirectBuffer.getSize(nArray2[this.hi.getParent(i)]);
                }
                if (this.hi.getChild()[i] != null) {
                    n3 += DirectBuffer.getSize(this.hi.getChild()[i].length);
                    for (int j = 0; j < this.hi.getChild()[i].length; ++j) {
                        n3 += DirectBuffer.getSize(nArray2[this.hi.getChild()[i][j]]);
                    }
                    continue;
                }
                ++n3;
            }
            System.out.println("ichild calc Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            System.out.println("childpos(ChildSize)=" + n3);
            System.out.println("total=" + ((long)n3 + this.pos + this.spos));
            l3 = System.currentTimeMillis();
            directBuffer.allocateDirect(this.pos);
            long l4 = 0L;
            int n4 = -1;
            long[] lArray = null;
            long[] lArray2 = null;
            String[] stringArray = null;
            if (this.hi.suspectList != null && this.hi.suspectList.length != 0) {
                lArray = new long[this.hi.suspectList.length];
                lArray2 = new long[this.hi.suspectList.length];
                stringArray = new String[this.hi.suspectList.length];
            }
            long[][] lArray3 = null;
            if (this.hi.suspectList != null && this.hi.suspectList.length != 0) {
                lArray3 = new long[2][this.hi.suspectList.length];
                for (int i = 0; i < this.hi.suspectList.length; ++i) {
                    lArray3[0][i] = this.hi.suspectList[i];
                    lArray3[1][i] = i;
                }
                Arrays2.sort(lArray3);
            }
            long l5 = 0L;
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(20);
                saveViewerTask.setStatMessage("Buffering root entries");
            }
            for (n2 = 0; n2 < this.hi.getRootChildrenLength(); ++n2) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(20 + 5 * n2 / this.hi.getRootChildrenLength());
                }
                l4 = this.hi.getOffsetAddress(this.hi.getRootChildren(n2));
                n4 = this.hi.suspectList != null ? Arrays.binarySearch(lArray3[0], l4 + this.hi.getBaseAddress()) : -1;
                if (n4 >= 0) {
                    n4 = (int)lArray3[1][n4];
                    lArray[n4] = directBuffer.position();
                    System.out.println("saving loc=" + lArray[n4]);
                    directBuffer.write(l4);
                    directBuffer.write(this.hi.getSize(this.hi.getRootChildren(n2)));
                    lArray2[n4] = l5 = this.hi.getTotal(this.hi.getRootChildren(n2));
                    directBuffer.write(l5 - (long)this.hi.getSize(this.hi.getRootChildren(n2)));
                    stringArray[n4] = this.hi.getName(this.hi.getRootChildren(n2));
                    if (stringArray[n4] == null) {
                        System.out.println("root null oname " + this.hi.getRootChildren(n2));
                    }
                    directBuffer.writeName(this.hi.isArray(this.hi.getRootChildren(n2)), this.hi.isClass(this.hi.getRootChildren(n2)), nArray[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                    directBuffer.putInt(nArray3[this.hi.getRootChildren(n2)]);
                    continue;
                }
                directBuffer.write(l4);
                directBuffer.write(this.hi.getSize(this.hi.getRootChildren(n2)));
                directBuffer.write(this.hi.getTotal(this.hi.getRootChildren(n2)) - (long)this.hi.getSize(this.hi.getRootChildren(n2)));
                directBuffer.writeName(this.hi.isArray(this.hi.getRootChildren(n2)), this.hi.isClass(this.hi.getRootChildren(n2)), nArray[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                directBuffer.putInt(nArray3[this.hi.getRootChildren(n2)]);
            }
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(25);
                saveViewerTask.setStatMessage("Buffering non-root entries");
            }
            for (n2 = 0; n2 < this.hi.getAddressLength(); ++n2) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(25 + 5 * n2 / this.hi.getAddressLength());
                }
                if (blArray[n2]) continue;
                l4 = this.hi.getOffsetAddress(n2);
                n4 = this.hi.suspectList != null ? Arrays.binarySearch(lArray3[0], l4 + this.hi.getBaseAddress()) : -1;
                if (n4 >= 0) {
                    n4 = (int)lArray3[1][n4];
                    lArray[n4] = directBuffer.position();
                    System.out.println("saving loc=" + lArray[n4]);
                    directBuffer.write(l4);
                    directBuffer.write(this.hi.getSize(n2));
                    lArray2[n4] = l5 = this.hi.getTotal(n2);
                    directBuffer.write(l5 - (long)this.hi.getSize(n2));
                    stringArray[n4] = this.hi.getName(n2);
                    if (stringArray[n4] == null) {
                        System.out.println("nonroot null oname " + n2);
                    }
                    directBuffer.writeName(this.hi.isArray(n2), this.hi.isClass(n2), nArray[this.hi.getNameKey(n2)]);
                    directBuffer.putInt(nArray3[n2]);
                    continue;
                }
                directBuffer.write(l4);
                directBuffer.write(this.hi.getSize(n2));
                directBuffer.write(this.hi.getTotal(n2) - (long)this.hi.getSize(n2));
                directBuffer.writeName(this.hi.isArray(n2), this.hi.isClass(n2), nArray[this.hi.getNameKey(n2)]);
                directBuffer.putInt(nArray3[n2]);
            }
            blArray = null;
            System.out.println("entry buffer write Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            l3 = System.currentTimeMillis();
            directBuffer2.allocateDirect(n3);
            for (n2 = 0; n2 < this.hi.getChild().length; ++n2) {
                if (this.hi.getParent(n2) < 0) {
                    directBuffer2.write(-1L);
                } else {
                    directBuffer2.write(nArray2[this.hi.getParent(n2)]);
                }
                if (this.hi.getChild()[n2] != null) {
                    directBuffer2.write(this.hi.getChild()[n2].length);
                    for (int i = 0; i < this.hi.getChild()[n2].length; ++i) {
                        directBuffer2.write(nArray2[this.hi.getChild()[n2][i]]);
                    }
                    continue;
                }
                directBuffer2.write(0L);
            }
            System.out.println("child buffer write Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            char[] cArray = HAV_SIGNATURE.toCharArray();
            int n5 = 61 + cArray.length;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
            ByteBuffer byteBuffer2 = null;
            int n6 = 0;
            if (this.hi.suspectList != null && (n6 = this.hi.suspectList.length) != 0) {
                int n7;
                int n8 = 0;
                for (n7 = 0; n7 < lArray.length; ++n7) {
                    n8 += stringArray[n7].length() + 1;
                }
                byteBuffer2 = ByteBuffer.allocateDirect(16 * this.hi.suspectList.length + this.hi.suspectList.length * n8);
                for (n7 = 0; n7 < lArray.length; ++n7) {
                    byteBuffer2.putLong(lArray[n7]).putLong(lArray2[n7]);
                }
                char[] cArray2 = null;
                for (int i = 0; i < lArray.length; ++i) {
                    cArray2 = stringArray[i].toCharArray();
                    for (n = 0; n < cArray2.length; ++n) {
                        byteBuffer2.put((byte)cArray2[n]);
                    }
                    byteBuffer2.put((byte)0);
                }
                byteBuffer2.flip();
            }
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(this.hi.getDumpInfo().length() + 1);
            for (by = 0; by < cArray.length; ++by) {
                byteBuffer.put((byte)cArray[by]);
            }
            by = 0;
            if (this.hi.isLongAddress()) {
                by = 1;
            }
            byteBuffer.put(by).putInt(n6).putLong(this.hi.getHeapSize()).putLong(this.spos).putLong(this.pos).putLong(this.nonRoot).putLong(this.hi.getBaseAddress()).putInt(this.hi.getRootChildrenLength()).putInt(this.hi.getAddressLength()).putInt(this.hi.getNameTableLength()).putInt(this.hi.getDumpInfo().length() + 1);
            char[] cArray3 = this.hi.getDumpInfo().toCharArray();
            for (n = 0; n < cArray3.length; ++n) {
                byteBuffer3.put((byte)cArray3[n]);
            }
            byteBuffer3.put((byte)0);
            byteBuffer3.flip();
            byteBuffer.flip();
            directBuffer.flip();
            directBuffer2.flip();
            l3 = System.currentTimeMillis();
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(30);
                saveViewerTask.setStatMessage("Saving header");
            }
            fileChannel.write(byteBuffer);
            if (byteBuffer2 != null) {
                if (saveViewerTask != null) {
                    saveViewerTask.setCurrent(35);
                    saveViewerTask.setStatMessage("Saving leak suspects");
                }
                fileChannel.write(byteBuffer2);
            }
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(40);
                saveViewerTask.setStatMessage("Saving dump information");
            }
            fileChannel.write(byteBuffer3);
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(50);
                saveViewerTask.setStatMessage("Saving name entries");
            }
            fileChannel.write(byteBufferArray);
            System.out.println("header/string Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            l3 = System.currentTimeMillis();
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(60);
                saveViewerTask.setStatMessage("Saving Heap entries");
            }
            for (n = 0; n < directBuffer.getNumberOfBuffers(); ++n) {
                fileChannel.write(directBuffer.getBuffer(n));
            }
            System.out.println("entry Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            l3 = System.currentTimeMillis();
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(80);
                saveViewerTask.setStatMessage("Saving children");
            }
            for (n = 0; n < directBuffer2.getNumberOfBuffers(); ++n) {
                fileChannel.write(directBuffer2.getBuffer(n));
            }
            if (saveViewerTask != null) {
                saveViewerTask.setCurrent(100);
                saveViewerTask.setStatMessage(file.getName() + " was successfully saved");
            }
            System.out.println("Child Completed in " + (System.currentTimeMillis() / 1000L - l3 / 1000L) + " seconds");
            fileChannel.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        directBuffer = null;
        byteBufferArray = null;
        System.out.println("Completed in " + (System.currentTimeMillis() / 1000L - l / 1000L) + " seconds");
    }

    void saveGzip(File file) {
        long l = 0L;
        this.stringLocation = new long[this.hi.getNameTable().length];
        this.entryLocation = new long[this.hi.getAddressLength()];
        for (int i = 0; i < this.entryLocation.length; ++i) {
            this.entryLocation[i] = -1L;
        }
        try {
            int n;
            int n2;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 1000000);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(gZIPOutputStream);
            char[] cArray = HAV_SIGNATURE.toCharArray();
            int n3 = 61 + cArray.length;
            int n4 = 0;
            for (n2 = 0; n2 < this.hi.getChild().length; ++n2) {
                if (this.hi.getChild()[n2] == null) continue;
                if (this.hi.getChild().length > n4) {
                    n4 = this.hi.getChild().length;
                }
                l += (long)this.hi.getChild()[n2].length;
            }
            this.findChildSize(n4);
            this.spos = 0L;
            for (n2 = 0; n2 < this.hi.getNameTable().length; ++n2) {
                this.stringLocation[n2] = this.spos;
                this.spos += (long)(this.hi.getNameTable(n2).length() + 1);
            }
            if (this.spos > Integer.MAX_VALUE) {
                this.pointerSize = 8;
                this.nameSize = 8;
            } else {
                this.pointerSize = this.calculatePointerSize();
            }
            this.pos = 0L;
            for (n2 = 0; n2 < this.hi.getRootChildrenLength(); ++n2) {
                this.entryLocation[this.hi.getRootChildren((int)n2)] = this.pos;
                this.pos += this.getUnitSize(this.hi.getRootChildren(n2));
            }
            this.nonRoot = this.pos;
            for (n2 = 0; n2 < this.hi.getAddressLength(); ++n2) {
                if (this.entryLocation[n2] != -1L) continue;
                this.entryLocation[n2] = this.pos;
                this.pos += this.getUnitSize(n2);
            }
            for (n2 = 0; n2 < cArray.length; ++n2) {
                dataOutputStream.writeByte((byte)cArray[n2]);
            }
            dataOutputStream.writeByte((byte)this.pointerSize);
            dataOutputStream.writeByte((byte)this.addressSize);
            dataOutputStream.writeByte((byte)this.nameSize);
            dataOutputStream.writeByte((byte)this.sizeSize);
            dataOutputStream.writeByte((byte)this.totalSize);
            dataOutputStream.writeByte((byte)this.childSize);
            dataOutputStream.writeLong(this.spos);
            dataOutputStream.writeLong(this.pos);
            dataOutputStream.writeLong(this.nonRoot);
            dataOutputStream.writeLong(this.hi.getBaseAddress());
            dataOutputStream.writeInt(this.hi.getRootChildrenLength());
            dataOutputStream.writeInt(this.hi.getAddressLength());
            dataOutputStream.writeInt(this.hi.getNameTableLength());
            for (n2 = 0; n2 < this.hi.getNameTable().length; ++n2) {
                dataOutputStream.write(this.hi.getNameTable(n2).getBytes());
                dataOutputStream.writeByte(0);
            }
            l = l * (long)this.pointerSize + (long)(this.hi.getAddressLength() * (this.pointerSize + this.addressSize + this.sizeSize + this.totalSize + this.nameSize + this.childSize));
            for (n2 = 0; n2 < this.hi.getRootChildrenLength(); ++n2) {
                if (this.addressSize == 8) {
                    dataOutputStream.writeLong(this.hi.getAddress(this.hi.getRootChildren(n2)));
                } else {
                    dataOutputStream.writeInt((int)this.hi.getAddress(this.hi.getRootChildren(n2)));
                }
                if (this.hi.isArray(this.hi.getRootChildren(n2))) {
                    if (this.sizeSize == 1) {
                        dataOutputStream.writeByte((byte)((byte)this.hi.getSize(this.hi.getRootChildren(n2)) | 0xFFFFFF80));
                    } else if (this.sizeSize == 2) {
                        dataOutputStream.writeShort((short)((short)this.hi.getSize(this.hi.getRootChildren(n2)) | Short.MIN_VALUE));
                    } else {
                        dataOutputStream.writeInt(this.hi.getSize(this.hi.getRootChildren(n2)) | Integer.MIN_VALUE);
                    }
                } else if (this.sizeSize == 1) {
                    dataOutputStream.writeByte((byte)this.hi.getSize(this.hi.getRootChildren(n2)));
                } else if (this.sizeSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getSize(this.hi.getRootChildren(n2)));
                } else {
                    dataOutputStream.writeInt(this.hi.getSize(this.hi.getRootChildren(n2)));
                }
                if (n2 < 10) {
                    System.out.println("i=" + n2 + " total=" + this.hi.getTotal(this.hi.getRootChildren(n2)));
                }
                if (this.totalSize == 1) {
                    dataOutputStream.writeByte((byte)this.hi.getTotal(this.hi.getRootChildren(n2)));
                } else if (this.totalSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getTotal(this.hi.getRootChildren(n2)));
                } else if (this.totalSize == 4) {
                    dataOutputStream.writeInt((int)this.hi.getTotal(this.hi.getRootChildren(n2)));
                } else {
                    dataOutputStream.writeLong(this.hi.getTotal(this.hi.getRootChildren(n2)));
                }
                if (this.hi.isClass(this.hi.getRootChildren(n2))) {
                    if (this.nameSize == 8) {
                        dataOutputStream.writeLong(Long.MIN_VALUE | this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                    } else if (this.nameSize == 4) {
                        dataOutputStream.writeInt(Integer.MIN_VALUE | (int)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                    } else if (this.nameSize == 2) {
                        dataOutputStream.writeShort((short)(Short.MIN_VALUE | (short)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]));
                    } else {
                        dataOutputStream.writeByte((byte)(0xFFFFFF80 | (byte)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]));
                    }
                } else if (this.nameSize == 8) {
                    dataOutputStream.writeLong(this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                } else if (this.nameSize == 4) {
                    dataOutputStream.writeInt((int)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                } else if (this.nameSize == 2) {
                    dataOutputStream.writeShort((short)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                } else {
                    dataOutputStream.writeByte((byte)this.stringLocation[this.hi.getNameKey(this.hi.getRootChildren(n2))]);
                }
                if (this.pointerSize == 8) {
                    dataOutputStream.writeLong(-1L);
                } else {
                    dataOutputStream.writeInt(-1);
                }
                if (this.hi.getChild()[this.hi.getRootChildren(n2)] == null) {
                    if (this.childSize == 8) {
                        dataOutputStream.writeLong(0L);
                    } else if (this.childSize == 4) {
                        dataOutputStream.writeInt(0);
                    } else if (this.childSize == 2) {
                        dataOutputStream.writeShort(0);
                    } else {
                        dataOutputStream.writeByte(0);
                    }
                } else if (this.childSize == 1) {
                    dataOutputStream.writeByte((byte)this.hi.getChild()[this.hi.getRootChildren(n2)].length);
                } else if (this.childSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getChild()[this.hi.getRootChildren(n2)].length);
                } else if (this.childSize == 4) {
                    dataOutputStream.writeInt(this.hi.getChild()[this.hi.getRootChildren(n2)].length);
                } else {
                    dataOutputStream.writeLong(this.hi.getChild()[this.hi.getRootChildren(n2)].length);
                }
                if (this.hi.getChild()[this.hi.getRootChildren(n2)] == null) continue;
                for (n = 0; n < this.hi.getChild()[this.hi.getRootChildren(n2)].length; ++n) {
                    if (this.pointerSize == 8) {
                        dataOutputStream.writeLong(this.entryLocation[this.hi.getChild()[this.hi.getRootChildren(n2)][n]]);
                        continue;
                    }
                    dataOutputStream.writeInt((int)this.entryLocation[this.hi.getChild()[this.hi.getRootChildren(n2)][n]]);
                }
            }
            for (n2 = 0; n2 < this.hi.getAddressLength(); ++n2) {
                if (this.hi.getParent()[n2] < 0) continue;
                if (this.addressSize == 8) {
                    dataOutputStream.writeLong(this.hi.getAddress(n2));
                } else {
                    dataOutputStream.writeInt((int)this.hi.getAddress(n2));
                }
                if (this.hi.isArray(n2)) {
                    if (this.sizeSize == 4) {
                        dataOutputStream.writeInt(this.hi.getSize(n2) | Integer.MIN_VALUE);
                    } else if (this.sizeSize == 2) {
                        dataOutputStream.writeShort((short)((short)this.hi.getSize(n2) | Short.MIN_VALUE));
                    } else {
                        dataOutputStream.writeByte((byte)((byte)this.hi.getSize(n2) | 0xFFFFFF80));
                    }
                } else if (this.sizeSize == 4) {
                    dataOutputStream.writeInt(this.hi.getSize(n2));
                } else if (this.sizeSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getSize(n2));
                } else {
                    dataOutputStream.writeByte((byte)this.hi.getSize(n2));
                }
                if (this.totalSize == 8) {
                    dataOutputStream.writeLong(this.hi.getTotal(n2));
                } else if (this.totalSize == 4) {
                    dataOutputStream.writeInt((int)this.hi.getTotal(n2));
                } else if (this.totalSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getTotal(n2));
                } else {
                    dataOutputStream.writeByte((byte)this.hi.getTotal(n2));
                }
                if (this.hi.isClass(n2)) {
                    if (this.nameSize == 8) {
                        dataOutputStream.writeLong(Long.MIN_VALUE | this.stringLocation[this.hi.getNameKey(n2)]);
                    } else if (this.nameSize == 4) {
                        dataOutputStream.writeInt(Integer.MIN_VALUE | (int)this.stringLocation[this.hi.getNameKey(n2)]);
                    } else if (this.nameSize == 2) {
                        dataOutputStream.writeShort((short)(Short.MIN_VALUE | (short)this.stringLocation[this.hi.getNameKey(n2)]));
                    } else {
                        dataOutputStream.writeByte((byte)(0xFFFFFF80 | (byte)this.stringLocation[this.hi.getNameKey(n2)]));
                    }
                } else if (this.nameSize == 8) {
                    dataOutputStream.writeLong(this.stringLocation[this.hi.getNameKey(n2)]);
                } else if (this.nameSize == 4) {
                    dataOutputStream.writeInt((int)this.stringLocation[this.hi.getNameKey(n2)]);
                } else if (this.nameSize == 2) {
                    dataOutputStream.writeShort((short)this.stringLocation[this.hi.getNameKey(n2)]);
                } else {
                    dataOutputStream.writeByte((byte)this.stringLocation[this.hi.getNameKey(n2)]);
                }
                if (this.pointerSize == 8) {
                    dataOutputStream.writeLong(this.entryLocation[this.hi.getParent()[n2]]);
                } else {
                    dataOutputStream.writeInt((int)this.entryLocation[this.hi.getParent()[n2]]);
                }
                if (this.hi.getChild()[n2] == null) {
                    if (this.childSize == 8) {
                        dataOutputStream.writeLong(0L);
                    } else if (this.childSize == 4) {
                        dataOutputStream.writeInt(0);
                    } else if (this.childSize == 2) {
                        dataOutputStream.writeShort(0);
                    } else {
                        dataOutputStream.writeByte(0);
                    }
                } else if (this.childSize == 8) {
                    dataOutputStream.writeLong(this.hi.getChild()[n2].length);
                } else if (this.childSize == 4) {
                    dataOutputStream.writeInt(this.hi.getChild()[n2].length);
                } else if (this.childSize == 2) {
                    dataOutputStream.writeShort((short)this.hi.getChild()[n2].length);
                } else {
                    dataOutputStream.writeByte((byte)this.hi.getChild()[n2].length);
                }
                if (this.hi.getChild()[n2] == null) continue;
                for (n = 0; n < this.hi.getChild()[n2].length; ++n) {
                    if (this.pointerSize == 8) {
                        dataOutputStream.writeLong(this.entryLocation[this.hi.getChild()[n2][n]]);
                        continue;
                    }
                    dataOutputStream.writeInt((int)this.entryLocation[this.hi.getChild()[n2][n]]);
                }
            }
            gZIPOutputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void open(File file) {
        long l = 0L;
        try {
            int n;
            this.raf = new RandomAccessFile(file, "r");
            int n2 = HAV_SIGNATURE.length();
            int n3 = 61;
            this.raf.seek(n2);
            byte by = this.raf.readByte();
            if (by == 1) {
                this.setLongAddress();
            }
            if ((n = this.raf.readInt()) != 0) {
                this.hi.suspectList = new long[n];
                this.hi.suspectTotalList = new long[n];
                this.hi.suspectNameList = new String[n];
            }
            this.hi.setHeapSize(this.raf.readLong());
            this.spos = this.raf.readLong();
            this.pos = this.raf.readLong();
            this.nonRoot = this.raf.readLong();
            l = this.raf.readLong();
            this.hi.setBaseAddress(l);
            this.setRootChildrenLength(this.raf.readInt());
            this.setNumberOfEntries(this.raf.readInt());
            this.setNameTableLength(this.raf.readInt());
            int n4 = this.raf.readInt();
            int n5 = 0;
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    this.hi.suspectList[i] = this.raf.readLong();
                    this.hi.suspectTotalList[i] = this.raf.readLong();
                    System.out.println("leak=" + this.hi.suspectList[i]);
                }
                char[] cArray = new char[500];
                byte by2 = 0;
                int n6 = 0;
                for (int i = 0; i < n; ++i) {
                    for (n6 = 0; n6 < cArray.length; ++n6) {
                        by2 = this.raf.readByte();
                        ++n5;
                        if (by2 == 0) break;
                        cArray[n6] = (char)by2;
                    }
                    this.hi.suspectNameList[i] = String.copyValueOf(cArray, 0, n6);
                    System.out.println("leak name=" + this.hi.suspectNameList[i]);
                }
            }
            byte by3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((by3 = this.raf.readByte()) != 0) {
                stringBuffer.append((char)by3);
            }
            this.hi.setDumpInfo(stringBuffer.toString());
            System.out.println("DumpInfoLength=" + n4 + "headersize=" + (n3 += n2 + n4 + n * 8 * 2 + n5) + " sigSize=" + n2 + " spos=" + this.spos + " pos=" + this.pos + " nonRoot=" + this.nonRoot);
            this.setStringBaseLocation(n3);
            this.setHeapBaseLocation((long)n3 + this.spos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    long readAddress() {
        if (this.addressSize == 8) {
            return this.heapBuffer.getLong();
        }
        return this.heapBuffer.getInt();
    }

    long readSize() {
        if (this.sizeSize == 8) {
            return this.heapBuffer.getLong();
        }
        if (this.sizeSize == 4) {
            int n = this.heapBuffer.getInt();
            if (n < 0) {
                return (long)(n &= Integer.MAX_VALUE) | Long.MIN_VALUE;
            }
            return n;
        }
        if (this.sizeSize == 2) {
            short s = this.heapBuffer.getShort();
            if (s < 0) {
                s = (short)(s & Short.MAX_VALUE);
                return (long)s | Long.MIN_VALUE;
            }
            return s;
        }
        byte by = this.heapBuffer.get();
        if (by < 0) {
            by = (byte)(by & 0x7F);
            return (long)by | Long.MIN_VALUE;
        }
        return by;
    }

    int readSizeInt() {
        if (this.sizeSize == 8) {
            return (int)this.heapBuffer.getLong();
        }
        if (this.sizeSize == 4) {
            return this.heapBuffer.getInt();
        }
        if (this.sizeSize == 2) {
            short s = this.heapBuffer.getShort();
            if (s < 0) {
                s = (short)(s & Short.MAX_VALUE);
                return s | Integer.MIN_VALUE;
            }
            return s;
        }
        byte by = this.heapBuffer.get();
        if (by < 0) {
            by = (byte)(by & 0x7F);
            return by | Integer.MIN_VALUE;
        }
        return by;
    }

    long readActualSize() {
        if (this.sizeSize == 8) {
            return this.heapBuffer.getLong() & Long.MAX_VALUE;
        }
        if (this.sizeSize == 4) {
            return this.heapBuffer.getInt() & Integer.MAX_VALUE;
        }
        if (this.sizeSize == 2) {
            return this.heapBuffer.getShort() & Short.MAX_VALUE;
        }
        return this.heapBuffer.get() & 0x7F;
    }

    void skipSize() {
        if (this.sizeSize == 8) {
            this.heapBuffer.getLong();
        } else if (this.sizeSize == 4) {
            this.heapBuffer.getInt();
        } else if (this.sizeSize == 2) {
            this.heapBuffer.getShort();
        } else {
            this.heapBuffer.get();
        }
    }

    long readTotal() {
        if (this.totalSize == 8) {
            return this.heapBuffer.getLong();
        }
        if (this.totalSize == 4) {
            return this.heapBuffer.getInt();
        }
        if (this.totalSize == 2) {
            return this.heapBuffer.getShort();
        }
        return this.heapBuffer.get();
    }

    long skipName() {
        if (this.nameSize == 8) {
            return this.heapBuffer.getLong();
        }
        if (this.nameSize == 4) {
            return this.heapBuffer.getInt();
        }
        if (this.nameSize == 2) {
            return this.heapBuffer.getShort();
        }
        return this.heapBuffer.get();
    }

    long readActualName() {
        if (this.nameSize == 8) {
            return this.heapBuffer.getLong() & Long.MAX_VALUE;
        }
        if (this.nameSize == 4) {
            return this.heapBuffer.getInt() & Integer.MAX_VALUE;
        }
        if (this.nameSize == 2) {
            return this.heapBuffer.getShort() & Short.MAX_VALUE;
        }
        return this.heapBuffer.get() & 0x7F;
    }

    long readName2() {
        if (this.nameSize == 8) {
            return this.heapBuffer.getLong();
        }
        if (this.nameSize == 4) {
            int n = this.heapBuffer.getInt();
            if (n < 0) {
                return (long)(n &= Integer.MAX_VALUE) | Long.MIN_VALUE;
            }
            return n;
        }
        if (this.nameSize == 2) {
            short s = this.heapBuffer.getShort();
            if (s < 0) {
                s = (short)(s & Short.MAX_VALUE);
                return (long)s | Long.MIN_VALUE;
            }
            return s;
        }
        byte by = this.heapBuffer.get();
        if (by < 0) {
            by = (byte)(by & 0x7F);
            return (long)by | Long.MIN_VALUE;
        }
        return by;
    }

    long readParent() {
        if (this.pointerSize == 8) {
            return this.heapBuffer.getLong();
        }
        return this.heapBuffer.getInt();
    }

    long readNChild() {
        if (this.childSize == 8) {
            return this.heapBuffer.getLong();
        }
        if (this.childSize == 4) {
            return this.heapBuffer.getInt();
        }
        if (this.childSize == 2) {
            return this.heapBuffer.getShort();
        }
        return this.heapBuffer.get();
    }

    int readPointer() {
        if (this.pointerSize == 8) {
            return (int)this.heapBuffer.getLong();
        }
        return this.heapBuffer.getInt();
    }

    void skipChild() {
        long l = this.readNChild();
        int n = 0;
        while ((long)n < l) {
            this.readPointer();
            ++n;
        }
    }

    public long readORG() throws IOException {
        byte by = this.raf.readByte();
        if ((by & 0x80) != 128) {
            if (by == 127) {
                return -1L;
            }
            return by;
        }
        if ((by & 0xC0) == 128) {
            byte by2 = this.raf.readByte();
            return by2 & 0xFF | (by & 0x7F) << 8;
        }
        if ((by & 0xE0) == 192) {
            short s = this.raf.readShort();
            return s & 0xFFFF | (by & 0x1F) << 16;
        }
        if ((by & 0xF0) == 224) {
            byte by3 = this.raf.readByte();
            short s = this.raf.readShort();
            return s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 0xF) << 24;
        }
        if ((by & 0xF8) == 240) {
            int n = this.raf.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by & 7) << 32);
        }
        if ((by & 0xFC) == 248) {
            byte by4 = this.raf.readByte();
            int n = this.raf.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)((by & 3) << 40);
        }
        short s = this.raf.readShort();
        int n = this.raf.readInt();
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)((by & 3) << 48);
    }

    public long read(RandomAccessFile randomAccessFile) throws IOException {
        byte by = randomAccessFile.readByte();
        if ((by & 0x80) != 128) {
            if (by == 127) {
                return -1L;
            }
            return by;
        }
        if ((by & 0xC0) == 128) {
            byte by2 = randomAccessFile.readByte();
            return by2 & 0xFF | (by & 0x7F) << 8;
        }
        if ((by & 0xE0) == 192) {
            short s = randomAccessFile.readShort();
            return s & 0xFFFF | (by & 0x1F) << 16;
        }
        if ((by & 0xF0) == 224) {
            byte by3 = randomAccessFile.readByte();
            short s = randomAccessFile.readShort();
            return s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 0xF) << 24;
        }
        if ((by & 0xF8) == 240) {
            int n = randomAccessFile.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by & 7) << 32);
        }
        if ((by & 0xFC) == 248) {
            byte by4 = randomAccessFile.readByte();
            int n = randomAccessFile.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)((by & 3) << 40);
        }
        byte by5 = randomAccessFile.readByte();
        short s = randomAccessFile.readShort();
        int n = randomAccessFile.readInt();
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)((by5 & 0xFF) << 40) | (long)((by & 3) << 48);
    }

    public long readNameORG() throws IOException {
        byte by = this.raf.readByte();
        if ((by & 0x20) != 32) {
            if ((by & 0x1F) == 31) {
                return -1L;
            }
            return (long)(by & 0x3F) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x30) == 32) {
            byte by2 = this.raf.readByte();
            return (long)(by2 & 0xFF | (by & 0x1F) << 8) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x38) == 48) {
            short s = this.raf.readShort();
            return (long)(s & 0xFFFF | (by & 0xF) << 16) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3C) == 56) {
            byte by3 = this.raf.readByte();
            short s = this.raf.readShort();
            return (long)(s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 3) << 24) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3E) == 60) {
            int n = this.raf.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by & 1) << 32) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3F) == 62) {
            byte by4 = this.raf.readByte();
            int n = this.raf.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)(by & 0xC0) << 56;
        }
        byte by5 = this.raf.readByte();
        short s = this.raf.readShort();
        int n = this.raf.readInt();
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)(by5 << 48) | (long)(by & 0xC0) << 56;
    }

    public long readName(RandomAccessFile randomAccessFile) throws IOException {
        byte by = randomAccessFile.readByte();
        if ((by & 0x20) != 32) {
            if ((by & 0x1F) == 31) {
                return -1L;
            }
            return (long)(by & 0x3F) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x30) == 32) {
            byte by2 = randomAccessFile.readByte();
            return (long)(by2 & 0xFF | (by & 0x1F) << 8) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x38) == 48) {
            short s = randomAccessFile.readShort();
            return (long)(s & 0xFFFF | (by & 0xF) << 16) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3C) == 56) {
            byte by3 = randomAccessFile.readByte();
            short s = randomAccessFile.readShort();
            return (long)(s & 0xFFFF | (by3 & 0xFF) << 16 | (by & 3) << 24) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3E) == 60) {
            int n = randomAccessFile.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by & 1) << 32) | (long)(by & 0xC0) << 56;
        }
        if ((by & 0x3F) == 62) {
            byte by4 = randomAccessFile.readByte();
            int n = randomAccessFile.readInt();
            return (long)n & 0xFFFFFFFFL | (long)((by4 & 0xFF) << 32) | (long)(by & 0xC0) << 56;
        }
        byte by5 = randomAccessFile.readByte();
        short s = randomAccessFile.readShort();
        int n = randomAccessFile.readInt();
        return (long)n & 0xFFFFFFFFL | (long)((s & 0xFFFF) << 32) | (long)(by5 << 48) | (long)(by & 0xC0) << 56;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLeaf(long l) {
        if (this.raf != null) {
            long l2;
            block8: {
                l2 = 0L;
                HeapCache heapCache = null;
                try {
                    heapCache = this.getHeapCache(l);
                    if (heapCache == null) {
                        RandomAccessFile randomAccessFile = this.raf;
                        synchronized (randomAccessFile) {
                            this.raf.seek(l + this.getHeapBaseLocation());
                            this.read(this.raf);
                            this.read(this.raf);
                            this.read(this.raf);
                            this.readName(this.raf);
                            int n = this.raf.readInt();
                            long l3 = n & 0xFFFFFFFF;
                            if (l3 + this.getHeapBaseLocation() < 0L) {
                                System.out.println("Negative seek=" + (l3 + this.getHeapBaseLocation()));
                            }
                            this.raf.seek(l3 + this.getHeapBaseLocation());
                            this.read(this.raf);
                            l2 = this.read(this.raf);
                            break block8;
                        }
                    }
                    l2 = heapCache.getNumberOfChildren();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l2 == 0L;
        }
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.readName();
        long l4 = this.heapBuffer.getInt() & 0xFFFFFFFF;
        this.heapBuffer.position(l4);
        this.heapBuffer.read();
        long l5 = this.heapBuffer.read();
        return l5 == 0L;
    }

    boolean isLeafCache(long l) {
        if (l == -1L) {
            return false;
        }
        HeapCache heapCache = this.returnHeapCache(l, true);
        if (heapCache == null) {
            return false;
        }
        int n = heapCache.getNumberOfChildren();
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRootChildren(int n) {
        long l = 0L;
        int n2 = 0;
        Object var5_4 = null;
        if (this.raf != null) {
            try {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    this.raf.seek(this.getHeapBaseLocation());
                    while (this.raf.getFilePointer() - this.getHeapBaseLocation() < this.nonRoot) {
                        l = this.raf.getFilePointer();
                        if (n2 == n) {
                            return l - this.getHeapBaseLocation();
                        }
                        this.read(this.raf);
                        this.read(this.raf);
                        this.read(this.raf);
                        this.readName(this.raf);
                        this.raf.readInt();
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return n;
        }
        DirectBuffer directBuffer = this.heapBuffer;
        synchronized (directBuffer) {
            this.heapBuffer.rewind();
            while (this.heapBuffer.position() < this.nonRoot) {
                l = this.heapBuffer.position();
                if (n2 == n) {
                    return l;
                }
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.readName();
                this.heapBuffer.getInt();
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(long l) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.raf != null) {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                try {
                    byte by2;
                    this.raf.seek(l + this.getStringBaseLocation());
                    while ((by2 = this.raf.readByte()) != 0) {
                        stringBuffer.append((char)by2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.stringBuffer.rewind();
        try {
            this.stringBuffer.position((int)l);
        }
        catch (Exception exception) {
            System.out.println("Break point");
        }
        while ((by = this.stringBuffer.get()) != 0) {
            stringBuffer.append((char)by);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNameHeap(long l) {
        StringBuffer stringBuffer = null;
        String string = null;
        if (this.raf != null) {
            try {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    this.raf.seek(l + this.getHeapBaseLocation());
                    this.read(this.raf);
                    this.read(this.raf);
                    this.read(this.raf);
                    long l2 = this.readName(this.raf);
                    string = this.getNameCache(l2);
                    if (string == null) {
                        byte by;
                        stringBuffer = (l2 & Long.MIN_VALUE) == Long.MIN_VALUE ? new StringBuffer("array of ") : ((l2 & 0x4000000000000000L) == 0x4000000000000000L ? new StringBuffer("class ") : new StringBuffer());
                        this.raf.seek(this.getStringBaseLocation() + (long)((int)(l2 & 0x3FFFFFFFFFFFFFFFL)));
                        while ((by = this.raf.readByte()) != 0) {
                            stringBuffer.append((char)by);
                        }
                    } else {
                        return string;
                    }
                    this.putNameCache(l2, stringBuffer.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            long l3;
            Object object = this.heapBuffer;
            synchronized (object) {
                this.heapBuffer.rewind();
                this.heapBuffer.position(l);
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.read();
                l3 = this.heapBuffer.readName();
            }
            stringBuffer = (l3 & Long.MIN_VALUE) == Long.MIN_VALUE ? new StringBuffer("array of ") : ((l3 & 0x4000000000000000L) == 0x4000000000000000L ? new StringBuffer("class ") : new StringBuffer());
            object = this.stringBuffer;
            synchronized (object) {
                byte by;
                this.stringBuffer.rewind();
                this.stringBuffer.position((int)(l3 & 0x3FFFFFFFFFFFFFFFL));
                while ((by = this.stringBuffer.get()) != 0) {
                    stringBuffer.append((char)by);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getObjectNameHeap(long l) {
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    try {
                        byte by;
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        this.read(this.raf);
                        this.read(this.raf);
                        long l3 = this.readName(this.raf);
                        this.raf.seek(this.getStringBaseLocation() + (long)((int)(l3 & 0x3FFFFFFFFFFFFFFFL)));
                        while ((by = this.raf.readByte()) != 0) {
                            stringBuffer.append((char)by);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return stringBuffer.toString();
                }
            }
            long l4 = heapCache.getNameLocation();
            string = this.getNameCache(l4 & 0x3FFFFFFFFFFFFFFFL);
            if (string != null) return string;
            try {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    byte by;
                    this.raf.seek(this.getStringBaseLocation() + (long)((int)(l4 & 0x3FFFFFFFFFFFFFFFL)));
                    while ((by = this.raf.readByte()) != 0) {
                        stringBuffer.append((char)by);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.putNameCache(l4 & 0x3FFFFFFFFFFFFFFFL, stringBuffer.toString());
            return stringBuffer.toString();
        }
        Object object = this.heapBuffer;
        synchronized (object) {
            this.heapBuffer.rewind();
            this.heapBuffer.position(l);
            this.heapBuffer.read();
            this.heapBuffer.read();
            this.heapBuffer.read();
            l2 = this.heapBuffer.readName();
        }
        object = this.stringBuffer;
        synchronized (object) {
            byte by;
            this.stringBuffer.rewind();
            this.stringBuffer.position((int)(l2 & 0x3FFFFFFFFFFFFFFFL));
            while ((by = this.stringBuffer.get()) != 0) {
                stringBuffer.append((char)by);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNameAddress(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    try {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        this.read(this.raf);
                        this.read(this.raf);
                        return this.readName(this.raf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return -1L;
                    }
                }
            }
            return heapCache.getNameLocation();
        }
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        return this.heapBuffer.readName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfChild(long l, long l2) {
        int n;
        long l3;
        Object object;
        long[] lArray = null;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        ArrayList<Long> arrayList4 = new ArrayList<Long>();
        HeapCache heapCache = null;
        if (this.raf != null) {
            try {
                if (l == -1L) {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(this.getHeapBaseLocation());
                        int n2 = 0;
                        while (this.raf.getFilePointer() - this.getHeapBaseLocation() < this.nonRoot) {
                            if (this.raf.getFilePointer() - this.getHeapBaseLocation() == l2) {
                                return n2;
                            }
                            this.read(this.raf);
                            this.read(this.raf);
                            this.read(this.raf);
                            this.readName(this.raf);
                            this.raf.readInt();
                            ++n2;
                        }
                    }
                    return -1;
                }
                heapCache = this.getHeapCache(l);
                if (heapCache == null) {
                    heapCache = new HeapCache();
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        int n3;
                        this.raf.seek(l + this.getHeapBaseLocation());
                        heapCache.setAddress(this.read(this.raf));
                        heapCache.setSize((int)this.read(this.raf));
                        heapCache.setTotalSize(this.read(this.raf));
                        heapCache.setNameLocation(this.readName(this.raf));
                        long l8 = this.raf.readInt() & 0xFFFFFFFF;
                        this.raf.seek(l8 + this.getHeapBaseLocation());
                        heapCache.setChildLocation(l8);
                        heapCache.setParentLocation(this.read(this.raf));
                        long l9 = this.read(this.raf);
                        heapCache.setNumberOfChildren((int)l9);
                        heapCache.setChild(new long[(int)l9]);
                        long l10 = 0L;
                        long l11 = 0L;
                        long l12 = 0L;
                        Object var30_33 = null;
                        int n4 = 0;
                        while ((long)n4 < l9) {
                            l6 = this.read(this.raf);
                            if (l6 == l2) {
                                return n4;
                            }
                            ++n4;
                        }
                        long[][] lArray2 = new long[2][arrayList.size()];
                        long l13 = 0L;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            l13 = (Long)arrayList.get(i);
                            lArray2[0][i] = (Long)arrayList3.get(i);
                            lArray2[1][i] = l13;
                        }
                        long[][] lArray3 = new long[2][arrayList2.size()];
                        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                            l13 = (Long)arrayList2.get(n3);
                            lArray3[0][n3] = (Long)arrayList4.get(n3);
                            lArray3[1][n3] = l13;
                        }
                        Arrays2.sort(lArray3);
                        Arrays2.sort(lArray2);
                        n3 = arrayList.size();
                        int n5 = 0;
                        int n6 = n3 - 1;
                        while (n5 < n3) {
                            heapCache.setChild(n5, lArray2[1][n6]);
                            ++n5;
                            --n6;
                        }
                        n5 = n3;
                        n6 = heapCache.getNumberOfChildren() - n3 - 1;
                        while (n5 < heapCache.getNumberOfChildren()) {
                            heapCache.setChild(n5, lArray3[1][n6]);
                            ++n5;
                            --n6;
                        }
                        heapCache.setLocation(l);
                        this.putHeapCache(l, heapCache);
                        for (n5 = 0; n5 < heapCache.getNumberOfChildren(); ++n5) {
                            if (heapCache.getChild(n5) != l2) continue;
                            return n5;
                        }
                        return -1;
                    }
                }
                for (int i = 0; i < heapCache.getNumberOfChildren(); ++i) {
                    if (heapCache.getChild(i) != l2) continue;
                    return i;
                }
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            object = this.heapBuffer;
            synchronized (object) {
                this.heapBuffer.position(l);
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.readName();
                l3 = this.heapBuffer.getInt() & 0xFFFFFFFF;
                this.heapBuffer.position(l3);
                this.heapBuffer.read();
                long l14 = this.heapBuffer.read();
                long l15 = 0L;
                long l16 = 0L;
                long l17 = 0L;
                lArray = new long[(int)l14];
                int n7 = 0;
                while ((long)n7 < l14) {
                    l6 = this.heapBuffer.read();
                    l16 = this.heapBuffer.position();
                    this.heapBuffer.position(l6);
                    this.heapBuffer.read();
                    l17 = this.heapBuffer.read();
                    l7 = l17 + this.heapBuffer.read();
                    this.heapBuffer.readName();
                    l5 = this.heapBuffer.getInt() & 0xFFFFFFFF;
                    this.heapBuffer.position(l5);
                    l4 = this.heapBuffer.read();
                    if (l4 == l) {
                        arrayList.add(new Long(l6));
                        arrayList3.add(new Long(l7));
                    } else {
                        arrayList2.add(new Long(l6));
                        arrayList4.add(new Long(l7));
                    }
                    this.heapBuffer.position(l16);
                    ++n7;
                }
            }
        }
        object = new long[2][arrayList.size()];
        l3 = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l3 = (Long)arrayList.get(i);
            object[0][i] = (Long)arrayList3.get(i);
            object[1][i] = l3;
        }
        long[][] lArray4 = new long[2][arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            l3 = (Long)arrayList2.get(n);
            lArray4[0][n] = (Long)arrayList4.get(n);
            lArray4[1][n] = l3;
        }
        Arrays2.sort(lArray4);
        Arrays2.sort((long[][])object);
        n = arrayList.size();
        int n8 = 0;
        int n9 = n - 1;
        while (n8 < n) {
            lArray[n8] = object[1][n9];
            ++n8;
            --n9;
        }
        n8 = n;
        n9 = lArray.length - n - 1;
        while (n8 < lArray.length) {
            lArray[n8] = lArray4[1][n9];
            ++n8;
            --n9;
        }
        for (n8 = 0; n8 < lArray.length; ++n8) {
            if (lArray[n8] != l2) continue;
            return n8;
        }
        return -1;
    }

    public synchronized int getIndexOfChildOrg(long l, long l2) {
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.readName();
        long l3 = this.heapBuffer.getInt() & 0xFFFFFFFF;
        this.heapBuffer.position(l3);
        this.heapBuffer.read();
        long l4 = this.heapBuffer.read();
        long l5 = 0L;
        int n = 0;
        while ((long)n < l4) {
            l5 = this.heapBuffer.read();
            if (l5 == l2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNChild(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    try {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        this.read(this.raf);
                        this.read(this.raf);
                        this.readName(this.raf);
                        long l2 = this.raf.readInt() & 0xFFFFFFFF;
                        this.raf.seek(l2 + this.getHeapBaseLocation());
                        this.read(this.raf);
                        return (int)this.read(this.raf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else {
                return heapCache.getNumberOfChildren();
            }
            return -1;
        }
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.readName();
        long l3 = this.heapBuffer.getInt() & 0xFFFFFFFF;
        this.heapBuffer.position(l3);
        this.heapBuffer.read();
        return (int)this.heapBuffer.read();
    }

    public int getNChildCache(long l) {
        HeapCache heapCache = null;
        heapCache = this.returnHeapCache(l, true);
        if (heapCache != null) {
            return heapCache.getNumberOfChildren();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChild(long l, int n) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            try {
                heapCache = this.getHeapCache(l);
                if (heapCache == null) {
                    heapCache = new HeapCache();
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        heapCache.setAddress(this.read(this.raf));
                        heapCache.setSize((int)this.read(this.raf));
                        heapCache.setTotalSize(this.read(this.raf));
                        heapCache.setNameLocation(this.readName(this.raf));
                        long l2 = this.raf.readInt() & 0xFFFFFFFF;
                        this.raf.seek(l2 + this.getHeapBaseLocation());
                        heapCache.setChildLocation(l2);
                        heapCache.setParentLocation(this.read(this.raf));
                        long l3 = this.read(this.raf);
                        heapCache.setNumberOfChildren((int)l3);
                        heapCache.setChild(new long[(int)l3]);
                        long l4 = 0L;
                        long l5 = -1L;
                        int n2 = 0;
                        while ((long)n2 < l3) {
                            l4 = this.read(this.raf);
                            heapCache.setChild(n2, l4);
                            if (n2 == n) {
                                l5 = l4;
                            }
                            ++n2;
                        }
                        return l5;
                    }
                }
                return heapCache.getChild(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1L;
            }
        }
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.readName();
        long l6 = this.heapBuffer.getInt() & 0xFFFFFFFF;
        this.heapBuffer.position(l6);
        this.heapBuffer.read();
        long l7 = this.heapBuffer.read();
        long l8 = 0L;
        int n3 = 0;
        while ((long)n3 < l7) {
            l8 = this.heapBuffer.read();
            if (n3 == n) {
                return l8;
            }
            ++n3;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChildSorted(long l, int n) {
        int n2;
        int n3;
        long l2;
        long l3;
        ArrayList<Integer> arrayList;
        long[] lArray = null;
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                heapCache = new HeapCache();
                arrayList = this.raf;
                synchronized (arrayList) {
                    try {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        heapCache.setAddress(this.read(this.raf));
                        heapCache.setSize((int)this.read(this.raf));
                        heapCache.setTotalSize(this.read(this.raf));
                        heapCache.setNameLocation(this.readName(this.raf));
                        l3 = this.raf.readInt() & 0xFFFFFFFF;
                        this.raf.seek(l3 + this.getHeapBaseLocation());
                        heapCache.setChildLocation(l3);
                        heapCache.setParentLocation(this.read(this.raf));
                        l2 = this.read(this.raf);
                        heapCache.setNumberOfChildren((int)l2);
                        long l4 = 0L;
                        if ((long)n >= l2) {
                            return -1L;
                        }
                        n3 = 0;
                        while ((long)n3 < l2) {
                            l4 = this.read(this.raf);
                            if (n3 == n) {
                                return l4;
                            }
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return heapCache.getChild(n);
        }
        arrayList = this.heapBuffer;
        synchronized (arrayList) {
            this.heapBuffer.position(l);
            this.heapBuffer.read();
            this.heapBuffer.read();
            this.heapBuffer.read();
            this.heapBuffer.readName();
            l3 = this.heapBuffer.getInt() & 0xFFFFFFFF;
            this.heapBuffer.position(l3);
            this.heapBuffer.read();
            l2 = this.heapBuffer.read();
            lArray = new long[(int)l2];
            int n4 = 0;
            while ((long)n4 < l2) {
                lArray[n4] = this.heapBuffer.read();
                ++n4;
            }
        }
        arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < lArray.length; ++i) {
            if (i % 10 == 0) {
                System.out.println("i=" + i + "/" + lArray.length + " getParent");
            }
            if (l == this.getParent((long)lArray[i])) {
                arrayList.add(new Integer(i));
                continue;
            }
            arrayList2.add(new Integer(i));
        }
        long[][] lArray2 = new long[2][arrayList.size()];
        int n5 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            n5 = (Integer)arrayList.get(i);
            lArray2[0][i] = this.getTotal(lArray[n5]);
            lArray2[1][i] = lArray[n5];
        }
        long[][] lArray3 = new long[2][arrayList2.size()];
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            n5 = (Integer)arrayList2.get(n2);
            lArray3[0][n2] = this.getTotal(lArray[n5]);
            lArray3[1][n2] = lArray[n5];
        }
        Arrays2.sort(lArray3);
        Arrays2.sort(lArray2);
        n2 = arrayList.size();
        int n6 = 0;
        n3 = n2 - 1;
        while (n6 < n2) {
            lArray[n6] = (int)lArray2[1][n3];
            ++n6;
            --n3;
        }
        n6 = n2;
        n3 = lArray.length - n2 - 1;
        while (n6 < lArray.length) {
            lArray[n6] = (int)lArray3[1][n3];
            ++n6;
            --n3;
        }
        heapCache.setChild(lArray);
        heapCache.setLocation(l);
        this.putHeapCache(l, heapCache);
        return lArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParent(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                RandomAccessFile randomAccessFile = this.raf;
                synchronized (randomAccessFile) {
                    try {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        this.read(this.raf);
                        this.read(this.raf);
                        this.readName(this.raf);
                        long l2 = (long)this.raf.readInt() & 0xFFFFFFFFL;
                        this.raf.seek(l2 + this.getHeapBaseLocation());
                        return this.read(this.raf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return -1L;
                    }
                }
            }
            return heapCache.getParentLocation();
        }
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.read();
        this.heapBuffer.readName();
        long l3 = this.heapBuffer.getInt() & 0xFFFFFFFF;
        this.heapBuffer.position(l3);
        return this.heapBuffer.read();
    }

    void setNumberOfEntries(int n) {
        this.numberOfEntries = n;
    }

    int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    void openDirectBuffer(File file) {
        long l = 0L;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            int n = HAV_SIGNATURE.length();
            int n2 = 61;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            fileChannel.read(byteBuffer2);
            byteBuffer2.flip();
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            int n3 = byteBuffer.getInt();
            if (n3 != 0) {
                this.hi.suspectList = new long[n3];
            }
            this.hi.setHeapSize(byteBuffer.getLong());
            this.spos = byteBuffer.getLong();
            this.pos = byteBuffer.getLong();
            this.nonRoot = byteBuffer.getLong();
            l = byteBuffer.getLong();
            this.hi.setBaseAddress(l);
            this.setRootChildrenLength(byteBuffer.getInt());
            this.setNumberOfEntries(byteBuffer.getInt());
            this.setNameTableLength(byteBuffer.getInt());
            int n4 = byteBuffer.getInt();
            if (n3 != 0) {
                ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n3 * 8);
                fileChannel.read(byteBuffer3);
                byteBuffer3.flip();
                for (int i = 0; i < n3; ++i) {
                    this.hi.suspectList[i] = byteBuffer3.getLong();
                    System.out.println("leak=" + this.hi.suspectList[i]);
                }
            }
            byte by = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(n4);
            fileChannel.read(byteBuffer4);
            byteBuffer4.flip();
            while ((by = byteBuffer4.get()) != 0) {
                stringBuffer.append((char)by);
            }
            this.hi.setDumpInfo(stringBuffer.toString());
            System.out.println("pointerSize=" + this.pointerSize + " addressSize=" + this.addressSize + "headersize=" + n2 + " sigSize=" + n + " spos=" + this.spos + " pos=" + this.pos + " nonRoot=" + this.nonRoot);
            this.stringBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, n2 += n + n4 + n3 * 8, this.spos);
            this.heapBuffer = new DirectBuffer();
            this.heapBuffer.map(fileChannel, FileChannel.MapMode.READ_ONLY, (long)n2 + this.spos, fileChannel.size() - (long)n2 - this.spos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotal(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                try {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        long l2 = this.read(this.raf);
                        return this.read(this.raf) + l2;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                return heapCache.getTotalSize();
            }
            return -1L;
        }
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        long l3 = this.heapBuffer.read();
        return this.heapBuffer.read() + l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                try {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        return (int)this.read(this.raf);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                return heapCache.getSize();
            }
            return -1;
        }
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        return (int)this.heapBuffer.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActualSize(long l) {
        if (this.raf != null) {
            HeapCache heapCache = null;
            try {
                heapCache = this.getHeapCache(l);
                if (heapCache == null) {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        this.read(this.raf);
                        return (int)this.read(this.raf);
                    }
                }
                return heapCache.getSize();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
        }
        this.heapBuffer.position(l);
        this.heapBuffer.read();
        return (int)this.heapBuffer.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddress(long l) {
        HeapCache heapCache = null;
        if (this.raf != null) {
            heapCache = this.getHeapCache(l);
            if (heapCache == null) {
                try {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(l + this.getHeapBaseLocation());
                        return this.read(this.raf) + this.hi.getBaseAddress();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                return heapCache.getAddress();
            }
            return -1L;
        }
        this.heapBuffer.rewind();
        this.heapBuffer.position(l);
        return this.heapBuffer.read() + this.hi.getBaseAddress();
    }

    public synchronized void readTotalToArray(long[][] lArray) {
        try {
            this.raf.seek(this.getHeapBaseLocation());
            long l = -1L;
            for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                l = this.raf.getFilePointer() - this.getHeapBaseLocation();
                this.read(this.raf);
                long l2 = this.read(this.raf);
                lArray[0][i] = this.read(this.raf) + l2;
                lArray[1][i] = l;
                this.readName(this.raf);
                this.raf.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void readSizeToArray(long[][] lArray) {
        try {
            this.raf.seek(this.getHeapBaseLocation());
            long l = -1L;
            for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                l = this.raf.getFilePointer() - this.getHeapBaseLocation();
                this.read(this.raf);
                lArray[0][i] = this.read(this.raf);
                lArray[1][i] = l;
                this.read(this.raf);
                this.readName(this.raf);
                this.raf.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void readAddressToArray(long[][] lArray) {
        try {
            this.raf.seek(this.getHeapBaseLocation());
            long l = -1L;
            for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                l = this.raf.getFilePointer() - this.getHeapBaseLocation();
                lArray[0][i] = this.read(this.raf) + this.hi.getBaseAddress();
                lArray[1][i] = l;
                this.read(this.raf);
                this.read(this.raf);
                this.readName(this.raf);
                this.raf.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void readNChildToArray(long[][] lArray) {
        try {
            this.raf.seek(this.getHeapBaseLocation());
            long l = -1L;
            long l2 = -1L;
            for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                long l3;
                l = this.raf.getFilePointer() - this.getHeapBaseLocation();
                this.read(this.raf);
                this.read(this.raf);
                this.read(this.raf);
                this.readName(this.raf);
                long l4 = this.raf.readInt();
                l2 = this.raf.getFilePointer();
                this.raf.seek(l4 + this.getHeapBaseLocation());
                this.read(this.raf);
                lArray[0][i] = l3 = this.read(this.raf);
                lArray[1][i] = l;
                this.raf.seek(l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void readNameToArray(long[][] lArray) {
        try {
            this.raf.seek(this.getHeapBaseLocation());
            long l = -1L;
            for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                l = this.raf.getFilePointer() - this.getHeapBaseLocation();
                this.read(this.raf);
                this.read(this.raf);
                this.read(this.raf);
                lArray[0][i] = 0x3FFFFFFFFFFFFFFFL & this.readName(this.raf);
                lArray[1][i] = l;
                this.raf.readInt();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNameTableLength(int n) {
        this.nameTableLength = n;
    }

    public int getNameTableLength() {
        return this.nameTableLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadName(OpenHavTask openHavTask, String[] stringArray, int[] nArray) throws Exception {
        block10: {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (this.raf != null) {
                try {
                    RandomAccessFile randomAccessFile = this.raf;
                    synchronized (randomAccessFile) {
                        this.raf.seek(this.getStringBaseLocation());
                        for (int i = 0; i < stringArray.length; ++i) {
                            byte by;
                            nArray[i] = n;
                            while ((by = this.raf.readByte()) != 0) {
                                stringBuffer.append((char)by);
                            }
                            stringArray[i] = stringBuffer.toString();
                            n = (int)this.raf.getFilePointer() - (int)this.getStringBaseLocation();
                            stringBuffer.setLength(0);
                            openHavTask.setCurrent(10 * i / stringArray.length);
                        }
                        break block10;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            this.stringBuffer.rewind();
            for (int i = 0; i < stringArray.length; ++i) {
                byte by;
                nArray[i] = n;
                while ((by = this.stringBuffer.get()) != 0) {
                    stringBuffer.append((char)by);
                }
                stringArray[i] = stringBuffer.toString();
                n = this.stringBuffer.position();
                stringBuffer.setLength(0);
            }
        }
    }

    public void sortEntries(OpenHavTask openHavTask, String[] stringArray, int[][] nArray, long[][] lArray, int[] nArray2, long[] lArray2, int[] nArray3, int[] nArray4, int[][] nArray5, int[] nArray6, long[][] lArray3) throws Exception {
        if (lArray == null) {
            int n;
            int n2;
            int n3;
            int[] nArray7 = new int[nArray6.length];
            for (n3 = 0; n3 < nArray6.length; ++n3) {
                nArray7[n3] = nArray[0][n3];
            }
            Arrays2.sort(nArray);
            for (n3 = 0; n3 < nArray6.length; ++n3) {
                nArray6[n3] = Arrays.binarySearch(nArray[0], nArray7[n3]);
            }
            nArray7 = null;
            Object object = new int[nArray2.length][];
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                object[n2] = nArray5[n2];
            }
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                nArray5[n2] = object[nArray[1][n2]];
            }
            object = null;
            int[] nArray8 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray8, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = nArray8[nArray[1][n]];
            }
            System.arraycopy(nArray3, 0, nArray8, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray3[n] = nArray8[nArray[1][n]];
            }
            System.arraycopy(nArray4, 0, nArray8, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray4[n] = nArray8[nArray[1][n]];
            }
            nArray8 = null;
            long[] lArray4 = new long[nArray2.length];
            System.arraycopy(lArray2, 0, lArray4, 0, nArray2.length);
            for (int i = 0; i < nArray2.length; ++i) {
                lArray2[i] = lArray4[nArray[1][i]];
            }
            lArray4 = null;
        } else {
            int n;
            int n4;
            int n5;
            long[] lArray5 = new long[nArray6.length];
            for (n5 = 0; n5 < nArray6.length; ++n5) {
                lArray5[n5] = lArray[0][n5];
            }
            Arrays2.sort(lArray);
            for (n5 = 0; n5 < nArray6.length; ++n5) {
                nArray6[n5] = Arrays.binarySearch(lArray[0], lArray5[n5]);
            }
            lArray5 = null;
            Object object = new int[nArray2.length][];
            for (n4 = 0; n4 < nArray2.length; ++n4) {
                object[n4] = nArray5[n4];
            }
            for (n4 = 0; n4 < nArray2.length; ++n4) {
                nArray5[n4] = object[(int)lArray[1][n4]];
            }
            object = null;
            int[] nArray9 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray9, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = nArray9[(int)lArray[1][n]];
            }
            System.arraycopy(nArray3, 0, nArray9, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray3[n] = nArray9[(int)lArray[1][n]];
            }
            System.arraycopy(nArray4, 0, nArray9, 0, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                nArray4[n] = nArray9[(int)lArray[1][n]];
            }
            nArray9 = null;
            long[] lArray6 = new long[nArray2.length];
            System.arraycopy(lArray2, 0, lArray6, 0, nArray2.length);
            for (int i = 0; i < nArray2.length; ++i) {
                lArray2[i] = lArray6[(int)lArray[1][i]];
            }
            lArray6 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEntries(OpenHavTask openHavTask, String[] stringArray, int[] nArray, int[][] nArray2, long[][] lArray, int[] nArray3, long[] lArray2, int[] nArray4, int[] nArray5, int[][] nArray6, long[][] lArray3) throws Exception {
        if (this.raf != null) {
            try {
                long l = this.getHeapBaseLocation();
                long l2 = 0L;
                int n = 0;
                boolean bl = true;
                int n2 = this.hi.getTotalLength();
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    openHavTask.setCurrent(10 + 70 * i / n2);
                    if (Thread.interrupted()) {
                        object = this;
                        synchronized (object) {
                            block20: {
                                try {
                                    this.wait(1000L);
                                }
                                catch (Exception exception) {
                                    if (exception instanceof InterruptedException) break block20;
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                    object = this.raf;
                    synchronized (object) {
                        int n3;
                        this.raf.seek(l);
                        lArray3[0][i] = this.raf.getFilePointer() - this.getHeapBaseLocation();
                        if (lArray == null) {
                            nArray2[0][i] = (int)this.read(this.raf);
                            nArray2[1][i] = i;
                            lArray3[1][i] = nArray2[0][i];
                        } else {
                            lArray[0][i] = this.read(this.raf);
                            lArray[1][i] = i;
                            lArray3[1][i] = lArray[0][i];
                        }
                        nArray3[i] = (int)this.read(this.raf);
                        lArray2[i] = this.read(this.raf) + (long)nArray3[i];
                        l2 = this.readName(this.raf);
                        if ((l2 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                            nArray3[i] = nArray3[i] | Integer.MIN_VALUE;
                        }
                        nArray5[i] = n3 = Arrays.binarySearch(nArray, (int)(l2 & 0x3FFFFFFFFFFFFFFFL));
                        if ((l2 & 0x4000000000000000L) == 0x4000000000000000L) {
                            nArray5[i] = nArray5[i] | Integer.MIN_VALUE;
                        }
                        if (n3 == -1) {
                            System.out.println("Key not found " + (l2 & Long.MAX_VALUE));
                        }
                        long l3 = this.raf.readInt() & 0xFFFFFFFF;
                        l = this.raf.getFilePointer();
                        this.raf.seek(l3 + this.getHeapBaseLocation());
                        nArray4[i] = (int)this.read(this.raf);
                        n = (int)this.read(this.raf);
                        if (n > 0) {
                            nArray6[i] = new int[n];
                            for (int j = 0; j < n; ++j) {
                                nArray6[i][j] = (int)this.read(this.raf);
                            }
                        }
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEntriesORG(String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, int[] nArray3, long[] lArray2, int[] nArray4, int[] nArray5, int[][] nArray6, long[] lArray3) throws Exception {
        if (this.raf != null) {
            try {
                long l = this.getHeapBaseLocation();
                long l2 = 0L;
                int n = 0;
                boolean bl = true;
                for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                    Object object;
                    if (Thread.interrupted()) {
                        object = this;
                        synchronized (object) {
                            block49: {
                                try {
                                    this.wait(1000L);
                                }
                                catch (Exception exception) {
                                    if (exception instanceof InterruptedException) break block49;
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                    object = this.raf;
                    synchronized (object) {
                        int n2;
                        this.raf.seek(l);
                        lArray3[i] = this.raf.getFilePointer() - this.getHeapBaseLocation();
                        if (lArray == null) {
                            nArray2[i] = (int)this.read(this.raf);
                        } else {
                            lArray[i] = this.read(this.raf);
                        }
                        nArray3[i] = (int)this.read(this.raf);
                        lArray2[i] = this.read(this.raf) + (long)nArray3[i];
                        l2 = this.readName(this.raf);
                        if ((l2 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                            nArray3[i] = nArray3[i] | Integer.MIN_VALUE;
                        }
                        nArray5[i] = n2 = Arrays.binarySearch(nArray, (int)(l2 & 0x3FFFFFFFFFFFFFFFL));
                        if ((l2 & 0x4000000000000000L) == 0x4000000000000000L) {
                            nArray5[i] = nArray5[i] | Integer.MIN_VALUE;
                        }
                        if (n2 == -1) {
                            System.out.println("Key not found " + (l2 & Long.MAX_VALUE));
                        }
                        long l3 = this.raf.readInt() & 0xFFFFFFFF;
                        l = this.raf.getFilePointer();
                        this.raf.seek(l3 + this.getHeapBaseLocation());
                        nArray4[i] = (int)this.read(this.raf);
                        n = (int)this.read(this.raf);
                        if (n > 0) {
                            nArray6[i] = new int[n];
                            for (int j = 0; j < n; ++j) {
                                nArray6[i][j] = (int)this.read(this.raf);
                            }
                        }
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        this.heapBuffer.rewind();
        long l = 0L;
        long l4 = 0L;
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < this.hi.getTotalLength(); ++i) {
            Object object;
            if (Thread.interrupted()) {
                object = this;
                synchronized (object) {
                    block50: {
                        try {
                            this.wait(1000L);
                        }
                        catch (Exception exception) {
                            if (exception instanceof InterruptedException) break block50;
                            exception.printStackTrace();
                        }
                    }
                }
            }
            object = this.heapBuffer;
            synchronized (object) {
                int n3;
                this.heapBuffer.setPosition(l);
                lArray3[i] = this.heapBuffer.position();
                if (i < 10) {
                    System.out.println("start " + this.heapBuffer.getPosition());
                }
                if (lArray == null) {
                    nArray2[i] = (int)this.heapBuffer.read();
                    if (i < 10) {
                        System.out.print("Loading i=" + i + " address=" + nArray2[i]);
                    }
                } else {
                    lArray[i] = this.heapBuffer.read();
                    if (i < 10) {
                        System.out.print("Loading i=" + i + " address=" + lArray[i]);
                    }
                }
                if (i < 10) {
                    System.out.println("address " + this.heapBuffer.getPosition());
                }
                nArray3[i] = (int)this.heapBuffer.read();
                if (i < 10) {
                    System.out.println("size " + this.heapBuffer.getPosition());
                }
                lArray2[i] = this.heapBuffer.read() + (long)nArray3[i];
                if (i < 10) {
                    System.out.println("total " + this.heapBuffer.getPosition());
                }
                l4 = this.heapBuffer.readName();
                if (i < 10) {
                    System.out.println("name " + this.heapBuffer.getPosition());
                }
                if ((l4 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                    nArray3[i] = nArray3[i] | Integer.MIN_VALUE;
                }
                nArray5[i] = n3 = Arrays.binarySearch(nArray, (int)(l4 & 0x3FFFFFFFFFFFFFFFL));
                if ((l4 & 0x4000000000000000L) == 0x4000000000000000L) {
                    nArray5[i] = nArray5[i] | Integer.MIN_VALUE;
                }
                if (n3 == -1) {
                    System.out.println("Key not found " + (l4 & Long.MAX_VALUE));
                }
                long l5 = this.heapBuffer.getInt() & 0xFFFFFFFF;
                if (i < 10) {
                    System.out.println("ad " + l5);
                }
                l = this.heapBuffer.getPosition();
                this.heapBuffer.position(l5);
                nArray4[i] = (int)this.heapBuffer.read();
                if (i < 10) {
                    System.out.println("parent " + this.heapBuffer.getPosition());
                }
                n = (int)this.heapBuffer.read();
                if (i < 10) {
                    System.out.println("nchild " + this.heapBuffer.getPosition());
                }
                if (i < 10) {
                    System.out.println(" size=" + nArray3[i] + " total=" + lArray2[i] + " name=" + l4 + " parent=" + nArray4[i] + " nChild=" + n);
                }
                if (i % 100000 == 0) {
                    System.out.println("Loading i=" + i + "/" + this.hi.getTotalLength());
                }
                if (n > 0) {
                    nArray6[i] = new int[n];
                    for (int j = 0; j < n; ++j) {
                        nArray6[i][j] = (int)this.heapBuffer.read();
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEntriesOrg(String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, int[] nArray3, long[] lArray2, int[] nArray4, int[] nArray5, int[][] nArray6, long[] lArray3) {
        this.heapBuffer.rewind();
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < this.hi.getTotalLength(); ++i) {
            Object object;
            if (Thread.interrupted()) {
                object = this;
                synchronized (object) {
                    block27: {
                        try {
                            this.wait(1000L);
                        }
                        catch (Exception exception) {
                            if (exception instanceof InterruptedException) break block27;
                            exception.printStackTrace();
                        }
                    }
                }
            }
            object = this.heapBuffer;
            synchronized (object) {
                int n2;
                this.heapBuffer.setPosition(l);
                lArray3[i] = this.heapBuffer.position();
                if (i < 10) {
                    System.out.println("start " + this.heapBuffer.getPosition());
                }
                if (lArray == null) {
                    nArray2[i] = (int)this.readAddress();
                    if (i < 10) {
                        System.out.print("Loading i=" + i + " address=" + nArray2[i]);
                    }
                } else {
                    lArray[i] = this.readAddress();
                    if (i < 10) {
                        System.out.print("Loading i=" + i + " address=" + lArray[i]);
                    }
                }
                if (i < 10) {
                    System.out.println("address " + this.heapBuffer.getPosition());
                }
                nArray3[i] = this.readSizeInt();
                if (i < 10) {
                    System.out.println("size " + this.heapBuffer.getPosition());
                }
                lArray2[i] = this.readTotal();
                if (i < 10) {
                    System.out.println("total " + this.heapBuffer.getPosition());
                }
                l2 = this.readName2();
                if (i < 10) {
                    System.out.println("name " + this.heapBuffer.getPosition());
                }
                if (l2 < 0L) {
                    n2 = Arrays.binarySearch(nArray, (int)(l2 & Long.MAX_VALUE));
                    nArray5[i] = n2 | Integer.MIN_VALUE;
                } else {
                    nArray5[i] = n2 = Arrays.binarySearch(nArray, (int)l2);
                }
                nArray4[i] = (int)this.readParent();
                if (i < 10) {
                    System.out.println("parent " + this.heapBuffer.getPosition());
                }
                n = (int)this.readNChild();
                if (i < 10) {
                    System.out.println("nchild " + this.heapBuffer.getPosition());
                }
                if (i < 10) {
                    System.out.println(" size=" + nArray3[i] + " total=" + lArray2[i] + " name=" + l2 + " parent=" + nArray4[i] + " nChild=" + n);
                }
                if (i % 100000 == 0) {
                    System.out.println("Loading i=" + i + "/" + this.hi.getTotalLength());
                }
                if (n > 0) {
                    nArray6[i] = new int[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        nArray6[i][n2] = this.readPointer();
                    }
                }
                l = this.heapBuffer.getPosition();
                continue;
            }
        }
    }

    public void convertChildrenParent(OpenHavTask openHavTask, int[][] nArray, int[] nArray2, long[][] lArray, int[][] nArray3, long[][] lArray2) throws Exception {
        int n = this.hi.getTotalLength();
        if (lArray2 == null) {
            for (int i = 0; i < n; ++i) {
                int n2;
                openHavTask.setCurrent(80 + 20 * i / n);
                if (nArray2[i] != -1) {
                    n2 = Arrays.binarySearch(lArray[0], (long)nArray2[i]);
                    if (n2 >= 0) {
                        if ((n2 = Arrays.binarySearch(nArray3[0], (int)lArray[1][n2])) >= 0) {
                            nArray2[i] = n2;
                        } else {
                            System.out.println("Error II:convertChildrenParent");
                        }
                    } else {
                        System.out.println("Error I:convertChildrenParent");
                    }
                }
                if (nArray[i] == null) continue;
                for (n2 = 0; n2 < nArray[i].length; ++n2) {
                    int n3 = Arrays.binarySearch(lArray[0], (long)nArray[i][n2]);
                    if (n3 >= 0) {
                        if ((n3 = Arrays.binarySearch(nArray3[0], (int)lArray[1][n3])) >= 0) {
                            nArray[i][n2] = n3;
                            continue;
                        }
                        System.out.println("Error II child :convertChildrenParent");
                        continue;
                    }
                    System.out.println("Error I child :convertChildrenParent");
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4;
                openHavTask.setCurrent(80 + 20 * i / n);
                if (nArray2[i] != -1) {
                    n4 = Arrays.binarySearch(lArray[0], (long)nArray2[i]);
                    if (n4 >= 0) {
                        if ((n4 = Arrays.binarySearch(lArray2[0], lArray[1][n4])) >= 0) {
                            nArray2[i] = n4;
                        } else {
                            System.out.println("Error II:convertChildrenParent");
                        }
                    } else {
                        System.out.println("Error I:convertChildrenParent");
                    }
                }
                if (nArray[i] == null) continue;
                for (n4 = 0; n4 < nArray[i].length; ++n4) {
                    int n5 = Arrays.binarySearch(lArray[0], (long)nArray[i][n4]);
                    if (n5 >= 0) {
                        if ((n5 = Arrays.binarySearch(lArray2[0], lArray[1][n5])) >= 0) {
                            nArray[i][n4] = n5;
                            continue;
                        }
                        System.out.println("Error II child :convertChildrenParent");
                        continue;
                    }
                    System.out.println("Error I child :convertChildrenParent");
                }
            }
        }
    }

    private synchronized void loadPointers(long[] lArray) {
        this.heapBuffer.rewind();
        for (int i = 0; i < this.hi.getTotalLength(); ++i) {
            lArray[i] = this.heapBuffer.position();
            this.readAddress();
            this.skipSize();
            this.readTotal();
            this.skipName();
            this.readParent();
            this.skipChild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocationFromAddress(long l) {
        long l2 = 0L;
        if (this.raf != null) {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                try {
                    this.raf.seek(this.getHeapBaseLocation());
                    for (int i = 0; i < this.hi.getHav().getNumberOfEntries(); ++i) {
                        l2 = this.raf.getFilePointer() - this.getHeapBaseLocation();
                        if (this.read(this.raf) == l) {
                            return l2;
                        }
                        this.read(this.raf);
                        this.read(this.raf);
                        this.readName(this.raf);
                        this.raf.readInt();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return -1L;
        }
        DirectBuffer directBuffer = this.heapBuffer;
        synchronized (directBuffer) {
            this.heapBuffer.rewind();
            for (int i = 0; i < this.hi.getHav().getNumberOfEntries(); ++i) {
                if (this.heapBuffer == null || this.hi == null) {
                    return -1L;
                }
                l2 = this.heapBuffer.position();
                if (this.heapBuffer.read() == l) {
                    return l2;
                }
                this.heapBuffer.read();
                this.heapBuffer.read();
                this.heapBuffer.readName();
                this.heapBuffer.getInt();
            }
        }
        return -1L;
    }

    public void setStringBaseLocation(long l) {
        this.stringBaseLocation = l;
    }

    public long getStringBaseLocation() {
        return this.stringBaseLocation;
    }

    public void setHeapBaseLocation(long l) {
        this.heapBaseLocation = l;
    }

    public long getHeapBaseLocation() {
        return this.heapBaseLocation;
    }

    public HeapCache getHeapCache(long l) {
        HeapCache heapCache = (HeapCache)this.heapCache.get(new Long(l));
        if (heapCache != null) {
            return heapCache;
        }
        return null;
    }

    public String getNameCache(long l) {
        String string = (String)this.nameCache.get(new Long(l));
        if (string != null) {
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putHeapCache(long l, HeapCache heapCache) {
        Hashtable hashtable = this.heapCache;
        synchronized (hashtable) {
            this.heapCache.put(new Long(l), heapCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNameCache(long l, String string) {
        Hashtable hashtable = this.nameCache;
        synchronized (hashtable) {
            this.nameCache.put(new Long(l), string);
        }
    }

    public void setLongAddress(boolean bl) {
        this.isLongAddress = bl;
    }

    public void setLongAddress() {
        this.isLongAddress = true;
    }

    public boolean isLongAddress() {
        return this.isLongAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapCache returnHeapCache(long l, boolean bl) {
        HeapCache heapCache = this.getHeapCache(l);
        if (heapCache != null) {
            return heapCache;
        }
        heapCache = new HeapCache();
        if (this.hi.backgroundThread != null && !this.hi.backgroundThread.isInterrupted()) {
            this.hi.backgroundThread.interrupt();
        }
        try {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(l + this.getHeapBaseLocation());
                heapCache.setAddress(this.read(this.raf));
                heapCache.setSize((int)this.read(this.raf));
                heapCache.setTotalSize(this.read(this.raf));
                heapCache.setNameLocation(this.readName(this.raf));
                long l2 = this.raf.readInt() & 0xFFFFFFFF;
                this.raf.seek(l2 + this.getHeapBaseLocation());
                heapCache.setChildLocation(l2);
                heapCache.setParentLocation(this.read(this.raf));
                long l3 = this.read(this.raf);
                heapCache.setNumberOfChildren((int)l3);
                heapCache.setChild(new long[(int)l3]);
                long l4 = 0L;
                long l5 = -1L;
                int n = 0;
                while ((long)n < l3) {
                    l4 = this.read(this.raf);
                    heapCache.setChild(n, l4);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (heapCache == null) {
            return null;
        }
        heapCache.setLocation(l);
        if (bl) {
            this.putHeapCache(l, heapCache);
        }
        return heapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapCache returnHeapCacheFirstChild(long l, boolean bl) {
        HeapCache heapCache = this.getHeapCache(l);
        if (heapCache != null) {
            return heapCache;
        }
        heapCache = new HeapCache();
        if (this.hi.backgroundThread != null && !this.hi.backgroundThread.isInterrupted()) {
            this.hi.backgroundThread.interrupt();
        }
        try {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(l + this.getHeapBaseLocation());
                heapCache.setAddress(this.read(this.raf));
                heapCache.setSize((int)this.read(this.raf));
                heapCache.setTotalSize(this.read(this.raf));
                heapCache.setNameLocation(this.readName(this.raf));
                long l2 = this.raf.readInt() & 0xFFFFFFFF;
                this.raf.seek(l2 + this.getHeapBaseLocation());
                heapCache.setChildLocation(l2);
                heapCache.setParentLocation(this.read(this.raf));
                long l3 = this.read(this.raf);
                heapCache.setNumberOfChildren((int)l3);
                heapCache.setChild(new long[(int)l3]);
                long l4 = 0L;
                long l5 = -1L;
                int n = 0;
                if ((long)n < l3) {
                    l4 = this.read(this.raf);
                    heapCache.setChild(n, l4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (heapCache == null) {
            return null;
        }
        heapCache.setLocation(l);
        return heapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapCache returnHeapCacheNoChild(long l, boolean bl) {
        HeapCache heapCache = this.getHeapCache(l);
        if (heapCache != null) {
            return heapCache;
        }
        heapCache = new HeapCache();
        if (this.hi.backgroundThread != null && !this.hi.backgroundThread.isInterrupted()) {
            this.hi.backgroundThread.interrupt();
        }
        try {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(l + this.getHeapBaseLocation());
                heapCache.setAddress(this.read(this.raf));
                heapCache.setSize((int)this.read(this.raf));
                heapCache.setTotalSize(this.read(this.raf));
                heapCache.setNameLocation(this.readName(this.raf));
                long l2 = this.raf.readInt() & 0xFFFFFFFF;
                this.raf.seek(l2 + this.getHeapBaseLocation());
                heapCache.setChildLocation(l2);
                heapCache.setParentLocation(this.read(this.raf));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (heapCache == null) {
            return null;
        }
        heapCache.setLocation(l);
        if (bl) {
            this.putHeapCache(l, heapCache);
        }
        return heapCache;
    }
}

