/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.AppendThread;
import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.ChartPanel;
import com.ibm.jinwoo.heap.Configuration;
import com.ibm.jinwoo.heap.ConsolePrintStream;
import com.ibm.jinwoo.heap.DropProgressDialog;
import com.ibm.jinwoo.heap.FileProcessDialog;
import com.ibm.jinwoo.heap.FileTask;
import com.ibm.jinwoo.heap.FindAddressView;
import com.ibm.jinwoo.heap.FindTypes;
import com.ibm.jinwoo.heap.FreeNode;
import com.ibm.jinwoo.heap.FreeSpaceTableModel;
import com.ibm.jinwoo.heap.HeapAnalyzerAboutBox;
import com.ibm.jinwoo.heap.HeapAnalyzerHeadless;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTable;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.HprofTask;
import com.ibm.jinwoo.heap.HprofTxtTask;
import com.ibm.jinwoo.heap.JDialogOption;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.JinwooFileFilter;
import com.ibm.jinwoo.heap.NumberCellRenderer;
import com.ibm.jinwoo.heap.OpenHavTask;
import com.ibm.jinwoo.heap.OpenTask;
import com.ibm.jinwoo.heap.PHDTask;
import com.ibm.jinwoo.heap.PopupListener;
import com.ibm.jinwoo.heap.SaveTask;
import com.ibm.jinwoo.heap.SaveViewerTask;
import com.ibm.jinwoo.heap.SearchTableModel;
import com.ibm.jinwoo.heap.TableThread;
import com.ibm.jinwoo.heap.TableThreadGap;
import com.ibm.jinwoo.heap.TableThreadTypes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HeapAnalyzer
extends JFrame {
    static final int FORMAT_HPROF_BIN = 3;
    private boolean isHeadless;
    FileProcessDialog fd = new FileProcessDialog((Frame)this, "Save as IBM HeapAnalyzer Archive File");
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    static final String cfgFile = "ha.cfg";
    public Configuration cfg;
    File currentDirectory;
    ConsolePrintStream console;
    private Timer timer;
    private Timer otimer;
    private Timer ptimer;
    private Timer htimer;
    private Timer htxttimer;
    private Timer savetimer;
    public Timer havtimer;
    private FileTask task;
    private PHDTask ptask;
    private HprofTask htask;
    private HprofTxtTask htxttask;
    private SaveTask stask;
    private OpenTask otask;
    private OpenHavTask havtask;
    private SaveViewerTask vtask;
    DropProgressDialog dp;
    JDialogProgress jp;
    private JMenuItem ivjAbout_BoxMenuItem = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JMenuItem ivjExitMenuItem = null;
    private JMenu ivjFileMenu = null;
    private JMenuBar ivjHeapAnalyzerJMenuBar = null;
    private JMenuItem ivjHelp_TopicsMenuItem = null;
    private JMenu ivjHelpMenu = null;
    private JPanel ivjJFrameContentPane = null;
    private JMenuItem ivjOpenMenuItem = null;
    private JPanel ivjStatusBarPane = null;
    private JLabel ivjStatusMsg1 = null;
    private JLabel ivjStatusMsg2 = null;
    private JMenu ivjViewMenu = null;
    private JDesktopPane ivjJDesktopPane1 = null;
    private JMenu ivjAnalysisMenu = null;
    private JMenuItem ivjFree_MenuItem = null;
    private JMenuItem ivjStats_MenuItem = null;
    private JMenuItem ivjOptionsJMenuItem = null;
    static long MAX_VIEW_SIZE = 100L;
    static long MIN_DROP_LIMIT = 10000000L;
    static long MIN_TOTAL_LIMIT = 10000000L;
    static long MAX_SUBTREE = 20L;
    static long MAX_FREELIST = 50L;
    static long MAX_OBJECTLIST = 50L;
    static long MAX_SIZELIST = 50L;
    static long MAX_ADDRESSLIST = 50L;
    static long MAX_TYPELIST = 50L;
    static long MAX_COUNTLIST = 50L;
    static long MIN_DROP = 100000000L;
    static long SUBTREE = 10L;
    static float RATIO = 0.5f;
    static float MRATIO = 0.1f;
    static float ROOT_RATIO = 0.4f;
    static boolean SHOW_NONOWNER = false;
    private JMenuItem ivjTreeView_MenuItem = null;
    private JCheckBoxMenuItem ivjJCheckBoxMenuItem2 = null;
    private String returnString;
    private JSeparator ivjJSeparator2 = null;
    private JMenuItem ivjSaveMenuItem = null;
    private JMenuItem ivjSaveViewerMenuItem = null;
    private JSeparator ivjJSeparator3 = null;
    private JSeparator ivjJSeparator4 = null;
    private JSeparator ivjJSeparator5 = null;
    private JSeparator ivjJSeparator6 = null;
    private JMenuItem ivjObjectsMenu = null;
    private JMenuItem ivjTypesMenu = null;
    private JScrollPane ivjConsoleScrollPane = null;
    private JTextArea ivjConsoleTextArea = null;
    private JPanel ivjJInternalFrameContentPane = null;
    private JCheckBoxMenuItem ivjConsoleCheckBoxMenuItem = null;
    private JInternalFrame ivjConsoleFrame = null;
    private JMenuItem ivjSearchMenuItem = null;
    private JMenuItem ivjClearConsoleMenuItem = null;
    private JMenuItem ivjAddressMenuItem = null;
    private JMenuItem ivjRootMenu = null;
    private JProgressBar havProgressBar = null;
    private JToolBar jToolBar = null;
    private JButton openButton = null;
    private JButton saveButton = null;
    private JButton treeButton = null;
    private JButton objectButton = null;
    private JButton typeButton = null;
    private JButton rootButton = null;
    private JButton gapButton = null;
    private JButton chartButton = null;
    private JButton nameButton = null;
    private JButton addressButton = null;
    private JButton optionButton = null;
    private JButton clearButton = null;
    private JToggleButton statusbarToggleButton = null;
    private JToggleButton consoleToggleButton = null;
    private JButton helpButton = null;
    private JButton aboutButton = null;
    private JButton openButton1 = null;

    public HeapAnalyzer() {
        this.initialize();
    }

    public HeapAnalyzer(String string) {
        super(string);
    }

    public void addressByType() {
        AppendThread appendThread;
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        String string = JOptionPane.showInputDialog(this, "Please enter Type name or regular expression\n(For example  .*byte.* for types include string \"byte\")", "Find address by Type", 3);
        if (string == null) {
            return;
        }
        int n = Arrays.binarySearch(heapInfo.getNameTable(), string);
        if (n < 0) {
            try {
                for (int i = 0; i < heapInfo.getNameTable().length; ++i) {
                    if (!heapInfo.getNameTable(i).matches(string)) continue;
                    bl = true;
                    break;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                JOptionPane.showMessageDialog(this, "Cannot find Type with expression: " + string, "Invalid regular expression", 0);
                return;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Cannot find Type : " + string, "Type not found", 0);
                return;
            }
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Address by Type", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        if (bl) {
            appendThread = new AppendThread(5, n, MAX_ADDRESSLIST, jTextArea, heapInfo, string);
        } else {
            jTextArea.append("Address for " + string + "\n");
            appendThread = new AppendThread(5, n, MAX_ADDRESSLIST, jTextArea, heapInfo);
        }
        appendThread.start();
    }

    public void addressByType_ActionPerformed() {
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        FindTypes findTypes = new FindTypes((Frame)this, heapInfo, this);
        Dimension dimension = findTypes.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        findTypes.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        findTypes.show();
    }

    public void addressByType_ActionPerformed2() {
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        FindTypes findTypes = new FindTypes((Frame)this, heapInfo, this, true);
        Dimension dimension = findTypes.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        findTypes.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        findTypes.show();
    }

    public void addressMenuItem_ActionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        FindAddressView findAddressView = new FindAddressView((Frame)this, heapInfo);
        Dimension dimension = findAddressView.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        findAddressView.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        findAddressView.show();
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.object_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC10(ActionEvent actionEvent) {
        try {
            this.optionsJMenuItem_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC11(ActionEvent actionEvent) {
        try {
            this.typesMenu_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC12(ActionEvent actionEvent) {
        try {
            this.viewConsole();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC13(ActionEvent actionEvent) {
        try {
            this.treeView_MenuItem_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC14(ActionEvent actionEvent) {
        try {
            this.search_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC15(ActionEvent actionEvent) {
        try {
            this.help_TopicsMenuItem_Accelerator();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC19(WindowEvent windowEvent) {
        try {
            this.heapAnalyzer_WindowClosing();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.viewStatusBar();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC21(ActionEvent actionEvent) {
        try {
            this.saveMenuItem_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ActionEvent actionEvent) {
        try {
            this.showAboutBox();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC4(ActionEvent actionEvent) {
        try {
            this.openFile_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC5(ActionEvent actionEvent) {
        try {
            this.freeList_MenuItem_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC6(ActionEvent actionEvent) {
        try {
            this.heapAnalyzer_WindowClosing();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC7(ActionEvent actionEvent) {
        try {
            this.free_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC8(ActionEvent actionEvent) {
        try {
            this.addressMenuItem_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC9(ActionEvent actionEvent) {
        try {
            this.rootMenu_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM10(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM11(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Exit to OS");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM12(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM13(ActionEvent actionEvent) {
        try {
            this.getConsoleTextArea().setText("");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Show/Hide Console");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM25(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Sort gaps between objects by size");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM26(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM27(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Gaps distribution chart");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM28(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM29(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Search objects/types and sort");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("View Heap dump Tree sorted by Total Size");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM31(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM35(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("List of Types sorted in various order");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM36(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM37(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("View/Change options");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM38(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM39(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM4(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM40(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Show/Hide Statusbar");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM42(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM43(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Help/Usage");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM44(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM45(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("About HeapAnalyzer");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM46(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM5(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Open a heap dump .txt, .txt.gz, .phd or .ha file");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM6(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText(" ");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM7(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM8(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("List of Objects sorted in various order");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM9(MouseEvent mouseEvent) {
        try {
            this.getStatusMsg2().setText("Save processed heap dump to .ha format");
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free_ActionPerformed(ActionEvent actionEvent) {
        long l = 0L;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        long[] lArray = new long[10];
        FreeSpaceTableModel freeSpaceTableModel = new FreeSpaceTableModel();
        long[] lArray2 = null;
        if (heapInfo.isHav()) {
            int n;
            long[][] lArray3 = null;
            int[] nArray = null;
            lArray3 = new long[2][heapInfo.getHav().getNumberOfEntries()];
            nArray = new int[heapInfo.getHav().getNumberOfEntries()];
            RandomAccessFile randomAccessFile = heapInfo.getHav().raf;
            synchronized (randomAccessFile) {
                try {
                    heapInfo.getHav().raf.seek(heapInfo.getHav().getHeapBaseLocation());
                    for (int i = 0; i < nArray.length; ++i) {
                        lArray3[0][i] = heapInfo.getHav().read(heapInfo.getHav().raf);
                        lArray3[1][i] = i;
                        nArray[i] = (int)heapInfo.getHav().read(heapInfo.getHav().raf);
                        heapInfo.getHav().read(heapInfo.getHav().raf);
                        heapInfo.getHav().readName(heapInfo.getHav().raf);
                        heapInfo.getHav().raf.readInt();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Arrays2.sort(lArray3);
            int n2 = 0;
            long l2 = lArray3[0][0] + (long)nArray[(int)lArray3[1][0]];
            for (n = 1; n < nArray.length; ++n) {
                if (lArray3[0][n] > l2) {
                    ++n2;
                }
                l2 = lArray3[0][n] + (long)nArray[(int)lArray3[1][n]];
            }
            lArray2 = new long[n2];
            n = 0;
            l2 = lArray3[0][0] + (long)nArray[(int)lArray3[1][0]];
            for (int i = 1; i < nArray.length; ++i) {
                if (lArray3[0][i] > l2) {
                    lArray2[n++] = lArray3[0][i] - l2;
                }
                l2 = lArray3[0][i] + (long)nArray[(int)lArray3[1][i]];
            }
            Arrays.sort(lArray2);
        } else {
            int n;
            int n3 = 0;
            long l3 = heapInfo.getAddress(0) + (long)heapInfo.getSize(0);
            for (n = 1; n < heapInfo.getAddressLength(); ++n) {
                if (heapInfo.getAddress(n) > l3) {
                    ++n3;
                }
                l3 = heapInfo.getAddress(n) + (long)heapInfo.getSize(n);
            }
            lArray2 = new long[n3];
            n = 0;
            l3 = heapInfo.getAddress(0) + (long)heapInfo.getSize(0);
            for (int i = 1; i < heapInfo.getAddressLength(); ++i) {
                if (heapInfo.getAddress(i) > l3) {
                    lArray2[n++] = heapInfo.getAddress(i) - l3;
                }
                l3 = heapInfo.getAddress(i) + (long)heapInfo.getSize(i);
            }
            Arrays.sort(lArray2);
        }
        for (int i = 0; i < lArray2.length; ++i) {
            int n = this.get10(lArray2[i]);
            if (n > 9) {
                n = 9;
            }
            long l4 = (Long)freeSpaceTableModel.getValueAt(n, 1);
            freeSpaceTableModel.setValueAt(new Long(++l4), n, 1);
            lArray[n] = l4;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Gap analysis", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/chart.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        JTable jTable = new JTable(freeSpaceTableModel);
        jTable.setDragEnabled(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTable, "South");
        jPanel.add((Component)new ChartPanel(lArray), "Center");
        heapFrame2.JScrollPaneSetViewportView(jPanel);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public void freeList_MenuItem_ActionPerformed(ActionEvent actionEvent) {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Gaps between objects", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/gap.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        JTable jTable = new JTable();
        jTable.setDragEnabled(true);
        jTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame2.JScrollPaneSetViewportView(jTable);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        TableThreadGap tableThreadGap = new TableThreadGap(jTable, heapInfo);
        tableThreadGap.start();
    }

    public int get10(long l) {
        int n = 0;
        while ((l /= 10L) >= 1L) {
            ++n;
        }
        return n;
    }

    private JMenuItem getAbout_BoxMenuItem() {
        if (this.ivjAbout_BoxMenuItem == null) {
            try {
                this.ivjAbout_BoxMenuItem = new JMenuItem();
                this.ivjAbout_BoxMenuItem.setName("About_BoxMenuItem");
                this.ivjAbout_BoxMenuItem.setIcon(null);
                this.ivjAbout_BoxMenuItem.setMnemonic('A');
                this.ivjAbout_BoxMenuItem.setText("About Box");
                this.ivjAbout_BoxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/about.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAbout_BoxMenuItem;
    }

    private JMenuItem getAddressMenuItem() {
        if (this.ivjAddressMenuItem == null) {
            try {
                this.ivjAddressMenuItem = new JMenuItem();
                this.ivjAddressMenuItem.setName("AddressMenuItem");
                this.ivjAddressMenuItem.setMnemonic('e');
                this.ivjAddressMenuItem.setText("Search Address");
                this.ivjAddressMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/address.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAddressMenuItem;
    }

    private JMenu getAnalysisMenu() {
        if (this.ivjAnalysisMenu == null) {
            try {
                this.ivjAnalysisMenu = new JMenu();
                this.ivjAnalysisMenu.setName("AnalysisMenu");
                this.ivjAnalysisMenu.setMnemonic('A');
                this.ivjAnalysisMenu.setText("Analysis");
                this.ivjAnalysisMenu.add(this.getTreeView_MenuItem());
                this.ivjAnalysisMenu.add(this.getJSeparator5());
                this.ivjAnalysisMenu.add(this.getObjectsMenu());
                this.ivjAnalysisMenu.add(this.getTypesMenu());
                this.ivjAnalysisMenu.add(this.getRootMenu());
                this.ivjAnalysisMenu.add(this.getJSeparator4());
                this.ivjAnalysisMenu.add(this.getFree_MenuItem());
                this.ivjAnalysisMenu.add(this.getStats_MenuItem());
                this.ivjAnalysisMenu.add(this.getJSeparator3());
                this.ivjAnalysisMenu.add(this.getSearchMenuItem());
                this.ivjAnalysisMenu.add(this.getAddressMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAnalysisMenu;
    }

    private JMenuItem getClearConsoleMenuItem() {
        if (this.ivjClearConsoleMenuItem == null) {
            try {
                this.ivjClearConsoleMenuItem = new JMenuItem();
                this.ivjClearConsoleMenuItem.setName("ClearConsoleMenuItem");
                this.ivjClearConsoleMenuItem.setMnemonic('C');
                this.ivjClearConsoleMenuItem.setText("Clear console");
                this.ivjClearConsoleMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/clear.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjClearConsoleMenuItem;
    }

    private JCheckBoxMenuItem getConsoleCheckBoxMenuItem() {
        if (this.ivjConsoleCheckBoxMenuItem == null) {
            try {
                this.ivjConsoleCheckBoxMenuItem = new JCheckBoxMenuItem();
                this.ivjConsoleCheckBoxMenuItem.setName("ConsoleCheckBoxMenuItem");
                this.ivjConsoleCheckBoxMenuItem.setSelected(true);
                this.ivjConsoleCheckBoxMenuItem.setMnemonic('n');
                this.ivjConsoleCheckBoxMenuItem.setText("Console");
                this.ivjConsoleCheckBoxMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/console.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConsoleCheckBoxMenuItem;
    }

    private JInternalFrame getConsoleFrame() {
        if (this.ivjConsoleFrame == null) {
            try {
                this.ivjConsoleFrame = new JInternalFrame();
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/console.gif"));
                this.ivjConsoleFrame.setFrameIcon(imageIcon);
                this.ivjConsoleFrame.setName("ConsoleFrame");
                this.ivjConsoleFrame.setTitle("Console");
                this.ivjConsoleFrame.setIconifiable(true);
                this.ivjConsoleFrame.setVisible(true);
                this.ivjConsoleFrame.setBounds(0, 552, 831, 107);
                this.ivjConsoleFrame.setMaximizable(true);
                this.ivjConsoleFrame.setResizable(true);
                this.getConsoleFrame().setContentPane(this.getJInternalFrameContentPane());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConsoleFrame;
    }

    private JScrollPane getConsoleScrollPane() {
        if (this.ivjConsoleScrollPane == null) {
            try {
                this.ivjConsoleScrollPane = new JScrollPane();
                this.ivjConsoleScrollPane.setName("ConsoleScrollPane");
                this.getConsoleScrollPane().setViewportView(this.getConsoleTextArea());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConsoleScrollPane;
    }

    private JTextArea getConsoleTextArea() {
        if (this.ivjConsoleTextArea == null) {
            try {
                this.ivjConsoleTextArea = new JTextArea();
                this.ivjConsoleTextArea.setName("ConsoleTextArea");
                this.ivjConsoleTextArea.setBounds(0, 0, 160, 120);
                this.ivjConsoleTextArea.setEditable(false);
                this.ivjConsoleTextArea.setDragEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConsoleTextArea;
    }

    private JMenuItem getExitMenuItem() {
        if (this.ivjExitMenuItem == null) {
            try {
                this.ivjExitMenuItem = new JMenuItem();
                this.ivjExitMenuItem.setName("ExitMenuItem");
                this.ivjExitMenuItem.setIcon(null);
                this.ivjExitMenuItem.setMnemonic('X');
                this.ivjExitMenuItem.setText("Exit");
                this.ivjExitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/exit.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExitMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.ivjFileMenu == null) {
            try {
                this.ivjFileMenu = new JMenu();
                this.ivjFileMenu.setName("FileMenu");
                this.ivjFileMenu.setMnemonic('F');
                this.ivjFileMenu.setText("File");
                this.ivjFileMenu.add(this.getOpenMenuItem());
                this.ivjFileMenu.add(this.getJSeparator2());
                this.ivjFileMenu.add(this.getExitMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileMenu;
    }

    public int askFileType(File file) {
        Object[] objectArray = new Object[]{"IBM classic/text", "IBM PHD(Portable Heap Dump)/binary", "HPROF binary", "HPROF text"};
        String string = (String)JOptionPane.showInputDialog(this, file.getAbsolutePath() + " is not identified as a valid Java heap dump.\nPlease select a format if you want to force analysis", "Java Heap Dump Format Selection", -1, null, objectArray, "IBM PHD(Portable Heap Dump)/binary");
        if (string == null) {
            return -1;
        }
        if (string.equals(objectArray[0])) {
            return 0;
        }
        if (string.equals(objectArray[2])) {
            return 3;
        }
        if (string.equals(objectArray[3])) {
            return 4;
        }
        return 1;
    }

    public int getFileType(File file) {
        String string;
        Object object;
        Closeable closeable;
        try {
            closeable = new InputStreamReader(this.getInputStream(file));
            object = new char[100];
            ((Reader)closeable).read((char[])object);
            string = new String((char[])object);
            if (string.startsWith("// Version:") || string.startsWith("0x")) {
                ((InputStreamReader)closeable).close();
                return 0;
            }
            if (string.startsWith("JAVA PROFILE") && string.indexOf(", created") != -1) {
                ((InputStreamReader)closeable).close();
                return 4;
            }
            if (string.startsWith("JAVA PROFILE")) {
                ((InputStreamReader)closeable).close();
                return 3;
            }
            if (string.startsWith("IBM HeapAnalyzer")) {
                ((InputStreamReader)closeable).close();
                return 7;
            }
            ((InputStreamReader)closeable).close();
        }
        catch (Exception exception) {
            this.handleException(exception);
            return this.askFileType(file);
        }
        try {
            closeable = this.getInputStream(file);
            object = new DataInputStream((InputStream)closeable);
            string = ((DataInputStream)object).readUTF();
            if (string.equals("portable heap dump")) {
                ((FilterInputStream)object).close();
                ((InputStream)closeable).close();
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.askFileType(file);
    }

    private JMenuItem getFree_MenuItem() {
        if (this.ivjFree_MenuItem == null) {
            try {
                this.ivjFree_MenuItem = new JMenuItem();
                this.ivjFree_MenuItem.setName("Free_MenuItem");
                this.ivjFree_MenuItem.setMnemonic('G');
                this.ivjFree_MenuItem.setText("Gaps by size");
                this.ivjFree_MenuItem.setIcon(new ImageIcon(this.getClass().getResource("/gap.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFree_MenuItem;
    }

    private JMenuBar getHeapAnalyzerJMenuBar() {
        if (this.ivjHeapAnalyzerJMenuBar == null) {
            try {
                this.ivjHeapAnalyzerJMenuBar = new JMenuBar();
                this.ivjHeapAnalyzerJMenuBar.setName("HeapAnalyzerJMenuBar");
                this.ivjHeapAnalyzerJMenuBar.add(this.getFileMenu());
                this.ivjHeapAnalyzerJMenuBar.add(this.getAnalysisMenu());
                this.ivjHeapAnalyzerJMenuBar.add(this.getViewMenu());
                this.ivjHeapAnalyzerJMenuBar.add(this.getHelpMenu());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHeapAnalyzerJMenuBar;
    }

    private JMenuItem getHelp_TopicsMenuItem() {
        if (this.ivjHelp_TopicsMenuItem == null) {
            try {
                this.ivjHelp_TopicsMenuItem = new JMenuItem();
                this.ivjHelp_TopicsMenuItem.setName("Help_TopicsMenuItem");
                this.ivjHelp_TopicsMenuItem.setIcon(null);
                this.ivjHelp_TopicsMenuItem.setMnemonic('H');
                this.ivjHelp_TopicsMenuItem.setText("Help Topics");
                this.ivjHelp_TopicsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/help.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHelp_TopicsMenuItem;
    }

    private JMenu getHelpMenu() {
        if (this.ivjHelpMenu == null) {
            try {
                this.ivjHelpMenu = new JMenu();
                this.ivjHelpMenu.setName("HelpMenu");
                this.ivjHelpMenu.setMnemonic('H');
                this.ivjHelpMenu.setText("Help");
                this.ivjHelpMenu.add(this.getHelp_TopicsMenuItem());
                this.ivjHelpMenu.add(this.getAbout_BoxMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHelpMenu;
    }

    public InputStream getInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItem2() {
        if (this.ivjJCheckBoxMenuItem2 == null) {
            try {
                this.ivjJCheckBoxMenuItem2 = new JCheckBoxMenuItem();
                this.ivjJCheckBoxMenuItem2.setName("JCheckBoxMenuItem2");
                this.ivjJCheckBoxMenuItem2.setSelected(true);
                this.ivjJCheckBoxMenuItem2.setMnemonic('S');
                this.ivjJCheckBoxMenuItem2.setText("Statusbar");
                this.ivjJCheckBoxMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/statusbar.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxMenuItem2;
    }

    public JDesktopPane getJDesktopPane1() {
        if (this.ivjJDesktopPane1 == null) {
            try {
                this.ivjJDesktopPane1 = new JDesktopPane();
                this.ivjJDesktopPane1.setName("JDesktopPane1");
                this.ivjJDesktopPane1.setMinimumSize(new Dimension(600, 200));
                this.ivjJDesktopPane1.setPreferredSize(new Dimension(600, 200));
                this.getJDesktopPane1().add((Component)this.getConsoleFrame(), this.getConsoleFrame().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJDesktopPane1;
    }

    public Container getJFrame() {
        return this;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getJToolBar(), "First");
                this.getJFrameContentPane().add((Component)this.getStatusBarPane(), "South");
                this.getJFrameContentPane().add((Component)this.getJDesktopPane1(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JPanel getJInternalFrameContentPane() {
        if (this.ivjJInternalFrameContentPane == null) {
            try {
                this.ivjJInternalFrameContentPane = new JPanel();
                this.ivjJInternalFrameContentPane.setName("JInternalFrameContentPane");
                this.ivjJInternalFrameContentPane.setLayout(new BorderLayout());
                this.getJInternalFrameContentPane().add((Component)this.getConsoleScrollPane(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJInternalFrameContentPane;
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSeparator getJSeparator3() {
        if (this.ivjJSeparator3 == null) {
            try {
                this.ivjJSeparator3 = new JSeparator();
                this.ivjJSeparator3.setName("JSeparator3");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator3;
    }

    private JSeparator getJSeparator4() {
        if (this.ivjJSeparator4 == null) {
            try {
                this.ivjJSeparator4 = new JSeparator();
                this.ivjJSeparator4.setName("JSeparator4");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator4;
    }

    private JSeparator getJSeparator5() {
        if (this.ivjJSeparator5 == null) {
            try {
                this.ivjJSeparator5 = new JSeparator();
                this.ivjJSeparator5.setName("JSeparator5");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator5;
    }

    private JSeparator getJSeparator6() {
        if (this.ivjJSeparator6 == null) {
            try {
                this.ivjJSeparator6 = new JSeparator();
                this.ivjJSeparator6.setName("JSeparator6");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJSeparator6;
    }

    private JMenuItem getObjectsMenu() {
        if (this.ivjObjectsMenu == null) {
            try {
                this.ivjObjectsMenu = new JMenuItem();
                this.ivjObjectsMenu.setName("ObjectsMenu");
                this.ivjObjectsMenu.setMnemonic('O');
                this.ivjObjectsMenu.setText("Objects List");
                this.ivjObjectsMenu.setIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjObjectsMenu;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.ivjOpenMenuItem == null) {
            try {
                this.ivjOpenMenuItem = new JMenuItem();
                this.ivjOpenMenuItem.setName("OpenMenuItem");
                this.ivjOpenMenuItem.setIcon(null);
                this.ivjOpenMenuItem.setMnemonic('O');
                this.ivjOpenMenuItem.setText("Open");
                this.ivjOpenMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOpenMenuItem;
    }

    private JMenuItem getOptionsJMenuItem() {
        if (this.ivjOptionsJMenuItem == null) {
            try {
                this.ivjOptionsJMenuItem = new JMenuItem();
                this.ivjOptionsJMenuItem.setName("OptionsJMenuItem");
                this.ivjOptionsJMenuItem.setIcon(null);
                this.ivjOptionsJMenuItem.setMnemonic('O');
                this.ivjOptionsJMenuItem.setText("Options");
                this.ivjOptionsJMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/options.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOptionsJMenuItem;
    }

    private JMenuItem getRootMenu() {
        if (this.ivjRootMenu == null) {
            try {
                this.ivjRootMenu = new JMenuItem();
                this.ivjRootMenu.setName("RootMenu");
                this.ivjRootMenu.setMnemonic('R');
                this.ivjRootMenu.setText("Root List");
                this.ivjRootMenu.setIcon(new ImageIcon(this.getClass().getResource("/root.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjRootMenu;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.ivjSaveMenuItem == null) {
            try {
                this.ivjSaveMenuItem = new JMenuItem();
                this.ivjSaveMenuItem.setName("SaveMenuItem");
                this.ivjSaveMenuItem.setIcon(null);
                this.ivjSaveMenuItem.setMnemonic('A');
                this.ivjSaveMenuItem.setText("Save as HeapAnalyzer (HA) format");
                this.ivjSaveMenuItem.setHorizontalAlignment(10);
                this.ivjSaveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/save.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSaveMenuItem;
    }

    private JMenuItem getSaveViewerMenuItem() {
        if (this.ivjSaveViewerMenuItem == null) {
            try {
                this.ivjSaveViewerMenuItem = new JMenuItem();
                this.ivjSaveViewerMenuItem.setName("SaveViewerMenuItem");
                this.ivjSaveViewerMenuItem.setIcon(null);
                this.ivjSaveViewerMenuItem.setMnemonic('S');
                this.ivjSaveViewerMenuItem.setText("Save as HeapAnalyzer Archive (HAV) format");
                this.ivjSaveViewerMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/save.gif")));
                this.ivjSaveViewerMenuItem.setHorizontalAlignment(10);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSaveViewerMenuItem;
    }

    private JMenuItem getSearchMenuItem() {
        if (this.ivjSearchMenuItem == null) {
            try {
                this.ivjSearchMenuItem = new JMenuItem();
                this.ivjSearchMenuItem.setName("SearchMenuItem");
                this.ivjSearchMenuItem.setMnemonic('S');
                this.ivjSearchMenuItem.setText("Search Name");
                this.ivjSearchMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/search.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSearchMenuItem;
    }

    private JMenuItem getStats_MenuItem() {
        if (this.ivjStats_MenuItem == null) {
            try {
                this.ivjStats_MenuItem = new JMenuItem();
                this.ivjStats_MenuItem.setName("Stats_MenuItem");
                this.ivjStats_MenuItem.setMnemonic('a');
                this.ivjStats_MenuItem.setText("Gap Statistics");
                this.ivjStats_MenuItem.setIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjStats_MenuItem;
    }

    private JPanel getStatusBarPane() {
        if (this.ivjStatusBarPane == null) {
            try {
                this.ivjStatusBarPane = new JPanel();
                this.ivjStatusBarPane.setName("StatusBarPane");
                this.ivjStatusBarPane.setLayout(new BorderLayout());
                this.getStatusBarPane().add((Component)this.getStatusMsg1(), "West");
                this.getStatusBarPane().add((Component)this.getStatusMsg2(), "Center");
                this.ivjStatusBarPane.add((Component)this.getHavProgressBar(), "East");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjStatusBarPane;
    }

    private JLabel getStatusMsg1() {
        if (this.ivjStatusMsg1 == null) {
            try {
                this.ivjStatusMsg1 = new JLabel();
                this.ivjStatusMsg1.setName("StatusMsg1");
                this.ivjStatusMsg1.setBorder(new EtchedBorder());
                this.ivjStatusMsg1.setText("HeapAnalyzer");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjStatusMsg1;
    }

    private JLabel getStatusMsg2() {
        if (this.ivjStatusMsg2 == null) {
            try {
                this.ivjStatusMsg2 = new JLabel();
                this.ivjStatusMsg2.setName("StatusMsg2");
                this.ivjStatusMsg2.setBorder(new EtchedBorder());
                this.ivjStatusMsg2.setText("");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjStatusMsg2;
    }

    public void getString(String string) {
        this.returnString = string;
    }

    private JMenuItem getTreeView_MenuItem() {
        if (this.ivjTreeView_MenuItem == null) {
            try {
                this.ivjTreeView_MenuItem = new JMenuItem();
                this.ivjTreeView_MenuItem.setName("TreeView_MenuItem");
                this.ivjTreeView_MenuItem.setMnemonic('T');
                this.ivjTreeView_MenuItem.setText("Tree view");
                this.ivjTreeView_MenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTreeView_MenuItem;
    }

    private JMenuItem getTypesMenu() {
        if (this.ivjTypesMenu == null) {
            try {
                this.ivjTypesMenu = new JMenuItem();
                this.ivjTypesMenu.setName("TypesMenu");
                this.ivjTypesMenu.setMnemonic('y');
                this.ivjTypesMenu.setText("Types List");
                this.ivjTypesMenu.setActionCommand("Types List");
                this.ivjTypesMenu.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTypesMenu;
    }

    public JMenu getViewMenu() {
        if (this.ivjViewMenu == null) {
            try {
                this.ivjViewMenu = new JMenu();
                this.ivjViewMenu.setName("ViewMenu");
                this.ivjViewMenu.setMnemonic('V');
                this.ivjViewMenu.setText("View");
                this.ivjViewMenu.add(this.getOptionsJMenuItem());
                this.ivjViewMenu.add(this.getClearConsoleMenuItem());
                this.ivjViewMenu.add(this.getJSeparator6());
                this.ivjViewMenu.add(this.getJCheckBoxMenuItem2());
                this.ivjViewMenu.add(this.getConsoleCheckBoxMenuItem());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjViewMenu;
    }

    public void handleException(Throwable throwable) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (gregorianCalendar != null) {
            System.out.print("[" + gregorianCalendar.getTime() + "] ");
        }
        throwable.printStackTrace(System.out);
        JOptionPane.showMessageDialog(this, throwable.toString(), "Exception", 2);
    }

    public void heapAnalyzer_WindowClosing() {
        if (JOptionPane.showConfirmDialog(this, "Do you want to exit IBM HeapAnalyzer?", "Exit", 0) == 1) {
            return;
        }
        if (this.cfg.save) {
            this.saveConfiguration();
        }
        System.exit(0);
    }

    public void help_TopicsMenuItem_Accelerator() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL uRL = this.getClass().getResource("/readme.html");
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Couldn't readd file: readme.html", "Information", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Couldn't find file: readme.html", "Information", 1);
            return;
        }
        HeapFrame heapFrame = new HeapFrame("Help");
        heapFrame.JScrollPaneSetViewportView(jEditorPane);
        this.getJDesktopPane1().add(heapFrame);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public void hprof_ActionPerformed() {
        JFileChooser jFileChooser = new JFileChooser();
        JDialog jDialog = new JDialog(this);
        jFileChooser.showDialog(jDialog, "Open");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File not found:" + file.getAbsoluteFile(), "File Open Error", 2);
            return;
        }
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.htask = new HprofTask(this, file, this.jp);
        this.htask.go();
        this.htimer.start();
    }

    public void hprof_ActionPerformed(File file) {
        File file2 = file;
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.htask = new HprofTask(this, file2, this.jp);
        this.htask.go();
        this.htimer.start();
    }

    public void hprof_txt_ActionPerformed(File file) {
        File file2 = file;
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.htxttask = new HprofTxtTask(this, file2, this.jp);
        this.htxttask.go();
        this.htxttimer.start();
    }

    private void initConnections() throws Exception {
        this.getStatusbarToggleButton().addActionListener(this.ivjEventHandler);
        this.getConsoleToggleButton().addActionListener(this.ivjEventHandler);
        this.getAboutButton().addActionListener(this.ivjEventHandler);
        this.getHelpButton().addActionListener(this.ivjEventHandler);
        this.getChartButton().addActionListener(this.ivjEventHandler);
        this.getGapButton().addActionListener(this.ivjEventHandler);
        this.getClearButton().addActionListener(this.ivjEventHandler);
        this.getOptionButton().addActionListener(this.ivjEventHandler);
        this.getNameButton().addActionListener(this.ivjEventHandler);
        this.getAddressButton().addActionListener(this.ivjEventHandler);
        this.getOpenButton().addActionListener(this.ivjEventHandler);
        this.getSaveButton().addActionListener(this.ivjEventHandler);
        this.getTreeButton().addActionListener(this.ivjEventHandler);
        this.getObjectButton().addActionListener(this.ivjEventHandler);
        this.getTypeButton().addActionListener(this.ivjEventHandler);
        this.getRootButton().addActionListener(this.ivjEventHandler);
        this.getJCheckBoxMenuItem2().addActionListener(this.ivjEventHandler);
        this.getAbout_BoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getOpenMenuItem().addActionListener(this.ivjEventHandler);
        this.getSaveViewerMenuItem().addActionListener(this.ivjEventHandler);
        this.getFree_MenuItem().addActionListener(this.ivjEventHandler);
        this.getStats_MenuItem().addActionListener(this.ivjEventHandler);
        this.getOptionsJMenuItem().addActionListener(this.ivjEventHandler);
        this.getTreeView_MenuItem().addActionListener(this.ivjEventHandler);
        this.getHelp_TopicsMenuItem().addActionListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getSaveMenuItem().addActionListener(this.ivjEventHandler);
        this.getTreeView_MenuItem().addMouseListener(this.ivjEventHandler);
        this.getOpenMenuItem().addMouseListener(this.ivjEventHandler);
        this.getSaveMenuItem().addMouseListener(this.ivjEventHandler);
        this.getExitMenuItem().addMouseListener(this.ivjEventHandler);
        this.getFree_MenuItem().addMouseListener(this.ivjEventHandler);
        this.getStats_MenuItem().addMouseListener(this.ivjEventHandler);
        this.getSearchMenuItem().addMouseListener(this.ivjEventHandler);
        this.getOptionsJMenuItem().addMouseListener(this.ivjEventHandler);
        this.getJCheckBoxMenuItem2().addMouseListener(this.ivjEventHandler);
        this.getHelp_TopicsMenuItem().addMouseListener(this.ivjEventHandler);
        this.getAbout_BoxMenuItem().addMouseListener(this.ivjEventHandler);
        this.getObjectsMenu().addActionListener(this.ivjEventHandler);
        this.getTypesMenu().addActionListener(this.ivjEventHandler);
        this.getConsoleCheckBoxMenuItem().addActionListener(this.ivjEventHandler);
        this.getConsoleCheckBoxMenuItem().addMouseListener(this.ivjEventHandler);
        this.getObjectsMenu().addMouseListener(this.ivjEventHandler);
        this.getTypesMenu().addMouseListener(this.ivjEventHandler);
        this.getSearchMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearConsoleMenuItem().addActionListener(this.ivjEventHandler);
        this.getExitMenuItem().addActionListener(this.ivjEventHandler);
        this.getAddressMenuItem().addActionListener(this.ivjEventHandler);
        this.getRootMenu().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        Object object;
        Object object2;
        Serializable serializable;
        try {
            this.setName("HeapAnalyzer");
            this.setDefaultCloseOperation(0);
            this.setJMenuBar(this.getHeapAnalyzerJMenuBar());
            this.setSize(833, 698);
            this.setTitle("IBM HeapAnalyzer");
            this.setContentPane(this.getJFrameContentPane());
            serializable = new ImageIcon(this.getClass().getResource("/ha.gif"));
            this.setIconImage(((ImageIcon)serializable).getImage());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        serializable = new File(cfgFile);
        if (!((File)serializable).exists()) {
            this.cfg = new Configuration();
        } else {
            try {
                object2 = new GZIPInputStream(new FileInputStream((File)serializable));
                object = new ObjectInputStream((InputStream)object2);
                this.cfg = (Configuration)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
                ((GZIPInputStream)object2).close();
            }
            catch (InvalidClassException invalidClassException) {
                this.cfg = new Configuration();
                System.out.println("Creating new configuration due to new configuration file format.");
            }
            catch (Exception exception) {
                this.handleException(exception);
                this.cfg = new Configuration();
                JOptionPane.showMessageDialog(this, "Cannot understand configuration file :" + ((File)serializable).getAbsoluteFile(), "File Format Error", 2);
            }
        }
        this.setSize(this.cfg.width, this.cfg.height);
        this.setLocation(this.cfg.locationX, this.cfg.locationY);
        this.getConsoleFrame().setSize(this.cfg.cwidth, this.cfg.cheight);
        this.getConsoleFrame().setLocation(this.cfg.clocationX, this.cfg.clocationY);
        MAX_SUBTREE = this.cfg.maxsub;
        MAX_VIEW_SIZE = this.cfg.maxview;
        RATIO = this.cfg.ratio;
        SUBTREE = this.cfg.subtree;
        MIN_DROP = this.cfg.drop;
        try {
            switch (this.cfg.lookAndFeel) {
                case 0: {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    break;
                }
                case 1: {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    break;
                }
                case 2: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.out.println("Saved Look and Feel is not supported on this platform. Trying Cross Platform Look and Feel.");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                System.out.println("Cross Platform Look and Feel is applied.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Cross Platform Look and Feel failed.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this.getJFrame());
        this.console = new ConsolePrintStream(this.getConsoleTextArea());
        System.setOut(this.console);
        System.setErr(this.console);
        this.getConsoleTextArea().setText(this.cfg.consoleText);
        this.getConsoleTextArea().setCaretPosition(this.cfg.consoleText.length());
        this.jp = new JDialogProgress(this);
        this.dp = new DropProgressDialog(this);
        object2 = this.dp.getPreferredSize();
        object = this.getSize();
        Point point = this.getLocation();
        this.dp.setLocation((((Dimension)object).width - ((Dimension)object2).width) / 2 + point.x, (((Dimension)object).height - ((Dimension)object2).height) / 2 + point.y);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeapAnalyzer.this.jp.isCanceled) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.timer.stop();
                    HeapAnalyzer.this.task.done();
                    HeapAnalyzer.this.jp.dispose();
                    return;
                }
                HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.task.getCurrent());
                HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.task.getOverall());
                HeapAnalyzer.this.jp.getJLabelElapsed().setText(HeapAnalyzer.this.task.getElapsed());
                String string = HeapAnalyzer.this.task.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.jp.getJLabel1().setText(string);
                }
                if (HeapAnalyzer.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.timer.stop();
                    HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
        this.ptimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeapAnalyzer.this.jp.isCanceled) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.ptimer.stop();
                    HeapAnalyzer.this.ptask.done();
                    HeapAnalyzer.this.jp.dispose();
                    return;
                }
                HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.ptask.getCurrent());
                HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.ptask.getOverall());
                HeapAnalyzer.this.jp.getJLabelElapsed().setText(HeapAnalyzer.this.ptask.getElapsed());
                String string = HeapAnalyzer.this.ptask.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.jp.getJLabel1().setText(string);
                }
                if (HeapAnalyzer.this.ptask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.ptimer.stop();
                    HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
        this.havtimer = new Timer(2000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapAnalyzer.this.getProgressBar().setValue(HeapAnalyzer.this.havtask.getCurrent());
                if (HeapAnalyzer.this.havtask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.havtimer.stop();
                    HeapAnalyzer.this.getProgressBar().setValue(HeapAnalyzer.this.getProgressBar().getMaximum());
                }
            }
        });
        this.htimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeapAnalyzer.this.jp.isCanceled) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.htimer.stop();
                    HeapAnalyzer.this.htask.done();
                    HeapAnalyzer.this.jp.dispose();
                    return;
                }
                HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.htask.getCurrent());
                HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.htask.getOverall());
                HeapAnalyzer.this.jp.getJLabelElapsed().setText(HeapAnalyzer.this.htask.getElapsed());
                String string = HeapAnalyzer.this.htask.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.jp.getJLabel1().setText(string);
                }
                if (HeapAnalyzer.this.htask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.htimer.stop();
                    HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
        this.htxttimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeapAnalyzer.this.jp.isCanceled) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.htxttimer.stop();
                    HeapAnalyzer.this.htxttask.done();
                    HeapAnalyzer.this.jp.dispose();
                    return;
                }
                HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.htxttask.getCurrent());
                HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.htxttask.getOverall());
                HeapAnalyzer.this.jp.getJLabelElapsed().setText(HeapAnalyzer.this.htxttask.getElapsed());
                String string = HeapAnalyzer.this.htxttask.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.jp.getJLabel1().setText(string);
                }
                if (HeapAnalyzer.this.htxttask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.htxttimer.stop();
                    HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
        this.savetimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapAnalyzer.this.fd.getJProgressBar1().setValue(HeapAnalyzer.this.vtask.getCurrent());
                HeapAnalyzer.this.fd.getJLabelElapsed().setText(HeapAnalyzer.this.vtask.getElapsed());
                String string = HeapAnalyzer.this.vtask.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.fd.setMessageText(string);
                }
                if (HeapAnalyzer.this.vtask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.savetimer.stop();
                    HeapAnalyzer.this.fd.getJProgressBar1().setValue(HeapAnalyzer.this.fd.getJProgressBar1().getMaximum());
                }
            }
        });
        this.otimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeapAnalyzer.this.jp.isCanceled) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.otimer.stop();
                    HeapAnalyzer.this.jp.dispose();
                    return;
                }
                HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.otask.getCurrent());
                HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.otask.getOverall());
                HeapAnalyzer.this.jp.getJLabelElapsed().setText(HeapAnalyzer.this.otask.getElapsed());
                String string = HeapAnalyzer.this.otask.getMessage();
                if (string != null) {
                    HeapAnalyzer.this.jp.getJLabel1().setText(string);
                }
                if (HeapAnalyzer.this.otask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapAnalyzer.this.otimer.stop();
                    HeapAnalyzer.this.jp.getJProgressBar1().setValue(HeapAnalyzer.this.jp.getJProgressBar1().getMaximum());
                    HeapAnalyzer.this.jp.getOverallProgressBar().setValue(HeapAnalyzer.this.jp.getOverallProgressBar().getMaximum());
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            HeapAnalyzer heapAnalyzer = new HeapAnalyzer();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = heapAnalyzer.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            heapAnalyzer.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            heapAnalyzer.setVisible(true);
            if (stringArray != null && stringArray.length != 0) {
                heapAnalyzer.openBatch(stringArray);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of HeapAnalyzer");
            throwable.printStackTrace(System.out);
        }
    }

    public void object_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Objects View", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/list.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        HeapTable heapTable = new HeapTable(heapInfo, this);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in a tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same type");
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame2.JScrollPaneSetViewportView(heapTable);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        TableThread tableThread = new TableThread(heapTable, heapInfo);
        tableThread.start();
    }

    public void object_MenuItem_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Objects sorted by size", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(3, MAX_OBJECTLIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void object_MenuItem_ActionPerformed_NumberOfChild() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Objects sorted by NumberOfChild", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(7, MAX_OBJECTLIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void object_MenuItem_ActionPerformed_TotalSize() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Objects sorted by TotalSize", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(6, MAX_OBJECTLIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void openBatch(String[] stringArray) {
        if (stringArray != null && stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, "File not found:" + file.getAbsoluteFile(), "File Open Error", 2);
                    continue;
                }
                int n = this.getFileType(file);
                if (n < 0) {
                    JOptionPane.showMessageDialog(this, "Cannot understand file :" + file.getAbsoluteFile(), "File Format Error", 2);
                    continue;
                }
                if (n == 1) {
                    this.pHDItem_ActionPerformed(file);
                    continue;
                }
                if (n == 2) {
                    this.openSavedMenuItem_ActionPerformed(file);
                    continue;
                }
                if (n == 3) {
                    this.hprof_ActionPerformed(file);
                    continue;
                }
                if (n == 4) {
                    this.hprof_txt_ActionPerformed(file);
                    continue;
                }
                if (n == 7) {
                    this.hav_ActionPerformed(file);
                    continue;
                }
                Dimension dimension = this.jp.getPreferredSize();
                Dimension dimension2 = this.getSize();
                Point point = this.getLocation();
                this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
                this.jp.show();
                this.task = new FileTask(this, file, this.jp);
                this.task.go();
                this.timer.start();
            }
        }
    }

    public void openFile_ActionPerformed() {
        JFileChooser jFileChooser;
        if (this.cfg.workingDir == null) {
            String string = System.getProperty("user.dir");
            jFileChooser = new JFileChooser(string);
        } else {
            jFileChooser = new JFileChooser(this.cfg.workingDir);
        }
        JDialog jDialog = new JDialog(this);
        int n = jFileChooser.showDialog(jDialog, "Open");
        File file = jFileChooser.getSelectedFile();
        if (this.cfg.recent) {
            this.cfg.workingDir = jFileChooser.getCurrentDirectory();
        }
        if (n == 1) {
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File not found:" + file.getAbsoluteFile(), "File Open Error", 2);
            return;
        }
        if (file.getName().endsWith(".gz") || file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            JOptionPane.showMessageDialog(this, "Please uncompress file :" + file.getAbsoluteFile(), "File Format Error", 2);
            return;
        }
        int n2 = this.getFileType(file);
        if (n2 < 0) {
            return;
        }
        if (n2 == 1) {
            this.pHDItem_ActionPerformed(file);
            return;
        }
        if (n2 == 2) {
            this.openSavedMenuItem_ActionPerformed(file);
            return;
        }
        if (n2 == 3) {
            this.hprof_ActionPerformed(file);
            return;
        }
        if (n2 == 4) {
            this.hprof_txt_ActionPerformed(file);
            return;
        }
        if (n2 == 7) {
            this.hav_ActionPerformed(file);
            return;
        }
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.task = new FileTask(this, file, this.jp);
        this.task.go();
        this.timer.start();
    }

    public void openMenuItem_ActionPerformed(ActionEvent actionEvent) {
        Object object;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            return;
        }
        long l = 0L;
        Vector vector = heapFrame.freeNodes;
        if (vector == null) {
            return;
        }
        FreeSpaceTableModel freeSpaceTableModel = new FreeSpaceTableModel();
        Enumeration enumeration = vector.elements();
        int n = 0;
        long l2 = 0L;
        while (enumeration.hasMoreElements()) {
            object = (FreeNode)enumeration.nextElement();
            n = this.get10(((FreeNode)object).size);
            if (n > 9) {
                n = 9;
            }
            l2 = (Long)freeSpaceTableModel.getValueAt(n, 1);
            freeSpaceTableModel.setValueAt(new Long(++l2), n, 1);
        }
        object = new HeapFrame(heapFrame.getTitle() + " Free heap space analysis");
        JTable jTable = new JTable(freeSpaceTableModel);
        ((HeapFrame)object).JScrollPaneSetViewportView(jTable);
        this.getJDesktopPane1().add((Component)object);
        this.getJDesktopPane1().getDesktopManager().activateFrame((JInternalFrame)object);
    }

    public void openSavedMenuItem_ActionPerformed(File file) {
        File file2 = file;
        HeapInfo heapInfo = new HeapInfo();
        FileProcessDialog fileProcessDialog = new FileProcessDialog(this);
        Dimension dimension = fileProcessDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        fileProcessDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        fileProcessDialog.show();
        this.otask = new OpenTask(this, file2, fileProcessDialog, heapInfo);
        this.otask.go();
        this.otimer.start();
    }

    public void hav_ActionPerformed(File file) {
        File file2 = file;
        HeapInfo heapInfo = new HeapInfo();
        FileProcessDialog fileProcessDialog = new FileProcessDialog(this);
        Dimension dimension = fileProcessDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        fileProcessDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        fileProcessDialog.show();
        this.havtask = new OpenHavTask(this, file2, fileProcessDialog, heapInfo);
        this.havtask.go();
    }

    public void optionsJMenuItem_ActionPerformed() {
        JDialogOption jDialogOption = new JDialogOption((Frame)this, this);
        Dimension dimension = jDialogOption.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        jDialogOption.setLocation((dimension2.width - dimension.width) / 4 + point.x, (dimension2.height - dimension.height) / 6 + point.y);
        jDialogOption.setModal(true);
        jDialogOption.show();
    }

    public void pHDItem_ActionPerformed() {
        JFileChooser jFileChooser = new JFileChooser();
        JDialog jDialog = new JDialog(this);
        jFileChooser.showDialog(jDialog, "Open");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File not found:" + file.getAbsoluteFile(), "File Open Error", 2);
            return;
        }
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.ptask = new PHDTask(this, file, this.jp);
        this.ptask.go();
        this.ptimer.start();
    }

    public void pHDItem_ActionPerformed(File file) {
        File file2 = file;
        Dimension dimension = this.jp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.jp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.jp.show();
        this.ptask = new PHDTask(this, file2, this.jp);
        this.ptask.go();
        this.ptimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootMenu_ActionPerformed(ActionEvent actionEvent) {
        int n;
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.getRootChildrenLength() == 0) {
            JOptionPane.showMessageDialog(this, "There's no root objects", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapInfo.getFile().getName() + " Root List", heapInfo);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/root.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        heapFrame2.fileName = heapInfo.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(heapInfo, this);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame2.JScrollPaneSetViewportView(heapTable);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        SearchTableModel searchTableModel = new SearchTableModel(heapInfo, 0);
        searchTableModel.modelArray = new long[2][heapInfo.getRootChildrenLength()];
        int n2 = 0;
        long l = 0L;
        if (heapInfo.isHav()) {
            RandomAccessFile randomAccessFile = heapInfo.getHav().raf;
            synchronized (randomAccessFile) {
                try {
                    heapInfo.getHav().raf.seek(heapInfo.getHav().getHeapBaseLocation());
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    for (n = 0; n < heapInfo.getRootChildrenLength(); ++n) {
                        l4 = heapInfo.getHav().raf.getFilePointer() - heapInfo.getHav().getHeapBaseLocation();
                        heapInfo.getHav().read(heapInfo.getHav().raf);
                        l2 = heapInfo.getHav().read(heapInfo.getHav().raf);
                        n2 = (int)((long)n2 + l2);
                        l3 = heapInfo.getHav().read(heapInfo.getHav().raf);
                        l += l3 + l2;
                        heapInfo.getHav().readName(heapInfo.getHav().raf);
                        heapInfo.getHav().raf.readInt();
                        searchTableModel.modelArray[0][n] = l3;
                        searchTableModel.modelArray[1][n] = l4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        for (int i = 0; i < heapInfo.getRootChildrenLength(); ++i) {
            n2 += heapInfo.getSize(heapInfo.getRootChildren(i));
            l += heapInfo.getTotal(heapInfo.getRootChildren(i));
            searchTableModel.modelArray[0][i] = heapInfo.getTotal(heapInfo.getRootChildren(i));
            searchTableModel.modelArray[1][i] = heapInfo.getRootChildren(i);
        }
        searchTableModel.columnNames[0] = searchTableModel.columnNames[0] + "/" + numberFormatter.format(l);
        searchTableModel.columnNames[1] = searchTableModel.columnNames[1] + "/" + numberFormatter.format(n2);
        searchTableModel.columnNames[4] = searchTableModel.columnNames[4] + "(" + numberFormatter.format(heapInfo.getRootChildrenLength()) + " objects)";
        searchTableModel.setTableHeader(heapTable.getTableHeader());
        if (searchTableModel.sortedArrary == null) {
            searchTableModel.sortedArrary = new long[2][heapInfo.getRootChildrenLength()];
            if (heapInfo.isHav()) {
                long l5 = 0L;
                long l6 = 0L;
                long l7 = 0L;
                RandomAccessFile randomAccessFile = heapInfo.getHav().raf;
                synchronized (randomAccessFile) {
                    try {
                        heapInfo.getHav().raf.seek(heapInfo.getHav().getHeapBaseLocation());
                        for (n = 0; n < heapInfo.getRootChildrenLength(); ++n) {
                            l6 = heapInfo.getHav().raf.getFilePointer() - heapInfo.getHav().getHeapBaseLocation();
                            heapInfo.getHav().read(heapInfo.getHav().raf);
                            l5 = heapInfo.getHav().read(heapInfo.getHav().raf);
                            l7 = heapInfo.getHav().read(heapInfo.getHav().raf);
                            heapInfo.getHav().readName(heapInfo.getHav().raf);
                            heapInfo.getHav().raf.readInt();
                            searchTableModel.sortedArrary[0][n] = l7 + l5;
                            searchTableModel.sortedArrary[1][n] = l6;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            for (int i = 0; i < heapInfo.getRootChildrenLength(); ++i) {
                searchTableModel.sortedArrary[0][i] = heapInfo.getTotal(heapInfo.getRootChildren(i));
                searchTableModel.sortedArrary[1][i] = heapInfo.getRootChildren(i);
            }
            if (this.cfg.verbose) {
                System.out.println("[" + new Date() + "] Sorting table by Total Size.");
            }
            Arrays2.sort(searchTableModel.sortedArrary);
        }
        heapTable.setModel(searchTableModel);
        TableColumnModel tableColumnModel = heapTable.getColumnModel();
        for (int i = 0; i < 6; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(80);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                tableColumn.setPreferredWidth(50);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 5) {
                tableColumn.setPreferredWidth(80);
                continue;
            }
            tableColumn.setPreferredWidth(300);
        }
    }

    void saveConfiguration() {
        if (this.cfg.verbose) {
            System.out.println("[" + new Date() + "] Saving configuration file.");
        }
        this.cfg.consoleText = this.getConsoleTextArea().getText();
        Rectangle rectangle = this.getBounds();
        Point point = this.getLocation();
        Dimension dimension = this.getConsoleFrame().getSize();
        Point point2 = this.getConsoleFrame().getLocation();
        this.cfg.width = rectangle.width;
        this.cfg.height = rectangle.height;
        this.cfg.locationX = point.x;
        this.cfg.locationY = point.y;
        this.cfg.cwidth = dimension.width;
        this.cfg.cheight = dimension.height;
        this.cfg.clocationX = point2.x;
        this.cfg.clocationY = point2.y;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(cfgFile));
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this.cfg);
            objectOutputStream.flush();
            objectOutputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            this.handleException(exception);
            exception.printStackTrace();
        }
    }

    public void saveViewer() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        JFileChooser jFileChooser = null;
        jFileChooser = this.cfg.workingDir == null ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.cfg.workingDir);
        JinwooFileFilter jinwooFileFilter = new JinwooFileFilter("hav", "IBM HeapAnalyzer Viewer Files");
        jFileChooser.addChoosableFileFilter(jinwooFileFilter);
        JDialog jDialog = new JDialog(this);
        jFileChooser.showDialog(jDialog, "Save as HAV");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.exists() && JOptionPane.showConfirmDialog(this, file.getAbsoluteFile() + " exist. Do you want to overwrite?", "File Already exists", 0) != 0) {
            return;
        }
        this.fd = new FileProcessDialog((Frame)this, "Save as IBM HeapAnalyzer Viewer File");
        this.fd.getJProgressBar1().setIndeterminate(false);
        this.fd.setMessageText("Saving header");
        Dimension dimension = this.fd.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.fd.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        this.fd.show();
        this.vtask = new SaveViewerTask(this, file, this.fd, heapInfo);
        this.vtask.go();
        this.savetimer.start();
    }

    public void saveMenuItem_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        JinwooFileFilter jinwooFileFilter = new JinwooFileFilter("ha", "HeapAnalyzer Files");
        jFileChooser.addChoosableFileFilter(jinwooFileFilter);
        JDialog jDialog = new JDialog(this);
        jFileChooser.showDialog(jDialog, "Save");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.exists() && JOptionPane.showConfirmDialog(this, file.getAbsoluteFile() + " exist. Do you want to overwrite?", "File Already exists", 0) != 0) {
            return;
        }
        FileProcessDialog fileProcessDialog = new FileProcessDialog(this);
        Dimension dimension = fileProcessDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        fileProcessDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        fileProcessDialog.show();
        this.stask = new SaveTask(this, file, fileProcessDialog, heapInfo);
        this.stask.go();
    }

    public void search_ActionPerformed() {
        boolean bl = false;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        FindTypes findTypes = new FindTypes((Frame)this, heapInfo, this, true);
        Dimension dimension = findTypes.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        findTypes.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        findTypes.show();
    }

    public void showAboutBox() {
        HeapAnalyzerAboutBox heapAnalyzerAboutBox = new HeapAnalyzerAboutBox(this);
        Dimension dimension = heapAnalyzerAboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        heapAnalyzerAboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        heapAnalyzerAboutBox.setModal(true);
        heapAnalyzerAboutBox.show();
    }

    public HeapFrame getHeapFrame() {
        int n;
        JInternalFrame[] jInternalFrameArray = this.getJDesktopPane1().getAllFrames();
        Object var2_2 = null;
        Object var3_3 = null;
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (!(jInternalFrameArray[n] instanceof HeapFrame)) continue;
            if (jInternalFrameArray[n].isSelected()) {
                return (HeapFrame)jInternalFrameArray[n];
            }
            if (((HeapFrame)jInternalFrameArray[n]).main1 == null) continue;
            if (((HeapFrame)jInternalFrameArray[n]).main1.isSelected()) {
                return ((HeapFrame)jInternalFrameArray[n]).main1;
            }
            if (!((HeapFrame)jInternalFrameArray[n]).main2.isSelected()) continue;
            return ((HeapFrame)jInternalFrameArray[n]).main2;
        }
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (!(jInternalFrameArray[n] instanceof HeapFrame)) continue;
            return (HeapFrame)jInternalFrameArray[n];
        }
        return null;
    }

    public void treeView_MenuItem_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Tree View", heapFrame.hi, this);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/tree.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        heapFrame2.fileName = heapFrame.fileName;
        HeapTree heapTree = new HeapTree(heapInfo, this);
        heapTree.addTreeSelectionListener(heapFrame2);
        heapTree.hf = heapFrame2;
        this.dp = new DropProgressDialog(this);
        Dimension dimension = this.dp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        this.dp.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        HeapTree heapTree2 = this.addLeakSuspectView(heapInfo, heapFrame2, null, false);
        heapFrame2.ht = heapTree;
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public void type_MenuItem_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Types sorted by sum of Size", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(1, MAX_SIZELIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void typeByName_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Types sorted by name", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setDragEnabled(true);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(4, MAX_TYPELIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void typeCount_JMenuItem_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Types sorted by Frequency", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setDragEnabled(true);
        jTextArea.setEditable(false);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        AppendThread appendThread = new AppendThread(2, MAX_COUNTLIST, jTextArea, heapInfo);
        appendThread.start();
    }

    public void typesMenu_ActionPerformed() {
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        HeapInfo heapInfo = heapFrame.hi;
        if (heapInfo == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
            JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.hi.getFile().getName() + " Types View", heapFrame.hi);
        heapFrame2.fileName = heapFrame.fileName;
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/list_type.gif"));
        heapFrame2.setFrameIcon(imageIcon);
        HeapTable heapTable = new HeapTable(heapInfo, this);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find same type");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame2.JScrollPaneSetViewportView(heapTable);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        try {
            heapFrame2.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        TableThreadTypes tableThreadTypes = new TableThreadTypes(heapTable, heapInfo);
        tableThreadTypes.start();
    }

    public void undoMenuItem_ActionPerformed(ActionEvent actionEvent) {
        long[] lArray = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        long l = 0L;
        HeapFrame heapFrame = this.getHeapFrame();
        if (heapFrame == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return;
        }
        Vector vector = heapFrame.freeNodes;
        if (vector == null) {
            return;
        }
        HeapFrame heapFrame2 = new HeapFrame(heapFrame.getTitle() + " Free heap space analysis");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        heapFrame2.JScrollPaneSetViewportView(jTextArea);
        this.getJDesktopPane1().add(heapFrame2);
        this.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame2);
        jTextArea.append("Lower limit - Upper limit\t\tFrequency\r\n");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FreeNode freeNode = (FreeNode)enumeration.nextElement();
            int n = this.get10(freeNode.size);
            lArray[n] = lArray[n] + 1L;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            jTextArea.append((int)Math.pow(10.0, i) + "-" + ((int)Math.pow(10.0, i + 1) - 1) + "\t\t" + (int)lArray[i] + "\n");
        }
    }

    public void viewConsole() {
        try {
            this.getConsoleFrame().setIcon(!this.getConsoleFrame().isIcon());
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public void viewStatusBar() {
        this.getStatusBarPane().setVisible(!this.getStatusBarPane().isVisible());
    }

    public static boolean isHeadLess(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length <= 1) {
            return false;
        }
        if (stringArray[0] == null) {
            return false;
        }
        return stringArray.length >= 2;
    }

    public static void runHeadLess(String[] stringArray) {
        HeapAnalyzerHeadless heapAnalyzerHeadless = new HeapAnalyzerHeadless(stringArray[1]);
        heapAnalyzerHeadless.heapAnalysis(stringArray[0], stringArray[1]);
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public JProgressBar getProgressBar() {
        return this.getHavProgressBar();
    }

    private JProgressBar getHavProgressBar() {
        if (this.havProgressBar == null) {
            this.havProgressBar = new JProgressBar();
            this.havProgressBar.setStringPainted(true);
            this.havProgressBar.setString("");
        }
        return this.havProgressBar;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setName("IBM HeapAnalyzer Tool Bar");
            this.jToolBar.setPreferredSize(new Dimension(32, 32));
            this.jToolBar.setBorder(null);
            this.jToolBar.setMaximumSize(new Dimension(32, 32));
            this.jToolBar.setMinimumSize(new Dimension(100, 100));
            this.jToolBar.setFloatable(true);
            this.jToolBar.setCursor(new Cursor(0));
            this.jToolBar.setToolTipText("IBM HeapAnalyzer Tool Bar");
            this.jToolBar.add(this.getOpenButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getTreeButton());
            this.jToolBar.add(this.getObjectButton());
            this.jToolBar.add(this.getTypeButton());
            this.jToolBar.add(this.getRootButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getGapButton());
            this.jToolBar.add(this.getChartButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getNameButton());
            this.jToolBar.add(this.getAddressButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getOptionButton());
            this.jToolBar.add(this.getClearButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getStatusbarToggleButton());
            this.jToolBar.add(this.getConsoleToggleButton());
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.getAboutButton());
            this.jToolBar.add(this.getHelpButton());
        }
        return this.jToolBar;
    }

    private JButton getOpenButton2() {
        if (this.openButton == null) {
            this.openButton = new JButton();
        }
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
        this.openButton.setActionCommand("Open");
        this.openButton.setPreferredSize(new Dimension(28, 28));
        this.openButton.setBounds(new Rectangle(16, 1, 28, 28));
        this.openButton.setToolTipText("Open");
        return this.openButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
        }
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/save.gif")));
        this.saveButton.setToolTipText("Save");
        return this.saveButton;
    }

    private JButton getTreeButton() {
        if (this.treeButton == null) {
            this.treeButton = new JButton();
        }
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        this.treeButton.setToolTipText("Tree View");
        return this.treeButton;
    }

    private JButton getObjectButton() {
        if (this.objectButton == null) {
            this.objectButton = new JButton();
        }
        this.objectButton.setIcon(new ImageIcon(this.getClass().getResource("/list.gif")));
        this.objectButton.setToolTipText("Object List");
        return this.objectButton;
    }

    private JButton getTypeButton() {
        if (this.typeButton == null) {
            this.typeButton = new JButton();
        }
        this.typeButton.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        this.typeButton.setToolTipText("Type List");
        return this.typeButton;
    }

    private JButton getRootButton() {
        if (this.rootButton == null) {
            this.rootButton = new JButton();
        }
        this.rootButton.setIcon(new ImageIcon(this.getClass().getResource("/root.gif")));
        this.rootButton.setToolTipText("Root List");
        return this.rootButton;
    }

    private JButton getGapButton() {
        if (this.gapButton == null) {
            this.gapButton = new JButton();
        }
        this.gapButton.setIcon(new ImageIcon(this.getClass().getResource("/gap.gif")));
        this.gapButton.setToolTipText("Gaps by Size");
        return this.gapButton;
    }

    private JButton getChartButton() {
        if (this.chartButton == null) {
            this.chartButton = new JButton();
        }
        this.chartButton.setIcon(new ImageIcon(this.getClass().getResource("/chart.gif")));
        this.chartButton.setToolTipText("Gap Statistics");
        return this.chartButton;
    }

    private JButton getNameButton() {
        if (this.nameButton == null) {
            this.nameButton = new JButton();
        }
        this.nameButton.setIcon(new ImageIcon(this.getClass().getResource("/search.gif")));
        this.nameButton.setToolTipText("Search Name");
        return this.nameButton;
    }

    private JButton getAddressButton() {
        if (this.addressButton == null) {
            this.addressButton = new JButton();
        }
        this.addressButton.setIcon(new ImageIcon(this.getClass().getResource("/address.gif")));
        this.addressButton.setToolTipText("Search Address");
        return this.addressButton;
    }

    private JButton getOptionButton() {
        if (this.optionButton == null) {
            this.optionButton = new JButton();
        }
        this.optionButton.setIcon(new ImageIcon(this.getClass().getResource("/options.gif")));
        this.optionButton.setToolTipText("Options");
        return this.optionButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
        }
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/clear.gif")));
        this.clearButton.setToolTipText("Clear Console");
        return this.clearButton;
    }

    private JToggleButton getStatusbarToggleButton() {
        if (this.statusbarToggleButton == null) {
            this.statusbarToggleButton = new JToggleButton();
        }
        this.statusbarToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/statusbar.gif")));
        this.statusbarToggleButton.setToolTipText("Status Bar");
        return this.statusbarToggleButton;
    }

    private JToggleButton getConsoleToggleButton() {
        if (this.consoleToggleButton == null) {
            this.consoleToggleButton = new JToggleButton();
        }
        this.consoleToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/console.gif")));
        this.consoleToggleButton.setToolTipText("Console");
        return this.consoleToggleButton;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
        }
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/help.gif")));
        this.helpButton.setToolTipText("Help");
        return this.helpButton;
    }

    private JButton getAboutButton() {
        if (this.aboutButton == null) {
            this.aboutButton = new JButton();
        }
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/about.gif")));
        this.aboutButton.setPreferredSize(new Dimension(28, 28));
        this.aboutButton.setSize(new Dimension(28, 28));
        this.aboutButton.setMaximumSize(new Dimension(28, 28));
        this.aboutButton.setMinimumSize(new Dimension(28, 28));
        this.aboutButton.setToolTipText("About IBM HeapAnalyzer");
        return this.aboutButton;
    }

    private JButton getOpenButton() {
        if (this.openButton1 == null) {
            this.openButton1 = new JButton();
            this.openButton1.setToolTipText("Open");
            this.openButton1.setPreferredSize(new Dimension(28, 28));
            this.openButton1.setBounds(new Rectangle(16, 1, 28, 28));
            this.openButton1.setMaximumSize(new Dimension(28, 28));
            this.openButton1.setMinimumSize(new Dimension(28, 28));
            this.openButton1.setIcon(new ImageIcon(this.getClass().getResource("/open.gif")));
        }
        return this.openButton1;
    }

    public HeapTree addLeakSuspectView(HeapInfo heapInfo, HeapFrame heapFrame, JTable jTable, boolean bl) {
        if (!heapInfo.isHav() && (!bl || heapInfo.suspectList != null && heapInfo.suspectList.length != 0)) {
            JComponent jComponent;
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            HeapFrame heapFrame2 = new HeapFrame("Reference Tree", heapInfo, this);
            MouseListener[] mouseListenerArray = ((BasicInternalFrameUI)heapFrame2.getUI()).getNorthPane().getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                ((BasicInternalFrameUI)heapFrame2.getUI()).getNorthPane().removeMouseListener(mouseListenerArray[i]);
            }
            heapFrame2.setSize(700, 400);
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/tree.gif"));
            heapFrame2.setFrameIcon(imageIcon);
            JMenu jMenu = null;
            heapFrame2.menuBar = new JMenuBar();
            heapFrame2.leakMenu = new JMenu("Subpoena Leak Suspect(s)");
            heapFrame2.leakMenu.setMnemonic('L');
            heapFrame2.leakMenu.setIcon(new ImageIcon(this.getClass().getResource("/leak.gif")));
            JMenuItem jMenuItem = null;
            if (!heapInfo.isHav() && heapInfo.suspectList != null && heapInfo.suspectList.length != 0) {
                Object object4;
                int n;
                object3 = new Hashtable();
                object2 = new Hashtable();
                serializable = new Integer(0);
                boolean bl2 = false;
                for (n = 0; n < heapInfo.suspectList.length; ++n) {
                    object4 = (Long)((Hashtable)object3).get(heapInfo.suspectNameList[n]);
                    if (object4 == null) {
                        object4 = new Long(heapInfo.suspectTotalList[n]);
                        serializable = new Integer(1);
                    } else {
                        object4 = new Long((Long)object4 + heapInfo.suspectTotalList[n]);
                        serializable = (Integer)((Hashtable)object2).get(heapInfo.suspectNameList[n]);
                        serializable = new Integer((Integer)serializable + 1);
                        bl2 = true;
                    }
                    ((Hashtable)object3).put(heapInfo.suspectNameList[n], object4);
                    ((Hashtable)object2).put(heapInfo.suspectNameList[n], serializable);
                }
                if (bl2) {
                    jMenu = new JMenu("Suspects by Catetory");
                    ArrayList arrayList = new ArrayList(((Hashtable)object3).entrySet());
                    Collections.sort(arrayList, new LongValueComparator());
                    object4 = arrayList.iterator();
                    object = "";
                    long l = 0L;
                    while (object4.hasNext()) {
                        Object object5;
                        int n2;
                        JMenuItem jMenuItem2;
                        Map.Entry entry = (Map.Entry)object4.next();
                        object = (String)entry.getKey();
                        l = (Long)entry.getValue();
                        int n3 = (Integer)((Hashtable)object2).get(object);
                        if (n3 == 1) {
                            jMenuItem2 = new JMenuItem("  " + numberFormatter.format(l) + " (" + 100L * l / heapInfo.getHeapSize() + "%) " + (String)object);
                            jMenu.add(jMenuItem2);
                            jMenuItem2.addActionListener(heapFrame2);
                            continue;
                        }
                        jComponent = new JMenu("  " + numberFormatter.format(l) + " (" + 100L * l / heapInfo.getHeapSize() + "%) " + (String)object);
                        jMenu.add((JMenuItem)jComponent);
                        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                        Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
                        boolean bl3 = false;
                        String string = null;
                        for (n2 = 0; n2 < heapInfo.suspectList.length; ++n2) {
                            if (!heapInfo.suspectNameList[n2].equals(object)) continue;
                            string = heapInfo.getNonJavaAncestor(heapInfo.suspectList[n2] - heapInfo.getBaseAddress());
                            object5 = null;
                            if (string != null) {
                                object5 = (Long)hashtable.get(string);
                            }
                            if (object5 == null) {
                                object5 = new Long(heapInfo.suspectTotalList[n2]);
                                serializable = new Integer(1);
                            } else {
                                object5 = new Long((Long)object5 + heapInfo.suspectTotalList[n2]);
                                serializable = (Integer)hashtable2.get(string);
                                serializable = new Integer((Integer)serializable + 1);
                                bl3 = true;
                            }
                            if (string == null) continue;
                            hashtable.put(string, object5);
                            hashtable2.put(string, serializable);
                        }
                        if (bl3) {
                            ArrayList arrayList2 = new ArrayList(hashtable.entrySet());
                            Collections.sort(arrayList2, new LongValueComparator());
                            object5 = arrayList2.iterator();
                            while (object5.hasNext()) {
                                Map.Entry entry2 = object5.next();
                                String string2 = (String)entry2.getKey();
                                long l2 = (Long)entry2.getValue();
                                int n4 = (Integer)hashtable2.get(string2);
                                if (n4 == 1) {
                                    jMenuItem2 = new JMenuItem("  " + numberFormatter.format(l2) + " (" + 100L * l2 / heapInfo.getHeapSize() + "%) under " + string2);
                                    ((JMenu)jComponent).add(jMenuItem2);
                                    jMenuItem2.setForeground(Color.blue);
                                    jMenuItem2.addActionListener(heapFrame2);
                                    continue;
                                }
                                JMenu jMenu2 = new JMenu("  " + numberFormatter.format(l2) + " (" + 100L * l2 / heapInfo.getHeapSize() + "%) under " + string2);
                                ((JMenu)jComponent).add(jMenu2);
                                for (int i = 0; i < heapInfo.suspectList.length; ++i) {
                                    if (!heapInfo.suspectNameList[i].equals(object) || (string = heapInfo.getNonJavaAncestor(heapInfo.suspectList[i] - heapInfo.getBaseAddress())) == null || !string.equals(string2)) continue;
                                    jMenuItem2 = new JMenuItem("  " + numberFormatter.format(heapInfo.suspectTotalList[i]) + " (" + 100L * heapInfo.suspectTotalList[i] / heapInfo.getHeapSize() + "%) " + heapInfo.suspectNameList[i]);
                                    jMenuItem2.setForeground(Color.blue);
                                    jMenu2.add(jMenuItem2);
                                    jMenuItem2.addActionListener(heapFrame2);
                                }
                            }
                            continue;
                        }
                        for (n2 = 0; n2 < heapInfo.suspectList.length; ++n2) {
                            if (!heapInfo.suspectNameList[n2].equals(object)) continue;
                            jMenuItem2 = new JMenuItem("  " + numberFormatter.format(heapInfo.suspectTotalList[n2]) + " (" + 100L * heapInfo.suspectTotalList[n2] / heapInfo.getHeapSize() + "%) " + heapInfo.suspectNameList[n2]);
                            jMenuItem2.setForeground(Color.blue);
                            ((JMenu)jComponent).add(jMenuItem2);
                            jMenuItem2.addActionListener(heapFrame2);
                        }
                    }
                }
                for (n = 0; n < heapInfo.suspectList.length; ++n) {
                    jMenuItem = new JMenuItem("  " + numberFormatter.format(heapInfo.suspectTotalList[n]) + " (" + 100L * heapInfo.suspectTotalList[n] / heapInfo.getHeapSize() + "%) " + heapInfo.suspectNameList[n]);
                    jMenuItem.setForeground(Color.blue);
                    heapFrame2.leakMenu.add(jMenuItem);
                    jMenuItem.addActionListener(heapFrame2);
                    heapFrame2.leakBookMark.put("  " + numberFormatter.format(heapInfo.suspectTotalList[n]), new Long(heapInfo.suspectList[n] - heapInfo.getBaseAddress()));
                    int n5 = heapInfo.getIndexFromObject(heapInfo.suspectList[n] - heapInfo.getBaseAddress());
                }
            } else {
                heapFrame2.leakMenu.setEnabled(false);
            }
            heapFrame2.menu = new JMenu("Go to Bookmark");
            heapFrame2.menu.setMnemonic('G');
            heapFrame2.menu.setIcon(new ImageIcon(this.getClass().getResource("/bookmark.gif")));
            heapFrame2.removeMenu = new JMenu("Remove Bookmark");
            heapFrame2.removeMenu.setMnemonic('R');
            heapFrame2.removeMenu.setIcon(new ImageIcon(this.getClass().getResource("/remove_bookmark.gif")));
            if (heapInfo.bookMark.size() > 0) {
                object3 = heapInfo.bookMark.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (object2 == null) continue;
                    serializable = new JMenuItem((String)object2);
                    JMenuItem jMenuItem3 = new JMenuItem(" " + (String)object2);
                    ((AbstractButton)serializable).addActionListener(heapFrame2);
                    jMenuItem3.addActionListener(heapFrame2);
                    heapFrame2.menu.add((JMenuItem)serializable);
                    heapFrame2.removeMenu.add(jMenuItem3);
                }
            } else {
                heapFrame2.removeMenu.setEnabled(false);
                heapFrame2.menu.setEnabled(false);
            }
            heapFrame2.menuBar.add(heapFrame2.leakMenu);
            if (jMenu != null) {
                heapFrame2.menuBar.add(jMenu);
            }
            heapFrame2.setClosable(false);
            heapFrame2.setIconifiable(false);
            heapFrame2.setMaximizable(false);
            heapFrame2.setJMenuBar(heapFrame2.menuBar);
            heapFrame2.menuBar.add(heapFrame2.menu);
            heapFrame2.menuBar.add(heapFrame2.removeMenu);
            object3 = new HeapTree(heapInfo, this);
            ((HeapTree)object3).hf = heapFrame2;
            ((JTree)object3).addTreeSelectionListener(heapFrame2);
            this.dp = new DropProgressDialog(this);
            object2 = this.dp.getPreferredSize();
            serializable = this.getSize();
            Point point = this.getLocation();
            this.dp.setLocation((((Dimension)serializable).width - ((Dimension)object2).width) / 2 + point.x, (((Dimension)serializable).height - ((Dimension)object2).height) / 2 + point.y);
            heapFrame2.JScrollPaneSetViewportView((Component)object3);
            heapFrame2.ht = object3;
            if (!bl) {
                ((BasicInternalFrameUI)heapFrame2.getUI()).setNorthPane(null);
            }
            heapFrame2.setBorder(null);
            long l = -1L;
            if (bl && heapInfo.suspectList != null && heapInfo.suspectList.length != 0) {
                long l3 = heapInfo.suspectList[0] - heapInfo.getBaseAddress();
                l = heapInfo.isAddress64() ? (long)Arrays.binarySearch(heapInfo.getAddressLong(), l3) : (long)Arrays.binarySearch(heapInfo.getAddress(), (int)l3);
                heapFrame2.findAddressInTree(l, heapFrame2.ht);
            }
            object = this.addInfoView(heapInfo, heapFrame2, (int)l);
            heapFrame.main1 = heapFrame2;
            heapFrame.main2 = object;
            JSplitPane jSplitPane = new JSplitPane(1, heapFrame2, (Component)object);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(600);
            jSplitPane.setResizeWeight(1.0);
            if (jTable != null) {
                Serializable serializable2;
                if (heapInfo.rootWarning != null) {
                    serializable2 = (DefaultTableModel)jTable.getModel();
                    HeapInfo.addRow2TableModel("WARNING", heapInfo.rootWarning, serializable2);
                }
                serializable2 = new JScrollPane(jTable);
                jComponent = new JSplitPane(0, (Component)serializable2, jSplitPane);
                ((JSplitPane)jComponent).setOneTouchExpandable(true);
                ((JSplitPane)jComponent).setDividerLocation((jTable.getRowCount() + 3) * jTable.getRowHeight());
                heapFrame.getContentPane().add((Component)jComponent, "Center");
            } else {
                heapFrame.getContentPane().add((Component)jSplitPane, "Center");
            }
            return object3;
        }
        return null;
    }

    public HeapFrame addInfoView(HeapInfo heapInfo, HeapFrame heapFrame, int n) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        Object[] objectArray = new String[2];
        HeapFrame heapFrame2 = null;
        heapFrame2 = n != -1 ? (heapInfo.isAddress64() ? new HeapFrame(heapInfo.getName(n) + " at 0x" + Long.toHexString(heapInfo.getAddress(n)), heapInfo) : new HeapFrame(heapInfo.getName(n) + " at 0x" + Integer.toHexString((int)heapInfo.getAddress(n)), heapInfo)) : new HeapFrame("Heap dump roots", heapInfo);
        Object object = ((BasicInternalFrameUI)heapFrame2.getUI()).getNorthPane().getMouseListeners();
        for (int i = 0; i < ((MouseListener[])object).length; ++i) {
            ((BasicInternalFrameUI)heapFrame2.getUI()).getNorthPane().removeMouseListener(object[i]);
        }
        heapFrame2.setBorder(null);
        heapFrame2.setClosable(false);
        heapFrame2.setIconifiable(false);
        heapFrame2.setMaximizable(false);
        if (n == -1) {
            objectArray[0] = "Number of roots";
            objectArray[1] = numberFormatter.format(heapInfo.getRootChildrenLength());
            defaultTableModel.addRow(objectArray);
        } else {
            String string = new String();
            if (heapInfo == null) {
                return null;
            }
            if (heapInfo.isSuspect(n)) {
                objectArray[0] = "Leak suspect";
                objectArray[1] = "Responsible for " + numberFormatter.format(heapInfo.getTotal(n)) + " bytes (" + 100.0f * (float)heapInfo.getTotal(n) / (float)heapInfo.getHeapSize() + " %) of Java heap";
                defaultTableModel.addRow(objectArray);
            }
            objectArray[0] = "Address";
            objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(n)) : "0x" + Integer.toHexString((int)heapInfo.getAddress(n));
            defaultTableModel.addRow(objectArray);
            objectArray[0] = "Name";
            objectArray[1] = heapInfo.getName(n);
            defaultTableModel.addRow(objectArray);
            if (heapInfo.getChild()[n] == null) {
                objectArray[0] = "Number of children";
                objectArray[1] = "0 (This is a leaf node)";
                defaultTableModel.addRow(objectArray);
            } else {
                objectArray[0] = "Number of children";
                objectArray[1] = numberFormatter.format(heapInfo.getChild()[n].length);
                defaultTableModel.addRow(objectArray);
            }
            objectArray[0] = "Number of parents";
            objectArray[1] = heapInfo.getParentsList()[n] == null ? "0 (This is a root node)" : numberFormatter.format(heapInfo.getParentsList()[n].length);
            defaultTableModel.addRow(objectArray);
            if (heapInfo.getParent()[n] >= 0) {
                objectArray[0] = "Owner address";
                objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(heapInfo.getParent()[n])) : "0x" + Integer.toHexString((int)heapInfo.getAddress(heapInfo.getParent()[n]));
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "Owner object";
                objectArray[1] = heapInfo.getName(heapInfo.getParent()[n]);
                defaultTableModel.addRow(objectArray);
            }
            string = string + "Size : " + numberFormatter.format(heapInfo.getSize(n)) + "\n";
            string = string + "Total size : " + numberFormatter.format(heapInfo.getTotal(n)) + "\n";
            objectArray[0] = "Size";
            objectArray[1] = numberFormatter.format(heapInfo.getSize(n));
            defaultTableModel.addRow(objectArray);
            objectArray[0] = "Total size";
            objectArray[1] = numberFormatter.format(heapInfo.getTotal(n));
            defaultTableModel.addRow(objectArray);
            heapInfo.addStackTraceString2Model(n, defaultTableModel);
            heapInfo.addFieldList2Model(n, defaultTableModel);
        }
        object = new ImageIcon(this.getClass().getResource("/detail.gif"));
        heapFrame2.setFrameIcon((Icon)object);
        JTable jTable = new JTable();
        jTable.setCellSelectionEnabled(true);
        jTable.setDragEnabled(true);
        heapFrame2.hi = heapInfo;
        heapFrame.detailView = heapFrame2;
        heapFrame.detailView.jtable = jTable;
        jTable.setModel(defaultTableModel);
        heapFrame2.setSize(200, 400);
        heapFrame2.JScrollPaneSetViewportView(jTable);
        return heapFrame2;
    }

    public void updateTableModel(HeapInfo heapInfo, HeapFrame heapFrame, int n) {
        if (heapFrame == null) {
            return;
        }
        if (n == -2) {
            heapFrame.setTitle("Expend the node to list more children");
            heapFrame.jtable.setModel(new DefaultTableModel());
            return;
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        Object[] objectArray = new String[2];
        if (n != -1) {
            if (heapInfo.isAddress64()) {
                heapFrame.setTitle(heapInfo.getName(n) + " at 0x" + Long.toHexString(heapInfo.getAddress(n)));
            } else {
                heapFrame.setTitle(heapInfo.getName(n) + " at 0x" + Integer.toHexString((int)heapInfo.getAddress(n)));
            }
        } else {
            heapFrame.setTitle("Heap dump roots");
        }
        if (n == -1) {
            objectArray[0] = "Number of roots";
            objectArray[1] = numberFormatter.format(heapInfo.getRootChildrenLength());
            defaultTableModel.addRow(objectArray);
        } else {
            String string = new String();
            if (heapInfo == null) {
                return;
            }
            if (heapInfo.isSuspect(n)) {
                objectArray[0] = "Leak suspect";
                objectArray[1] = "Responsible for " + numberFormatter.format(heapInfo.getTotal(n)) + " bytes (" + 100.0f * (float)heapInfo.getTotal(n) / (float)heapInfo.getHeapSize() + " %) of Java heap";
                defaultTableModel.addRow(objectArray);
            }
            objectArray[0] = "Address";
            objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(n)) : "0x" + Integer.toHexString((int)heapInfo.getAddress(n));
            defaultTableModel.addRow(objectArray);
            objectArray[0] = "Name";
            objectArray[1] = heapInfo.getName(n);
            defaultTableModel.addRow(objectArray);
            if (heapInfo.getChild()[n] == null) {
                objectArray[0] = "Number of children";
                objectArray[1] = "0 (This is a leaf node)";
                defaultTableModel.addRow(objectArray);
            } else {
                objectArray[0] = "Number of children";
                objectArray[1] = numberFormatter.format(heapInfo.getChild()[n].length);
                defaultTableModel.addRow(objectArray);
            }
            objectArray[0] = "Number of parents";
            objectArray[1] = heapInfo.getParentsList()[n] == null ? "0 (This is a root node)" : numberFormatter.format(heapInfo.getParentsList()[n].length);
            defaultTableModel.addRow(objectArray);
            if (heapInfo.getParent()[n] >= 0) {
                objectArray[0] = "Owner address";
                objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(heapInfo.getParent()[n])) : "0x" + Integer.toHexString((int)heapInfo.getAddress(heapInfo.getParent()[n]));
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "Owner object";
                objectArray[1] = heapInfo.getName(heapInfo.getParent()[n]);
                defaultTableModel.addRow(objectArray);
            }
            string = string + "Size : " + numberFormatter.format(heapInfo.getSize(n)) + "\n";
            string = string + "Total size : " + numberFormatter.format(heapInfo.getTotal(n)) + "\n";
            objectArray[0] = "Size";
            objectArray[1] = numberFormatter.format(heapInfo.getSize(n));
            defaultTableModel.addRow(objectArray);
            objectArray[0] = "Total size";
            objectArray[1] = numberFormatter.format(heapInfo.getTotal(n));
            defaultTableModel.addRow(objectArray);
            heapInfo.addStackTraceString2Model(n, defaultTableModel);
            heapInfo.addFieldList2Model(n, defaultTableModel);
        }
        heapFrame.jtable.setModel(defaultTableModel);
    }

    private static class LongValueComparator
    implements Comparator {
        private LongValueComparator() {
        }

        public int compare(Object object, Object object2) {
            Map.Entry entry = (Map.Entry)object;
            Map.Entry entry2 = (Map.Entry)object2;
            Long l = (Long)entry.getValue();
            Long l2 = (Long)entry2.getValue();
            return l2.compareTo(l);
        }
    }

    class IvjEventHandler
    implements ActionListener,
    MouseListener,
    WindowListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HeapAnalyzer.this.getJCheckBoxMenuItem2() || actionEvent.getSource() == HeapAnalyzer.this.getStatusbarToggleButton()) {
                HeapAnalyzer.this.connEtoC2(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getAbout_BoxMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getAboutButton()) {
                HeapAnalyzer.this.connEtoC3(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getOpenMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getOpenButton()) {
                HeapAnalyzer.this.connEtoC4(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getFree_MenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getGapButton()) {
                HeapAnalyzer.this.connEtoC5(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getStats_MenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getChartButton()) {
                HeapAnalyzer.this.connEtoC7(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getOptionsJMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getOptionButton()) {
                HeapAnalyzer.this.connEtoC10(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getTreeView_MenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getTreeButton()) {
                HeapAnalyzer.this.connEtoC13(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getHelp_TopicsMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getHelpButton()) {
                HeapAnalyzer.this.connEtoC15(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getSaveMenuItem()) {
                HeapAnalyzer.this.connEtoC21(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getSaveViewerMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getSaveButton()) {
                HeapAnalyzer.this.saveViewer();
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getObjectsMenu() || actionEvent.getSource() == HeapAnalyzer.this.getObjectButton()) {
                HeapAnalyzer.this.connEtoC1(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getTypesMenu() || actionEvent.getSource() == HeapAnalyzer.this.getTypeButton()) {
                HeapAnalyzer.this.connEtoC11(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getConsoleCheckBoxMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getConsoleToggleButton()) {
                HeapAnalyzer.this.connEtoC12(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getSearchMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getNameButton()) {
                HeapAnalyzer.this.connEtoC14(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getClearConsoleMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getClearButton()) {
                HeapAnalyzer.this.connEtoM13(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getExitMenuItem()) {
                HeapAnalyzer.this.connEtoC6(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getAddressMenuItem() || actionEvent.getSource() == HeapAnalyzer.this.getAddressButton()) {
                HeapAnalyzer.this.connEtoC8(actionEvent);
            }
            if (actionEvent.getSource() == HeapAnalyzer.this.getRootMenu() || actionEvent.getSource() == HeapAnalyzer.this.getRootButton()) {
                HeapAnalyzer.this.connEtoC9(actionEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == HeapAnalyzer.this.getTreeView_MenuItem()) {
                HeapAnalyzer.this.connEtoM3(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getOpenMenuItem()) {
                HeapAnalyzer.this.connEtoM5(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getSaveMenuItem()) {
                HeapAnalyzer.this.connEtoM9(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getExitMenuItem()) {
                HeapAnalyzer.this.connEtoM11(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getFree_MenuItem()) {
                HeapAnalyzer.this.connEtoM25(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getStats_MenuItem()) {
                HeapAnalyzer.this.connEtoM27(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getSearchMenuItem()) {
                HeapAnalyzer.this.connEtoM29(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getOptionsJMenuItem()) {
                HeapAnalyzer.this.connEtoM37(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getJCheckBoxMenuItem2()) {
                HeapAnalyzer.this.connEtoM40(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getHelp_TopicsMenuItem()) {
                HeapAnalyzer.this.connEtoM43(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getAbout_BoxMenuItem()) {
                HeapAnalyzer.this.connEtoM45(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getConsoleCheckBoxMenuItem()) {
                HeapAnalyzer.this.connEtoM2(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getObjectsMenu()) {
                HeapAnalyzer.this.connEtoM8(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getTypesMenu()) {
                HeapAnalyzer.this.connEtoM35(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == HeapAnalyzer.this.getTreeView_MenuItem()) {
                HeapAnalyzer.this.connEtoM4(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getOpenMenuItem()) {
                HeapAnalyzer.this.connEtoM6(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getSaveMenuItem()) {
                HeapAnalyzer.this.connEtoM10(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getExitMenuItem()) {
                HeapAnalyzer.this.connEtoM12(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getFree_MenuItem()) {
                HeapAnalyzer.this.connEtoM26(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getStats_MenuItem()) {
                HeapAnalyzer.this.connEtoM28(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getSearchMenuItem()) {
                HeapAnalyzer.this.connEtoM31(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getOptionsJMenuItem()) {
                HeapAnalyzer.this.connEtoM38(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getJCheckBoxMenuItem2()) {
                HeapAnalyzer.this.connEtoM42(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getHelp_TopicsMenuItem()) {
                HeapAnalyzer.this.connEtoM44(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getAbout_BoxMenuItem()) {
                HeapAnalyzer.this.connEtoM46(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getConsoleCheckBoxMenuItem()) {
                HeapAnalyzer.this.connEtoM7(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getObjectsMenu()) {
                HeapAnalyzer.this.connEtoM36(mouseEvent);
            }
            if (mouseEvent.getSource() == HeapAnalyzer.this.getTypesMenu()) {
                HeapAnalyzer.this.connEtoM39(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getSource() == HeapAnalyzer.this) {
                HeapAnalyzer.this.connEtoC19(windowEvent);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

