/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Configuration;
import com.ibm.jinwoo.heap.FileTask;
import com.ibm.jinwoo.heap.Hav;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HprofTask;
import com.ibm.jinwoo.heap.HprofTxtTask;
import com.ibm.jinwoo.heap.OpenTask;
import com.ibm.jinwoo.heap.PHDTask;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.UTFDataFormatException;
import java.util.zip.GZIPInputStream;

public class HeapAnalyzerHeadless {
    String outputFileName;
    public Configuration cfg;

    public HeapAnalyzerHeadless() {
    }

    public HeapAnalyzerHeadless(String string) {
        this.outputFileName = string;
    }

    public void handleException(Throwable throwable) {
        throwable.printStackTrace(System.out);
    }

    public void readConfiguration(String string) {
        File file = new File(string);
        if (!file.exists()) {
            this.cfg = new Configuration();
        } else {
            try {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
                ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
                this.cfg = (Configuration)objectInputStream.readObject();
                objectInputStream.close();
                gZIPInputStream.close();
            }
            catch (Exception exception) {
                this.handleException(exception);
                this.cfg = new Configuration();
                System.out.println("Cannot understand configuration file :" + file.getAbsoluteFile());
            }
        }
    }

    public void heapAnalysis(String string, String string2) {
        HeapInfo heapInfo = this.getHeapAnalysis(string, string2);
        if (heapInfo == null) {
            System.out.println("Java heap dump process failed:" + string);
            return;
        }
        this.saveAnalysis(heapInfo, string2);
    }

    public void saveAnalysis(HeapInfo heapInfo, String string) {
        File file = new File(string);
        if (file == null) {
            System.out.println("Cannot create file : " + string);
            return;
        }
        if (file.exists()) {
            System.out.println("File already exists: " + string);
            return;
        }
        Hav hav = new Hav(heapInfo);
        if (heapInfo.getSortTask() != null) {
            if (heapInfo.isSortCompleted()) {
                hav.saveCompressed(file, null);
            } else {
                if (heapInfo.getSortTask().getCurrentThread() != null) {
                    try {
                        System.out.println("Joining");
                        heapInfo.getSortTask().getCurrentThread().join();
                        System.out.println("Joined");
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                hav.saveCompressed(file, null);
            }
        }
    }

    public HeapInfo getHeapAnalysis(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            System.out.println("File not found:" + file.getAbsoluteFile());
            return null;
        }
        if (file2 == null) {
            System.out.println("Cannot create file : " + string2);
            return null;
        }
        if (file2.exists()) {
            System.out.println("File already exists: " + string2);
            return null;
        }
        int n = this.getFileType(file);
        if (n < 0) {
            System.out.println("Cannot understand file :" + file.getAbsoluteFile());
            return null;
        }
        switch (n) {
            case 0: {
                FileTask fileTask = new FileTask(file);
                FileTask.ActualTask actualTask = fileTask.new FileTask.ActualTask();
                return fileTask.getHeapInfo();
            }
            case 1: {
                PHDTask pHDTask = new PHDTask(file);
                PHDTask.ActualTask actualTask = new PHDTask.ActualTask(pHDTask);
                return pHDTask.getHeapInfo();
            }
            case 2: {
                OpenTask openTask = new OpenTask(file);
                OpenTask.ActualTask actualTask = new OpenTask.ActualTask(openTask);
                return openTask.getHeapInfo();
            }
            case 3: {
                HprofTask hprofTask = new HprofTask(file);
                HprofTask.ActualTask actualTask = new HprofTask.ActualTask(hprofTask);
                return hprofTask.getHeapInfo();
            }
            case 4: {
                HprofTxtTask hprofTxtTask = new HprofTxtTask(file);
                HprofTxtTask.ActualTask actualTask = new HprofTxtTask.ActualTask(hprofTxtTask);
                return hprofTxtTask.getHeapInfo();
            }
            case 7: {
                System.out.println("File is already archived:" + file.getAbsoluteFile());
                return null;
            }
        }
        System.out.println("File type unknown:" + file.getAbsoluteFile());
        return null;
    }

    public int getFileType(File file) {
        block11: {
            Object object;
            Closeable closeable;
            try {
                closeable = new BufferedReader(new InputStreamReader(this.getInputStream(file)));
                object = ((BufferedReader)closeable).readLine();
                if (((String)object).startsWith("// Version:") || ((String)object).startsWith("0x")) {
                    ((BufferedReader)closeable).close();
                    return 0;
                }
                if (((String)object).startsWith("JAVA PROFILE") && ((String)object).length() < 80 && ((String)object).indexOf(", created") != -1) {
                    ((BufferedReader)closeable).close();
                    return 4;
                }
                if (((String)object).startsWith("IBM HeapAnalyzer")) {
                    ((BufferedReader)closeable).close();
                    return 7;
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
                return -1;
            }
            try {
                closeable = this.getInputStream(file);
                object = new DataInputStream((InputStream)closeable);
                String string = ((DataInputStream)object).readUTF();
                if (string.equals("portable heap dump")) {
                    ((FilterInputStream)object).close();
                    ((InputStream)closeable).close();
                    return 1;
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof UTFDataFormatException)) break block11;
                try {
                    String string;
                    object = this.getInputStream(file);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                    byte[] byArray = new byte[18];
                    if (dataInputStream.read(byArray) != -1 && (string = new String(byArray)).startsWith("JAVA PROFILE")) {
                        return 3;
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return 2;
            }
        }
        return -1;
    }

    public InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }
}

