/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.ExpandTask;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.MyRenderer;
import com.ibm.jinwoo.heap.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class HeapFrame
extends JInternalFrame
implements ActionListener,
InternalFrameListener,
TreeSelectionListener {
    private static int TOTAL = 0;
    private JPanel ivjJInternalFrameContentPane = null;
    private JScrollPane ivjJScrollPane1 = null;
    public Node root = null;
    public Vector v = null;
    public Vector freeNodes = null;
    public Vector typeNodes = null;
    public String fileName = null;
    public Vector objectV = null;
    public HeapInfo hi;
    public JMenuBar menuBar = null;
    public JMenu menu = null;
    public JMenu removeMenu = null;
    public JMenu leakMenu = null;
    public Hashtable leakBookMark = new Hashtable();
    public HeapTree ht = null;
    private long id = 0L;
    private Timer etimer;
    private ExpandTask etask;
    public HeapAnalyzer ha = null;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapFrame detailView = null;
    public JTable jtable = null;
    public HeapFrame main1 = null;
    public HeapFrame main2 = null;

    public HeapFrame() {
        this.initialize();
    }

    public HeapFrame(String string) {
        super(string, true, true, true, true);
        ++TOTAL;
        this.initialize();
    }

    public HeapFrame(String string, HeapInfo heapInfo) {
        super(string, true, true, true, true);
        ++TOTAL;
        this.hi = heapInfo;
        this.initialize();
    }

    public HeapFrame(String string, HeapInfo heapInfo, HeapAnalyzer heapAnalyzer) {
        super(string, true, true, true, true);
        ++TOTAL;
        this.hi = heapInfo;
        this.ha = heapAnalyzer;
        this.initialize();
    }

    public HeapFrame(String string, Node node, Vector vector, Vector vector2, Vector vector3) {
        super(string, true, true, true, true);
        this.initialize();
        this.root = node;
        this.v = vector;
        this.freeNodes = vector2;
        this.typeNodes = vector3;
    }

    public HeapFrame(String string, Node node, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        super(string, true, true, true, true);
        this.initialize();
        this.root = node;
        this.v = vector;
        this.freeNodes = vector2;
        this.typeNodes = vector3;
        this.objectV = vector4;
    }

    public HeapFrame(String string, boolean bl) {
        super(string, bl);
    }

    public HeapFrame(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public HeapFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl, bl2, bl3);
    }

    public HeapFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            JMenuItem jMenuItem;
            block7: {
                block6: {
                    if (!(actionEvent.getSource() instanceof JMenuItem)) {
                        return;
                    }
                    jMenuItem = (JMenuItem)actionEvent.getSource();
                    if (!jMenuItem.getText().startsWith("  ")) break block6;
                    Enumeration enumeration = this.leakBookMark.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (!jMenuItem.getText().startsWith(string)) continue;
                        int n = -1;
                        long l = (Long)this.leakBookMark.get(string);
                        n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)l);
                        if (n < 0) {
                            JOptionPane.showMessageDialog(this.ha, "Cannot find address : 0x" + Long.toHexString(l), "Address not found", 0);
                            return;
                        }
                        this.findAddressInTree(n, this.ht);
                        break block5;
                    }
                    break block5;
                }
                if (!jMenuItem.getText().startsWith(" ")) break block7;
                String string = jMenuItem.getText().substring(1);
                if (!this.hi.bookMark.containsKey(string)) break block5;
                this.removeMenu.removeActionListener(this);
                this.removeMenu.remove(jMenuItem);
                this.hi.bookMark.remove(string);
                for (int i = 0; i < this.menu.getItemCount(); ++i) {
                    if (this.menu.getItem(i).getText().compareTo(string) != 0) continue;
                    this.menu.getItem(i).removeActionListener(this);
                    this.menu.remove(this.menu.getItem(i));
                    break block5;
                }
                break block5;
            }
            Enumeration enumeration = this.hi.bookMark.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!jMenuItem.getText().startsWith(string)) continue;
                Node node = (Node)this.hi.bookMark.get(string);
                this.findAddressInTree(node.getIndex(), this.ht);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAddressInTree(long l, HeapTree heapTree) {
        if (l < 0L) {
            return;
        }
        if (this.hi.isHav()) {
            int n;
            boolean bl = false;
            RandomAccessFile randomAccessFile = this.hi.getHav().raf;
            Object object = randomAccessFile;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getHeapBaseLocation());
                    for (n = 0; n < this.hi.getHav().getNumberOfEntries(); ++n) {
                        l = this.hi.getHav().raf.getFilePointer() - this.hi.getHav().getHeapBaseLocation();
                        if (this.hi.getHav().read(randomAccessFile) == this.hi.getHav().getAddress(l)) {
                            bl = true;
                            this.hi.getHav().read(randomAccessFile);
                            this.hi.getHav().read(randomAccessFile);
                            this.hi.getHav().readName(randomAccessFile);
                            this.hi.getHav().raf.readInt();
                            break;
                        }
                        this.hi.getHav().read(randomAccessFile);
                        this.hi.getHav().read(randomAccessFile);
                        this.hi.getHav().readName(randomAccessFile);
                        this.hi.getHav().raf.readInt();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Cannot find address of index: " + l, "Address not found", 0);
                return;
            }
            if (this.returnTreeDepth(l) > HeapAnalyzer.MAX_VIEW_SIZE) {
                heapTree.moreParentsMenuItem.setEnabled(true);
                heapTree.showFromRootsMenuItem.setEnabled(true);
                object = new Vector();
                ((Vector)object).add(0, new Node(true, l));
                n = 0;
                while (this.hi.getHav().getParent(l) >= 0L && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                    ((Vector)object).add(0, new Node(true, this.hi.getHav().getParent(l)));
                    l = this.hi.getHav().getParent(l);
                    ++n;
                }
                Node node = new Node(true, this.hi.getHav().getParent(l), (int)HeapAnalyzer.MAX_SUBTREE);
                ((Vector)object).add(0, node);
                Object[] objectArray = ((Vector)object).toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray2);
                if (treePath == null) {
                    return;
                }
                Node node2 = ((HeapModel)heapTree.getModel()).rootPerson;
                ((HeapModel)heapTree.getModel()).rootPerson = node;
                ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node2);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
                this.ha.dp.hide();
            } else {
                heapTree.moreParentsMenuItem.setEnabled(false);
                heapTree.showFromRootsMenuItem.setEnabled(false);
                if (((HeapModel)heapTree.getModel()).rootPerson.getIndex() != -1) {
                    object = new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE);
                    Node node = ((HeapModel)heapTree.getModel()).rootPerson;
                    ((HeapModel)heapTree.getModel()).rootPerson = object;
                    ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node);
                }
                if ((object = this.returnTreePath(l)) == null) {
                    return;
                }
                heapTree.scrollPathToVisible((TreePath)object);
                heapTree.setSelectionPath((TreePath)object);
                this.ha.dp.hide();
            }
        } else {
            if (l < 0L) {
                JOptionPane.showMessageDialog(this, "Cannot find address of index : " + l, "Address not found", 0);
                return;
            }
            if (this.returnTreeDepth2(l) > HeapAnalyzer.MAX_VIEW_SIZE) {
                heapTree.moreParentsMenuItem.setEnabled(true);
                heapTree.showFromRootsMenuItem.setEnabled(true);
                Vector<Node> vector = new Vector<Node>();
                vector.add(0, new Node((int)l));
                int n = 0;
                while (this.hi.getParent()[(int)l] >= 0 && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                    vector.add(0, new Node(this.hi.getParent()[(int)l]));
                    l = this.hi.getParent()[(int)l];
                    ++n;
                }
                Node node = new Node(this.hi.getParent()[(int)l], (int)HeapAnalyzer.MAX_SUBTREE);
                vector.add(0, node);
                Object[] objectArray = vector.toArray();
                Object[] objectArray3 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray3[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray3);
                if (treePath == null) {
                    return;
                }
                Node node3 = ((HeapModel)heapTree.getModel()).rootPerson;
                ((HeapModel)heapTree.getModel()).setMustHaveTreePath(treePath);
                ((HeapModel)heapTree.getModel()).rootPerson = node;
                ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node3);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
            } else {
                heapTree.moreParentsMenuItem.setEnabled(false);
                heapTree.showFromRootsMenuItem.setEnabled(false);
                TreePath treePath = this.returnTreePath2(l);
                if (treePath == null) {
                    return;
                }
                ((HeapModel)heapTree.getModel()).setMustHaveTreePath(treePath);
                ((HeapModel)heapTree.getModel()).rootPerson = new Node(-1, ((HeapModel)heapTree.getModel()).getNumberOfMustHaveRootChildren());
                heapTree.setModel(new HeapModel(this.hi, treePath));
                heapTree.setCellRenderer(new MyRenderer(this.hi, (HeapModel)heapTree.getModel(), this.ha.cfg.percentage));
                treePath = this.returnTreePath2(l);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
            }
        }
    }

    private JPanel getJInternalFrameContentPane() {
        if (this.ivjJInternalFrameContentPane == null) {
            try {
                this.ivjJInternalFrameContentPane = new JPanel();
                this.ivjJInternalFrameContentPane.setName("JInternalFrameContentPane");
                this.ivjJInternalFrameContentPane.setLayout(new BorderLayout());
                this.getJInternalFrameContentPane().add((Component)this.getJScrollPane1(), "Center");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJInternalFrameContentPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane1;
    }

    private void handleException(Throwable throwable) {
        throwable.printStackTrace(System.out);
        JOptionPane.showMessageDialog(this, throwable.toString(), "Exception", 2);
    }

    private void initialize() {
        try {
            this.setName("HeapFrame");
            this.setDefaultCloseOperation(0);
            this.setClosable(true);
            this.setIconifiable(true);
            this.setVisible(true);
            this.setSelected(true);
            this.setSize(812, 381);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setContentPane(this.getJInternalFrameContentPane());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.addInternalFrameListener(this);
        this.setLocation(TOTAL % 10 * 30 + TOTAL / 10 * 30, TOTAL % 10 * 30 + 30 * (TOTAL / 10));
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        if (this.hi == null) {
            this.dispose();
            return;
        }
        if (this.hi.getFile() == null) {
            this.dispose();
            return;
        }
        if (this.getTitle().compareTo("Analysis of " + this.hi.getFile().getName()) == 0) {
            if (JOptionPane.showConfirmDialog(this, "Do you want to close " + this.hi.getFile().getName() + "?", "Close HeapDump", 0) == 1) {
                return;
            }
            if (this.hi.isHav()) {
                this.hi.setHav(null);
            }
            this.hi = null;
        }
        this.dispose();
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void JScrollPaneSetViewportView(Component component) {
        this.getJScrollPane1().setViewportView(component);
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            HeapFrame heapFrame = new HeapFrame();
            jFrame.setContentPane(heapFrame);
            jFrame.setSize(heapFrame.getSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.show();
            Insets insets = jFrame.getInsets();
            jFrame.setSize(jFrame.getWidth() + insets.left + insets.right, jFrame.getHeight() + insets.top + insets.bottom);
            jFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JInternalFrame");
            throwable.printStackTrace(System.out);
        }
    }

    public long returnTreeDepth(long l) {
        long l2;
        block3: {
            int n;
            block4: {
                l2 = 0L;
                n = 0;
                if (!this.hi.isHav()) break block4;
                long l3 = l;
                if (l3 == -1L) break block3;
                while ((l3 = this.hi.getHav().getParent(l3)) >= 0L) {
                    ++l2;
                    if (l3 >= 0L) continue;
                    break block3;
                }
                break block3;
            }
            n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)l);
            if (n < 0) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address : 0x" + Long.toHexString(l), "Address not found", 0);
                return -1L;
            }
            while (this.hi.getParent()[n] >= 0) {
                ++l2;
                n = this.hi.getParent()[n];
            }
        }
        return l2;
    }

    public long returnTreeDepth(Node node) {
        long l = 0L;
        if (node.isHav()) {
            long l2 = node.getLocation();
            long l3 = -1L;
            if (l2 < 0L) {
                return -1L;
            }
            while ((l3 = this.hi.getHav().getParent(l2)) >= 0L) {
                ++l;
                l2 = l3;
            }
        } else {
            int n = node.getIndex();
            if (n < 0) {
                return -1L;
            }
            while (this.hi.getParent()[n] >= 0) {
                ++l;
                n = this.hi.getParent()[n];
            }
        }
        return l;
    }

    public long returnTreeDepth2(long l) {
        long l2 = 0L;
        if (this.hi.isHav()) {
            if (l == -1L) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
                return -1L;
            }
            while (this.hi.getHav().getParent(l) >= 0L) {
                ++l2;
                l = this.hi.getHav().getParent(l);
            }
            return l2;
        }
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return -1L;
        }
        while (this.hi.getParent()[(int)l] >= 0) {
            ++l2;
            l = this.hi.getParent()[(int)l];
        }
        return l2;
    }

    public TreePath returnTreePath(long l) {
        Vector<Node> vector = new Vector<Node>();
        if (this.hi.isHav()) {
            long l2 = 0L;
            l2 = l;
            vector.add(0, new Node(true, l2));
            System.out.println("LOC=" + l2);
            while ((l2 = this.hi.getHav().getParent(l2)) >= 0L) {
                vector.add(0, new Node(true, l2));
                System.out.println("LOC=" + l2);
            }
        } else {
            int n = 0;
            n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)l);
            if (n < 0) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address : 0x" + Long.toHexString(l), "Address not found", 0);
                return null;
            }
            vector.add(0, new Node(n));
            while (this.hi.getParent()[n] >= 0) {
                vector.add(0, new Node(this.hi.getParent()[n]));
                n = this.hi.getParent()[n];
            }
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public TreePath returnTreePath(Node node) {
        Vector<Node> vector = new Vector<Node>();
        if (node.isHav()) {
            long l = node.getLocation();
            if (l < 0L) {
                return null;
            }
            vector.add(0, node);
            long l2 = -1L;
            while ((l2 = this.hi.getHav().getParent(l)) >= 0L) {
                vector.add(0, new Node(true, l2));
                l = l2;
            }
        } else {
            int n = node.getIndex();
            if (n < 0) {
                return null;
            }
            vector.add(0, node);
            while (this.hi.getParent()[n] >= 0) {
                vector.add(0, new Node(this.hi.getParent()[n]));
                n = this.hi.getParent()[n];
            }
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public TreePath returnTreePath2(long l) {
        if (this.hi.isHav()) {
            if (l == -1L) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
                return null;
            }
            Vector<Node> vector = new Vector<Node>();
            vector.add(0, new Node(true, l));
            while (this.hi.getHav().getParent(l) >= 0L) {
                vector.add(0, new Node(true, this.hi.getHav().getParent(l)));
                l = this.hi.getHav().getParent(l);
            }
            Object[] objectArray = this.ht.getPathForRow(0).getPath();
            vector.add(0, (Node)objectArray[0]);
            Object[] objectArray2 = vector.toArray();
            Object[] objectArray3 = new Node[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[i] = (Node)objectArray2[i];
            }
            return new TreePath(objectArray3);
        }
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        vector.add(0, new Node((int)l));
        while (this.hi.getParent()[(int)l] >= 0) {
            vector.add(0, new Node(this.hi.getParent()[(int)l]));
            l = this.hi.getParent()[(int)l];
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray4 = vector.toArray();
        Object[] objectArray5 = new Node[objectArray4.length];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray5[i] = (Node)objectArray4[i];
        }
        return new TreePath(objectArray5);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.ht == null) {
            return;
        }
        Node node = (Node)this.ht.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.ha.updateTableModel(this.hi, this.detailView, node.getIndex());
    }
}

