/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.FieldValues;
import com.ibm.jinwoo.heap.Hav;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HprofTask;
import com.ibm.jinwoo.heap.JinwooDataInput;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.PHDTask;
import com.ibm.jinwoo.heap.SortTask;
import com.ibm.jinwoo.heap.StackFrame;
import com.ibm.jinwoo.heap.StackTrace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JMenu;
import javax.swing.table.DefaultTableModel;

public class HeapInfo
implements Serializable {
    long[] classIndex = null;
    Hashtable classTable = null;
    JinwooDataInput dis = null;
    Hashtable stringsHashTable = null;
    long[] valueLocation = null;
    int[] nameHashKey = null;
    long[] nameHashKeyLong = null;
    int bookMarkID = 0;
    Hashtable bookMark = new Hashtable();
    public String rootWarning = null;
    static final int HPROFTXT = 4;
    Hashtable stackTrace;
    Hashtable stackFrame;
    int numberOfFinalizerObject = 0;
    int numberOfNoneGarbageFinalizerObject = 0;
    int numberOfFinalizableObject = 0;
    Hashtable listOfSuspects = new Hashtable();
    static final String[] REF = new String[]{"java.lang.ref.PhantomReference", "java.lang.ref.SoftReference", "java.lang.ref.WeakReference", "java/lang/ref/PhantomReference", "java/lang/ref/SoftReference", "java/lang/ref/WeakReference"};
    static final String[] FINALIZER = new String[]{"java.lang.ref.Finalizer", "java/lang/ref/Finalizer"};
    private boolean isSortCompleted;
    private SortTask sortTask;
    private boolean isLoadCompleted;
    private boolean isLoading;
    private boolean leakMenuReady = true;
    long[] suspectList = null;
    long[] suspectTotalList = null;
    String[] suspectNameList = null;
    JMenu leakMenu = null;
    Hashtable leakBookMark = new Hashtable();
    Thread backgroundThread = null;
    private int fileType = -1;
    private Hav hav = null;
    private String dumpInfo;
    private File file;
    private long baseAddress;
    private boolean address64 = false;
    private long[] addressLong;
    private int[] address;
    private String[] nameTable;
    private int[] nameKey;
    private int[] size;
    private long[] total;
    private int[][] child;
    private int[][] parentsList = null;
    private int[] stackTraceSerialNumber;
    private byte[] bits;
    private int[] parent;
    private long heapSize;
    private boolean[] isFinalizer;
    private boolean[] isReference;
    private boolean isJ9 = false;
    private int[] rootChildren;
    private byte[] reference;

    public long[] getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(long[] lArray) {
        this.classIndex = lArray;
    }

    public long getClassIndex(int n) {
        return this.classIndex[n];
    }

    public void setClassIndex(int n, long l) {
        this.classIndex[n] = l;
    }

    public Hashtable getClassTable() {
        return this.classTable;
    }

    public void setClassTable(Hashtable hashtable) {
        this.classTable = hashtable;
    }

    public long[] getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(long[] lArray) {
        this.valueLocation = lArray;
    }

    public long getValueLocation(int n) {
        return this.valueLocation[n];
    }

    public void setValueLocation(int n, long l) {
        this.valueLocation[n] = l;
    }

    public Hashtable getStringsHashTable() {
        return this.stringsHashTable;
    }

    public void setStringsHashTable(Hashtable hashtable) {
        this.stringsHashTable = hashtable;
    }

    public int[] getNameHashKey() {
        return this.nameHashKey;
    }

    public void setNameHashKey(int[] nArray) {
        this.nameHashKey = nArray;
    }

    public long[] getNameHashKeyLong() {
        return this.nameHashKeyLong;
    }

    public void setNameHashKeyLong(long[] lArray) {
        this.nameHashKeyLong = lArray;
    }

    public Hashtable getBookMark() {
        return this.bookMark;
    }

    public Node getBookMark(String string) {
        return (Node)this.getBookMark().get(string);
    }

    public void setBookMark(Hashtable hashtable) {
        this.bookMark = hashtable;
    }

    public synchronized void setBookMark(String string, Node node) {
        this.bookMark.put(string, node);
    }

    public Hashtable getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(Hashtable hashtable) {
        this.stackTrace = hashtable;
    }

    public Hashtable getStackFrame() {
        return this.stackFrame;
    }

    public void setStackFrame(Hashtable hashtable) {
        this.stackFrame = hashtable;
    }

    public int[] getStackTraceSerialNumber() {
        return this.stackTraceSerialNumber;
    }

    public void setStackTraceSerialNumber(int[] nArray) {
        this.stackTraceSerialNumber = nArray;
    }

    public int getStackTraceSerialNumber(int n) {
        return this.stackTraceSerialNumber[n];
    }

    public void setStackTraceSerialNumber(int n, int n2) {
        this.stackTraceSerialNumber[n] = n2;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public void setBits(byte[] byArray) {
        this.bits = byArray;
    }

    public boolean[] getIsFinalizer() {
        return this.isFinalizer;
    }

    public void setIsFinalizer(boolean[] blArray) {
        this.isFinalizer = blArray;
    }

    public boolean[] getIsReference() {
        return this.isReference;
    }

    public void setIsReference(boolean[] blArray) {
        this.isReference = blArray;
    }

    public boolean isJ9() {
        return this.isJ9;
    }

    public void setJ9(boolean bl) {
        this.isJ9 = bl;
    }

    public byte[] getReference() {
        return this.reference;
    }

    public void setReference(byte[] byArray) {
        this.reference = byArray;
    }

    public boolean isHav() {
        return this.getFileType() == 7;
    }

    public boolean hasNoneRef(int n) {
        if (this.visitedReference(n)) {
            return !this.hasReference(n);
        }
        for (int i = 0; i < this.getParentsList()[n].length; ++i) {
            if (this.getVisited(this.getParentsList()[n][i]) || this.isReference(this.getParentsList()[n][i])) continue;
            this.setVisitedReference(n);
            this.setHasNoReference(n);
            return true;
        }
        this.setVisitedReference(n);
        this.setHasReference(n);
        return false;
    }

    public boolean hasNoneFinalizer(int n) {
        if (this.visitedFinalizer(n)) {
            return !this.hasFinalizer(n);
        }
        for (int i = 0; i < this.getParentsList()[n].length; ++i) {
            if (this.getVisited(this.getParentsList()[n][i]) || this.isFinalizer(this.getParentsList()[n][i])) continue;
            this.setVisitedFinalizer(n);
            this.setHasNoFinalizer(n);
            return true;
        }
        this.setVisitedFinalizer(n);
        this.setHasFinalizer(n);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateTotal(int n) {
        boolean bl = false;
        Stack<Integer> stack = new Stack<Integer>();
        this.getTotal()[n] = this.getSize(n);
        this.setVisited(n);
        stack.push(new Integer(n));
        while (!stack.empty()) {
            int n2;
            int n3;
            int n4;
            int n5 = (Integer)stack.peek();
            bl = false;
            if (this.getChild()[n5] != null) {
                if (this.isReference(n5)) {
                    for (n4 = 0; n4 < this.getChild()[n5].length; ++n4) {
                        n3 = this.getChild()[n5][n4];
                        if (n3 < 0 || this.getVisited(n2 = n3) || this.hasNoneRef(n2)) continue;
                        this.getParent()[n2] = n5;
                        this.setVisited(n2);
                        this.getTotal()[n2] = this.getSize(n2);
                        stack.push(new Integer(n2));
                        bl = true;
                    }
                } else if (this.isFinalizer(n5)) {
                    for (n4 = 0; n4 < this.getChild()[n5].length; ++n4) {
                        n3 = this.getChild()[n5][n4];
                        if (n3 < 0 || this.getVisited(n2 = n3) || this.hasNoneFinalizer(n2)) continue;
                        this.getParent()[n2] = n5;
                        this.setVisited(n2);
                        if (!this.isFinalizer(n2)) {
                            ++this.numberOfFinalizableObject;
                        }
                        this.getTotal()[n2] = this.getSize(n2);
                        stack.push(new Integer(n2));
                        bl = true;
                    }
                } else {
                    for (n4 = 0; n4 < this.getChild()[n5].length; ++n4) {
                        n3 = this.getChild()[n5][n4];
                        if (n3 < 0 || this.getVisited(n2 = n3)) continue;
                        this.getParent()[n2] = n5;
                        this.setVisited(n2);
                        this.getTotal()[n2] = this.getSize(n2);
                        stack.push(new Integer(n2));
                        bl = true;
                    }
                }
            }
            if (bl) continue;
            n5 = (Integer)stack.pop();
            if (this.getChild()[n5] == null) continue;
            for (n4 = 0; n4 < this.getChild()[n5].length; ++n4) {
                n3 = this.getChild()[n5][n4];
                if (n3 < 0) continue;
                n2 = n3;
                if (this.getParent()[n2] != n5 || this.getCounted(n2)) continue;
                long[] lArray = this.getTotal();
                int n6 = n5;
                lArray[n6] = lArray[n6] + this.getTotal()[n2];
                this.setCounted(n2);
            }
            if (this.getTotal(n5) < HeapAnalyzer.MIN_TOTAL_LIMIT || !((float)this.getBiggestTotalRealChild(n5) / (float)this.getTotal(n5) <= HeapAnalyzer.RATIO)) continue;
            Hashtable hashtable = this.listOfSuspects;
            synchronized (hashtable) {
                this.listOfSuspects.put(new Long(this.getAddress(n5)), new Long(this.getTotal(n5)));
            }
        }
    }

    public int getNameKey(int n) {
        if (this.nameKey[n] == -1) {
            return -1;
        }
        if ((this.nameKey[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return this.nameKey[n] & Integer.MAX_VALUE;
        }
        return this.nameKey[n];
    }

    public int getParent(int n) {
        return this.getParent()[n];
    }

    public int getSize(int n) {
        if (this.isHav()) {
            return this.hav.getActualSize(n);
        }
        if ((this.size[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return this.size[n] & Integer.MAX_VALUE;
        }
        return this.size[n];
    }

    public boolean isArray(int n) {
        if (this.isHav()) {
            return this.getHav().getSize(n) < 0;
        }
        return this.size[n] < 0;
    }

    public boolean isClass(int n) {
        if (this.isHav()) {
            return this.getHav().getNameAddress(n) < 0L;
        }
        if (this.fileType == 3) {
            return this.getClassIndex(n) == -1L;
        }
        return this.nameKey[n] < 0;
    }

    public void setArray(int n) {
        this.setSize(n, this.getSize(n) | Integer.MIN_VALUE);
    }

    public void setClass(int n) {
        this.setNameKey(n, this.getNameKey(n) | Integer.MIN_VALUE);
    }

    public long getTotal(long l) {
        if (this.isHav()) {
            return this.hav.getTotal(l);
        }
        return this.getTotal()[(int)l];
    }

    void setNameKey(int[] nArray) {
        this.nameKey = nArray;
    }

    void setNameKey(int n, int n2) {
        this.nameKey[n] = (this.nameKey[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n2 | Integer.MIN_VALUE : n2;
    }

    public int[] getNameKey() {
        return this.nameKey;
    }

    void setSize(int[] nArray) {
        this.size = nArray;
    }

    void setSize(int n, int n2) {
        this.size[n] = (this.size[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE ? n2 | Integer.MIN_VALUE : n2;
    }

    public int[] getSize() {
        return this.size;
    }

    void setNameTable(String[] stringArray) {
        this.nameTable = stringArray;
    }

    int getNameTableLength() {
        if (this.isHav()) {
            return this.getHav().getNameTableLength();
        }
        return this.getNameTable().length;
    }

    String[] getNameTable() {
        return this.nameTable;
    }

    void setNameTable(int n, String string) {
        this.nameTable[n] = string;
    }

    String getNameTable(int n) {
        if (this.isHav()) {
            return this.getHav().getName(n);
        }
        if (n == -1) {
            return null;
        }
        return this.nameTable[n];
    }

    String getName(int n) {
        if (this.isHav()) {
            return this.hav.getNameHeap(n);
        }
        if (this.getStringsHashTable() != null) {
            if (this.getNameHashKeyLong() != null) {
                long l = this.nameHashKeyLong[n];
                String string = (String)this.getStringsHashTable().get(new Long(l));
                if (this.isClass(n)) {
                    return "class " + string;
                }
                if (this.isArray(n)) {
                    return "array of " + string;
                }
                return string;
            }
            int n2 = this.nameHashKey[n];
            String string = (String)this.getStringsHashTable().get(new Integer(n2));
            if (this.isClass(n)) {
                return "class " + string;
            }
            if (this.isArray(n)) {
                return "array of " + string;
            }
            return string;
        }
        int n3 = this.getNameKey(n);
        if (this.isClass(n)) {
            return "class " + this.getNameTable(n3);
        }
        if (this.isArray(n)) {
            return "array of " + this.getNameTable(n3);
        }
        return this.getNameTable(n3);
    }

    String getObjectName(int n) {
        if (this.isHav()) {
            return this.hav.getObjectNameHeap(n);
        }
        int n2 = this.getNameKey(n);
        return this.getNameTable(n2);
    }

    public void setAddress(int[] nArray) {
        this.address = nArray;
    }

    public void setAddressLong(long[] lArray) {
        this.addressLong = lArray;
    }

    void setAddress(int n, long l) {
        if (this.isAddress64()) {
            this.addressLong[n] = l - this.getBaseAddress();
        } else {
            this.address[n] = (int)(l - this.getBaseAddress());
        }
    }

    public long[] getAddressLong() {
        return this.addressLong;
    }

    public int[] getAddress() {
        return this.address;
    }

    int getAddressLength() {
        if (this.isHav()) {
            return this.hav.getNumberOfEntries();
        }
        if (this.isAddress64()) {
            return this.addressLong.length;
        }
        return this.address.length;
    }

    long getAddress(int n) {
        if (this.isHav()) {
            return this.hav.getAddress(n);
        }
        if (this.isAddress64()) {
            return this.addressLong[n] + this.getBaseAddress();
        }
        return (long)this.address[n] + this.getBaseAddress();
    }

    long getOffsetAddress(int n) {
        if (this.isHav()) {
            return this.hav.getAddress(n);
        }
        if (this.isAddress64()) {
            return this.addressLong[n];
        }
        return this.address[n];
    }

    public void setAddress64(boolean bl) {
        this.address64 = bl;
    }

    public boolean isAddress64() {
        return this.address64;
    }

    public void allocateAddress(int n) {
        if (this.isAddress64()) {
            this.addressLong = new long[n];
        } else {
            this.address = new int[n];
        }
    }

    public void setBaseAddress(long l) {
        this.baseAddress = l;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public void setRootChildren(int[] nArray) {
        this.rootChildren = nArray;
    }

    private int[] getRootChildren() {
        return this.rootChildren;
    }

    public int getRootChildren(int n) {
        if (this.isHav()) {
            return (int)this.getRootChildrenPointer(n);
        }
        return this.rootChildren[n];
    }

    public long getRootChildrenPointer(int n) {
        return this.getHav().getRootChildren(n);
    }

    public void setRootChildren(int n, int n2) {
        this.rootChildren[n] = n2;
    }

    public int getRootChildrenLength() {
        if (this.getFileType() == 7) {
            return this.getHav().getRootChildrenLength();
        }
        return this.rootChildren.length;
    }

    public void sortRootChildren() {
        int n;
        long[][] lArray = new long[2][this.getRootChildrenLength()];
        for (n = 0; n < this.getRootChildrenLength(); ++n) {
            lArray[0][n] = this.getTotal()[this.getRootChildren(n)];
            lArray[1][n] = this.getRootChildren(n);
        }
        Arrays2.sort(lArray);
        n = 0;
        int n2 = this.getRootChildrenLength() - 1;
        while (n < this.getRootChildrenLength()) {
            this.setRootChildren(n, (int)lArray[1][n2]);
            ++n;
            --n2;
        }
    }

    void setTotal(long[] lArray) {
        this.total = lArray;
    }

    private long[] getTotal() {
        return this.total;
    }

    public int getTotalLength() {
        if (this.isHav()) {
            return this.hav.getNumberOfEntries();
        }
        return this.total.length;
    }

    void setChild(int[][] nArray) {
        this.child = nArray;
    }

    int[][] getChild() {
        return this.child;
    }

    int getChildLength(int n) {
        if (this.isHav()) {
            return this.hav.getNChild(n);
        }
        if (this.child[n] == null) {
            return 0;
        }
        return this.child[n].length;
    }

    void clearBits() {
    }

    void setSuspect(int n) {
        this.bits[n] = (byte)(this.bits[n] | 8);
    }

    boolean isSuspect(int n) {
        return (this.bits[n] & 8) == 8;
    }

    void setVisited(int n) {
        this.bits[n] = (byte)(this.bits[n] | 0x80);
    }

    boolean getVisited(int n) {
        return (this.bits[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    void setSorted(int n) {
        this.bits[n] = (byte)(this.bits[n] | 0x40);
    }

    boolean isSorted(int n) {
        return (this.bits[n] & 0x40) == 64;
    }

    void setHasParentORG(int n) {
        this.bits[n] = (byte)(this.bits[n] | 0x20);
    }

    boolean getHasParent(int n) {
        if (this.parentsList[n] == null) {
            return false;
        }
        return this.parentsList[n].length != 0;
    }

    void setCounted(int n) {
        this.bits[n] = (byte)(this.bits[n] | 0x10);
    }

    boolean getCounted(int n) {
        return (this.bits[n] & 0x10) == 16;
    }

    void setParent(int[] nArray) {
        this.parent = nArray;
    }

    int[] getParent() {
        return this.parent;
    }

    void setFile(File file) {
        this.file = file;
    }

    File getFile() {
        return this.file;
    }

    void setDumpInfo(String string) {
        this.dumpInfo = string;
    }

    String getDumpInfo() {
        return this.dumpInfo;
    }

    void setFileType(int n) {
        this.fileType = n;
    }

    int getFileType() {
        return this.fileType;
    }

    void setHav(Hav hav) {
        this.hav = hav;
    }

    Hav getHav() {
        return this.hav;
    }

    public void setHeapSize(long l) {
        this.heapSize = l;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public long getBiggestTotalRealChild(int n) {
        long l = 0L;
        if (n == -1) {
            return this.getTotal(this.getRootChildren(0));
        }
        if (this.getChild()[n] == null) {
            return 0L;
        }
        int n2 = this.getChildLength(n);
        if (n2 == -1) {
            return 0L;
        }
        for (int i = 0; i < n2; ++i) {
            long l2 = this.getChild()[n][i];
            if (n != this.getParent()[(int)l2] || this.getTotal(l2) <= l) continue;
            l = this.getTotal(l2);
        }
        return l;
    }

    public int getBiggestRealChild(int n) {
        long l = 0L;
        int n2 = -1;
        if (n == -1) {
            return -1;
        }
        if (this.getChild()[n] == null) {
            return -1;
        }
        int n3 = this.getChildLength(n);
        if (n3 == -1) {
            return -1;
        }
        for (int i = 0; i < n3; ++i) {
            long l2 = this.getChild()[n][i];
            if (n != this.getParent()[(int)l2] || this.getTotal(l2) <= l) continue;
            l = this.getTotal(l2);
            n2 = (int)l2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortChildren(int n) {
        int[] nArray = this.getChild()[n];
        synchronized (nArray) {
            int n2;
            int n3;
            int n4;
            if (this.isSorted(n)) {
                return;
            }
            int n5 = 0;
            for (n4 = 0; n4 < this.getChild()[n].length; ++n4) {
                n3 = this.getChild()[n][n4];
                if (n != this.getParent()[n3]) continue;
                ++n5;
            }
            long[][] lArray = new long[2][n5];
            long[][] lArray2 = new long[2][this.getChild()[n].length - n5];
            n4 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < this.getChild()[n].length; ++n2) {
                n3 = this.getChild()[n][n2];
                if (n == this.getParent()[n3]) {
                    lArray[0][n4] = this.getTotal(this.getChild()[n][n2]);
                    lArray[1][n4++] = this.getChild()[n][n2];
                    continue;
                }
                lArray2[0][n6] = this.getTotal(this.getChild()[n][n2]);
                lArray2[1][n6++] = this.getChild()[n][n2];
            }
            Arrays2.sort(lArray);
            Arrays2.sort(lArray2);
            n2 = 0;
            int n7 = n5 - 1;
            while (n2 < n5) {
                this.getChild()[n][n2] = (int)lArray[1][n7];
                ++n2;
                --n7;
            }
            n2 = n5;
            n7 = this.getChild()[n].length - n5 - 1;
            while (n2 < this.getChild()[n].length) {
                this.getChild()[n][n2] = (int)lArray2[1][n7];
                ++n2;
                --n7;
            }
            this.setSorted(n);
        }
    }

    public synchronized void setLeakMenuReady(boolean bl) {
        this.leakMenuReady = bl;
    }

    public boolean isLeakMenuReady() {
        return this.leakMenuReady;
    }

    public synchronized void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public synchronized void setLoading() {
        this.isLoading = true;
    }

    public synchronized boolean isLoading() {
        return this.isLoading;
    }

    public synchronized void setLoadCompleted(boolean bl) {
        this.isLoadCompleted = bl;
    }

    public synchronized void setLoadCompleted() {
        this.isLoadCompleted = true;
    }

    public synchronized boolean isLoadCompleted() {
        return this.isLoadCompleted;
    }

    public boolean isLongAddress() {
        return this.addressLong != null;
    }

    public void setSortTask(SortTask sortTask) {
        this.sortTask = sortTask;
    }

    public SortTask getSortTask() {
        return this.sortTask;
    }

    public void setSortCompleted(boolean bl) {
        this.isSortCompleted = bl;
    }

    public void setSortCompleted() {
        this.isSortCompleted = true;
    }

    public boolean isSortCompleted() {
        return this.isSortCompleted;
    }

    public int[][] getParentsList() {
        return this.parentsList;
    }

    public void setParentsList(int[][] nArray) {
        this.parentsList = nArray;
    }

    public void reorg() {
        int n;
        int n2;
        int[] nArray = new int[this.getAddressLength()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (this.getChild()[n2] == null) continue;
            for (n = 0; n < this.getChild()[n2].length; ++n) {
                int n3 = this.getChild()[n2][n];
                nArray[n3] = nArray[n3] + 1;
            }
        }
        this.setParentsList(new int[this.getAddressLength()][]);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == 0) continue;
            this.getParentsList()[n2] = new int[nArray[n2]];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < this.getAddressLength(); ++n2) {
            if (this.getChild()[n2] == null) continue;
            for (n = 0; n < this.getChild()[n2].length; ++n) {
                int n4 = this.getChild()[n2][n];
                int n5 = nArray[n4];
                nArray[n4] = n5 + 1;
                this.getParentsList()[this.getChild()[n2][n]][n5] = n2;
            }
        }
        nArray = null;
    }

    public void reorg2() {
        int n;
        int n2;
        Object[] objectArray = new Object[this.getAddressLength()];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (this.getChild()[n2] == null) continue;
            for (n = 0; n < this.getChild()[n2].length; ++n) {
                if (objectArray[this.getChild()[n2][n]] == null) {
                    objectArray[this.getChild()[n2][n]] = new ArrayList();
                }
                ((ArrayList)objectArray[this.getChild()[n2][n]]).add(new Integer(n2));
            }
        }
        this.setParentsList(new int[this.getAddressLength()][]);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] == null) continue;
            this.getParentsList()[n2] = new int[((ArrayList)objectArray[n2]).size()];
            for (n = 0; n < this.getParentsList()[n2].length; ++n) {
                this.getParentsList()[n2][n] = (Integer)((ArrayList)objectArray[n2]).get(n);
            }
            objectArray[n2] = null;
        }
        objectArray = null;
    }

    public String darkMatterAnalysis() {
        long l = 0L;
        long l2 = 0L;
        long l3 = this.getAddress(0) + (long)this.getSize(0);
        for (int i = 1; i < this.getAddressLength(); ++i) {
            l2 = this.getAddress(i) - l3;
            if (l2 > 0L && l2 <= (long)(512 + this.getHeaderSize())) {
                l += l2;
            }
            l3 = this.getAddress(i) + (long)this.getSize(i);
        }
        if (l > 0L && this.getHeapSize() != 0L) {
            if ((double)((float)l / (float)this.getHeapSize()) > 0.1) {
                return "\nWARNING!! Java garbage collection trace may report " + PHDTask.numberFormatter.format(l + this.getHeapSize()) + " bytes are used by Java heap.\nBut there are " + PHDTask.numberFormatter.format(l) + " bytes (" + (float)l * 100.0f / (float)this.getHeapSize() + " %) of dark matters in the Java heap.\nActual Java heap usage is " + PHDTask.numberFormatter.format(this.getHeapSize()) + " bytes\n";
            }
            return "" + PHDTask.numberFormatter.format(l) + " bytes (" + (float)l * 100.0f / (float)this.getHeapSize() + " %)";
        }
        return "0 byte";
    }

    public void darkMatterAnalysis(DefaultTableModel defaultTableModel) {
        long l = 0L;
        long l2 = 0L;
        long l3 = this.getAddress(0) + (long)this.getSize(0);
        for (int i = 1; i < this.getAddressLength(); ++i) {
            l2 = this.getAddress(i) - l3;
            if (l2 > 0L && l2 <= (long)(512 + this.getHeaderSize())) {
                l += l2;
            }
            l3 = this.getAddress(i) + (long)this.getSize(i);
        }
        if (l > 0L && this.getHeapSize() != 0L) {
            if ((double)((float)l / (float)this.getHeapSize()) > 0.1) {
                Object[] objectArray = new String[]{"Dark Matter", PHDTask.numberFormatter.format(l) + " bytes (" + (float)l * 100.0f / (float)this.getHeapSize() + " %)"};
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "WARNING!!";
                objectArray[1] = "Java garbage collection trace may report " + PHDTask.numberFormatter.format(l + this.getHeapSize()) + " bytes are used by Java heap";
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "";
                objectArray[1] = "Actual Java heap usage is " + PHDTask.numberFormatter.format(this.getHeapSize()) + " bytes due to excessive dark matters";
                defaultTableModel.addRow(objectArray);
            } else {
                Object[] objectArray = new String[]{"Dark Matter", PHDTask.numberFormatter.format(l) + " bytes (" + (float)l * 100.0f / (float)this.getHeapSize() + " %)"};
                defaultTableModel.addRow(objectArray);
            }
        } else {
            Object[] objectArray = new String[]{"Dark Matter", "0 byte"};
            defaultTableModel.addRow(objectArray);
        }
    }

    public int getHeaderSize() {
        if (this.isAddress64()) {
            return 24;
        }
        return 12;
    }

    public int getNumberOfFinalizerObject() {
        return this.numberOfFinalizerObject;
    }

    public void setNumberOfFinalizerObject(int n) {
        this.numberOfFinalizerObject = n;
    }

    public int getNumberOfNoneGarbageFinalizerObject() {
        return this.numberOfNoneGarbageFinalizerObject;
    }

    public void setNumberOfNoneGarbageFinalizerObject(int n) {
        this.numberOfNoneGarbageFinalizerObject = n;
    }

    public int getNumberOfFinalizableObject() {
        return this.numberOfFinalizableObject;
    }

    public void setNumberOfFinalizableObject(int n) {
        this.numberOfFinalizableObject = n;
    }

    public void markReferences() {
        int n;
        this.setReference(new byte[this.getAddressLength()]);
        this.setIsFinalizer(new boolean[this.getNameTable().length]);
        this.setIsReference(new boolean[this.getNameTable().length]);
        int n2 = -1;
        for (n = 0; n < REF.length; ++n) {
            n2 = Arrays.binarySearch(this.getNameTable(), REF[n]);
            if (n2 < 0) continue;
            this.isReference[n2] = true;
        }
        for (n = 0; n < FINALIZER.length; ++n) {
            n2 = Arrays.binarySearch(this.getNameTable(), FINALIZER[n]);
            if (n2 < 0) continue;
            this.isFinalizer[n2] = true;
        }
    }

    public boolean isFinalizer(int n) {
        if (n == -1) {
            return false;
        }
        if (this.size[n] < 0) {
            return false;
        }
        if (this.nameKey[n] == -1) {
            return false;
        }
        if ((this.nameKey[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return false;
        }
        return this.isFinalizer[this.nameKey[n]];
    }

    public boolean isReference(int n) {
        if (n == -1) {
            return false;
        }
        if (this.size[n] < 0) {
            return false;
        }
        if (this.nameKey[n] == -1) {
            return false;
        }
        if ((this.nameKey[n] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return false;
        }
        return this.isReference[this.nameKey[n]];
    }

    public boolean visitedFinalizer(int n) {
        return (this.reference[n] & 0x40) == 64;
    }

    public void setVisitedFinalizer(int n) {
        this.reference[n] = (byte)(this.reference[n] | 0x40);
    }

    public boolean hasFinalizer(int n) {
        return (this.reference[n] & 0x20) == 32;
    }

    public void setHasFinalizer(int n) {
        this.reference[n] = (byte)(this.reference[n] | 0x20);
    }

    public boolean hasNoFinalizer(int n) {
        return (this.reference[n] & 0x10) == 16;
    }

    public void setHasNoFinalizer(int n) {
        this.reference[n] = (byte)(this.reference[n] | 0x10);
    }

    public boolean visitedReference(int n) {
        return (this.reference[n] & 4) == 4;
    }

    public void setVisitedReference(int n) {
        this.reference[n] = (byte)(this.reference[n] | 4);
    }

    public boolean hasReference(int n) {
        return (this.reference[n] & 2) == 2;
    }

    public void setHasReference(int n) {
        this.reference[n] = (byte)(this.reference[n] | 2);
    }

    public boolean hasNoReference(int n) {
        return (this.reference[n] & 1) == 1;
    }

    public void setHasNoReference(int n) {
        this.reference[n] = (byte)(this.reference[n] | 1);
    }

    public String printType(int n, byte[] byArray) {
        switch (n) {
            case 2: {
                if (byArray == null) {
                    return "reference";
                }
                int n2 = 0;
                n2 = this.isAddress64() ? (int)HeapInfo.toLong(byArray) : HeapInfo.toInt(byArray);
                if (n2 >= 0) {
                    long l = this.getAddress(n2);
                    return this.getName(n2);
                }
                return "reference";
            }
            case 4: {
                return "boolean";
            }
            case 8: {
                return "byte";
            }
            case 5: {
                return "char";
            }
            case 9: {
                return "short";
            }
            case 6: {
                return "float";
            }
            case 10: {
                return "int";
            }
            case 7: {
                return "double";
            }
            case 11: {
                return "long";
            }
        }
        System.out.println("Unknown type=" + Integer.toHexString(n));
        return "variable";
    }

    public String printContent(int n, byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        switch (n) {
            case 2: {
                int n2 = 0;
                n2 = this.isAddress64() ? (int)HeapInfo.toLong(byArray) : HeapInfo.toInt(byArray);
                if (n2 >= 0) {
                    long l = this.getAddress(n2);
                    if (this.isAddress64()) {
                        return "0x" + Long.toHexString(l);
                    }
                    return "0x" + Integer.toHexString((int)l);
                }
                return "NULL";
            }
            case 4: {
                if (byArray[0] == 1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 8: {
                return byArray[0] + "";
            }
            case 5: {
                return "'" + (char)HeapInfo.toShort(byArray) + "'";
            }
            case 9: {
                return HeapInfo.toShort(byArray) + "";
            }
            case 6: {
                return HeapInfo.toFloat(byArray) + "";
            }
            case 10: {
                return HeapInfo.toInt(byArray) + "";
            }
            case 7: {
                return HeapInfo.toDouble(byArray) + "";
            }
            case 11: {
                return HeapInfo.toLong(byArray) + "";
            }
        }
        System.out.println("Unknown type=" + Integer.toHexString(n));
        return "";
    }

    public static short toShort(byte[] byArray) {
        short s = 0;
        int n = byArray.length - 1;
        for (int i = 0; i < 16; i += 8) {
            s = (short)(s | (short)(byArray[n] & 0xFF) << i);
            --n;
        }
        return s;
    }

    public static int toInt(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length - 1;
        for (int i = 0; i < 32; i += 8) {
            n |= (byArray[n2] & 0xFF) << i;
            --n2;
        }
        return n;
    }

    public static long toLong(byte[] byArray) {
        long l = 0L;
        if (byArray.length == 0) {
            return 0L;
        }
        int n = byArray.length - 1;
        for (int i = 0; i < 64 && n >= 0; --n, i += 8) {
            l |= (long)(byArray[n] & 0xFF) << i;
        }
        return l;
    }

    public static double toDouble(byte[] byArray) {
        long l = 0L;
        int n = byArray.length - 1;
        for (int i = 0; i < 64; i += 8) {
            l |= (long)(byArray[n] & 0xFF) << i;
            --n;
        }
        return Double.longBitsToDouble(l);
    }

    public static float toFloat(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length - 1;
        for (int i = 0; i < 32; i += 8) {
            n = (int)((long)n | (long)(byArray[n2] & 0xFF) << i);
            --n2;
        }
        return Float.intBitsToFloat(n);
    }

    public String getFieldList(int n) {
        return null;
    }

    public int getIndexFromObject(long l) {
        int n = 0;
        n = this.getAddressLong() != null ? Arrays.binarySearch(this.getAddressLong(), l) : Arrays.binarySearch(this.getAddress(), (int)(l & 0xFFFFFFFFL));
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public long readID() throws IOException {
        if (this.isAddress64()) {
            return this.dis.bufferedReadLong();
        }
        return this.dis.bufferedReadInt();
    }

    public int sizeOfType(int n) {
        switch (n) {
            case 2: {
                if (this.isAddress64()) {
                    return 8;
                }
                return 4;
            }
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        System.out.println("(sizeOfType) Unknown type=" + Integer.toHexString(n));
        return 0;
    }

    public int getRefs(long l) {
        int n = 0;
        HprofTask.ClassTable classTable = this.getClass(l);
        while (classTable != null) {
            if (classTable.instanceFields != null) {
                for (int i = 0; i < classTable.instanceFields.length; ++i) {
                    if (classTable.instanceFields[i] != 2) continue;
                    ++n;
                }
            }
            if (classTable.superClassID == 0L) break;
            classTable = this.getClass(classTable.superClassID);
        }
        return n;
    }

    public HprofTask.ClassTable getClass(long l) {
        HprofTask.ClassTable classTable = (HprofTask.ClassTable)this.getClassTable().get(new Long(l));
        if (classTable == null) {
            return null;
        }
        return classTable;
    }

    public int getInstances(long l) {
        int n = 0;
        HprofTask.ClassTable classTable = this.getClass(l);
        while (classTable != null) {
            if (classTable.instanceFields != null) {
                n += classTable.instanceFields.length;
            }
            if (classTable.superClassID == 0L) break;
            classTable = this.getClass(classTable.superClassID);
        }
        return n;
    }

    public long getValues(int n, byte[] byArray, int n2) {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
            }
            case 4: {
                return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            }
            case 8: {
                return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
            }
        }
        System.out.println("(getValues) Unknown size=" + Integer.toHexString(n2));
        return 0L;
    }

    public void addFieldList2Model(int n, DefaultTableModel defaultTableModel) {
        int n2;
        int n3;
        int n4;
        if (this.getValueLocation() == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        long l = this.getValueLocation(n);
        if (l == 0L) {
            return;
        }
        try {
            this.dis.seek(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        HprofTask.ClassTable classTable = null;
        FieldValues fieldValues = null;
        long l2 = this.getClassIndex(n);
        if (l2 == 0L) {
            int n5;
            int n6 = 0;
            byte by = 0;
            byte[] byArray = null;
            int n7 = 0;
            try {
                n6 = this.dis.bufferedReadInt();
                if (n6 <= 0) {
                    return;
                }
                by = this.dis.bufferedReadByte();
                n7 = this.sizeOfType(by);
                n5 = n7 * n6;
                byArray = new byte[n5];
                this.dis.bufferedReadFully(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            n5 = 0;
            Object[] objectArray = new String[2];
            String string = this.printType(by, null);
            byte[] byArray2 = new byte[n7];
            for (int i = 0; i < n6; ++i) {
                String string2;
                objectArray[0] = string + "[" + i + "]";
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray2[j] = byArray[n5++];
                }
                objectArray[1] = string2 = this.printContent(by, byArray2);
                defaultTableModel.addRow(objectArray);
            }
            return;
        }
        if (l2 == -1L) {
            classTable = (HprofTask.ClassTable)this.getClassTable().get(new Long(this.getAddress(n)));
            if (classTable == null) {
                return;
            }
            long l3 = -1L;
            n4 = 4;
            if (this.isAddress64()) {
                n4 = 8;
            }
            n3 = 0;
            long l4 = 0L;
            n2 = 0;
            try {
                n2 = this.dis.bufferedReadUnsignedShort();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (n2 > 0) {
                fieldValues = new FieldValues();
                fieldValues.setStringID(new long[n2]);
                fieldValues.setType(new byte[n2]);
                fieldValues.setValue(new byte[n2][]);
            }
            for (int i = 0; i < n2; ++i) {
                byte[] byArray;
                try {
                    l3 = this.readID();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    n3 = this.dis.bufferedReadByte();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                fieldValues.setType(i, (byte)n3);
                fieldValues.setStringID(i, l3);
                if (n3 == 2) {
                    try {
                        l4 = this.readID();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    l4 = this.getIndexFromObject(l4);
                    byArray = new byte[]{(byte)((int)l4 >> 24), (byte)((int)l4 >> 16), (byte)((int)l4 >> 8), (byte)((int)l4 & 0xFF)};
                    fieldValues.setValue(i, byArray);
                    continue;
                }
                byArray = new byte[this.sizeOfType(n3)];
                try {
                    this.dis.bufferedRead(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                fieldValues.setValue(i, byArray);
            }
        } else {
            classTable = (HprofTask.ClassTable)this.getClassTable().get(new Long(l2));
            if (classTable == null) {
                return;
            }
            int n8 = 0;
            try {
                n8 = this.dis.bufferedReadInt();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byte[] byArray = null;
            if (n8 != 0) {
                byArray = new byte[n8];
                try {
                    this.dis.bufferedReadFully(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            n4 = 0;
            n3 = this.getInstances(l2);
            if (n3 > 0) {
                int n9 = this.getRefs(l2);
                fieldValues = new FieldValues();
                fieldValues.setStringID(new long[n3]);
                fieldValues.setType(new byte[n3]);
                fieldValues.setValue(new byte[n3][]);
                int n10 = 0;
                n2 = 0;
                HprofTask.ClassTable classTable2 = classTable;
                while (classTable2 != null) {
                    if (classTable2.instanceFields != null && classTable2.instanceFields.length > 0) {
                        for (int i = 0; i < classTable2.instanceFields.length; ++i) {
                            int n11;
                            fieldValues.setStringID(n10, classTable2.fieldNameID[i]);
                            fieldValues.setType(n10, classTable2.instanceFields[i]);
                            if (classTable2.instanceFields[i] == 2) {
                                n11 = 0;
                                n11 = this.isAddress64() ? 8 : 4;
                                long l5 = this.getValues(n4, byArray, n11);
                                n4 += n11;
                                int n12 = this.getIndexFromObject(l5);
                                byte[] byArray3 = new byte[]{(byte)(n12 >> 24), (byte)(n12 >> 16), (byte)(n12 >> 8), (byte)(n12 & 0xFF)};
                                fieldValues.setValue(n10, byArray3);
                                ++n2;
                            } else {
                                n11 = this.sizeOfType(classTable2.instanceFields[i]);
                                if (n11 > 0) {
                                    byte[] byArray4 = new byte[n11];
                                    for (int j = 0; j < n11; ++j) {
                                        byArray4[j] = byArray[n4 + j];
                                    }
                                    fieldValues.setValue(n10, byArray4);
                                    n4 += n11;
                                }
                            }
                            ++n10;
                        }
                    }
                    if (classTable2.superClassID != 0L) {
                        classTable2 = this.getClass(classTable2.superClassID);
                        continue;
                    }
                    break;
                }
            }
        }
        if (fieldValues != null) {
            Object[] objectArray = new String[2];
            for (int i = 0; i < fieldValues.getStringID().length; ++i) {
                String string;
                String string3 = null;
                string3 = this.isAddress64() ? (String)this.getStringsHashTable().get(new Long(fieldValues.getStringID(i))) : (String)this.getStringsHashTable().get(new Integer((int)fieldValues.getStringID(i)));
                if (string3 == null) {
                    string3 = "";
                }
                objectArray[0] = this.printType(fieldValues.getType(i), fieldValues.getValue(i)) + " " + string3;
                objectArray[1] = string = this.printContent(fieldValues.getType(i), fieldValues.getValue(i));
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    public String getStackTraceString(int n) {
        if (this.getStackTraceSerialNumber() == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        int n2 = this.getStackTraceSerialNumber(n);
        if (this.getFileType() == 4) {
            StringBuffer stringBuffer = (StringBuffer)this.getStackTrace().get(new Integer(n2));
            if (stringBuffer == null) {
                return null;
            }
            return "Stack trace :" + stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        StackTrace stackTrace = (StackTrace)this.getStackTrace().get(new Integer(n2));
        if (stackTrace == null || stackTrace.getStackFrame() == null) {
            return null;
        }
        stringBuffer.append("Stack trace :");
        for (int i = 0; i < stackTrace.getStackFrame().length; ++i) {
            long l = stackTrace.getStackFrame(i);
            StackFrame stackFrame = (StackFrame)this.getStackFrame().get(new Long(l));
            if (stackFrame == null) continue;
            stringBuffer.append("\tat ");
            if (this.isAddress64()) {
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getMethodNameID())));
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getMethodSigID())));
                stringBuffer.append(" ");
                stringBuffer.append("(");
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getSourceFileNameID())));
            } else {
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getMethodNameID())));
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getMethodSigID())));
                stringBuffer.append(" ");
                stringBuffer.append("(");
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getSourceFileNameID())));
            }
            stringBuffer.append(":");
            switch (stackFrame.getLineNumber()) {
                case 0: {
                    stringBuffer.append("no source code line number information available");
                    break;
                }
                case -1: {
                    stringBuffer.append("source code line number unknown");
                    break;
                }
                default: {
                    stringBuffer.append(stackFrame.getLineNumber());
                }
            }
            stringBuffer.append(")\n");
        }
        return stringBuffer.toString();
    }

    public void addStackTraceString2Model(int n, DefaultTableModel defaultTableModel) {
        if (this.getStackTraceSerialNumber() == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        Object[] objectArray = new String[2];
        int n2 = this.getStackTraceSerialNumber(n);
        if (this.getFileType() == 4) {
            StringBuffer stringBuffer = (StringBuffer)this.getStackTrace().get(new Integer(n2));
            if (stringBuffer == null) {
                return;
            }
            objectArray[0] = "Stack trace";
            objectArray[1] = stringBuffer.toString();
            defaultTableModel.addRow(objectArray);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StackTrace stackTrace = (StackTrace)this.getStackTrace().get(new Integer(n2));
        if (stackTrace == null || stackTrace.getStackFrame() == null) {
            return;
        }
        for (int i = 0; i < stackTrace.getStackFrame().length; ++i) {
            long l = stackTrace.getStackFrame(i);
            StackFrame stackFrame = (StackFrame)this.getStackFrame().get(new Long(l));
            if (stackFrame == null) continue;
            stringBuffer.setLength(0);
            stringBuffer.append("at ");
            if (this.isAddress64()) {
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getMethodNameID())));
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getMethodSigID())));
                stringBuffer.append(" ");
                stringBuffer.append("(");
                stringBuffer.append(this.getStringsHashTable().get(new Long(stackFrame.getSourceFileNameID())));
            } else {
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getMethodNameID())));
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getMethodSigID())));
                stringBuffer.append(" ");
                stringBuffer.append("(");
                stringBuffer.append(this.getStringsHashTable().get(new Integer((int)stackFrame.getSourceFileNameID())));
            }
            stringBuffer.append(":");
            switch (stackFrame.getLineNumber()) {
                case 0: {
                    stringBuffer.append("no source code line number information available");
                    break;
                }
                case -1: {
                    stringBuffer.append("source code line number unknown");
                    break;
                }
                default: {
                    stringBuffer.append(stackFrame.getLineNumber());
                }
            }
            stringBuffer.append(")");
            objectArray[0] = i == 0 ? "Stack trace" : "";
            objectArray[1] = stringBuffer.toString();
            defaultTableModel.addRow(objectArray);
        }
    }

    public synchronized long nextID() {
        if (this.bookMark.size() == 0) {
            this.bookMarkID = 0;
        }
        ++this.bookMarkID;
        return this.bookMarkID;
    }

    public static void addRow2TableModel(String string, String string2, DefaultTableModel defaultTableModel) {
        Object[] objectArray = new String[]{string, string2};
        defaultTableModel.addRow(objectArray);
    }

    public long returnTreeDepth(long l) {
        long l2;
        block3: {
            int n;
            block4: {
                l2 = 0L;
                n = 0;
                if (!this.isHav()) break block4;
                long l3 = l;
                if (l3 == -1L) break block3;
                while ((l3 = this.getHav().getParent(l3)) >= 0L) {
                    ++l2;
                    if (l3 >= 0L) continue;
                    break block3;
                }
                break block3;
            }
            n = this.isAddress64() ? Arrays.binarySearch(this.getAddressLong(), l) : Arrays.binarySearch(this.getAddress(), (int)l);
            if (n < 0) {
                System.out.println("Cannot find address : 0x" + Long.toHexString(l));
                return -1L;
            }
            while (this.getParent()[n] >= 0) {
                ++l2;
                n = this.getParent()[n];
            }
        }
        return l2;
    }

    public boolean isJavaAPI(String string) {
        int n = string.lastIndexOf(" ");
        if (n >= 0) {
            string = string.substring(n + 1);
            System.out.println("|" + string + "|");
        }
        if (string.startsWith("java/")) {
            return true;
        }
        if (string.startsWith("javax/")) {
            return true;
        }
        if (string.startsWith("java.")) {
            return true;
        }
        return string.startsWith("javax.");
    }

    public String getNonJavaAncestor(long l) {
        String string = null;
        int n = this.getIndexFromObject(l);
        int n2 = 0;
        while (this.getHasParent(n)) {
            if ((n = this.getParent(n)) >= 0) {
                string = this.getName(n);
                if (!this.isJavaAPI(string)) {
                    return string;
                }
            } else {
                return null;
            }
            if (n2++ <= 10) continue;
            return null;
        }
        return null;
    }

    public long getAddressOfSuspectByName(String string) {
        for (int i = 0; i < this.suspectNameList.length; ++i) {
            if (!this.suspectNameList[i].equals(string)) continue;
            return this.suspectList[i] - this.getBaseAddress();
        }
        return -1L;
    }

    public int getIndexOfSuspectByName(String string) {
        for (int i = 0; i < this.suspectNameList.length; ++i) {
            if (!this.suspectNameList[i].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

