/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.DirectBuffer;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapCache;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTreeModelListener;
import com.ibm.jinwoo.heap.Node;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class HeapModel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    public Node rootPerson;
    public HeapInfo hi;
    boolean wasHav = false;
    public Hashtable nodeTable = new Hashtable();
    public Hashtable rootNodeTable = new Hashtable();
    private TreePath mustHaveTreePath = null;

    public TreePath getMustHaveTreePath() {
        return this.mustHaveTreePath;
    }

    public int getIndexInTreePath(int n) {
        if (this.getMustHaveTreePath() == null) {
            return -1;
        }
        for (int i = 0; i < this.getMustHaveTreePath().getPathCount(); ++i) {
            if (((Node)this.getMustHaveTreePath().getPathComponent(i)).getIndex() != n) continue;
            return i;
        }
        return -1;
    }

    public void setMustHaveTreePath(TreePath treePath) {
        this.mustHaveTreePath = treePath;
    }

    public HeapModel(HeapInfo heapInfo) {
        this.hi = heapInfo;
        this.rootPerson = this.hi.isHav() ? new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE) : new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
        this.addTreeModelListener(new HeapTreeModelListener());
    }

    public HeapModel(HeapInfo heapInfo, TreePath treePath) {
        this.setMustHaveTreePath(treePath);
        this.hi = heapInfo;
        this.rootPerson = this.hi.isHav() ? new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE) : new Node(-1, this.getNumberOfMustHaveRootChildren());
        this.addTreeModelListener(new HeapTreeModelListener());
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    protected void fireTreeNodesChanged(Node node) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{node});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesChanged(TreePath treePath) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Node node) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{node});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreePath treePath) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Node node) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{node});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Node node) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{node});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreePath treePath) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public int getBiggestRealChild(int n) {
        if (n == -1) {
            return this.hi.getRootChildren(0);
        }
        if (this.hi.getChild()[n] == null) {
            return -1;
        }
        int n2 = this.getChildCount(n);
        if (n2 == -1) {
            return -1;
        }
        if (this.hi.isSorted(n) && n == this.hi.getParent()[this.hi.getChild()[n][0]]) {
            return this.hi.getChild()[n][0];
        }
        for (int i = 0; i < n2; ++i) {
            long l = this.hi.getChild()[n][i];
            if (n != this.hi.getParent()[(int)l]) continue;
            return (int)l;
        }
        return -1;
    }

    public HeapCache getBiggestRealChildHavObject(Object object) {
        Node node = (Node)object;
        if (node == null) {
            return null;
        }
        if (node.getIndex() == -1) {
            HeapCache heapCache = this.hi.getHav().getHeapCache(this.hi.getRootChildren(0));
            if (heapCache == null) {
                heapCache = this.hi.getHav().returnHeapCache(this.hi.getRootChildren(0), false);
                return heapCache;
            }
            return heapCache;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = -1L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        HeapCache heapCache = this.hi.getHav().returnHeapCache(node.getLocation(), false);
        if (heapCache == null) {
            return null;
        }
        if (heapCache.getNumberOfChildren() == 0) {
            return null;
        }
        HeapCache heapCache2 = null;
        HeapCache heapCache3 = null;
        long l9 = -1L;
        for (int i = 0; i < heapCache.getNumberOfChildren(); ++i) {
            l9 = heapCache.getChild(i);
            heapCache2 = this.hi.getHav().returnHeapCacheNoChild(l9, false);
            if (heapCache2.getParentLocation() != node.getLocation()) continue;
            heapCache3 = heapCache2;
            break;
        }
        return heapCache3;
    }

    public HeapCache getBiggestRealChildHavObjectFirstChild(Object object) {
        Node node = (Node)object;
        if (node == null) {
            return null;
        }
        if (node.getIndex() == -1) {
            HeapCache heapCache = this.hi.getHav().getHeapCache(this.hi.getRootChildren(0));
            if (heapCache == null) {
                heapCache = this.hi.getHav().returnHeapCacheFirstChild(this.hi.getRootChildren(0), false);
                return heapCache;
            }
            return heapCache;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = -1L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        HeapCache heapCache = this.hi.getHav().returnHeapCache(node.getLocation(), false);
        if (heapCache == null) {
            return null;
        }
        if (heapCache.getNumberOfChildren() == 0) {
            return null;
        }
        HeapCache heapCache2 = null;
        HeapCache heapCache3 = null;
        long l9 = -1L;
        for (int i = 0; i < heapCache.getNumberOfChildren(); ++i) {
            l9 = heapCache.getChild(i);
            heapCache2 = this.hi.getHav().returnHeapCacheNoChild(l9, false);
            if (heapCache2.getParentLocation() != node.getLocation()) continue;
            heapCache3 = heapCache2;
            break;
        }
        return heapCache3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBiggestRealChild(Object object) {
        Node node = (Node)object;
        if (node == null) {
            return -1L;
        }
        if (node.getIndex() == -1) {
            return this.hi.getRootChildren(0);
        }
        if (node.isHav()) {
            int n = this.hi.getHav().getNChild(node.getLocation());
            if (n == 0) {
                return -1L;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = -1L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            HeapCache heapCache = this.hi.getHav().getHeapCache(node.getLocation());
            if (heapCache == null) {
                if (this.hi.backgroundThread != null) {
                    this.hi.backgroundThread.interrupt();
                }
                RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                synchronized (randomAccessFile) {
                    block26: {
                        try {
                            this.hi.getHav().raf.seek(node.getLocation() + this.hi.getHav().getHeapBaseLocation());
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().readName(this.hi.getHav().raf);
                            long l9 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                            this.hi.getHav().raf.seek(l9 + this.hi.getHav().getHeapBaseLocation());
                            this.hi.getHav().read(this.hi.getHav().raf);
                            int n2 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                            if (n2 <= 0) break block26;
                            for (int i = 0; i < n2; ++i) {
                                l9 = this.hi.getHav().read(this.hi.getHav().raf);
                                l5 = this.hi.getHav().raf.getFilePointer();
                                this.hi.getHav().raf.seek(l9 + this.hi.getHav().getHeapBaseLocation());
                                this.hi.getHav().read(this.hi.getHav().raf);
                                l7 = this.hi.getHav().read(this.hi.getHav().raf);
                                l8 = l7 + this.hi.getHav().read(this.hi.getHav().raf);
                                this.hi.getHav().readName(this.hi.getHav().raf);
                                l3 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                                this.hi.getHav().raf.seek(l3 + this.hi.getHav().getHeapBaseLocation());
                                l2 = this.hi.getHav().read(this.hi.getHav().raf);
                                if (l2 == node.getLocation()) {
                                    l4 = l9;
                                    break;
                                }
                                this.hi.getHav().raf.seek(l5);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            int n3 = heapCache.getNumberOfChildren();
            if (n3 > 0) {
                long l10 = -1L;
                HeapCache heapCache2 = null;
                for (int i = 0; i < n3; ++i) {
                    l10 = heapCache.getChild(i);
                    heapCache2 = this.hi.getHav().getHeapCache(l10);
                    if (heapCache2 == null) {
                        RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                        synchronized (randomAccessFile) {
                            try {
                                l5 = this.hi.getHav().raf.getFilePointer();
                                this.hi.getHav().raf.seek(l10 + this.hi.getHav().getHeapBaseLocation());
                                this.hi.getHav().read(this.hi.getHav().raf);
                                l7 = this.hi.getHav().read(this.hi.getHav().raf);
                                l8 = l7 + this.hi.getHav().read(this.hi.getHav().raf);
                                this.hi.getHav().readName(this.hi.getHav().raf);
                                l3 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                                this.hi.getHav().raf.seek(l3 + this.hi.getHav().getHeapBaseLocation());
                                l2 = this.hi.getHav().read(this.hi.getHav().raf);
                                if (l2 == node.getLocation()) {
                                    l4 = l10;
                                    break;
                                }
                                this.hi.getHav().raf.seek(l5);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            continue;
                        }
                    }
                    l2 = heapCache2.getParentLocation();
                    if (l2 != node.getLocation()) continue;
                    l4 = l10;
                    break;
                }
            }
            return l4;
        }
        if (this.hi.getChild()[node.getIndex()] == null) {
            return -1L;
        }
        long l = 0L;
        int n = -1;
        int n4 = this.getChildCount(node);
        if (n4 == -1) {
            return -1L;
        }
        if (this.hi.isSorted(node.getIndex()) && node.getIndex() == this.hi.getParent()[this.hi.getChild()[node.getIndex()][0]]) {
            return this.hi.getChild()[node.getIndex()][0];
        }
        for (int i = 0; i < n4; ++i) {
            long l11 = this.hi.getChild()[node.getIndex()][i];
            if (node.getIndex() != this.hi.getParent()[(int)l11] || this.hi.getTotal(l11) <= l) continue;
            l = this.hi.getTotal(l11);
            n = (int)l11;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBiggestRealChildORG2(Object object) {
        Node node = (Node)object;
        if (node == null) {
            return -1L;
        }
        if (node.getIndex() == -1) {
            return this.hi.getRootChildren(0);
        }
        if (node.isHav()) {
            int n = this.hi.getHav().getNChild(node.getLocation());
            if (n == 0) {
                return -1L;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = -1L;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            HeapCache heapCache = this.hi.getHav().getHeapCache(node.getLocation());
            if (heapCache == null) {
                if (this.hi.backgroundThread != null) {
                    this.hi.backgroundThread.interrupt();
                }
                RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                synchronized (randomAccessFile) {
                    try {
                        this.hi.getHav().raf.seek(node.getLocation() + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().readName(this.hi.getHav().raf);
                        long l9 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                        this.hi.getHav().raf.seek(l9 + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        int n2 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                        if (n2 > 0) {
                            for (int i = 0; i < n2; ++i) {
                                l9 = this.hi.getHav().read(this.hi.getHav().raf);
                                l5 = this.hi.getHav().raf.getFilePointer();
                                this.hi.getHav().raf.seek(l9 + this.hi.getHav().getHeapBaseLocation());
                                this.hi.getHav().read(this.hi.getHav().raf);
                                l7 = this.hi.getHav().read(this.hi.getHav().raf);
                                l8 = l7 + this.hi.getHav().read(this.hi.getHav().raf);
                                this.hi.getHav().readName(this.hi.getHav().raf);
                                l3 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                                this.hi.getHav().raf.seek(l3 + this.hi.getHav().getHeapBaseLocation());
                                l2 = this.hi.getHav().read(this.hi.getHav().raf);
                                if (l2 == node.getLocation() && l8 > l) {
                                    l = l8;
                                    l4 = l9;
                                }
                                this.hi.getHav().raf.seek(l5);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            int n3 = heapCache.getNumberOfChildren();
            if (n3 > 0) {
                long l10 = -1L;
                HeapCache heapCache2 = null;
                for (int i = 0; i < n3; ++i) {
                    l10 = heapCache.getChild(i);
                    heapCache2 = this.hi.getHav().getHeapCache(l10);
                    if (heapCache2 == null) {
                        RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                        synchronized (randomAccessFile) {
                            try {
                                l5 = this.hi.getHav().raf.getFilePointer();
                                this.hi.getHav().raf.seek(l10 + this.hi.getHav().getHeapBaseLocation());
                                this.hi.getHav().read(this.hi.getHav().raf);
                                l7 = this.hi.getHav().read(this.hi.getHav().raf);
                                l8 = l7 + this.hi.getHav().read(this.hi.getHav().raf);
                                this.hi.getHav().readName(this.hi.getHav().raf);
                                l3 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                                this.hi.getHav().raf.seek(l3 + this.hi.getHav().getHeapBaseLocation());
                                l2 = this.hi.getHav().read(this.hi.getHav().raf);
                                if (l2 == node.getLocation() && l8 > l) {
                                    l = l8;
                                    l4 = l10;
                                }
                                this.hi.getHav().raf.seek(l5);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            continue;
                        }
                    }
                    l2 = heapCache2.getParentLocation();
                    l8 = heapCache2.getTotalSize();
                    if (l2 != node.getLocation() || l8 <= l) continue;
                    l = l8;
                    l4 = l10;
                }
            }
            return l4;
        }
        if (this.hi.getChild()[node.getIndex()] == null) {
            return -1L;
        }
        long l = 0L;
        int n = -1;
        int n4 = this.getChildCount(node);
        if (n4 == -1) {
            return -1L;
        }
        if (this.hi.isSorted(node.getIndex()) && node.getIndex() == this.hi.getParent()[this.hi.getChild()[node.getIndex()][0]]) {
            return this.hi.getChild()[node.getIndex()][0];
        }
        for (int i = 0; i < n4; ++i) {
            long l11 = this.hi.getChild()[node.getIndex()][i];
            if (node.getIndex() != this.hi.getParent()[(int)l11] || this.hi.getTotal(l11) <= l) continue;
            l = this.hi.getTotal(l11);
            n = (int)l11;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBiggestRealChildORG(Object object) {
        Node node = (Node)object;
        if (node == null) {
            return -1L;
        }
        if (node.getIndex() == -1) {
            return this.hi.getRootChildren(0);
        }
        if (node.isHav()) {
            int n = this.hi.getHav().getNChild(node.getLocation());
            if (n == 0) {
                return -1L;
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = -1L;
            DirectBuffer directBuffer = this.hi.getHav().heapBuffer;
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            RandomAccessFile randomAccessFile = this.hi.getHav().raf;
            synchronized (randomAccessFile) {
                directBuffer.position(node.getLocation());
                directBuffer.read();
                directBuffer.read();
                directBuffer.read();
                directBuffer.readName();
                long l9 = directBuffer.getInt() & 0xFFFFFFFF;
                directBuffer.position(l9);
                directBuffer.read();
                int n2 = (int)directBuffer.read();
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        l9 = directBuffer.read();
                        l5 = directBuffer.position();
                        directBuffer.position(l9);
                        directBuffer.read();
                        l7 = directBuffer.read();
                        l8 = l7 + directBuffer.read();
                        directBuffer.readName();
                        l3 = directBuffer.getInt() & 0xFFFFFFFF;
                        directBuffer.position(l3);
                        l2 = directBuffer.read();
                        if (l2 == node.getLocation() && l8 > l) {
                            l = l8;
                            l4 = l9;
                        }
                        directBuffer.position(l5);
                    }
                }
            }
            return l4;
        }
        if (this.hi.getChild()[node.getIndex()] == null) {
            return -1L;
        }
        long l = 0L;
        int n = -1;
        int n3 = this.getChildCount(node);
        if (n3 == -1) {
            return -1L;
        }
        if (this.hi.isSorted(node.getIndex()) && node.getIndex() == this.hi.getParent()[this.hi.getChild()[node.getIndex()][0]]) {
            return this.hi.getChild()[node.getIndex()][0];
        }
        for (int i = 0; i < n3; ++i) {
            long l10 = this.hi.getChild()[node.getIndex()][i];
            if (node.getIndex() != this.hi.getParent()[(int)l10] || this.hi.getTotal(l10) <= l) continue;
            l = this.hi.getTotal(l10);
            n = (int)l10;
        }
        return n;
    }

    public Object getChild(Object object, int n) {
        Node node = (Node)object;
        if (node.isHav()) {
            this.wasHav = true;
            if (this.hi.backgroundThread != null) {
                this.hi.backgroundThread.interrupt();
            }
            if (node.getIndex() == -2) {
                return null;
            }
            if (node.getIndex() == -1) {
                if (n == node.getNumberOfChildren()) {
                    Node node2 = new Node(true, -2);
                    node2.setNumberOfChildren(this.hi.getRootChildrenLength() - node.getNumberOfChildren());
                    return node2;
                }
                Integer n2 = new Integer(n);
                if (this.rootNodeTable.containsKey(n2)) {
                    return (Node)this.rootNodeTable.get(n2);
                }
                Node node3 = new Node(true, this.hi.getRootChildrenPointer(n), (int)HeapAnalyzer.MAX_SUBTREE);
                this.rootNodeTable.put(n2, node3);
                return node3;
            }
            if (this.hi.getHav().getNChild(node.getLocation()) == 0) {
                return null;
            }
            if (n == node.getNumberOfChildren()) {
                Node node4 = new Node(true, -2);
                if (this.hi.backgroundThread != null) {
                    this.hi.backgroundThread.interrupt();
                }
                node4.setNumberOfChildren(this.hi.getHav().getNChild(node.getLocation()) - node.getNumberOfChildren());
                return node4;
            }
            long l = this.hi.getHav().getChildSorted(node.getLocation(), n);
            String string = node.getLocation() + ":" + n;
            if (this.nodeTable.containsKey(string)) {
                return (Node)this.nodeTable.get(string);
            }
            if (!HeapAnalyzer.SHOW_NONOWNER && this.hi.getHav().getParent(l) != node.getLocation()) {
                Node node5 = new Node(true, l, true, (int)HeapAnalyzer.MAX_SUBTREE);
                this.nodeTable.put(string, node5);
                return node5;
            }
            Node node6 = new Node(true, l, (int)HeapAnalyzer.MAX_SUBTREE);
            this.nodeTable.put(string, node6);
            return node6;
        }
        if (node.getIndex() == -2) {
            return null;
        }
        if (node.getIndex() == -1) {
            if (n == node.getNumberOfChildren()) {
                Node node7 = new Node(-2);
                node7.setNumberOfChildren(this.hi.getRootChildrenLength() - node.getNumberOfChildren());
                return node7;
            }
            Integer n3 = new Integer(n);
            if (this.rootNodeTable.containsKey(n3)) {
                Node node8 = (Node)this.rootNodeTable.get(n3);
                if (node8.isHav()) {
                    this.rootNodeTable.remove(n3);
                    node8 = new Node(this.hi.getRootChildren(n), (int)HeapAnalyzer.MAX_SUBTREE);
                    this.rootNodeTable.put(n3, node8);
                    return node8;
                }
                return (Node)this.rootNodeTable.get(n3);
            }
            Node node9 = new Node(this.hi.getRootChildren(n), (int)HeapAnalyzer.MAX_SUBTREE);
            this.rootNodeTable.put(n3, node9);
            return node9;
        }
        if (this.hi.getChild()[node.getIndex()] == null) {
            return null;
        }
        if (n == node.getNumberOfChildren()) {
            Node node10 = new Node(-2);
            node10.setNumberOfChildren(this.hi.getChild()[node.getIndex()].length - node.getNumberOfChildren());
            return node10;
        }
        int n4 = this.hi.getChild()[node.getIndex()][n];
        String string = node.getIndex() + "." + n;
        if (this.nodeTable.containsKey(string)) {
            Node node11 = (Node)this.nodeTable.get(string);
            if (node11.isHav()) {
                node11 = new Node(n4, true, (int)HeapAnalyzer.MAX_SUBTREE);
                this.nodeTable.remove(string);
                this.nodeTable.put(string, node11);
                return node11;
            }
            return (Node)this.nodeTable.get(string);
        }
        if (!HeapAnalyzer.SHOW_NONOWNER && this.hi.getParent()[n4] != node.getIndex()) {
            Node node12 = new Node(n4, true, (int)HeapAnalyzer.MAX_SUBTREE);
            this.nodeTable.put(string, node12);
            return node12;
        }
        Node node13 = new Node(n4, (int)HeapAnalyzer.MAX_SUBTREE);
        this.nodeTable.put(string, node13);
        return node13;
    }

    public int getChildCount(long l) {
        if (l == -1L) {
            return this.hi.getRootChildrenLength();
        }
        if (this.hi.isHav()) {
            if (this.hi.backgroundThread != null) {
                this.hi.backgroundThread.interrupt();
            }
            int n = this.hi.getHav().getNChild(l);
            return n;
        }
        int n = (int)l;
        if (this.hi.getChild()[n] != null) {
            if (!this.hi.isSorted((int)l)) {
                this.hi.sortChildren((int)l);
            }
            return this.hi.getChild()[n].length;
        }
        return 0;
    }

    public int getNumberOfMustHaveRootChildren() {
        if (this.getMustHaveTreePath().getPathCount() < 2) {
            return this.hi.getRootChildrenLength();
        }
        Node node = (Node)this.getMustHaveTreePath().getPathComponent(0);
        if (node.getIndex() != -1) {
            return this.hi.getRootChildrenLength();
        }
        Node node2 = (Node)this.getMustHaveTreePath().getPathComponent(1);
        for (int i = 0; i < this.hi.getRootChildrenLength(); ++i) {
            if (this.hi.getRootChildren(i) != node2.getIndex()) continue;
            if (i + 1 < this.hi.getRootChildrenLength()) {
                return i + 2;
            }
            return i + 1;
        }
        return this.hi.getRootChildrenLength();
    }

    public int getNumberOfMustHaveChildren(int n, Node node) {
        Node node2 = (Node)this.getMustHaveTreePath().getPathComponent(n + 1);
        if (node.getIndex() == -1) {
            for (int i = 0; i < this.hi.getRootChildrenLength(); ++i) {
                if (this.hi.getRootChildren(i) != node2.getIndex()) continue;
                if (node.getNumberOfChildren() > i) break;
                if (i + 1 < this.hi.getRootChildrenLength()) {
                    node.setNumberOfChildren(i + 2);
                    continue;
                }
                node.setNumberOfChildren(i + 1);
            }
            if (node.getNumberOfChildren() >= this.hi.getRootChildrenLength()) {
                node.setNumberOfChildren(this.hi.getRootChildrenLength());
                return this.hi.getRootChildrenLength();
            }
            return node.getNumberOfChildren() + 1;
        }
        if (this.hi.getChild()[node.getIndex()] != null && !this.hi.isSorted(node.getIndex())) {
            this.hi.sortChildren(node.getIndex());
        }
        for (int i = 0; i < this.hi.getChild()[node.getIndex()].length; ++i) {
            if (this.hi.getChild()[node.getIndex()][i] != node2.getIndex()) continue;
            if (node.getNumberOfChildren() > i) break;
            node.setNumberOfChildren(i + 1);
            if (i + 1 < this.hi.getChild()[node.getIndex()].length) {
                node.setNumberOfChildren(i + 2);
                continue;
            }
            node.setNumberOfChildren(i + 1);
        }
        if (node.getNumberOfChildren() >= this.hi.getChild()[node.getIndex()].length) {
            node.setNumberOfChildren(this.hi.getChild()[node.getIndex()].length);
            return this.hi.getChild()[node.getIndex()].length;
        }
        return node.getNumberOfChildren() + 1;
    }

    public int getChildCount(Object object) {
        int n;
        Node node = (Node)object;
        if (node.isHav()) {
            if (this.hi.backgroundThread != null) {
                this.hi.backgroundThread.interrupt();
            }
            if (node.getIndex() == -1) {
                if (node.getNumberOfChildren() >= this.hi.getRootChildrenLength()) {
                    node.setNumberOfChildren(this.hi.getRootChildrenLength());
                    return this.hi.getRootChildrenLength();
                }
                return node.getNumberOfChildren() + 1;
            }
            long l = this.hi.getHav().getNChildCache(node.getLocation());
            if ((long)node.getNumberOfChildren() >= l) {
                node.setNumberOfChildren((int)l);
                return (int)l;
            }
            return node.getNumberOfChildren() + 1;
        }
        if (this.getMustHaveTreePath() != null && (n = this.getIndexInTreePath(node.getIndex())) >= 0 && n + 1 < this.getMustHaveTreePath().getPathCount()) {
            return this.getNumberOfMustHaveChildren(n, node);
        }
        if (node.getIndex() == -1) {
            if (node.getNumberOfChildren() >= this.hi.getRootChildrenLength()) {
                node.setNumberOfChildren(this.hi.getRootChildrenLength());
                return this.hi.getRootChildrenLength();
            }
            return node.getNumberOfChildren() + 1;
        }
        if (node.getIndex() == -2) {
            return 0;
        }
        if (this.hi.getChild()[node.getIndex()] != null && !this.hi.isSorted(node.getIndex())) {
            this.hi.sortChildren(node.getIndex());
        }
        if (this.hi.getChild()[node.getIndex()] != null && node.getNumberOfChildren() >= this.hi.getChild()[node.getIndex()].length) {
            node.setNumberOfChildren(this.hi.getChild()[node.getIndex()].length);
            return this.hi.getChild()[node.getIndex()].length;
        }
        return node.getNumberOfChildren() + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIndexOfChild(Object object, Object object2) {
        Node node = (Node)object;
        Node node2 = (Node)object2;
        if (node.isHav()) {
            if (this.hi.backgroundThread != null) {
                this.hi.backgroundThread.interrupt();
            }
            if (node.getIndex() == -2) {
                return -1;
            }
            if (node.getIndex() != -1) return this.hi.getHav().getIndexOfChild(node.getLocation(), node2.getLocation());
            for (int i = 0; i < this.hi.getRootChildrenLength(); ++i) {
                if (this.hi.getRootChildrenPointer(i) != node2.getLocation()) continue;
                return i;
            }
            return -1;
        }
        if (node.getIndex() == -2) {
            return -1;
        }
        if (node.getIndex() == -1) {
            for (int i = 0; i < this.hi.getRootChildrenLength(); ++i) {
                if (this.hi.getRootChildren(i) != node2.getIndex()) continue;
                return i;
            }
            return -1;
        } else {
            for (int i = 0; i < this.hi.getChild()[node.getIndex()].length; ++i) {
                if (this.hi.getChild()[node.getIndex()][i] != node2.getIndex()) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getRoot() {
        return this.rootPerson;
    }

    public boolean isLeaf(Object object) {
        Node node = (Node)object;
        if (node.isHav()) {
            return this.hi.getHav().isLeafCache(node.getLocation());
        }
        if (node.getIndex() == -1) {
            return false;
        }
        if (node.getIndex() == -2) {
            return false;
        }
        if (object == null) {
            return true;
        }
        return this.hi.getChild()[node.getIndex()] == null;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("*** valueForPathChanged : " + treePath + " --> " + object);
    }
}

