/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.DropProgressDialog;
import com.ibm.jinwoo.heap.FindAddressView;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.MyRenderer;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.NumberCellRenderer;
import com.ibm.jinwoo.heap.ObjectTableModel;
import com.ibm.jinwoo.heap.ParentSearch;
import com.ibm.jinwoo.heap.PopupListener;
import com.ibm.jinwoo.heap.SearchTableModel;
import com.ibm.jinwoo.heap.TableThreadSearch;
import com.ibm.jinwoo.heap.TypeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class HeapTable
extends JTable
implements ActionListener {
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    HeapInfo hi;
    HeapAnalyzer ha;
    HeapTree ht;

    public HeapTable() {
    }

    public HeapTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public HeapTable(int n, int n2) {
        super(n, n2);
    }

    public HeapTable(HeapInfo heapInfo, HeapAnalyzer heapAnalyzer) {
        this.hi = heapInfo;
        this.ha = heapAnalyzer;
        this.setCellSelectionEnabled(true);
    }

    public HeapTable(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public HeapTable(TableModel tableModel) {
        super(tableModel);
    }

    public HeapTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public HeapTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().startsWith("Find parents")) {
            if (this.hi.isLoading() && !this.hi.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            ObjectTableModel objectTableModel = (ObjectTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            long l = FindAddressView.getStringToLong(string);
            long l2 = 0L;
            l -= this.hi.getBaseAddress();
            if (this.hi.isHav()) {
                l2 = this.hi.getHav().getLocationFromAddress(l);
                if (l2 == -1L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            } else {
                l2 = this.hi.isAddress64() ? (long)Arrays.binarySearch(this.hi.getAddressLong(), l) : (long)Arrays.binarySearch(this.hi.getAddress(), (int)l);
                if (l2 < 0L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            }
            this.listParents(l2, string);
        } else if (jMenuItem.getText().startsWith("Find children")) {
            ObjectTableModel objectTableModel = (ObjectTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            long l = FindAddressView.getStringToLong(string);
            long l3 = 0L;
            l -= this.hi.getBaseAddress();
            if (this.hi.isHav()) {
                l3 = this.hi.getHav().getLocationFromAddress(l);
                if (l3 == -1L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            } else {
                l3 = this.hi.isAddress64() ? (long)Arrays.binarySearch(this.hi.getAddressLong(), l) : (long)Arrays.binarySearch(this.hi.getAddress(), (int)l);
                if (l3 < 0L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            }
            this.listChildren(l3, string);
        } else if (jMenuItem.getText().startsWith("List parents")) {
            if (this.hi.isLoading() && !this.hi.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            SearchTableModel searchTableModel = (SearchTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            long l = FindAddressView.getStringToLong(string);
            l -= this.hi.getBaseAddress();
            long l4 = 0L;
            if (this.hi.isHav()) {
                l4 = this.hi.getHav().getLocationFromAddress(l);
                if (l4 == -1L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            } else {
                l4 = this.hi.isAddress64() ? (long)Arrays.binarySearch(this.hi.getAddressLong(), l) : (long)Arrays.binarySearch(this.hi.getAddress(), (int)l);
                if (l4 < 0L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            }
            this.listParents(l4, string);
        } else if (jMenuItem.getText().startsWith("List children")) {
            SearchTableModel searchTableModel = (SearchTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            long l = FindAddressView.getStringToLong(string);
            long l5 = 0L;
            l -= this.hi.getBaseAddress();
            if (this.hi.isHav()) {
                l5 = this.hi.getHav().getLocationFromAddress(l);
                if (l5 == -1L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            } else {
                l5 = this.hi.isAddress64() ? (long)Arrays.binarySearch(this.hi.getAddressLong(), l) : (long)Arrays.binarySearch(this.hi.getAddress(), (int)l);
                if (l5 < 0L) {
                    JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                    return;
                }
            }
            this.listChildren(l5, string);
        } else if (jMenuItem.getText().startsWith("List same types")) {
            if (this.hi.isLoading() && !this.hi.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            SearchTableModel searchTableModel = (SearchTableModel)this.getModel();
            int n = this.getColumnModel().getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (!((String)this.getColumnModel().getColumn(i).getIdentifier()).startsWith("Name")) continue;
                String string = (String)this.getValueAt(this.getSelectedRow(), i);
                this.listTypes(string);
                break;
            }
        } else if (jMenuItem.getText().startsWith("Find object in tree view")) {
            SearchTableModel searchTableModel = (SearchTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            this.ht = this.newTreeView();
            this.findAddressInTree(string, this.ht);
        } else if (jMenuItem.getText().startsWith("Find object in a tree view")) {
            ObjectTableModel objectTableModel = (ObjectTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            this.ht = this.newTreeView();
            this.findAddressInTree(string, this.ht);
        } else if (jMenuItem.getText().startsWith("List same type")) {
            if (this.hi.isLoading() && !this.hi.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            ObjectTableModel objectTableModel = (ObjectTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Name"));
            this.listTypes(string);
        } else if (jMenuItem.getText().startsWith("Find same type")) {
            if (this.hi.isLoading() && !this.hi.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            TypeTableModel typeTableModel = (TypeTableModel)this.getModel();
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Type"));
            this.listTypes(string);
        } else if (jMenuItem.getText().startsWith("Detailed")) {
            Object object;
            if (this.hi == null) {
                return;
            }
            HeapFrame heapFrame = null;
            String string = (String)this.getValueAt(this.getSelectedRow(), this.getColumnModel().getColumnIndex("Address"));
            long l = FindAddressView.getStringToLong(string);
            int n = 0;
            n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)(l -= this.hi.getBaseAddress()));
            if (n < 0) {
                JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                return;
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Property");
            defaultTableModel.addColumn("Value");
            Object[] objectArray = new String[2];
            heapFrame = n != -1 ? (this.hi.isAddress64() ? new HeapFrame(this.hi.getName(n) + " at 0x" + Long.toHexString(this.hi.getAddress(n))) : new HeapFrame(this.hi.getName(n) + " at 0x" + Integer.toHexString((int)this.hi.getAddress(n)))) : new HeapFrame("Heap dump roots");
            if (n == -1) {
                objectArray[0] = "Number of roots";
                objectArray[1] = numberFormatter.format(this.hi.getRootChildrenLength());
                defaultTableModel.addRow(objectArray);
            } else {
                object = new String();
                if (this.hi == null) {
                    return;
                }
                if (this.hi.isSuspect(n)) {
                    objectArray[0] = "Leak suspect";
                    objectArray[1] = "Responsible for " + numberFormatter.format(this.hi.getTotal(n)) + " bytes (" + 100.0f * (float)this.hi.getTotal(n) / (float)this.hi.getHeapSize() + " %) of Java heap";
                    defaultTableModel.addRow(objectArray);
                }
                objectArray[0] = "Address";
                objectArray[1] = this.hi.isAddress64() ? "0x" + Long.toHexString(this.hi.getAddress(n)) : "0x" + Integer.toHexString((int)this.hi.getAddress(n));
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "Name";
                objectArray[1] = this.hi.getName(n);
                defaultTableModel.addRow(objectArray);
                if (this.hi.getChild()[n] == null) {
                    objectArray[0] = "Number of children";
                    objectArray[1] = "0 (This is a leaf node)";
                    defaultTableModel.addRow(objectArray);
                } else {
                    objectArray[0] = "Number of children";
                    objectArray[1] = numberFormatter.format(this.hi.getChild()[n].length);
                    defaultTableModel.addRow(objectArray);
                }
                objectArray[0] = "Number of parents";
                objectArray[1] = this.hi.getParentsList()[n] == null ? "0 (This is a root node)" : numberFormatter.format(this.hi.getParentsList()[n].length);
                defaultTableModel.addRow(objectArray);
                if (this.hi.getParent()[n] >= 0) {
                    objectArray[0] = "Owner address";
                    objectArray[1] = this.hi.isAddress64() ? "0x" + Long.toHexString(this.hi.getAddress(this.hi.getParent()[n])) : "0x" + Integer.toHexString((int)this.hi.getAddress(this.hi.getParent()[n]));
                    defaultTableModel.addRow(objectArray);
                    objectArray[0] = "Owner object";
                    objectArray[1] = this.hi.getName(this.hi.getParent()[n]);
                    defaultTableModel.addRow(objectArray);
                }
                object = (String)object + "Size : " + numberFormatter.format(this.hi.getSize(n)) + "\n";
                object = (String)object + "Total size : " + numberFormatter.format(this.hi.getTotal(n)) + "\n";
                objectArray[0] = "Size";
                objectArray[1] = numberFormatter.format(this.hi.getSize(n));
                defaultTableModel.addRow(objectArray);
                objectArray[0] = "Total size";
                objectArray[1] = numberFormatter.format(this.hi.getTotal(n));
                defaultTableModel.addRow(objectArray);
                this.hi.addStackTraceString2Model(n, defaultTableModel);
                this.hi.addFieldList2Model(n, defaultTableModel);
            }
            object = new ImageIcon(this.getClass().getResource("/detail.gif"));
            heapFrame.setFrameIcon((Icon)object);
            JTable jTable = new JTable();
            jTable.setCellSelectionEnabled(true);
            jTable.setDragEnabled(true);
            heapFrame.hi = this.hi;
            jTable.setModel(defaultTableModel);
            heapFrame.JScrollPaneSetViewportView(jTable);
            heapFrame.pack();
            this.ha.getJDesktopPane1().add(heapFrame);
            this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAddressInTree(String string, HeapTree heapTree) {
        if (string == null) {
            return;
        }
        long l = 0L;
        try {
            l = FindAddressView.getStringToLong(string);
        }
        catch (RuntimeException runtimeException) {
            JOptionPane.showMessageDialog(this, "Invalid address : " + string, "Invalid address", 0);
            return;
        }
        l -= this.hi.getBaseAddress();
        long l2 = 0L;
        if (this.hi.isHav()) {
            int n;
            boolean bl = false;
            RandomAccessFile randomAccessFile = this.hi.getHav().raf;
            Object object = randomAccessFile;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getHeapBaseLocation());
                    for (n = 0; n < this.hi.getHav().getNumberOfEntries(); ++n) {
                        l2 = this.hi.getHav().raf.getFilePointer() - this.hi.getHav().getHeapBaseLocation();
                        if (this.hi.getHav().read(randomAccessFile) == l) {
                            bl = true;
                            this.hi.getHav().read(randomAccessFile);
                            this.hi.getHav().read(randomAccessFile);
                            this.hi.getHav().readName(randomAccessFile);
                            this.hi.getHav().raf.readInt();
                            break;
                        }
                        this.hi.getHav().read(randomAccessFile);
                        this.hi.getHav().read(randomAccessFile);
                        this.hi.getHav().readName(randomAccessFile);
                        this.hi.getHav().raf.readInt();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                return;
            }
            if (this.returnTreeDepth(l2) > HeapAnalyzer.MAX_VIEW_SIZE) {
                heapTree.moreParentsMenuItem.setEnabled(true);
                heapTree.showFromRootsMenuItem.setEnabled(true);
                object = new Vector();
                ((Vector)object).add(0, new Node(true, l2));
                n = 0;
                while (this.hi.getHav().getParent(l2) >= 0L && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                    ((Vector)object).add(0, new Node(true, this.hi.getHav().getParent(l2)));
                    l2 = this.hi.getHav().getParent(l2);
                    ++n;
                }
                Node node = new Node(true, this.hi.getHav().getParent(l2), (int)HeapAnalyzer.MAX_SUBTREE);
                ((Vector)object).add(0, node);
                Object[] objectArray = ((Vector)object).toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray2);
                if (treePath == null) {
                    return;
                }
                Node node2 = ((HeapModel)heapTree.getModel()).rootPerson;
                ((HeapModel)heapTree.getModel()).rootPerson = node;
                ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node2);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
                this.ha.dp.hide();
            } else {
                heapTree.moreParentsMenuItem.setEnabled(false);
                heapTree.showFromRootsMenuItem.setEnabled(false);
                if (((HeapModel)heapTree.getModel()).rootPerson.getIndex() != -1) {
                    object = new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE);
                    Node node = ((HeapModel)heapTree.getModel()).rootPerson;
                    ((HeapModel)heapTree.getModel()).rootPerson = object;
                    ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node);
                }
                if ((object = this.returnTreePath(l2)) == null) {
                    return;
                }
                heapTree.scrollPathToVisible((TreePath)object);
                heapTree.setSelectionPath((TreePath)object);
                this.ha.dp.hide();
            }
        } else {
            l2 = this.hi.isAddress64() ? (long)Arrays.binarySearch(this.hi.getAddressLong(), l) : (long)Arrays.binarySearch(this.hi.getAddress(), (int)l);
            if (l2 < 0L) {
                JOptionPane.showMessageDialog(this, "Cannot find address : " + string, "Address not found", 0);
                return;
            }
            if (this.returnTreeDepth(l2) > HeapAnalyzer.MAX_VIEW_SIZE) {
                heapTree.moreParentsMenuItem.setEnabled(true);
                heapTree.showFromRootsMenuItem.setEnabled(true);
                Vector<Node> vector = new Vector<Node>();
                vector.add(0, new Node((int)l2));
                int n = 0;
                while (this.hi.getParent()[(int)l2] >= 0 && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                    vector.add(0, new Node(this.hi.getParent()[(int)l2]));
                    l2 = this.hi.getParent()[(int)l2];
                    ++n;
                }
                Node node = new Node(this.hi.getParent()[(int)l2], (int)HeapAnalyzer.MAX_SUBTREE);
                vector.add(0, node);
                Object[] objectArray = vector.toArray();
                Object[] objectArray3 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray3[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray3);
                if (treePath == null) {
                    return;
                }
                Node node3 = ((HeapModel)heapTree.getModel()).rootPerson;
                ((HeapModel)heapTree.getModel()).setMustHaveTreePath(treePath);
                ((HeapModel)heapTree.getModel()).rootPerson = node;
                ((HeapModel)heapTree.getModel()).fireTreeStructureChanged(node3);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
            } else {
                heapTree.moreParentsMenuItem.setEnabled(false);
                heapTree.showFromRootsMenuItem.setEnabled(false);
                TreePath treePath = this.returnTreePath(l2);
                if (treePath == null) {
                    return;
                }
                ((HeapModel)heapTree.getModel()).setMustHaveTreePath(treePath);
                ((HeapModel)heapTree.getModel()).rootPerson = new Node(-1, ((HeapModel)heapTree.getModel()).getNumberOfMustHaveRootChildren());
                heapTree.setModel(new HeapModel(this.hi, treePath));
                heapTree.setCellRenderer(new MyRenderer(this.hi, (HeapModel)heapTree.getModel(), this.ha.cfg.percentage));
                treePath = this.returnTreePath(l2);
                heapTree.scrollPathToVisible(treePath);
                heapTree.setSelectionPath(treePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChildren(long l, String string) {
        long l2 = 0L;
        if (this.hi.isHav()) {
            l2 = this.hi.getHav().getNChild(l);
            if (l2 == 0L) {
                JOptionPane.showMessageDialog(this.ha, "This is a leaf object. There's no children of this object", "Information", 1);
                return;
            }
        } else if (this.hi.getChild()[(int)l] == null || this.hi.getChild()[(int)l].length == 0) {
            JOptionPane.showMessageDialog(this.ha, "This is a leaf object. There's no children of this object", "Information", 1);
            return;
        }
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Children of " + string, this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/child.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView(heapTable);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        SearchTableModel searchTableModel = new SearchTableModel(this.hi, 0);
        searchTableModel.setTableHeader(heapTable.getTableHeader());
        int n = 0;
        if (searchTableModel.sortedArrary == null) {
            if (this.hi.isHav()) {
                System.out.println("Requesting " + numberFormatter.format(l2 * 4L) + " bytes of Java heap.");
                searchTableModel.sortedArrary = new long[2][(int)l2];
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                synchronized (randomAccessFile) {
                    try {
                        this.hi.getHav().raf.seek(l + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().readName(this.hi.getHav().raf);
                        long l7 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                        this.hi.getHav().raf.seek(l7 + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        l2 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                        if (l2 > 0L) {
                            int n2 = 0;
                            while ((long)n2 < l2) {
                                searchTableModel.sortedArrary[1][n] = this.hi.getHav().read(this.hi.getHav().raf);
                                l3 = this.hi.getHav().raf.getFilePointer();
                                this.hi.getHav().raf.seek(searchTableModel.sortedArrary[1][n] + this.hi.getHav().getHeapBaseLocation());
                                this.hi.getHav().read(this.hi.getHav().raf);
                                l5 = this.hi.getHav().read(this.hi.getHav().raf);
                                l6 = l5 + this.hi.getHav().read(this.hi.getHav().raf);
                                searchTableModel.sortedArrary[0][n++] = l6;
                                this.hi.getHav().raf.seek(l3);
                                ++n2;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                searchTableModel.columnNames[4] = searchTableModel.columnNames[4] + "(" + numberFormatter.format(l2) + " objects)";
            } else {
                System.out.println("Requesting " + numberFormatter.format(this.hi.getChild()[(int)l].length * 4) + " bytes of Java heap.");
                searchTableModel.sortedArrary = new long[2][this.hi.getChild()[(int)l].length];
                for (int i = 0; i < this.hi.getChild()[(int)l].length; ++i) {
                    searchTableModel.sortedArrary[0][n] = this.hi.getTotal(this.hi.getChild()[(int)l][i]);
                    searchTableModel.sortedArrary[1][n++] = this.hi.getChild()[(int)l][i];
                }
                searchTableModel.columnNames[4] = searchTableModel.columnNames[4] + "(" + numberFormatter.format(this.hi.getChild()[(int)l].length) + " objects)";
            }
            System.out.println("Requesting " + numberFormatter.format(searchTableModel.sortedArrary[0].length * 8) + " bytes of Java heap.");
            searchTableModel.modelArray = new long[2][searchTableModel.sortedArrary[0].length];
            for (int i = 0; i < searchTableModel.sortedArrary[0].length; ++i) {
                searchTableModel.modelArray[0][i] = searchTableModel.sortedArrary[0][i];
                searchTableModel.modelArray[1][i] = searchTableModel.sortedArrary[1][i];
            }
            System.out.println("Sorting table by TotalSize.");
            Arrays2.sort(searchTableModel.sortedArrary);
        }
        heapTable.setModel(searchTableModel);
        TableColumnModel tableColumnModel = heapTable.getColumnModel();
        for (int i = 0; i < 6; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(80);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                tableColumn.setPreferredWidth(50);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 5) {
                tableColumn.setPreferredWidth(80);
                continue;
            }
            tableColumn.setPreferredWidth(300);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listParents(long l, String string) {
        Object object;
        int n = 0;
        if (this.hi.isHav()) {
            long l2 = this.hi.getHav().getHeapBaseLocation();
            long l3 = 0L;
            object = this.hi.getHav().raf;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getHeapBaseLocation());
                    for (int i = 0; i < this.hi.getHav().getNumberOfEntries(); ++i) {
                        this.hi.getHav().raf.seek(l2);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().readName(this.hi.getHav().raf);
                        long l4 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                        l2 = this.hi.getHav().raf.getFilePointer();
                        this.hi.getHav().raf.seek(l4 + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        l3 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                        if (l3 <= 0L) continue;
                        int n2 = 0;
                        while ((long)n2 < l3) {
                            if (this.hi.getHav().read(this.hi.getHav().raf) == l) {
                                ++n;
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        n = this.hi.getParentsList()[(int)l] == null ? 0 : this.hi.getParentsList()[(int)l].length;
        if (n == 0) {
            JOptionPane.showMessageDialog(this.ha, "This is a root object. There's no parent of this object", "Information", 1);
            return;
        }
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Parents of " + string, this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/parent.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        object = new JMenuItem("Find object in tree view");
        ((AbstractButton)object).setMnemonic('F');
        ((AbstractButton)object).addActionListener(heapTable);
        ((AbstractButton)object).setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("List same types");
        ((AbstractButton)object).setMnemonic('L');
        ((AbstractButton)object).addActionListener(heapTable);
        ((AbstractButton)object).setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("List parents");
        ((AbstractButton)object).setMnemonic('p');
        ((AbstractButton)object).setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        ((AbstractButton)object).addActionListener(heapTable);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("List children");
        ((AbstractButton)object).setMnemonic('c');
        ((AbstractButton)object).setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        ((AbstractButton)object).addActionListener(heapTable);
        jPopupMenu.add((JMenuItem)object);
        object = new JMenuItem("Detailed information");
        ((AbstractButton)object).setMnemonic('d');
        ((AbstractButton)object).setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        ((AbstractButton)object).addActionListener(heapTable);
        jPopupMenu.add((JMenuItem)object);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView(heapTable);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        ParentSearch parentSearch = new ParentSearch((JTable)heapTable, this.hi, l, n);
        parentSearch.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listTypes(String string) {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return;
        }
        if (this.hi.isHav()) {
            if (string.startsWith("class ")) {
                string = string.substring("class ".length());
            } else if (string.startsWith("array of ")) {
                string = string.substring("array of ".length());
            }
            StringBuffer stringBuffer = new StringBuffer();
            object2 = null;
            long l = 0L;
            object = this.hi.getHav().raf;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getStringBaseLocation());
                    for (int i = 0; i < this.hi.getHav().getNameTableLength(); ++i) {
                        byte by;
                        l = this.hi.getHav().raf.getFilePointer() - this.hi.getHav().getStringBaseLocation();
                        while ((by = this.hi.getHav().raf.readByte()) != 0) {
                            stringBuffer.append((char)by);
                        }
                        object2 = stringBuffer.toString();
                        if (((String)object2).compareTo(string) == 0) {
                            bl = true;
                            break;
                        }
                        stringBuffer.setLength(0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Cannot find Type : " + string, "Type not found", 0);
                return;
            }
        } else {
            if (string.startsWith("class ")) {
                string = string.substring("class ".length());
            } else if (string.startsWith("array of ")) {
                string = string.substring("array of ".length());
            }
            n = Arrays.binarySearch(this.hi.getNameTable(), string);
            if (n < 0) {
                try {
                    for (int i = 0; i < this.hi.getNameTable().length; ++i) {
                        if (!this.hi.getNameTable(i).matches(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    JOptionPane.showMessageDialog(this, "Cannot find Type with expression: " + string, "Invalid regular expression", 0);
                    return;
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(this, "Cannot find Type : " + string, "Type not found", 0);
                    return;
                }
            }
        }
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Type " + string, this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/list_type.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        object2 = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener((ActionListener)object2);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener((ActionListener)object2);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.addActionListener((ActionListener)object2);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener((ActionListener)object2);
        jPopupMenu.add(jMenuItem);
        object = new PopupListener(jPopupMenu);
        ((Component)object2).addMouseListener((MouseListener)object);
        ((JTable)object2).setDragEnabled(true);
        ((JTable)object2).getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView((Component)object2);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        TableThreadSearch tableThreadSearch = new TableThreadSearch((JTable)object2, this.hi, n, string);
        tableThreadSearch.start();
    }

    public HeapTree newTreeView() {
        HeapTree heapTree;
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Tree View", this.hi, this.ha);
        heapFrame.fileName = this.hi.getFile().getName();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/tree.gif"));
        heapFrame.setFrameIcon(imageIcon);
        DropProgressDialog dropProgressDialog = new DropProgressDialog(this.ha);
        Dimension dimension = dropProgressDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        dropProgressDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        heapFrame.ht = heapTree = this.ha.addLeakSuspectView(this.hi, heapFrame, null, false);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        return heapTree;
    }

    public long returnTreeDepth(long l) {
        long l2 = 0L;
        if (this.hi.isHav()) {
            if (l == -1L) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
                return -1L;
            }
            while (this.hi.getHav().getParent(l) >= 0L) {
                ++l2;
                l = this.hi.getHav().getParent(l);
            }
            return l2;
        }
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return -1L;
        }
        while (this.hi.getParent()[(int)l] >= 0) {
            ++l2;
            l = this.hi.getParent()[(int)l];
        }
        return l2;
    }

    public TreePath returnTreePath(long l) {
        if (this.hi.isHav()) {
            if (l == -1L) {
                JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
                return null;
            }
            Vector<Node> vector = new Vector<Node>();
            vector.add(0, new Node(true, l));
            while (this.hi.getHav().getParent(l) >= 0L) {
                vector.add(0, new Node(true, this.hi.getHav().getParent(l)));
                l = this.hi.getHav().getParent(l);
            }
            Object[] objectArray = this.ht.getPathForRow(0).getPath();
            vector.add(0, (Node)objectArray[0]);
            Object[] objectArray2 = vector.toArray();
            Object[] objectArray3 = new Node[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[i] = (Node)objectArray2[i];
            }
            return new TreePath(objectArray3);
        }
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        vector.add(0, new Node((int)l));
        while (this.hi.getParent()[(int)l] >= 0) {
            vector.add(0, new Node(this.hi.getParent()[(int)l]));
            l = this.hi.getParent()[(int)l];
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray4 = vector.toArray();
        Object[] objectArray5 = new Node[objectArray4.length];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray5[i] = (Node)objectArray4[i];
        }
        return new TreePath(objectArray5);
    }

    public HeapTree newTreeView21() {
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Tree View", this.hi, this.ha);
        heapFrame.fileName = this.hi.getFile().getName();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/tree.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.menuBar = new JMenuBar();
        heapFrame.menu = new JMenu("Go to Bookmark");
        heapFrame.menu.setMnemonic('G');
        heapFrame.menu.setIcon(new ImageIcon(this.getClass().getResource("/bookmark.gif")));
        heapFrame.removeMenu = new JMenu("Remove Bookmark");
        heapFrame.removeMenu.setMnemonic('R');
        heapFrame.removeMenu.setIcon(new ImageIcon(this.getClass().getResource("/remove_bookmark.gif")));
        heapFrame.leakMenu = new JMenu("Leak Suspects");
        heapFrame.leakMenu.setMnemonic('L');
        heapFrame.leakMenu.setIcon(new ImageIcon(this.getClass().getResource("/leak.gif")));
        heapFrame.removeMenu.setEnabled(false);
        heapFrame.menu.setEnabled(false);
        heapFrame.leakMenu.setEnabled(false);
        heapFrame.menuBar.add(heapFrame.menu);
        heapFrame.menuBar.add(heapFrame.removeMenu);
        heapFrame.menuBar.add(heapFrame.leakMenu);
        heapFrame.setJMenuBar(heapFrame.menuBar);
        HeapTree heapTree = new HeapTree(this.hi, this.ha, false);
        heapTree.hf = heapFrame;
        DropProgressDialog dropProgressDialog = new DropProgressDialog(this.ha);
        Dimension dimension = dropProgressDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        dropProgressDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        heapFrame.JScrollPaneSetViewportView(heapTree);
        heapFrame.ht = heapTree;
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        return heapTree;
    }
}

