/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.BigTask;
import com.ibm.jinwoo.heap.DropProgressDialog;
import com.ibm.jinwoo.heap.DropTask;
import com.ibm.jinwoo.heap.ExpandTask;
import com.ibm.jinwoo.heap.FindAddressView;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapCache;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTable;
import com.ibm.jinwoo.heap.LeakTask;
import com.ibm.jinwoo.heap.MyRenderer;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.NumberCellRenderer;
import com.ibm.jinwoo.heap.ParentSearch;
import com.ibm.jinwoo.heap.PopupListener;
import com.ibm.jinwoo.heap.SearchTableModel;
import com.ibm.jinwoo.heap.SuspectTask;
import com.ibm.jinwoo.heap.TableThreadSearch;
import com.ibm.jinwoo.heap.TreeSelection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class HeapTree
extends JTree
implements ActionListener,
TreeWillExpandListener {
    HeapTree newHeapTree;
    private DropTask task;
    private LeakTask ltask;
    private BigTask btask;
    private SuspectTask stask;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    Vector vector = null;
    Node root = null;
    HeapAnalyzer ha = null;
    HeapInfo hi;
    int adjustedThreshold;
    private Timer timer;
    private Timer ltimer;
    private Timer btimer;
    private Timer stimer;
    public HeapFrame hf = null;
    public JMenuItem compileMenuItem = null;
    public JMenuItem moreParentsMenuItem = null;
    public JMenuItem showFromRootsMenuItem = null;

    public HeapTree(HeapInfo heapInfo, HeapAnalyzer heapAnalyzer) {
        super(new HeapModel(heapInfo));
        this.getSelectionModel().setSelectionMode(4);
        this.setDragEnabled(true);
        TreeSelection treeSelection = new TreeSelection();
        treeSelection.setPercentage(heapAnalyzer.cfg.percentage);
        this.setTransferHandler(treeSelection);
        this.setCellRenderer(new MyRenderer(heapInfo, (HeapModel)this.getModel(), heapAnalyzer.cfg.percentage));
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addTreeWillExpandListener(this);
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Search for total size drop");
        jMenuItem.setMnemonic('t');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/drop.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Go to the largest drop in subtrees");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/biggest_drop.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Locate a leak suspect");
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/leak.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Detailed node information");
        jMenuItem.setMnemonic('n');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find an address");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/address.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same type");
        jMenuItem.setMnemonic('y');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('i');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('s');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Show more children");
        jMenuItem.setMnemonic('m');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/more_child.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.moreParentsMenuItem = new JMenuItem("Show more parents");
        this.moreParentsMenuItem.setMnemonic('p');
        this.moreParentsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/more_parent.gif")));
        this.moreParentsMenuItem.addActionListener(this);
        this.moreParentsMenuItem.setEnabled(false);
        jPopupMenu.add(this.moreParentsMenuItem);
        this.showFromRootsMenuItem = new JMenuItem("Show from roots");
        this.showFromRootsMenuItem.setMnemonic('r');
        this.showFromRootsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/root_tree.gif")));
        this.showFromRootsMenuItem.addActionListener(this);
        this.showFromRootsMenuItem.setEnabled(false);
        jPopupMenu.add(this.showFromRootsMenuItem);
        jMenuItem = new JMenuItem("Add Bookmark");
        jMenuItem.setMnemonic('A');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/add_bookmark.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu, this);
        this.addMouseListener(popupListener);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.task.getCurrent()) + "th tree...");
                String string = HeapTree.this.task.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.timer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.task.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.ltimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.ltask.getCurrent()) + "th tree...");
                String string = HeapTree.this.ltask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.ltask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.ltimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.ltask.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.btimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.btask.getCurrent()) + "th tree...");
                String string = HeapTree.this.btask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.btask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.btimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.btask.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.stimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.stask.getCurrent()) + "th tree...");
                String string = HeapTree.this.stask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.stask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.stimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.stask.getCurrent()) + " trees are being analyzed...");
                }
            }
        });
    }

    public HeapTree(HeapInfo heapInfo, HeapAnalyzer heapAnalyzer, boolean bl) {
        if (bl) {
            this.setModel(new HeapModel(heapInfo));
            this.setCellRenderer(new MyRenderer(heapInfo, (HeapModel)this.getModel(), heapAnalyzer.cfg.percentage));
        }
        this.getSelectionModel().setSelectionMode(4);
        this.setDragEnabled(true);
        TreeSelection treeSelection = new TreeSelection();
        treeSelection.setPercentage(heapAnalyzer.cfg.percentage);
        this.setTransferHandler(treeSelection);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addTreeWillExpandListener(this);
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Search for total size drop");
        jMenuItem.setMnemonic('t');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/drop.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Go to the largest drop in subtrees");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/biggest_drop.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Locate a leak suspect");
        jMenuItem.setMnemonic('L');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/leak.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Detailed node information");
        jMenuItem.setMnemonic('n');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find an address");
        jMenuItem.setMnemonic('F');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/address.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same type");
        jMenuItem.setMnemonic('y');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('i');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('s');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Show more children");
        jMenuItem.setMnemonic('m');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/more_child.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.moreParentsMenuItem = new JMenuItem("Show more parents");
        this.moreParentsMenuItem.setMnemonic('p');
        this.moreParentsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/more_parent.gif")));
        this.moreParentsMenuItem.addActionListener(this);
        this.moreParentsMenuItem.setEnabled(false);
        jPopupMenu.add(this.moreParentsMenuItem);
        this.showFromRootsMenuItem = new JMenuItem("Show from roots");
        this.showFromRootsMenuItem.setMnemonic('r');
        this.showFromRootsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/root_tree.gif")));
        this.showFromRootsMenuItem.addActionListener(this);
        this.showFromRootsMenuItem.setEnabled(false);
        jPopupMenu.add(this.showFromRootsMenuItem);
        jMenuItem = new JMenuItem("Add Bookmark");
        jMenuItem.setMnemonic('A');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/add_bookmark.gif")));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu, this);
        this.addMouseListener(popupListener);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.task.getCurrent()) + "th tree...");
                String string = HeapTree.this.task.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.task.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.timer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.task.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.ltimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.ltask.getCurrent()) + "th tree...");
                String string = HeapTree.this.ltask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.ltask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.ltimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.ltask.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.btimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.btask.getCurrent()) + "th tree...");
                String string = HeapTree.this.btask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.btask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.btimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.btask.getCurrent()) + " trees are expanded...");
                }
            }
        });
        this.stimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapTree.this.ha.dp.setProgressText("   Traversing " + numberFormatter.format(HeapTree.this.stask.getCurrent()) + "th tree...");
                String string = HeapTree.this.stask.getMessage();
                if (string != null) {
                    // empty if block
                }
                if (HeapTree.this.stask.isDone()) {
                    Toolkit.getDefaultToolkit().beep();
                    HeapTree.this.stimer.stop();
                    HeapTree.this.ha.dp.setProgressText("   Please wait while " + numberFormatter.format(HeapTree.this.stask.getCurrent()) + " trees are being analyzed...");
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        Node node = (Node)this.getLastSelectedPathComponent();
        if (jMenuItem.getText().startsWith("List children")) {
            HeapInfo heapInfo = ((HeapModel)this.getModel()).hi;
            if (heapInfo == null) {
                return;
            }
            if (node.getIndex() != -1) {
                this.listChildren(node);
            }
        } else if (jMenuItem.getText().startsWith("List parents")) {
            HeapInfo heapInfo = ((HeapModel)this.getModel()).hi;
            if (heapInfo == null) {
                return;
            }
            if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            if (node.getIndex() != -1) {
                this.listParents(node);
            }
        } else if (jMenuItem.getText().startsWith("List same type")) {
            HeapInfo heapInfo = ((HeapModel)this.getModel()).hi;
            if (heapInfo == null) {
                return;
            }
            if (heapInfo.isLoading() && !heapInfo.isLoadCompleted()) {
                JOptionPane.showMessageDialog(this, "Caching is in progress. Please wait until caching is completed", "Information", 1);
                return;
            }
            if (node.getIndex() != -1) {
                this.listTypes(node);
            }
        } else if (jMenuItem.getText().startsWith("Find")) {
            FindAddressView findAddressView = new FindAddressView((Frame)this.ha, this.hi, this);
            Dimension dimension = findAddressView.getPreferredSize();
            Dimension dimension2 = this.ha.getSize();
            Point point = this.ha.getLocation();
            findAddressView.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
            findAddressView.show();
        } else if (jMenuItem.getText().startsWith("Search")) {
            if (this.ha.dp != null) {
                this.ha.dp.show();
            }
            this.task = new DropTask(this, this.ha, this.hi, node, (int)HeapAnalyzer.MIN_DROP, this.getSelectionPath());
            this.task.go();
            this.timer.start();
        } else if (jMenuItem.getText().startsWith("Go to")) {
            if (this.ha.dp != null) {
                this.ha.dp.show();
            }
            this.btask = new BigTask(this, this.ha, this.hi, node, this.getSelectionPath());
            this.btask.go();
            this.btimer.start();
        } else if (jMenuItem.getText().startsWith("Compile")) {
            if (this.ha.dp != null) {
                this.ha.dp.show();
            }
            this.stask = new SuspectTask(this, this.ha, this.hi, node, this.getSelectionPath());
            this.stask.go();
            this.stimer.start();
        } else if (jMenuItem.getText().startsWith("Add")) {
            if (node.isDup()) {
                JOptionPane.showMessageDialog(this.ha, "Cannot bookmark child node under non-owner object. The same object under owner object will be added to bookmark", "Add Bookmark", 1);
            }
            String string = this.hi.isHav() ? (node.getLocation() == -1L ? this.hi.nextID() + " Root" : this.hi.nextID() + " " + this.hi.getHav().getNameHeap(node.getLocation())) : (node.getIndex() == -1 ? this.hi.nextID() + " Root" : this.hi.nextID() + " " + this.hi.getName(node.getIndex()));
            this.hf.menu.setEnabled(true);
            this.hf.removeMenu.setEnabled(true);
            JMenuItem jMenuItem2 = new JMenuItem(string);
            JMenuItem jMenuItem3 = new JMenuItem(" " + string);
            this.hf.menu.add(jMenuItem2);
            this.hf.removeMenu.add(jMenuItem3);
            jMenuItem2.addActionListener(this.hf);
            jMenuItem3.addActionListener(this.hf);
            this.hi.bookMark.put(string, node);
        } else if (jMenuItem.getText().startsWith("Show more children")) {
            node.setNumberOfChildren(node.getNumberOfChildren() + (int)HeapAnalyzer.SUBTREE);
            ((HeapModel)this.getModel()).fireTreeStructureChanged(this.getSelectionPath());
        } else if (jMenuItem.getText().startsWith("Show from roots")) {
            Node node2 = ((HeapModel)this.getModel()).rootPerson;
            Node node3 = null;
            node3 = this.hi.isHav() ? new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE) : new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
            this.showFromRootsMenuItem.setEnabled(false);
            ((HeapModel)this.getModel()).rootPerson = node3;
            ((HeapModel)this.getModel()).fireTreeStructureChanged(node2);
        } else if (jMenuItem.getText().startsWith("Show more parents")) {
            int n;
            if (node.isDup()) {
                JOptionPane.showMessageDialog(this.ha, "Cannot show more parents under non-owner objects", "Show more parents", 1);
                return;
            }
            if (((HeapModel)this.getModel()).rootPerson.getIndex() == -1) {
                this.moreParentsMenuItem.setEnabled(false);
                return;
            }
            Vector<Node> vector = new Vector<Node>();
            Node node4 = null;
            if (this.hi.isHav()) {
                vector.add(0, new Node(true, node.getLocation()));
                n = 0;
                long l = node.getLocation();
                if (l != ((HeapModel)this.getModel()).rootPerson.getLocation()) {
                    while (this.hi.getHav().getParent(l) != ((HeapModel)this.getModel()).rootPerson.getLocation()) {
                        vector.add(0, new Node(true, this.hi.getHav().getParent(l)));
                        l = this.hi.getHav().getParent(l);
                    }
                }
                while (this.hi.getHav().getParent(l) >= 0L && (long)n < HeapAnalyzer.SUBTREE) {
                    vector.add(0, new Node(true, this.hi.getHav().getParent(l)));
                    l = this.hi.getHav().getParent(l);
                    ++n;
                }
                if (this.hi.getHav().getParent(l) == -1L) {
                    node4 = new Node(true, -1, (int)HeapAnalyzer.MAX_SUBTREE);
                    this.moreParentsMenuItem.setEnabled(false);
                } else {
                    node4 = new Node(true, this.hi.getHav().getParent(l), (int)HeapAnalyzer.MAX_SUBTREE);
                }
                vector.add(0, node4);
            } else {
                vector.add(0, new Node(node.getIndex()));
                n = 0;
                int n2 = node.getIndex();
                if (n2 != ((HeapModel)this.getModel()).rootPerson.getIndex()) {
                    while (this.hi.getParent()[n2] != ((HeapModel)this.getModel()).rootPerson.getIndex()) {
                        vector.add(0, new Node(this.hi.getParent()[n2]));
                        n2 = this.hi.getParent()[n2];
                    }
                }
                while (this.hi.getParent()[n2] >= 0 && (long)n < HeapAnalyzer.SUBTREE) {
                    vector.add(0, new Node(this.hi.getParent()[n2]));
                    n2 = this.hi.getParent()[n2];
                    ++n;
                }
                if (this.hi.getParent()[n2] == -1) {
                    node4 = new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
                    this.moreParentsMenuItem.setEnabled(false);
                } else {
                    node4 = new Node(this.hi.getParent()[n2], (int)HeapAnalyzer.MAX_SUBTREE);
                }
                vector.add(0, node4);
            }
            Object[] objectArray = vector.toArray();
            Object[] objectArray2 = new Node[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = (Node)objectArray[i];
            }
            TreePath treePath = new TreePath(objectArray2);
            if (treePath == null) {
                return;
            }
            Node node5 = ((HeapModel)this.getModel()).rootPerson;
            ((HeapModel)this.getModel()).rootPerson = node4;
            ((HeapModel)this.getModel()).fireTreeStructureChanged(node5);
            ExpandTask expandTask = new ExpandTask(this, this.ha, treePath, true);
            expandTask.go();
        } else if (jMenuItem.getText().startsWith("Locate")) {
            if (this.ha.dp != null) {
                this.ha.dp.show();
            }
            this.ltask = new LeakTask(this, this.ha, this.hi, node, this.getSelectionPath());
            this.ltask.go();
            this.ltimer.start();
        } else if (jMenuItem.getText().startsWith("Detailed")) {
            Object object;
            HeapInfo heapInfo = ((HeapModel)this.getModel()).hi;
            if (heapInfo == null) {
                return;
            }
            JTextArea jTextArea = new JTextArea();
            HeapFrame heapFrame = null;
            jTextArea.setEditable(false);
            jTextArea.setDragEnabled(true);
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Property");
            defaultTableModel.addColumn("Value");
            Object[] objectArray = new String[2];
            if (node.isHav()) {
                heapFrame = node.getIndex() != -1 ? (heapInfo.isAddress64() ? new HeapFrame(heapInfo.getHav().getNameHeap(node.getLocation()) + " at 0x" + Long.toHexString(heapInfo.getHav().getAddress(node.getLocation()))) : new HeapFrame(heapInfo.getHav().getNameHeap(node.getLocation()) + " at 0x" + Integer.toHexString((int)heapInfo.getHav().getAddress(node.getLocation())))) : new HeapFrame("Heap dump roots");
                if (node.getIndex() == -1) {
                    jTextArea.append("Heap dump roots\nNumber of roots : " + numberFormatter.format(heapInfo.getHav().getRootChildrenLength()));
                } else {
                    object = new String();
                    if (heapInfo == null) {
                        return;
                    }
                    object = heapInfo.isAddress64() ? (String)object + "Address : 0x" + Long.toHexString(heapInfo.getHav().getAddress(node.getLocation())) + "\n" : (String)object + "Address : 0x" + Integer.toHexString((int)heapInfo.getHav().getAddress(node.getLocation())) + "\n";
                    object = (String)object + "Object : " + heapInfo.getHav().getNameHeap(node.getLocation()) + "\n";
                    long l = heapInfo.getHav().getNChild(node.getLocation());
                    object = l == 0L ? (String)object + "Number of children : 0 (This is a leaf node)\n" : (String)object + "Number of children : " + numberFormatter.format(l) + "\n";
                    if (heapInfo.getHav().getParent(node.getLocation()) >= 0L) {
                        object = (String)object + "Owner address: 0x" + Long.toHexString(heapInfo.getHav().getAddress(heapInfo.getHav().getParent(node.getLocation()))) + "\n";
                        object = (String)object + "Owner object: " + heapInfo.getHav().getNameHeap(heapInfo.getHav().getParent(node.getLocation())) + "\n";
                    }
                    object = (String)object + "Size : " + numberFormatter.format(heapInfo.getHav().getSize(node.getLocation())) + "\n";
                    object = (String)object + "Total size : " + numberFormatter.format(heapInfo.getHav().getTotal(node.getLocation())) + "\n";
                    System.out.println((String)object);
                    object = (String)object + "HAV IDX=" + node.getIndex() + " LOC=" + node.getLocation() + " C.IDX=" + heapInfo.getHav().getIndexOfChild(heapInfo.getHav().getParent(node.getLocation()), node.getLocation());
                    jTextArea.append((String)object);
                }
            } else {
                heapFrame = node.getIndex() != -1 ? (heapInfo.isAddress64() ? new HeapFrame(heapInfo.getName(node.getIndex()) + " at 0x" + Long.toHexString(heapInfo.getAddress(node.getIndex()))) : new HeapFrame(heapInfo.getName(node.getIndex()) + " at 0x" + Integer.toHexString((int)heapInfo.getAddress(node.getIndex())))) : new HeapFrame("Heap dump roots");
                if (node.getIndex() == -1) {
                    objectArray[0] = "Number of roots";
                    objectArray[1] = numberFormatter.format(heapInfo.getRootChildrenLength());
                    defaultTableModel.addRow(objectArray);
                } else {
                    object = new String();
                    if (heapInfo == null) {
                        return;
                    }
                    if (heapInfo.isSuspect(node.getIndex())) {
                        objectArray[0] = "Leak suspect";
                        objectArray[1] = "Responsible for " + numberFormatter.format(heapInfo.getTotal(node.getIndex())) + " bytes (" + 100.0f * (float)heapInfo.getTotal(node.getIndex()) / (float)heapInfo.getHeapSize() + " %) of Java heap";
                        defaultTableModel.addRow(objectArray);
                    }
                    objectArray[0] = "Address";
                    objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(node.getIndex())) : "0x" + Integer.toHexString((int)heapInfo.getAddress(node.getIndex()));
                    defaultTableModel.addRow(objectArray);
                    objectArray[0] = "Name";
                    objectArray[1] = heapInfo.getName(node.getIndex());
                    defaultTableModel.addRow(objectArray);
                    if (heapInfo.getChild()[node.getIndex()] == null) {
                        objectArray[0] = "Number of children";
                        objectArray[1] = "0 (This is a leaf node)";
                        defaultTableModel.addRow(objectArray);
                    } else {
                        objectArray[0] = "Number of children";
                        objectArray[1] = numberFormatter.format(heapInfo.getChild()[node.getIndex()].length);
                        defaultTableModel.addRow(objectArray);
                    }
                    objectArray[0] = "Number of parents";
                    objectArray[1] = heapInfo.getParentsList()[node.getIndex()] == null ? "0 (This is a root node)" : numberFormatter.format(heapInfo.getParentsList()[node.getIndex()].length);
                    defaultTableModel.addRow(objectArray);
                    if (heapInfo.getParent()[node.getIndex()] >= 0) {
                        objectArray[0] = "Owner address";
                        objectArray[1] = heapInfo.isAddress64() ? "0x" + Long.toHexString(heapInfo.getAddress(heapInfo.getParent()[node.getIndex()])) : "0x" + Integer.toHexString((int)heapInfo.getAddress(heapInfo.getParent()[node.getIndex()]));
                        defaultTableModel.addRow(objectArray);
                        objectArray[0] = "Owner object";
                        objectArray[1] = heapInfo.getName(heapInfo.getParent()[node.getIndex()]);
                        defaultTableModel.addRow(objectArray);
                    }
                    object = (String)object + "Size : " + numberFormatter.format(heapInfo.getSize(node.getIndex())) + "\n";
                    object = (String)object + "Total size : " + numberFormatter.format(heapInfo.getTotal(node.getIndex())) + "\n";
                    objectArray[0] = "Size";
                    objectArray[1] = numberFormatter.format(heapInfo.getSize(node.getIndex()));
                    defaultTableModel.addRow(objectArray);
                    objectArray[0] = "Total size";
                    objectArray[1] = numberFormatter.format(heapInfo.getTotal(node.getIndex()));
                    defaultTableModel.addRow(objectArray);
                    heapInfo.addStackTraceString2Model(node.getIndex(), defaultTableModel);
                    heapInfo.addFieldList2Model(node.getIndex(), defaultTableModel);
                }
            }
            object = new ImageIcon(this.getClass().getResource("/detail.gif"));
            heapFrame.setFrameIcon((Icon)object);
            JTable jTable = new JTable();
            jTable.setCellSelectionEnabled(true);
            jTable.setDragEnabled(true);
            heapFrame.hi = heapInfo;
            jTable.setModel(defaultTableModel);
            heapFrame.JScrollPaneSetViewportView(jTable);
            heapFrame.pack();
            this.ha.getJDesktopPane1().add(heapFrame);
            this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChildren(Node node) {
        HeapFrame heapFrame;
        long l;
        if (node.isHav()) {
            l = node.getLocation();
            heapFrame = this.hi.isAddress64() ? new HeapFrame(this.hi.getFile().getName() + " Children of 0x" + Long.toHexString(this.hi.getHav().getAddress(l))) : new HeapFrame(this.hi.getFile().getName() + " Children of 0x" + Integer.toHexString((int)this.hi.getHav().getAddress(l)));
        } else {
            l = node.getIndex();
            if (this.hi.getChild()[(int)l] == null || this.hi.getChild()[(int)l].length == 0) {
                JOptionPane.showMessageDialog(this.ha, "This is a leaf object. There's no children of this object", "Information", 1);
                return;
            }
            heapFrame = this.hi.isAddress64() ? new HeapFrame(this.hi.getFile().getName() + " Children of 0x" + Long.toHexString(this.hi.getAddress((int)l)), this.hi) : new HeapFrame(this.hi.getFile().getName() + " Children of 0x" + Integer.toHexString((int)this.hi.getAddress((int)l)), this.hi);
        }
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/child.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        HeapTable heapTable = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.addActionListener(heapTable);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener(heapTable);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        heapTable.addMouseListener(popupListener);
        heapTable.setDragEnabled(true);
        heapTable.getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView(heapTable);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        SearchTableModel searchTableModel = new SearchTableModel(this.hi, 0);
        searchTableModel.setTableHeader(heapTable.getTableHeader());
        int n = 0;
        if (searchTableModel.sortedArrary == null) {
            int n2;
            if (node.isHav()) {
                Object object;
                n2 = this.hi.getHav().getNChild(l);
                System.out.println("Requesting " + numberFormatter.format(n2 * 4) + " bytes of Java heap.");
                searchTableModel.sortedArrary = new long[2][n2];
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                HeapCache heapCache = null;
                heapCache = this.hi.getHav().getHeapCache(l);
                if (heapCache == null) {
                    try {
                        object = this.hi.getHav().raf;
                        synchronized (object) {
                            this.hi.getHav().raf.seek(l + this.hi.getHav().getHeapBaseLocation());
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().read(this.hi.getHav().raf);
                            this.hi.getHav().readName(this.hi.getHav().raf);
                            long l6 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                            this.hi.getHav().raf.seek(l6 + this.hi.getHav().getHeapBaseLocation());
                            this.hi.getHav().read(this.hi.getHav().raf);
                            n2 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                            if (n2 > 0) {
                                for (int i = 0; i < n2; ++i) {
                                    searchTableModel.sortedArrary[1][n] = this.hi.getHav().read(this.hi.getHav().raf);
                                    l2 = this.hi.getHav().raf.getFilePointer();
                                    this.hi.getHav().raf.seek(searchTableModel.sortedArrary[1][n] + this.hi.getHav().getHeapBaseLocation());
                                    this.hi.getHav().read(this.hi.getHav().raf);
                                    l4 = this.hi.getHav().read(this.hi.getHav().raf);
                                    l5 = l4 + this.hi.getHav().read(this.hi.getHav().raf);
                                    searchTableModel.sortedArrary[0][n++] = l5;
                                    this.hi.getHav().raf.seek(l2);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    n2 = heapCache.getNumberOfChildren();
                    object = null;
                    if (n2 > 0) {
                        for (int i = 0; i < n2; ++i) {
                            object = this.hi.getHav().getHeapCache(heapCache.getChild(i));
                            if (object == null) {
                                try {
                                    RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                                    synchronized (randomAccessFile) {
                                        searchTableModel.sortedArrary[1][n] = heapCache.getChild(i);
                                        this.hi.getHav().raf.seek(searchTableModel.sortedArrary[1][n] + this.hi.getHav().getHeapBaseLocation());
                                        this.hi.getHav().read(this.hi.getHav().raf);
                                        l4 = this.hi.getHav().read(this.hi.getHav().raf);
                                        l5 = l4 + this.hi.getHav().read(this.hi.getHav().raf);
                                        searchTableModel.sortedArrary[0][n++] = l5;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                continue;
                            }
                            searchTableModel.sortedArrary[1][n] = heapCache.getChild(i);
                            searchTableModel.sortedArrary[0][n++] = ((HeapCache)object).getTotalSize();
                        }
                    }
                }
                searchTableModel.columnNames[4] = searchTableModel.columnNames[4] + "(" + numberFormatter.format(n2) + " objects)";
            } else {
                System.out.println("Requesting " + numberFormatter.format(this.hi.getChild()[(int)l].length * 4) + " bytes of Java heap.");
                searchTableModel.sortedArrary = new long[2][this.hi.getChild()[(int)l].length];
                for (n2 = 0; n2 < this.hi.getChild()[(int)l].length; ++n2) {
                    searchTableModel.sortedArrary[0][n] = this.hi.getTotal(this.hi.getChild()[(int)l][n2]);
                    searchTableModel.sortedArrary[1][n++] = this.hi.getChild()[(int)l][n2];
                }
                searchTableModel.columnNames[4] = searchTableModel.columnNames[4] + "(" + numberFormatter.format(this.hi.getChild()[(int)l].length) + " objects)";
            }
            System.out.println("Requesting " + numberFormatter.format(searchTableModel.sortedArrary[0].length * 8) + " bytes of Java heap.");
            searchTableModel.modelArray = new long[2][searchTableModel.sortedArrary[0].length];
            for (n2 = 0; n2 < searchTableModel.sortedArrary[0].length; ++n2) {
                searchTableModel.modelArray[0][n2] = searchTableModel.sortedArrary[0][n2];
                searchTableModel.modelArray[1][n2] = searchTableModel.sortedArrary[1][n2];
            }
            System.out.println("Sorting table by TotalSize.");
            Arrays2.sort(searchTableModel.sortedArrary);
        }
        heapTable.setModel(searchTableModel);
        TableColumnModel tableColumnModel = heapTable.getColumnModel();
        for (int i = 0; i < 6; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(80);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                tableColumn.setPreferredWidth(50);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 5) {
                tableColumn.setPreferredWidth(80);
                continue;
            }
            tableColumn.setPreferredWidth(300);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listParents(Node node) {
        Object object;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        if (node.isHav()) {
            l = node.getLocation();
            long l3 = this.hi.getHav().getHeapBaseLocation();
            try {
                object = this.hi.getHav().raf;
                synchronized (object) {
                    for (int i = 0; i < this.hi.getHav().getNumberOfEntries(); ++i) {
                        this.hi.getHav().raf.seek(l3);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().read(this.hi.getHav().raf);
                        this.hi.getHav().readName(this.hi.getHav().raf);
                        long l4 = this.hi.getHav().raf.readInt() & 0xFFFFFFFF;
                        l3 = this.hi.getHav().raf.getFilePointer();
                        this.hi.getHav().raf.seek(l4 + this.hi.getHav().getHeapBaseLocation());
                        this.hi.getHav().read(this.hi.getHav().raf);
                        l2 = (int)this.hi.getHav().read(this.hi.getHav().raf);
                        if (l2 <= 0L) continue;
                        int n2 = 0;
                        while ((long)n2 < l2) {
                            if (this.hi.getHav().read(this.hi.getHav().raf) == l) {
                                ++n;
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            l = node.getIndex();
            n = this.hi.getParentsList()[(int)l] == null ? 0 : this.hi.getParentsList()[(int)l].length;
            l2 = this.hi.getAddress((int)l);
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(this.ha, "This is a root object. There's no parent of this object", "Information", 1);
            return;
        }
        HeapFrame heapFrame = null;
        heapFrame = this.hi.isAddress64() ? new HeapFrame(this.hi.getFile().getName() + " Parents of 0x" + Long.toHexString(l2), this.hi) : new HeapFrame(this.hi.getFile().getName() + " Parents of 0x" + Integer.toHexString((int)l2), this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/parent.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        object = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener((ActionListener)object);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List same types");
        jMenuItem.setMnemonic('L');
        jMenuItem.addActionListener((ActionListener)object);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/list_type.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jMenuItem.addActionListener((ActionListener)object);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener((ActionListener)object);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener((ActionListener)object);
        jPopupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        ((Component)object).addMouseListener(popupListener);
        ((JTable)object).setDragEnabled(true);
        ((JTable)object).getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView((Component)object);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        ParentSearch parentSearch = new ParentSearch((JTable)object, this.hi, l, n);
        parentSearch.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listTypes(Node node) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        boolean bl = false;
        long l = 0L;
        if (node.isHav()) {
            l = node.getLocation();
            string = this.hi.getHav().getObjectNameHeap(l);
            if (string == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            object3 = null;
            long l2 = 0L;
            object2 = this.hi.getHav().stringBuffer;
            object = this.hi.getHav().raf;
            synchronized (object) {
                try {
                    this.hi.getHav().raf.seek(this.hi.getHav().getStringBaseLocation());
                    for (int i = 0; i < this.hi.getHav().getNameTableLength(); ++i) {
                        byte by;
                        l2 = this.hi.getHav().raf.getFilePointer();
                        while ((by = this.hi.getHav().raf.readByte()) != 0) {
                            stringBuffer.append((char)by);
                        }
                        object3 = stringBuffer.toString();
                        if (((String)object3).compareTo(string) == 0) {
                            bl = true;
                            break;
                        }
                        stringBuffer.setLength(0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Cannot find Type : " + string, "Type not found", 0);
                return;
            }
        } else {
            string = this.hi.getName(node.getIndex());
            if (string == null) {
                return;
            }
            if (string.startsWith("class ")) {
                string = string.substring("class ".length());
            } else if (string.startsWith("array of ")) {
                string = string.substring("array of ".length());
            }
            l = Arrays.binarySearch(this.hi.getNameTable(), string);
            if (l < 0L) {
                try {
                    for (int i = 0; i < this.hi.getNameTable().length; ++i) {
                        if (!this.hi.getNameTable(i).matches(string)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    JOptionPane.showMessageDialog(this, "Cannot find Type with expression: " + string, "Invalid regular expression", 0);
                    return;
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(this, "Cannot find Type : " + string, "Type not found", 0);
                    return;
                }
            }
        }
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Type " + string, this.hi);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/list_type.gif"));
        heapFrame.setFrameIcon(imageIcon);
        heapFrame.fileName = this.hi.getFile().getAbsolutePath();
        object3 = new HeapTable(this.hi, this.ha);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Find object in tree view");
        jMenuItem.setMnemonic('F');
        jMenuItem.addActionListener((ActionListener)object3);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List parents");
        jMenuItem.setMnemonic('p');
        jMenuItem.addActionListener((ActionListener)object3);
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/parent.gif")));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("List children");
        jMenuItem.setMnemonic('c');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/child.gif")));
        jMenuItem.addActionListener((ActionListener)object3);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Detailed information");
        jMenuItem.setMnemonic('d');
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detail.gif")));
        jMenuItem.addActionListener((ActionListener)object3);
        jPopupMenu.add(jMenuItem);
        object2 = new PopupListener(jPopupMenu);
        ((Component)object3).addMouseListener((MouseListener)object2);
        ((JTable)object3).setDragEnabled(true);
        ((JTable)object3).getTableHeader().setToolTipText("Click to sort ; Click again to sort in reverse order");
        heapFrame.JScrollPaneSetViewportView((Component)object3);
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        object = new TableThreadSearch((JTable)object3, this.hi, l, string);
        ((Thread)object).start();
    }

    public HeapTree newTree() {
        if (this.hi == null) {
            JOptionPane.showMessageDialog(this, "Please select a heap dump window", "Information", 1);
            return null;
        }
        HeapFrame heapFrame = new HeapFrame(this.hi.getFile().getName() + " Tree View", this.hi, this.ha);
        heapFrame.fileName = this.hi.getFile().getName();
        heapFrame.menuBar = new JMenuBar();
        heapFrame.menu = new JMenu("Go to Bookmark!");
        heapFrame.menu.setMnemonic('G');
        heapFrame.menu.setIcon(new ImageIcon(this.getClass().getResource("/bookmark.gif")));
        heapFrame.removeMenu = new JMenu("Remove Bookmark");
        heapFrame.removeMenu.setMnemonic('R');
        heapFrame.removeMenu.setIcon(new ImageIcon(this.getClass().getResource("/remove_bookmark.gif")));
        heapFrame.leakMenu = new JMenu("Leak Suspects");
        heapFrame.leakMenu.setMnemonic('L');
        heapFrame.leakMenu.setIcon(new ImageIcon(this.getClass().getResource("/leak.gif")));
        heapFrame.removeMenu.setEnabled(false);
        heapFrame.menu.setEnabled(false);
        if (this.hi.leakMenu != null) {
            int n = this.hi.leakMenu.getItemCount();
            if (n > 0) {
                heapFrame.leakMenu = this.hi.leakMenu;
                for (int i = 0; i < n; ++i) {
                    heapFrame.leakMenu.getItem(i).addActionListener(heapFrame);
                }
            }
        } else {
            heapFrame.leakMenu.setEnabled(false);
        }
        heapFrame.menuBar.add(heapFrame.menu);
        heapFrame.menuBar.add(heapFrame.removeMenu);
        heapFrame.menuBar.add(heapFrame.leakMenu);
        heapFrame.setJMenuBar(heapFrame.menuBar);
        HeapTree heapTree = new HeapTree(this.hi, this.ha);
        heapTree.hf = heapFrame;
        DropProgressDialog dropProgressDialog = new DropProgressDialog(this.ha);
        Dimension dimension = dropProgressDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        dropProgressDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        heapFrame.JScrollPaneSetViewportView(heapTree);
        heapFrame.ht = heapTree;
        this.ha.getJDesktopPane1().add(heapFrame);
        this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
        try {
            heapFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        return heapTree;
    }

    public TreePath returnBigDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        if (this.hi.getTotal(node.getIndex()) <= (long)n) {
            int n2 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
            this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
        } else {
            this.adjustedThreshold = -1;
        }
        while ((l = ((HeapModel)this.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
        }
        return null;
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (treeExpansionEvent == null) {
            return;
        }
        if (treeExpansionEvent.getPath() == null) {
            return;
        }
        Node node = (Node)treeExpansionEvent.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.getIndex() == -2) {
            Node node2 = (Node)treeExpansionEvent.getPath().getParentPath().getLastPathComponent();
            node2.setNumberOfChildren(node2.getNumberOfChildren() + (int)HeapAnalyzer.SUBTREE);
            ((HeapModel)this.getModel()).fireTreeStructureChanged(treeExpansionEvent.getPath().getParentPath());
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }
}

