/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FieldValues;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.JinwooDataInput;
import com.ibm.jinwoo.heap.StackFrame;
import com.ibm.jinwoo.heap.StackTrace;
import com.ibm.jinwoo.heap.SuspectTask;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.beans.PropertyVetoException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class HprofTask {
    static final String[] p = new String[]{"unknown", "java.lang.Object[]", "boolean[]", "char[]", "float[]", "double[]", "byte[]", "short[]", "int[]", "long[]"};
    static final String[] type = new String[]{null, null, "java.lang.Object[]", null, "boolean[]", "char[]", "float[]", "double[]", "byte[]", "short[]", "int[]", "long[]"};
    long heapDumpLocation = 0L;
    boolean PROFILE = false;
    boolean stackTrace = false;
    static final int bufferSize = Integer.MAX_VALUE;
    private boolean isHeadless;
    long startTime = 0L;
    long[] longNameKey = null;
    int[] nameHashKey = null;
    boolean debug = false;
    boolean[] isClass;
    static final int CLASS_SIZE = 76;
    long fileLocation;
    long fileSize;
    private HeapInfo hi = null;
    Hashtable strings = new Hashtable();
    Hashtable classes = new Hashtable();
    List objectList = new ArrayList();
    long totalNodes = 0L;
    long heapDumpSize = 0L;
    long[] primitiveString = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L};
    int objectCount;
    int objectArrayCount;
    int classCount;
    int primitiveArrayCount;
    int totalObjectCount;
    int refCount;
    int zzz = 0;
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    public static final String[] types = new String[]{"bool", "char", "float", "double", "byte", "short", "int", "long"};
    public static final int START_OF_HEADER = 1;
    public static final int START_OF_DUMP = 2;
    public static final int END_OF_DUMP = 3;
    public static final int LONG_OBJECT_RECORD = 4;
    public static final int OBJECT_ARRAY_RECORD = 5;
    public static final int CLASS_RECORD = 6;
    public static final int PRIMITIVE_ARRAY_RECORD = 7;
    public static final int NEW_OBJECT_ARRAY_RECORD = 8;
    public static final int TOTALS = 1;
    public static final int END_OF_HEADER = 2;
    public static final int HASHCODE_RANDOMS = 3;
    public static final int FULL_VERSION = 4;
    JinwooDataInput dis;
    String sdkFullVersion;
    boolean isJ9 = false;
    boolean is64 = false;
    boolean sov78432 = false;
    static final long long32bit = 0xFFFFFFFFL;
    int shift = 3;
    int version;
    int dumpFlags;
    boolean dbg = false;
    int totalObjects;
    int totalRefs;
    int random1;
    int random2;
    long[] classAddressCache = new long[4];
    long lastAddress;
    int classAddressCacheIndex;
    int sizeOfID;
    long timestamp;
    DefaultTableModel tm = new DefaultTableModel();

    public boolean isStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(boolean bl) {
        this.stackTrace = bl;
    }

    public int[] getNameHashKey() {
        return this.nameHashKey;
    }

    public void setNameHashKey(int[] nArray) {
        this.nameHashKey = nArray;
    }

    public long getNameHashKey(int n) {
        if (this.is64) {
            return this.longNameKey[n];
        }
        return this.nameHashKey[n];
    }

    public long setNameHashKey(int n, long l) {
        if (this.is64) {
            this.longNameKey[n] = l;
            return this.longNameKey[n];
        }
        this.nameHashKey[n] = (int)l;
        return this.nameHashKey[n];
    }

    public HprofTask(HeapAnalyzer heapAnalyzer, File file) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.lengthOfTask = 1000;
    }

    public HprofTask(HeapAnalyzer heapAnalyzer, File file, JDialogProgress jDialogProgress) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = jDialogProgress;
        this.lengthOfTask = 100;
    }

    public HprofTask(File file) {
        this.file = file;
        this.lengthOfTask = 100;
        this.setHeadless();
    }

    public long firstPass() {
        this.totalNodes = 0L;
        byte[] byArray = new byte[19];
        this.overall = 0;
        this.statMessage = "Loading heap dump file";
        this.fileLocation = 0L;
        this.current = 0;
        this.hi.setStringsHashTable(this.strings);
        this.hi.setStackTrace(new Hashtable());
        this.hi.setStackFrame(new Hashtable());
        if (!this.isHeadless()) {
            this.jp.getJProgressBar1().setMaximum(100);
        }
        try {
            this.fileSize = this.file.length();
            if (this.debug) {
                System.out.println("file size=" + this.fileSize);
            }
            InputStream inputStream = this.getInputStream(this.file);
            this.hi.dis = this.dis = new JinwooDataInput(this.file, "r");
            byte by = this.dis.bufferedReadByte();
            ++this.fileLocation;
            int n = 0;
            while (by != 0) {
                byArray[n++] = by;
                by = this.dis.bufferedReadByte();
                ++this.fileLocation;
            }
            if (this.debug) {
                System.out.println(new String(byArray));
            }
            this.sizeOfID = this.dis.bufferedReadInt();
            if (this.sizeOfID == 8) {
                this.is64 = true;
                this.getHeapInfo().setAddress64(true);
            }
            this.timestamp = this.dis.bufferedReadLong();
            this.fileLocation += 12L;
            this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Timestamp: " + new Date(this.timestamp) + "\n");
            HeapInfo.addRow2TableModel("Timestamp", new Date(this.timestamp).toString(), this.tm);
            if (this.debug) {
                System.out.println("size of ID=" + this.sizeOfID + " timestamp=" + new Date(this.timestamp));
            }
            n = 0;
            while (true) {
                int n2;
                int n3;
                int n4;
                this.current = (int)(100.0f * (float)this.fileLocation / (float)this.fileSize);
                this.overall = (int)(30.0f * (float)this.fileLocation / (float)this.fileSize);
                byte by2 = this.dis.bufferedReadByte();
                ++this.fileLocation;
                if (by2 == 1) {
                    n4 = this.dis.bufferedReadInt();
                    n3 = this.dis.bufferedReadInt();
                    long l = this.is64 ? this.dis.bufferedReadLong() : (long)this.dis.bufferedReadInt();
                    this.fileLocation += (long)(8 + this.sizeOfID);
                    if (n3 <= 4) continue;
                    String string = null;
                    byte[] byArray2 = null;
                    if (this.is64) {
                        try {
                            if (n3 > 8) {
                                byArray2 = this.readBytes(n3 - 8);
                                if (byArray2 == null) {
                                    return -1L;
                                }
                                string = new String(byArray2);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        this.fileLocation += (long)(n3 - 8);
                    } else if (n3 > 4) {
                        byArray2 = this.readBytes(n3 - 4);
                        if (byArray2 == null) {
                            return -1L;
                        }
                        string = new String(byArray2);
                        this.fileLocation += (long)(n3 - 4);
                    }
                    if (string == null) {
                        string = "";
                    }
                    if (this.is64) {
                        this.strings.put(new Long(l), string);
                    } else {
                        this.strings.put(new Integer((int)l), string);
                    }
                    this.markPrimitive(l, string);
                    continue;
                }
                if (by2 == 12 || by2 == 28) {
                    n4 = this.dis.bufferedReadInt();
                    long l = this.dis.bufferedU4();
                    this.fileLocation += 8L;
                    this.heapDumpLocation = this.dis.getFilePointer();
                    if (this.debug) {
                        System.out.println("Start of heap dump. length=" + l);
                    }
                    this.heapDumpSize = l;
                    this.readHeapDump(this.heapDumpSize, 1);
                    if (!this.debug) continue;
                    System.out.println("End of heap dump");
                    continue;
                }
                if (by2 == 2) {
                    if (this.debug) {
                        System.out.println("load class parsing");
                    }
                    n4 = this.dis.bufferedReadInt();
                    n3 = this.dis.bufferedReadInt();
                    this.dis.skipBytes(4);
                    long l = this.readID();
                    this.dis.skipBytes(4);
                    long l2 = this.readID();
                    this.fileLocation += (long)(16 + 2 * this.sizeOfID);
                    ClassTable classTable = (ClassTable)this.classes.get(new Long(l));
                    if (classTable == null) {
                        classTable = new ClassTable(l2, 0, null, 0L);
                        this.classes.put(new Long(l), classTable);
                    } else if (classTable.nameID == -1L) {
                        classTable.nameID = l2;
                        this.classes.put(new Long(l), classTable);
                    }
                    if (!this.debug) continue;
                    System.out.println("Load class 0x" + Long.toHexString(l));
                    continue;
                }
                if (by2 == 7) {
                    n4 = this.dis.bufferedReadInt();
                    n3 = this.dis.bufferedReadInt();
                    int n5 = this.dis.bufferedReadInt();
                    n2 = this.dis.bufferedReadInt();
                    long l = this.dis.bufferedReadLong();
                    long l3 = this.dis.bufferedReadLong();
                    System.out.println("Total live bytes : " + n5 + "\nTotal live instances : " + n2 + "\nTotal bytes allocated : " + l + "\nTotal instances allocated :" + l3);
                    this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Total live bytes : " + n5 + "\nTotal live instances : " + n2 + "\nTotal bytes allocated : " + l + "\nTotal instances allocated :" + l3 + "\n");
                    continue;
                }
                if (by2 == 5) {
                    n4 = this.dis.bufferedReadInt();
                    n3 = this.dis.bufferedReadInt();
                    StackTrace stackTrace = new StackTrace();
                    stackTrace.setStackTraceID(this.dis.bufferedReadInt());
                    stackTrace.setThreadID(this.dis.bufferedReadInt());
                    n2 = this.dis.bufferedReadInt();
                    if (n2 > 0) {
                        stackTrace.setStackFrame(new long[n2]);
                        for (int i = 0; i < n2; ++i) {
                            stackTrace.setStackFrame(i, this.readID());
                        }
                    }
                    this.hi.getStackTrace().put(new Integer(stackTrace.getStackTraceID()), stackTrace);
                    this.fileLocation += (long)(n3 + 8);
                    continue;
                }
                if (by2 == 4) {
                    n4 = this.dis.bufferedReadInt();
                    n3 = this.dis.bufferedReadInt();
                    StackFrame stackFrame = new StackFrame();
                    stackFrame.setStackFrameID(this.readID());
                    stackFrame.setMethodNameID(this.readID());
                    stackFrame.setMethodSigID(this.readID());
                    stackFrame.setSourceFileNameID(this.readID());
                    stackFrame.setClassID(this.dis.bufferedReadInt());
                    stackFrame.setLineNumber(this.dis.bufferedReadInt());
                    this.hi.getStackFrame().put(new Long(stackFrame.getStackFrameID()), stackFrame);
                    this.fileLocation += (long)(n3 + 8);
                    continue;
                }
                if (this.debug) {
                    System.out.println("other tag=" + Integer.toHexString(by2));
                }
                n4 = this.dis.bufferedReadInt();
                n3 = this.dis.bufferedReadInt();
                this.dis.skipBytes(n3);
                this.fileLocation += (long)(n3 + 8);
            }
        }
        catch (EOFException eOFException) {
            if (this.debug) {
                System.out.println("End of file");
            }
            return this.totalNodes;
        }
        catch (IOException iOException) {
            if (!this.isHeadless()) {
                if (this.debug) {
                    System.out.println("IO Exception");
                }
                this.ha.handleException(iOException);
                this.jp.dispose();
                this.done = true;
            } else {
                iOException.printStackTrace();
            }
            return 0L;
        }
    }

    public ClassTable getClass(long l) {
        ClassTable classTable = (ClassTable)this.classes.get(new Long(l));
        if (classTable == null) {
            return null;
        }
        return classTable;
    }

    public int getCurrent() {
        return this.current;
    }

    int getHashCode(long l, int n) throws Exception {
        if (this.isJ9) {
            return this.dis.bufferedReadShort();
        }
        if (n != 0) {
            return this.dis.bufferedReadInt();
        }
        return this.MANGLE(this.Handle2Hash(l));
    }

    public int getIndexFromObject(long l) {
        int n = 0;
        n = this.is64 ? Arrays.binarySearch(this.getHeapInfo().getAddressLong(), l) : Arrays.binarySearch(this.getHeapInfo().getAddress(), (int)(l & 0xFFFFFFFFL));
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public long getIndexOfPrimitiveArray(int n) {
        switch (n) {
            case 2: {
                return this.primitiveString[1];
            }
            case 4: {
                return this.primitiveString[2];
            }
            case 5: {
                return this.primitiveString[3];
            }
            case 6: {
                return this.primitiveString[4];
            }
            case 7: {
                return this.primitiveString[5];
            }
            case 8: {
                return this.primitiveString[6];
            }
            case 9: {
                return this.primitiveString[7];
            }
            case 10: {
                return this.primitiveString[8];
            }
            case 11: {
                return this.primitiveString[9];
            }
        }
        System.out.println("(sizeOfType) Unknown type=" + Integer.toHexString(n));
        return -1L;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public String getName(long l) {
        if (l == -1L) {
            return "UNKNOWN";
        }
        String string = null;
        string = this.is64 ? (String)this.strings.get(new Long(l)) : (String)this.strings.get(new Integer((int)l));
        if (string == null) {
            System.out.println("Cannot find string ID 0x" + Long.toHexString(l));
            return null;
        }
        return string;
    }

    public int getOverall() {
        return this.overall;
    }

    public int getRefs(long l) {
        int n = 0;
        ClassTable classTable = this.getClass(l);
        while (classTable != null) {
            if (classTable.instanceFields != null) {
                for (int i = 0; i < classTable.instanceFields.length; ++i) {
                    if (classTable.instanceFields[i] != 2) continue;
                    ++n;
                }
            }
            if (classTable.superClassID == 0L) break;
            classTable = this.getClass(classTable.superClassID);
        }
        return n;
    }

    public int getInstances(long l) {
        int n = 0;
        ClassTable classTable = this.getClass(l);
        while (classTable != null) {
            if (classTable.instanceFields != null) {
                n += classTable.instanceFields.length;
            }
            if (classTable.superClassID == 0L) break;
            classTable = this.getClass(classTable.superClassID);
        }
        return n;
    }

    long getRelativeAddress(int n) {
        long l = 0L;
        try {
            switch (n) {
                case 0: {
                    l = this.lastAddress + (long)(this.dis.bufferedReadByte() << this.shift);
                    break;
                }
                case 1: {
                    l = this.lastAddress + (long)(this.dis.bufferedReadShort() << this.shift);
                    break;
                }
                case 2: {
                    l = this.lastAddress + (long)(this.dis.bufferedReadInt() << this.shift);
                    break;
                }
                case 3: {
                    l = this.lastAddress + (this.dis.bufferedReadLong() << this.shift);
                }
            }
        }
        catch (Exception exception) {
            throw new Error("Getting relative address, unexpected error: " + exception);
        }
        if (!this.is64) {
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    public long getValues(int n, byte[] byArray, int n2) {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
            }
            case 4: {
                return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            }
            case 8: {
                return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
            }
        }
        System.out.println("(getValues) Unknown size=" + Integer.toHexString(n2));
        return 0L;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                HprofTask.this.current = 0;
                HprofTask.this.done = false;
                HprofTask.this.canceled = false;
                HprofTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    int Handle2Hash(long l) {
        return (int)(l >>> 3);
    }

    public boolean isDone() {
        return this.done;
    }

    int MANGLE(int n) {
        return (this.ROTATE(n ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    public void markPrimitive(long l, String string) {
        if (string.compareTo("java.lang.Object[]") == 0) {
            this.primitiveString[0] = l;
        } else if (string.compareTo("boolean[]") == 0) {
            this.primitiveString[1] = l;
        } else if (string.compareTo("char[]") == 0) {
            this.primitiveString[2] = l;
        } else if (string.compareTo("float[]") == 0) {
            this.primitiveString[3] = l;
        } else if (string.compareTo("double[]") == 0) {
            this.primitiveString[4] = l;
        } else if (string.compareTo("byte[]") == 0) {
            this.primitiveString[5] = l;
        } else if (string.compareTo("short[]") == 0) {
            this.primitiveString[6] = l;
        } else if (string.compareTo("int[]") == 0) {
            this.primitiveString[7] = l;
        } else if (string.compareTo("long[]") == 0) {
            this.primitiveString[8] = l;
        }
    }

    public void populatePrimiveString() {
        long l = 0L;
        for (int i = 0; i < this.primitiveString.length; ++i) {
            if (this.primitiveString[i] != -1L) continue;
            while (this.strings.containsKey(new Long(l))) {
                if (++l < Long.MAX_VALUE) continue;
                System.out.println("Cannot find a slot for a primitive string");
                return;
            }
            this.primitiveString[i] = l;
            if (this.is64) {
                this.strings.put(new Long(l++), p[i]);
                continue;
            }
            this.strings.put(new Integer((int)l++), p[i]);
        }
    }

    public byte[] readBytes(int n) {
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            this.dis.bufferedRead(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return byArray;
    }

    public int readClass(int n) throws IOException {
        long l;
        int n2;
        boolean bl = false;
        String string = null;
        long l2 = this.readID();
        ClassTable classTable = null;
        classTable = (ClassTable)this.classes.get(new Long(l2));
        int n3 = 0;
        if (n == 1) {
            this.dis.skipBytes(4);
        } else if (this.isStackTrace()) {
            n3 = this.dis.bufferedReadInt();
        } else {
            this.dis.skipBytes(4);
        }
        long l3 = this.readID();
        this.dis.skipBytes(5 * this.sizeOfID);
        int n4 = this.dis.bufferedReadInt();
        n4 = this.is64 ? (n4 += 16) : (n4 += 8);
        if (classTable == null) {
            bl = true;
            classTable = new ClassTable(-1L, n4, null, l3);
            this.classes.put(new Long(l2), classTable);
        }
        if (n == 1) {
            classTable.size = n4;
            classTable.superClassID = l3;
        }
        int n5 = this.dis.bufferedReadUnsignedShort();
        int n6 = this.sizeOfID * 7 + 10;
        for (int i = 0; i < n5; ++i) {
            this.dis.skipBytes(2);
            n6 += this.skipEntry() + 2;
        }
        long l4 = this.dis.getFilePointer();
        int n7 = this.dis.bufferedReadUnsignedShort();
        n6 += 2;
        if (n == 1) {
            for (n2 = 0; n2 < n7; ++n2) {
                this.dis.skipBytes(this.sizeOfID);
                n6 += this.skipEntry() + this.sizeOfID;
            }
        } else {
            int n8;
            int n9;
            n2 = this.getIndexFromObject(l2);
            if (n2 == -1) {
                System.out.println("Cannot find index of address 0x" + Long.toHexString(l2) + "in readClass");
                return n6;
            }
            this.getHeapInfo().setClassIndex(n2, -1L);
            this.getHeapInfo().setValueLocation(n2, l4);
            this.getHeapInfo().setSize(n2, 76);
            if (this.isStackTrace()) {
                this.getHeapInfo().setStackTraceSerialNumber(n2, n3);
            }
            if ((string = this.is64 ? (String)this.strings.get(new Long(classTable.nameID)) : (String)this.strings.get(new Integer((int)classTable.nameID))) == null) {
                string = "unknown";
            }
            if ((n9 = Arrays.binarySearch(this.getHeapInfo().getNameTable(), string)) >= 0) {
                this.hi.setNameKey(n2, n9);
            } else {
                this.hi.setNameKey(n2, -1);
            }
            this.setNameHashKey(n2, classTable.nameID);
            this.isClass[n2] = true;
            if (classTable.nameID == -1L) {
                System.out.println("Set nameKey -1 of class 0x" + Long.toHexString(l2) + " in readClass()");
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            long l5 = 0L;
            for (n8 = 0; n8 < n7; ++n8) {
                l = this.readID();
                n6 += this.sizeOfID;
                byte by = this.dis.bufferedReadByte();
                ++n6;
                if (by == 2) {
                    l5 = this.readID();
                    arrayList.add(new Long(l5));
                    n6 += this.sizeOfID;
                    continue;
                }
                this.dis.skipBytes(this.sizeOfType(by));
                n6 += this.sizeOfType(by);
            }
            n8 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                long l6 = (Long)arrayList.get(i);
                if (l6 == 0L || this.getIndexFromObject(l6) < 0) continue;
                ++n8;
            }
            if (n8 != 0) {
                this.getHeapInfo().getChild()[n2] = new int[n8];
                int n10 = 0;
                int n11 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    long l7 = (Long)arrayList.get(i);
                    if (l7 == 0L || (n11 = this.getIndexFromObject(l7)) < 0) continue;
                    this.getHeapInfo().getChild()[n2][n10++] = n11;
                }
                arrayList = null;
            }
        }
        n2 = this.dis.bufferedReadUnsignedShort();
        n6 += 2;
        byte[] byArray = null;
        long[] lArray = null;
        if (n2 != 0) {
            if (n == 1) {
                byArray = new byte[n2];
                lArray = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    lArray[i] = l = this.readID();
                    byArray[i] = this.dis.bufferedReadByte();
                    n6 += this.sizeOfID + 1;
                }
                classTable.instanceFields = byArray;
                classTable.fieldNameID = lArray;
            } else {
                for (int i = 0; i < n2; ++i) {
                    this.readID();
                    this.dis.bufferedReadByte();
                    n6 += this.sizeOfID + 1;
                }
            }
        }
        if (n == 1 || bl) {
            this.classes.put(new Long(l2), classTable);
        }
        return n6;
    }

    public int readClass2(int n) throws IOException {
        Object object;
        int n2;
        int n3;
        boolean bl = false;
        long l = this.readID();
        ClassTable classTable = null;
        classTable = (ClassTable)this.classes.get(new Long(l));
        int n4 = 0;
        if (n == 1) {
            this.dis.skipBytes(4);
        } else if (this.isStackTrace()) {
            n4 = this.dis.bufferedReadInt();
        } else {
            this.dis.skipBytes(4);
        }
        long l2 = this.readID();
        this.dis.skipBytes(5 * this.sizeOfID);
        int n5 = this.dis.bufferedReadInt();
        n5 = this.is64 ? (n5 += 16) : (n5 += 8);
        if (classTable == null) {
            bl = true;
            classTable = new ClassTable(-1L, n5, null, l2);
            this.classes.put(new Long(l), classTable);
        }
        if (n == 1) {
            classTable.size = n5;
            classTable.superClassID = l2;
        }
        int n6 = this.dis.bufferedReadUnsignedShort();
        int n7 = this.sizeOfID * 7 + 10;
        for (n3 = 0; n3 < n6; ++n3) {
            this.dis.skipBytes(2);
            n7 += this.skipEntry() + 2;
        }
        n3 = this.dis.bufferedReadUnsignedShort();
        n7 += 2;
        if (n == 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.dis.skipBytes(this.sizeOfID);
                n7 += this.skipEntry() + this.sizeOfID;
            }
        } else {
            int n8;
            n2 = this.getIndexFromObject(l);
            if (n2 == -1) {
                System.out.println("Cannot find index of address 0x" + Long.toHexString(l) + "in readClass");
                return n7;
            }
            this.getHeapInfo().setSize(n2, 76);
            if (this.isStackTrace()) {
                this.getHeapInfo().setStackTraceSerialNumber(n2, n4);
            }
            this.setNameHashKey(n2, classTable.nameID);
            this.isClass[n2] = true;
            if (classTable.nameID == -1L) {
                System.out.println("Set nameKey -1 of class 0x" + Long.toHexString(l) + " in readClass()");
            }
            object = new ArrayList();
            long l3 = 0L;
            FieldValues fieldValues = null;
            if (n3 > 0) {
                fieldValues = new FieldValues();
                fieldValues.setStringID(new long[n3]);
                fieldValues.setType(new byte[n3]);
                fieldValues.setValue(new byte[n3][]);
            }
            for (n8 = 0; n8 < n3; ++n8) {
                byte[] byArray;
                long l4 = this.readID();
                n7 += this.sizeOfID;
                byte by = this.dis.bufferedReadByte();
                ++n7;
                fieldValues.setStringID(n8, l4);
                String string = null;
                string = this.is64 ? (String)this.strings.get(new Long(l4)) : (String)this.strings.get(new Integer((int)l4));
                if (string != null) {
                    // empty if block
                }
                fieldValues.setType(n8, by);
                if (by == 2) {
                    l3 = this.readID();
                    object.add(new Long(l3));
                    l3 = this.getIndexFromObject(l3);
                    byArray = new byte[]{(byte)((int)l3 >> 24), (byte)((int)l3 >> 16), (byte)((int)l3 >> 8), (byte)((int)l3 & 0xFF)};
                    fieldValues.setValue(n8, byArray);
                    n7 += this.sizeOfID;
                    continue;
                }
                byArray = new byte[this.sizeOfType(by)];
                this.dis.bufferedRead(byArray);
                fieldValues.setValue(n8, byArray);
                n7 += this.sizeOfType(by);
            }
            n8 = 0;
            for (int i = 0; i < object.size(); ++i) {
                long l5 = (Long)object.get(i);
                if (l5 == 0L || this.getIndexFromObject(l5) < 0) continue;
                ++n8;
            }
            if (n8 != 0) {
                this.getHeapInfo().getChild()[n2] = new int[n8];
                int n9 = 0;
                int n10 = 0;
                for (int i = 0; i < object.size(); ++i) {
                    long l6 = (Long)object.get(i);
                    if (l6 == 0L || (n10 = this.getIndexFromObject(l6)) < 0) continue;
                    this.getHeapInfo().getChild()[n2][n9++] = n10;
                }
                object.clear();
                object = null;
            }
        }
        n2 = this.dis.bufferedReadUnsignedShort();
        n7 += 2;
        byte[] byArray = null;
        object = null;
        if (n2 != 0) {
            if (n == 1) {
                byArray = new byte[n2];
                object = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    long l7 = this.readID();
                    String string = null;
                    string = this.is64 ? (String)this.strings.get(new Long(l7)) : (String)this.strings.get(new Integer((int)l7));
                    if (string != null) {
                        object[i] = l7;
                    }
                    byArray[i] = this.dis.bufferedReadByte();
                    n7 += this.sizeOfID + 1;
                }
                classTable.instanceFields = byArray;
                classTable.fieldNameID = object;
            } else {
                for (int i = 0; i < n2; ++i) {
                    this.readID();
                    this.dis.bufferedReadByte();
                    n7 += this.sizeOfID + 1;
                }
            }
        }
        if (n == 1 || bl) {
            this.classes.put(new Long(l), classTable);
        }
        return n7;
    }

    public void readHeapDump(long l, int n) throws IOException {
        long l2 = this.fileLocation;
        String string = null;
        block10: while (l > 0L) {
            this.fileLocation = l2 + (this.heapDumpSize - l);
            if (n == 1) {
                this.current = (int)(100.0f * (float)this.fileLocation / (float)this.fileSize);
                this.overall = (int)(30.0f * (float)this.fileLocation / (float)this.fileSize);
            } else {
                this.current = (int)(100.0f * (float)this.fileLocation / (float)(this.heapDumpSize + l2));
                this.overall = 30 + (int)(30.0f * (float)this.fileLocation / (float)(this.heapDumpSize + l2));
            }
            int n2 = this.dis.bufferedReadUnsignedByte();
            --l;
            switch (n2) {
                case 5: 
                case 7: 
                case 255: {
                    this.dis.skipBytes(this.sizeOfID);
                    l -= (long)this.sizeOfID;
                    continue block10;
                }
                case 1: {
                    this.dis.skipBytes(this.sizeOfID * 2);
                    l -= (long)(this.sizeOfID * 2);
                    continue block10;
                }
                case 2: 
                case 3: 
                case 8: {
                    this.dis.skipBytes(this.sizeOfID + 8);
                    l -= (long)(this.sizeOfID + 8);
                    continue block10;
                }
                case 4: 
                case 6: {
                    this.dis.skipBytes(this.sizeOfID + 4);
                    l -= (long)(this.sizeOfID + 4);
                    continue block10;
                }
                case 32: {
                    l -= (long)this.readClass(n);
                    continue block10;
                }
                case 33: {
                    int n3 = 0;
                    long l3 = this.readID();
                    if (n == 1) {
                        this.objectList.add(new Long(l3));
                    }
                    if (n == 1) {
                        this.dis.skipBytes(4);
                    } else if (this.isStackTrace()) {
                        n3 = this.dis.bufferedReadInt();
                    } else {
                        this.dis.skipBytes(4);
                    }
                    long l4 = this.readID();
                    long l5 = this.dis.getFilePointer();
                    int n4 = this.dis.bufferedReadInt();
                    if (n == 1) {
                        this.dis.skipBytes(n4);
                    } else {
                        this.readInstance(l5, l3, l4, n4, n3);
                    }
                    l -= (long)(n4 + this.sizeOfID * 2 + 8);
                    if (n != 1) continue block10;
                    ++this.totalNodes;
                    continue block10;
                }
                case 34: {
                    int n5;
                    int n3 = 0;
                    long l3 = this.readID();
                    if (n == 1) {
                        this.dis.skipBytes(4);
                    } else if (this.isStackTrace()) {
                        n3 = this.dis.bufferedReadInt();
                    } else {
                        this.dis.skipBytes(4);
                    }
                    int n6 = this.dis.bufferedReadInt();
                    long l6 = this.readID();
                    l -= (long)(8 + this.sizeOfID * 2);
                    if (n == 1) {
                        ++this.objectArrayCount;
                        this.objectList.add(new Long(l3));
                        for (n5 = 0; n5 < n6; ++n5) {
                            this.readID();
                            l -= (long)this.sizeOfID;
                        }
                    } else {
                        this.readObjectArray(l3, l6, n6, n3);
                        l -= (long)(this.sizeOfID * n6);
                    }
                    if (n != 1) continue block10;
                    ++this.totalNodes;
                    continue block10;
                }
                case 35: {
                    int n3 = 0;
                    long l3 = this.readID();
                    if (n == 1) {
                        this.dis.skipBytes(4);
                    } else if (this.isStackTrace()) {
                        n3 = this.dis.bufferedReadInt();
                    } else {
                        this.dis.skipBytes(4);
                    }
                    long l4 = 0L;
                    if (n == 2) {
                        l4 = this.dis.getFilePointer();
                    }
                    int n7 = this.dis.bufferedReadInt();
                    int n5 = this.dis.bufferedReadByte();
                    int n4 = this.sizeOfType(n5) * n7;
                    this.dis.skipBytes(n4);
                    l -= (long)(n4 += 9 + this.sizeOfID);
                    if (n == 1) {
                        ++this.primitiveArrayCount;
                        ++this.totalNodes;
                        this.objectList.add(new Long(l3));
                    }
                    if (n != 2) continue block10;
                    int n8 = this.getIndexFromObject(l3);
                    if (n8 == -1) {
                        System.out.println("Cannot find index of address 0x" + Long.toHexString(l3));
                        continue block10;
                    }
                    if (n7 == 0) {
                        this.getHeapInfo().setSize(n8, this.sizeOfID);
                    } else {
                        this.getHeapInfo().setSize(n8, this.sizeOfType(n5) * n7);
                    }
                    this.getHeapInfo().setClassIndex(n8, 0L);
                    this.getHeapInfo().setValueLocation(n8, l4);
                    if (this.isStackTrace()) {
                        this.getHeapInfo().setStackTraceSerialNumber(n8, n3);
                    }
                    this.getHeapInfo().getChild()[n8] = null;
                    string = type[n5];
                    if (string != null) {
                        int n9 = Arrays.binarySearch(this.getHeapInfo().getNameTable(), string);
                        if (n9 >= 0) {
                            this.hi.setNameKey(n8, n9);
                        } else {
                            this.hi.setNameKey(n8, -1);
                        }
                    } else {
                        this.hi.setNameKey(n8, -1);
                    }
                    this.setNameHashKey(n8, this.getIndexOfPrimitiveArray(n5));
                    continue block10;
                }
            }
            System.out.println("(readheapdump) unknown tag=0x" + Integer.toHexString(n2));
        }
    }

    public long readID() throws IOException {
        if (this.is64) {
            return this.dis.bufferedReadLong();
        }
        return this.dis.bufferedReadInt();
    }

    public void readInstance(long l, long l2, long l3, int n, int n2) throws IOException {
        int n3;
        int n4;
        byte[] byArray = null;
        String string = null;
        if (n != 0) {
            byArray = new byte[n];
            this.dis.bufferedReadFully(byArray);
        }
        int n5 = 0;
        ClassTable classTable = this.getClass(l3);
        if (classTable == null) {
            if (!this.isHeadless() && this.ha.cfg.verbose) {
                System.out.println("Cannot find class ID 0x" + Long.toHexString(l3) + " in readInstance()");
            }
            classTable = new ClassTable(-1L, 76, null, 0L);
            this.classes.put(new Long(l3), classTable);
            return;
        }
        int n6 = this.getIndexFromObject(l2);
        if (n6 == -1) {
            if (!this.isHeadless() && this.ha.cfg.verbose) {
                System.out.println("Cannot find index of address 0x" + Long.toHexString(l2));
            }
            return;
        }
        this.getHeapInfo().setSize(n6, classTable.size);
        this.getHeapInfo().setValueLocation(n6, l);
        this.getHeapInfo().setClassIndex(n6, l3);
        if (this.isStackTrace()) {
            this.getHeapInfo().setStackTraceSerialNumber(n6, n2);
        }
        if ((string = this.is64 ? (String)this.strings.get(new Long(classTable.nameID)) : (String)this.strings.get(new Integer((int)classTable.nameID))) == null) {
            string = "unknown";
        }
        if ((n4 = Arrays.binarySearch(this.getHeapInfo().getNameTable(), string)) >= 0) {
            this.hi.setNameKey(n6, n4);
        } else {
            this.hi.setNameKey(n6, -1);
        }
        this.setNameHashKey(n6, classTable.nameID);
        if (classTable.nameID == -1L) {
            System.out.println("nameKey -1 in readInstance()");
        }
        if ((n3 = this.getInstances(l3)) > 0) {
            int n7;
            int n8;
            int n9 = this.getRefs(l3);
            long[] lArray = n9 > 0 ? new long[n9] : null;
            int n10 = 0;
            int n11 = 0;
            ClassTable classTable2 = classTable;
            while (classTable2 != null) {
                if (classTable2.instanceFields != null && classTable2.instanceFields.length > 0) {
                    for (n8 = 0; n8 < classTable2.instanceFields.length; ++n8) {
                        if (classTable2.instanceFields[n8] == 2) {
                            n7 = 4;
                            if (this.is64) {
                                n7 = 8;
                            }
                            lArray[n11] = this.getValues(n5, byArray, n7);
                            n5 += n7;
                            ++n11;
                        } else {
                            n5 += this.sizeOfType(classTable2.instanceFields[n8]);
                        }
                        ++n10;
                    }
                }
                if (classTable2.superClassID == 0L) break;
                classTable2 = this.getClass(classTable2.superClassID);
            }
            n11 = 0;
            if (lArray != null) {
                for (n8 = 0; n8 < lArray.length; ++n8) {
                    if (lArray[n8] == 0L || this.getIndexFromObject(lArray[n8]) < 0) continue;
                    ++n11;
                }
                this.getHeapInfo().getChild()[n6] = new int[n11];
                n11 = 0;
                n8 = 0;
                for (n7 = 0; n7 < lArray.length; ++n7) {
                    if (lArray[n7] == 0L || (n8 = this.getIndexFromObject(lArray[n7])) < 0) continue;
                    this.getHeapInfo().getChild()[n6][n11++] = n8;
                }
            }
        }
    }

    long readLong() throws Exception {
        if ((this.dumpFlags & 1) != 0) {
            return this.dis.bufferedReadLong();
        }
        return 0xFFFFFFFFL & (long)this.dis.bufferedReadInt();
    }

    public void readObjectArray(long l, long l2, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        long[] lArray = null;
        if (n != 0) {
            lArray = new long[n];
        }
        for (n5 = 0; n5 < n; ++n5) {
            lArray[n5] = this.readID();
        }
        n5 = 0;
        ClassTable classTable = this.getClass(l2);
        boolean bl = true;
        if (classTable == null) {
            System.out.println("WARNING! Cannot find class ID 0x" + Long.toHexString(l2) + " in readInstance()");
            bl = false;
        }
        if ((n4 = this.getIndexFromObject(l)) == -1) {
            System.out.println("WARNING! Cannot find index of address 0x" + Long.toHexString(l));
            return;
        }
        if (n == 0) {
            this.getHeapInfo().setSize(n4, this.sizeOfID);
        } else {
            this.getHeapInfo().setSize(n4, n * this.sizeOfID);
        }
        this.getHeapInfo().setArray(n4);
        if (this.isStackTrace()) {
            this.getHeapInfo().setStackTraceSerialNumber(n4, n2);
        }
        String string = null;
        if (bl) {
            string = this.is64 ? (String)this.strings.get(new Long(classTable.nameID)) : (String)this.strings.get(new Integer((int)classTable.nameID));
            if (string == null) {
                string = "unknown";
            }
        } else {
            string = "unknown";
        }
        if ((n3 = Arrays.binarySearch(this.getHeapInfo().getNameTable(), string)) >= 0) {
            this.hi.setNameKey(n4, n3);
        } else {
            this.hi.setNameKey(n4, -1);
        }
        if (bl) {
            this.setNameHashKey(n4, classTable.nameID);
            this.getHeapInfo().setClassIndex(n4, l2);
            if (classTable.nameID == -1L) {
                System.out.println("nameKey is -1 in readObjectArray");
            }
        }
        if (n != 0) {
            int n6;
            int n7 = 0;
            for (n6 = 0; n6 < lArray.length; ++n6) {
                if (lArray[n6] == 0L || this.getIndexFromObject(lArray[n6]) < 0) continue;
                ++n7;
            }
            this.getHeapInfo().getChild()[n4] = new int[n7];
            n7 = 0;
            n6 = 0;
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 0L || (n6 = this.getIndexFromObject(lArray[i])) < 0) continue;
                this.getHeapInfo().getChild()[n4][n7++] = n6;
            }
        }
    }

    long[] readRefs(long l, int n, int n2) throws Exception {
        long[] lArray = new long[n];
        long l2 = 0L;
        if (this.dbg) {
            System.out.println("readRefs, numRefs = " + n + " refsSize = " + n2);
        }
        for (int i = 0; i < n; ++i) {
            l2 = n2 == 0 ? (long)(this.dis.bufferedReadByte() << this.shift) : (n2 == 1 ? (long)(this.dis.bufferedReadShort() << this.shift) : (n2 == 2 ? (long)(this.dis.bufferedReadInt() << this.shift) : this.dis.bufferedReadLong() << this.shift));
            long l3 = lArray[i] = this.is64 ? l + l2 : l + l2 & 0xFFFFFFFFL;
            if (!this.dbg) continue;
            System.out.println("read ref " + Long.toHexString(lArray[i]) + " with gap " + Long.toHexString(l2));
        }
        if (this.dbg) {
            System.out.println("end of readRefs");
        }
        return lArray;
    }

    long readWord() throws Exception {
        if ((this.dumpFlags & 1) != 0) {
            return this.dis.bufferedReadLong();
        }
        return this.dis.bufferedReadInt();
    }

    int ROTATE(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    int roundup(int n) {
        return n + 7 & 0xFFFFFFF8;
    }

    public int secondPass() {
        long l;
        int n;
        this.hi.setNameTable(new String[this.classes.size() + p.length - 1]);
        int n2 = 0;
        long l2 = 0L;
        String string = null;
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] name table started at " + this.getElapsed());
        }
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            l2 = ((ClassTable)enumeration.nextElement()).nameID;
            string = this.is64 ? (String)this.strings.get(new Long(l2)) : (String)this.strings.get(new Integer((int)l2));
            if (string == null) {
                string = "unknown";
            }
            this.hi.setNameTable(n2++, string);
        }
        for (int i = 0; i < p.length; ++i) {
            if (i == 1) continue;
            this.hi.setNameTable(n2++, p[i]);
        }
        Arrays.sort(this.getHeapInfo().getNameTable());
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] name table ended at " + this.getElapsed());
        }
        this.statMessage = "Parsing objects";
        this.fileLocation = 0L;
        this.current = (int)(100.0f * (float)this.fileLocation / (float)this.heapDumpSize);
        this.overall = 30 + (int)(30.0f * (float)this.fileLocation / (float)this.heapDumpSize);
        long[] lArray = new long[this.objectList.size()];
        for (n = 0; n < this.objectList.size(); ++n) {
            lArray[n] = (Long)this.objectList.get(n);
        }
        this.objectCount = lArray.length;
        this.objectList.clear();
        this.objectList = null;
        this.classCount = this.classes.size();
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format((lArray.length + this.classes.size()) * 8) + " bytes of Java heap.");
        }
        this.getHeapInfo().allocateAddress(lArray.length + this.classes.size());
        n = 0;
        Enumeration enumeration2 = this.classes.keys();
        while (enumeration2.hasMoreElements()) {
            long l3 = (Long)enumeration2.nextElement();
            l = this.is64 ? l3 : l3 & 0xFFFFFFFFL;
            this.getHeapInfo().setAddress(n++, l);
        }
        for (int i = 0; i < lArray.length; ++i) {
            l = this.is64 ? lArray[i] : lArray[i] & 0xFFFFFFFFL;
            this.getHeapInfo().setAddress(n++, l);
        }
        lArray = null;
        if (this.is64) {
            Arrays.sort(this.getHeapInfo().getAddressLong());
        } else {
            Arrays.sort(this.getHeapInfo().getAddress());
        }
        this.populatePrimiveString();
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
        }
        if (this.is64) {
            this.longNameKey = new long[this.getHeapInfo().getAddressLength()];
            this.hi.setNameHashKeyLong(this.longNameKey);
        } else {
            this.nameHashKey = new int[this.getHeapInfo().getAddressLength()];
            this.hi.setNameHashKey(this.nameHashKey);
        }
        this.getHeapInfo().setNameKey(new int[this.getHeapInfo().getAddressLength()]);
        this.isClass = new boolean[this.getHeapInfo().getAddressLength()];
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
        }
        this.getHeapInfo().setSize(new int[this.getHeapInfo().getAddressLength()]);
        this.getHeapInfo().setClassIndex(new long[this.getHeapInfo().getAddressLength()]);
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
        }
        this.getHeapInfo().setChild(new int[this.getHeapInfo().getAddressLength()][]);
        this.getHeapInfo().setValueLocation(new long[this.getHeapInfo().getAddressLength()]);
        if (this.hi.getStackFrame().size() > 0) {
            this.hi.setStackTraceSerialNumber(new int[this.getHeapInfo().getAddressLength()]);
            this.setStackTrace(true);
        }
        try {
            this.dis.seek(this.heapDumpLocation);
            this.readHeapDump(this.heapDumpSize, 2);
        }
        catch (EOFException eOFException) {
            return 0;
        }
        catch (IOException iOException) {
            this.ha.handleException(iOException);
            this.jp.dispose();
            this.done = true;
            return -1;
        }
        return 0;
    }

    public int sizeOfType(int n) {
        switch (n) {
            case 2: {
                return this.sizeOfID;
            }
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        System.out.println("(sizeOfType) Unknown type=" + Integer.toHexString(n));
        return 0;
    }

    public int skipEntry() throws IOException {
        byte by = this.dis.bufferedReadByte();
        int n = 1;
        switch (by) {
            case 2: {
                this.dis.skipBytes(this.sizeOfID);
                n += this.sizeOfID;
                break;
            }
            case 4: 
            case 8: {
                this.dis.skipBytes(1);
                ++n;
                break;
            }
            case 5: 
            case 9: {
                this.dis.skipBytes(2);
                n += 2;
                break;
            }
            case 6: 
            case 10: {
                this.dis.skipBytes(4);
                n += 4;
                break;
            }
            case 7: 
            case 11: {
                this.dis.skipBytes(8);
                n += 8;
                break;
            }
            default: {
                System.out.println("(skipEntry) Unknown type=0x" + Integer.toHexString(by));
            }
        }
        return n;
    }

    public void skipHeader(DataInputStream dataInputStream) throws Exception {
        int n;
        dataInputStream.readUTF();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readUnsignedByte();
        block6: do {
            n = this.dis.bufferedReadUnsignedByte();
            switch (n) {
                case 1: {
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    break;
                }
                case 4: {
                    dataInputStream.readUTF();
                    if (!this.dbg) continue block6;
                    System.out.println(this.sdkFullVersion);
                    break;
                }
                default: {
                    throw new Exception("unrecognized tag: " + n);
                }
            }
        } while (n != 2);
        n = this.dis.bufferedReadUnsignedByte();
        if (n != 2) {
            throw new Exception("Cannot find dump. Corrupted phd file");
        }
        if (this.dbg) {
            System.out.println("read start of dump tag");
        }
    }

    void skipRefs(int n, int n2) throws Exception {
        long l = 0L;
        if (this.dbg) {
            System.out.println("skipRefs, numRefs = " + n + " refsSize = " + n2);
        }
        for (int i = 0; i < n; ++i) {
            if (n2 == 0) {
                this.dis.bufferedReadByte();
                continue;
            }
            if (n2 == 1) {
                this.dis.bufferedReadShort();
                continue;
            }
            if (n2 == 2) {
                this.dis.bufferedReadInt();
                continue;
            }
            this.dis.bufferedReadLong();
        }
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public int thirdPass() {
        int n;
        int n2;
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] third pass started " + this.getElapsed());
        }
        this.getHeapInfo().markReferences();
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] mark references completed at " + this.getElapsed());
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] stackTrace completed at " + this.getElapsed());
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] memory allocation started at " + this.getElapsed());
        }
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength()) + " bytes of Java heap.");
        }
        this.getHeapInfo().setBits(new byte[this.getHeapInfo().getAddressLength()]);
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
        }
        this.getHeapInfo().setParent(new int[this.getHeapInfo().getAddressLength()]);
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] init parent started at " + this.getElapsed());
        }
        this.statMessage = "Initializing parents";
        for (n2 = 0; n2 < this.getHeapInfo().getParent().length; ++n2) {
            this.getHeapInfo().getParent()[n2] = -1;
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] init parent completed at " + this.getElapsed());
        }
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
        }
        this.getHeapInfo().setTotal(new long[this.getHeapInfo().getAddressLength()]);
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] memory allocation ended at " + this.getElapsed());
        }
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength()) + " bytes of Java heap.");
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] search root ended at " + this.getElapsed());
        }
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(this.getHeapInfo().getAddressLength() * 2) + " bytes of Java heap.");
        }
        this.overall = 72;
        this.current = 0;
        this.statMessage = "Searching parents of each object";
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] reorg started at " + this.getElapsed());
        }
        this.getHeapInfo().reorg();
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] reorg ended at " + this.getElapsed());
        }
        this.statMessage = "Searching pure roots";
        if (!this.isHeadless()) {
            this.jp.getJProgressBar1().setMaximum(this.getHeapInfo().getAddressLength());
        }
        this.current = 0;
        n2 = 0;
        for (int i = 0; i < this.getHeapInfo().getAddressLength(); ++i) {
            ++this.current;
            if (this.getHeapInfo().getHasParent(i)) continue;
            ++n2;
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] searching pure root ended at " + this.getElapsed());
        }
        int[] nArray = new int[n2];
        n2 = 0;
        this.statMessage = "Analyzing pure roots";
        this.current = 0;
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing pure started at " + this.getElapsed());
        }
        if (!this.isHeadless()) {
            this.jp.getJProgressBar1().setMaximum(this.getHeapInfo().getAddressLength());
        }
        for (int i = 0; i < this.getHeapInfo().getAddressLength(); ++i) {
            ++this.current;
            if (this.getHeapInfo().getHasParent(i)) continue;
            this.getHeapInfo().calculateTotal(i);
            nArray[n2++] = i;
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing pure ended at " + this.getElapsed());
        }
        this.overall = 78;
        this.current = 0;
        this.statMessage = "Analyzing pseudo roots";
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing pseudo started at " + this.getElapsed());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!this.isHeadless()) {
            this.jp.getJProgressBar1().setMaximum(this.getHeapInfo().getAddressLength());
        }
        this.current = 0;
        for (int i = 0; i < this.getHeapInfo().getAddressLength(); ++i) {
            ++this.current;
            if (this.getHeapInfo().getVisited(i) || this.getHeapInfo().getChild()[i] == null) continue;
            this.getHeapInfo().calculateTotal(i);
            arrayList.add(new Integer(i));
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing pseudo ended at " + this.getElapsed());
        }
        this.getHeapInfo().clearBits();
        if (!this.isHeadless() && this.ha.cfg.verbose) {
            System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format((nArray.length + arrayList.size()) * 4) + " bytes of Java heap.");
        }
        this.getHeapInfo().setRootChildren(new int[nArray.length + arrayList.size()]);
        this.overall = 80;
        this.current = 0;
        this.statMessage = "Analyzing root children";
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing root children started at " + this.getElapsed());
        }
        Object var4_7 = null;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            this.getHeapInfo().setRootChildren(n3++, nArray[n]);
            ++this.current;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.getHeapInfo().setRootChildren(n3++, (Integer)arrayList.get(n));
            ++this.current;
        }
        arrayList = null;
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] analyzing root children ended at " + this.getElapsed());
        }
        this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Number of roots : " + numberFormatter.format(this.getHeapInfo().getRootChildrenLength()) + "\n");
        HeapInfo.addRow2TableModel("Number of roots", numberFormatter.format(this.getHeapInfo().getRootChildrenLength()), this.tm);
        this.overall = 90;
        this.statMessage = "Calculating total heap size";
        this.current = 0;
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] calc total heap started at " + this.getElapsed());
        }
        long l = 0L;
        int n4 = 0;
        for (n3 = 0; n3 < this.getHeapInfo().getSize().length; ++n3) {
            l += (long)this.getHeapInfo().getSize(n3);
            if (this.getHeapInfo().isFinalizer(n3)) {
                ++n4;
            }
            this.current = (int)(100.0f * (float)n3 / (float)this.getHeapInfo().getSize().length);
            this.overall = 90 + (int)(10.0f * (float)n3 / (float)this.getHeapInfo().getSize().length);
        }
        if (this.PROFILE) {
            System.out.println("[" + new Date() + "] calc total heap ended at " + this.getElapsed());
        }
        if (n4 > 0) {
            this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Number of objects with finalize() method : " + numberFormatter.format(n4) + "\n");
            HeapInfo.addRow2TableModel("Number of objects with finalize() method", numberFormatter.format(n4), this.tm);
        }
        if (this.getHeapInfo().getNumberOfFinalizableObject() > 0) {
            this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Number of garbage objects implementing finalize() method : " + numberFormatter.format(this.getHeapInfo().getNumberOfFinalizableObject()) + "\n");
            HeapInfo.addRow2TableModel("Number of garbage objects implementing finalize() method", numberFormatter.format(this.getHeapInfo().getNumberOfFinalizableObject()), this.tm);
        }
        this.getHeapInfo().setNumberOfFinalizerObject(n4);
        this.getHeapInfo().setHeapSize(l);
        this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Heap size : " + numberFormatter.format(l) + "\n");
        HeapInfo.addRow2TableModel("Heap size", numberFormatter.format(l), this.tm);
        this.getHeapInfo().setDumpInfo(this.getHeapInfo().getDumpInfo() + "Classes : " + numberFormatter.format(this.classCount) + ", Objects :  " + numberFormatter.format(this.objectCount) + ", ObjectArrays : " + numberFormatter.format(this.objectArrayCount) + ", PrimitiveArrays : " + numberFormatter.format(this.primitiveArrayCount) + "\n");
        HeapInfo.addRow2TableModel("Classes", numberFormatter.format(this.classCount), this.tm);
        HeapInfo.addRow2TableModel("Objects", numberFormatter.format(this.objectCount), this.tm);
        HeapInfo.addRow2TableModel("ObjectArrays", numberFormatter.format(this.objectArrayCount), this.tm);
        HeapInfo.addRow2TableModel("PrimitiveArrays", numberFormatter.format(this.primitiveArrayCount), this.tm);
        this.getHeapInfo().sortRootChildren();
        this.statMessage = "Chasing Java heap leak suspects";
        SuspectTask suspectTask = new SuspectTask(null, this.ha, this.getHeapInfo(), null, null);
        int n5 = suspectTask.headLessTask();
        this.done = true;
        this.overall = 100;
        this.current = 100;
        System.out.println("[" + new Date() + "] Heap Analysis of " + this.file.getAbsoluteFile() + " completed in " + this.getElapsed());
        if (!this.isHeadless()) {
            this.jp.dispose();
            HeapFrame heapFrame = new HeapFrame("Analysis of " + this.file.getName(), this.getHeapInfo());
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ha.gif"));
            heapFrame.setFrameIcon(imageIcon);
            heapFrame.fileName = this.file.getName();
            JTable jTable = new JTable();
            jTable.setDragEnabled(true);
            jTable.setModel(this.tm);
            jTable.setCellSelectionEnabled(true);
            HeapTree heapTree = this.ha.addLeakSuspectView(this.hi, heapFrame, jTable, true);
            if (heapTree == null) {
                heapFrame.JScrollPaneSetViewportView(jTable);
            } else {
                heapFrame.setSize(900, 800);
                HeapInfo.addRow2TableModel("Number of leak suspects", numberFormatter.format(this.hi.suspectList.length), this.tm);
            }
            this.ha.getJDesktopPane1().add(heapFrame);
            this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
            try {
                heapFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        } else {
            System.out.println("Heap dump file name : " + this.file.getAbsoluteFile() + "\n");
            System.out.println(this.getHeapInfo().getDumpInfo() + "\n");
        }
        return 0;
    }

    public void done() {
        this.done = true;
    }

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public HeapInfo getHeapInfo() {
        return this.hi;
    }

    public InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }

    public class ClassTable {
        long nameID;
        int size;
        byte[] instanceFields;
        long[] fieldNameID;
        long superClassID;

        public String toString() {
            if (this.instanceFields == null) {
                if (HprofTask.this.is64) {
                    return (String)HprofTask.this.strings.get(new Long(this.nameID)) + " size=" + this.size;
                }
                return (String)HprofTask.this.strings.get(new Integer((int)this.nameID)) + " size=" + this.size;
            }
            String string = new String();
            block11: for (int i = 0; i < this.instanceFields.length; ++i) {
                switch (this.instanceFields[i]) {
                    case 2: {
                        string = string + "Object ";
                        continue block11;
                    }
                    case 4: {
                        string = string + "boolean ";
                        continue block11;
                    }
                    case 5: {
                        string = string + "char ";
                        continue block11;
                    }
                    case 6: {
                        string = string + "float ";
                        continue block11;
                    }
                    case 7: {
                        string = string + "double ";
                        continue block11;
                    }
                    case 8: {
                        string = string + "byte ";
                        continue block11;
                    }
                    case 9: {
                        string = string + "short ";
                        continue block11;
                    }
                    case 10: {
                        string = string + "int ";
                        continue block11;
                    }
                    case 11: {
                        string = string + "long ";
                    }
                }
            }
            if (HprofTask.this.is64) {
                return (String)HprofTask.this.strings.get(new Long(this.nameID)) + " size=" + this.size + " numIns=" + this.instanceFields.length + " fields=" + string;
            }
            return (String)HprofTask.this.strings.get(new Integer((int)this.nameID)) + " size=" + this.size + " numIns=" + this.instanceFields.length + " fields=" + string;
        }

        public ClassTable(long l, int n, byte[] byArray, long l2) {
            this.nameID = l;
            this.size = n;
            this.instanceFields = byArray;
            this.superClassID = l2;
        }
    }

    class ActualTask {
        ActualTask() {
            HprofTask.this.startTime = System.currentTimeMillis();
            HprofTask.this.setHeapInfo(new HeapInfo());
            HprofTask.this.getHeapInfo().setFile(HprofTask.this.file);
            HprofTask.this.getHeapInfo().setDumpInfo("Heap dump comments :\n");
            HprofTask.this.getHeapInfo().setClassTable(HprofTask.this.classes);
            HprofTask.this.getHeapInfo().setFileType(3);
            HprofTask.this.tm.addColumn("Property");
            HprofTask.this.tm.addColumn("Value");
            HeapInfo.addRow2TableModel("Heap dump file name", "" + HprofTask.this.file.getAbsoluteFile(), HprofTask.this.tm);
            if (HprofTask.this.debug) {
                System.out.println("first pass start");
            }
            try {
                long l = HprofTask.this.firstPass();
                if (l == 0L) {
                    if (!HprofTask.this.isHeadless()) {
                        HprofTask.this.jp.dispose();
                        HprofTask.this.done = true;
                        JOptionPane.showMessageDialog(HprofTask.this.ha, "Cannot find any instances in the heap dump. Incomplete heap dump.", "Aborting  heap dump processing", 2);
                        HprofTask.this.jp.dispose();
                    } else {
                        System.out.println("Cannot find any instances in the heap dump. Incomplete heap dump.");
                    }
                    return;
                }
                if (l == -1L) {
                    HprofTask.this.jp.dispose();
                    HprofTask.this.done = true;
                    JOptionPane.showMessageDialog(HprofTask.this.ha, HprofTask.this.file.getAbsolutePath() + " is a truncated heap dump", "Aborting  heap dump processing", 2);
                    HprofTask.this.jp.dispose();
                    return;
                }
                if (HprofTask.this.debug) {
                    System.out.println("first pass done");
                }
                if (HprofTask.this.PROFILE) {
                    System.out.println("[" + new Date() + "] first pass completed in " + HprofTask.this.getElapsed());
                }
                if (HprofTask.this.totalNodes > Integer.MAX_VALUE) {
                    if (!HprofTask.this.isHeadless()) {
                        JOptionPane.showMessageDialog(HprofTask.this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes", "Error", 2);
                        HprofTask.this.jp.dispose();
                        HprofTask.this.done = true;
                    } else {
                        System.out.println("Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes");
                    }
                    return;
                }
                if (HprofTask.this.classes.size() == 0 || HprofTask.this.strings.size() == 0) {
                    if (!HprofTask.this.isHeadless()) {
                        JOptionPane.showMessageDialog(HprofTask.this.ha, "Cannot find any record.", "Error", 2);
                        HprofTask.this.jp.dispose();
                        HprofTask.this.done = true;
                    } else {
                        System.out.println("Cannot find any record.");
                    }
                    return;
                }
                if (HprofTask.this.secondPass() == -1) {
                    if (!HprofTask.this.isHeadless()) {
                        HprofTask.this.jp.dispose();
                        HprofTask.this.done = true;
                    }
                    return;
                }
                if (HprofTask.this.PROFILE) {
                    System.out.println("[" + new Date() + "] second pass completed in " + HprofTask.this.getElapsed());
                }
                HprofTask.this.thirdPass();
            }
            catch (Exception exception) {
                if (!HprofTask.this.isHeadless()) {
                    HprofTask.this.ha.handleException(exception);
                    HprofTask.this.jp.dispose();
                    HprofTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            if (!HprofTask.this.isHeadless()) {
                HprofTask.this.jp.dispose();
                HprofTask.this.done = true;
            }
        }
    }
}

