/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FindAddressView;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.SuspectTask;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class HprofTxtTask {
    static final int bufferSize = 102400;
    private boolean isHeadless;
    private static String dumpBegin = "HEAP DUMP BEGIN";
    private static String dumpEnd = "HEAP DUMP END";
    private static String TRACE = "TRACE ";
    private static String TAB = "\t";
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    long startTime = 0L;
    private HeapInfo hi;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;

    public HprofTxtTask(HeapAnalyzer heapAnalyzer, File file) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.lengthOfTask = 1000;
    }

    public HprofTxtTask(File file) {
        this.file = file;
        this.setHeadless();
        this.lengthOfTask = 1000;
    }

    public HprofTxtTask(HeapAnalyzer heapAnalyzer, File file, JDialogProgress jDialogProgress) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = jDialogProgress;
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                HprofTxtTask.this.current = 0;
                HprofTxtTask.this.done = false;
                HprofTxtTask.this.canceled = false;
                HprofTxtTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public void done() {
        this.done = true;
    }

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public HeapInfo getHeapInfo() {
        return this.hi;
    }

    public InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }

    class ActualTask {
        ActualTask() {
            int n;
            String string;
            BufferedReader bufferedReader;
            HprofTxtTask.this.startTime = System.currentTimeMillis();
            boolean bl = false;
            Boolean bl2 = null;
            long l = 0L;
            long l2 = 0L;
            HprofTxtTask.this.setHeapInfo(new HeapInfo());
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            HprofTxtTask.this.getHeapInfo().setAddress64(true);
            HprofTxtTask.this.getHeapInfo().setFileType(4);
            int n2 = 0;
            boolean bl3 = false;
            HprofTxtTask.this.getHeapInfo().setDumpInfo("Heap dump comments :\n");
            defaultTableModel.addColumn("Property");
            defaultTableModel.addColumn("Value");
            HeapInfo.addRow2TableModel("Heap dump file name", "" + HprofTxtTask.this.file.getAbsoluteFile(), defaultTableModel);
            long l3 = 0L;
            String string2 = new String();
            Vector<Integer> vector = new Vector<Integer>(1);
            int n3 = 0;
            int n4 = 0;
            Object var22_14 = null;
            boolean bl4 = false;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            n4 = 0;
            HprofTxtTask.this.overall = 0;
            HprofTxtTask.this.statMessage = "Loading heap dump file";
            StringBuffer stringBuffer = null;
            HprofTxtTask.this.hi.setStackTrace(new Hashtable());
            String string3 = null;
            int n8 = 0;
            int n9 = 0;
            try {
                long l4 = HprofTxtTask.this.file.length();
                bufferedReader = new BufferedReader(new InputStreamReader(HprofTxtTask.this.getInputStream(HprofTxtTask.this.file)), 102400);
                string2 = bufferedReader.readLine();
                ++l;
                if (string2 != null) {
                    l2 += (long)string2.length();
                }
                while (string2 != null && !string2.startsWith(dumpBegin)) {
                    string2 = bufferedReader.readLine();
                    ++l;
                    if (string2 != null) {
                        l2 += (long)string2.length();
                    }
                    if (string2.startsWith(TRACE)) {
                        n9 = string2.indexOf(":");
                        if (n9 < 0 || (string3 = string2.substring(TRACE.length(), n9)) == null) continue;
                        n8 = Integer.parseInt(string3);
                        stringBuffer = new StringBuffer();
                        HprofTxtTask.this.hi.getStackTrace().put(new Integer(n8), stringBuffer);
                        continue;
                    }
                    if (!string2.startsWith(TAB) || stringBuffer == null) continue;
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                }
                if (string2 == null || !string2.startsWith(dumpBegin)) {
                    if (!HprofTxtTask.this.isHeadless()) {
                        JOptionPane.showMessageDialog(HprofTxtTask.this.ha, "There is no Java heap dump in " + HprofTxtTask.this.file.getName(), "Error", 2);
                        HprofTxtTask.this.jp.dispose();
                        HprofTxtTask.this.done = true;
                    } else {
                        System.out.println("There is no Java heap dump in " + HprofTxtTask.this.file.getName());
                    }
                    return;
                }
                while (string2 != null && !string2.startsWith(dumpEnd)) {
                    if (string2.startsWith("CLS") || string2.startsWith("OBJ") || string2.startsWith("ARR")) {
                        ++l3;
                    }
                    HprofTxtTask.this.current = (int)(100.0f * (float)l2 / (float)l4);
                    HprofTxtTask.this.overall = (int)(10.0f * (float)l2 / (float)l4);
                    string2 = bufferedReader.readLine();
                    ++l;
                    if (string2 != null) {
                        l2 += (long)string2.length();
                    }
                    while (string2 != null && string2.startsWith("\t")) {
                        string2 = bufferedReader.readLine();
                        ++l;
                        if (string2 == null) continue;
                        l2 += (long)string2.length();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("Exception while parsing line " + numberFormatter.format(l) + " : " + string2);
                if (!HprofTxtTask.this.isHeadless()) {
                    HprofTxtTask.this.ha.handleException(exception);
                    HprofTxtTask.this.jp.dispose();
                    HprofTxtTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            if (l3 > Integer.MAX_VALUE) {
                if (!HprofTxtTask.this.isHeadless()) {
                    JOptionPane.showMessageDialog(HprofTxtTask.this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes", "Error", 2);
                    HprofTxtTask.this.jp.dispose();
                    HprofTxtTask.this.done = true;
                } else {
                    System.out.println("Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes");
                }
                return;
            }
            HprofTxtTask.this.statMessage = "Loading address of heap node";
            HprofTxtTask.this.overall = 10;
            if (!HprofTxtTask.this.isHeadless()) {
                HprofTxtTask.this.jp.getJProgressBar1().setMaximum((int)l3);
                HprofTxtTask.this.jp.getJProgressBar1().setStringPainted(true);
            }
            HprofTxtTask.this.current = 0;
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(l3 * 8L) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setAddress64(true);
            HprofTxtTask.this.getHeapInfo().allocateAddress((int)l3);
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            HprofTxtTask.this.getHeapInfo().setFile(HprofTxtTask.this.file);
            l3 = 0L;
            int n10 = 0;
            n4 = 0;
            l = 0L;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(HprofTxtTask.this.getInputStream(HprofTxtTask.this.file)), 102400);
                string2 = bufferedReader.readLine();
                ++l;
                while (string2 != null && !string2.startsWith(dumpBegin)) {
                    string2 = bufferedReader.readLine();
                    ++l;
                    if (string2 == null) continue;
                    l2 += (long)string2.length();
                }
                while (string2 != null && !string2.startsWith(dumpEnd)) {
                    if (string2.startsWith(dumpBegin)) {
                        HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + string2.substring(dumpBegin.length() + 1) + "\n");
                        HeapInfo.addRow2TableModel("Comment", string2.substring(dumpBegin.length() + 1), defaultTableModel);
                    } else if (string2.startsWith("CLS") || string2.startsWith("OBJ") || string2.startsWith("ARR")) {
                        try {
                            n5 = string2.indexOf(32);
                            if (n5 == -1) {
                                throw new Exception();
                            }
                            n6 = string2.indexOf(40);
                            if (n6 == -1) {
                                throw new Exception();
                            }
                            HprofTxtTask.this.getHeapInfo().setAddress(n10++, FindAddressView.getStringToLong("0x" + string2.substring(n5 + 1, n6 - 1)));
                        }
                        catch (Exception exception) {
                            System.out.println("Exception while parsing line " + numberFormatter.format(l) + " : " + string2);
                            exception.printStackTrace();
                            string2 = bufferedReader.readLine();
                            ++l;
                            continue;
                        }
                        if (string2.startsWith("CLS")) {
                            n5 = string2.indexOf("name=");
                            n6 = string2.indexOf(44);
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = "class " + string2.substring(n5 + 5, n6);
                        } else if (string2.startsWith("OBJ")) {
                            n5 = string2.indexOf("class=");
                            n6 = string2.indexOf("@");
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = string2.substring(n5 + 6, n6);
                        } else {
                            n5 = string2.indexOf("type=");
                            n6 = string2.indexOf(41);
                            n7 = string2.indexOf("@");
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = n7 == -1 ? "array of " + string2.substring(n5 + 5, n6) : "array of " + string2.substring(n5 + 5, n7);
                        }
                        bl2 = (Boolean)hashtable.get(string);
                        if (bl2 == null) {
                            hashtable.put(string, new Boolean(true));
                        }
                        ++l3;
                        ++n4;
                        HprofTxtTask.this.current++;
                        HprofTxtTask.this.overall = 10 + (int)(18.0f * ((float)HprofTxtTask.this.current / (float)HprofTxtTask.this.getHeapInfo().getAddressLength()));
                    }
                    string2 = bufferedReader.readLine();
                    ++l;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("Exception while parsing line " + numberFormatter.format(l) + " : " + string2);
                if (!HprofTxtTask.this.isHeadless()) {
                    HprofTxtTask.this.ha.handleException(exception);
                    HprofTxtTask.this.jp.dispose();
                    HprofTxtTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            HprofTxtTask.this.statMessage = "Sorting nodes by address";
            HprofTxtTask.this.overall = 28;
            if (HprofTxtTask.this.getHeapInfo().isAddress64()) {
                Arrays.sort(HprofTxtTask.this.getHeapInfo().getAddressLong());
            } else {
                Arrays.sort(HprofTxtTask.this.getHeapInfo().getAddress());
            }
            HprofTxtTask.this.getHeapInfo().setNameTable(new String[hashtable.size()]);
            int n11 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                HprofTxtTask.this.getHeapInfo().setNameTable(n11++, (String)enumeration.nextElement());
            }
            hashtable.clear();
            hashtable = null;
            HprofTxtTask.this.overall = 29;
            Arrays.sort(HprofTxtTask.this.getHeapInfo().getNameTable());
            HprofTxtTask.this.getHeapInfo().markReferences();
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setNameKey(new int[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setSize(new int[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setChild(new int[HprofTxtTask.this.getHeapInfo().getAddressLength()][]);
            HprofTxtTask.this.statMessage = "Processing heap node";
            HprofTxtTask.this.overall = 30;
            HprofTxtTask.this.current = 0;
            l = 0L;
            bl4 = false;
            n2 = 0;
            n4 = 0;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(HprofTxtTask.this.getInputStream(HprofTxtTask.this.file)), 102400);
                string2 = bufferedReader.readLine();
                ++l;
                while (string2 != null && !string2.startsWith(dumpBegin)) {
                    string2 = bufferedReader.readLine();
                    ++l;
                    if (string2 == null) continue;
                    l2 += (long)string2.length();
                }
                if (HprofTxtTask.this.hi.getStackTrace().size() > 0) {
                    HprofTxtTask.this.hi.setStackTraceSerialNumber(new int[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
                }
                while (string2 != null && !string2.startsWith(dumpEnd)) {
                    if (string2.startsWith("CLS") || string2.startsWith("OBJ") || string2.startsWith("ARR")) {
                        n5 = string2.indexOf(32);
                        if (n5 == -1) {
                            throw new Exception();
                        }
                        n6 = string2.indexOf(40);
                        if (n6 == -1) {
                            throw new Exception();
                        }
                        n2 = Arrays.binarySearch(HprofTxtTask.this.getHeapInfo().getAddressLong(), FindAddressView.getStringToLong("0x" + string2.substring(n5 + 1, n6 - 1)));
                        n6 = string2.indexOf("sz=");
                        if (n6 >= (n5 = string2.indexOf(44))) {
                            throw new Exception();
                        }
                        if (string2.startsWith("CLS")) {
                            HprofTxtTask.this.getHeapInfo().setSize(n2, 76);
                        } else {
                            HprofTxtTask.this.getHeapInfo().setSize(n2, Integer.parseInt(string2.substring(n6 + 3, n5)));
                        }
                        n6 = string2.indexOf("trace=");
                        if (n6 > 0 && (n5 = string2.substring(n6).indexOf(44)) > 0 && (string3 = string2.substring(n6 + "trace=".length(), n6 + n5)) != null && HprofTxtTask.this.getHeapInfo().getStackTraceSerialNumber() != null && (n5 = Integer.parseInt(string3)) != 0) {
                            HprofTxtTask.this.getHeapInfo().setStackTraceSerialNumber(n2, Integer.parseInt(string3));
                        }
                        if (string2.startsWith("CLS")) {
                            n5 = string2.indexOf("name=");
                            n6 = string2.indexOf(44);
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = "class " + string2.substring(n5 + 5, n6);
                        } else if (string2.startsWith("OBJ")) {
                            n5 = string2.indexOf("class=");
                            n6 = string2.indexOf("@");
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = string2.substring(n5 + 6, n6);
                        } else {
                            n5 = string2.indexOf("type=");
                            n6 = string2.indexOf(41);
                            n7 = string2.indexOf("@");
                            if (n5 == -1 || n6 == -1) {
                                throw new Exception();
                            }
                            string = n7 == -1 ? "array of " + string2.substring(n5 + 5, n6) : "array of " + string2.substring(n5 + 5, n7);
                        }
                        n3 = Arrays.binarySearch(HprofTxtTask.this.getHeapInfo().getNameTable(), string);
                        if (n3 < 0) {
                            System.out.println("Could not find an object in an array");
                            throw new Exception();
                        }
                        HprofTxtTask.this.getHeapInfo().setNameKey(n2, n3);
                        ++n4;
                        HprofTxtTask.this.current++;
                        HprofTxtTask.this.overall = 30 + (int)(40.0f * (float)HprofTxtTask.this.current / (float)HprofTxtTask.this.getHeapInfo().getAddressLength());
                    }
                    string2 = bufferedReader.readLine();
                    ++l;
                    vector.clear();
                    n7 = 0;
                    while (string2 != null && string2.length() != 0 && string2.charAt(0) == '\t') {
                        try {
                            if (string2.length() == 1) continue;
                            while (string2.charAt(0) == '\t') {
                                int n12;
                                n5 = string2.lastIndexOf(9);
                                Long l5 = new Long(FindAddressView.getStringToLong("0x" + string2.substring(n5 + 1)));
                                if (string2.indexOf("super") == -1 && (n12 = Arrays.binarySearch(HprofTxtTask.this.getHeapInfo().getAddressLong(), l5)) >= 0) {
                                    vector.addElement(new Integer(n12));
                                }
                                string2 = bufferedReader.readLine();
                                ++l;
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Exception while parsing line " + numberFormatter.format(l) + " : " + string2);
                            exception.printStackTrace();
                            string2 = bufferedReader.readLine();
                            ++l;
                        }
                    }
                    if (vector.isEmpty()) continue;
                    HprofTxtTask.this.getHeapInfo().getChild()[n2] = new int[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        HprofTxtTask.this.getHeapInfo().getChild()[n2][i] = (Integer)vector.elementAt(i);
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("Exception while parsing line " + numberFormatter.format(l) + " : " + string2);
                if (!HprofTxtTask.this.isHeadless()) {
                    HprofTxtTask.this.ha.handleException(exception);
                    HprofTxtTask.this.jp.dispose();
                    HprofTxtTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            vector.clear();
            vector = null;
            HprofTxtTask.this.getHeapInfo().setBits(new byte[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setParent(new int[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
            for (n5 = 0; n5 < HprofTxtTask.this.getHeapInfo().getParent().length; ++n5) {
                HprofTxtTask.this.getHeapInfo().getParent()[n5] = -1;
            }
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setTotal(new long[HprofTxtTask.this.getHeapInfo().getAddressLength()]);
            l3 = 0L;
            n4 = 0;
            HprofTxtTask.this.overall = 73;
            HprofTxtTask.this.statMessage = "Analyzing pure roots";
            HprofTxtTask.this.current = 0;
            if (!HprofTxtTask.this.isHeadless()) {
                HprofTxtTask.this.jp.getJProgressBar1().setMaximum(HprofTxtTask.this.getHeapInfo().getAddressLength());
            }
            HprofTxtTask.this.getHeapInfo().reorg();
            int n13 = 0;
            for (int i = 0; i < HprofTxtTask.this.getHeapInfo().getAddressLength(); ++i) {
                if (HprofTxtTask.this.getHeapInfo().getHasParent(i)) continue;
                ++n13;
            }
            int[] nArray = new int[n13];
            n13 = 0;
            for (int i = 0; i < HprofTxtTask.this.getHeapInfo().getAddressLength(); ++i) {
                if (!HprofTxtTask.this.getHeapInfo().getHasParent(i)) {
                    HprofTxtTask.this.getHeapInfo().calculateTotal(i);
                    nArray[n13++] = i;
                }
                HprofTxtTask.this.current++;
            }
            HprofTxtTask.this.overall = 75;
            HprofTxtTask.this.statMessage = "Analyzing pseudo roots";
            HprofTxtTask.this.current = 0;
            n4 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < HprofTxtTask.this.getHeapInfo().getAddressLength(); ++n) {
                if (!HprofTxtTask.this.getHeapInfo().getVisited(n) && HprofTxtTask.this.getHeapInfo().getChild()[n] != null) {
                    HprofTxtTask.this.getHeapInfo().calculateTotal(n);
                    arrayList.add(new Integer(n));
                }
                HprofTxtTask.this.current++;
            }
            HprofTxtTask.this.getHeapInfo().clearBits();
            if (!HprofTxtTask.this.isHeadless() && HprofTxtTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format((nArray.length + arrayList.size()) * 4) + " bytes of Java heap.");
            }
            HprofTxtTask.this.getHeapInfo().setRootChildren(new int[nArray.length + arrayList.size()]);
            HprofTxtTask.this.overall = 78;
            HprofTxtTask.this.statMessage = "Analyzing root children";
            HprofTxtTask.this.current = 0;
            n5 = 0;
            if (!HprofTxtTask.this.isHeadless()) {
                HprofTxtTask.this.jp.getJProgressBar1().setMaximum(nArray.length + arrayList.size());
            }
            for (n = 0; n < nArray.length; ++n) {
                HprofTxtTask.this.getHeapInfo().setRootChildren(n5++, nArray[n]);
                HprofTxtTask.this.current++;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                HprofTxtTask.this.getHeapInfo().setRootChildren(n5++, (Integer)arrayList.get(n));
                HprofTxtTask.this.current++;
            }
            arrayList = null;
            HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Number of roots : " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getRootChildrenLength()) + "\n");
            HeapInfo.addRow2TableModel("Number of roots", numberFormatter.format(HprofTxtTask.this.getHeapInfo().getRootChildrenLength()), defaultTableModel);
            HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Number of types : " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getNameTable().length) + "\n");
            HeapInfo.addRow2TableModel("Number of types", numberFormatter.format(HprofTxtTask.this.getHeapInfo().getNameTable().length), defaultTableModel);
            HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Heap range : 0x" + Long.toHexString(HprofTxtTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(HprofTxtTask.this.getHeapInfo().getAddress(HprofTxtTask.this.getHeapInfo().getAddressLength() - 1)) + "\n");
            HeapInfo.addRow2TableModel("Heap range", "0x" + Long.toHexString(HprofTxtTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(HprofTxtTask.this.getHeapInfo().getAddress(HprofTxtTask.this.getHeapInfo().getAddressLength() - 1)), defaultTableModel);
            HprofTxtTask.this.overall = 90;
            HprofTxtTask.this.statMessage = "Calculating total heap size";
            HprofTxtTask.this.current = 0;
            if (!HprofTxtTask.this.isHeadless()) {
                HprofTxtTask.this.jp.getJProgressBar1().setMaximum(HprofTxtTask.this.getHeapInfo().getAddressLength());
            }
            long l6 = 0L;
            int n14 = 0;
            for (n5 = 0; n5 < HprofTxtTask.this.getHeapInfo().getSize().length; ++n5) {
                l6 += (long)HprofTxtTask.this.getHeapInfo().getSize()[n5];
                if (HprofTxtTask.this.getHeapInfo().isFinalizer(n5)) {
                    ++n14;
                }
                HprofTxtTask.this.current++;
            }
            if (n14 > 0) {
                HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Number of objects with finalize() method : " + numberFormatter.format(n14) + "\n");
                HeapInfo.addRow2TableModel("Number of objects with finalize() method", numberFormatter.format(n14), defaultTableModel);
            }
            if (HprofTxtTask.this.getHeapInfo().getNumberOfFinalizableObject() > 0) {
                HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Number of garbage objects implementing finalize() method : " + numberFormatter.format(HprofTxtTask.this.getHeapInfo().getNumberOfFinalizableObject()) + "\n");
                HeapInfo.addRow2TableModel("Number of garbage objects implementing finalize() method", numberFormatter.format(HprofTxtTask.this.getHeapInfo().getNumberOfFinalizableObject()), defaultTableModel);
            }
            HprofTxtTask.this.getHeapInfo().setNumberOfFinalizerObject(n14);
            HprofTxtTask.this.getHeapInfo().setHeapSize(l6);
            HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "Heap size : " + numberFormatter.format(l6) + "\n");
            HeapInfo.addRow2TableModel("Java heap usage", numberFormatter.format(l6) + " bytes", defaultTableModel);
            HprofTxtTask.this.getHeapInfo().sortRootChildren();
            HprofTxtTask.this.statMessage = "Chasing Java heap leak suspects";
            SuspectTask suspectTask = new SuspectTask(null, HprofTxtTask.this.ha, HprofTxtTask.this.getHeapInfo(), null, null);
            int n15 = suspectTask.headLessTask();
            HprofTxtTask.this.done = true;
            HprofTxtTask.this.overall = 100;
            System.out.println("[" + new Date() + "] Heap Analysis of " + HprofTxtTask.this.file.getAbsoluteFile() + " completed in " + HprofTxtTask.this.getElapsed());
            if (HprofTxtTask.this.getHeapInfo().getDumpInfo().indexOf("// EOF: ") == -1 && bl) {
                HprofTxtTask.this.getHeapInfo().setDumpInfo(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "\n*** WARNING!! THE HEAP DUMP IS TRUNCATED. No further analysis is recommended.***\n\n");
                HeapInfo.addRow2TableModel("WARNING", "THE HEAP DUMP IS TRUNCATED. No further analysis is recommended", defaultTableModel);
            }
            if (!HprofTxtTask.this.isHeadless()) {
                HprofTxtTask.this.jp.dispose();
                HeapFrame heapFrame = new HeapFrame("Analysis of " + HprofTxtTask.this.file.getName(), HprofTxtTask.this.getHeapInfo());
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ha.gif"));
                heapFrame.setFrameIcon(imageIcon);
                heapFrame.fileName = HprofTxtTask.this.file.getName();
                JTable jTable = new JTable();
                jTable.setDragEnabled(true);
                jTable.setModel(defaultTableModel);
                jTable.setCellSelectionEnabled(true);
                HeapTree heapTree = HprofTxtTask.this.ha.addLeakSuspectView(HprofTxtTask.this.hi, heapFrame, jTable, true);
                if (heapTree == null) {
                    heapFrame.JScrollPaneSetViewportView(jTable);
                } else {
                    heapFrame.setSize(900, 800);
                    HeapInfo.addRow2TableModel("Number of leak suspects", numberFormatter.format(((HprofTxtTask)HprofTxtTask.this).hi.suspectList.length), defaultTableModel);
                }
                HprofTxtTask.this.ha.getJDesktopPane1().add(heapFrame);
                HprofTxtTask.this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
                try {
                    heapFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            } else {
                System.out.println("Heap dump file name : " + HprofTxtTask.this.file.getAbsoluteFile() + "\n");
                System.out.println(HprofTxtTask.this.getHeapInfo().getDumpInfo() + "\n");
            }
        }
    }
}

