/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public class JDialogOption
extends JDialog {
    Frame owner = null;
    HeapAnalyzer ha = null;
    ButtonGroup lookAndFeelGroup = new ButtonGroup();
    private JPanel ivjJDialogContentPane1 = null;
    private JLabel ivjJLabel1 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjApplyJButton = null;
    private JButton ivjCancelJButton = null;
    private JLabel ivjJLabel3 = null;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private JTextField ivjJTextField81 = null;
    private JButton ivjJButton1 = null;
    private JLabel ivjJLabel41 = null;
    private JLabel ivjJLabel11 = null;
    private JPanel ivjLookAndFeelPanel = null;
    private JRadioButton ivjMetalRadioButton = null;
    private JRadioButton ivjMotifRadioButton = null;
    private JRadioButton ivjSystemRadioButton = null;
    private JButton ivjBrowseButton = null;
    private JTextField ivjDefaultPath = null;
    private JLabel ivjJLabel12 = null;
    private JCheckBox ivjSaveCheckBox = null;
    private JCheckBox ivjVerboseCheckBox = null;
    private JCheckBox ivjJCheckBoxRecent = null;
    private JSpinner maxSubSpinner = null;
    private JSpinner maxViewSpinner = null;
    private JSpinner subTreeSpinner = null;
    private JSpinner dropSpinner = null;
    private JCheckBox percentageCheckBox = null;
    private JCheckBox referenceCheckBox = null;

    public JDialogOption() {
        this.initialize();
    }

    public JDialogOption(Dialog dialog) {
        super(dialog);
    }

    public JDialogOption(Dialog dialog, String string) {
        super(dialog, string);
    }

    public JDialogOption(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public JDialogOption(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public JDialogOption(Frame frame) {
        super(frame);
        this.owner = frame;
        this.initialize();
    }

    public JDialogOption(Frame frame, HeapAnalyzer heapAnalyzer) {
        super(frame);
        this.owner = frame;
        this.ha = heapAnalyzer;
        this.initialize();
    }

    public JDialogOption(Frame frame, String string) {
        super(frame, string);
    }

    public JDialogOption(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public JDialogOption(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public void applyJButton_ActionPerformed() {
        try {
            File file;
            this.ha.cfg.verbose = this.getVerboseCheckBox().isSelected();
            this.ha.cfg.save = this.getSaveCheckBox().isSelected();
            this.ha.cfg.recent = this.getJCheckBoxRecent().isSelected();
            this.ha.cfg.percentage = this.getPercentageCheckBox().isSelected();
            this.ha.cfg.weak = this.getReferenceCheckBox().isSelected();
            if (this.getMetalRadioButton().isSelected()) {
                this.ha.cfg.lookAndFeel = 0;
            }
            if (this.getMotifRadioButton().isSelected()) {
                this.ha.cfg.lookAndFeel = 1;
            }
            if (this.getSystemRadioButton().isSelected()) {
                this.ha.cfg.lookAndFeel = 2;
            }
            this.ha.cfg.maxsub = HeapAnalyzer.MAX_SUBTREE = (long)((Integer)this.getMaxSubSpinner().getValue()).intValue();
            this.ha.cfg.maxview = HeapAnalyzer.MAX_VIEW_SIZE = (long)((Integer)this.getMaxViewSpinner().getValue()).intValue();
            this.ha.cfg.subtree = HeapAnalyzer.SUBTREE = (long)((Integer)this.getSubTreeSpinner().getValue()).intValue();
            this.ha.cfg.drop = HeapAnalyzer.MIN_DROP = (long)((Integer)this.getDropSpinner().getValue()).intValue();
            String string = this.getDefaultPath().getText();
            if (string != null && (file = new File(this.getDefaultPath().getText())) != null) {
                this.ha.cfg.workingDir = file;
            }
            this.hide();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception", 2);
        }
    }

    public void browseButton_ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        if (this.ha.cfg.workingDir == null) {
            String string = System.getProperty("user.dir");
            jFileChooser = new JFileChooser(string);
        } else {
            jFileChooser = new JFileChooser(this.ha.cfg.workingDir);
        }
        jFileChooser.setFileSelectionMode(1);
        JDialog jDialog = new JDialog(this);
        jFileChooser.showDialog(jDialog, "Default directory");
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "Directory not found:" + file.getAbsoluteFile(), "Directory Open Error", 2);
            return;
        }
        this.ha.cfg.workingDir = jFileChooser.getSelectedFile();
        this.getDefaultPath().setText(this.ha.cfg.workingDir.getAbsolutePath());
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.applyJButton_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.browseButton_ActionPerformed(actionEvent);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionEvent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2(ActionEvent actionEvent) {
        try {
            this.getJTextField81().setVisible(true);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(ActionEvent actionEvent) {
    }

    private JButton getApplyJButton() {
        if (this.ivjApplyJButton == null) {
            try {
                this.ivjApplyJButton = new JButton();
                this.ivjApplyJButton.setName("ApplyJButton");
                this.ivjApplyJButton.setMnemonic('A');
                this.ivjApplyJButton.setText("Apply");
                this.ivjApplyJButton.setBounds(104, 423, 85, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjApplyJButton;
    }

    private JButton getBrowseButton() {
        if (this.ivjBrowseButton == null) {
            try {
                this.ivjBrowseButton = new JButton();
                this.ivjBrowseButton.setName("BrowseButton");
                this.ivjBrowseButton.setMnemonic('B');
                this.ivjBrowseButton.setText("Browse");
                this.ivjBrowseButton.setBounds(338, 205, 85, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjBrowseButton;
    }

    private JButton getCancelJButton() {
        if (this.ivjCancelJButton == null) {
            try {
                this.ivjCancelJButton = new JButton();
                this.ivjCancelJButton.setName("CancelJButton");
                this.ivjCancelJButton.setMnemonic('C');
                this.ivjCancelJButton.setText("Cancel");
                this.ivjCancelJButton.setBounds(233, 423, 85, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCancelJButton;
    }

    private JTextField getDefaultPath() {
        if (this.ivjDefaultPath == null) {
            try {
                this.ivjDefaultPath = new JTextField();
                this.ivjDefaultPath.setName("DefaultPath");
                this.ivjDefaultPath.setBounds(136, 204, 184, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDefaultPath;
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setText("");
                this.ivjJButton1.setVisible(false);
                this.ivjJButton1.setFocusPainted(false);
                this.ivjJButton1.setBorderPainted(false);
                this.ivjJButton1.setBounds(402, 429, 11, 13);
                this.ivjJButton1.setEnabled(true);
                this.ivjJButton1.setRequestFocusEnabled(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJButton1;
    }

    private JCheckBox getJCheckBoxRecent() {
        if (this.ivjJCheckBoxRecent == null) {
            try {
                this.ivjJCheckBoxRecent = new JCheckBox();
                this.ivjJCheckBoxRecent.setName("JCheckBoxRecent");
                this.ivjJCheckBoxRecent.setSelected(true);
                this.ivjJCheckBoxRecent.setMnemonic('r');
                this.ivjJCheckBoxRecent.setText("Open Recent Directory");
                this.ivjJCheckBoxRecent.setBounds(255, 256, 168, 22);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJCheckBoxRecent;
    }

    private JPanel getJDialogContentPane1() {
        if (this.ivjJDialogContentPane1 == null) {
            try {
                this.ivjJDialogContentPane1 = new JPanel();
                this.ivjJDialogContentPane1.setName("JDialogContentPane1");
                this.ivjJDialogContentPane1.setLayout(null);
                this.getJDialogContentPane1().add((Component)this.getJLabel1(), this.getJLabel1().getName());
                this.getJDialogContentPane1().add((Component)this.getApplyJButton(), this.getApplyJButton().getName());
                this.getJDialogContentPane1().add((Component)this.getCancelJButton(), this.getCancelJButton().getName());
                this.getJDialogContentPane1().add((Component)this.getJLabel3(), this.getJLabel3().getName());
                this.getJDialogContentPane1().add((Component)this.getJTextField81(), this.getJTextField81().getName());
                this.getJDialogContentPane1().add((Component)this.getJButton1(), this.getJButton1().getName());
                this.getJDialogContentPane1().add((Component)this.getJLabel41(), this.getJLabel41().getName());
                this.getJDialogContentPane1().add((Component)this.getJLabel11(), this.getJLabel11().getName());
                this.getJDialogContentPane1().add((Component)this.getLookAndFeelPanel(), this.getLookAndFeelPanel().getName());
                this.getJDialogContentPane1().add((Component)this.getJLabel12(), this.getJLabel12().getName());
                this.getJDialogContentPane1().add((Component)this.getDefaultPath(), this.getDefaultPath().getName());
                this.getJDialogContentPane1().add((Component)this.getBrowseButton(), this.getBrowseButton().getName());
                this.getJDialogContentPane1().add((Component)this.getSaveCheckBox(), this.getSaveCheckBox().getName());
                this.getJDialogContentPane1().add((Component)this.getVerboseCheckBox(), this.getVerboseCheckBox().getName());
                this.getJDialogContentPane1().add((Component)this.getJCheckBoxRecent(), this.getJCheckBoxRecent().getName());
                this.ivjJDialogContentPane1.add((Component)this.getMaxSubSpinner(), null);
                this.ivjJDialogContentPane1.add((Component)this.getMaxViewSpinner(), null);
                this.ivjJDialogContentPane1.add((Component)this.getSubTreeSpinner(), null);
                this.ivjJDialogContentPane1.add((Component)this.getDropSpinner(), null);
                this.ivjJDialogContentPane1.add((Component)this.getPercentageCheckBox(), null);
                this.ivjJDialogContentPane1.add((Component)this.getReferenceCheckBox(), null);
                switch (this.ha.cfg.lookAndFeel) {
                    case 0: {
                        this.getMetalRadioButton().setSelected(true);
                        break;
                    }
                    case 1: {
                        this.getMotifRadioButton().setSelected(true);
                        break;
                    }
                    case 2: {
                        this.getSystemRadioButton().setSelected(true);
                    }
                }
                this.getDefaultPath().setText(this.ha.cfg.workingDir.getAbsolutePath());
                this.getVerboseCheckBox().setSelected(this.ha.cfg.verbose);
                this.getSaveCheckBox().setSelected(this.ha.cfg.save);
                this.getJCheckBoxRecent().setSelected(this.ha.cfg.recent);
                this.getPercentageCheckBox().setSelected(this.ha.cfg.percentage);
                this.getReferenceCheckBox().setSelected(this.ha.cfg.weak);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJDialogContentPane1;
    }

    public Container getJFrame() {
        return this.owner;
    }

    public Container getJDialog() {
        return this;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Maximum number of sub-trees");
                this.ivjJLabel1.setBounds(28, 29, 265, 14);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel11() {
        if (this.ivjJLabel11 == null) {
            try {
                this.ivjJLabel11 = new JLabel();
                this.ivjJLabel11.setName("JLabel11");
                this.ivjJLabel11.setText("Maximum number of super-trees");
                this.ivjJLabel11.setBounds(28, 72, 265, 14);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel11;
    }

    private JLabel getJLabel12() {
        if (this.ivjJLabel12 == null) {
            try {
                this.ivjJLabel12 = new JLabel();
                this.ivjJLabel12.setName("JLabel12");
                this.ivjJLabel12.setText("Default directory");
                this.ivjJLabel12.setBounds(28, 204, 104, 25);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel12;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Mininum total size drop for search (byte)");
                this.ivjJLabel3.setBounds(28, 159, 271, 14);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel41() {
        if (this.ivjJLabel41 == null) {
            try {
                this.ivjJLabel41 = new JLabel();
                this.ivjJLabel41.setName("JLabel41");
                this.ivjJLabel41.setText("How many more sub/super-trees to display ?");
                this.ivjJLabel41.setBounds(28, 115, 277, 14);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJLabel41;
    }

    private JTextField getJTextField81() {
        if (this.ivjJTextField81 == null) {
            try {
                this.ivjJTextField81 = new JTextField();
                this.ivjJTextField81.setName("JTextField81");
                this.ivjJTextField81.setBounds(309, 233, 116, 20);
                this.ivjJTextField81.setVisible(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJTextField81;
    }

    private JPanel getLookAndFeelPanel() {
        if (this.ivjLookAndFeelPanel == null) {
            try {
                this.ivjLookAndFeelPanel = new JPanel();
                this.ivjLookAndFeelPanel.setName("LookAndFeelPanel");
                this.ivjLookAndFeelPanel.setLayout(null);
                this.ivjLookAndFeelPanel.setBounds(27, 332, 389, 65);
                this.getLookAndFeelPanel().add((Component)this.getMetalRadioButton(), this.getMetalRadioButton().getName());
                this.getLookAndFeelPanel().add((Component)this.getMotifRadioButton(), this.getMotifRadioButton().getName());
                this.getLookAndFeelPanel().add((Component)this.getSystemRadioButton(), this.getSystemRadioButton().getName());
                Border border = BorderFactory.createEtchedBorder(0);
                this.ivjLookAndFeelPanel.setBorder(BorderFactory.createTitledBorder(border, " Look and Feel "));
                switch (this.ha.cfg.lookAndFeel) {
                    case 0: {
                        this.getMetalRadioButton().setSelected(true);
                        break;
                    }
                    case 1: {
                        this.getMotifRadioButton().setSelected(true);
                        break;
                    }
                    case 2: {
                        this.getSystemRadioButton().setSelected(true);
                    }
                }
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLookAndFeelPanel;
    }

    private JRadioButton getMetalRadioButton() {
        if (this.ivjMetalRadioButton == null) {
            try {
                this.ivjMetalRadioButton = new JRadioButton();
                this.ivjMetalRadioButton.setName("MetalRadioButton");
                this.ivjMetalRadioButton.setMnemonic('M');
                this.ivjMetalRadioButton.setText("Metal");
                this.ivjMetalRadioButton.setBounds(35, 24, 57, 22);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMetalRadioButton;
    }

    private JRadioButton getMotifRadioButton() {
        if (this.ivjMotifRadioButton == null) {
            try {
                this.ivjMotifRadioButton = new JRadioButton();
                this.ivjMotifRadioButton.setName("MotifRadioButton");
                this.ivjMotifRadioButton.setMnemonic('o');
                this.ivjMotifRadioButton.setText("Motif");
                this.ivjMotifRadioButton.setBounds(127, 24, 55, 22);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMotifRadioButton;
    }

    private JCheckBox getSaveCheckBox() {
        if (this.ivjSaveCheckBox == null) {
            try {
                this.ivjSaveCheckBox = new JCheckBox();
                this.ivjSaveCheckBox.setName("SaveCheckBox");
                this.ivjSaveCheckBox.setSelected(true);
                this.ivjSaveCheckBox.setMnemonic('S');
                this.ivjSaveCheckBox.setText("Save option");
                this.ivjSaveCheckBox.setBounds(145, 256, 103, 22);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSaveCheckBox;
    }

    private JRadioButton getSystemRadioButton() {
        if (this.ivjSystemRadioButton == null) {
            try {
                this.ivjSystemRadioButton = new JRadioButton();
                this.ivjSystemRadioButton.setName("SystemRadioButton");
                this.ivjSystemRadioButton.setSelected(false);
                this.ivjSystemRadioButton.setMnemonic('S');
                this.ivjSystemRadioButton.setText("System");
                this.ivjSystemRadioButton.setBounds(217, 24, 69, 22);
                this.ivjSystemRadioButton.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSystemRadioButton;
    }

    private JCheckBox getVerboseCheckBox() {
        if (this.ivjVerboseCheckBox == null) {
            try {
                this.ivjVerboseCheckBox = new JCheckBox();
                this.ivjVerboseCheckBox.setName("VerboseCheckBox");
                this.ivjVerboseCheckBox.setSelected(true);
                this.ivjVerboseCheckBox.setMnemonic('V');
                this.ivjVerboseCheckBox.setText("Verbose Mode");
                this.ivjVerboseCheckBox.setBounds(24, 256, 108, 22);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjVerboseCheckBox;
    }

    private void handleException(Throwable throwable) {
        throwable.printStackTrace(System.out);
        JOptionPane.showMessageDialog(this, throwable.toString(), "Exception", 2);
    }

    private void initConnections() throws Exception {
        this.getCancelJButton().addActionListener(this.ivjEventHandler);
        this.getApplyJButton().addActionListener(this.ivjEventHandler);
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.getBrowseButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("JDialogOption");
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
            this.setVisible(false);
            this.setModal(true);
            this.setSize(450, 519);
            this.setTitle("Options");
            this.setContentPane(this.getJDialogContentPane1());
            this.initConnections();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        this.lookAndFeelGroup.add(this.getMetalRadioButton());
        this.lookAndFeelGroup.add(this.getMotifRadioButton());
        this.lookAndFeelGroup.add(this.getSystemRadioButton());
        LookAndFeelListener lookAndFeelListener = new LookAndFeelListener();
        this.getMetalRadioButton().addItemListener(lookAndFeelListener);
        this.getMotifRadioButton().addItemListener(lookAndFeelListener);
        this.getSystemRadioButton().addItemListener(lookAndFeelListener);
        HeapAnalyzer.MAX_SUBTREE = this.ha.cfg.maxsub;
        HeapAnalyzer.MAX_VIEW_SIZE = this.ha.cfg.maxview;
        HeapAnalyzer.RATIO = this.ha.cfg.ratio;
        HeapAnalyzer.SUBTREE = this.ha.cfg.subtree;
        HeapAnalyzer.MIN_DROP = this.ha.cfg.drop;
        this.getMaxSubSpinner().setValue(new Integer((int)HeapAnalyzer.MAX_SUBTREE));
        this.getMaxViewSpinner().setValue(new Integer((int)HeapAnalyzer.MAX_VIEW_SIZE));
        this.getJTextField81().setText(numberFormatter.format(HeapAnalyzer.RATIO));
        this.getSubTreeSpinner().setValue(new Integer((int)HeapAnalyzer.SUBTREE));
        this.getDropSpinner().setValue(new Integer((int)HeapAnalyzer.MIN_DROP));
    }

    public static void main(String[] stringArray) {
        try {
            JDialogOption jDialogOption = new JDialogOption();
            jDialogOption.setModal(true);
            jDialogOption.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jDialogOption.show();
            Insets insets = jDialogOption.getInsets();
            jDialogOption.setSize(jDialogOption.getWidth() + insets.left + insets.right, jDialogOption.getHeight() + insets.top + insets.bottom);
            jDialogOption.setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            throwable.printStackTrace(System.out);
        }
    }

    private JSpinner getMaxSubSpinner() {
        if (this.maxSubSpinner == null) {
            this.maxSubSpinner = new JSpinner();
            this.maxSubSpinner.setBounds(new Rectangle(312, 25, 111, 20));
            this.maxSubSpinner.setModel(new SpinnerNumberModel(new Integer(5), new Integer(1), new Integer(1000000000), new Integer(1)));
        }
        return this.maxSubSpinner;
    }

    private JSpinner getMaxViewSpinner() {
        if (this.maxViewSpinner == null) {
            this.maxViewSpinner = new JSpinner();
            this.maxViewSpinner.setBounds(new Rectangle(312, 71, 111, 20));
            this.maxViewSpinner.setModel(new SpinnerNumberModel(new Integer(5), new Integer(1), new Integer(1000000000), new Integer(1)));
        }
        return this.maxViewSpinner;
    }

    private JSpinner getSubTreeSpinner() {
        if (this.subTreeSpinner == null) {
            this.subTreeSpinner = new JSpinner();
            this.subTreeSpinner.setBounds(new Rectangle(312, 112, 111, 20));
            this.subTreeSpinner.setModel(new SpinnerNumberModel(new Integer(5), new Integer(1), new Integer(1000000000), new Integer(1)));
        }
        return this.subTreeSpinner;
    }

    private JSpinner getDropSpinner() {
        if (this.dropSpinner == null) {
            this.dropSpinner = new JSpinner();
            this.dropSpinner.setBounds(new Rectangle(312, 156, 111, 20));
            this.subTreeSpinner.setModel(new SpinnerNumberModel(new Integer(10000000), new Integer(1), new Integer(1000000000), new Integer(1)));
        }
        return this.dropSpinner;
    }

    private JCheckBox getPercentageCheckBox() {
        if (this.percentageCheckBox == null) {
            this.percentageCheckBox = new JCheckBox();
            this.percentageCheckBox.setBounds(new Rectangle(24, 289, 137, 21));
            this.percentageCheckBox.setActionCommand("");
            this.percentageCheckBox.setSelected(true);
            this.percentageCheckBox.setText("Display percentage");
        }
        return this.percentageCheckBox;
    }

    private JCheckBox getReferenceCheckBox() {
        if (this.referenceCheckBox == null) {
            this.referenceCheckBox = new JCheckBox();
            this.referenceCheckBox.setBounds(new Rectangle(165, 289, 241, 21));
            this.referenceCheckBox.setText("Avoid Soft/Weak/Phantom Reference");
            this.referenceCheckBox.setSelected(false);
            this.referenceCheckBox.setActionCommand("Avoid weak");
        }
        return this.referenceCheckBox;
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JDialogOption.this.getCancelJButton()) {
                JDialogOption.this.connEtoM1(actionEvent);
            }
            if (actionEvent.getSource() == JDialogOption.this.getApplyJButton()) {
                JDialogOption.this.connEtoC1(actionEvent);
            }
            if (actionEvent.getSource() == JDialogOption.this.getJButton1()) {
                JDialogOption.this.connEtoM2(actionEvent);
            }
            if (actionEvent.getSource() == JDialogOption.this.getJButton1()) {
                JDialogOption.this.connEtoM3(actionEvent);
            }
            if (actionEvent.getSource() == JDialogOption.this.getBrowseButton()) {
                JDialogOption.this.connEtoC2(actionEvent);
            }
        }
    }

    class LookAndFeelListener
    implements ItemListener {
        LookAndFeelListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            try {
                if (jRadioButton.isSelected() && jRadioButton.getText().equals("System")) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJDialog());
                } else if (jRadioButton.isSelected() && jRadioButton.getText().equals("Motif")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJDialog());
                } else if (jRadioButton.isSelected() && jRadioButton.getText().equals("Metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJFrame());
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJDialog());
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                jRadioButton.setEnabled(false);
                System.out.println(jRadioButton.getText() + " Look and Feel is not supported on this platform. Trying Cross Platform Look and Feel.");
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(JDialogOption.this.getJFrame());
                    System.out.println("Cross Platform Look and Feel is applied.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Cross Platform Look and Feel failed.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

