/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JinwooDataInput
extends RandomAccessFile {
    static final int BUFFER_SIZE = 10000;
    int pointer = 10000;
    int lastPointer = Integer.MAX_VALUE;
    byte[] buffer = new byte[10000];
    long filePointer = 0L;

    public JinwooDataInput(File file, String string) throws FileNotFoundException {
        super(file, string);
    }

    public byte bufferedReadByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int bufferedReadInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long bufferedU4() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return ((long)n4 << 24) + (long)(n3 << 16) + (long)(n2 << 8) + (long)(n << 0);
    }

    public final long bufferedReadLong() throws IOException {
        return ((long)this.bufferedReadInt() << 32) + ((long)this.bufferedReadInt() & 0xFFFFFFFFL);
    }

    public final short bufferedReadShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public int bufferedRead(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.bufferedReadByte();
        }
        return byArray.length;
    }

    public final int bufferedReadUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final int bufferedReadUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final void bufferedReadFully(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.bufferedReadByte();
        }
    }

    public int read() throws IOException {
        int n = 0;
        if (this.pointer >= this.lastPointer) {
            throw new EOFException();
        }
        if (this.pointer >= 10000) {
            this.filePointer = super.getFilePointer();
            n = super.read(this.buffer);
            this.pointer = 0;
            if (n < 0) {
                return -1;
            }
            if (n < 10000) {
                this.lastPointer = n;
            }
        }
        return this.buffer[this.pointer++] & 0xFF;
    }

    public void seek(long l) throws IOException {
        this.pointer = 10000;
        this.lastPointer = Integer.MAX_VALUE;
        super.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.filePointer + (long)this.pointer;
    }

    public int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.read();
        }
        return n;
    }
}

