/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapCache;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class LeakTask {
    private int lengthOfTask;
    private static int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private HeapInfo hi;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    HeapInfo heapinfo;
    Node node;
    int adjustedThreshold = -1;
    TreePath tpath;
    private HeapTree ht;
    private Node newNode;
    private TreePath nextPath;
    private Node nextNode;

    public LeakTask(HeapTree heapTree, HeapAnalyzer heapAnalyzer, HeapInfo heapInfo, Node node, TreePath treePath) {
        this.ht = heapTree;
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        this.node = node;
        this.tpath = treePath;
        this.lengthOfTask = 1000;
    }

    public int getCurrent() {
        return current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                current = 0;
                LeakTask.this.done = false;
                LeakTask.this.canceled = false;
                LeakTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isEnd(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l == -1L || node.getIndex() == -1 || this.hi.getTotal(l) == (long)this.hi.getSize((int)l);
    }

    public boolean isRealDrop(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        if (l != -1L && node.getIndex() != -1) {
            if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(node.getIndex()) <= HeapAnalyzer.RATIO) {
                return true;
            }
        }
        return false;
    }

    public boolean isRealDrop(Node node, TreePath treePath) {
        float f = 0.5f;
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l != -1L && node.getIndex() != -1 && (float)this.hi.getTotal(l) / ((float)this.hi.getTotal(node.getIndex()) - (float)this.hi.getTotal(l)) <= f;
    }

    public boolean isThereLeakSuspect(int n) {
        long l;
        current = 0;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        while ((l = (long)heapModel.getBiggestRealChild(n)) != -1L) {
            if (n != -1) {
                if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(n) <= HeapAnalyzer.RATIO) {
                    return true;
                }
            }
            ++current;
            n = (int)l;
        }
        return false;
    }

    public TreePath returnBigDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) <= (long)n) {
            int n2 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
            this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
        } else {
            this.adjustedThreshold = -1;
        }
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public TreePath returnBiggestDrop(Node node, int n, TreePath treePath) {
        long l;
        long l2 = 0L;
        Node node2 = node;
        Vector vector = new Vector(1);
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
            }
            node = new Node((int)l);
        }
        return null;
    }

    public long returnLeakSuspect(Node node) {
        long l = 0L;
        HeapCache heapCache = null;
        int n = 0;
        boolean bl = false;
        long l2 = -1L;
        long l3 = -1L;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        boolean bl2 = false;
        long l4 = System.currentTimeMillis();
        if (node.isHav()) {
            Node node2 = new Node(true, node.getLocation());
            l = node2.getLocation();
            long l5 = this.hi.getHav().getTotal(l);
            long l6 = this.hi.getHav().getNameAddress(l);
            while ((heapCache = heapModel.getBiggestRealChildHavObjectFirstChild(node2)) != null && (l == -1L || l5 >= HeapAnalyzer.MIN_TOTAL_LIMIT)) {
                if (l != -1L) {
                    if ((float)heapCache.getTotalSize() / (float)l5 <= HeapAnalyzer.RATIO && l5 - heapCache.getTotalSize() > HeapAnalyzer.MIN_DROP_LIMIT) {
                        return heapCache.getLocation();
                    }
                }
                if (l != -1L && l6 == heapCache.getNameLocation()) {
                    if (bl) {
                        l3 = heapCache.getLocation();
                        ++n;
                    } else {
                        bl = true;
                        n = 1;
                        l2 = l;
                        l3 = heapCache.getLocation();
                    }
                } else if (l != -1L && bl) {
                    bl = false;
                    n = 0;
                    if ((float)this.hi.getHav().getTotal(l3) / (float)this.hi.getHav().getTotal(l2) <= HeapAnalyzer.RATIO) {
                        JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getHav().getNameHeap(l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                        return l2;
                    }
                }
                node2.setLocation(heapCache.getLocation());
                if (heapCache != null) continue;
                node2.setIndex(-1);
            }
            if (bl) {
                if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                    JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getHav().getNameHeap(l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                    return l2;
                }
            }
        } else {
            long l7;
            int n2 = node.getIndex();
            while ((l7 = (long)heapModel.getBiggestRealChild(n2)) != -1L && (n2 == -1 || this.hi.getTotal(n2) >= HeapAnalyzer.MIN_TOTAL_LIMIT || bl)) {
                if (n2 != -1) {
                    if ((float)this.hi.getTotal(l7) / (float)this.hi.getTotal(n2) <= HeapAnalyzer.RATIO && this.hi.getTotal(n2) - this.hi.getTotal(l7) > HeapAnalyzer.MIN_DROP_LIMIT) {
                        return l7;
                    }
                }
                if (n2 != -1 && this.hi.getNameKey(n2) == this.hi.getNameKey((int)l7)) {
                    if (bl) {
                        l3 = l7;
                        ++n;
                    } else {
                        bl = true;
                        n = 1;
                        l2 = n2;
                        l3 = l7;
                    }
                } else if (n2 != -1 && bl) {
                    if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                        JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getName((int)l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                        return l2;
                    }
                    bl = false;
                    n = 0;
                }
                n2 = (int)l7;
            }
            if (bl) {
                if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                    JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getName((int)l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                    return l2;
                }
            }
        }
        return -2L;
    }

    public long returnLeakSuspectORG(Node node) {
        long l = 0L;
        int n = 0;
        boolean bl = false;
        long l2 = -1L;
        long l3 = -1L;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        long l4 = System.currentTimeMillis();
        if (node.isHav()) {
            long l5;
            Node node2 = new Node(true, node.getLocation());
            l = node2.getLocation();
            long l6 = this.hi.getHav().getTotal(l);
            long l7 = this.hi.getHav().getNameAddress(l);
            long l8 = -1L;
            while ((l5 = heapModel.getBiggestRealChild(node2)) != -1L) {
                if (this.hi.backgroundThread != null && !this.hi.backgroundThread.isInterrupted()) {
                    this.hi.backgroundThread.interrupt();
                }
                l8 = this.hi.getHav().getTotal(l5);
                if (l != -1L && l6 < HeapAnalyzer.MIN_TOTAL_LIMIT) break;
                if (l != -1L) {
                    if ((float)l8 / (float)l6 <= HeapAnalyzer.RATIO && l6 - l8 > HeapAnalyzer.MIN_DROP_LIMIT) {
                        return l5;
                    }
                }
                if (l != -1L && l7 == this.hi.getHav().getNameAddress(l5)) {
                    if (bl) {
                        l3 = l5;
                        ++n;
                    } else {
                        bl = true;
                        n = 1;
                        l2 = l;
                        l3 = l5;
                    }
                } else if (l != -1L && bl) {
                    bl = false;
                    n = 0;
                    if ((float)this.hi.getHav().getTotal(l3) / (float)this.hi.getHav().getTotal(l2) <= HeapAnalyzer.RATIO) {
                        JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getHav().getNameHeap(l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                        return l2;
                    }
                }
                node2.setLocation(l5);
                if (l5 != -1L) continue;
                node2.setIndex(-1);
            }
            if (bl) {
                if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                    JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getHav().getNameHeap(l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                    return l2;
                }
            }
        } else {
            long l9;
            Node node3 = new Node(node.getIndex());
            l = node3.getIndex();
            while ((l9 = heapModel.getBiggestRealChild(node3)) != -1L && (l == -1L || this.hi.getTotal(l) >= HeapAnalyzer.MIN_TOTAL_LIMIT)) {
                if (l != -1L) {
                    if ((float)this.hi.getTotal(l9) / (float)this.hi.getTotal(l) <= HeapAnalyzer.RATIO && this.hi.getTotal(l) - this.hi.getTotal(l9) > HeapAnalyzer.MIN_DROP_LIMIT) {
                        return l9;
                    }
                }
                if (l != -1L && this.hi.getNameKey((int)l) == this.hi.getNameKey((int)l9)) {
                    if (bl) {
                        l3 = l9;
                        ++n;
                    } else {
                        bl = true;
                        n = 1;
                        l2 = l;
                        l3 = l9;
                    }
                } else if (l != -1L && bl) {
                    bl = false;
                    n = 0;
                    if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                        JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getName((int)l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                        return l2;
                    }
                }
                node3.setIndex((int)l9);
            }
            if (bl) {
                if ((float)this.hi.getTotal(l3) / (float)this.hi.getTotal(l2) <= HeapAnalyzer.RATIO) {
                    JOptionPane.showMessageDialog(this.ha, "Located a leak suspect\n" + this.hi.getName((int)l2) + " ( count : " + numberFormatter.format(n) + " )\nis responsible for " + numberFormatter.format(this.hi.getTotal(l2) - this.hi.getTotal(l3)) + " bytes", "Locate a leak suspect", 1);
                    return l2;
                }
            }
        }
        return -2L;
    }

    public TreePath returnLeakSuspect(Node node, TreePath treePath) {
        int n;
        Vector<Object> vector = new Vector<Object>(1);
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        TreePath treePath2 = null;
        while ((n = heapModel.getBiggestRealChild(node.getIndex())) != -1) {
            if (node.getIndex() != -1) {
                if ((float)this.hi.getTotal(n) / (float)this.hi.getTotal(node.getIndex()) <= HeapAnalyzer.RATIO) {
                    vector.addAll(0, Arrays.asList(treePath.getPath()));
                    Object[] objectArray = vector.toArray();
                    Object[] objectArray2 = new Node[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray2[i] = (Node)objectArray[i];
                    }
                    treePath2 = new TreePath(objectArray2);
                    return treePath2;
                }
            }
            node = new Node(n);
            vector.addElement(node);
        }
        return null;
    }

    public TreePath returnOneDrop(Node node, int n, TreePath treePath) {
        int n2;
        Vector<Object> vector = new Vector<Object>(1);
        TreePath treePath2 = null;
        while ((n2 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node.getIndex())) != -1) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(n2) == (long)n) {
                int n3;
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray2[n3] = (Node)objectArray[n3];
                }
                treePath2 = new TreePath(objectArray2);
                this.nextNode = new Node(n2);
                vector.addElement(this.nextNode);
                objectArray = vector.toArray();
                objectArray2 = new Node[objectArray.length];
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray2[n3] = (Node)objectArray[n3];
                }
                this.nextPath = new TreePath(objectArray2);
                return treePath2;
            }
            if (this.hi.getTotal(n2) < (long)n) {
                return null;
            }
            node = new Node(n2);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public long returnTreeDepth(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return -1L;
        }
        if (this.hi.isHav()) {
            long l4 = 0L;
            while ((l4 = this.hi.getHav().getParent(l)) >= 0L) {
                ++l3;
                l = l4;
            }
        } else {
            while (this.hi.getParent()[(int)l] >= 0) {
                ++l3;
                l = this.hi.getParent()[(int)l];
            }
        }
        return l3;
    }

    public TreePath returnTreePath(long l) {
        if (l < 0L) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address of index : " + l, "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        if (this.hi.isHav()) {
            vector.add(0, new Node(true, l));
            long l2 = 0L;
            while ((l2 = this.hi.getHav().getParent(l)) >= 0L) {
                vector.add(0, new Node(true, l2));
                l = l2;
            }
        } else {
            vector.add(0, new Node((int)l));
            while ((l = (long)this.hi.getParent()[(int)l]) >= 0L) {
                vector.add(0, new Node((int)l));
            }
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public long returnBiggestDrop(Node node) {
        long l;
        long l2 = 0L;
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
                this.newNode = node;
            }
            node = new Node((int)l);
        }
        return l2;
    }

    public long returnBiggestDrop(Node node, TreePath treePath) {
        long l;
        long l2 = 0L;
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
                this.newNode = node;
            }
            node = new Node((int)l);
        }
        return l2;
    }

    class ActualTask {
        ActualTask() {
            current = 0;
            LeakTask.this.ha.dp.setProgressText("   Traversing trees...");
            LeakTask.this.ha.dp.setTitle("Searching for a leak suspect");
            long l = LeakTask.this.returnLeakSuspect(LeakTask.this.node);
            LeakTask.this.done = true;
            if (l == -2L) {
                LeakTask.this.ha.dp.hide();
                JOptionPane.showMessageDialog(LeakTask.this.ha, "Cannot locate any leak suspect", "Locate a leak suspect", 1);
                return;
            }
            if (LeakTask.this.returnTreeDepth(l) > HeapAnalyzer.MAX_VIEW_SIZE) {
                ((LeakTask)LeakTask.this).ht.moreParentsMenuItem.setEnabled(true);
                ((LeakTask)LeakTask.this).ht.showFromRootsMenuItem.setEnabled(true);
                Vector<Node> vector = new Vector<Node>();
                int n = 0;
                Node node = null;
                long l2 = System.currentTimeMillis();
                if (LeakTask.this.hi.isHav()) {
                    vector.add(0, new Node(true, l));
                    long l3 = 0L;
                    while ((l3 = LeakTask.this.hi.getHav().getParent(l)) >= 0L && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(true, l3));
                        l = l3;
                        ++n;
                    }
                    node = new Node(true, l3, (int)HeapAnalyzer.MAX_SUBTREE);
                } else {
                    vector.add(0, new Node((int)l));
                    while (LeakTask.this.hi.getParent()[(int)l] >= 0 && (long)n <= HeapAnalyzer.MAX_VIEW_SIZE) {
                        vector.add(0, new Node(LeakTask.this.hi.getParent()[(int)l]));
                        l = LeakTask.this.hi.getParent()[(int)l];
                        ++n;
                    }
                    node = new Node(LeakTask.this.hi.getParent()[(int)l], (int)HeapAnalyzer.MAX_SUBTREE);
                }
                vector.add(0, node);
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                TreePath treePath = new TreePath(objectArray2);
                if (treePath == null) {
                    return;
                }
                Node node2 = ((HeapModel)((LeakTask)LeakTask.this).ht.getModel()).rootPerson;
                ((HeapModel)((LeakTask)LeakTask.this).ht.getModel()).rootPerson = node;
                ((HeapModel)LeakTask.this.ht.getModel()).fireTreeStructureChanged(node2);
                l2 = System.currentTimeMillis();
                LeakTask.this.ht.scrollPathToVisible(treePath);
                LeakTask.this.ht.setSelectionPath(treePath);
                LeakTask.this.ha.dp.hide();
            } else {
                Object object;
                ((LeakTask)LeakTask.this).ht.moreParentsMenuItem.setEnabled(false);
                ((LeakTask)LeakTask.this).ht.showFromRootsMenuItem.setEnabled(false);
                if (((HeapModel)((LeakTask)LeakTask.this).ht.getModel()).rootPerson.getIndex() != -1) {
                    object = new Node(-1, (int)HeapAnalyzer.MAX_SUBTREE);
                    Node node = ((HeapModel)((LeakTask)LeakTask.this).ht.getModel()).rootPerson;
                    ((HeapModel)((LeakTask)LeakTask.this).ht.getModel()).rootPerson = object;
                    ((HeapModel)LeakTask.this.ht.getModel()).fireTreeStructureChanged(node);
                }
                if ((object = LeakTask.this.returnTreePath(l)) == null) {
                    return;
                }
                LeakTask.this.ht.scrollPathToVisible((TreePath)object);
                LeakTask.this.ht.setSelectionPath((TreePath)object);
                LeakTask.this.ha.dp.hide();
            }
        }
    }
}

