/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.DirectBuffer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.Node;
import java.awt.Color;
import java.awt.Component;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class MyRenderer
extends DefaultTreeCellRenderer {
    HeapInfo hi;
    HeapModel model;
    boolean percentage;
    static NumberFormat nf = NumberFormat.getNumberInstance();

    public MyRenderer() {
    }

    public MyRenderer(HeapInfo heapInfo, HeapModel heapModel, boolean bl) {
        this.hi = heapInfo;
        this.model = heapModel;
        this.percentage = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        int n2 = ((Node)object).getIndex();
        if (n2 == -1) {
            if (this.percentage) {
                this.setText("TotalSize (TotalSize/HeapSize%) [ObjectSize] NumberOfChildObject(" + nf.format(this.hi.getRootChildrenLength()) + ") ObjectName Address");
            } else {
                this.setText("TotalSize [ObjectSize] NumberOfChildObject(" + nf.format(this.hi.getRootChildrenLength()) + ") ObjectName Address");
            }
            this.setIcon(new ImageIcon(this.getClass().getResource("/tree.gif")));
        } else if (n2 == -2) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/more16.gif")));
            this.setText("There are " + nf.format(((Node)object).getNumberOfChildren()) + " more children");
        } else {
            if (this.hi.isSuspect(n2)) {
                this.setForeground(Color.blue);
            }
            String string = "";
            if (((Node)object).isDup()) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
            }
            if (this.hi.isHav() || ((Node)object).isHav()) {
                if (this.hi.backgroundThread != null) {
                    this.hi.backgroundThread.interrupt();
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                if (this.hi.getHav().raf != null) {
                    try {
                        RandomAccessFile randomAccessFile = this.hi.getHav().raf;
                        synchronized (randomAccessFile) {
                            long l6 = ((Node)object).getLocation();
                            this.hi.getHav().raf.seek(l6 + this.hi.getHav().getHeapBaseLocation());
                            l5 = this.hi.getHav().read(this.hi.getHav().raf) + this.hi.getBaseAddress();
                            l2 = this.hi.getHav().read(this.hi.getHav().raf);
                            l = this.hi.getHav().read(this.hi.getHav().raf) + l2;
                            l4 = this.hi.getHav().readName(this.hi.getHav().raf);
                            if ((l4 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                                string = "array of ";
                            }
                            if ((l4 & 0x4000000000000000L) == 0x4000000000000000L) {
                                string = "class ";
                            }
                            l4 &= 0x3FFFFFFFFFFFFFFFL;
                            long l7 = this.hi.getHav().raf.readInt();
                            this.hi.getHav().raf.seek(l7 + this.hi.getHav().getHeapBaseLocation());
                            this.hi.getHav().read(this.hi.getHav().raf);
                            l3 = this.hi.getHav().read(this.hi.getHav().raf);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (this.model.rootPerson.getLocation() != 0L && this.model.rootPerson.getLocation() == ((Node)object).getLocation()) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/MP16.gif")));
                    } else if (this.hi.getHav().getName(l4).indexOf("[]") >= 0) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/array.gif")));
                    } else if (string.indexOf("class ") >= 0) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/class.gif")));
                    } else if (string.indexOf("array of") >= 0) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/array.gif")));
                    } else if (((Node)object).isDup()) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
                    } else {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/object.gif")));
                    }
                } else {
                    DirectBuffer directBuffer = this.hi.getHav().heapBuffer;
                    synchronized (directBuffer) {
                        long l8 = ((Node)object).getLocation();
                        this.hi.getHav().heapBuffer.position(l8);
                        l5 = this.hi.getHav().heapBuffer.read() + this.hi.getBaseAddress();
                        l2 = this.hi.getHav().heapBuffer.read();
                        l = this.hi.getHav().heapBuffer.read() + l2;
                        l4 = this.hi.getHav().heapBuffer.readName();
                        if ((l4 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                            string = "array of ";
                        }
                        if ((l4 & 0x4000000000000000L) == 0x4000000000000000L) {
                            string = "class ";
                        }
                        l4 &= 0x3FFFFFFFFFFFFFFFL;
                        long l9 = this.hi.getHav().heapBuffer.getInt();
                        this.hi.getHav().heapBuffer.setPosition(l9);
                        this.hi.getHav().heapBuffer.read();
                        l3 = this.hi.getHav().heapBuffer.read();
                    }
                }
                this.setText(nf.format(l) + " (" + 100L * l / this.hi.getHeapSize() + "%)" + " [" + nf.format(l2) + "] " + nf.format(l3) + " " + string + this.hi.getHav().getName(l4) + " 0x" + Long.toHexString(l5));
            } else {
                String string2 = null;
                string2 = this.hi.isAddress64() ? " 0x" + Long.toHexString(this.hi.getAddress(n2)) : " 0x" + Integer.toHexString((int)this.hi.getAddress(n2));
                if (this.hi.getName(n2) == null) {
                    if (((Node)object).isDup()) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
                    } else if (this.hi.isArray(n2)) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/array.gif")));
                    } else {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/object.gif")));
                    }
                    if (this.model.rootPerson.getIndex() == n2) {
                        this.setIcon(new ImageIcon(this.getClass().getResource("/MP16.gif")));
                    }
                    if (this.hi.getChild()[n2] != null) {
                        if (this.percentage) {
                            this.setText(nf.format(this.hi.getTotal(n2)) + " (" + 100L * this.hi.getTotal(n2) / this.hi.getHeapSize() + "%)" + " [" + nf.format(this.hi.getSize(n2)) + "] " + nf.format(this.hi.getChild()[n2].length) + " " + "Unknown" + string2);
                        } else {
                            this.setText(nf.format(this.hi.getTotal(n2)) + " [" + nf.format(this.hi.getSize(n2)) + "] " + nf.format(this.hi.getChild()[n2].length) + " " + "Unknown" + string2);
                        }
                    } else if (this.percentage) {
                        this.setText(nf.format(this.hi.getTotal(n2)) + " (" + 100L * this.hi.getTotal(n2) / this.hi.getHeapSize() + "%)" + " [" + nf.format(this.hi.getSize(n2)) + "] 0 " + "Unknown" + string2);
                    } else {
                        this.setText(nf.format(this.hi.getTotal(n2)) + " [" + nf.format(this.hi.getSize(n2)) + "] 0 " + "Unknown" + string2);
                    }
                    return this;
                }
                if (((Node)object).isDup()) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/Dup16.gif")));
                } else if (this.hi.getName(n2).indexOf("[]") >= 0) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/array.gif")));
                } else if (this.hi.isClass(n2) || this.hi.getName(n2).indexOf("class ") >= 0) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/class.gif")));
                } else if (this.hi.isArray(n2)) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/array.gif")));
                } else {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/object.gif")));
                }
                if (this.model.rootPerson.getIndex() == n2) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/MP16.gif")));
                }
                if (this.hi.getChild()[n2] != null) {
                    if (this.percentage) {
                        this.setText(nf.format(this.hi.getTotal(n2)) + " (" + 100L * this.hi.getTotal(n2) / this.hi.getHeapSize() + "%)" + " [" + nf.format(this.hi.getSize(n2)) + "] " + nf.format(this.hi.getChild()[n2].length) + " " + this.hi.getName(n2) + string2);
                    } else {
                        this.setText(nf.format(this.hi.getTotal(n2)) + " [" + nf.format(this.hi.getSize(n2)) + "] " + nf.format(this.hi.getChild()[n2].length) + " " + this.hi.getName(n2) + string2);
                    }
                } else if (this.percentage) {
                    this.setText(nf.format(this.hi.getTotal(n2)) + " (" + 100L * this.hi.getTotal(n2) / this.hi.getHeapSize() + "%)" + " [" + nf.format(this.hi.getSize(n2)) + "] 0 " + this.hi.getName(n2) + string2);
                } else {
                    this.setText(nf.format(this.hi.getTotal(n2)) + " [" + nf.format(this.hi.getSize(n2)) + "] 0 " + this.hi.getName(n2) + string2);
                }
            }
        }
        return this;
    }
}

