/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FileProcessDialog;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.zip.GZIPInputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class OpenTask {
    long startTime = 0L;
    private boolean isHeadless;
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private FileProcessDialog jp = null;
    private HeapInfo hi = null;

    public OpenTask(File file) {
        this.file = file;
        this.setHeadless();
        this.lengthOfTask = 100;
        this.setHeapInfo(this.hi);
    }

    public OpenTask(HeapAnalyzer heapAnalyzer, File file, FileProcessDialog fileProcessDialog, HeapInfo heapInfo) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = fileProcessDialog;
        this.setHeapInfo(heapInfo);
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                OpenTask.this.current = 0;
                OpenTask.this.done = false;
                OpenTask.this.canceled = false;
                OpenTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public HeapInfo getHeapInfo() {
        return this.hi;
    }

    class ActualTask {
        ActualTask() {
            this.processHeapDump();
        }

        void processHeapDump() {
            Object object;
            Object object2;
            OpenTask.this.startTime = System.currentTimeMillis();
            if (!OpenTask.this.isHeadless()) {
                OpenTask.this.jp.setTitle("Load processed heap dump");
                OpenTask.this.jp.setMessageText("Please wait while " + OpenTask.this.file.getName() + " is being loaded");
            }
            try {
                object2 = new GZIPInputStream(new FileInputStream(OpenTask.this.file));
                object = new ObjectInputStream((InputStream)object2);
                OpenTask.this.setHeapInfo((HeapInfo)((ObjectInputStream)object).readObject());
                ((ObjectInputStream)object).close();
                ((GZIPInputStream)object2).close();
            }
            catch (Exception exception) {
                if (!OpenTask.this.isHeadless()) {
                    OpenTask.this.jp.dispose();
                    OpenTask.this.ha.handleException(exception);
                    OpenTask.this.done = true;
                    JOptionPane.showMessageDialog(OpenTask.this.ha, "Cannot understand file :" + OpenTask.this.file.getAbsoluteFile(), "File Format Error", 2);
                } else {
                    System.out.println("Cannot understand file :" + OpenTask.this.file.getAbsoluteFile());
                    exception.printStackTrace();
                }
                return;
            }
            if (!OpenTask.this.isHeadless()) {
                OpenTask.this.jp.setMessageText(OpenTask.this.file.getName() + " was loaded succesfully");
                OpenTask.this.jp.setIndeterminate(false);
                OpenTask.this.jp.setJProgressBar1Value(100);
                OpenTask.this.jp.setOkButtonVisible(true);
                object2 = new HeapFrame(OpenTask.this.file.getName(), OpenTask.this.getHeapInfo());
                ((HeapFrame)object2).fileName = OpenTask.this.file.getName();
                OpenTask.this.getHeapInfo().setFile(OpenTask.this.file);
                object = new JTextArea();
                ((JTextComponent)object).setDragEnabled(true);
                ((JTextComponent)object).setEditable(false);
                ((JTextArea)object).append("Heap dump file name : " + OpenTask.this.file.getAbsoluteFile() + "\n");
                ((JTextArea)object).append(OpenTask.this.getHeapInfo().getDumpInfo() + "\n");
                ((HeapFrame)object2).JScrollPaneSetViewportView((Component)object);
                OpenTask.this.ha.getJDesktopPane1().add((Component)object2);
                OpenTask.this.ha.getJDesktopPane1().getDesktopManager().activateFrame((JInternalFrame)object2);
                try {
                    ((JInternalFrame)object2).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            } else {
                System.out.println("Heap dump file name : " + OpenTask.this.file.getAbsoluteFile() + "\n");
                System.out.println(OpenTask.this.getHeapInfo().getDumpInfo() + "\n");
            }
        }
    }
}

