/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapFrame;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.SortTask;
import com.ibm.jinwoo.heap.SuspectTask;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class PHDTask {
    static final int bufferSize = 102400;
    private boolean isHeadless;
    int objectCount;
    int objectArrayCount;
    int classCount;
    int primitiveArrayCount;
    int totalObjectCount;
    int refCount;
    long startTime = 0L;
    int zzz = 0;
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    public static final String[] types = new String[]{"bool", "char", "float", "double", "byte", "short", "int", "long"};
    public static final int START_OF_HEADER = 1;
    public static final int START_OF_DUMP = 2;
    public static final int END_OF_DUMP = 3;
    public static final int LONG_OBJECT_RECORD = 4;
    public static final int OBJECT_ARRAY_RECORD = 5;
    public static final int CLASS_RECORD = 6;
    public static final int PRIMITIVE_ARRAY_RECORD = 7;
    public static final int NEW_OBJECT_ARRAY_RECORD = 8;
    public static final int TOTALS = 1;
    public static final int END_OF_HEADER = 2;
    public static final int HASHCODE_RANDOMS = 3;
    public static final int FULL_VERSION = 4;
    DataInputStream dis;
    String sdkFullVersion;
    boolean isJ9 = false;
    boolean is64 = false;
    boolean sov78432 = false;
    static final long long32bit = 0xFFFFFFFFL;
    int shift = 3;
    int version;
    int dumpFlags;
    boolean dbg = false;
    int totalObjects;
    int totalRefs;
    int random1;
    int random2;
    long[] classAddressCache = new long[4];
    long lastAddress;
    int classAddressCacheIndex;
    private HeapInfo hi = null;

    public PHDTask(HeapAnalyzer heapAnalyzer, File file) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.lengthOfTask = 1000;
    }

    public PHDTask(File file) {
        this.file = file;
        this.setHeadless();
        this.lengthOfTask = 100;
    }

    public PHDTask(HeapAnalyzer heapAnalyzer, File file, JDialogProgress jDialogProgress) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = jDialogProgress;
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    int getHashCode(long l, int n) throws Exception {
        if (this.isJ9) {
            return this.dis.readShort();
        }
        if (n != 0) {
            return this.dis.readInt();
        }
        return this.MANGLE(this.Handle2Hash(l));
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    long getRelativeAddress(int n) {
        long l = 0L;
        try {
            switch (n) {
                case 0: {
                    l = this.lastAddress + (long)(this.dis.readByte() << this.shift);
                    break;
                }
                case 1: {
                    l = this.lastAddress + (long)(this.dis.readShort() << this.shift);
                    break;
                }
                case 2: {
                    l = this.lastAddress + (long)(this.dis.readInt() << this.shift);
                    break;
                }
                case 3: {
                    l = this.lastAddress + (this.dis.readLong() << this.shift);
                }
            }
        }
        catch (Exception exception) {
            throw new Error("Getting relative address, unexpected error: " + exception);
        }
        if (!this.is64) {
            l &= 0xFFFFFFFFL;
        }
        return l;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                PHDTask.this.current = 0;
                PHDTask.this.done = false;
                PHDTask.this.canceled = false;
                PHDTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    int Handle2Hash(long l) {
        return (int)(l >>> 3);
    }

    public boolean isDone() {
        return this.done;
    }

    int MANGLE(int n) {
        return (this.ROTATE(n ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    long readLong() throws Exception {
        if ((this.dumpFlags & 1) != 0) {
            return this.dis.readLong();
        }
        return 0xFFFFFFFFL & (long)this.dis.readInt();
    }

    long[] readRefs(long l, int n, int n2) throws Exception {
        long[] lArray = new long[n];
        long l2 = 0L;
        if (this.dbg) {
            System.out.println("readRefs, numRefs = " + n + " refsSize = " + n2);
        }
        for (int i = 0; i < n; ++i) {
            l2 = n2 == 0 ? (long)(this.dis.readByte() << this.shift) : (n2 == 1 ? (long)(this.dis.readShort() << this.shift) : (n2 == 2 ? (long)(this.dis.readInt() << this.shift) : this.dis.readLong() << this.shift));
            long l3 = lArray[i] = this.is64 ? l + l2 : l + l2 & 0xFFFFFFFFL;
            if (!this.dbg) continue;
            System.out.println("read ref " + Long.toHexString(lArray[i]) + " with gap " + Long.toHexString(l2));
        }
        if (this.dbg) {
            System.out.println("end of readRefs");
        }
        return lArray;
    }

    long readWord() throws Exception {
        if ((this.dumpFlags & 1) != 0) {
            return this.dis.readLong();
        }
        return this.dis.readInt();
    }

    int ROTATE(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    int roundup(int n) {
        return n + 7 & 0xFFFFFFF8;
    }

    public void skipHeader(DataInputStream dataInputStream) throws Exception {
        int n;
        dataInputStream.readUTF();
        dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readUnsignedByte();
        block6: do {
            n = this.dis.readUnsignedByte();
            switch (n) {
                case 1: {
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    break;
                }
                case 4: {
                    dataInputStream.readUTF();
                    if (!this.dbg) continue block6;
                    System.out.println(this.sdkFullVersion);
                    break;
                }
                default: {
                    throw new Exception("unrecognized tag: " + n);
                }
            }
        } while (n != 2);
        n = this.dis.readUnsignedByte();
        if (n != 2) {
            throw new Exception("Cannot find dump. Corrupted phd file");
        }
        if (this.dbg) {
            System.out.println("read start of dump tag");
        }
    }

    int skipRefs(int n, int n2) throws Exception {
        boolean bl = false;
        if (this.dbg) {
            System.out.println("skipRefs, numRefs = " + n + " refsSize = " + n2);
        }
        for (int i = 0; i < n; ++i) {
            if (n2 == 0) {
                this.dis.readByte();
                continue;
            }
            if (n2 == 1) {
                this.dis.readShort();
                continue;
            }
            if (n2 == 2) {
                this.dis.readInt();
                continue;
            }
            this.dis.readLong();
        }
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return 2 * n;
            }
            case 2: {
                return 4 * n;
            }
        }
        return 8 * n;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    public void done() {
        this.done = true;
    }

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    public void setHeapInfo(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public HeapInfo getHeapInfo() {
        return this.hi;
    }

    public InputStream getInputStream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
            try {
                return new ZipInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                return new FileInputStream(file);
            }
        }
        return new FileInputStream(file);
    }

    public class ClassTable {
        long address;
        String name;
        int size;

        public ClassTable(long l, String string, int n) {
            this.address = l;
            this.name = string;
            this.size = n;
        }
    }

    class ActualTask {
        public void processHeapDump() {
            int n;
            int n2;
            int n3;
            int n4;
            ClassTable classTable;
            int n5;
            Object object;
            BufferedInputStream bufferedInputStream;
            InputStream inputStream;
            PHDTask.this.startTime = System.currentTimeMillis();
            long l = 0L;
            long l2 = 0L;
            Boolean bl = null;
            long l3 = 0L;
            long l4 = PHDTask.this.file.length();
            long l5 = 0L;
            PHDTask.this.setHeapInfo(new HeapInfo());
            int n6 = 0;
            boolean bl2 = false;
            PHDTask.this.getHeapInfo().setDumpInfo("");
            long l6 = 0L;
            int n7 = 0;
            long l7 = 0L;
            Object var23_12 = null;
            boolean bl3 = false;
            int n8 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            l7 = 0L;
            PHDTask.this.current = 0;
            PHDTask.this.overall = 0;
            PHDTask.this.statMessage = "Loading heap dump file";
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setMaximum(100);
                PHDTask.this.jp.getJProgressBar1().setStringPainted(true);
            }
            boolean bl6 = false;
            long l8 = 0L;
            long l9 = 0L;
            long[] lArray = null;
            Hashtable<Long, ClassTable> hashtable = new Hashtable<Long, ClassTable>();
            try {
                inputStream = PHDTask.this.getInputStream(PHDTask.this.file);
                bufferedInputStream = new BufferedInputStream(inputStream, 102400);
                PHDTask.this.dis = new DataInputStream(bufferedInputStream);
                object = PHDTask.this.dis.readUTF();
                if (((String)object).equals("portable heap dump")) {
                    PHDTask.this.version = PHDTask.this.dis.readInt();
                    l7 += 4L;
                    if (PHDTask.this.version != 4 && PHDTask.this.version != 5) {
                        throw new Exception("unexpected version: " + PHDTask.this.version);
                    }
                } else {
                    throw new Exception("bad header " + (String)object);
                }
                if (PHDTask.this.version == 5) {
                    --PHDTask.this.shift;
                }
                PHDTask.this.dumpFlags = PHDTask.this.dis.readInt();
                l7 += 4L;
                boolean bl7 = PHDTask.this.is64 = (PHDTask.this.dumpFlags & 1) != 0;
                if ((PHDTask.this.dumpFlags & 4) != 0) {
                    PHDTask.this.shift = 2;
                    PHDTask.this.isJ9 = true;
                    PHDTask.this.getHeapInfo().setJ9(true);
                }
                n5 = PHDTask.this.dis.readUnsignedByte();
                ++l7;
                if (n5 != 1) {
                    throw new Exception("Cannot find header. Corrupted phd file");
                }
                block37: do {
                    n5 = PHDTask.this.dis.readUnsignedByte();
                    ++l7;
                    switch (n5) {
                        case 1: {
                            PHDTask.this.totalObjects = PHDTask.this.dis.readInt();
                            PHDTask.this.totalRefs = PHDTask.this.dis.readInt();
                            l7 += 8L;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            PHDTask.this.random1 = PHDTask.this.dis.readInt();
                            PHDTask.this.random2 = PHDTask.this.dis.readInt();
                            l7 += 8L;
                            break;
                        }
                        case 4: {
                            PHDTask.this.sdkFullVersion = PHDTask.this.dis.readUTF();
                            l7 += (long)PHDTask.this.sdkFullVersion.length();
                            if (PHDTask.this.sdkFullVersion.endsWith("20040917")) {
                                PHDTask.this.sov78432 = true;
                            }
                            if (!PHDTask.this.dbg) continue block37;
                            System.out.println(PHDTask.this.sdkFullVersion);
                            break;
                        }
                        default: {
                            throw new Exception("Bad Heapdump. Unexpected tag: " + n5);
                        }
                    }
                } while (n5 != 2);
                n5 = PHDTask.this.dis.readUnsignedByte();
                ++l7;
                if (n5 != 2) {
                    throw new Exception("Cannot find dump. Corrupted phd file");
                }
                l7 = 0L;
                if (PHDTask.this.dbg) {
                    System.out.println("First pass");
                }
                while (!bl6) {
                    int n9;
                    int n10;
                    PHDTask.this.current = (int)(100L * l7 / l4);
                    PHDTask.this.overall = 15 * PHDTask.this.current / 100;
                    n5 = PHDTask.this.dis.readUnsignedByte();
                    ++l7;
                    if (PHDTask.this.dbg) {
                        System.out.println("read tag " + Integer.toHexString(n5));
                    }
                    if ((n5 & 0x80) != 0) {
                        long l10 = PHDTask.this.classAddressCache[(n5 &= 0x7F) >> 5];
                        n10 = n5 >> 3 & 3;
                        int n11 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        if (l6 == 0L) {
                            l = l8;
                            l2 = l8;
                        } else {
                            if (l8 < l) {
                                l = l8;
                            }
                            if (l8 > l2) {
                                l2 = l8;
                            }
                        }
                        n9 = PHDTask.this.getHashCode(l8, 0);
                        if (PHDTask.this.isJ9) {
                            l7 += 2L;
                        }
                        l7 += (long)PHDTask.this.skipRefs(n10, n11);
                        ++l6;
                        classTable = (ClassTable)hashtable.get(new Long(l10));
                        if (classTable == null) {
                            hashtable.put(new Long(l10), new ClassTable(l10, "unknown class at 0x" + Long.toHexString(l10), 0));
                            if (PHDTask.this.dbg) {
                                System.out.println("Adding unknown class at 0x" + Long.toHexString(l10));
                            }
                        }
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": short object, class = " + Long.toHexString(l10));
                        }
                    } else if ((n5 & 0x40) != 0) {
                        int n12 = (n5 &= 0x3F) >> 3;
                        int n13 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        if (l6 == 0L) {
                            l = l8;
                            l2 = l8;
                        } else {
                            if (l8 < l) {
                                l = l8;
                            }
                            if (l8 > l2) {
                                l2 = l8;
                            }
                        }
                        long l11 = PHDTask.this.readLong();
                        l7 += 8L;
                        PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l11;
                        PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                        n9 = PHDTask.this.getHashCode(l8, 0);
                        if (PHDTask.this.isJ9) {
                            l7 += 2L;
                        }
                        l7 += (long)PHDTask.this.skipRefs(n12, n13);
                        ++l6;
                        classTable = (ClassTable)hashtable.get(new Long(l11));
                        if (classTable == null) {
                            hashtable.put(new Long(l11), new ClassTable(l11, "unknown class at 0x" + Long.toHexString(l11), 0));
                            if (PHDTask.this.dbg) {
                                System.out.println("Adding unknown class at 0x" + Long.toHexString(l11));
                            }
                        }
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": medium object");
                        }
                    } else if ((n5 & 0x20) != 0) {
                        int n14 = n5 >> 2 & 7;
                        int n15 = n5 & 3;
                        n10 = 0;
                        if (PHDTask.this.sov78432 && n15 == 3) {
                            l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readInt() << PHDTask.this.shift);
                            n10 = PHDTask.this.dis.readInt();
                            l7 += 8L;
                        } else {
                            l8 = PHDTask.this.getRelativeAddress(n15);
                            if (n15 == 0) {
                                try {
                                    n10 = PHDTask.this.dis.readUnsignedByte();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                ++l7;
                            } else if (n15 == 1) {
                                n10 = PHDTask.this.dis.readUnsignedShort();
                                l7 += 2L;
                            } else if (n15 == 2) {
                                n10 = PHDTask.this.dis.readInt();
                                l7 += 4L;
                            } else {
                                n10 = (int)PHDTask.this.dis.readLong();
                                l7 += 8L;
                            }
                        }
                        if (l6 == 0L) {
                            l = l8;
                            l2 = l8;
                        } else {
                            if (l8 < l) {
                                l = l8;
                            }
                            if (l8 > l2) {
                                l2 = l8;
                            }
                        }
                        int n16 = PHDTask.this.getHashCode(l8, 0);
                        if (PHDTask.this.isJ9) {
                            l7 += 2L;
                        }
                        ++l6;
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": primitive array of length " + n10);
                        }
                    } else {
                        switch (n5) {
                            case 3: {
                                bl6 = true;
                                break;
                            }
                            case 4: {
                                int n17 = PHDTask.this.dis.readUnsignedByte();
                                ++l7;
                                l8 = PHDTask.this.getRelativeAddress(n17 >> 6 & 3);
                                if (l6 == 0L) {
                                    l = l8;
                                    l2 = l8;
                                } else {
                                    if (l8 < l) {
                                        l = l8;
                                    }
                                    if (l8 > l2) {
                                        l2 = l8;
                                    }
                                }
                                long l12 = PHDTask.this.readLong();
                                l7 += 8L;
                                PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l12;
                                PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                                int n18 = PHDTask.this.getHashCode(l8, n17 & 2);
                                if (PHDTask.this.isJ9) {
                                    l7 += 2L;
                                } else if ((n17 & 2) != 0) {
                                    l7 += 4L;
                                }
                                n9 = PHDTask.this.dis.readInt();
                                l7 += 4L;
                                int n19 = n17 >> 4 & 3;
                                l7 += (long)PHDTask.this.skipRefs(n9, n19);
                                ++l6;
                                classTable = (ClassTable)hashtable.get(new Long(l12));
                                if (classTable == null) {
                                    hashtable.put(new Long(l12), new ClassTable(l12, "unknown class at 0x" + Long.toHexString(l12), 0));
                                    if (PHDTask.this.dbg) {
                                        System.out.println("Adding unknown class at 0x" + Long.toHexString(l12));
                                    }
                                }
                                if (!PHDTask.this.dbg) break;
                                System.out.println(Long.toHexString(l8) + ": long object, hash code = " + Integer.toHexString(n18) + " flags = " + Integer.toHexString(n17) + " class = " + Long.toHexString(l12) + " numRefs = " + n9);
                                break;
                            }
                            case 5: 
                            case 8: {
                                int n20 = PHDTask.this.dis.readUnsignedByte();
                                ++l7;
                                l8 = PHDTask.this.getRelativeAddress(n20 >> 6 & 3);
                                if (l6 == 0L) {
                                    l = l8;
                                    l2 = l8;
                                } else {
                                    if (l8 < l) {
                                        l = l8;
                                    }
                                    if (l8 > l2) {
                                        l2 = l8;
                                    }
                                }
                                long l13 = PHDTask.this.readLong();
                                l7 += 8L;
                                int n21 = PHDTask.this.getHashCode(l8, n20 & 2);
                                if (PHDTask.this.isJ9) {
                                    l7 += 2L;
                                } else if ((n20 & 2) != 0) {
                                    l7 += 4L;
                                }
                                n9 = PHDTask.this.dis.readInt();
                                l7 += 4L;
                                int n22 = n20 >> 4 & 3;
                                l7 += (long)PHDTask.this.skipRefs(n9, n22);
                                if (n5 == 8) {
                                    PHDTask.this.dis.readInt();
                                }
                                ++l6;
                                classTable = (ClassTable)hashtable.get(new Long(l13));
                                if (classTable == null) {
                                    hashtable.put(new Long(l13), new ClassTable(l13, "unknown class at 0x" + Long.toHexString(l13), 0));
                                    if (PHDTask.this.dbg) {
                                        System.out.println("Adding unknown class at 0x" + Long.toHexString(l13));
                                    }
                                }
                                if (!PHDTask.this.dbg) break;
                                System.out.println(Long.toHexString(l8) + ": object array, num refs = " + n9);
                                break;
                            }
                            case 6: {
                                int n23 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n23 >> 6 & 3);
                                if (l6 == 0L) {
                                    l = l8;
                                    l2 = l8;
                                } else {
                                    if (l8 < l) {
                                        l = l8;
                                    }
                                    if (l8 > l2) {
                                        l2 = l8;
                                    }
                                }
                                int n24 = PHDTask.this.dis.readInt();
                                n10 = PHDTask.this.getHashCode(l8, n23 & 8);
                                if (PHDTask.this.isJ9) {
                                    l7 += 2L;
                                } else if ((n23 & 8) != 0) {
                                    l7 += 4L;
                                }
                                long l14 = PHDTask.this.readLong();
                                l7 += 13L;
                                String string = PHDTask.this.dis.readUTF();
                                l7 += (long)string.length();
                                int n25 = PHDTask.this.dis.readInt();
                                l7 += 4L;
                                n4 = n23 >> 4 & 3;
                                l7 += (long)PHDTask.this.skipRefs(n25, n4);
                                hashtable.put(new Long(l8), new ClassTable(l8, string, n24));
                                ++l6;
                                if (!PHDTask.this.dbg) break;
                                System.out.println(Long.toHexString(l8) + ": class " + string);
                                break;
                            }
                            case 7: {
                                int n26 = PHDTask.this.dis.readUnsignedByte();
                                ++l7;
                                int n27 = n26 >>> 5;
                                n10 = 0;
                                if ((n26 & 0x10) == 0) {
                                    l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readByte() << PHDTask.this.shift);
                                    n10 = PHDTask.this.dis.readUnsignedByte();
                                    l7 += 2L;
                                } else {
                                    l8 = PHDTask.this.lastAddress + (PHDTask.this.readWord() << PHDTask.this.shift);
                                    n10 = (int)PHDTask.this.readLong();
                                    l7 += 8L;
                                }
                                if (l6 == 0L) {
                                    l = l8;
                                    l2 = l8;
                                } else {
                                    if (l8 < l) {
                                        l = l8;
                                    }
                                    if (l8 > l2) {
                                        l2 = l8;
                                    }
                                }
                                int n28 = PHDTask.this.getHashCode(l8, n26 & 2);
                                if (PHDTask.this.isJ9) {
                                    l7 += 2L;
                                } else if ((n26 & 2) != 0) {
                                    l7 += 4L;
                                }
                                ++l6;
                                if (!PHDTask.this.dbg) break;
                                System.out.println(Long.toHexString(l8) + ": primitive array");
                                break;
                            }
                            default: {
                                throw new Exception("Bad Heapdump. Unexpected tag: " + n5);
                            }
                        }
                    }
                    PHDTask.this.lastAddress = l8;
                }
                PHDTask.this.dis.close();
                bufferedInputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                if (!PHDTask.this.isHeadless()) {
                    PHDTask.this.ha.handleException(exception);
                    PHDTask.this.jp.dispose();
                    PHDTask.this.done = true;
                } else {
                    exception.printStackTrace();
                }
                return;
            }
            if (l6 > Integer.MAX_VALUE) {
                if (!PHDTask.this.isHeadless()) {
                    JOptionPane.showMessageDialog(PHDTask.this.ha, "Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes", "Error", 2);
                    PHDTask.this.jp.dispose();
                    PHDTask.this.done = true;
                } else {
                    System.out.println("Cannot process more than " + numberFormatter.format(Integer.MAX_VALUE) + " nodes");
                }
                return;
            }
            PHDTask.this.statMessage = "Loading address of heap node";
            PHDTask.this.overall = 15;
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setMaximum((int)l6);
                PHDTask.this.jp.getJProgressBar1().setStringPainted(true);
            }
            PHDTask.this.current = 0;
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(l6 * 8L) + " bytes of Java heap.");
            }
            if (l2 - l > Integer.MAX_VALUE) {
                PHDTask.this.getHeapInfo().setAddress64(true);
            }
            PHDTask.this.getHeapInfo().allocateAddress((int)l6);
            PHDTask.this.getHeapInfo().setBaseAddress(l);
            object = new Hashtable();
            PHDTask.this.getHeapInfo().setFile(PHDTask.this.file);
            int n29 = 0;
            l7 = 0L;
            l3 = 0L;
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setIndeterminate(false);
                PHDTask.this.jp.getJProgressBar1().setStringPainted(true);
            }
            PHDTask.this.classAddressCacheIndex = 0;
            try {
                if (PHDTask.this.dbg) {
                    System.out.println("Second pass");
                }
                l8 = 0L;
                PHDTask.this.lastAddress = 0L;
                inputStream = PHDTask.this.getInputStream(PHDTask.this.file);
                bufferedInputStream = new BufferedInputStream(inputStream, 102400);
                PHDTask.this.dis = new DataInputStream(bufferedInputStream);
                bl6 = false;
                PHDTask.this.skipHeader(PHDTask.this.dis);
                while (!bl6) {
                    int n30;
                    PHDTask.this.overall = 15 + (int)((long)(15 * PHDTask.this.current) / l6);
                    n5 = PHDTask.this.dis.readUnsignedByte();
                    if (PHDTask.this.dbg) {
                        System.out.println("read tag " + Integer.toHexString(n5));
                    }
                    if ((n5 & 0x80) != 0) {
                        long l15 = PHDTask.this.classAddressCache[(n5 &= 0x7F) >> 5];
                        int n31 = n5 >> 3 & 3;
                        int n32 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        n30 = PHDTask.this.getHashCode(l8, 0);
                        lArray = PHDTask.this.readRefs(l8, n31, n32);
                        PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                        classTable = (ClassTable)hashtable.get(new Long(l15));
                        bl = (Boolean)((Hashtable)object).get(classTable.name);
                        if (bl == null) {
                            ((Hashtable)object).put(classTable.name, new Boolean(true));
                        }
                        PHDTask.this.current++;
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": short object, class = " + Long.toHexString(l15));
                        }
                    } else if ((n5 & 0x40) != 0) {
                        long l16;
                        int n33 = (n5 &= 0x3F) >> 3;
                        int n34 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l16 = PHDTask.this.readLong();
                        PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                        n30 = PHDTask.this.getHashCode(l8, 0);
                        lArray = PHDTask.this.readRefs(l8, n33, n34);
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": medium object");
                        }
                        PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                        classTable = (ClassTable)hashtable.get(new Long(l16));
                        bl = (Boolean)((Hashtable)object).get(classTable.name);
                        if (bl == null) {
                            ((Hashtable)object).put(classTable.name, new Boolean(true));
                        }
                        PHDTask.this.current++;
                    } else if ((n5 & 0x20) != 0) {
                        int n35 = n5 >> 2 & 7;
                        int n36 = n5 & 3;
                        int n37 = 0;
                        if (PHDTask.this.sov78432 && n36 == 3) {
                            l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readInt() << PHDTask.this.shift);
                            n37 = PHDTask.this.dis.readInt();
                        } else {
                            l8 = PHDTask.this.getRelativeAddress(n36);
                            n37 = n36 == 0 ? PHDTask.this.dis.readUnsignedByte() : (n36 == 1 ? PHDTask.this.dis.readUnsignedShort() : (n36 == 2 ? PHDTask.this.dis.readInt() : (int)PHDTask.this.dis.readLong()));
                        }
                        int n38 = PHDTask.this.getHashCode(l8, 0);
                        PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": primitive array of length " + n37);
                        }
                        if ((bl = (Boolean)((Hashtable)object).get(types[n35] + "[]")) == null) {
                            ((Hashtable)object).put(types[n35] + "[]", new Boolean(true));
                        }
                        PHDTask.this.current++;
                    } else {
                        switch (n5) {
                            case 3: {
                                bl6 = true;
                                break;
                            }
                            case 4: {
                                long l17;
                                int n39 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n39 >> 6 & 3);
                                PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l17 = PHDTask.this.readLong();
                                PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                                int n40 = PHDTask.this.getHashCode(l8, n39 & 2);
                                n30 = PHDTask.this.dis.readInt();
                                int n41 = n39 >> 4 & 3;
                                if ((n39 & 8) == 8) {
                                    System.out.println("LO Pinned");
                                }
                                if ((n39 & 4) == 4) {
                                    System.out.println("LO Dosed");
                                }
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": long object, hash code = " + Integer.toHexString(n40) + " flags = " + Integer.toHexString(n39) + " class = " + Long.toHexString(l17) + " numRefs = " + n30);
                                }
                                lArray = PHDTask.this.readRefs(l8, n30, n41);
                                PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                                classTable = (ClassTable)hashtable.get(new Long(l17));
                                bl = (Boolean)((Hashtable)object).get(classTable.name);
                                if (bl == null) {
                                    ((Hashtable)object).put(classTable.name, new Boolean(true));
                                }
                                PHDTask.this.current++;
                                break;
                            }
                            case 5: 
                            case 8: {
                                int n42 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n42 >> 6 & 3);
                                long l18 = PHDTask.this.readLong();
                                int n43 = PHDTask.this.getHashCode(l8, n42 & 2);
                                n30 = PHDTask.this.dis.readInt();
                                int n44 = n42 >> 4 & 3;
                                if ((n42 & 8) == 8) {
                                    System.out.println("OA Pinned");
                                }
                                if ((n42 & 4) == 4) {
                                    System.out.println("OA Dosed");
                                }
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": object array, num refs = " + n30);
                                }
                                lArray = PHDTask.this.readRefs(l8, n30, n44);
                                n4 = n30;
                                if (n5 == 8) {
                                    n4 = PHDTask.this.dis.readInt();
                                }
                                PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                                classTable = (ClassTable)hashtable.get(new Long(l18));
                                if (classTable != null && PHDTask.this.dbg) {
                                    System.out.println(classTable.name);
                                }
                                if ((bl = (Boolean)((Hashtable)object).get(classTable.name)) == null) {
                                    ((Hashtable)object).put(classTable.name, new Boolean(true));
                                }
                                if (PHDTask.this.dbg) {
                                    System.out.println("##5");
                                }
                                PHDTask.this.current++;
                                break;
                            }
                            case 6: {
                                int n45 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n45 >> 6 & 3);
                                int n46 = PHDTask.this.dis.readInt();
                                int n47 = PHDTask.this.getHashCode(l8, n45 & 8);
                                long l19 = PHDTask.this.readLong();
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": class flags = " + Integer.toHexString(n45) + " instanceSize = " + n46 + " hashCode = " + Integer.toHexString(n47) + " superAddress = " + Long.toHexString(l19));
                                }
                                String string = PHDTask.this.dis.readUTF();
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": class " + string);
                                }
                                n4 = PHDTask.this.dis.readInt();
                                n3 = n45 >> 4 & 3;
                                lArray = PHDTask.this.readRefs(l8, n4, n3);
                                PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                                bl = (Boolean)((Hashtable)object).get(string);
                                if (bl == null) {
                                    ((Hashtable)object).put(string, new Boolean(true));
                                }
                                PHDTask.this.current++;
                                break;
                            }
                            case 7: {
                                int n48 = PHDTask.this.dis.readUnsignedByte();
                                int n49 = n48 >>> 5;
                                int n50 = 0;
                                if ((n48 & 0x10) == 0) {
                                    l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readByte() << PHDTask.this.shift);
                                    n50 = PHDTask.this.dis.readUnsignedByte();
                                } else {
                                    l8 = PHDTask.this.lastAddress + (PHDTask.this.readWord() << PHDTask.this.shift);
                                    n50 = (int)PHDTask.this.readLong();
                                }
                                int n51 = PHDTask.this.getHashCode(l8, n48 & 2);
                                PHDTask.this.getHeapInfo().setAddress(n29++, l8);
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": primitive array");
                                }
                                if ((bl = (Boolean)((Hashtable)object).get(types[n49] + "[]")) == null) {
                                    ((Hashtable)object).put(types[n49] + "[]", new Boolean(true));
                                }
                                PHDTask.this.current++;
                                break;
                            }
                            default: {
                                throw new Exception("Bad Heapdump. Unexpected tag: " + n5);
                            }
                        }
                    }
                    PHDTask.this.lastAddress = l8;
                }
                PHDTask.this.dis.close();
                bufferedInputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                if (!PHDTask.this.isHeadless()) {
                    PHDTask.this.ha.handleException(exception);
                    PHDTask.this.jp.dispose();
                    PHDTask.this.done = true;
                }
                exception.printStackTrace();
            }
            PHDTask.this.statMessage = "Sorting nodes by address";
            PHDTask.this.overall = 30;
            if (PHDTask.this.getHeapInfo().isAddress64()) {
                Arrays.sort(PHDTask.this.getHeapInfo().getAddressLong());
            } else {
                Arrays.sort(PHDTask.this.getHeapInfo().getAddress());
            }
            PHDTask.this.getHeapInfo().setNameTable(new String[((Hashtable)object).size()]);
            int n52 = 0;
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                PHDTask.this.getHeapInfo().setNameTable(n52++, (String)enumeration.nextElement());
            }
            ((Hashtable)object).clear();
            object = null;
            PHDTask.this.overall = 29;
            Arrays.sort(PHDTask.this.getHeapInfo().getNameTable());
            PHDTask.this.getHeapInfo().markReferences();
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(PHDTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setNameKey(new int[PHDTask.this.getHeapInfo().getAddressLength()]);
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(PHDTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setSize(new int[PHDTask.this.getHeapInfo().getAddressLength()]);
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(PHDTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setChild(new int[PHDTask.this.getHeapInfo().getAddressLength()][]);
            PHDTask.this.statMessage = "Processing heap node";
            PHDTask.this.overall = 30;
            PHDTask.this.current = 0;
            l3 = 0L;
            PHDTask.this.classAddressCacheIndex = 0;
            bl3 = false;
            n6 = 0;
            l7 = 0L;
            PHDTask.this.refCount = 0;
            try {
                if (PHDTask.this.dbg) {
                    System.out.println("3rd pass");
                }
                l8 = 0L;
                PHDTask.this.lastAddress = 0L;
                inputStream = PHDTask.this.getInputStream(PHDTask.this.file);
                bufferedInputStream = new BufferedInputStream(inputStream, 102400);
                PHDTask.this.dis = new DataInputStream(bufferedInputStream);
                bl6 = false;
                PHDTask.this.skipHeader(PHDTask.this.dis);
                while (!bl6) {
                    int n53;
                    int n54;
                    PHDTask.this.overall = 30 + (int)((long)(60 * PHDTask.this.current) / l6);
                    n5 = PHDTask.this.dis.readUnsignedByte();
                    if (PHDTask.this.dbg) {
                        System.out.println("read tag " + Integer.toHexString(n5));
                    }
                    if ((n5 & 0x80) != 0) {
                        long l20 = PHDTask.this.classAddressCache[(n5 &= 0x7F) >> 5];
                        int n55 = n5 >> 3 & 3;
                        int n56 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        n54 = PHDTask.this.getHashCode(l8, 0);
                        lArray = PHDTask.this.readRefs(l8, n55, n56);
                        PHDTask.this.refCount += lArray.length;
                        ++PHDTask.this.objectCount;
                        ++PHDTask.this.totalObjectCount;
                        n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                        classTable = (ClassTable)hashtable.get(new Long(l20));
                        if (PHDTask.this.isJ9) {
                            PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size));
                        } else {
                            PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size + 12));
                        }
                        n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), classTable.name);
                        PHDTask.this.current++;
                        if (n7 < 0) {
                            System.out.println("Could not find an object in an array");
                            throw new RuntimeException();
                        }
                        PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                        if (lArray != null) {
                            int n57 = 0;
                            if (PHDTask.this.getHeapInfo().isAddress64()) {
                                for (n3 = 0; n3 < lArray.length; ++n3) {
                                    if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress()) >= 0) continue;
                                    ++n57;
                                }
                            } else {
                                for (n3 = 0; n3 < lArray.length; ++n3) {
                                    if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress())) >= 0) continue;
                                    ++n57;
                                }
                            }
                            if (lArray.length - n57 > 0) {
                                PHDTask.this.getHeapInfo().getChild()[n6] = new int[lArray.length - n57];
                                if (PHDTask.this.getHeapInfo().isAddress64()) {
                                    n53 = 0;
                                    for (n3 = 0; n3 < lArray.length; ++n3) {
                                        n2 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress());
                                        if (n2 <= 0) continue;
                                        PHDTask.this.getHeapInfo().getChild()[n6][n53] = n2;
                                        ++n53;
                                    }
                                } else {
                                    n53 = 0;
                                    for (n3 = 0; n3 < lArray.length; ++n3) {
                                        n2 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress()));
                                        if (n2 <= 0) continue;
                                        PHDTask.this.getHeapInfo().getChild()[n6][n53] = n2;
                                        ++n53;
                                    }
                                }
                            }
                        }
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": short object, class = " + Long.toHexString(l20));
                        }
                    } else if ((n5 & 0x40) != 0) {
                        long l21;
                        int n58 = (n5 &= 0x3F) >> 3;
                        int n59 = n5 & 3;
                        l8 = PHDTask.this.getRelativeAddress(n5 >> 2 & 1);
                        PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l21 = PHDTask.this.readLong();
                        PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                        n54 = PHDTask.this.getHashCode(l8, 0);
                        lArray = PHDTask.this.readRefs(l8, n58, n59);
                        PHDTask.this.refCount += lArray.length;
                        ++PHDTask.this.objectCount;
                        ++PHDTask.this.totalObjectCount;
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": medium object");
                        }
                        n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                        classTable = (ClassTable)hashtable.get(new Long(l21));
                        if (PHDTask.this.isJ9) {
                            PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size));
                        } else {
                            PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size + 12));
                        }
                        n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), classTable.name);
                        if (n7 < 0) {
                            System.out.println("Could not find an object in an array");
                            throw new RuntimeException();
                        }
                        PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                        PHDTask.this.current++;
                        if (lArray != null) {
                            int n60 = 0;
                            if (PHDTask.this.getHeapInfo().isAddress64()) {
                                for (n3 = 0; n3 < lArray.length; ++n3) {
                                    if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress()) >= 0) continue;
                                    ++n60;
                                }
                            } else {
                                for (n3 = 0; n3 < lArray.length; ++n3) {
                                    if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress())) >= 0) continue;
                                    ++n60;
                                }
                            }
                            if (lArray.length - n60 > 0) {
                                PHDTask.this.getHeapInfo().getChild()[n6] = new int[lArray.length - n60];
                                if (PHDTask.this.getHeapInfo().isAddress64()) {
                                    n53 = 0;
                                    for (n3 = 0; n3 < lArray.length; ++n3) {
                                        n2 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress());
                                        if (n2 <= 0) continue;
                                        PHDTask.this.getHeapInfo().getChild()[n6][n53] = n2;
                                        ++n53;
                                    }
                                } else {
                                    n53 = 0;
                                    for (n3 = 0; n3 < lArray.length; ++n3) {
                                        n2 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n3] - PHDTask.this.getHeapInfo().getBaseAddress()));
                                        if (n2 <= 0) continue;
                                        PHDTask.this.getHeapInfo().getChild()[n6][n53] = n2;
                                        ++n53;
                                    }
                                }
                            }
                        }
                    } else if ((n5 & 0x20) != 0) {
                        int n61 = n5 >> 2 & 7;
                        int n62 = n5 & 3;
                        int n63 = 0;
                        if (PHDTask.this.sov78432 && n62 == 3) {
                            l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readInt() << PHDTask.this.shift);
                            n63 = PHDTask.this.dis.readInt();
                        } else {
                            l8 = PHDTask.this.getRelativeAddress(n62);
                            n63 = n62 == 0 ? PHDTask.this.dis.readUnsignedByte() : (n62 == 1 ? PHDTask.this.dis.readUnsignedShort() : (n62 == 2 ? PHDTask.this.dis.readInt() : (int)PHDTask.this.dis.readLong()));
                        }
                        int n64 = PHDTask.this.getHashCode(l8, 0);
                        ++PHDTask.this.primitiveArrayCount;
                        ++PHDTask.this.totalObjectCount;
                        PHDTask.this.current++;
                        n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                        if (PHDTask.this.isJ9) {
                            PHDTask.this.getHeapInfo().setSize(n6, (PHDTask.this.is64 ? 24 : 16) + PHDTask.this.roundup(n63 << (n61 & 3)));
                        } else {
                            PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup((PHDTask.this.is64 ? 20 : 12) + (n63 << (n61 & 3))));
                        }
                        n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), types[n61] + "[]");
                        if (n7 < 0) {
                            System.out.println("Could not find an object in an array");
                            throw new RuntimeException();
                        }
                        PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                        if (PHDTask.this.dbg) {
                            System.out.println(Long.toHexString(l8) + ": primitive array of length " + n63);
                        }
                    } else {
                        switch (n5) {
                            case 3: {
                                bl6 = true;
                                break;
                            }
                            case 4: {
                                int n65;
                                long l22;
                                int n66 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n66 >> 6 & 3);
                                PHDTask.this.classAddressCache[PHDTask.this.classAddressCacheIndex] = l22 = PHDTask.this.readLong();
                                PHDTask.this.classAddressCacheIndex = (PHDTask.this.classAddressCacheIndex + 1) % 4;
                                int n67 = PHDTask.this.getHashCode(l8, n66 & 2);
                                n54 = PHDTask.this.dis.readInt();
                                int n68 = n66 >> 4 & 3;
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": long object, hash code = " + Integer.toHexString(n67) + " flags = " + Integer.toHexString(n66) + " class = " + Long.toHexString(l22) + " numRefs = " + n54);
                                }
                                lArray = PHDTask.this.readRefs(l8, n54, n68);
                                PHDTask.this.refCount += lArray.length;
                                ++PHDTask.this.objectCount;
                                ++PHDTask.this.totalObjectCount;
                                PHDTask.this.current++;
                                n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                                classTable = (ClassTable)hashtable.get(new Long(l22));
                                if (PHDTask.this.dbg) {
                                    System.out.println("A");
                                }
                                if (PHDTask.this.isJ9) {
                                    PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size));
                                } else {
                                    PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup(classTable.size + 12));
                                }
                                if (PHDTask.this.dbg) {
                                    System.out.println("B");
                                }
                                if ((n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), classTable.name)) >= 0) {
                                    if (PHDTask.this.dbg) {
                                        System.out.println("C");
                                    }
                                    PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                                    if (PHDTask.this.dbg) {
                                        System.out.println("D");
                                    }
                                } else {
                                    System.out.println("Could not find an object in an array");
                                    throw new RuntimeException();
                                }
                                if (lArray != null) {
                                    n3 = 0;
                                    if (PHDTask.this.getHeapInfo().isAddress64()) {
                                        for (n53 = 0; n53 < lArray.length; ++n53) {
                                            if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n53] - PHDTask.this.getHeapInfo().getBaseAddress()) >= 0) continue;
                                            ++n3;
                                        }
                                    } else {
                                        for (n53 = 0; n53 < lArray.length; ++n53) {
                                            if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n53] - PHDTask.this.getHeapInfo().getBaseAddress())) >= 0) continue;
                                            ++n3;
                                        }
                                    }
                                    if (lArray.length - n3 > 0) {
                                        if (PHDTask.this.dbg) {
                                            System.out.println("E");
                                        }
                                        PHDTask.this.getHeapInfo().getChild()[n6] = new int[lArray.length - n3];
                                        if (PHDTask.this.dbg) {
                                            System.out.println("F");
                                        }
                                        if (PHDTask.this.getHeapInfo().isAddress64()) {
                                            n2 = 0;
                                            for (n53 = 0; n53 < lArray.length; ++n53) {
                                                n65 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n53] - PHDTask.this.getHeapInfo().getBaseAddress());
                                                if (n65 <= 0) continue;
                                                PHDTask.this.getHeapInfo().getChild()[n6][n2] = n65;
                                                ++n2;
                                            }
                                        } else {
                                            n2 = 0;
                                            for (n53 = 0; n53 < lArray.length; ++n53) {
                                                n65 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n53] - PHDTask.this.getHeapInfo().getBaseAddress()));
                                                if (n65 <= 0) continue;
                                                PHDTask.this.getHeapInfo().getChild()[n6][n2] = n65;
                                                ++n2;
                                            }
                                        }
                                    }
                                }
                                if (PHDTask.this.dbg) {
                                    System.out.println("I");
                                }
                                break;
                            }
                            case 5: 
                            case 8: {
                                int n69;
                                int n65;
                                int n70 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n70 >> 6 & 3);
                                long l23 = PHDTask.this.readLong();
                                int n71 = PHDTask.this.getHashCode(l8, n70 & 2);
                                n54 = PHDTask.this.dis.readInt();
                                int n72 = n70 >> 4 & 3;
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": object array, num refs = " + n54);
                                }
                                lArray = PHDTask.this.readRefs(l8, n54, n72);
                                n3 = n54;
                                if (n5 == 8) {
                                    n3 = PHDTask.this.dis.readInt();
                                }
                                PHDTask.this.refCount += lArray.length;
                                ++PHDTask.this.objectArrayCount;
                                ++PHDTask.this.totalObjectCount;
                                PHDTask.this.current++;
                                n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                                classTable = (ClassTable)hashtable.get(new Long(l23));
                                PHDTask.this.getHeapInfo().setSize(n6, (PHDTask.this.is64 ? 24 : 16) + PHDTask.this.roundup(n3 << (PHDTask.this.is64 ? 3 : 2)));
                                n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), classTable.name);
                                if (n7 < 0) {
                                    System.out.println("Could not find an object in an array");
                                    throw new RuntimeException();
                                }
                                PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                                PHDTask.this.getHeapInfo().setArray(n6);
                                if (lArray == null) break;
                                n53 = 0;
                                if (PHDTask.this.getHeapInfo().isAddress64()) {
                                    for (n2 = 0; n2 < lArray.length; ++n2) {
                                        if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n2] - PHDTask.this.getHeapInfo().getBaseAddress()) >= 0) continue;
                                        ++n53;
                                    }
                                } else {
                                    for (n2 = 0; n2 < lArray.length; ++n2) {
                                        if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n2] - PHDTask.this.getHeapInfo().getBaseAddress())) >= 0) continue;
                                        ++n53;
                                    }
                                }
                                if (lArray.length - n53 > 0) {
                                    PHDTask.this.getHeapInfo().getChild()[n6] = new int[lArray.length - n53];
                                    if (PHDTask.this.getHeapInfo().isAddress64()) {
                                        n65 = 0;
                                        for (n2 = 0; n2 < lArray.length; ++n2) {
                                            n69 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n2] - PHDTask.this.getHeapInfo().getBaseAddress());
                                            if (n69 <= 0) continue;
                                            PHDTask.this.getHeapInfo().getChild()[n6][n65] = n69;
                                            ++n65;
                                        }
                                    } else {
                                        n65 = 0;
                                        for (n2 = 0; n2 < lArray.length; ++n2) {
                                            n69 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n2] - PHDTask.this.getHeapInfo().getBaseAddress()));
                                            if (n69 <= 0) continue;
                                            PHDTask.this.getHeapInfo().getChild()[n6][n65] = n69;
                                            ++n65;
                                        }
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int n69;
                                int n65;
                                int n73 = PHDTask.this.dis.readUnsignedByte();
                                l8 = PHDTask.this.getRelativeAddress(n73 >> 6 & 3);
                                int n74 = PHDTask.this.dis.readInt();
                                int n75 = PHDTask.this.getHashCode(l8, n73 & 8);
                                long l24 = PHDTask.this.readLong();
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": class flags = " + Integer.toHexString(n73) + " instanceSize = " + n74 + " hashCode = " + Integer.toHexString(n75) + " superAddress = " + Long.toHexString(l24));
                                }
                                String string = PHDTask.this.dis.readUTF();
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": class " + string);
                                }
                                n3 = PHDTask.this.dis.readInt();
                                n53 = n73 >> 4 & 3;
                                lArray = PHDTask.this.readRefs(l8, n3, n53);
                                PHDTask.this.refCount += lArray.length;
                                ++PHDTask.this.classCount;
                                ++PHDTask.this.totalObjectCount;
                                PHDTask.this.current++;
                                n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                                classTable = (ClassTable)hashtable.get(new Long(l8));
                                if (PHDTask.this.isJ9) {
                                    PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.is64 ? 56 : 32);
                                } else {
                                    PHDTask.this.getHeapInfo().setSize(n6, 312);
                                }
                                if (PHDTask.this.getHeapInfo().getNameTable() == null) {
                                    System.out.println("table null");
                                }
                                if (classTable == null) {
                                    System.out.println("ct null");
                                }
                                if ((n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), classTable.name)) < 0) {
                                    System.out.println("Could not find an object in an array");
                                    throw new RuntimeException();
                                }
                                PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                                PHDTask.this.getHeapInfo().setClass(n6);
                                if (lArray == null) break;
                                n2 = 0;
                                if (PHDTask.this.getHeapInfo().isAddress64()) {
                                    for (n65 = 0; n65 < lArray.length; ++n65) {
                                        if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n65] - PHDTask.this.getHeapInfo().getBaseAddress()) >= 0) continue;
                                        ++n2;
                                    }
                                } else {
                                    for (n65 = 0; n65 < lArray.length; ++n65) {
                                        if (Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n65] - PHDTask.this.getHeapInfo().getBaseAddress())) >= 0) continue;
                                        ++n2;
                                    }
                                }
                                if (lArray.length - n2 > 0) {
                                    int n76;
                                    PHDTask.this.getHeapInfo().getChild()[n6] = new int[lArray.length - n2];
                                    if (PHDTask.this.getHeapInfo().isAddress64()) {
                                        n69 = 0;
                                        for (n65 = 0; n65 < lArray.length; ++n65) {
                                            n76 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), lArray[n65] - PHDTask.this.getHeapInfo().getBaseAddress());
                                            if (n76 <= 0) continue;
                                            PHDTask.this.getHeapInfo().getChild()[n6][n69] = n76;
                                            ++n69;
                                        }
                                    } else {
                                        n69 = 0;
                                        for (n65 = 0; n65 < lArray.length; ++n65) {
                                            n76 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(lArray[n65] - PHDTask.this.getHeapInfo().getBaseAddress()));
                                            if (n76 <= 0) continue;
                                            PHDTask.this.getHeapInfo().getChild()[n6][n69] = n76;
                                            ++n69;
                                        }
                                    }
                                }
                                break;
                            }
                            case 7: {
                                int n77 = PHDTask.this.dis.readUnsignedByte();
                                int n78 = n77 >>> 5;
                                int n79 = 0;
                                if ((n77 & 0x10) == 0) {
                                    l8 = PHDTask.this.lastAddress + (long)(PHDTask.this.dis.readByte() << PHDTask.this.shift);
                                    n79 = PHDTask.this.dis.readUnsignedByte();
                                } else {
                                    l8 = PHDTask.this.lastAddress + (PHDTask.this.readWord() << PHDTask.this.shift);
                                    n79 = (int)PHDTask.this.readLong();
                                }
                                int n80 = PHDTask.this.getHashCode(l8, n77 & 2);
                                if (PHDTask.this.dbg) {
                                    System.out.println(Long.toHexString(l8) + ": primitive array");
                                }
                                n6 = PHDTask.this.getHeapInfo().isAddress64() ? Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddressLong(), l8 - PHDTask.this.getHeapInfo().getBaseAddress()) : Arrays.binarySearch(PHDTask.this.getHeapInfo().getAddress(), (int)(l8 - PHDTask.this.getHeapInfo().getBaseAddress()));
                                ++PHDTask.this.primitiveArrayCount;
                                ++PHDTask.this.totalObjectCount;
                                PHDTask.this.current++;
                                if (PHDTask.this.isJ9) {
                                    PHDTask.this.getHeapInfo().setSize(n6, (PHDTask.this.is64 ? 24 : 16) + PHDTask.this.roundup(n79 << (n78 & 3)));
                                } else {
                                    PHDTask.this.getHeapInfo().setSize(n6, PHDTask.this.roundup((PHDTask.this.is64 ? 20 : 12) + (n79 << (n78 & 3))));
                                }
                                n7 = Arrays.binarySearch(PHDTask.this.getHeapInfo().getNameTable(), types[n78] + "[]");
                                if (n7 >= 0) {
                                    PHDTask.this.getHeapInfo().setNameKey(n6, n7);
                                    break;
                                }
                                System.out.println("Could not find an object in an array");
                                throw new RuntimeException();
                            }
                            default: {
                                throw new Exception("Bad Heapdump. Unexpected tag: " + n5);
                            }
                        }
                    }
                    PHDTask.this.lastAddress = l8;
                }
                PHDTask.this.dis.close();
                bufferedInputStream.close();
                inputStream.close();
            }
            catch (Exception exception) {
                if (!PHDTask.this.isHeadless()) {
                    PHDTask.this.ha.handleException(exception);
                    PHDTask.this.jp.dispose();
                    PHDTask.this.done = true;
                }
                exception.printStackTrace();
            }
            hashtable = null;
            PHDTask.this.getHeapInfo().setBits(new byte[PHDTask.this.getHeapInfo().getAddressLength()]);
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(PHDTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setParent(new int[PHDTask.this.getHeapInfo().getAddressLength()]);
            for (n8 = 0; n8 < PHDTask.this.getHeapInfo().getParent().length; ++n8) {
                PHDTask.this.getHeapInfo().getParent()[n8] = -1;
            }
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format(PHDTask.this.getHeapInfo().getAddressLength() * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setTotal(new long[PHDTask.this.getHeapInfo().getAddressLength()]);
            l6 = 0L;
            l7 = 0L;
            PHDTask.this.overall = 95;
            PHDTask.this.statMessage = "Searching parents of each object";
            PHDTask.this.current = 0;
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setMaximum(PHDTask.this.getHeapInfo().getAddressLength());
            }
            PHDTask.this.getHeapInfo().reorg();
            PHDTask.this.statMessage = "Analyzing pure roots";
            int n81 = 0;
            for (int i = 0; i < PHDTask.this.getHeapInfo().getAddressLength(); ++i) {
                if (PHDTask.this.getHeapInfo().getHasParent(i)) continue;
                ++n81;
            }
            int[] nArray = new int[n81];
            n81 = 0;
            for (int i = 0; i < PHDTask.this.getHeapInfo().getAddressLength(); ++i) {
                if (!PHDTask.this.getHeapInfo().getHasParent(i)) {
                    PHDTask.this.getHeapInfo().calculateTotal(i);
                    nArray[n81++] = i;
                }
                PHDTask.this.current++;
            }
            PHDTask.this.overall = 97;
            PHDTask.this.statMessage = "Analyzing pseudo roots";
            PHDTask.this.current = 0;
            l7 = 0L;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < PHDTask.this.getHeapInfo().getAddressLength(); ++n) {
                if (!PHDTask.this.getHeapInfo().getVisited(n) && PHDTask.this.getHeapInfo().getChild()[n] != null) {
                    PHDTask.this.getHeapInfo().calculateTotal(n);
                    arrayList.add(new Integer(n));
                }
                PHDTask.this.current++;
            }
            PHDTask.this.getHeapInfo().clearBits();
            if (!PHDTask.this.isHeadless() && PHDTask.this.ha.cfg.verbose) {
                System.out.println("[" + new Date() + "] Requesting " + numberFormatter.format((nArray.length + arrayList.size()) * 4) + " bytes of Java heap.");
            }
            PHDTask.this.getHeapInfo().setRootChildren(new int[nArray.length + arrayList.size()]);
            PHDTask.this.overall = 98;
            PHDTask.this.statMessage = "Analyzing root children";
            PHDTask.this.current = 0;
            n8 = 0;
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setMaximum(nArray.length + arrayList.size());
            }
            for (n = 0; n < nArray.length; ++n) {
                PHDTask.this.getHeapInfo().setRootChildren(n8++, nArray[n]);
                PHDTask.this.current++;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                PHDTask.this.getHeapInfo().setRootChildren(n8++, (Integer)arrayList.get(n));
                PHDTask.this.current++;
            }
            PHDTask.this.getHeapInfo().sortRootChildren();
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Java Version: " + PHDTask.this.sdkFullVersion + "\n");
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Number of Classes: " + numberFormatter.format(PHDTask.this.classCount) + "\nNumber of Objects: " + numberFormatter.format(PHDTask.this.objectCount) + "\nNumber of ObjectArrays: " + numberFormatter.format(PHDTask.this.objectArrayCount) + "\nNumber of PrimitiveArrays: " + numberFormatter.format(PHDTask.this.primitiveArrayCount) + "\n");
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Total Number of Instances: " + numberFormatter.format(PHDTask.this.totalObjectCount) + "\nTotal Number of References: " + numberFormatter.format(PHDTask.this.refCount) + "\n");
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Property");
            defaultTableModel.addColumn("Value");
            HeapInfo.addRow2TableModel("Heap dump file name", "" + PHDTask.this.file.getAbsoluteFile(), defaultTableModel);
            HeapInfo.addRow2TableModel("Java Version", PHDTask.this.sdkFullVersion, defaultTableModel);
            HeapInfo.addRow2TableModel("Number of Classes", numberFormatter.format(PHDTask.this.classCount), defaultTableModel);
            HeapInfo.addRow2TableModel("Number of Objects", numberFormatter.format(PHDTask.this.objectCount), defaultTableModel);
            HeapInfo.addRow2TableModel("Number of ObjectArrays", numberFormatter.format(PHDTask.this.objectArrayCount), defaultTableModel);
            HeapInfo.addRow2TableModel("Number of PrimitiveArrays", numberFormatter.format(PHDTask.this.primitiveArrayCount), defaultTableModel);
            HeapInfo.addRow2TableModel("Total Number of Instances", numberFormatter.format(PHDTask.this.totalObjectCount), defaultTableModel);
            HeapInfo.addRow2TableModel("Total Number of References", numberFormatter.format(PHDTask.this.refCount), defaultTableModel);
            if (!PHDTask.this.getHeapInfo().isJ9()) {
                HeapInfo.addRow2TableModel("Recommended size of kCluster", numberFormatter.format((long)((float)PHDTask.this.classCount * 1.1f)) + " or greater", defaultTableModel);
                PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Recommended size of kCluster : " + numberFormatter.format((long)((float)PHDTask.this.classCount * 1.1f)) + " or greater\n");
            }
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Number of roots : " + numberFormatter.format(PHDTask.this.getHeapInfo().getRootChildrenLength()) + "\n");
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Number of types : " + numberFormatter.format(PHDTask.this.getHeapInfo().getNameTable().length) + "\n");
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Heap range : 0x" + Long.toHexString(PHDTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(PHDTask.this.getHeapInfo().getAddress(PHDTask.this.getHeapInfo().getAddressLength() - 1)) + "\n");
            HeapInfo.addRow2TableModel("Number of roots", numberFormatter.format(PHDTask.this.getHeapInfo().getRootChildrenLength()), defaultTableModel);
            HeapInfo.addRow2TableModel("Number of types", numberFormatter.format(PHDTask.this.getHeapInfo().getNameTable().length), defaultTableModel);
            HeapInfo.addRow2TableModel("Heap range", "0x" + Long.toHexString(PHDTask.this.getHeapInfo().getAddress(0)) + " to 0x" + Long.toHexString(PHDTask.this.getHeapInfo().getAddress(PHDTask.this.getHeapInfo().getAddressLength() - 1)), defaultTableModel);
            if (PHDTask.this.getHeapInfo().getNumberOfFinalizableObject() > 0) {
                HeapInfo.addRow2TableModel("Number of garbage objects implementing finalize() method", numberFormatter.format(PHDTask.this.getHeapInfo().getNumberOfFinalizableObject()), defaultTableModel);
                PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Number of garbage objects implementing finalize() method : " + numberFormatter.format(PHDTask.this.getHeapInfo().getNumberOfFinalizableObject()) + "\n");
            }
            PHDTask.this.overall = 99;
            PHDTask.this.statMessage = "Calculating total heap size";
            PHDTask.this.current = 0;
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.getJProgressBar1().setMaximum(PHDTask.this.getHeapInfo().getAddressLength());
            }
            long l25 = 0L;
            n3 = 0;
            for (n8 = 0; n8 < PHDTask.this.getHeapInfo().getSize().length; ++n8) {
                l25 += (long)PHDTask.this.getHeapInfo().getSize(n8);
                if (PHDTask.this.getHeapInfo().isFinalizer(n8)) {
                    ++n3;
                }
                PHDTask.this.current++;
            }
            if (n3 > 0) {
                HeapInfo.addRow2TableModel("Number of objects with finalize() method", numberFormatter.format(n3), defaultTableModel);
                PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Number of objects with finalize() method : " + numberFormatter.format(n3) + "\n");
            }
            PHDTask.this.getHeapInfo().setNumberOfFinalizerObject(n3);
            PHDTask.this.getHeapInfo().setHeapSize(l25);
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + "Java heap usage : " + numberFormatter.format(l25) + " bytes\n");
            PHDTask.this.getHeapInfo().setDumpInfo(PHDTask.this.getHeapInfo().getDumpInfo() + PHDTask.this.getHeapInfo().darkMatterAnalysis() + "\n");
            HeapInfo.addRow2TableModel("Java heap usage", numberFormatter.format(l25) + " bytes", defaultTableModel);
            PHDTask.this.getHeapInfo().darkMatterAnalysis(defaultTableModel);
            PHDTask.this.getHeapInfo().setSortTask(new SortTask(PHDTask.this.getHeapInfo()));
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.getHeapInfo().getSortTask().goBackground();
            } else {
                PHDTask.this.getHeapInfo().getSortTask().go();
            }
            PHDTask.this.statMessage = "Chasing Java heap leak suspects";
            SuspectTask suspectTask = new SuspectTask(null, PHDTask.this.ha, PHDTask.this.getHeapInfo(), null, null);
            n2 = suspectTask.headLessTask();
            PHDTask.this.done = true;
            PHDTask.this.overall = 100;
            System.out.println("[" + new Date() + "] Heap Analysis of " + PHDTask.this.file.getAbsoluteFile() + " completed in " + PHDTask.this.getElapsed());
            if (!PHDTask.this.isHeadless()) {
                PHDTask.this.jp.dispose();
                HeapFrame heapFrame = new HeapFrame("Analysis of " + PHDTask.this.file.getName(), PHDTask.this.getHeapInfo());
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ha.gif"));
                heapFrame.setFrameIcon(imageIcon);
                heapFrame.fileName = PHDTask.this.file.getName();
                JTable jTable = new JTable();
                jTable.setDragEnabled(true);
                jTable.setColumnSelectionAllowed(true);
                jTable.setModel(defaultTableModel);
                HeapTree heapTree = PHDTask.this.ha.addLeakSuspectView(PHDTask.this.hi, heapFrame, jTable, true);
                if (heapTree == null) {
                    heapFrame.JScrollPaneSetViewportView(jTable);
                } else {
                    heapFrame.setSize(900, 800);
                    HeapInfo.addRow2TableModel("Number of leak suspects", numberFormatter.format(((PHDTask)PHDTask.this).hi.suspectList.length), defaultTableModel);
                }
                PHDTask.this.ha.getJDesktopPane1().add(heapFrame);
                PHDTask.this.ha.getJDesktopPane1().getDesktopManager().activateFrame(heapFrame);
                try {
                    heapFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            } else {
                System.out.println("Heap dump file name : " + PHDTask.this.file.getAbsoluteFile() + "\n");
                System.out.println(PHDTask.this.getHeapInfo().getDumpInfo() + "\n");
            }
        }

        ActualTask() {
            this.processHeapDump();
        }
    }
}

