/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FileProcessDialog;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.zip.GZIPOutputStream;

public class SaveTask {
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private FileProcessDialog jp = null;
    private HeapInfo hi = null;

    public SaveTask(HeapAnalyzer heapAnalyzer, File file, FileProcessDialog fileProcessDialog, HeapInfo heapInfo) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = fileProcessDialog;
        this.hi = heapInfo;
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                SaveTask.this.current = 0;
                SaveTask.this.done = false;
                SaveTask.this.canceled = false;
                SaveTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    class ActualTask {
        ActualTask() {
            SaveTask.this.jp.setTitle("Save heap dump");
            SaveTask.this.jp.setMessageText("Please wait while " + SaveTask.this.file.getName() + " is being saved");
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(SaveTask.this.file));
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferedOutputStream);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
                objectOutputStream.writeObject(SaveTask.this.hi);
                objectOutputStream.flush();
                objectOutputStream.close();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                SaveTask.this.ha.handleException(exception);
                exception.printStackTrace();
            }
            SaveTask.this.jp.setMessageText(SaveTask.this.file.getName() + " was saved succesfully");
            SaveTask.this.jp.setIndeterminate(false);
            SaveTask.this.jp.setJProgressBar1Value(100);
            SaveTask.this.jp.setOkButtonVisible(true);
        }
    }
}

