/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.FileProcessDialog;
import com.ibm.jinwoo.heap.Hav;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.text.NumberFormat;

public class SaveViewerTask {
    private boolean isHeadless;
    long startTime = 0L;
    static final String HAV_SIGNATURE = "IBM HeapAnalyzer 1.0.0";
    private int lengthOfTask;
    private int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private FileProcessDialog jp = null;
    private HeapInfo hi = null;

    public String getElapsed() {
        long l = System.currentTimeMillis() - this.startTime;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l /= 60L) % 60;
        return ((l /= 60L) > 9L ? "" : "0") + l + ":" + (n2 > 9 ? "" : "0") + n2 + ":" + (n > 9 ? "" : "0") + n;
    }

    public void printObject(MappedByteBuffer mappedByteBuffer, MappedByteBuffer mappedByteBuffer2, int n, int n2, int n3, int n4, int n5, int n6) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        mappedByteBuffer.position(n);
        l = n2 == 8 ? mappedByteBuffer.getLong() : (long)mappedByteBuffer.getInt();
        l4 = n4 == 8 ? mappedByteBuffer.getLong() : (n4 == 4 ? (long)mappedByteBuffer.getInt() : (n4 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        l2 = n5 == 8 ? mappedByteBuffer.getLong() : (n5 == 4 ? (long)mappedByteBuffer.getInt() : (n5 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        if (n3 == 8) {
            long l6 = mappedByteBuffer.getLong();
        } else {
            long l7 = mappedByteBuffer.getInt();
        }
        l3 = n2 == 8 ? mappedByteBuffer.getLong() : (long)mappedByteBuffer.getInt();
        l5 = n6 == 8 ? mappedByteBuffer.getLong() : (n6 == 4 ? (long)mappedByteBuffer.getInt() : (n6 == 2 ? (long)mappedByteBuffer.getShort() : (long)mappedByteBuffer.get()));
        System.out.println(" 0x" + Long.toHexString(l) + " [" + l4 + "/" + l2 + "] ");
    }

    public StringBuffer getObjectName(MappedByteBuffer mappedByteBuffer, int n) {
        byte by = 0;
        StringBuffer stringBuffer = new StringBuffer();
        mappedByteBuffer.rewind();
        mappedByteBuffer.position(n);
        do {
            if ((by = mappedByteBuffer.get()) == 0) continue;
            stringBuffer.append((char)by);
        } while (by != 0);
        return stringBuffer;
    }

    public SaveViewerTask(HeapAnalyzer heapAnalyzer, File file, FileProcessDialog fileProcessDialog, HeapInfo heapInfo) {
        this.file = file;
        this.ha = heapAnalyzer;
        this.jp = fileProcessDialog;
        this.hi = heapInfo;
        this.lengthOfTask = 100;
    }

    public SaveViewerTask(File file, HeapInfo heapInfo) {
        this.file = file;
        this.setHeadless();
        this.hi = heapInfo;
        this.lengthOfTask = 100;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int n) {
        this.current = n;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.getStatMessage();
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        final SaveViewerTask saveViewerTask = this;
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                SaveViewerTask.this.current = 0;
                SaveViewerTask.this.done = false;
                SaveViewerTask.this.canceled = false;
                SaveViewerTask.this.setStatMessage(null);
                return new ActualTask(saveViewerTask);
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.setStatMessage(null);
    }

    public void setStatMessage(String string) {
        this.statMessage = string;
    }

    public String getStatMessage() {
        return this.statMessage;
    }

    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    public void setHeadless() {
        this.isHeadless = true;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }

    class ActualTask {
        final int DEFAULT_POINTER_SIZE = 4;
        int pointerSize = 4;
        int addressSize = 4;
        int nameSize = 4;
        int totalSize = 8;
        int sizeSize = 4;
        int childSize = 4;
        long[] stringLocation = null;
        long[] entryLocation = null;
        long nonRoot = 0L;
        long spos = 0L;
        long pos = 0L;

        void setNameSize(long l) {
            this.nameSize = l > Integer.MAX_VALUE ? 8 : (l > 32767L ? 4 : (l > 127L ? 2 : 1));
        }

        void setChildSize(int n) {
            this.childSize = n > Integer.MAX_VALUE ? 8 : (n > Short.MAX_VALUE ? 4 : (n > 127 ? 2 : 1));
        }

        void setSizeSize(long l) {
            this.sizeSize = l > Integer.MAX_VALUE ? 8 : (l > 32767L ? 4 : (l > 127L ? 2 : 1));
        }

        void setTotalSize(long l) {
            this.totalSize = l > Integer.MAX_VALUE ? 8 : (l > 32767L ? 4 : (l > 127L ? 2 : 1));
        }

        long getUnitSize(int n) {
            int n2 = 0;
            if (SaveViewerTask.this.hi.getChild()[n] != null) {
                n2 = SaveViewerTask.this.hi.getChild()[n].length;
            }
            return (n2 + 1) * this.pointerSize + this.addressSize + this.sizeSize + this.totalSize + this.childSize + this.nameSize;
        }

        long getDefaultUnitSize(int n) {
            int n2 = 0;
            if (SaveViewerTask.this.hi.getChild()[n] != null) {
                n2 = SaveViewerTask.this.hi.getChild()[n].length;
            }
            return (n2 + 1) * 4 + this.addressSize + this.sizeSize + this.totalSize + this.childSize + this.nameSize;
        }

        int calculatePointerSize() {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            for (int i = 0; i < SaveViewerTask.this.hi.getAddressLength(); ++i) {
                if (i == 0) {
                    l2 = SaveViewerTask.this.hi.getSize(i);
                    l3 = SaveViewerTask.this.hi.getTotal(i);
                }
                if (l2 < (long)SaveViewerTask.this.hi.getSize(i)) {
                    l2 = SaveViewerTask.this.hi.getSize(i);
                }
                if (l3 < SaveViewerTask.this.hi.getTotal(i)) {
                    l3 = SaveViewerTask.this.hi.getTotal(i);
                }
                if (l > Integer.MAX_VALUE) continue;
                l += this.getDefaultUnitSize(i);
            }
            this.setTotalSize(l3);
            this.setSizeSize(l2);
            if (l > Integer.MAX_VALUE) {
                return 8;
            }
            return 4;
        }

        ActualTask(SaveViewerTask saveViewerTask2) {
            SaveViewerTask.this.startTime = System.currentTimeMillis();
            Hav hav = new Hav(SaveViewerTask.this.hi);
            hav.saveCompressed(SaveViewerTask.this.file, saveViewerTask2);
            SaveViewerTask.this.done = true;
            if (!SaveViewerTask.this.isHeadless()) {
                SaveViewerTask.this.jp.setMessageText(SaveViewerTask.this.file.getName() + " was saved succesfully");
                SaveViewerTask.this.jp.setIndeterminate(false);
                SaveViewerTask.this.jp.setJProgressBar1Value(100);
                SaveViewerTask.this.jp.setOkButtonVisible(true);
            }
        }
    }
}

