/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.ObjectTableModel;

public class SortThread
extends Thread {
    ObjectTableModel om;
    int column;

    public SortThread() {
    }

    public SortThread(ObjectTableModel objectTableModel) {
        this.om = objectTableModel;
        this.column = 0;
    }

    public SortThread(ObjectTableModel objectTableModel, int n) {
        this.om = objectTableModel;
        this.column = n;
    }

    public SortThread(Runnable runnable) {
        super(runnable);
    }

    public SortThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public SortThread(String string) {
        super(string);
    }

    public SortThread(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
    }

    public SortThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    public SortThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public void run() {
        HeapInfo heapInfo = this.om.hi;
        switch (this.column) {
            case 0: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readTotalToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getTotal(i);
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
            case 1: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readSizeToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getSize(i);
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
            case 2: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readNChildToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getChild()[i] == null ? 0L : (long)heapInfo.getChild()[i].length;
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
            case 3: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readAddressToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getParentsList()[i] == null ? 0L : (long)heapInfo.getParentsList()[i].length;
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
            case 5: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readAddressToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getAddress(i);
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
            case 4: {
                if (heapInfo.isHav()) {
                    heapInfo.getHav().readNameToArray(this.om.sortedArrary);
                } else {
                    for (int i = 0; i < heapInfo.getTotalLength(); ++i) {
                        this.om.sortedArrary[0][i] = heapInfo.getNameKey(i);
                        this.om.sortedArrary[1][i] = i;
                    }
                }
                Arrays2.sort(this.om.sortedArrary);
                break;
            }
        }
        this.om.sortedColumn = this.column;
        this.om.direction = true;
        this.om.fireTableDataChanged();
        if (this.om.tableHeader != null) {
            this.om.tableHeader.repaint();
        }
    }
}

