/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.HeapAnalyzer;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.JDialogProgress;
import com.ibm.jinwoo.heap.Node;
import com.ibm.jinwoo.heap.ThreadHandler;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class SuspectTask {
    private int lengthOfTask;
    private static int current = 0;
    private int overall = 0;
    private boolean done = false;
    private boolean canceled = false;
    private String statMessage;
    private HeapInfo hi;
    Hashtable listOfSuspects;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    public HeapAnalyzer ha = null;
    public File file = null;
    private JDialogProgress jp = null;
    HeapInfo heapinfo;
    Node node;
    int adjustedThreshold = -1;
    TreePath tpath;
    private HeapTree ht;
    private Node newNode;
    private TreePath nextPath;
    private Node nextNode;

    public SuspectTask(HeapTree heapTree, HeapAnalyzer heapAnalyzer, HeapInfo heapInfo, Node node, TreePath treePath) {
        this.ht = heapTree;
        this.ha = heapAnalyzer;
        this.hi = heapInfo;
        this.node = node;
        this.tpath = treePath;
        this.listOfSuspects = heapInfo.listOfSuspects;
        this.lengthOfTask = 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileLeakSuspects(int n) {
        Hashtable hashtable;
        long l;
        int n2;
        int n3 = n;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((n2 = this.hi.getBiggestRealChild(n3)) != -1 && ((l = this.hi.getTotal(n3)) >= HeapAnalyzer.MIN_TOTAL_LIMIT || bl)) {
            if (this.hi.getNameKey(n3) == this.hi.getNameKey(n2)) {
                if (bl) {
                    n6 = n2;
                    ++n4;
                } else {
                    bl = true;
                    n4 = 1;
                    n5 = n3;
                    n6 = n2;
                }
            } else if (bl) {
                if ((float)this.hi.getTotal(n6) / (float)this.hi.getTotal(n5) <= HeapAnalyzer.RATIO) {
                    hashtable = this.listOfSuspects;
                    synchronized (hashtable) {
                        this.listOfSuspects.put(new Long(this.hi.getAddress(n5)), new Long(this.hi.getTotal(n5) - this.hi.getTotal(n6)));
                    }
                }
                n4 = 0;
                bl = false;
            }
            n3 = n2;
        }
        if (bl) {
            if ((float)this.hi.getTotal(n6) / (float)this.hi.getTotal(n5) <= HeapAnalyzer.RATIO) {
                hashtable = this.listOfSuspects;
                synchronized (hashtable) {
                    this.listOfSuspects.put(new Long(this.hi.getAddress(n5)), new Long(this.hi.getTotal(n5) - this.hi.getTotal(n6)));
                }
            }
        }
    }

    public void compileLeakSuspectsHav(long l) {
        long l2 = 0L;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        boolean bl = false;
        HashMap hashMap = new HashMap();
        Stack<Long> stack = new Stack<Long>();
        stack.push(new Long(l));
        while (!stack.empty()) {
            long l3 = (Long)stack.peek();
            bl = false;
            if (this.hi.getHav().getNChild(l3) != 0) {
                int n = heapModel.getChildCount(l3);
                for (int i = 0; i < n; ++i) {
                    long l4 = this.hi.getHav().getChild(l3, i);
                    l2 = this.hi.getHav().getTotal(l4);
                    if (l2 < HeapAnalyzer.MIN_TOTAL_LIMIT || l4 < 0L || !((float)l2 / (float)this.hi.getHav().getTotal(l3) > HeapAnalyzer.MRATIO)) break;
                    long l5 = l4;
                    if (hashMap.containsKey(new Long(l5))) continue;
                    hashMap.put(new Long(l5), null);
                    stack.push(new Long(l5));
                    ++current;
                    bl = true;
                }
            }
            if (bl) continue;
            l3 = (Long)stack.pop();
            if (this.hi.getHav().getTotal(l3) < HeapAnalyzer.MIN_TOTAL_LIMIT || this.hi.getHav().getNChild(l3) == 0 || !((float)this.hi.getHav().getTotal(this.hi.getHav().getChildSorted(l3, 0)) / (float)this.hi.getHav().getTotal(l3) <= HeapAnalyzer.RATIO)) continue;
            this.listOfSuspects.put(new Long(l3), new Long(this.hi.getHav().getTotal(l3)));
        }
    }

    public int getCurrent() {
        return current;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public int getOverall() {
        return this.overall;
    }

    public void go() {
        ThreadHandler threadHandler = new ThreadHandler(){

            public Object construct() {
                current = 0;
                SuspectTask.this.done = false;
                SuspectTask.this.canceled = false;
                SuspectTask.this.statMessage = null;
                return new ActualTask();
            }
        };
        threadHandler.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isEnd(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l == -1L || node.getIndex() == -1 || this.hi.getTotal(l) == (long)this.hi.getSize((int)l);
    }

    public boolean isRealDrop(Node node) {
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        if (l != -1L && node.getIndex() != -1) {
            if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(node.getIndex()) <= HeapAnalyzer.RATIO) {
                return true;
            }
        }
        return false;
    }

    public boolean isRealDrop(Node node, TreePath treePath) {
        float f = 0.5f;
        long l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node);
        return l != -1L && node.getIndex() != -1 && (float)this.hi.getTotal(l) / ((float)this.hi.getTotal(node.getIndex()) - (float)this.hi.getTotal(l)) <= f;
    }

    public boolean isThereLeakSuspect(int n) {
        int n2;
        current = 0;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        while ((n2 = heapModel.getBiggestRealChild(n)) != -1) {
            if (n != -1) {
                if ((float)this.hi.getTotal(n2) / (float)this.hi.getTotal(n) <= HeapAnalyzer.RATIO) {
                    return true;
                }
            }
            ++current;
            n = n2;
        }
        return false;
    }

    public void printSuspects(int n) {
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        boolean bl = false;
        boolean[] blArray = new boolean[this.hi.getAddressLength()];
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(n));
        while (!stack.empty()) {
            int n2 = (Integer)stack.peek();
            bl = false;
            if (this.hi.getChild()[n2] != null) {
                int n3;
                int n4 = heapModel.getChildCount(n2);
                for (int i = 0; i < n4 && this.hi.getTotal(n3 = this.hi.getChild()[n2][i]) >= HeapAnalyzer.MIN_TOTAL_LIMIT && n3 >= 0 && (float)this.hi.getTotal(n3) / (float)this.hi.getTotal(n2) > HeapAnalyzer.MRATIO; ++i) {
                    int n5 = n3;
                    if (blArray[n5]) continue;
                    blArray[n5] = true;
                    stack.push(new Integer(n5));
                    bl = true;
                }
            }
            if (bl || this.hi.getTotal(n2 = ((Integer)stack.pop()).intValue()) < HeapAnalyzer.MIN_TOTAL_LIMIT || this.hi.getChild()[n2] == null || !((float)this.hi.getTotal(this.hi.getChild()[n2][0]) / (float)this.hi.getTotal(n2) <= HeapAnalyzer.RATIO)) continue;
        }
    }

    public TreePath returnBigDrop(Node node, int n, TreePath treePath) {
        long l;
        Vector<Object> vector = new Vector<Object>(1);
        if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) <= (long)n) {
            int n2 = (int)(Math.log(this.hi.getTotal(node.getIndex())) / Math.log(10.0));
            this.adjustedThreshold = n = (int)Math.pow(10.0, n2);
        } else {
            this.adjustedThreshold = -1;
        }
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) >= (long)n) {
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = (Node)objectArray[i];
                }
                return new TreePath(objectArray2);
            }
            if (this.hi.getTotal(l) < (long)n) {
                return null;
            }
            node = new Node((int)l);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public long returnBiggestDrop(Node node) {
        long l;
        long l2 = 0L;
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
                this.newNode = node;
            }
            node = new Node((int)l);
        }
        return l2;
    }

    public TreePath returnBiggestDrop(Node node, int n, TreePath treePath) {
        long l;
        long l2 = 0L;
        Node node2 = node;
        Vector vector = new Vector(1);
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
            }
            node = new Node((int)l);
        }
        return null;
    }

    public long returnBiggestDrop(Node node, TreePath treePath) {
        long l;
        long l2 = 0L;
        while ((l = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node)) != -1L) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l) > l2) {
                l2 = this.hi.getTotal(node.getIndex()) - this.hi.getTotal(l);
                this.newNode = node;
            }
            node = new Node((int)l);
        }
        return l2;
    }

    public int returnLeakSuspect(int n) {
        long l;
        current = 0;
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        while ((l = (long)heapModel.getBiggestRealChild(n)) != -1L) {
            if (n != -1 && this.hi.getTotal(n) < HeapAnalyzer.MIN_TOTAL_LIMIT) {
                return -2;
            }
            if (n != -1) {
                if ((float)this.hi.getTotal(l) / (float)this.hi.getTotal(n) <= HeapAnalyzer.RATIO) {
                    if (this.hi.getTotal(n) - this.hi.getTotal(l) < HeapAnalyzer.MIN_DROP_LIMIT) {
                        n = (int)l;
                        continue;
                    }
                    return (int)l;
                }
            }
            ++current;
            n = (int)l;
        }
        return -2;
    }

    public TreePath returnLeakSuspect(Node node, TreePath treePath) {
        int n;
        current = 0;
        Vector<Object> vector = new Vector<Object>(1);
        HeapModel heapModel = (HeapModel)this.ht.getModel();
        TreePath treePath2 = null;
        while ((n = heapModel.getBiggestRealChild(node.getIndex())) != -1) {
            if (node.getIndex() != -1) {
                if ((float)this.hi.getTotal(n) / (float)this.hi.getTotal(node.getIndex()) <= HeapAnalyzer.RATIO) {
                    vector.addAll(0, Arrays.asList(treePath.getPath()));
                    Object[] objectArray = vector.toArray();
                    Object[] objectArray2 = new Node[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray2[i] = (Node)objectArray[i];
                    }
                    treePath2 = new TreePath(objectArray2);
                    return treePath2;
                }
            }
            node = new Node(n);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public TreePath returnOneDrop(Node node, int n, TreePath treePath) {
        int n2;
        Vector<Object> vector = new Vector<Object>(1);
        TreePath treePath2 = null;
        while ((n2 = ((HeapModel)this.ht.getModel()).getBiggestRealChild(node.getIndex())) != -1) {
            if (node.getIndex() != -1 && this.hi.getTotal(node.getIndex()) - this.hi.getTotal(n2) == (long)n) {
                int n3;
                vector.addAll(0, Arrays.asList(treePath.getPath()));
                Object[] objectArray = vector.toArray();
                Object[] objectArray2 = new Node[objectArray.length];
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray2[n3] = (Node)objectArray[n3];
                }
                treePath2 = new TreePath(objectArray2);
                this.nextNode = new Node(n2);
                vector.addElement(this.nextNode);
                objectArray = vector.toArray();
                objectArray2 = new Node[objectArray.length];
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    objectArray2[n3] = (Node)objectArray[n3];
                }
                this.nextPath = new TreePath(objectArray2);
                return treePath2;
            }
            if (this.hi.getTotal(n2) < (long)n) {
                return null;
            }
            node = new Node(n2);
            vector.addElement(node);
            ++current;
        }
        return null;
    }

    public TreePath returnTreePath(long l) {
        int n = 0;
        n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), l) : Arrays.binarySearch(this.hi.getAddress(), (int)l);
        if (n < 0) {
            JOptionPane.showMessageDialog(this.ha, "Cannot find address : 0x" + Long.toHexString(l), "Address not found", 0);
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        vector.add(0, new Node(n));
        while (this.hi.getParent()[n] >= 0) {
            vector.add(0, new Node(this.hi.getParent()[n]));
            n = this.hi.getParent()[n];
        }
        Object[] objectArray = this.ht.getPathForRow(0).getPath();
        vector.add(0, (Node)objectArray[0]);
        Object[] objectArray2 = vector.toArray();
        Object[] objectArray3 = new Node[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray3[i] = (Node)objectArray2[i];
        }
        return new TreePath(objectArray3);
    }

    public void stop() {
        this.canceled = true;
        this.statMessage = null;
    }

    int headLessTask() {
        int n;
        int n2;
        current = 0;
        int n3 = this.hi.getRootChildrenLength();
        long l = 0L;
        for (int i = 0; i < n3; ++i) {
            if ((float)this.hi.getTotal(this.hi.getRootChildren(i)) / (float)this.hi.getHeapSize() > HeapAnalyzer.MRATIO) {
                if (this.hi.isHav()) {
                    this.compileLeakSuspectsHav(this.hi.getRootChildrenPointer(i));
                    continue;
                }
                this.compileLeakSuspects(this.hi.getRootChildren(i));
                continue;
            }
            l += this.hi.getTotal(this.hi.getRootChildren(i));
        }
        float f = (float)l / (float)this.hi.getHeapSize();
        if (f > HeapAnalyzer.ROOT_RATIO) {
            this.hi.setDumpInfo(this.hi.getDumpInfo() + "\nWARNING! More than " + f * 100.0f + " % of Java heap is used by root objects or pseudo root objects and their reference objects.\n\n");
            this.hi.rootWarning = "More than " + f * 100.0f + " % of Java heap is used by root objects or pseudo root objects and their reference objects";
        }
        this.done = true;
        if (this.listOfSuspects.size() == 0) {
            return 0;
        }
        long[][] lArray = new long[2][this.listOfSuspects.size()];
        Enumeration enumeration = this.listOfSuspects.keys();
        int n4 = 0;
        Long l2 = null;
        while (enumeration.hasMoreElements()) {
            l2 = (Long)enumeration.nextElement();
            lArray[0][n4] = (Long)this.listOfSuspects.get(l2);
            lArray[1][n4] = l2;
            ++n4;
        }
        Arrays2.sort(lArray);
        this.hi.leakMenu = new JMenu();
        JMenuItem jMenuItem = null;
        this.hi.suspectList = new long[lArray[0].length];
        this.hi.suspectTotalList = new long[lArray[0].length];
        this.hi.suspectNameList = new String[lArray[0].length];
        for (n2 = lArray[0].length - 1; n2 >= 0; --n2) {
            if (this.hi.isHav()) {
                jMenuItem = new JMenuItem("  " + numberFormatter.format(lArray[0][n2]) + " (" + 100L * lArray[0][n2] / this.hi.getHeapSize() + "%) " + this.hi.getHav().getNameHeap(lArray[1][n2]));
            } else {
                n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), lArray[1][n2] - this.hi.getBaseAddress()) : Arrays.binarySearch(this.hi.getAddress(), (int)(lArray[1][n2] - this.hi.getBaseAddress()));
                if (n >= 0) {
                    jMenuItem = new JMenuItem("  " + numberFormatter.format(lArray[0][n2]) + " (" + 100L * lArray[0][n2] / this.hi.getHeapSize() + "%) " + this.hi.getName(n));
                    this.hi.setSuspect(n);
                } else {
                    jMenuItem = null;
                }
            }
            if (jMenuItem != null) {
                this.hi.leakMenu.add(jMenuItem);
            }
            this.hi.leakBookMark.put("  " + numberFormatter.format(lArray[0][n2]), new Long(lArray[1][n2] - this.hi.getBaseAddress()));
            this.hi.suspectList[lArray[0].length - n2 - 1] = lArray[1][n2];
        }
        for (n2 = 0; n2 < this.hi.suspectList.length; ++n2) {
            n = this.hi.isAddress64() ? Arrays.binarySearch(this.hi.getAddressLong(), this.hi.suspectList[n2] - this.hi.getBaseAddress()) : Arrays.binarySearch(this.hi.getAddress(), (int)(this.hi.suspectList[n2] - this.hi.getBaseAddress()));
            if (n < 0) continue;
            this.hi.suspectTotalList[n2] = this.hi.getTotal(n);
            this.hi.suspectNameList[n2] = this.hi.getName(n);
        }
        return this.listOfSuspects.size();
    }

    class ActualTask {
        ActualTask() {
            current = 0;
            SuspectTask.this.ha.dp.setProgressText("   Traversing trees...");
            SuspectTask.this.ha.dp.setTitle("Searching for leak suspects");
            int n = ((HeapModel)SuspectTask.this.ht.getModel()).getChildCount(-1L);
            for (int i = 0; i < n && (float)SuspectTask.this.hi.getTotal(SuspectTask.this.hi.getRootChildren(i)) / (float)SuspectTask.this.hi.getHeapSize() > HeapAnalyzer.MRATIO; ++i) {
                if (SuspectTask.this.hi.isHav()) {
                    SuspectTask.this.compileLeakSuspectsHav(SuspectTask.this.hi.getRootChildrenPointer(i));
                    continue;
                }
                SuspectTask.this.compileLeakSuspects(SuspectTask.this.hi.getRootChildren(i));
            }
            SuspectTask.this.done = true;
            SuspectTask.this.ha.dp.hide();
            if (SuspectTask.this.listOfSuspects.size() == 0) {
                JOptionPane.showMessageDialog(SuspectTask.this.ha, "Cannot locate any leak suspect", "Locate any leak suspect", 1);
                return;
            }
            long[][] lArray = new long[2][SuspectTask.this.listOfSuspects.size()];
            Enumeration enumeration = SuspectTask.this.listOfSuspects.keys();
            int n2 = 0;
            Long l = null;
            while (enumeration.hasMoreElements()) {
                l = (Long)enumeration.nextElement();
                lArray[0][n2] = (Long)SuspectTask.this.listOfSuspects.get(l);
                lArray[1][n2] = l;
                ++n2;
            }
            Arrays2.sort(lArray);
            AbstractButton abstractButton = null;
            for (int i = lArray[0].length - 1; i >= 0; --i) {
                if (SuspectTask.this.hi.isHav()) {
                    abstractButton = new JMenuItem("  " + numberFormatter.format(lArray[0][i]) + " (" + 100L * lArray[0][i] / SuspectTask.this.hi.getHeapSize() + "%) " + SuspectTask.this.hi.getHav().getNameHeap(lArray[1][i]));
                } else {
                    int n3 = SuspectTask.this.hi.isAddress64() ? Arrays.binarySearch(SuspectTask.this.hi.getAddressLong(), lArray[1][i] - SuspectTask.this.hi.getBaseAddress()) : Arrays.binarySearch(SuspectTask.this.hi.getAddress(), (int)(lArray[1][i] - SuspectTask.this.hi.getBaseAddress()));
                    if (n3 >= 0) {
                        abstractButton = new JMenuItem("  " + numberFormatter.format(lArray[0][i]) + " (" + 100L * lArray[0][i] / SuspectTask.this.hi.getHeapSize() + "%) " + SuspectTask.this.hi.getName(n3));
                    }
                }
                ((SuspectTask)SuspectTask.this).ht.hf.leakMenu.add((JMenuItem)abstractButton);
                abstractButton.addActionListener(((SuspectTask)SuspectTask.this).ht.hf);
                ((SuspectTask)SuspectTask.this).ht.hf.leakBookMark.put("  " + numberFormatter.format(lArray[0][i]), new Long(lArray[1][i]));
            }
            ((SuspectTask)SuspectTask.this).ht.hf.leakMenu.setEnabled(true);
            ((SuspectTask)SuspectTask.this).ht.compileMenuItem.setEnabled(false);
        }
    }
}

