/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.NumberCellRenderer;
import com.ibm.jinwoo.heap.ObjectTableModel;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableThread
extends Thread {
    HeapInfo hi;
    JTable jt;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public TableThread() {
    }

    public TableThread(HeapInfo heapInfo) {
        this.hi = heapInfo;
    }

    public TableThread(Runnable runnable) {
        super(runnable);
    }

    public TableThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public TableThread(String string) {
        super(string);
    }

    public TableThread(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
    }

    public TableThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
    }

    public TableThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public TableThread(JTable jTable, HeapInfo heapInfo) {
        this.hi = heapInfo;
        this.jt = jTable;
    }

    public void run() {
        ObjectTableModel objectTableModel = new ObjectTableModel(this.hi);
        objectTableModel.setTableHeader(this.jt.getTableHeader());
        if (objectTableModel.sortedArrary == null) {
            System.out.println("Requesting " + numberFormatter.format(this.hi.getTotalLength() * 8) + " bytes of Java heap.");
            objectTableModel.sortedArrary = new long[2][this.hi.getTotalLength()];
            if (this.hi.isHav()) {
                this.hi.getHav().readTotalToArray(objectTableModel.sortedArrary);
            } else {
                for (int i = 0; i < this.hi.getTotalLength(); ++i) {
                    objectTableModel.sortedArrary[0][i] = this.hi.getTotal(i);
                    objectTableModel.sortedArrary[1][i] = i;
                }
            }
            System.out.println("Sorting table by TotalSize.");
            Arrays2.sort(objectTableModel.sortedArrary);
        }
        this.jt.setModel(objectTableModel);
        TableColumnModel tableColumnModel = this.jt.getColumnModel();
        for (int i = 0; i < 6; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(80);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 1 || i == 2 || i == 3) {
                tableColumn.setPreferredWidth(50);
                tableColumn.setCellRenderer(new NumberCellRenderer());
                continue;
            }
            if (i == 5) {
                tableColumn.setPreferredWidth(80);
                continue;
            }
            tableColumn.setPreferredWidth(300);
        }
    }
}

