/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.Arrays2;
import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.HeapModel;
import com.ibm.jinwoo.heap.HeapTree;
import com.ibm.jinwoo.heap.Node;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class TreeSelection
extends TransferHandler {
    static NumberFormat nf = NumberFormat.getNumberInstance();
    boolean percentage;
    private String node;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable createTransferable(JComponent jComponent) {
        int n;
        TreePath[] treePathArray = ((HeapTree)jComponent).getSelectionPaths();
        int[][] nArray = new int[2][treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            nArray[0][i] = ((HeapTree)jComponent).getRowForPath(treePathArray[i]);
            nArray[1][i] = i;
        }
        Arrays2.sort(nArray);
        int[] nArray2 = new int[treePathArray.length];
        int n2 = treePathArray[0].getPathCount();
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = treePathArray[n].getPathCount();
            if (nArray2[n] >= n2) continue;
            n2 = nArray2[n];
        }
        n = 0;
        while (n < nArray2.length) {
            int n3 = n++;
            nArray2[n3] = nArray2[n3] - n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < treePathArray.length; ++i) {
            Node node = (Node)treePathArray[nArray[1][i]].getLastPathComponent();
            if (node == null) continue;
            int n4 = node.getIndex();
            HeapInfo heapInfo = ((HeapModel)((HeapTree)jComponent).getModel()).hi;
            if (n4 == -1) {
                if (this.percentage) {
                    stringBuffer.append("TotalSize (TotalSize/HeapSize%) [ObjectSize] NumberOfChildObject(" + nf.format(heapInfo.getRootChildrenLength()) + ") ObjectName Address\n");
                    continue;
                }
                stringBuffer.append("TotalSize [ObjectSize] NumberOfChildObject(" + nf.format(heapInfo.getRootChildrenLength()) + ") ObjectName Address\n");
                continue;
            }
            if (n4 == -2) {
                stringBuffer.append("There are " + nf.format(node.getNumberOfChildren()) + " more children");
                continue;
            }
            for (int j = 0; j < nArray2[nArray[1][i]]; ++j) {
                stringBuffer.append(' ');
            }
            if (heapInfo.isHav() || node.isHav()) {
                long l = node.getLocation();
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                String string = " ";
                RandomAccessFile randomAccessFile = heapInfo.getHav().raf;
                synchronized (randomAccessFile) {
                    try {
                        heapInfo.getHav().raf.seek(l + heapInfo.getHav().getHeapBaseLocation());
                        l2 = heapInfo.getHav().read(heapInfo.getHav().raf) + heapInfo.getBaseAddress();
                        l3 = heapInfo.getHav().read(heapInfo.getHav().raf);
                        l4 = heapInfo.getHav().read(heapInfo.getHav().raf) + l3;
                        l5 = heapInfo.getHav().readName(heapInfo.getHav().raf);
                        if ((l5 & Long.MIN_VALUE) == Long.MIN_VALUE) {
                            string = " array of ";
                        }
                        if ((l5 & 0x4000000000000000L) == 0x4000000000000000L) {
                            string = " class ";
                        }
                        l5 &= 0x3FFFFFFFFFFFFFFFL;
                        long l7 = heapInfo.getHav().raf.readInt();
                        heapInfo.getHav().raf.seek(l7 + heapInfo.getHav().getHeapBaseLocation());
                        heapInfo.getHav().read(heapInfo.getHav().raf);
                        l6 = heapInfo.getHav().read(heapInfo.getHav().raf);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                stringBuffer.append(nf.format(l4) + " (" + 100L * l4 / heapInfo.getHeapSize() + "%)" + " [" + nf.format(l3) + "] " + nf.format(l6) + string + heapInfo.getHav().getName(l5) + " 0x" + Long.toHexString(l2) + "\n");
                continue;
            }
            if (heapInfo.getChild()[n4] != null) {
                if (this.percentage) {
                    stringBuffer.append(nf.format(heapInfo.getTotal(n4)) + " (" + 100L * heapInfo.getTotal(n4) / heapInfo.getHeapSize() + "%)" + " [" + nf.format(heapInfo.getSize(n4)) + "] " + nf.format(heapInfo.getChild()[n4].length) + " " + heapInfo.getName(n4) + " 0x" + Long.toHexString(heapInfo.getAddress(n4)) + "\n");
                    continue;
                }
                stringBuffer.append(nf.format(heapInfo.getTotal(n4)) + " [" + nf.format(heapInfo.getSize(n4)) + "] " + nf.format(heapInfo.getChild()[n4].length) + " " + heapInfo.getName(n4) + " 0x" + Long.toHexString(heapInfo.getAddress(n4)) + "\n");
                continue;
            }
            if (this.percentage) {
                stringBuffer.append(nf.format(heapInfo.getTotal(n4)) + " (" + 100L * heapInfo.getTotal(n4) / heapInfo.getHeapSize() + "%)" + " [" + nf.format(heapInfo.getSize(n4)) + "] 0 " + heapInfo.getName(n4) + " 0x" + Long.toHexString(heapInfo.getAddress(n4)) + "\n");
                continue;
            }
            stringBuffer.append(nf.format(heapInfo.getTotal(n4)) + " [" + nf.format(heapInfo.getSize(n4)) + "] 0 " + heapInfo.getName(n4) + " 0x" + Long.toHexString(heapInfo.getAddress(n4)) + "\n");
        }
        return new StringSelection(stringBuffer.toString());
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    public void setPercentage(boolean bl) {
        this.percentage = bl;
    }
}

