/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.heap;

import com.ibm.jinwoo.heap.HeapInfo;
import com.ibm.jinwoo.heap.SortThreadTypes;
import com.ibm.jinwoo.heap.SortableHeaderIcon;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class TypeTableModel
extends AbstractTableModel {
    public static final boolean DESCENDING = true;
    public static final boolean ASCENDING = false;
    public boolean direction = true;
    String[] columnNames = new String[]{"Sum of sizes", "Sum of total sizes", "Count", "Type"};
    HeapInfo hi;
    int sortedColumn = 0;
    public JTableHeader tableHeader;
    public long[][] sortedArrary;
    public long[][] modelArray;
    long[] addressList;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public TypeTableModel() {
    }

    public TypeTableModel(HeapInfo heapInfo) {
        this.hi = heapInfo;
        this.sortedColumn = 0;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public TypeTableModel(HeapInfo heapInfo, int n) {
        this.hi = heapInfo;
        this.sortedColumn = n;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Icon getHeaderIcon(int n, int n2) {
        if (n != this.sortedColumn) {
            return null;
        }
        return new SortableHeaderIcon(this.direction, n2);
    }

    public int getRowCount() {
        return this.hi.getNameTableLength();
    }

    public Object getValueAt(int n, int n2) {
        int n3 = n;
        if (this.direction) {
            n3 = this.hi.getNameTableLength() - n - 1;
        }
        if (this.sortedColumn == 0) {
            if (n2 == 0) {
                return numberFormatter.format(this.sortedArrary[0][n3]);
            }
            if (n2 == 1) {
                return numberFormatter.format(this.modelArray[2][(int)this.sortedArrary[1][n3]]);
            }
            if (n2 == 2) {
                return numberFormatter.format(this.modelArray[1][(int)this.sortedArrary[1][n3]]);
            }
            if (this.hi.isHav()) {
                return this.hi.getNameTable((int)this.addressList[(int)this.sortedArrary[1][n3]]);
            }
            return this.hi.getNameTable((int)this.sortedArrary[1][n3]);
        }
        if (this.sortedColumn == 1) {
            if (n2 == 0) {
                return numberFormatter.format(this.modelArray[0][(int)this.sortedArrary[1][n3]]);
            }
            if (n2 == 1) {
                return numberFormatter.format(this.sortedArrary[0][n3]);
            }
            if (n2 == 2) {
                return numberFormatter.format(this.modelArray[1][(int)this.sortedArrary[1][n3]]);
            }
            if (this.hi.isHav()) {
                return this.hi.getNameTable((int)this.addressList[(int)this.sortedArrary[1][n3]]);
            }
            return this.hi.getNameTable((int)this.sortedArrary[1][n3]);
        }
        if (this.sortedColumn == 2) {
            if (n2 == 0) {
                return numberFormatter.format(this.modelArray[0][(int)this.sortedArrary[1][n3]]);
            }
            if (n2 == 1) {
                return numberFormatter.format(this.modelArray[2][(int)this.sortedArrary[1][n3]]);
            }
            if (n2 == 2) {
                return numberFormatter.format(this.sortedArrary[0][n3]);
            }
            if (this.hi.isHav()) {
                return this.hi.getNameTable((int)this.addressList[(int)this.sortedArrary[1][n3]]);
            }
            return this.hi.getNameTable((int)this.sortedArrary[1][n3]);
        }
        if (n2 == 0) {
            return numberFormatter.format(this.modelArray[0][n3]);
        }
        if (n2 == 1) {
            return numberFormatter.format(this.modelArray[2][n3]);
        }
        if (n2 == 2) {
            return numberFormatter.format(this.modelArray[1][n3]);
        }
        if (this.hi.isHav()) {
            return this.hi.getNameTable((int)this.addressList[n3]);
        }
        return this.hi.getNameTable(n3);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer tableCellRenderer = this.tableHeader.getDefaultRenderer();
            if (tableCellRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)tableCellRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void sortColumn(int n, boolean bl) {
        if (n == this.sortedColumn) {
            this.direction = !bl;
            this.fireTableDataChanged();
            return;
        }
        if (n > 3) {
            return;
        }
        SortThreadTypes sortThreadTypes = new SortThreadTypes(this, n);
        sortThreadTypes.start();
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalTextPosition(2);
                int n3 = jTable.convertColumnIndexToModel(n2);
                jLabel.setIcon(TypeTableModel.this.getHeaderIcon(n3, jLabel.getFont().getSize()));
            }
            return component;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                TypeTableModel.this.sortColumn(n2, TypeTableModel.this.direction);
                if (TypeTableModel.this.tableHeader != null) {
                    TypeTableModel.this.tableHeader.repaint();
                }
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            TypeTableModel.this.fireTableDataChanged();
        }
    }
}

