/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.CompareCell;
import com.ibm.jinwoo.thread.CompareTableCellRenderer;
import com.ibm.jinwoo.thread.CompareTableModel;
import com.ibm.jinwoo.thread.Configuration;
import com.ibm.jinwoo.thread.MonitorDump;
import com.ibm.jinwoo.thread.ThreadDump;
import com.ibm.jinwoo.thread.ThreadFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLDocument;

public class CompareFrame
extends JInternalFrame
implements ListSelectionListener {
    private int dividerLocation = 100;
    private JScrollPane ivjCompareScrollPane = null;
    private JSplitPane ivjCompareSplitPane = null;
    private JTable ivjCompareTable = null;
    private ThreadDump[] threadDumps = null;
    private CompareTableModel tt = null;
    private String compareSummary = "";
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    public String summary = null;
    public Configuration cfg;
    private JList ivjBlockList = null;
    private JLabel ivjJLabelBlocking = null;
    private JLabel ivjJLabelWaiting = null;
    private JPanel ivjJPanel1 = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JSplitPane ivjJSplitPane1 = null;
    private JScrollPane ivjListScrollPane = null;
    private JScrollPane ivjStackScrollPane = null;
    private JTextPane ivjStackTextPane = null;
    private JList ivjThreadList = null;

    public CompareFrame() {
        this.initialize();
    }

    public CompareFrame(ThreadDump[] td) {
        this.threadDumps = td;
        this.initialize();
    }

    public CompareFrame(ThreadDump[] td, Configuration c) {
        this.threadDumps = td;
        this.cfg = c;
        this.initialize();
    }

    public CompareFrame(String title) {
        super(title);
        this.initialize();
    }

    public CompareFrame(String title, ThreadDump[] td, Configuration c) {
        super(title);
        this.threadDumps = td;
        this.cfg = c;
        this.initialize();
    }

    public CompareFrame(String title, boolean resizable) {
        super(title, resizable);
        this.initialize();
    }

    public CompareFrame(String title, boolean resizable, boolean closable) {
        super(title, resizable, closable);
        this.initialize();
    }

    public CompareFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        super(title, resizable, closable, maximizable);
        this.initialize();
    }

    public CompareFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.initialize();
    }

    public void blockList_MouseClicked(MouseEvent mouseEvent) {
    }

    public void compareTable_KeyReleased(KeyEvent keyEvent) {
        this.compareTable_MouseReleased(null);
    }

    public void compareTable_MouseReleased(MouseEvent mouseEvent) {
        int selectedRow = this.getCompareTable().getSelectedRow();
        int selectedColumn = this.getCompareTable().getSelectedColumn();
        if (selectedColumn == -1) {
            this.getStackTextPane().setText(this.compareSummary);
            this.getStackTextPane().setCaretPosition(0);
            return;
        }
        if (this.tt.direction) {
            selectedRow = this.tt.threadNames.length - selectedRow - 1;
        }
        if (this.tt.sortedColumn == 0) {
            selectedRow = this.tt.sortedNames[selectedRow];
            if (selectedColumn == 0) {
                this.getStackTextPane().setText(this.tt.threadNames[selectedRow]);
            } else {
                int i;
                Long tid = (Long)this.tt.tidHash.get(new Integer(selectedRow));
                if (!this.tt.hi[selectedColumn - 1].threadHash.containsKey(tid)) {
                    this.getStackTextPane().setText("The thread does not exist in this thread dump");
                    return;
                }
                int idx = (Integer)this.tt.hi[selectedColumn - 1].threadHash.get(tid);
                String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].getName(idx) + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(idx);
                String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitors(idx);
                String monString = "";
                if (m1 != null) {
                    monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                }
                if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitors(idx)) != null) {
                    monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
                }
                stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                stackTrace = this.tt.hi[selectedColumn - 1].javaStack[idx] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[idx] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
                stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[idx] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[idx] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
                this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                this.getStackTextPane().setCaretPosition(0);
                DefaultListModel<Object> listModel = new DefaultListModel<Object>();
                this.getThreadList().setModel(listModel);
                DefaultListModel<Object> listModel2 = new DefaultListModel<Object>();
                this.getBlockList().setModel(listModel2);
                MonitorDump[] md = this.tt.hi[selectedColumn - 1].mdump;
                ArrayList waitingThreads = null;
                int i2 = 0;
                while (i2 < md.length) {
                    if (this.tt.hi[selectedColumn - 1].sys_thread[idx] == md[i2].owner) {
                        if (waitingThreads == null) {
                            waitingThreads = new ArrayList(md[i2].waiting);
                        } else {
                            waitingThreads.addAll(md[i2].waiting);
                        }
                    }
                    ++i2;
                }
                this.setJLabelWaiting(0);
                if (waitingThreads != null) {
                    if (this.getJSplitPane1().getDividerLocation() != 1) {
                        this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                    }
                    if (this.dividerLocation == 0) {
                        this.dividerLocation = 100;
                    }
                    this.getJSplitPane1().setDividerLocation(this.dividerLocation);
                    ArrayList<String> nameList = new ArrayList<String>();
                    int i3 = 0;
                    while (i3 < waitingThreads.size()) {
                        int j = 0;
                        while (j < this.tt.hi[selectedColumn - 1].sys_thread.length) {
                            if ((Long)waitingThreads.get(i3) == this.tt.hi[selectedColumn - 1].sys_thread[j] && !nameList.contains(this.tt.hi[selectedColumn - 1].name[j])) {
                                nameList.add(this.tt.hi[selectedColumn - 1].name[j]);
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    if (nameList.size() != 0) {
                        Object[] sortedName = nameList.toArray(new String[nameList.size()]);
                        Arrays.sort(sortedName, 0, sortedName.length);
                        i = 0;
                        while (i < sortedName.length) {
                            listModel.addElement(sortedName[i]);
                            ++i;
                        }
                        this.setJLabelWaiting(listModel.getSize());
                        nameList = null;
                    }
                }
                MonitorDump[] mdump = md;
                ArrayList<String> blockList = new ArrayList<String>();
                i = 0;
                while (i < mdump.length) {
                    if (mdump[i] != null && mdump[i].waiting != null && mdump[i].waiting.size() != 0 && mdump[i].owner != -1L) {
                        int j = 0;
                        while (j < mdump[i].waiting.size()) {
                            if ((Long)mdump[i].waiting.get(j) == this.tt.hi[selectedColumn - 1].sys_thread[idx] && !blockList.contains(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)])) {
                                blockList.add(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.setJLabelBlocking(0);
                if (blockList.size() != 0) {
                    if (this.getJSplitPane1().getDividerLocation() != 1) {
                        this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                    }
                    if (this.dividerLocation == 0) {
                        this.dividerLocation = 100;
                    }
                    this.getJSplitPane1().setDividerLocation(this.dividerLocation);
                    Object[] sortedName = blockList.toArray(new String[blockList.size()]);
                    Arrays.sort(sortedName, 0, sortedName.length);
                    int i4 = 0;
                    while (i4 < sortedName.length) {
                        listModel2.addElement(sortedName[i4]);
                        ++i4;
                    }
                    this.setJLabelBlocking(listModel2.getSize());
                    blockList = null;
                } else if (waitingThreads == null) {
                    if (this.getJSplitPane1().getDividerLocation() != 1) {
                        this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                    }
                    this.getJSplitPane1().setDividerLocation(1);
                }
            }
        } else if (selectedColumn == 0) {
            selectedRow = this.tt.sortedMethod[this.tt.sortedColumn - 1][selectedRow];
            this.getStackTextPane().setText(this.tt.threadNames[selectedRow]);
        } else {
            int i;
            Long tid = (Long)this.tt.tidHash.get(new Integer(selectedRow = this.tt.sortedMethod[this.tt.sortedColumn - 1][selectedRow]));
            if (!this.tt.hi[selectedColumn - 1].threadHash.containsKey(tid)) {
                this.getStackTextPane().setText("The thread does not exist in this thread dump");
                return;
            }
            int idx = (Integer)this.tt.hi[selectedColumn - 1].threadHash.get(tid);
            String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].getName(idx) + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(idx);
            String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitors(idx);
            String monString = "";
            if (m1 != null) {
                monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
            }
            if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitors(idx)) != null) {
                monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
            }
            stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
            stackTrace = this.tt.hi[selectedColumn - 1].javaStack[idx] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[idx] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
            stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[idx] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[idx] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
            this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
            this.getStackTextPane().setCaretPosition(0);
            DefaultListModel<Object> listModel = new DefaultListModel<Object>();
            this.getThreadList().setModel(listModel);
            DefaultListModel<Object> listModel2 = new DefaultListModel<Object>();
            this.getBlockList().setModel(listModel2);
            MonitorDump[] md = this.tt.hi[selectedColumn - 1].mdump;
            List waitingThreads = null;
            int i5 = 0;
            while (i5 < md.length) {
                if (this.tt.hi[selectedColumn - 1].sys_thread[idx] == md[i5].owner) {
                    if (waitingThreads == null) {
                        waitingThreads = md[i5].waiting;
                    } else {
                        waitingThreads.addAll(md[i5].waiting);
                    }
                }
                ++i5;
            }
            this.setJLabelWaiting(0);
            if (waitingThreads != null) {
                if (this.getJSplitPane1().getDividerLocation() != 1) {
                    this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                }
                if (this.dividerLocation == 0) {
                    this.dividerLocation = 100;
                }
                this.getJSplitPane1().setDividerLocation(this.dividerLocation);
                ArrayList<String> nameList = new ArrayList<String>();
                int i6 = 0;
                while (i6 < waitingThreads.size()) {
                    int j = 0;
                    while (j < this.tt.hi[selectedColumn - 1].sys_thread.length) {
                        if ((Long)waitingThreads.get(i6) == this.tt.hi[selectedColumn - 1].sys_thread[j] && !nameList.contains(this.tt.hi[selectedColumn - 1].name[j])) {
                            nameList.add(this.tt.hi[selectedColumn - 1].name[j]);
                        }
                        ++j;
                    }
                    ++i6;
                }
                if (nameList.size() != 0) {
                    Object[] sortedName = nameList.toArray(new String[nameList.size()]);
                    Arrays.sort(sortedName, 0, sortedName.length);
                    i = 0;
                    while (i < sortedName.length) {
                        listModel.addElement(sortedName[i]);
                        ++i;
                    }
                    this.setJLabelWaiting(listModel.getSize());
                    nameList = null;
                }
            }
            MonitorDump[] mdump = md;
            ArrayList<String> blockList = new ArrayList<String>();
            i = 0;
            while (i < mdump.length) {
                if (mdump[i] != null && mdump[i].waiting != null && mdump[i].waiting.size() != 0 && mdump[i].owner != -1L) {
                    int j = 0;
                    while (j < mdump[i].waiting.size()) {
                        if ((Long)mdump[i].waiting.get(j) == this.tt.hi[selectedColumn - 1].sys_thread[idx] && !blockList.contains(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)])) {
                            blockList.add(this.tt.hi[selectedColumn - 1].name[this.tt.hi[selectedColumn - 1].getIndexFromSysThread(mdump[i].owner)]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.setJLabelBlocking(0);
            if (blockList.size() != 0) {
                if (this.getJSplitPane1().getDividerLocation() != 1) {
                    this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                }
                if (this.dividerLocation == 0) {
                    this.dividerLocation = 100;
                }
                this.getJSplitPane1().setDividerLocation(this.dividerLocation);
                Object[] sortedName = blockList.toArray(new String[blockList.size()]);
                Arrays.sort(sortedName, 0, sortedName.length);
                int i7 = 0;
                while (i7 < sortedName.length) {
                    listModel2.addElement(sortedName[i7]);
                    ++i7;
                }
                this.setJLabelBlocking(listModel2.getSize());
                blockList = null;
            } else if (waitingThreads == null) {
                if (this.getJSplitPane1().getDividerLocation() != 1) {
                    this.dividerLocation = this.getJSplitPane1().getDividerLocation();
                }
                this.getJSplitPane1().setDividerLocation(1);
            }
        }
    }

    private void connEtoC1(MouseEvent arg1) {
        try {
            this.compareTable_MouseReleased(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.compareTable_KeyReleased(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(MouseEvent arg1) {
        try {
            this.threadList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(MouseEvent arg1) {
        try {
            this.blockList_MouseClicked(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JList getBlockList() {
        if (this.ivjBlockList == null) {
            try {
                this.ivjBlockList = new JList();
                this.ivjBlockList.setName("BlockList");
                this.ivjBlockList.setBounds(0, 0, 160, 120);
                this.ivjBlockList.addListSelectionListener(this);
                this.ivjBlockList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBlockList;
    }

    private JScrollPane getCompareScrollPane() {
        if (this.ivjCompareScrollPane == null) {
            try {
                this.ivjCompareScrollPane = new JScrollPane();
                this.ivjCompareScrollPane.setName("CompareScrollPane");
                this.ivjCompareScrollPane.setVerticalScrollBarPolicy(22);
                this.ivjCompareScrollPane.setHorizontalScrollBarPolicy(32);
                this.getCompareScrollPane().setViewportView(this.getCompareTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareScrollPane;
    }

    private JSplitPane getCompareSplitPane() {
        if (this.ivjCompareSplitPane == null) {
            try {
                this.ivjCompareSplitPane = new JSplitPane(1);
                this.ivjCompareSplitPane.setName("CompareSplitPane");
                this.ivjCompareSplitPane.setDividerLocation(300);
                this.ivjCompareSplitPane.setOneTouchExpandable(true);
                this.ivjCompareSplitPane.setContinuousLayout(false);
                this.getCompareSplitPane().add((Component)this.getCompareScrollPane(), "left");
                this.getCompareSplitPane().add((Component)this.getJSplitPane1(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareSplitPane;
    }

    private JTable getCompareTable() {
        if (this.ivjCompareTable == null) {
            try {
                long endTime;
                long startTime;
                this.ivjCompareTable = new JTable();
                this.ivjCompareTable.setName("CompareTable");
                this.getCompareScrollPane().setColumnHeaderView(this.ivjCompareTable.getTableHeader());
                this.getCompareScrollPane().getViewport().setBackingStoreEnabled(true);
                this.ivjCompareTable.setCellSelectionEnabled(true);
                this.ivjCompareTable.setBounds(0, 0, 200, 200);
                if (this.threadDumps[0].pid != -1L) {
                    this.compareSummary = !this.isSamePID(this.threadDumps) ? "<UL><B>Thread Comparison Analysis</B><BR><BR><LI>WARNING!! Thread dumps are taken from different processes.<BR>Further analysis is not meaningful<BR><BR>" : "<UL><B>Thread Comparison Analysis</B><BR><BR><LI>Process ID : " + this.threadDumps[0].pid + "<BR><BR>";
                }
                if ((startTime = (endTime = this.threadDumps[0].timeStamp)) != -1L) {
                    long endAF;
                    long endGC;
                    long startGC = endGC = this.threadDumps[0].gc;
                    long startAF = endAF = this.threadDumps[0].af;
                    int i = 0;
                    while (i < this.threadDumps.length) {
                        if (startTime > this.threadDumps[i].timeStamp) {
                            startTime = this.threadDumps[i].timeStamp;
                            startGC = this.threadDumps[i].gc;
                            startAF = this.threadDumps[i].af;
                        }
                        if (endTime < this.threadDumps[i].timeStamp) {
                            endTime = this.threadDumps[i].timeStamp;
                            endGC = this.threadDumps[i].gc;
                            endAF = this.threadDumps[i].af;
                        }
                        ++i;
                    }
                    float min = (float)(endTime - startTime) / 60000.0f;
                    this.compareSummary = String.valueOf(this.compareSummary) + "<LI>First Dump : " + new Date(startTime) + "<BR><BR><LI>Last Dump : " + new Date(endTime) + "<BR><BR>";
                    if (startGC != -1L) {
                        if (min != 0.0f) {
                            this.compareSummary = this.threadDumps[0].isJ9 ? String.valueOf(this.compareSummary) + "<LI>Global Collections per Minute : " + (float)(endGC - startGC) / min + "<BR><BR><LI>Scavenge Collections per Minute : " + (float)(endAF - startAF) / min + "<BR><BR>" : String.valueOf(this.compareSummary) + "<LI>Garbage Collections per Minute : " + (float)(endGC - startGC) / min + "<BR><BR><LI>Allocation Failures per Minute : " + (float)(endAF - startAF) / min + "<BR><BR>";
                        }
                        long t = (endTime - startTime) / 1000L;
                        long s = t % 60L;
                        long m = t / 60L % 60L;
                        long h = t / 60L / 60L % 24L;
                        long d = t / 60L / 60L / 24L;
                        if (t != 0L && s + m + h + d != 0L) {
                            this.compareSummary = String.valueOf(this.compareSummary) + "<LI>Elapsed Time : " + (d == 0L ? "" : String.valueOf(d) + " Day(s) ") + (h == 0L ? "" : String.valueOf(h) + " Hour(s) ") + (m == 0L ? "" : String.valueOf(m) + " Minute(s) ") + (s == 0L ? "" : String.valueOf(s) + " Second(s)") + "<BR><BR>";
                        }
                    }
                }
                this.ivjCompareTable.setDragEnabled(true);
                this.ivjCompareTable.setDefaultRenderer(CompareCell.class, new CompareTableCellRenderer(this.cfg));
                this.tt = new CompareTableModel(this.threadDumps);
                this.compareSummary = String.valueOf(this.compareSummary) + this.hangSummary(this.tt);
                this.ivjCompareTable.setModel(this.tt);
                this.tt.setTableHeader(this.ivjCompareTable.getTableHeader());
                this.getCompareScrollPane().setViewportView(this.ivjCompareTable);
                this.getStackTextPane().setText(this.compareSummary);
                this.getStackTextPane().setCaretPosition(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareTable;
    }

    public String getHTMLColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        String R = r <= 15 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String G = g <= 15 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String B = b <= 15 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        return String.valueOf(R) + G + B;
    }

    private JLabel getJLabelBlocking() {
        if (this.ivjJLabelBlocking == null) {
            try {
                this.ivjJLabelBlocking = new JLabel();
                this.ivjJLabelBlocking.setName("JLabelBlocking");
                this.ivjJLabelBlocking.setText("Blocked by : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelBlocking;
    }

    private JLabel getJLabelWaiting() {
        if (this.ivjJLabelWaiting == null) {
            try {
                this.ivjJLabelWaiting = new JLabel();
                this.ivjJLabelWaiting.setName("JLabelWaiting");
                this.ivjJLabelWaiting.setText("Waiting Threads : 0");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelWaiting;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabelWaiting = new GridBagConstraints();
                constraintsJLabelWaiting.gridx = 1;
                constraintsJLabelWaiting.gridy = 1;
                constraintsJLabelWaiting.insets = new Insets(7, 3, 3, 2);
                this.getJPanel1().add((Component)this.getJLabelWaiting(), constraintsJLabelWaiting);
                GridBagConstraints constraintsListScrollPane = new GridBagConstraints();
                constraintsListScrollPane.gridx = 1;
                constraintsListScrollPane.gridy = 2;
                constraintsListScrollPane.fill = 1;
                constraintsListScrollPane.weightx = 1.0;
                constraintsListScrollPane.weighty = 1.0;
                constraintsListScrollPane.ipadx = 76;
                constraintsListScrollPane.ipady = 280;
                constraintsListScrollPane.insets = new Insets(3, 0, 4, 0);
                this.getJPanel1().add((Component)this.getListScrollPane(), constraintsListScrollPane);
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 1;
                constraintsJScrollPane1.gridy = 4;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.ipadx = 76;
                constraintsJScrollPane1.ipady = 137;
                constraintsJScrollPane1.insets = new Insets(3, 0, 9, 0);
                this.getJPanel1().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
                GridBagConstraints constraintsJLabelBlocking = new GridBagConstraints();
                constraintsJLabelBlocking.gridx = 1;
                constraintsJLabelBlocking.gridy = 3;
                constraintsJLabelBlocking.ipadx = 15;
                constraintsJLabelBlocking.insets = new Insets(4, 8, 2, 13);
                this.getJPanel1().add((Component)this.getJLabelBlocking(), constraintsJLabelBlocking);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getBlockList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSplitPane getJSplitPane1() {
        if (this.ivjJSplitPane1 == null) {
            try {
                this.ivjJSplitPane1 = new JSplitPane(1);
                this.ivjJSplitPane1.setName("JSplitPane1");
                this.ivjJSplitPane1.setOneTouchExpandable(true);
                this.ivjJSplitPane1.setDividerLocation(150);
                this.getJSplitPane1().add((Component)this.getJPanel1(), "left");
                this.getJSplitPane1().add((Component)this.getStackScrollPane(), "right");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSplitPane1;
    }

    private JScrollPane getListScrollPane() {
        if (this.ivjListScrollPane == null) {
            try {
                this.ivjListScrollPane = new JScrollPane();
                this.ivjListScrollPane.setName("ListScrollPane");
                this.getListScrollPane().setViewportView(this.getThreadList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjListScrollPane;
    }

    private JScrollPane getStackScrollPane() {
        if (this.ivjStackScrollPane == null) {
            try {
                this.ivjStackScrollPane = new JScrollPane();
                this.ivjStackScrollPane.setName("StackScrollPane");
                this.getStackScrollPane().setViewportView(this.getStackTextPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStackScrollPane;
    }

    private JTextPane getStackTextPane() {
        if (this.ivjStackTextPane == null) {
            try {
                this.ivjStackTextPane = new JTextPane();
                this.ivjStackTextPane.setName("StackTextPane");
                this.ivjStackTextPane.setDocument(new HTMLDocument());
                this.ivjStackTextPane.setBounds(0, 0, 535, 527);
                this.ivjStackTextPane.setEditable(false);
                this.ivjStackTextPane.setContentType("text/html");
                this.ivjStackTextPane.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStackTextPane;
    }

    private JList getThreadList() {
        if (this.ivjThreadList == null) {
            try {
                this.ivjThreadList = new JList();
                this.ivjThreadList.setName("ThreadList");
                this.ivjThreadList.setBounds(0, 0, 160, 120);
                this.ivjThreadList.addListSelectionListener(this);
                this.ivjThreadList.setDragEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjThreadList;
    }

    private void handleException(Throwable exception) {
    }

    private String hangSummary(CompareTableModel cTableModel) {
        String summary;
        block17: {
            summary = "";
            List<String> threadNameList = Collections.synchronizedList(new ArrayList());
            if (cTableModel == null || cTableModel.hi == null || cTableModel.hi.length == 1) break block17;
            long numberOfHung = 0L;
            ThreadDump[] hi = cTableModel.hi;
            String[] threads = new String[cTableModel.tidHash.size()];
            boolean[] isMoving = new boolean[cTableModel.tidHash.size()];
            int i = 0;
            while (i < cTableModel.tidHash.size()) {
                block20: {
                    Integer idx;
                    Long tid;
                    block19: {
                        block18: {
                            tid = (Long)cTableModel.tidHash.get(new Integer(i));
                            idx = (Integer)hi[0].threadHash.get(tid);
                            if (idx == null) break block18;
                            threads[i] = hi[0].javaStack[idx];
                            if (threads[i] != null) break block19;
                            isMoving[i] = true;
                            break block20;
                        }
                        isMoving[i] = true;
                        break block20;
                    }
                    int j = 1;
                    while (j < hi.length) {
                        idx = (Integer)hi[j].threadHash.get(tid);
                        if (idx != null) {
                            if (hi[j].javaStack[idx] == null || threads[i].compareTo(hi[j].javaStack[idx]) != 0) {
                                isMoving[i] = true;
                                break;
                            }
                        } else {
                            isMoving[i] = true;
                            break;
                        }
                        ++j;
                    }
                    idx = (Integer)hi[0].threadHash.get(tid);
                    if (!isMoving[i] && idx != null && hi[0].macro[idx] != 1) {
                        threadNameList.add(hi[0].name[idx]);
                    }
                }
                ++i;
            }
            if (threadNameList.size() != 0) {
                Object[] nameString = threadNameList.toArray(new String[threadNameList.size()]);
                Arrays.sort(nameString);
                summary = "<LI>Number of hang suspects : " + nameString.length + "<BR><BR><LI>List of hang suspects<BR><BR><table border=\"1\"><tr><th>Thread Name</th><th>State</th><th>Method</th></tr>";
                int index = -1;
                String htmlColor = null;
                String imageName = null;
                int i2 = 0;
                while (i2 < nameString.length) {
                    index = hi[0].getIndexFromName((String)nameString[i2]);
                    switch (hi[0].state[index]) {
                        case 0: {
                            htmlColor = this.getHTMLColor(this.cfg.runnable);
                            imageName = "/run.gif";
                            break;
                        }
                        case 1: {
                            htmlColor = this.getHTMLColor(this.cfg.condition);
                            imageName = "/condition.gif";
                            break;
                        }
                        case 2: {
                            htmlColor = this.getHTMLColor(this.cfg.monitor);
                            imageName = "/monitor_wait.gif";
                            break;
                        }
                        case 3: {
                            htmlColor = this.getHTMLColor(this.cfg.suspended);
                            imageName = "/suspend.gif";
                            break;
                        }
                        case 4: {
                            htmlColor = this.getHTMLColor(this.cfg.object);
                            imageName = "/waiting.gif";
                            break;
                        }
                        case 5: {
                            htmlColor = this.getHTMLColor(this.cfg.blocked);
                            imageName = "/block.gif";
                        }
                    }
                    if (hi[0].isDeadlock[index]) {
                        htmlColor = this.getHTMLColor(this.cfg.deadlock);
                        imageName = "/deadlock_view.gif";
                    }
                    summary = String.valueOf(summary) + "<tr><td>" + (String)nameString[i2] + "</td><td bgcolor=\"#" + htmlColor + "\"><img src=\"" + this.getClass().getResource(imageName) + "\"> " + hi[0].getState(index) + "</td><td>" + hi[0].getCurrentMethod(index) + "</td></tr>";
                    ++i2;
                }
                summary = String.valueOf(summary) + "</table>";
            }
        }
        return summary;
    }

    private void initConnections() throws Exception {
        this.getCompareTable().addMouseListener(this.ivjEventHandler);
        this.getCompareTable().addKeyListener(this.ivjEventHandler);
        this.getThreadList().addMouseListener(this.ivjEventHandler);
        this.getBlockList().addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("CompareFrame");
            this.setIconifiable(true);
            this.setClosable(true);
            this.setVisible(true);
            this.setFrameIcon(new ImageIcon(this.getClass().getResource("/thread_comp.gif")));
            this.setSize(923, 688);
            this.setMaximizable(true);
            this.setResizable(true);
            this.setContentPane(this.getCompareSplitPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private boolean isSamePID(ThreadDump[] td) {
        long pid = td[0].pid;
        int i = 1;
        while (i < td.length) {
            if (pid != td[i].pid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            CompareFrame aCompareFrame = new CompareFrame();
            frame.setContentPane(aCompareFrame);
            frame.setSize(aCompareFrame.getSize());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JInternalFrame");
            exception.printStackTrace(System.out);
        }
    }

    private void setJLabelBlocking(int n) {
        this.ivjJLabelBlocking.setText("Blocked by : " + n);
    }

    private void setJLabelWaiting(int n) {
        this.ivjJLabelWaiting.setText("Waiting Threads : " + n);
    }

    public void threadList_MouseClicked(MouseEvent mouseEvent) {
        int selectedRow = -1;
        if (this.getThreadList().getSelectedIndex() != -1) {
            selectedRow = -1;
            int selectedColumn = this.getCompareTable().getSelectedColumn();
            int i = 0;
            while (i < this.tt.hi[selectedColumn - 1].name.length) {
                if (this.tt.hi[selectedColumn - 1].name[i].compareTo((String)this.getThreadList().getSelectedValue()) == 0) {
                    selectedRow = i;
                    break;
                }
                ++i;
            }
            if (selectedRow == -1) {
                return;
            }
            String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].getName(selectedRow) + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(selectedRow);
            String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitors(selectedRow);
            String monString = "";
            if (m1 != null) {
                monString = "Owns Monitor Lock on " + m1;
            }
            if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitors(selectedRow)) != null) {
                monString = monString.length() == 0 ? String.valueOf(monString) + "Waiting for Monitor Lock on " + m1 : String.valueOf(monString) + "<BR>Waiting for Monitor Lock on " + m1;
            }
            stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
            stackTrace = this.tt.hi[selectedColumn - 1].javaStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>";
            stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[selectedRow] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[selectedRow] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td>No Native stack trace available</td></tr>";
            if (stackTrace.length() == 0) {
                stackTrace = "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
            }
            this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
            this.getStackTextPane().setCaretPosition(0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list;
        if (!e.getValueIsAdjusting() && (list = (JList)e.getSource()).getSelectedIndex() != -1) {
            int selectedColumn = this.getCompareTable().getSelectedColumn();
            int i = 0;
            while (i < this.tt.hi[selectedColumn - 1].name.length) {
                if (this.tt.hi[selectedColumn - 1].name[i].compareTo((String)list.getSelectedValue()) == 0) {
                    String stackTrace = "<table border=\"1\"><tr><th><B>Thread Name</B></th><th>" + this.tt.hi[selectedColumn - 1].name[i] + "<tr><td><B>State</B></td><td>" + this.tt.hi[selectedColumn - 1].getState(i);
                    String monString = "";
                    String m1 = this.tt.hi[selectedColumn - 1].getOwningMonitor(i);
                    if (m1 != null) {
                        monString = String.valueOf(monString) + "Owns Monitor Lock on " + m1;
                    }
                    if ((m1 = this.tt.hi[selectedColumn - 1].getWaitingMonitor(i)) != null) {
                        if (monString.length() != 0) {
                            monString = String.valueOf(monString) + "<BR>";
                        }
                        monString = String.valueOf(monString) + "Waiting for Monitor Lock on " + m1;
                    }
                    stackTrace = monString.length() == 0 ? String.valueOf(stackTrace) + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Monitor</B></td><td>" + monString + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].javaStack[i] == null ? String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td>No Java stack trace available</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Java Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].javaStack[i] + "</td></tr>";
                    stackTrace = this.tt.hi[selectedColumn - 1].nativeStack[i] != null ? String.valueOf(stackTrace) + "<tr><td><B>Native Stack</B></td><td>" + this.tt.hi[selectedColumn - 1].nativeStack[i] + "</td></tr>" : String.valueOf(stackTrace) + "<tr><td><B>Stack Trace</B></td>No stack trace available</td></tr>";
                    this.getStackTextPane().setText(ThreadFrame.getCopyFriendlyString(stackTrace));
                    this.getStackTextPane().setCaretPosition(0);
                }
                ++i;
            }
        }
    }

    class IvjEventHandler
    implements KeyListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == CompareFrame.this.getCompareTable()) {
                CompareFrame.this.connEtoC2(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == CompareFrame.this.getCompareTable()) {
                CompareFrame.this.connEtoC1(e);
            }
            if (e.getSource() == CompareFrame.this.getThreadList()) {
                CompareFrame.this.connEtoC3(e);
            }
            if (e.getSource() == CompareFrame.this.getBlockList()) {
                CompareFrame.this.connEtoC4(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

