/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import com.ibm.jinwoo.thread.Arrays2;
import com.ibm.jinwoo.thread.CompareCell;
import com.ibm.jinwoo.thread.SortableHeaderIcon;
import com.ibm.jinwoo.thread.ThreadDump;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CompareTableModel
extends AbstractTableModel {
    static SimpleDateFormat dateFormatter2 = new SimpleDateFormat("MMM d HH:mm:ss yyyy");
    public static final boolean DESCENDING = true;
    public static final boolean ASCENDING = false;
    public boolean direction = false;
    String[] columnNames = null;
    public String[] threadNames = null;
    public int[] sortedNames;
    ThreadDump[] hi;
    Hashtable tidHash = new Hashtable();
    int sortedColumn = 0;
    int tidCounter = 0;
    public JTableHeader tableHeader;
    public long[][] sortedArrary;
    public int[][] sortedMethod;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public CompareTableModel() {
    }

    public CompareTableModel(ThreadDump[] h) {
        int j;
        this.hi = h;
        this.sortedColumn = 0;
        this.columnNames = new String[h.length + 1];
        this.columnNames[0] = "Thread";
        Long newTid = null;
        int i = 0;
        while (i < h.length) {
            this.columnNames[i + 1] = h[i].timeStamp != 0L ? String.valueOf(h[i].fileName) + " [" + dateFormatter2.format(new Date(h[i].timeStamp)) + "]" : h[i].fileName;
            h[i].threadHash = new Hashtable();
            int j2 = 0;
            while (j2 < h[i].tid.length) {
                newTid = new Long(h[i].tid[j2]);
                h[i].threadHash.put(newTid, new Integer(j2));
                if (!this.tidHash.contains(newTid)) {
                    this.tidHash.put(new Integer(this.tidCounter++), newTid);
                }
                ++j2;
            }
            ++i;
        }
        this.threadNames = new String[this.tidCounter];
        this.sortedNames = new int[this.tidCounter];
        this.tidCounter = 0;
        HashMap<String, Integer> nameHash = new HashMap<String, Integer>();
        int i2 = 0;
        while (i2 < this.tidHash.size()) {
            Long tid = (Long)this.tidHash.get(new Integer(i2));
            boolean first = true;
            j = 0;
            while (j < this.hi.length) {
                Integer idx = (Integer)this.hi[j].threadHash.get(tid);
                if (idx != null) {
                    if (first) {
                        first = false;
                        nameHash.clear();
                        nameHash.put(this.hi[j].name[idx], 0);
                        this.threadNames[this.tidCounter++] = this.hi[j].name[idx];
                    } else if (!nameHash.containsKey(this.hi[j].name[idx])) {
                        nameHash.put(this.hi[j].name[idx], 0);
                        this.threadNames[this.tidCounter - 1] = String.valueOf(this.threadNames[this.tidCounter - 1]) + " => " + this.hi[j].name[idx];
                    }
                }
                ++j;
            }
            ++i2;
        }
        String[] tempNames = new String[this.tidCounter];
        int i3 = 0;
        while (i3 < this.threadNames.length) {
            tempNames[i3] = this.threadNames[i3];
            this.sortedNames[i3] = i3;
            ++i3;
        }
        Arrays2.sort(tempNames, this.sortedNames);
        this.sortedMethod = new int[h.length][this.threadNames.length];
        String[] tempString = new String[this.threadNames.length];
        j = 0;
        while (j < h.length) {
            int i4 = 0;
            while (i4 < this.tidHash.size()) {
                Long tid = (Long)this.tidHash.get(new Integer(i4));
                Integer idx = (Integer)this.hi[j].threadHash.get(tid);
                this.sortedMethod[j][i4] = i4;
                tempString[i4] = idx != null ? this.hi[j].getCurrentMethod(idx) : "";
                ++i4;
            }
            Arrays2.sort(tempString, this.sortedMethod[j]);
            ++j;
        }
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public CompareTableModel(ThreadDump[] h, int col) {
        this.hi = h;
        this.sortedColumn = col;
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return String.class;
        }
        return CompareCell.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Icon getHeaderIcon(int column, int size) {
        if (column != this.sortedColumn) {
            return null;
        }
        return new SortableHeaderIcon(this.direction, size);
    }

    @Override
    public int getRowCount() {
        return this.tidHash.size();
    }

    public String getStack(int x, int y) {
        Long tid = (Long)this.tidHash.get(new Integer(x = this.sortedNames[x]));
        if (!this.hi[y].threadHash.containsKey(tid)) {
            return "The thread does not exist in this thread dump";
        }
        int idx = (Integer)this.hi[y].threadHash.get(tid);
        String stackTrace = "Thread Name : " + this.hi[y].getName(idx) + "<BR>State : " + this.hi[y].getState(idx) + "<BR>";
        String m1 = this.hi[y].getOwningMonitors(idx);
        if (m1 != null) {
            stackTrace = String.valueOf(stackTrace) + "Owns Monitor Lock on " + m1 + "<BR>";
        }
        if ((m1 = this.hi[y].getWaitingMonitors(idx)) != null) {
            stackTrace = String.valueOf(stackTrace) + "Waiting for Monitor Lock on " + m1 + "<BR>";
        }
        stackTrace = this.hi[y].javaStack[idx] != null ? String.valueOf(stackTrace) + "Java Stack<BR>" + this.hi[y].javaStack[idx] : String.valueOf(stackTrace) + "No Java stack trace available";
        if (this.hi[y].nativeStack[idx] != null) {
            stackTrace = String.valueOf(stackTrace) + "<BR>Native Stack<BR>" + this.hi[y].nativeStack[idx];
        }
        return stackTrace;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.direction) {
            row = this.threadNames.length - row - 1;
        }
        Long tid = (Long)this.tidHash.get(new Integer(row));
        if (this.sortedColumn == 0) {
            if (col == 0) {
                return this.threadNames[this.sortedNames[row]];
            }
            tid = (Long)this.tidHash.get(new Integer(this.sortedNames[row]));
            if (!this.hi[col - 1].threadHash.containsKey(tid)) {
                return null;
            }
            int idx = (Integer)this.hi[col - 1].threadHash.get(tid);
            return new CompareCell(this.hi, col - 1, idx, tid);
        }
        if (col == 0) {
            return this.threadNames[this.sortedMethod[this.sortedColumn - 1][row]];
        }
        tid = (Long)this.tidHash.get(new Integer(this.sortedMethod[this.sortedColumn - 1][row]));
        if (!this.hi[col - 1].threadHash.containsKey(tid)) {
            return null;
        }
        int idx = (Integer)this.hi[col - 1].threadHash.get(tid);
        return new CompareCell(this.hi, col - 1, idx, tid);
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void sortColumn(int column, boolean direction) {
        if (column == this.sortedColumn) {
            this.direction = !direction;
            this.fireTableDataChanged();
            return;
        }
        this.sortedColumn = column;
        direction = true;
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                CompareTableModel.this.sortColumn(column, CompareTableModel.this.direction);
                if (CompareTableModel.this.tableHeader != null) {
                    CompareTableModel.this.tableHeader.repaint();
                }
            }
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(CompareTableModel.this.getHeaderIcon(modelColumn, l.getFont().getSize()));
            }
            return c;
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            CompareTableModel.this.fireTableDataChanged();
        }
    }
}

