/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jinwoo.thread;

import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;

public class ConsolePrintStream
extends PrintStream {
    JTextArea text;

    public ConsolePrintStream(OutputStream out) {
        super(out);
    }

    public ConsolePrintStream(OutputStream out, JTextArea jt) {
        super(out);
        this.text = jt;
    }

    public ConsolePrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public ConsolePrintStream(JTextArea jt) {
        super(new PipedOutputStream());
        this.text = jt;
    }

    @Override
    public void print(char[] c) {
        if (c != null) {
            this.text.append(new String(c, 0, c.length));
        }
        this.scroll();
    }

    @Override
    public void print(char c) {
        this.text.append(String.valueOf(c));
        this.scroll();
    }

    @Override
    public void print(double d) {
        this.text.append(String.valueOf(d));
        this.scroll();
    }

    @Override
    public void print(float f) {
        this.text.append(String.valueOf(f));
        this.scroll();
    }

    @Override
    public void print(int i) {
        this.text.append(String.valueOf(i));
        this.scroll();
    }

    @Override
    public void print(Object obj) {
        if (obj != null) {
            this.text.append(obj.toString());
        } else {
            this.text.append("null");
        }
        this.scroll();
    }

    @Override
    public void print(String str) {
        if (str != null) {
            this.text.append(str);
        } else {
            this.text.append("null");
        }
        this.scroll();
    }

    @Override
    public void print(boolean b) {
        this.text.append(String.valueOf(b));
        this.scroll();
    }

    @Override
    public void println(char[] c) {
        if (c != null) {
            this.text.append(String.valueOf(new String(c, 0, c.length)) + "\n");
        }
        this.scroll();
    }

    @Override
    public void println(char c) {
        this.text.append(String.valueOf(c) + "\n");
        this.scroll();
    }

    @Override
    public void println(double d) {
        this.text.append(String.valueOf(d) + "\n");
        this.scroll();
    }

    @Override
    public void println(float f) {
        this.text.append(String.valueOf(f) + "\n");
        this.scroll();
    }

    @Override
    public void println(int i) {
        this.text.append(String.valueOf(i) + "\n");
        this.scroll();
    }

    @Override
    public void println(Object obj) {
        if (obj != null) {
            this.text.append(String.valueOf(obj.toString()) + "\n");
        } else {
            this.text.append("null\n");
        }
        this.scroll();
    }

    @Override
    public void println(String str) {
        if (str != null) {
            this.text.append(String.valueOf(str) + "\n");
        } else {
            this.text.append("null\n");
        }
        this.scroll();
    }

    @Override
    public void println(boolean b) {
        this.text.append(String.valueOf(b) + "\n");
        this.scroll();
    }

    private void scroll() {
        this.text.setCaretPosition(this.text.getDocument().getLength());
    }
}

